/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.writer;

import htsjdk.samtools.cram.encoding.DataSeries;
import htsjdk.samtools.cram.encoding.DataSeriesMap;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.encoding.writer.DataWriter;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;

public class Writer {
    private Charset charset = Charset.forName("UTF8");
    private boolean captureReadNames = false;
    @DataSeries(key=EncodingKey.BF_BitFlags, type=DataSeriesType.INT)
    public DataWriter<Integer> bitFlagsC;
    @DataSeries(key=EncodingKey.CF_CompressionBitFlags, type=DataSeriesType.BYTE)
    public DataWriter<Byte> compBitFlagsC;
    @DataSeries(key=EncodingKey.RL_ReadLength, type=DataSeriesType.INT)
    public DataWriter<Integer> readLengthC;
    @DataSeries(key=EncodingKey.AP_AlignmentPositionOffset, type=DataSeriesType.INT)
    public DataWriter<Integer> alStartC;
    @DataSeries(key=EncodingKey.RG_ReadGroup, type=DataSeriesType.INT)
    public DataWriter<Integer> readGroupC;
    @DataSeries(key=EncodingKey.RN_ReadName, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> readNameC;
    @DataSeries(key=EncodingKey.NF_RecordsToNextFragment, type=DataSeriesType.INT)
    public DataWriter<Integer> distanceC;
    @DataSeriesMap(name="TAG")
    public Map<Integer, DataWriter<byte[]>> tagValueCodecs;
    @DataSeries(key=EncodingKey.FN_NumberOfReadFeatures, type=DataSeriesType.INT)
    public DataWriter<Integer> numberOfReadFeaturesCodec;
    @DataSeries(key=EncodingKey.FP_FeaturePosition, type=DataSeriesType.INT)
    public DataWriter<Integer> featurePositionCodec;
    @DataSeries(key=EncodingKey.FC_FeatureCode, type=DataSeriesType.BYTE)
    public DataWriter<Byte> featuresCodeCodec;
    @DataSeries(key=EncodingKey.BA_Base, type=DataSeriesType.BYTE)
    public DataWriter<Byte> baseCodec;
    @DataSeries(key=EncodingKey.QS_QualityScore, type=DataSeriesType.BYTE)
    public DataWriter<Byte> qualityScoreCodec;
    @DataSeries(key=EncodingKey.QS_QualityScore, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> qualityScoreArrayCodec;
    @DataSeries(key=EncodingKey.BS_BaseSubstitutionCode, type=DataSeriesType.BYTE)
    public DataWriter<Byte> baseSubstitutionCodeCodec;
    @DataSeries(key=EncodingKey.IN_Insertion, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> insertionCodec;
    @DataSeries(key=EncodingKey.SC_SoftClip, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> softClipCodec;
    @DataSeries(key=EncodingKey.HC_HardClip, type=DataSeriesType.INT)
    public DataWriter<Integer> hardClipCodec;
    @DataSeries(key=EncodingKey.PD_padding, type=DataSeriesType.INT)
    public DataWriter<Integer> paddingCodec;
    @DataSeries(key=EncodingKey.DL_DeletionLength, type=DataSeriesType.INT)
    public DataWriter<Integer> deletionLengthCodec;
    @DataSeries(key=EncodingKey.MQ_MappingQualityScore, type=DataSeriesType.INT)
    public DataWriter<Integer> mappingQualityScoreCodec;
    @DataSeries(key=EncodingKey.MF_MateBitFlags, type=DataSeriesType.BYTE)
    public DataWriter<Byte> mateBitFlagsCodec;
    @DataSeries(key=EncodingKey.NS_NextFragmentReferenceSequenceID, type=DataSeriesType.INT)
    public DataWriter<Integer> nextFragmentReferenceSequenceIDCodec;
    @DataSeries(key=EncodingKey.NP_NextFragmentAlignmentStart, type=DataSeriesType.INT)
    public DataWriter<Integer> nextFragmentAlignmentStart;
    @DataSeries(key=EncodingKey.TS_InsetSize, type=DataSeriesType.INT)
    public DataWriter<Integer> templateSize;
    @DataSeries(key=EncodingKey.TL_TagIdList, type=DataSeriesType.INT)
    public DataWriter<Integer> tagIdListCodec;
    @DataSeries(key=EncodingKey.RI_RefId, type=DataSeriesType.INT)
    public DataWriter<Integer> refIdCodec;
    @DataSeries(key=EncodingKey.RS_RefSkip, type=DataSeriesType.INT)
    public DataWriter<Integer> refSkipCodec;
    public int refId;
    public SubstitutionMatrix substitutionMatrix;
    public boolean AP_delta = true;
    public static int detachedCount = 0;

    public void write(CramCompressionRecord r) throws IOException {
        this.bitFlagsC.writeData(r.flags);
        this.compBitFlagsC.writeData(r.getCompressionFlags());
        if (this.refId == -2) {
            this.refIdCodec.writeData(r.sequenceId);
        }
        this.readLengthC.writeData(r.readLength);
        if (this.AP_delta) {
            this.alStartC.writeData(r.alignmentDelta);
        } else {
            this.alStartC.writeData(r.alignmentStart);
        }
        this.readGroupC.writeData(r.readGroupID);
        if (this.isCaptureReadNames()) {
            this.readNameC.writeData(r.readName.getBytes(this.charset));
        }
        if (r.isDetached()) {
            this.mateBitFlagsCodec.writeData(r.getMateFlags());
            if (!this.isCaptureReadNames()) {
                this.readNameC.writeData(r.readName.getBytes(this.charset));
            }
            this.nextFragmentReferenceSequenceIDCodec.writeData(r.mateSequenceID);
            this.nextFragmentAlignmentStart.writeData(r.mateAlignmentStart);
            this.templateSize.writeData(r.templateSize);
            ++detachedCount;
        } else if (r.isHasMateDownStream()) {
            this.distanceC.writeData(r.recordsToNextFragment);
        }
        this.tagIdListCodec.writeData(r.tagIdsIndex.value);
        if (r.tags != null) {
            for (int i = 0; i < r.tags.length; ++i) {
                DataWriter<byte[]> writer = this.tagValueCodecs.get(r.tags[i].keyType3BytesAsInt);
                writer.writeData(r.tags[i].getValueAsByteArray());
            }
        }
        if (!r.isSegmentUnmapped()) {
            this.numberOfReadFeaturesCodec.writeData(r.readFeatures.size());
            int prevPos = 0;
            block16: for (ReadFeature f : r.readFeatures) {
                this.featuresCodeCodec.writeData(f.getOperator());
                switch (f.getOperator()) {
                    case 88: {
                        break;
                    }
                }
                this.featurePositionCodec.writeData(f.getPosition() - prevPos);
                prevPos = f.getPosition();
                switch (f.getOperator()) {
                    case 66: {
                        ReadBase rb = (ReadBase)f;
                        this.baseCodec.writeData(rb.getBase());
                        this.qualityScoreCodec.writeData(rb.getQualityScore());
                        continue block16;
                    }
                    case 88: {
                        Substitution sv = (Substitution)f;
                        if (sv.getCode() < 0) {
                            this.baseSubstitutionCodeCodec.writeData(this.substitutionMatrix.code(sv.getReferenceBase(), sv.getBase()));
                            continue block16;
                        }
                        this.baseSubstitutionCodeCodec.writeData(sv.getCode());
                        continue block16;
                    }
                    case 73: {
                        Insertion iv = (Insertion)f;
                        this.insertionCodec.writeData(iv.getSequence());
                        continue block16;
                    }
                    case 83: {
                        SoftClip fv = (SoftClip)f;
                        this.softClipCodec.writeData(fv.getSequence());
                        continue block16;
                    }
                    case 72: {
                        HardClip hv = (HardClip)f;
                        this.hardClipCodec.writeData(hv.getLength());
                        continue block16;
                    }
                    case 80: {
                        Padding pv = (Padding)f;
                        this.paddingCodec.writeData(pv.getLength());
                        continue block16;
                    }
                    case 68: {
                        Deletion dv = (Deletion)f;
                        this.deletionLengthCodec.writeData(dv.getLength());
                        continue block16;
                    }
                    case 78: {
                        RefSkip rsv = (RefSkip)f;
                        this.refSkipCodec.writeData(rsv.getLength());
                        continue block16;
                    }
                    case 105: {
                        InsertBase ib = (InsertBase)f;
                        this.baseCodec.writeData(ib.getBase());
                        continue block16;
                    }
                    case 81: {
                        BaseQualityScore bqs = (BaseQualityScore)f;
                        this.qualityScoreCodec.writeData(bqs.getQualityScore());
                        continue block16;
                    }
                }
                throw new RuntimeException("Unknown read feature operator: " + (char)f.getOperator());
            }
            this.mappingQualityScoreCodec.writeData(r.mappingQuality);
            if (r.isForcePreserveQualityScores()) {
                this.qualityScoreArrayCodec.writeData(r.qualityScores);
            }
        } else {
            if (!r.isUnknownBases()) {
                for (byte b : r.readBases) {
                    this.baseCodec.writeData(b);
                }
            }
            if (r.isForcePreserveQualityScores()) {
                this.qualityScoreArrayCodec.writeData(r.qualityScores);
            }
        }
    }

    public boolean isCaptureReadNames() {
        return this.captureReadNames;
    }

    public void setCaptureReadNames(boolean captureReadNames) {
        this.captureReadNames = captureReadNames;
    }
}

