/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.visitor.ConstantCounter;
import proguard.classfile.constant.visitor.ConstantTagFilter;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.constant.visitor.PrimitiveArrayConstantElementVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionUtil;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class PrimitiveArrayConstantReplacer
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
PrimitiveArrayConstantElementVisitor {
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
    private final ConstantPoolShrinker constantPoolShrinker = new ConstantPoolShrinker();
    private boolean classModified;
    private InstructionSequenceBuilder builder;

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        ConstantCounter constantCounter = new ConstantCounter();
        programClass.constantPoolEntriesAccept(new ConstantTagFilter(21, (ConstantVisitor)constantCounter));
        if (constantCounter.getCount() > 0) {
            this.classModified = false;
            programClass.methodsAccept(new AllAttributeVisitor(this));
            if (this.classModified) {
                programClass.accept(this.constantPoolShrinker);
            }
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        if (this.codeAttributeEditor.isModified()) {
            this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
            this.classModified = true;
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        this.builder = null;
        clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
        if (this.builder != null) {
            this.codeAttributeEditor.replaceInstruction(n, this.builder.instructions());
            this.classModified = true;
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        char c = primitiveArrayConstant.getPrimitiveType();
        int n = primitiveArrayConstant.getLength();
        this.builder = new InstructionSequenceBuilder((ProgramClass)clazz);
        this.builder.pushInt(primitiveArrayConstant.getLength());
        this.builder.newarray(InstructionUtil.arrayTypeFromInternalType(c));
        primitiveArrayConstant.primitiveArrayElementsAccept(clazz, this);
    }

    @Override
    public void visitBooleanArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, boolean bl) {
        this.builder.dup().pushInt(n).iconst(bl ? 1 : 0).bastore();
    }

    @Override
    public void visitByteArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, byte by) {
        this.builder.dup().pushInt(n).pushInt(by).bastore();
    }

    @Override
    public void visitCharArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, char c) {
        this.builder.dup().pushInt(n).pushInt(c).castore();
    }

    @Override
    public void visitShortArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, short s) {
        this.builder.dup().pushInt(n).pushInt(s).sastore();
    }

    @Override
    public void visitIntArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, int n2) {
        this.builder.dup().pushInt(n).pushInt(n2).iastore();
    }

    @Override
    public void visitFloatArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, float f) {
        this.builder.dup().pushInt(n).pushFloat(f).fastore();
    }

    @Override
    public void visitLongArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, long l) {
        this.builder.dup().pushInt(n).pushLong(l).lastore();
    }

    @Override
    public void visitDoubleArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, double d) {
        this.builder.dup().pushInt(n).pushDouble(d).dastore();
    }
}

