/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_CACHEMEMORYACCESS_H_
#define OPENDRIM_CACHEMEMORYACCESS_H_

#include "CPU_Common.h"
#include <SMBIOS.h>
#include "OpenDRIM_CacheMemory.h"

int CPU_OpenDRIM_CacheMemory_load(const CMPIBroker* broker, string& errorMessage);

int CPU_OpenDRIM_CacheMemory_unload(string& errorMessage);

int CPU_OpenDRIM_CacheMemory_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_CacheMemory>& instances, const char** properties, string& errorMessage, const string& discriminant);

int CPU_OpenDRIM_CacheMemory_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_CacheMemory& instance, const char** properties, string& errorMessage);

int CPU_OpenDRIM_CacheMemory_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_CacheMemory& newInstance, const OpenDRIM_CacheMemory& oldInstance, const char** properties, string& errorMessage);

int CPU_OpenDRIM_CacheMemory_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_CacheMemory& instance, string& errorMessage);

int CPU_OpenDRIM_CacheMemory_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_CacheMemory& instance, string& errorMessage);

int CPU_OpenDRIM_CacheMemory_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_CacheMemory& instance, unsigned int& returnValue, const OpenDRIM_CacheMemory_RequestStateChange_In& in, OpenDRIM_CacheMemory_RequestStateChange_Out& out, string& errorMessage);

int CPU_OpenDRIM_CacheMemory_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_CacheMemory& instance, unsigned int& returnValue, const OpenDRIM_CacheMemory_SetPowerState_In& in, string& errorMessage);

int CPU_OpenDRIM_CacheMemory_Reset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_CacheMemory& instance, unsigned int& returnValue, string& errorMessage);

int CPU_OpenDRIM_CacheMemory_EnableDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_CacheMemory& instance, unsigned int& returnValue, const OpenDRIM_CacheMemory_EnableDevice_In& in, string& errorMessage);

int CPU_OpenDRIM_CacheMemory_OnlineDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_CacheMemory& instance, unsigned int& returnValue, const OpenDRIM_CacheMemory_OnlineDevice_In& in, string& errorMessage);

int CPU_OpenDRIM_CacheMemory_QuiesceDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_CacheMemory& instance, unsigned int& returnValue, const OpenDRIM_CacheMemory_QuiesceDevice_In& in, string& errorMessage);

int CPU_OpenDRIM_CacheMemory_SaveProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_CacheMemory& instance, unsigned int& returnValue, string& errorMessage);

int CPU_OpenDRIM_CacheMemory_RestoreProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_CacheMemory& instance, unsigned int& returnValue, string& errorMessage);

int CPU_OpenDRIM_CacheMemory_populate(OpenDRIM_CacheMemory& instance, const _processor_topology& cpu_info_processor_information, const _processor_information& SMBIOS_processor_information, int level, string& errorMessage);

#endif /*OPENDRIM_CACHEMEMORYACCESS_H_*/
