/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_USEOFLOG_H_
#define OPENDRIM_USEOFLOG_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_Log.h"
#include "CIM_LogAccess.h"
#include "cmpiCIM_ManagedSystemElement.h"
#include "CIM_ManagedSystemElementAccess.h"
*/

const static char* OpenDRIM_UseOfLog_classnames[] = {"OpenDRIM_UseOfLog"};
static string OpenDRIM_UseOfLog_NAMESPACE = _NAMESPACE;
const static string Antecedent_role = "Antecedent";
const static char* Antecedent_classnames[] = {"OpenDRIM_RecordLog"}; // CIM_RecordLog
const static string Antecedent_NAMESPACE = _NAMESPACE;

const static string Dependent_role = "Dependent";
const static char* Dependent_classnames[] = {"OpenDRIM_ComputerSystem"}; // CIM_ManagedSystemElement
const static string Dependent_NAMESPACE = _NAMESPACE;

class OpenDRIM_UseOfLog {

public:
	
	Objectpath Antecedent;
	bool Antecedent_isNULL;
	
	Objectpath Dependent;
	bool Dependent_isNULL;
	
	string RecordedData;
	bool RecordedData_isNULL;
	
	OpenDRIM_UseOfLog() {
		Antecedent_isNULL = true;
		Dependent_isNULL = true;
		RecordedData_isNULL = true;
	}
	
	~OpenDRIM_UseOfLog() {}
	
	string getKeys() const {
		return CF_toLowCase(".Antecedent=\"" + CF_quoteString(Antecedent.toString()) + "\""".Dependent=\"" + CF_quoteString(Dependent.toString()) + "\"");
	}

	int getAntecedent(Objectpath& value) const {
		if (Antecedent_isNULL==true)
			return NOT_FOUND;
		value = Antecedent;
		return OK;
	}
	
	int setAntecedent(const Objectpath& newValue) {
		Antecedent = newValue;
		Antecedent.setNamespace(Antecedent_NAMESPACE);
		Antecedent_isNULL = false;
		return OK;
	}

	int getDependent(Objectpath& value) const {
		if (Dependent_isNULL==true)
			return NOT_FOUND;
		value = Dependent;
		return OK;
	}
	
	int setDependent(const Objectpath& newValue) {
		Dependent = newValue;
		Dependent.setNamespace(Dependent_NAMESPACE);
		Dependent_isNULL = false;
		return OK;
	}

	int getRecordedData(string& value) const {
		if (RecordedData_isNULL==true)
			return NOT_FOUND;
		value = RecordedData;
		return OK;
	}
	
	int setRecordedData(const string& newValue) {
		RecordedData = newValue;
		RecordedData_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_USEOFLOG_H_*/
