/*###############################################################################
# Linux Management Providers (LMP), Software Update provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_SoftwareUpdateHostedService.h"
#include "OpenDRIM_SoftwareUpdateHostedServiceAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderSetInstance SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderModifyInstance
#endif

int SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_init(const CMPIBroker* broker);

int SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_SoftwareUpdateHostedService> instances;
	string errorMessage;
	
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_SoftwareUpdateHostedService> instances;
	string errorMessage;
	
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_SoftwareUpdateHostedService instance;
	SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_SoftwareUpdateHostedService newInstance, oldInstance;
	SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_toCPP(_broker, ci, newInstance);
	SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_SoftwareUpdateHostedService instance;
	SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_SoftwareUpdateHostedService instance;
	SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                     Association Provider Interface                         */
/* ---------------------------------------------------------------------------*/

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderAssociationCleanup(CMPIAssociationMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderAssociatorNames(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* resultClass, const char* role, const char* resultRole) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_associator(_broker, ctx, cop, known, assocClass, resultClass, role, resultRole, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associatedInstances.size(); i++)
		CMReturnObjectPath(rslt, associatedInstances[i].getObjectpath().getHdl());
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderAssociators(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* resultClass, const char* role, const char* resultRole, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_associator(_broker, ctx, cop, known, assocClass, resultClass, role, resultRole, properties, associatedInstances, leftToRight, errorMessage, "a");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associatedInstances.size(); i++)
		CMReturnInstance(rslt, associatedInstances[i].getHdl());
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderReferenceNames(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* role) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_associator(_broker, ctx, cop, known, assocClass, NULL, role, NULL, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	vector<OpenDRIM_SoftwareUpdateHostedService> associationInstances;
	if (leftToRight)
		errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_referenceAntecedentToDependent(_broker, ctx, known, associatedInstances, associationInstances, NULL, errorMessage, "rn");
	else
		errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_referenceDependentToAntecedent(_broker, ctx, known, associatedInstances, associationInstances, NULL, errorMessage, "rn");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associationInstances.size(); i++) {
		CMPIObjectPath* op = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_toCMPIObjectPath(_broker, associationInstances[i]);
		CMReturnObjectPath(rslt, op);
	}
	_L_;
	return rc;
}

CMPIStatus SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProviderReferences(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* role, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_associator(_broker, ctx, cop, known, assocClass, NULL, role, NULL, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	vector<OpenDRIM_SoftwareUpdateHostedService> associationInstances;
	if (leftToRight)
		errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_referenceAntecedentToDependent(_broker, ctx, known, associatedInstances, associationInstances, properties, errorMessage, "r");
	else
		errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_referenceDependentToAntecedent(_broker, ctx, known, associatedInstances, associationInstances, properties, errorMessage, "r");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associationInstances.size(); i++) {
		CMPIInstance* inst = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_toCMPIInstance(_broker, associationInstances[i]);
		CMReturnInstance(rslt, inst);
	}
	_L_;
	return rc;
}

/* ---------------------------------------------------------------------------*/
/*                  End Of Association Provider Interface                     */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_init FAILED: " + (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_unload FAILED: " + (string) OpenDRIM_SoftwareUpdateHostedService_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_INIT if (SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_init(_broker) < 0) return NULL

CMInstanceMIStub(SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProvider, SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProvider, _broker, SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_INIT);
CMAssociationMIStub(SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProvider, SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedServiceProvider, _broker, SoftwareUpdate_OpenDRIM_SoftwareUpdateHostedService_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
