/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.UTF8Util;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.InternalClob;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;

final class StoreStreamClob
implements InternalClob {
    private static final long SKIP_BUFFER_SIZE = 8192L;
    private volatile boolean released = false;
    private final PositionedStoreStream positionedStoreStream;
    private final ConnectionChild conChild;
    private final Object synchronizationObject;

    public StoreStreamClob(InputStream inputStream, ConnectionChild connectionChild) throws StandardException {
        this.positionedStoreStream = new PositionedStoreStream(inputStream);
        this.conChild = connectionChild;
        this.synchronizationObject = connectionChild.getConnectionSynchronization();
        this.positionedStoreStream.initStream();
    }

    public void release() {
        if (!this.released) {
            this.positionedStoreStream.closeStream();
            this.released = true;
        }
    }

    public long getByteLength() throws IOException, SQLException {
        this.checkIfValid();
        long l = 0L;
        try {
            long l2;
            this.conChild.setupContextStack();
            this.positionedStoreStream.reposition(0L);
            int n = this.positionedStoreStream.read();
            int n2 = this.positionedStoreStream.read();
            l = (n << 8) + (n2 << 0);
            if (l == 0L) {
                while ((l2 = this.positionedStoreStream.skip(8192L)) > 0L) {
                    l += l2;
                }
                l -= 3L;
            }
            l2 = l;
            return l2;
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
        finally {
            this.conChild.restoreContextStack();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getCharLength() throws SQLException {
        this.checkIfValid();
        Object object = this.synchronizationObject;
        synchronized (object) {
            this.conChild.setupContextStack();
            try {
                long l = UTF8Util.skipUntilEOF(new BufferedInputStream(this.getRawByteStream()));
                return l;
            }
            catch (Throwable throwable) {
                throw StoreStreamClob.noStateChangeLOB(throwable);
            }
            finally {
                this.conChild.restoreContextStack();
            }
        }
    }

    public InputStream getRawByteStream() throws IOException, SQLException {
        this.checkIfValid();
        try {
            this.positionedStoreStream.reposition(2L);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
        return this.positionedStoreStream;
    }

    public Reader getReader(long l) throws IOException, SQLException {
        long l2;
        this.checkIfValid();
        try {
            this.positionedStoreStream.reposition(0L);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
        UTF8Reader uTF8Reader = new UTF8Reader(this.positionedStoreStream, Integer.MAX_VALUE, this.conChild, this.synchronizationObject);
        for (long i = l - 1L; i > 0L; i -= l2) {
            l2 = ((Reader)uTF8Reader).skip(i);
            if (l2 > 0L) continue;
            throw new EOFException("Reached end-of-stream prematurely");
        }
        return uTF8Reader;
    }

    public long getBytePosition(long l) throws IOException, SQLException {
        return UTF8Util.skipFully(this.getRawByteStream(), l - 1L);
    }

    public Writer getWriter(long l) {
        throw new UnsupportedOperationException("A StoreStreamClob object is not updatable");
    }

    public long insertString(String string, long l) {
        throw new UnsupportedOperationException("A StoreStreamClob object is not updatable");
    }

    public boolean isWritable() {
        return false;
    }

    public void truncate(long l) {
        throw new UnsupportedOperationException("A StoreStreamClob object is not updatable");
    }

    private static SQLException noStateChangeLOB(Throwable throwable) {
        if (throwable instanceof StandardException && ((StandardException)throwable).getMessageId().equals("40XD0")) {
            throwable = StandardException.newException("XJ073.S");
        }
        return EmbedResultSet.noStateChangeException(throwable);
    }

    private void checkIfValid() {
        if (this.released) {
            throw new IllegalStateException("The Clob has been released and is not valid");
        }
    }
}

