/*
 * translate_text.c - Translation texts to be included in translate.c
 *
 * Written by
 *  Marco van den Heuvel <blackystardust68@yahoo.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

translate_t string_table[] = {

/* autostart.c */
/* en */ {IDGS_CANNOT_LOAD_SNAPSHOT_FILE,    N_("Cannot load snapshot file.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_LOAD_SNAPSHOT_FILE_DA, "Kunne ikke indlse snapshot-fil."},
/* de */ {IDGS_CANNOT_LOAD_SNAPSHOT_FILE_DE, "Kann Snapshot Datei nicht laden."},
/* es */ {IDGS_CANNOT_LOAD_SNAPSHOT_FILE_ES, "No puedo cargar Instantnea"},
/* fr */ {IDGS_CANNOT_LOAD_SNAPSHOT_FILE_FR, "Impossible de charger l'instantan."},
/* hu */ {IDGS_CANNOT_LOAD_SNAPSHOT_FILE_HU, "Nem sikerlt betlteni a pillanatkp fjlt."},
/* it */ {IDGS_CANNOT_LOAD_SNAPSHOT_FILE_IT, "Non  possibile caricare il file di snapshot."},
/* ko */ {IDGS_CANNOT_LOAD_SNAPSHOT_FILE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_LOAD_SNAPSHOT_FILE_NL, "Kan momentopnamebestand niet laden."},
/* pl */ {IDGS_CANNOT_LOAD_SNAPSHOT_FILE_PL, "Nie mona wczyta pliku zrzutu."},
/* ru */ {IDGS_CANNOT_LOAD_SNAPSHOT_FILE_RU, "Cannot load snapshot file."},
/* sv */ {IDGS_CANNOT_LOAD_SNAPSHOT_FILE_SV, "Kan inte lsa in gonblicksbildfil."},
/* tr */ {IDGS_CANNOT_LOAD_SNAPSHOT_FILE_TR, "Anlk grnt dosyas yklenemedi."},
#endif

/* debug.c */
/* en */ {IDGS_PLAYBACK_ERROR_DIFFERENT,    N_("Playback error: %s different from line %d of file debug%06d")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_PLAYBACK_ERROR_DIFFERENT_DA, "Afspilningsfejl: %s forskellig fra linje %d i filen debug%06d"},
/* de */ {IDGS_PLAYBACK_ERROR_DIFFERENT_DE, "Wiedergabe Fehler: %s ist unterschiedlich von Zeile %d in Datei debug%06d"},
/* es */ {IDGS_PLAYBACK_ERROR_DIFFERENT_ES, "Error de reproduccin: %s diferente desde linea %d del fichero de depuracin%06d"},
/* fr */ {IDGS_PLAYBACK_ERROR_DIFFERENT_FR, "Erreur de lecture: %s diffrent de la ligne %d du fichier debug%06d"},
/* hu */ {IDGS_PLAYBACK_ERROR_DIFFERENT_HU, "Visszajtszsi hiba: %s klnbzik a %d. sorban a debug%06d fjl esetn"},
/* it */ {IDGS_PLAYBACK_ERROR_DIFFERENT_IT, "Errore di riproduzione: %s  differente dalla linea %d del file di debug %06d"},
/* ko */ {IDGS_PLAYBACK_ERROR_DIFFERENT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_PLAYBACK_ERROR_DIFFERENT_NL, "Afspeelfout: %s is anders dan regel %d van bestand debug%06d"},
/* pl */ {IDGS_PLAYBACK_ERROR_DIFFERENT_PL, "Bd otwarzania: %s rni si od linii %d pliku debug%06d"},
/* ru */ {IDGS_PLAYBACK_ERROR_DIFFERENT_RU, "Playback error: %s different from line %d of file debug%06d"},
/* sv */ {IDGS_PLAYBACK_ERROR_DIFFERENT_SV, "terspelningsfel: %s inte lika som rad %d i filen debug%06d"},
/* tr */ {IDGS_PLAYBACK_ERROR_DIFFERENT_TR, "Kayttan yrtme hatas: %s dosyann %d satrndan farkl (hata ayklama%06d)"},
#endif

/* event.c */
/* en */ {IDGS_CANNOT_CREATE_IMAGE,    N_("Cannot create image file!")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_CREATE_IMAGE_DA, "Kunne ikke oprette image-fil!"},
/* de */ {IDGS_CANNOT_CREATE_IMAGE_DE, "Kann Imagedatei nicht erzeugen!"},
/* es */ {IDGS_CANNOT_CREATE_IMAGE_ES, "No puedo crear fichero imagen!"},
/* fr */ {IDGS_CANNOT_CREATE_IMAGE_FR, "Impossible de crer le fichier image!"},
/* hu */ {IDGS_CANNOT_CREATE_IMAGE_HU, "Nem sikerlt a kpms fjlt ltrehozni!"},
/* it */ {IDGS_CANNOT_CREATE_IMAGE_IT, "Non  possibile creare il file immagine!"},
/* ko */ {IDGS_CANNOT_CREATE_IMAGE_KO, "̹  Ҽ ϴ!"},
/* nl */ {IDGS_CANNOT_CREATE_IMAGE_NL, "Kan bestand niet aanmaken!"},
/* pl */ {IDGS_CANNOT_CREATE_IMAGE_PL, "Nie mona utworzy pliku obrazu!"},
/* ru */ {IDGS_CANNOT_CREATE_IMAGE_RU, "    !"},
/* sv */ {IDGS_CANNOT_CREATE_IMAGE_SV, "Kan inte skapa avbildningsfil!"},
/* tr */ {IDGS_CANNOT_CREATE_IMAGE_TR, "Imaj dosyas yaratlamad!"},
#endif

/* event.c */
/* en */ {IDGS_CANNOT_WRITE_IMAGE_FILE_S,    N_("Cannot write image file %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_WRITE_IMAGE_FILE_S_DA, "Kunne ikks skrive image-fil %s"},
/* de */ {IDGS_CANNOT_WRITE_IMAGE_FILE_S_DE, "Kann Datei %s nicht schreiben"},
/* es */ {IDGS_CANNOT_WRITE_IMAGE_FILE_S_ES, "No puedo grabar fichero imagen %s"},
/* fr */ {IDGS_CANNOT_WRITE_IMAGE_FILE_S_FR, "Impossible d'crire le fichier image %s"},
/* hu */ {IDGS_CANNOT_WRITE_IMAGE_FILE_S_HU, "Nem sikerlt a %s kpms fjlba rni"},
/* it */ {IDGS_CANNOT_WRITE_IMAGE_FILE_S_IT, "Non  possibile scrivere l'immagine %s"},
/* ko */ {IDGS_CANNOT_WRITE_IMAGE_FILE_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_WRITE_IMAGE_FILE_S_NL, "Kan niet schrijven naar bestand %s"},
/* pl */ {IDGS_CANNOT_WRITE_IMAGE_FILE_S_PL, "Nie mona zapisa pliku obrazu %s"},
/* ru */ {IDGS_CANNOT_WRITE_IMAGE_FILE_S_RU, "Cannot write image file %s"},
/* sv */ {IDGS_CANNOT_WRITE_IMAGE_FILE_S_SV, "Kan inte skriva avbildningsfil %s"},
/* tr */ {IDGS_CANNOT_WRITE_IMAGE_FILE_S_TR, "%s imaj dosyasna yazlamad"},
#endif

/* event.c */
/* en */ {IDGS_CANNOT_FIND_MAPPED_NAME_S,    N_("Cannot find mapped name for %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_FIND_MAPPED_NAME_S_DA, "Kunne ikke finde mappet navn for %s"},
/* de */ {IDGS_CANNOT_FIND_MAPPED_NAME_S_DE, "Kann zugeordneten Namen fr `%s' nicht finden."},
/* es */ {IDGS_CANNOT_FIND_MAPPED_NAME_S_ES, "No puedo encontrar nombre mapeado para %s"},
/* fr */ {IDGS_CANNOT_FIND_MAPPED_NAME_S_FR, "Impossible de trouver le nom correspondant  %s"},
/* hu */ {IDGS_CANNOT_FIND_MAPPED_NAME_S_HU, "A VICE %s lekpzett nevt nem tallja"},
/* it */ {IDGS_CANNOT_FIND_MAPPED_NAME_S_IT, "Non  possibile trovare il nome mappato per %s"},
/* ko */ {IDGS_CANNOT_FIND_MAPPED_NAME_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_FIND_MAPPED_NAME_S_NL, "Kan toegewezen naam voor %s niet vinden"},
/* pl */ {IDGS_CANNOT_FIND_MAPPED_NAME_S_PL, "Nie mona znale zmapowanej nazwy %s"},
/* ru */ {IDGS_CANNOT_FIND_MAPPED_NAME_S_RU, "Cannot find mapped name for %s"},
/* sv */ {IDGS_CANNOT_FIND_MAPPED_NAME_S_SV, "Kan inte kopplat namn fr %s"},
/* tr */ {IDGS_CANNOT_FIND_MAPPED_NAME_S_TR, "%s iin eleme ismi bulunamad"},
#endif

/* event.c */
/* en */ {IDGS_CANT_CREATE_START_SNAP_S,    N_("Could not create start snapshot file %s.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANT_CREATE_START_SNAP_S_DA, "Kunne ikke oprette start-snapshot-filen %s."},
/* de */ {IDGS_CANT_CREATE_START_SNAP_S_DE, "Kann Start Snapshot Datei nicht erzeugen: %s"},
/* es */ {IDGS_CANT_CREATE_START_SNAP_S_ES, "No puedo crear inicio fichero Instantnea %s."},
/* fr */ {IDGS_CANT_CREATE_START_SNAP_S_FR, "Impossible de crer l'instantan de dpart %s."},
/* hu */ {IDGS_CANT_CREATE_START_SNAP_S_HU, "Nem sikerlt a %s kezdeti pillanatkp fjlt ltrehozni."},
/* it */ {IDGS_CANT_CREATE_START_SNAP_S_IT, "Non  possibile creare il file di inizio snapshot %s."},
/* ko */ {IDGS_CANT_CREATE_START_SNAP_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANT_CREATE_START_SNAP_S_NL, "Kon het start momentopnamebestand %s niet maken."},
/* pl */ {IDGS_CANT_CREATE_START_SNAP_S_PL, "Nie mona utworzy pocztkowego pliku zrzutu %s."},
/* ru */ {IDGS_CANT_CREATE_START_SNAP_S_RU, "Could not create start snapshot file %s."},
/* sv */ {IDGS_CANT_CREATE_START_SNAP_S_SV, "Kunde inte skapa startgonblicksbildfilen %s."},
/* tr */ {IDGS_CANT_CREATE_START_SNAP_S_TR, "Anlk grnt dosyas %s yaratlamad."},
#endif

/* event.c */
/* en */ {IDGS_ERROR_READING_END_SNAP_S,    N_("Error reading end snapshot file %s.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ERROR_READING_END_SNAP_S_DA, "Fejl under lsning af slut-snapshot %s."},
/* de */ {IDGS_ERROR_READING_END_SNAP_S_DE, "Kann Ende Snapshot Datei nicht lesen: %s"},
/* es */ {IDGS_ERROR_READING_END_SNAP_S_ES, "Error leyendo final fichero Instantnea %s."},
/* fr */ {IDGS_ERROR_READING_END_SNAP_S_FR, "Erreur de lecture de l'instantan de fin %s."},
/* hu */ {IDGS_ERROR_READING_END_SNAP_S_HU, "Hiba az utols %s pillanatkp fjl rsakor."},
/* it */ {IDGS_ERROR_READING_END_SNAP_S_IT, "Errore durante la lettura del file di fine snapshot %s."},
/* ko */ {IDGS_ERROR_READING_END_SNAP_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ERROR_READING_END_SNAP_S_NL, "Fout bij het lezen van het eind van het momentopnamebestand %s."},
/* pl */ {IDGS_ERROR_READING_END_SNAP_S_PL, "Bd odczytu kocowego pliku zrzutu %s."},
/* ru */ {IDGS_ERROR_READING_END_SNAP_S_RU, "Error reading end snapshot file %s."},
/* sv */ {IDGS_ERROR_READING_END_SNAP_S_SV, "Fel vid lsning av slutgonblicksbildfilen %s."},
/* tr */ {IDGS_ERROR_READING_END_SNAP_S_TR, "Anlk grnt dosyas %s okuma hatas."},
#endif

/* event.c */
/* en */ {IDGS_CANT_CREATE_END_SNAP_S,    N_("Could not create end snapshot file %s.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANT_CREATE_END_SNAP_S_DA, "Kunne ikke oprette slut-snapshot-filen %s."},
/* de */ {IDGS_CANT_CREATE_END_SNAP_S_DE, "Kann Ende Snapshot Datei nicht erzeugen: %s"},
/* es */ {IDGS_CANT_CREATE_END_SNAP_S_ES, "No puedo crear fin fichero Instantnea %s."},
/* fr */ {IDGS_CANT_CREATE_END_SNAP_S_FR, "Impossible de crer l'instantan de fin %s."},
/* hu */ {IDGS_CANT_CREATE_END_SNAP_S_HU, "Nem sikerlt a %s befejez pillanatkp fjlt ltrehozni."},
/* it */ {IDGS_CANT_CREATE_END_SNAP_S_IT, "Non  possibile creare il file di fine snapshot %s."},
/* ko */ {IDGS_CANT_CREATE_END_SNAP_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANT_CREATE_END_SNAP_S_NL, "Kon het eind momentopnamebestand %s niet maken."},
/* pl */ {IDGS_CANT_CREATE_END_SNAP_S_PL, "Nie mona utworzy kocowego pliku zrzutu %s."},
/* ru */ {IDGS_CANT_CREATE_END_SNAP_S_RU, "Could not create end snapshot file %s."},
/* sv */ {IDGS_CANT_CREATE_END_SNAP_S_SV, "Kunde inte skapa slutgonblicksbildfilen %s."},
/* tr */ {IDGS_CANT_CREATE_END_SNAP_S_TR, "Son anlk grnt dosyas %s yaratlamad."},
#endif

/* event.c */
/* en */ {IDGS_CANT_OPEN_END_SNAP_S,    N_("Could not open end snapshot file %s.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANT_OPEN_END_SNAP_S_DA, "Kunne ikke bne slut-snapshot-filen %s."},
/* de */ {IDGS_CANT_OPEN_END_SNAP_S_DE, "Kann Ende Snapshot Datei nicht ffnen: %s"},
/* es */ {IDGS_CANT_OPEN_END_SNAP_S_ES, "No puedo abrir fin fichero Instantnea %s."},
/* fr */ {IDGS_CANT_OPEN_END_SNAP_S_FR, "Impossible d'ouvrir l'instantan de fin %s."},
/* hu */ {IDGS_CANT_OPEN_END_SNAP_S_HU, "Nem sikerlt az utols %s pillanatkp fjlt megnyitni."},
/* it */ {IDGS_CANT_OPEN_END_SNAP_S_IT, "Non  possibile aprire il file di fine snapshot %s."},
/* ko */ {IDGS_CANT_OPEN_END_SNAP_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANT_OPEN_END_SNAP_S_NL, "Kon het eind momentopnamebestand %s niet openen."},
/* pl */ {IDGS_CANT_OPEN_END_SNAP_S_PL, "Nie mona otworzy kocowego pliku zrzutu %s."},
/* ru */ {IDGS_CANT_OPEN_END_SNAP_S_RU, "Could not open end snapshot file %s."},
/* sv */ {IDGS_CANT_OPEN_END_SNAP_S_SV, "Kunde inte ppna slutgonblicksbildfilen %s."},
/* tr */ {IDGS_CANT_OPEN_END_SNAP_S_TR, "Son anlk grnt dosyas %s alamad."},
#endif

/* event.c */
/* en */ {IDGS_CANT_FIND_SECTION_END_SNAP,    N_("Could not find event section in end snapshot file.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANT_FIND_SECTION_END_SNAP_DA, "Kunne ikke finde hndelses-sektionen i slut-snapshot-filen."},
/* de */ {IDGS_CANT_FIND_SECTION_END_SNAP_DE, "Kann Sektion in Ende Snapshotdatei nicht finden."},
/* es */ {IDGS_CANT_FIND_SECTION_END_SNAP_ES, "No puedo encontrar seccin eventos en fin fichero Instantnea."},
/* fr */ {IDGS_CANT_FIND_SECTION_END_SNAP_FR, "Impossible de trouver la section event dans l'instantan de fin."},
/* hu */ {IDGS_CANT_FIND_SECTION_END_SNAP_HU, "Nem talltam esemny rszt az utols pillanatkp fjlban."},
/* it */ {IDGS_CANT_FIND_SECTION_END_SNAP_IT, "Non  possibile trovare la sezione eventi nel file di fine snapshot."},
/* ko */ {IDGS_CANT_FIND_SECTION_END_SNAP_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANT_FIND_SECTION_END_SNAP_NL, "Kon de gebeurtenis sectie in eind momentopnamebestand niet vinden."},
/* pl */ {IDGS_CANT_FIND_SECTION_END_SNAP_PL, "Nie znaleziono sekcji zdarze w pliku kocowym zrzutu"},
/* ru */ {IDGS_CANT_FIND_SECTION_END_SNAP_RU, "Could not find event section in end snapshot file."},
/* sv */ {IDGS_CANT_FIND_SECTION_END_SNAP_SV, "Kunde inte hinna hndelsedelen i slutgonblicksbilden."},
/* tr */ {IDGS_CANT_FIND_SECTION_END_SNAP_TR, "Son anlk grnt dosyasnda olay blm bulunamad."},
#endif

/* event.c */
/* en */ {IDGS_ERROR_READING_START_SNAP_TRIED,    N_("Error reading start snapshot file. Tried %s and %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ERROR_READING_START_SNAP_TRIED_DA, "Fejl under lsning af start-snapshot. Prvede %s og %s"},
/* de */ {IDGS_ERROR_READING_START_SNAP_TRIED_DE, "Fehler beim Lesen der Start Snapshot Datei. Versuch gescheitert bei %s und %s."},
/* es */ {IDGS_ERROR_READING_START_SNAP_TRIED_ES, "Error leyendo inicio fichero Instantnea. Intentado %s y %s"},
/* fr */ {IDGS_ERROR_READING_START_SNAP_TRIED_FR, "Erreur de lecture de l'instantan de dpart. Essay %s et %s"},
/* hu */ {IDGS_ERROR_READING_START_SNAP_TRIED_HU, "Nem sikerlt az els pillanatkp fjl olvassa. Kiprblva: %s s %s"},
/* it */ {IDGS_ERROR_READING_START_SNAP_TRIED_IT, "Errore durante la lettura del file di inizio snapshot. Ho provato %s e %s"},
/* ko */ {IDGS_ERROR_READING_START_SNAP_TRIED_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ERROR_READING_START_SNAP_TRIED_NL, "Fout bij het lezen van het start momentopnamebestand. Heb %s en %s geprobeerd"},
/* pl */ {IDGS_ERROR_READING_START_SNAP_TRIED_PL, "Bd odczytu pocztkowego pliku zrzutu. Wyprbowano %s i %s"},
/* ru */ {IDGS_ERROR_READING_START_SNAP_TRIED_RU, "Error reading start snapshot file. Tried %s and %s"},
/* sv */ {IDGS_ERROR_READING_START_SNAP_TRIED_SV, "Fel vid lsning av startgonblicksbildfil. Frskte med %s och %s"},
/* tr */ {IDGS_ERROR_READING_START_SNAP_TRIED_TR, "Balang anlk grnt dosyas okuma hatas. %s ve %s denendi"},
#endif

/* event.c */
/* en */ {IDGS_ERROR_READING_START_SNAP,    N_("Error reading start snapshot file.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ERROR_READING_START_SNAP_DA, "Fejl under lsning af start-snapshot."},
/* de */ {IDGS_ERROR_READING_START_SNAP_DE, "Fehler beim Lesen der Start Snapshot Datei."},
/* es */ {IDGS_ERROR_READING_START_SNAP_ES, "Error leyendo inicio fichero Instantnea."},
/* fr */ {IDGS_ERROR_READING_START_SNAP_FR, "Erreur de lecture de l'instantan de dpart."},
/* hu */ {IDGS_ERROR_READING_START_SNAP_HU, "Nem sikerlt az indt pillanatkp fjl olvassa."},
/* it */ {IDGS_ERROR_READING_START_SNAP_IT, "Errore durante la lettura del file di inizio snapshot."},
/* ko */ {IDGS_ERROR_READING_START_SNAP_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ERROR_READING_START_SNAP_NL, "Fout bij het lezen van het start momentopnamebestand."},
/* pl */ {IDGS_ERROR_READING_START_SNAP_PL, "Bd odczytu pocztkowego pliku zrzutu."},
/* ru */ {IDGS_ERROR_READING_START_SNAP_RU, "Error reading start snapshot file."},
/* sv */ {IDGS_ERROR_READING_START_SNAP_SV, "Fel vid lsning av startgonblicksbildfil."},
/* tr */ {IDGS_ERROR_READING_START_SNAP_TR, "Balang anlk grnt dosyas okuma hatas."},
#endif

/* screenshot.c */
/* en */ {IDGS_SORRY_NO_MULTI_RECORDING,    N_("Sorry. Multiple recording is not supported.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SORRY_NO_MULTI_RECORDING_DA, "Kun en optagelse kan foretages ad gangen."},
/* de */ {IDGS_SORRY_NO_MULTI_RECORDING_DE, "Eine Aufnahme ist zur Zeit aktiv. Mehrfache Aufnahme ist nicht mglich."},
/* es */ {IDGS_SORRY_NO_MULTI_RECORDING_ES, "Lo siento, no estn soportadas las grabaciones mltiples."},
/* fr */ {IDGS_SORRY_NO_MULTI_RECORDING_FR, "Dsol. De multiples enregistrements ne sont pas support."},
/* hu */ {IDGS_SORRY_NO_MULTI_RECORDING_HU, "Sajnlom: tbbszrs felvtel nem tmogatott."},
/* it */ {IDGS_SORRY_NO_MULTI_RECORDING_IT, "Le registrazioni multiple non sono supportate."},
/* ko */ {IDGS_SORRY_NO_MULTI_RECORDING_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SORRY_NO_MULTI_RECORDING_NL, "Sorry. Meerdere gelijktijdige opnamen wordt niet ondersteund."},
/* pl */ {IDGS_SORRY_NO_MULTI_RECORDING_PL, "Przepraszamy, wielociekowy zapis nie jest obsugiwany."},
/* ru */ {IDGS_SORRY_NO_MULTI_RECORDING_RU, "Sorry. Multiple recording is not supported."},
/* sv */ {IDGS_SORRY_NO_MULTI_RECORDING_SV, "Endast en inspelning kan gras t gngen."},
/* tr */ {IDGS_SORRY_NO_MULTI_RECORDING_TR, "zgnz. oklu kayt desteklenmiyor."},
#endif

/* sound.c */
/* en */ {IDGS_WRITE_TO_SOUND_DEVICE_FAILED,    N_("write to sound device failed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_WRITE_TO_SOUND_DEVICE_FAILED_DA, "Kunne ikke skrive til lydenhed."},
/* de */ {IDGS_WRITE_TO_SOUND_DEVICE_FAILED_DE, "Schreiben auf Sound Gert ist fehlgeschlagen."},
/* es */ {IDGS_WRITE_TO_SOUND_DEVICE_FAILED_ES, "Fallo en grabacin perifrico sonido."},
/* fr */ {IDGS_WRITE_TO_SOUND_DEVICE_FAILED_FR, "impossible d'crire sur le priphrique son."},
/* hu */ {IDGS_WRITE_TO_SOUND_DEVICE_FAILED_HU, "Nem sikerlt a hangeszkzre rni"},
/* it */ {IDGS_WRITE_TO_SOUND_DEVICE_FAILED_IT, "scrittura sulla scheda audio fallita."},
/* ko */ {IDGS_WRITE_TO_SOUND_DEVICE_FAILED_KO, ""},  /* fuzzy */
/* nl */ {IDGS_WRITE_TO_SOUND_DEVICE_FAILED_NL, "schrijfactie naar geluidsapparaat is mislukt."},
/* pl */ {IDGS_WRITE_TO_SOUND_DEVICE_FAILED_PL, "Zapis do urzdzenia dwiku nie powid si."},
/* ru */ {IDGS_WRITE_TO_SOUND_DEVICE_FAILED_RU, "write to sound device failed."},
/* sv */ {IDGS_WRITE_TO_SOUND_DEVICE_FAILED_SV, "misslyckades att skriva till ljudenhet."},
/* tr */ {IDGS_WRITE_TO_SOUND_DEVICE_FAILED_TR, "ses aygtna yazma baarsz oldu."},
#endif

/* sound.c */
/* en */ {IDGS_CANNOT_OPEN_SID_ENGINE,    N_("Cannot open SID engine")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_OPEN_SID_ENGINE_DA, "Kunne ikke bne SID-motor"},
/* de */ {IDGS_CANNOT_OPEN_SID_ENGINE_DE, "Kann SID Engine nicht ffnen"},
/* es */ {IDGS_CANNOT_OPEN_SID_ENGINE_ES, "No puedo abrir motor SID"},
/* fr */ {IDGS_CANNOT_OPEN_SID_ENGINE_FR, "Erreur d'ouverture de l'engin SID"},
/* hu */ {IDGS_CANNOT_OPEN_SID_ENGINE_HU, "Nem sikerlt a SID motort megnyitni"},
/* it */ {IDGS_CANNOT_OPEN_SID_ENGINE_IT, "Non  possibile aprire il motore SID"},
/* ko */ {IDGS_CANNOT_OPEN_SID_ENGINE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_OPEN_SID_ENGINE_NL, "Kan de SID kern niet openen"},
/* pl */ {IDGS_CANNOT_OPEN_SID_ENGINE_PL, "Nie mona otworzy silnika SID"},
/* ru */ {IDGS_CANNOT_OPEN_SID_ENGINE_RU, "Cannot open SID engine"},
/* sv */ {IDGS_CANNOT_OPEN_SID_ENGINE_SV, "Kan inte ppna SID-motor"},
/* tr */ {IDGS_CANNOT_OPEN_SID_ENGINE_TR, "SID motoru alamyor"},
#endif

/* sound.c */
/* en */ {IDGS_CANNOT_INIT_SID_ENGINE,    N_("Cannot initialize SID engine")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_INIT_SID_ENGINE_DA, "Kunne ikke initialisere SID-motor"},
/* de */ {IDGS_CANNOT_INIT_SID_ENGINE_DE, "Kann SID Engine nicht initialisieren"},
/* es */ {IDGS_CANNOT_INIT_SID_ENGINE_ES, "No puedo inicializar motor SID"},
/* fr */ {IDGS_CANNOT_INIT_SID_ENGINE_FR, "Erreur d'initialisation de l'engin SID"},
/* hu */ {IDGS_CANNOT_INIT_SID_ENGINE_HU, "Nem sikerlt a SID motort elindtani"},
/* it */ {IDGS_CANNOT_INIT_SID_ENGINE_IT, "Non  possibile inizializzare il motore SID"},
/* ko */ {IDGS_CANNOT_INIT_SID_ENGINE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_INIT_SID_ENGINE_NL, "Kan de SID kern niet initialiseren"},
/* pl */ {IDGS_CANNOT_INIT_SID_ENGINE_PL, "Nie mona uruchomi silnika SID"},
/* ru */ {IDGS_CANNOT_INIT_SID_ENGINE_RU, "Cannot initialize SID engine"},
/* sv */ {IDGS_CANNOT_INIT_SID_ENGINE_SV, "Kan inte initiera SID-motor"},
/* tr */ {IDGS_CANNOT_INIT_SID_ENGINE_TR, "SID motorunun balang ayarlar yaplamyor"},
#endif

/* sound.c */
/* en */ {IDGS_INIT_FAILED_FOR_DEVICE_S,    N_("initialization failed for device `%s'.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_INIT_FAILED_FOR_DEVICE_S_DA, "Initialisering fejlede for enhed \"%s\"."},
/* de */ {IDGS_INIT_FAILED_FOR_DEVICE_S_DE, "Initialisierung von Gert `%s' fehlgeschlagen."},
/* es */ {IDGS_INIT_FAILED_FOR_DEVICE_S_ES, "Fallo inicializacin para perifrico `%s'."},
/* fr */ {IDGS_INIT_FAILED_FOR_DEVICE_S_FR, "erreur d'initialisation du priphrique `%s'."},
/* hu */ {IDGS_INIT_FAILED_FOR_DEVICE_S_HU, "A `%s' eszkzt nem sikerlt elindtani."},
/* it */ {IDGS_INIT_FAILED_FOR_DEVICE_S_IT, "inizializzazione fallita per il device `%s'."},
/* ko */ {IDGS_INIT_FAILED_FOR_DEVICE_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_INIT_FAILED_FOR_DEVICE_S_NL, "initialisatie voor apparaat `%s' is mislukt."},
/* pl */ {IDGS_INIT_FAILED_FOR_DEVICE_S_PL, "Inicjalizacja urzdzenia `%s' nie powioda si."},
/* ru */ {IDGS_INIT_FAILED_FOR_DEVICE_S_RU, "initialization failed for device `%s'."},
/* sv */ {IDGS_INIT_FAILED_FOR_DEVICE_S_SV, "initiering misslyckades fr enhet \"%s\"."},
/* tr */ {IDGS_INIT_FAILED_FOR_DEVICE_S_TR, "`%s' aygt iin balang ayarlar baarsz oldu."},
#endif

/* sound.c */
/* en */ {IDGS_DEVICE_S_NOT_FOUND_SUPPORT,    N_("device '%s' not found or not supported.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_DEVICE_S_NOT_FOUND_SUPPORT_DA, "enhed \"%s\" ikke fundet eller understttet."},
/* de */ {IDGS_DEVICE_S_NOT_FOUND_SUPPORT_DE, "Gert '%s' konnte nicht gefunden werden oder ist nicht untersttzt."},
/* es */ {IDGS_DEVICE_S_NOT_FOUND_SUPPORT_ES, "Perifrico '%s' no encontrado o soportado."},
/* fr */ {IDGS_DEVICE_S_NOT_FOUND_SUPPORT_FR, "priphrique '%s' non trouv ou non support."},
/* hu */ {IDGS_DEVICE_S_NOT_FOUND_SUPPORT_HU, "A '%s' eszkz nem ltezik, vagy nem tmogatott."},
/* it */ {IDGS_DEVICE_S_NOT_FOUND_SUPPORT_IT, "il device '%s' non  stato trovato oppure non  supportato."},
/* ko */ {IDGS_DEVICE_S_NOT_FOUND_SUPPORT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_DEVICE_S_NOT_FOUND_SUPPORT_NL, "apparaat '%s' niet gevonden of niet ondersteund"},
/* pl */ {IDGS_DEVICE_S_NOT_FOUND_SUPPORT_PL, "Nie znaleziono urzdzenia '%s' lub jest ono niewspierane"},
/* ru */ {IDGS_DEVICE_S_NOT_FOUND_SUPPORT_RU, "device '%s' not found or not supported."},
/* sv */ {IDGS_DEVICE_S_NOT_FOUND_SUPPORT_SV, "enheten \"%s\" hittades eller stds ej."},
/* tr */ {IDGS_DEVICE_S_NOT_FOUND_SUPPORT_TR, "'%s' aygt yok ya da desteklenmiyor."},
#endif

/* sound.c */
/* en */ {IDGS_RECORD_DEVICE_S_NOT_EXIST,    N_("Recording device %s doesn't exist!")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_RECORD_DEVICE_S_NOT_EXIST_DA, "Optageenheden %s findes ikke!"},
/* de */ {IDGS_RECORD_DEVICE_S_NOT_EXIST_DE, "Aufnahmegert %s existiert nicht!"},
/* es */ {IDGS_RECORD_DEVICE_S_NOT_EXIST_ES, "No existe el perifrico %s de grabacin "},
/* fr */ {IDGS_RECORD_DEVICE_S_NOT_EXIST_FR, "Le priphrique d'enregistrement %s n'existe pas!"},
/* hu */ {IDGS_RECORD_DEVICE_S_NOT_EXIST_HU, "A %s felvev eszkz nem ltezik!"},
/* it */ {IDGS_RECORD_DEVICE_S_NOT_EXIST_IT, "Il dispositivo di registrazione %s non esiste!"},
/* ko */ {IDGS_RECORD_DEVICE_S_NOT_EXIST_KO, ""},  /* fuzzy */
/* nl */ {IDGS_RECORD_DEVICE_S_NOT_EXIST_NL, "Opnameapparaat %s bestaat niet!"},
/* pl */ {IDGS_RECORD_DEVICE_S_NOT_EXIST_PL, "Urzdzenie zapisu %s nie istnieje!"},
/* ru */ {IDGS_RECORD_DEVICE_S_NOT_EXIST_RU, "Recording device %s doesn't exist!"},
/* sv */ {IDGS_RECORD_DEVICE_S_NOT_EXIST_SV, "Inspelningsenhet %s finns inte!"},
/* tr */ {IDGS_RECORD_DEVICE_S_NOT_EXIST_TR, "Kayt aygt %s mevcut deil!"},
#endif

/* sound.c */
/* en */ {IDGS_RECORD_DIFFERENT_PLAYBACK,    N_("Recording device must be different from playback device")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_RECORD_DIFFERENT_PLAYBACK_DA, "Indspilningsenhed og optagelsesenhed skal vre forskellige"},
/* de */ {IDGS_RECORD_DIFFERENT_PLAYBACK_DE, "Aufnahmegert muss unterschiedlich vom Abspielgert sein"},
/* es */ {IDGS_RECORD_DIFFERENT_PLAYBACK_ES, "Perifrico de grabacin y reproduccin tienen que ser diferentes"},
/* fr */ {IDGS_RECORD_DIFFERENT_PLAYBACK_FR, "Le priphrique de son d'enregistrement doivent tre diffrents"},
/* hu */ {IDGS_RECORD_DIFFERENT_PLAYBACK_HU, "A felvev s lejtsz eszkzknek klnbznie kell"},
/* it */ {IDGS_RECORD_DIFFERENT_PLAYBACK_IT, "Il dispositivo di registrazione deve essere differente da quello di riproduzione"},
/* ko */ {IDGS_RECORD_DIFFERENT_PLAYBACK_KO, ""},  /* fuzzy */
/* nl */ {IDGS_RECORD_DIFFERENT_PLAYBACK_NL, "Opnameapparaat moet anders zijn dan afspeelapparaat"},
/* pl */ {IDGS_RECORD_DIFFERENT_PLAYBACK_PL, "Urzdzenie zapisu musi by inne ni urzdzenie odtwarzania"},
/* ru */ {IDGS_RECORD_DIFFERENT_PLAYBACK_RU, "      "},
/* sv */ {IDGS_RECORD_DIFFERENT_PLAYBACK_SV, "Inspelningsenhet och terspelningsenhet kan inte vara samma"},
/* tr */ {IDGS_RECORD_DIFFERENT_PLAYBACK_TR, "Kayt aygt kayttan yrtme aygt ile farkl olmak zorundadr"},
#endif

/* sound.c */
/* en */ {IDGS_WARNING_RECORDING_REALTIME,    N_("Warning! Recording device %s seems to be a realtime device!")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_WARNING_RECORDING_REALTIME_DA, "Advarsel! Optageenheden %s ser ud til at vre en realtidsenhed!"},
/* de */ {IDGS_WARNING_RECORDING_REALTIME_DE, "Warnung! Aufnahmegert %s scheint ein Echtzeitgert zu sein!"},
/* es */ {IDGS_WARNING_RECORDING_REALTIME_ES, "Precaucin! perifrico de grabacin %s parece ser un perifrico en tiempo real"},
/* fr */ {IDGS_WARNING_RECORDING_REALTIME_FR, "Attention! Le priphrique d'enregistrement %s semble tre un priphrique temps rel"},
/* hu */ {IDGS_WARNING_RECORDING_REALTIME_HU, "Figyelem! A %s felvev eszkz gy tnik, vals idej eszkz!"},
/* it */ {IDGS_WARNING_RECORDING_REALTIME_IT, "Attenzione! Il dispositivo di registrazione %s sembra essere di tipo realtime!"},
/* ko */ {IDGS_WARNING_RECORDING_REALTIME_KO, ""},  /* fuzzy */
/* nl */ {IDGS_WARNING_RECORDING_REALTIME_NL, "Waarschuwing! Opnameapparaat %s lijkt een realtime apparaat te zijn!"},
/* pl */ {IDGS_WARNING_RECORDING_REALTIME_PL, "Ostrzeenie! Urzdzenie zapisu %s dziaa chyba w czasie rzeczywistym!"},
/* ru */ {IDGS_WARNING_RECORDING_REALTIME_RU, "Warning! Recording device %s seems to be a realtime device!"},
/* sv */ {IDGS_WARNING_RECORDING_REALTIME_SV, "Varning! Inspelningsenheten %s verkar vara en realtidsenhet!"},
/* tr */ {IDGS_WARNING_RECORDING_REALTIME_TR, "Uyar! Kayt aygt %s gerek zamanl bir aygt gibi grnyor!"},
#endif

/* sound.c */
/* en */ {IDGS_RECORD_NOT_SUPPORT_SOUND_PAR,    N_("The recording device doesn't support current sound parameters")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_DA, "Optageenheden understtter ikke de valgte lydparametre"},
/* de */ {IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_DE, "Aufnahmegert untersttzt derzeitige Soundeinstellungen nicht"},
/* es */ {IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_ES, "El perifrico de grabacin no soporta los actuales parmetros de sonido"},
/* fr */ {IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_FR, "Le priphrique d'enregistrement ne supporte pas les paramtres actuels"},
/* hu */ {IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_HU, "A felvev eszkz nem tmogatja az aktulis hangbelltsokat"},
/* it */ {IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_IT, "Il dispositivo di registrazione non supporta i parametri attuali"},
/* ko */ {IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_KO, ""},  /* fuzzy */
/* nl */ {IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_NL, "Het opnameapparaat ondersteunt de huidige geluidsopties niet"},
/* pl */ {IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_PL, "Urzdzenie zapisu nie obsuguje obecnych parametrw dwiku"},
/* ru */ {IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_RU, "The recording device doesn't support current sound parameters"},
/* sv */ {IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_SV, "Inspelningsenheten stder inte aktuella ljudinstllningar"},
/* tr */ {IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_TR, "Kayt aygt geerli ses parametrelerini desteklemiyor"},
#endif

/* sound.c */
/* en */ {IDGS_SOUND_BUFFER_OVERFLOW_CYCLE,    N_("Sound buffer overflow (cycle based)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_DA, "Lydbuffer overlb (cykelbaseret)"},
/* de */ {IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_DE, "Sound Puffer berlauf (Zyklus basiert)"},
/* es */ {IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_ES, "Desbordamiento Buffer sonido (Base ciclos)"},
/* fr */ {IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_FR, "Erreur de dpassement de tampon son (cycle based)"},
/* hu */ {IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_HU, "Hangpuffer tlcsorduls (ciklus alap)"},
/* it */ {IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_IT, "Overflow del buffer audio (cycle based)"},
/* ko */ {IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_NL, "Geluidsbuffer overloop (cyclus gebaseerd)"},
/* pl */ {IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_PL, "Przepeniony bufor dwiku (cykliczny)"},
/* ru */ {IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_RU, "Sound buffer overflow (cycle based)"},
/* sv */ {IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_SV, "Fr mycket data i ljudbufferten (cykelbaserad)"},
/* tr */ {IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_TR, "Ses arabellek tamas (cycle bazl)"},
#endif

/* sound.c */
/* en */ {IDGS_SOUND_BUFFER_OVERFLOW,    N_("Sound buffer overflow.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SOUND_BUFFER_OVERFLOW_DA, "Lydbuffer overlb."},
/* de */ {IDGS_SOUND_BUFFER_OVERFLOW_DE, "Sound Puffer berlauf."},
/* es */ {IDGS_SOUND_BUFFER_OVERFLOW_ES, "Desbordamiento Buffer sonido"},
/* fr */ {IDGS_SOUND_BUFFER_OVERFLOW_FR, "Erreur de dpassement de tampon son."},
/* hu */ {IDGS_SOUND_BUFFER_OVERFLOW_HU, "Hangpuffer tlcsorduls."},
/* it */ {IDGS_SOUND_BUFFER_OVERFLOW_IT, "Overflow del buffer audio."},
/* ko */ {IDGS_SOUND_BUFFER_OVERFLOW_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SOUND_BUFFER_OVERFLOW_NL, "Geluidsbuffer overloop."},
/* pl */ {IDGS_SOUND_BUFFER_OVERFLOW_PL, "Przepeniony bufor dwiku."},
/* ru */ {IDGS_SOUND_BUFFER_OVERFLOW_RU, "Sound buffer overflow."},
/* sv */ {IDGS_SOUND_BUFFER_OVERFLOW_SV, "Fr mycket data i ljudbufferten."},
/* tr */ {IDGS_SOUND_BUFFER_OVERFLOW_TR, "Ses arabellek tamas."},
#endif

/* sound.c */
/* en */ {IDGS_CANNOT_FLUSH,    N_("cannot flush.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_FLUSH_DA, "Kan ikke tmme."},
/* de */ {IDGS_CANNOT_FLUSH_DE, "Entleerung nicht mglich."},
/* es */ {IDGS_CANNOT_FLUSH_ES, "cannot flush."},
/* fr */ {IDGS_CANNOT_FLUSH_FR, "impossible de vider."},
/* hu */ {IDGS_CANNOT_FLUSH_HU, "nem sikerlt rteni a puffert."},
/* it */ {IDGS_CANNOT_FLUSH_IT, "non  possibile svuotare."},
/* ko */ {IDGS_CANNOT_FLUSH_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_FLUSH_NL, "kan niet leegmaken."},
/* pl */ {IDGS_CANNOT_FLUSH_PL, "Nie mona oprni."},
/* ru */ {IDGS_CANNOT_FLUSH_RU, "cannot flush."},
/* sv */ {IDGS_CANNOT_FLUSH_SV, "kan inte tmma."},
/* tr */ {IDGS_CANNOT_FLUSH_TR, "temizlenemedi."},
#endif

/* sound.c */
/* en */ {IDGS_FRAGMENT_PROBLEMS,    N_("fragment problems.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_FRAGMENT_PROBLEMS_DA, "Fragmentproblem."},
/* de */ {IDGS_FRAGMENT_PROBLEMS_DE, "Fragmentierungsproblem."},
/* es */ {IDGS_FRAGMENT_PROBLEMS_ES, "Problema de fragmentacin"},
/* fr */ {IDGS_FRAGMENT_PROBLEMS_FR, "problmes de fragments."},
/* hu */ {IDGS_FRAGMENT_PROBLEMS_HU, "tredkrsz problmk."},
/* it */ {IDGS_FRAGMENT_PROBLEMS_IT, "problemi di frammentazione."},
/* ko */ {IDGS_FRAGMENT_PROBLEMS_KO, ""},  /* fuzzy */
/* nl */ {IDGS_FRAGMENT_PROBLEMS_NL, "fragment problemen."},
/* pl */ {IDGS_FRAGMENT_PROBLEMS_PL, "Problemy z fragmentem"},
/* ru */ {IDGS_FRAGMENT_PROBLEMS_RU, "fragment problems."},
/* sv */ {IDGS_FRAGMENT_PROBLEMS_SV, "fragmentprogram."},
/* tr */ {IDGS_FRAGMENT_PROBLEMS_TR, "paralara ayrma problemi."},
#endif

/* sound.c */
/* en */ {IDGS_RUNNING_TOO_SLOW,    N_("running too slow.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_RUNNING_TOO_SLOW_DA, "Krer for langsomt."},
/* de */ {IDGS_RUNNING_TOO_SLOW_DE, "Ablauf zu langsam."},
/* es */ {IDGS_RUNNING_TOO_SLOW_ES, "Funciona demasiado lento."},
/* fr */ {IDGS_RUNNING_TOO_SLOW_FR, "excution trop lente."},
/* hu */ {IDGS_RUNNING_TOO_SLOW_HU, "tl lassan megy."},
/* it */ {IDGS_RUNNING_TOO_SLOW_IT, "esecuzione troppo lenta."},
/* ko */ {IDGS_RUNNING_TOO_SLOW_KO, ""},  /* fuzzy */
/* nl */ {IDGS_RUNNING_TOO_SLOW_NL, "draait te langzaam."},
/* pl */ {IDGS_RUNNING_TOO_SLOW_PL, "dziaa za wolno."},
/* ru */ {IDGS_RUNNING_TOO_SLOW_RU, "running too slow."},
/* sv */ {IDGS_RUNNING_TOO_SLOW_SV, "gr fr lngsamt."},
/* tr */ {IDGS_RUNNING_TOO_SLOW_TR, "ok yava alyor."},
#endif

/* sound.c */
/* en */ {IDGS_STORE_SOUNDDEVICE_FAILED,    N_("store to sounddevice failed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_STORE_SOUNDDEVICE_FAILED_DA, "skrivning til lydenhed fejlede."},
/* de */ {IDGS_STORE_SOUNDDEVICE_FAILED_DE, "Speichern auf Sound Gert ist fehlgeschlagen."},
/* es */ {IDGS_STORE_SOUNDDEVICE_FAILED_ES, "Almacenamiento en perifrico de sonido fallido"},
/* fr */ {IDGS_STORE_SOUNDDEVICE_FAILED_FR, "erreur d'enregistrement sur le priphrique son."},
/* hu */ {IDGS_STORE_SOUNDDEVICE_FAILED_HU, "a hangeszkzn trtn trols nem sikerlt."},
/* it */ {IDGS_STORE_SOUNDDEVICE_FAILED_IT, "memorizzazione sulla scheda audio fallita."},
/* ko */ {IDGS_STORE_SOUNDDEVICE_FAILED_KO, ""},  /* fuzzy */
/* nl */ {IDGS_STORE_SOUNDDEVICE_FAILED_NL, "opslag naar geluidsapparaat is mislukt."},
/* pl */ {IDGS_STORE_SOUNDDEVICE_FAILED_PL, "zapis do urzdzenia dwiku nie powid si"},
/* ru */ {IDGS_STORE_SOUNDDEVICE_FAILED_RU, "store to sounddevice failed."},
/* sv */ {IDGS_STORE_SOUNDDEVICE_FAILED_SV, "misslyckades spara i ljudenheten."},
/* tr */ {IDGS_STORE_SOUNDDEVICE_FAILED_TR, "ses aygtna saklama baarsz oldu."},
#endif

#ifdef HAVE_NETWORK
/* network.c */
/* en */ {IDGS_TESTING_BEST_FRAME_DELAY,    N_("Testing best frame delay...")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_TESTING_BEST_FRAME_DELAY_DA, "Tester bedste billed-forsinkelse..."},
/* de */ {IDGS_TESTING_BEST_FRAME_DELAY_DE, "Teste optimale Framerate..."},
/* es */ {IDGS_TESTING_BEST_FRAME_DELAY_ES, "Probando mejor demora de cuadro..."},
/* fr */ {IDGS_TESTING_BEST_FRAME_DELAY_FR, "Recherche du meilleur dlai d'image..."},
/* hu */ {IDGS_TESTING_BEST_FRAME_DELAY_HU, ""},  /* fuzzy */
/* it */ {IDGS_TESTING_BEST_FRAME_DELAY_IT, "Rileva il miglior ritardo tra frame..."},
/* ko */ {IDGS_TESTING_BEST_FRAME_DELAY_KO, ""},  /* fuzzy */
/* nl */ {IDGS_TESTING_BEST_FRAME_DELAY_NL, "Beste framevertraging aan het testen..."},
/* pl */ {IDGS_TESTING_BEST_FRAME_DELAY_PL, "Sprawdzam najlepsze opnienie klatek..."},
/* ru */ {IDGS_TESTING_BEST_FRAME_DELAY_RU, "Testing best frame delay..."},
/* sv */ {IDGS_TESTING_BEST_FRAME_DELAY_SV, "Testar bsta ramfrdrjning..."},
/* tr */ {IDGS_TESTING_BEST_FRAME_DELAY_TR, "En iyi frame bekleme sresi test ediliyor..."},
#endif

/* network.c */
/* en */ {IDGS_USING_D_FRAMES_DELAY,    N_("Using %d frames delay.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_USING_D_FRAMES_DELAY_DA, "Bruger %d billeders forsinkelse."},
/* de */ {IDGS_USING_D_FRAMES_DELAY_DE, "Benutze %d Frameverzgerung."},
/* es */ {IDGS_USING_D_FRAMES_DELAY_ES, "Usando %d cuadros de demora."},
/* fr */ {IDGS_USING_D_FRAMES_DELAY_FR, "Utilisation d'un dlai de %d images."},
/* hu */ {IDGS_USING_D_FRAMES_DELAY_HU, "%d kpkocka ksleltets hasznlata."},
/* it */ {IDGS_USING_D_FRAMES_DELAY_IT, "Utilizzo %d frame di ritardo."},
/* ko */ {IDGS_USING_D_FRAMES_DELAY_KO, ""},  /* fuzzy */
/* nl */ {IDGS_USING_D_FRAMES_DELAY_NL, "%d frames vertraging in gebruik."},
/* pl */ {IDGS_USING_D_FRAMES_DELAY_PL, "Uywam opnienia klatek %d."},
/* ru */ {IDGS_USING_D_FRAMES_DELAY_RU, "Using %d frames delay."},
/* sv */ {IDGS_USING_D_FRAMES_DELAY_SV, "Anvnder %d ramars frdrjning."},
/* tr */ {IDGS_USING_D_FRAMES_DELAY_TR, "%d frame bekleme sresi kullanlyor."},
#endif

/* network.c */
/* en */ {IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER,    N_("Cannot load snapshot file for transfer")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_DA, "Kunne ikke indlse snapshot til overfrsel."},
/* de */ {IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_DE, "Kann Snapshot Datei fr Transfer nicht laden"},
/* es */ {IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_ES, "No puedo cargar fichero Instantnea  para trasferencia"},
/* fr */ {IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_FR, "Impossible de charger l'instantan pour le transfer"},
/* hu */ {IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_HU, "Nem sikerlt az tkldend pillanatkp fjlt betlteni"},
/* it */ {IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_IT, "Non  possibile caricare il file di snapshot per il trasferimento"},
/* ko */ {IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_NL, "Kan het momentopnamebestand voor versturen niet laden"},
/* pl */ {IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_PL, "Nie mona wczyta pliku zrzutu do transferu"},
/* ru */ {IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_RU, "Cannot load snapshot file for transfer"},
/* sv */ {IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_SV, "Kan inte lsa in gonblicksbildfil fr verfring."},
/* tr */ {IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_TR, "Transfer iin anlk grnt dosyas yklenemedi"},
#endif

/* network.c */
/* en */ {IDGS_SENDING_SNAPSHOT_TO_CLIENT,    N_("Sending snapshot to client...")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SENDING_SNAPSHOT_TO_CLIENT_DA, "Sender snapshot til klient..."},
/* de */ {IDGS_SENDING_SNAPSHOT_TO_CLIENT_DE, "Sende Snapshot zu Client..."},
/* es */ {IDGS_SENDING_SNAPSHOT_TO_CLIENT_ES, "Remitiendo Instantnea a cliente..."},
/* fr */ {IDGS_SENDING_SNAPSHOT_TO_CLIENT_FR, "Envoi de l'instantan au client..."},
/* hu */ {IDGS_SENDING_SNAPSHOT_TO_CLIENT_HU, ""},  /* fuzzy */
/* it */ {IDGS_SENDING_SNAPSHOT_TO_CLIENT_IT, "Invio snapshot al client in corso..."},
/* ko */ {IDGS_SENDING_SNAPSHOT_TO_CLIENT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SENDING_SNAPSHOT_TO_CLIENT_NL, "Momentopname wordt naar de client verstuurd..."},
/* pl */ {IDGS_SENDING_SNAPSHOT_TO_CLIENT_PL, "Wysyam zrzut do klienta..."},
/* ru */ {IDGS_SENDING_SNAPSHOT_TO_CLIENT_RU, "Sending snapshot to client..."},
/* sv */ {IDGS_SENDING_SNAPSHOT_TO_CLIENT_SV, "Snder gonblicksbild till klient..."},
/* tr */ {IDGS_SENDING_SNAPSHOT_TO_CLIENT_TR, "Anlk grnt dosyas istemciye gnderiliyor..."},
#endif

/* network.c */
/* en */ {IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT,    N_("Cannot send snapshot to client")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_DA, "Kunne ikke sende snapshot til klient"},
/* de */ {IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_DE, "Kann Snapshot Datei nicht senden"},
/* es */ {IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_ES, "No puedo remitir Instantnea a cliente"},
/* fr */ {IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_FR, "Impossible d'envoyer l'instantan au client"},
/* hu */ {IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_HU, "Nem sikerlt pillanatkpet elkldeni a klienshez"},
/* it */ {IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_IT, "Non  possibile inviare lo snapshot al client"},
/* ko */ {IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_NL, "Kan de momentopname niet naar de client versturen"},
/* pl */ {IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_PL, "Nie mona wysa zrzutu do klienta"},
/* ru */ {IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_RU, "Cannot send snapshot to client"},
/* sv */ {IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_SV, "Kan inte snda gonblicksbild till klient"},
/* tr */ {IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_TR, "Anlk grnt dosyas istemciye gnderilemedi"},
#endif

/* network.c */
/* en */ {IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S,    N_("Cannot create snapshot file %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_DA, "Kunne ikke oprette snapshot-fil %s"},
/* de */ {IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_DE, "Kann Snapshot Datei `%s' nicht erzeugen"},
/* es */ {IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_ES, "No puedo crear fichero Instantnea %s"},
/* fr */ {IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_FR, "Impossible de crer l'instantan %s"},
/* hu */ {IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_HU, "Nem sikerlt a pillanatkpfjlt ltrehozni (%s)"},
/* it */ {IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_IT, "Non  possibile creare il file di snapshot %s"},
/* ko */ {IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_NL, "Kan het momentopnamebestand %s niet maken"},
/* pl */ {IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_PL, "Nie mona utworzy pliku zrzutu %s"},
/* ru */ {IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_RU, "Cannot create snapshot file %s"},
/* sv */ {IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_SV, "Kan inte skapa gonblicksbildfil %s"},
/* tr */ {IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_TR, "Anlk grnt dosyas %s yaratlamad"},
#endif

/* network.c */
/* en */ {IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S,    N_("Cannot open snapshot file %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_DA, "Kunne ikke bne snapshot-fil %s"},
/* de */ {IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_DE, "Kann Snapshot Datei `%s' nicht ffnen."},
/* es */ {IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_ES, "No puedo abrir fichero Instantnea %s"},
/* fr */ {IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_FR, "Impossible d'ouvrir le fichier %s"},
/* hu */ {IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_HU, "Nem sikerlt a pillanatkpfjlt megnyitni (%s)"},
/* it */ {IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_IT, "Non  possibile aprire il file di snapshot %s"},
/* ko */ {IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_NL, "Kan het momentopnamebestand %s niet openen"},
/* pl */ {IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_PL, "Nie mona otworzy pliku zrzutu %s"},
/* ru */ {IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_RU, "Cannot open snapshot file %s"},
/* sv */ {IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_SV, "Kan inte ppna gonblicksbildfil %s"},
/* tr */ {IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_TR, "Anlk grnt dosyas %s alamad"},
#endif

/* network.c */
/* en */ {IDGS_SERVER_IS_WAITING_FOR_CLIENT,    N_("Server is waiting for a client...")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SERVER_IS_WAITING_FOR_CLIENT_DA, "Server venter p en klient..."},
/* de */ {IDGS_SERVER_IS_WAITING_FOR_CLIENT_DE, "Server wartet auf Client..."},
/* es */ {IDGS_SERVER_IS_WAITING_FOR_CLIENT_ES, "El servidor est esperando al cliente..."},
/* fr */ {IDGS_SERVER_IS_WAITING_FOR_CLIENT_FR, "Le serveur attend un client..."},
/* hu */ {IDGS_SERVER_IS_WAITING_FOR_CLIENT_HU, ""},  /* fuzzy */
/* it */ {IDGS_SERVER_IS_WAITING_FOR_CLIENT_IT, "Il server  in attesa di un client..."},
/* ko */ {IDGS_SERVER_IS_WAITING_FOR_CLIENT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SERVER_IS_WAITING_FOR_CLIENT_NL, "Server wacht op een client..."},
/* pl */ {IDGS_SERVER_IS_WAITING_FOR_CLIENT_PL, "Serwer czeka na klienta..."},
/* ru */ {IDGS_SERVER_IS_WAITING_FOR_CLIENT_RU, "Server is waiting for a client..."},
/* sv */ {IDGS_SERVER_IS_WAITING_FOR_CLIENT_SV, "Servern vntar p en klient..."},
/* tr */ {IDGS_SERVER_IS_WAITING_FOR_CLIENT_TR, "Sunucu bir istemcinin balanmas iin bekliyor..."},
#endif

/* network.c */
/* en */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT,    N_("Cannot create snapshot file. Select different history directory!")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_DA, "Kunne ikke oprette snapshot-fil. Vlg et andet historik-katalog!"},
/* de */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_DE, "Kann Snapshot Datei nicht erzeugen. Verwende ein anderes Verzeichnis!"},
/* es */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_ES, "No puedo crear fichero Instantnea. Seleccionar diferente directorio histrico!"},
/* fr */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_FR, "Impossible de crer le fichier d'instantan. Slectionnez un rpertoire d'historique diffrent"},
/* hu */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_HU, "Nem sikerlt pillanatkp fjlt ltrehozni. Krem vlasszon ms knyvtrat!"},
/* it */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_IT, "Non  possibile creare il file di snapshot. Seleziona una directory diversa per la cronologia."},
/* ko */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_NL, "Kan het momentopnamebestand niet maken. Selecteer een andere geschiedenismap!"},
/* pl */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_PL, "Nie mona utworzy pliku zrzutu. Wybierz inny katalog historii!"},
/* ru */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_RU, "Cannot create snapshot file. Select different history directory!"},
/* sv */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_SV, "Kan inte skapa gonblicksbildfil. Vlj en annan historikkatalog!"},
/* tr */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_TR, "Anlk grnt dosyas yaratlamad. Farkl bir tarihe dizini sein!"},
#endif

/* network.c */
/* en */ {IDGS_CANNOT_RESOLVE_S,    N_("Cannot resolve %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_RESOLVE_S_DA, "Kan ikke opsl %s"},
/* de */ {IDGS_CANNOT_RESOLVE_S_DE, "Kann %s nicht auflsen"},
/* es */ {IDGS_CANNOT_RESOLVE_S_ES, "No puedo resolver %s"},
/* fr */ {IDGS_CANNOT_RESOLVE_S_FR, "Impossible de rsoudre %s"},
/* hu */ {IDGS_CANNOT_RESOLVE_S_HU, "Nem sikerlt %s-t feloldani"},
/* it */ {IDGS_CANNOT_RESOLVE_S_IT, "Non  possibile risolvere %s"},
/* ko */ {IDGS_CANNOT_RESOLVE_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_RESOLVE_S_NL, "Onbekende host %s"},
/* pl */ {IDGS_CANNOT_RESOLVE_S_PL, "Nie mona znale %s"},
/* ru */ {IDGS_CANNOT_RESOLVE_S_RU, "Cannot resolve %s"},
/* sv */ {IDGS_CANNOT_RESOLVE_S_SV, "Kan inte sl upp %s"},
/* tr */ {IDGS_CANNOT_RESOLVE_S_TR, "%s zlemedi"},
#endif

/* network.c */
/* en */ {IDGS_CANNOT_CONNECT_TO_S,    N_("Cannot connect to %s (no server running on port %d).")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_CONNECT_TO_S_DA, "Kan ikke forbinde til %s (ingen server p port %d)."},
/* de */ {IDGS_CANNOT_CONNECT_TO_S_DE, "Kann zu %s nicht verbinden (Kein Server aktiv auf Port %d)."},
/* es */ {IDGS_CANNOT_CONNECT_TO_S_ES, "No puedo conectar a  %s (Ningn servidor en puerto %d)."},
/* fr */ {IDGS_CANNOT_CONNECT_TO_S_FR, "Impossible de se connecter  %s (aucun serveur sur le port %d)."},
/* hu */ {IDGS_CANNOT_CONNECT_TO_S_HU, "Nem sikerlt %s-hez kapcsoldni (a %d porton nem fut kiszolgl)"},
/* it */ {IDGS_CANNOT_CONNECT_TO_S_IT, "Non  possibile connettersi a %s (nessun server  attivo sulla porta %d)."},
/* ko */ {IDGS_CANNOT_CONNECT_TO_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_CONNECT_TO_S_NL, "Kan geen verbinding maken met %s (er is geen server aanwezig op poort %d)."},
/* pl */ {IDGS_CANNOT_CONNECT_TO_S_PL, "Nie mona podczy do %s (na porcie %d nie dziaa aden serwer)."},
/* ru */ {IDGS_CANNOT_CONNECT_TO_S_RU, "Cannot connect to %s (no server running on port %d)."},
/* sv */ {IDGS_CANNOT_CONNECT_TO_S_SV, "Kan inte ansluta till %s (ingen server igng p port %d)."},
/* tr */ {IDGS_CANNOT_CONNECT_TO_S_TR, "%s balants kurulamad (port %d zerinde alan sunucu yok)."},
#endif

/* network.c */
/* en */ {IDGS_RECEIVING_SNAPSHOT_SERVER,    N_("Receiving snapshot from server...")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_RECEIVING_SNAPSHOT_SERVER_DA, "Modtager snapshot fra server..."},
/* de */ {IDGS_RECEIVING_SNAPSHOT_SERVER_DE, "Empfange Snapshot von Server..."},
/* es */ {IDGS_RECEIVING_SNAPSHOT_SERVER_ES, "Recibiendo Instantnea desde el servidor..."},
/* fr */ {IDGS_RECEIVING_SNAPSHOT_SERVER_FR, "Rception de l'instantan du serveur..."},
/* hu */ {IDGS_RECEIVING_SNAPSHOT_SERVER_HU, ""},  /* fuzzy */
/* it */ {IDGS_RECEIVING_SNAPSHOT_SERVER_IT, "Ricezione dello snapshot dal server in corso..."},
/* ko */ {IDGS_RECEIVING_SNAPSHOT_SERVER_KO, ""},  /* fuzzy */
/* nl */ {IDGS_RECEIVING_SNAPSHOT_SERVER_NL, "Momentopname van de server wordt ontvangen..."},
/* pl */ {IDGS_RECEIVING_SNAPSHOT_SERVER_PL, "Odbieranie zrzutu z serwera..."},
/* ru */ {IDGS_RECEIVING_SNAPSHOT_SERVER_RU, "Receiving snapshot from server..."},
/* sv */ {IDGS_RECEIVING_SNAPSHOT_SERVER_SV, "Tar emot goblicksbild frn server..."},
/* tr */ {IDGS_RECEIVING_SNAPSHOT_SERVER_TR, "Sunucudan anlk grnt alnyor..."},
#endif

/* network.c */
/* en */ {IDGS_NETWORK_OUT_OF_SYNC,    N_("Network out of sync - disconnecting.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_NETWORK_OUT_OF_SYNC_DA, "Netvrk ude af synk - afbryder forbindelsen."},
/* de */ {IDGS_NETWORK_OUT_OF_SYNC_DE, "Netzwerksynchronisationsproblem - Trenne Verbindung."},
/* es */ {IDGS_NETWORK_OUT_OF_SYNC_ES, "Red fuera de sincrona - desconectando."},
/* fr */ {IDGS_NETWORK_OUT_OF_SYNC_FR, "Le rseau n'est pas synchronis (out of sync error). Dconnexion."},
/* hu */ {IDGS_NETWORK_OUT_OF_SYNC_HU, "A hlzat kiesett a szinkronbl - sztkapcsolds"},
/* it */ {IDGS_NETWORK_OUT_OF_SYNC_IT, "Rete non sincronizzata - disconnesione in corso."},
/* ko */ {IDGS_NETWORK_OUT_OF_SYNC_KO, ""},  /* fuzzy */
/* nl */ {IDGS_NETWORK_OUT_OF_SYNC_NL, "Netwerk niet synchroon - verbinding wordt verbroken."},
/* pl */ {IDGS_NETWORK_OUT_OF_SYNC_PL, "Desynchronizacja sieci - rozczam."},
/* ru */ {IDGS_NETWORK_OUT_OF_SYNC_RU, "Network out of sync - disconnecting."},
/* sv */ {IDGS_NETWORK_OUT_OF_SYNC_SV, "Ntverket ur synk - kopplar frn."},
/* tr */ {IDGS_NETWORK_OUT_OF_SYNC_TR, "A senkronizasyonu bozuldu - balant kesiliyor."},
#endif

/* network.c */
/* en */ {IDGS_REMOTE_HOST_DISCONNECTED,    N_("Remote host disconnected.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_REMOTE_HOST_DISCONNECTED_DA, "Fjernmaskine afbrudt."},
/* de */ {IDGS_REMOTE_HOST_DISCONNECTED_DE, "Entfernter Rechner getrennt."},
/* es */ {IDGS_REMOTE_HOST_DISCONNECTED_ES, "Host Remoto desconectado."},
/* fr */ {IDGS_REMOTE_HOST_DISCONNECTED_FR, "L'hte distant s'est dconnect."},
/* hu */ {IDGS_REMOTE_HOST_DISCONNECTED_HU, "A tvoli szmtogp lekapcsoldott."},
/* it */ {IDGS_REMOTE_HOST_DISCONNECTED_IT, "Host remoto disconnesso."},
/* ko */ {IDGS_REMOTE_HOST_DISCONNECTED_KO, ""},  /* fuzzy */
/* nl */ {IDGS_REMOTE_HOST_DISCONNECTED_NL, "De andere computer heeft de verbinding verbroken."},
/* pl */ {IDGS_REMOTE_HOST_DISCONNECTED_PL, "Zdalny host rozczy si."},
/* ru */ {IDGS_REMOTE_HOST_DISCONNECTED_RU, "Remote host disconnected."},
/* sv */ {IDGS_REMOTE_HOST_DISCONNECTED_SV, "Frnkopplad frn fjrrvrd."},
/* tr */ {IDGS_REMOTE_HOST_DISCONNECTED_TR, "Uzak sunucu balants kesildi."},
#endif

/* network.c */
/* en */ {IDGS_REMOTE_HOST_SUSPENDING,    N_("Remote host suspending...")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_REMOTE_HOST_SUSPENDING_DA, "Fjernmaskine pauser..."},
/* de */ {IDGS_REMOTE_HOST_SUSPENDING_DE, "Entfernter Rechner angehaltedn..."},
/* es */ {IDGS_REMOTE_HOST_SUSPENDING_ES, "Host remoto suspendido..."},
/* fr */ {IDGS_REMOTE_HOST_SUSPENDING_FR, "L'hte distant  suspendu..."},
/* hu */ {IDGS_REMOTE_HOST_SUSPENDING_HU, ""},  /* fuzzy */
/* it */ {IDGS_REMOTE_HOST_SUSPENDING_IT, "Sospesione host remoto in corso..."},
/* ko */ {IDGS_REMOTE_HOST_SUSPENDING_KO, ""},  /* fuzzy */
/* nl */ {IDGS_REMOTE_HOST_SUSPENDING_NL, "De andere computer onderbreekt de netplay..."},
/* pl */ {IDGS_REMOTE_HOST_SUSPENDING_PL, "Zawieszenie zdalnego hosta...."},
/* ru */ {IDGS_REMOTE_HOST_SUSPENDING_RU, "Remote host suspending..."},
/* sv */ {IDGS_REMOTE_HOST_SUSPENDING_SV, "FJrrvrden pausar..."},
/* tr */ {IDGS_REMOTE_HOST_SUSPENDING_TR, "Uzak sunucu askda..."},
#endif
#endif

/* gfxoutputdrv/ffmpegdrv.c */
/* en */ {IDGS_FFMPEG_CANNOT_OPEN_VSTREAM,    N_("ffmpegdrv: Cannot open video stream")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_DA, "ffmpegdrv: Kan ikke bne video-strm"},
/* de */ {IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_DE, "ffmpegdrv: Kann video stream nicht ffnen"},
/* es */ {IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_ES, "ffmpegdrv: no puedo abrir vdeo stream"},
/* fr */ {IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_FR, "ffmpegdrv: Impossible d'ouvrir le flux vido"},
/* hu */ {IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_HU, "ffmpegdrv: Nem sikerlt megnyitni a vide adatfolyamot"},
/* it */ {IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_IT, "ffmpegdrv: Non  possibile aprire il flusso video"},
/* ko */ {IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_KO, ""},  /* fuzzy */
/* nl */ {IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_NL, "ffmpegdrv: Kan videostroom niet openen"},
/* pl */ {IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_PL, "ffmpegdrv: Nie mona otworzy strumienia wideo"},
/* ru */ {IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_RU, "ffmpegdrv:     "},
/* sv */ {IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_SV, "ffmpegdrv: Kan inte ppna videostrm"},
/* tr */ {IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_TR, "ffmpegdrv: Grnt ak alamad"},
#endif

/* gfxoutputdrv/ffmpegdrv.c */
/* en */ {IDGS_FFMPEG_CANNOT_OPEN_ASTREAM,    N_("ffmpegdrv: Cannot open audio stream")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_DA, "ffmpegdrv: Kan ikke bne lyd-strm"},
/* de */ {IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_DE, "ffmpegdrv: Kann audio stream nicht ffnen"},
/* es */ {IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_ES, "ffmpegdrv: No puedo abrir audio stream"},
/* fr */ {IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_FR, "ffmpegdrv: Impossible d'ouvrir le flux audio"},
/* hu */ {IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_HU, "ffmpegdrv: Nem sikerlt megnyitni a audi adatfolyamot"},
/* it */ {IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_IT, "ffmpegdrv: Non  possibile aprire il flusso audio"},
/* ko */ {IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_KO, ""},  /* fuzzy */
/* nl */ {IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_NL, "ffmpegdrv: Kan audiostroom niet openen"},
/* pl */ {IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_PL, "ffmpegdrv: Nie mona otworzy strumienia audio"},
/* ru */ {IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_RU, "ffmpegdrv:     "},
/* sv */ {IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_SV, "ffmpegdrv: Kan inte ppna ljudstrm"},
/* tr */ {IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_TR, "ffmpegdrv: Ses ak alamad"},
#endif

/* gfxoutputdrv/ffmpegdrv.c */
/* en */ {IDGS_FFMPEG_CANNOT_OPEN_S,    N_("ffmpegdrv: Cannot open %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_FFMPEG_CANNOT_OPEN_S_DA, "ffmpegdrv: Kan ikke bne %s"},
/* de */ {IDGS_FFMPEG_CANNOT_OPEN_S_DE, "ffmpegdrv: ffnen von %s fehlgeschlagen"},
/* es */ {IDGS_FFMPEG_CANNOT_OPEN_S_ES, "ffmpegdrv: No puedo abrir %s"},
/* fr */ {IDGS_FFMPEG_CANNOT_OPEN_S_FR, "ffmpegdrv: Impossible d'ouvrir %s"},
/* hu */ {IDGS_FFMPEG_CANNOT_OPEN_S_HU, "ffmpegdrv: Nem sikerlt megnyitni: %s"},
/* it */ {IDGS_FFMPEG_CANNOT_OPEN_S_IT, "ffmpegdrv: Non  possibile aprire %s"},
/* ko */ {IDGS_FFMPEG_CANNOT_OPEN_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_FFMPEG_CANNOT_OPEN_S_NL, "ffmpegdrv: Kan %s niet openen"},
/* pl */ {IDGS_FFMPEG_CANNOT_OPEN_S_PL, "ffmpegdrv: Nie mona otworzy %s"},
/* ru */ {IDGS_FFMPEG_CANNOT_OPEN_S_RU, "ffmpegdrv: Cannot open %s"},
/* sv */ {IDGS_FFMPEG_CANNOT_OPEN_S_SV, "ffmpegdrv: Kan inte ppna %s"},
/* tr */ {IDGS_FFMPEG_CANNOT_OPEN_S_TR, "ffmpegdrv: %s alamad"},
#endif

/* c64/c64io.c, vic20/vic20io.c */
/* en */ {IDGS_IO_READ_COLL_AT_X_FROM,    N_("I/O read collision at %X from ")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_IO_READ_COLL_AT_X_FROM_DA, "I/O-lsekollision ved %X fra "},
/* de */ {IDGS_IO_READ_COLL_AT_X_FROM_DE, "I/O Lese Kollision bei %X von "},
/* es */ {IDGS_IO_READ_COLL_AT_X_FROM_ES, "Entrada/Salida real colisin en %X para"},
/* fr */ {IDGS_IO_READ_COLL_AT_X_FROM_FR, "Collision lors de la lecture E/S at %X  partir de "},
/* hu */ {IDGS_IO_READ_COLL_AT_X_FROM_HU, ""},  /* fuzzy */
/* it */ {IDGS_IO_READ_COLL_AT_X_FROM_IT, "Collisione di I/O in lettura a %X da "},
/* ko */ {IDGS_IO_READ_COLL_AT_X_FROM_KO, ""},  /* fuzzy */
/* nl */ {IDGS_IO_READ_COLL_AT_X_FROM_NL, "I/O lees conflict op %X van "},
/* pl */ {IDGS_IO_READ_COLL_AT_X_FROM_PL, "Kolizja odczytu we/wy w %X z"},
/* ru */ {IDGS_IO_READ_COLL_AT_X_FROM_RU, "I/O read collision at %X from "},
/* sv */ {IDGS_IO_READ_COLL_AT_X_FROM_SV, "I/O-lskollision vid %X frn "},
/* tr */ {IDGS_IO_READ_COLL_AT_X_FROM_TR, "G/ okuma akmas %X'de "},
#endif

/* c64/c64io.c, vic20/vic20io.c */
/* en */ {IDGS_AND,    N_(" and ")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_AND_DA, " og "},
/* de */ {IDGS_AND_DE, " und "},
/* es */ {IDGS_AND_ES, " y "},
/* fr */ {IDGS_AND_FR, " et "},
/* hu */ {IDGS_AND_HU, ""},  /* fuzzy */
/* it */ {IDGS_AND_IT, " e "},
/* ko */ {IDGS_AND_KO, " ׸ "},
/* nl */ {IDGS_AND_NL, " en "},
/* pl */ {IDGS_AND_PL, "i"},
/* ru */ {IDGS_AND_RU, ""},
/* sv */ {IDGS_AND_SV, " och "},
/* tr */ {IDGS_AND_TR, " ve "},
#endif

/* c64/c64io.c, vic20/vic20io.c */
/* en */ {IDGS_ALL_DEVICES_DETACHED,    N_(".\nAll the named devices will be detached.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ALL_DEVICES_DETACHED_DA, ".\nAlle de navngivne enheder vil blive frakoblet."},
/* de */ {IDGS_ALL_DEVICES_DETACHED_DE, ".\nAlle genannten Gerte werden entfernt."},
/* es */ {IDGS_ALL_DEVICES_DETACHED_ES, ".\nTodos los perifricos nombrados se desconectarn."},
/* fr */ {IDGS_ALL_DEVICES_DETACHED_FR, ".\nTous les priphriques nomms vont tre dtachs."},
/* hu */ {IDGS_ALL_DEVICES_DETACHED_HU, ".\nMinden megnevezett eszkz le lesz vlasztva."},
/* it */ {IDGS_ALL_DEVICES_DETACHED_IT, ".\nTutti i device specificati sarranno rimossi."},
/* ko */ {IDGS_ALL_DEVICES_DETACHED_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ALL_DEVICES_DETACHED_NL, ".\nAlle genoemde apparaten zullen worden ontkoppeld."},
/* pl */ {IDGS_ALL_DEVICES_DETACHED_PL, ".\nWszystkie wymienione urzdzenia zostan odmontowane."},
/* ru */ {IDGS_ALL_DEVICES_DETACHED_RU, ".\nAll the named devices will be detached."},
/* sv */ {IDGS_ALL_DEVICES_DETACHED_SV, ".\nAlla namngivna enheter kommer kopplas frn."},
/* tr */ {IDGS_ALL_DEVICES_DETACHED_TR, ".\nTm isimlendirilmi aygtlar kartlacaktr."},
#endif

/* c64/c64io.c, vic20/vic20io.c */
/* en */ {IDGS_ALL_DEVICES_EXCEPT,    N_(".\nAll devices except ")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ALL_DEVICES_EXCEPT_DA, ".\nAlle enheder undtagen "},
/* de */ {IDGS_ALL_DEVICES_EXCEPT_DE, ".\nAlle Gerte auer "},
/* es */ {IDGS_ALL_DEVICES_EXCEPT_ES, ".\nTodos los perifricos excepto"},
/* fr */ {IDGS_ALL_DEVICES_EXCEPT_FR, ".\nTous priphriques except  "},
/* hu */ {IDGS_ALL_DEVICES_EXCEPT_HU, ""},  /* fuzzy */
/* it */ {IDGS_ALL_DEVICES_EXCEPT_IT, ".\nTutti i device tranne "},
/* ko */ {IDGS_ALL_DEVICES_EXCEPT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ALL_DEVICES_EXCEPT_NL, ".\nAlle apparaten behalve "},
/* pl */ {IDGS_ALL_DEVICES_EXCEPT_PL, ".\nWszystkie urzdzenia, prcz"},
/* ru */ {IDGS_ALL_DEVICES_EXCEPT_RU, ".\nAll devices except "},
/* sv */ {IDGS_ALL_DEVICES_EXCEPT_SV, ".\nAlla enheter frutom "},
/* tr */ {IDGS_ALL_DEVICES_EXCEPT_TR, ".\nBunlar hari tm cihazlar "},
#endif

/* c64/c64io.c, vic20/vic20io.c */
/* en */ {IDGS_WILL_BE_DETACHED,    N_(" will be detached.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_WILL_BE_DETACHED_DA, " vil blive frakoblet."},
/* de */ {IDGS_WILL_BE_DETACHED_DE, " werden entfernt."},
/* es */ {IDGS_WILL_BE_DETACHED_ES, "se desconectarn"},
/* fr */ {IDGS_WILL_BE_DETACHED_FR, " vont tre dtachs."},
/* hu */ {IDGS_WILL_BE_DETACHED_HU, ""},  /* fuzzy */
/* it */ {IDGS_WILL_BE_DETACHED_IT, "sarranno rimossi."},
/* ko */ {IDGS_WILL_BE_DETACHED_KO, ""},  /* fuzzy */
/* nl */ {IDGS_WILL_BE_DETACHED_NL, " zullen worden ontkoppeld."},
/* pl */ {IDGS_WILL_BE_DETACHED_PL, " zostanie rozczone."},
/* ru */ {IDGS_WILL_BE_DETACHED_RU, ""},  /* fuzzy */
/* sv */ {IDGS_WILL_BE_DETACHED_SV, " kommer kopplas frn."},
/* tr */ {IDGS_WILL_BE_DETACHED_TR, " haricindeki tm cihazlar kartlacaktr."},
#endif

/* c64dtv/c64dtvflash.c */
/* en */ {IDGS_NO_FILENAME,    N_("No filename!")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_NO_FILENAME_DA, "Intet filnavn!"},
/* de */ {IDGS_NO_FILENAME_DE, "Dateiname fehlt!"},
/* es */ {IDGS_NO_FILENAME_ES, "Sin nombre de fichero!"},
/* fr */ {IDGS_NO_FILENAME_FR, "Aucun fichier!"},
/* hu */ {IDGS_NO_FILENAME_HU, "Nincs fjlnv!"},
/* it */ {IDGS_NO_FILENAME_IT, "Nessun nome file!"},
/* ko */ {IDGS_NO_FILENAME_KO, ""},  /* fuzzy */
/* nl */ {IDGS_NO_FILENAME_NL, "Geen bestandsnaam!"},
/* pl */ {IDGS_NO_FILENAME_PL, "Brak nazwy pliku!"},
/* ru */ {IDGS_NO_FILENAME_RU, "  !"},
/* sv */ {IDGS_NO_FILENAME_SV, "Filnamn saknas!"},
/* tr */ {IDGS_NO_FILENAME_TR, "Dosya ismi yok!"},
#endif

/* c64dtv/c64dtvflash.c */
/* en */ {IDGS_ILLEGAL_FILENAME,    N_("Illegal filename!")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ILLEGAL_FILENAME_DA, "Ugyldigt filnavn!"},
/* de */ {IDGS_ILLEGAL_FILENAME_DE, "Ungltiger Dateiname!"},
/* es */ {IDGS_ILLEGAL_FILENAME_ES, "Nombre fichero ilegal!"},
/* fr */ {IDGS_ILLEGAL_FILENAME_FR, "Nom de fichier illgal!"},
/* hu */ {IDGS_ILLEGAL_FILENAME_HU, "rvnytelen fjlnv!"},
/* it */ {IDGS_ILLEGAL_FILENAME_IT, "Nome file non valido!"},
/* ko */ {IDGS_ILLEGAL_FILENAME_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ILLEGAL_FILENAME_NL, "Bestandsnaam ongeldig!"},
/* pl */ {IDGS_ILLEGAL_FILENAME_PL, "Za nazwa pliku!"},
/* ru */ {IDGS_ILLEGAL_FILENAME_RU, "Illegal filename!"},
/* sv */ {IDGS_ILLEGAL_FILENAME_SV, "Ogiltigt filnamn!"},
/* tr */ {IDGS_ILLEGAL_FILENAME_TR, "Kural d dosya ismi!"},
#endif

/* c64dtv/c64dtvflash.c */
/* en */ {IDGS_ERROR_CREATING_FILE_S,    N_("Error creating file %s!")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ERROR_CREATING_FILE_S_DA, "Fejl under oprettelse af filen %s!"},
/* de */ {IDGS_ERROR_CREATING_FILE_S_DE, "Fehler beim Schreiben: %s."},
/* es */ {IDGS_ERROR_CREATING_FILE_S_ES, "Error creando fichero %s!"},
/* fr */ {IDGS_ERROR_CREATING_FILE_S_FR, "Erreur lors de la cration du fichier %s!"},
/* hu */ {IDGS_ERROR_CREATING_FILE_S_HU, "Hiba %s fjl ltrehozsa kzben!"},
/* it */ {IDGS_ERROR_CREATING_FILE_S_IT, "Errore durante la creazione del file %s!"},
/* ko */ {IDGS_ERROR_CREATING_FILE_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ERROR_CREATING_FILE_S_NL, "Fout bij het maken van bestand %s!"},
/* pl */ {IDGS_ERROR_CREATING_FILE_S_PL, "Bd tworzenia pliku %s!"},
/* ru */ {IDGS_ERROR_CREATING_FILE_S_RU, "Error creating file %s!"},
/* sv */ {IDGS_ERROR_CREATING_FILE_S_SV, "Fel nr filen \"%s\" skulle skapas!"},
/* tr */ {IDGS_ERROR_CREATING_FILE_S_TR, "%s dosyas yaratlrken hata olutu!"},
#endif

/* c64dtv/c64dtvflash.c */
/* en */ {IDGS_ERROR_WRITING_TO_FILE_S,    N_("Error writing to file %s!")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ERROR_WRITING_TO_FILE_S_DA, "Fejl ved skrivning til filen %s!"},
/* de */ {IDGS_ERROR_WRITING_TO_FILE_S_DE, "Fehler bei Schreibzugriff: %s!"},
/* es */ {IDGS_ERROR_WRITING_TO_FILE_S_ES, "Error grabando fichero %s!"},
/* fr */ {IDGS_ERROR_WRITING_TO_FILE_S_FR, "Erreur lors de l'criture dans le fichier %s!"},
/* hu */ {IDGS_ERROR_WRITING_TO_FILE_S_HU, "Hiba %s fjlba rs kzben!"},
/* it */ {IDGS_ERROR_WRITING_TO_FILE_S_IT, "Errore durante la scrittura sul file %s!"},
/* ko */ {IDGS_ERROR_WRITING_TO_FILE_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ERROR_WRITING_TO_FILE_S_NL, "Fout bij het schrijven naar bestand %s!"},
/* pl */ {IDGS_ERROR_WRITING_TO_FILE_S_PL, "Bd zapisu do pliku %s!"},
/* ru */ {IDGS_ERROR_WRITING_TO_FILE_S_RU, "Error writing to file %s!"},
/* sv */ {IDGS_ERROR_WRITING_TO_FILE_S_SV, "Fel vid skrivning till filen %s!"},
/* tr */ {IDGS_ERROR_WRITING_TO_FILE_S_TR, "%s dosyasna yazlrken hata olutu!"},
#endif

/* c64dtv/c64dtvflash.c */
/* en */ {IDGS_DTV_ROM_CREATED,    N_("DTV ROM image created successfully")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_DTV_ROM_CREATED_DA, "DTV-ROM-image oprettet med success"},
/* de */ {IDGS_DTV_ROM_CREATED_DE, "DTV ROM Image erfolgreich erzeugt"},
/* es */ {IDGS_DTV_ROM_CREATED_ES, "Imagen DTV ROM creada con xito"},
/* fr */ {IDGS_DTV_ROM_CREATED_FR, "Image ROM DTV cre correctement"},
/* hu */ {IDGS_DTV_ROM_CREATED_HU, "DTV ROM kpms sikeresen ltrehozva"},
/* it */ {IDGS_DTV_ROM_CREATED_IT, "Immagine ROM DTV creata con successo"},
/* ko */ {IDGS_DTV_ROM_CREATED_KO, ""},  /* fuzzy */
/* nl */ {IDGS_DTV_ROM_CREATED_NL, "DTV ROM bestand gemaakt!"},
/* pl */ {IDGS_DTV_ROM_CREATED_PL, "Z powodzeniem utworzono obraz ROM DTV"},
/* ru */ {IDGS_DTV_ROM_CREATED_RU, " DTV ROM  "},
/* sv */ {IDGS_DTV_ROM_CREATED_SV, "DTV-ROM-avbildning skapades framgngsrikt"},
/* tr */ {IDGS_DTV_ROM_CREATED_TR, "DTV ROM imaj baaryla oluturuldu"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_TYPE,    N_("Type")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_TYPE_DA, "Type"},
/* de */ {IDGS_TYPE_DE, "Typ"},
/* es */ {IDGS_TYPE_ES, "Tipo"},
/* fr */ {IDGS_TYPE_FR, "type"},
/* hu */ {IDGS_TYPE_HU, "Tpus"},
/* it */ {IDGS_TYPE_IT, "Tipo"},
/* ko */ {IDGS_TYPE_KO, ""},
/* nl */ {IDGS_TYPE_NL, "Soort"},
/* pl */ {IDGS_TYPE_PL, "Typ"},
/* ru */ {IDGS_TYPE_RU, "Type"},
/* sv */ {IDGS_TYPE_SV, "Typ"},
/* tr */ {IDGS_TYPE_TR, "Tip"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_COMMAND_S_UNKNOWN,    N_("Command `%s' unknown.\n")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_COMMAND_S_UNKNOWN_DA, "Ukendt kommando \"%s\".\n"},
/* de */ {IDGS_COMMAND_S_UNKNOWN_DE, "Kommand `%s' ist unbekannt.\n"},
/* es */ {IDGS_COMMAND_S_UNKNOWN_ES, "Comando `%s' desconocido.\n"},
/* fr */ {IDGS_COMMAND_S_UNKNOWN_FR, "Commande `%s' inconnue.\n"},
/* hu */ {IDGS_COMMAND_S_UNKNOWN_HU, "`%s' parancs ismeretlen.\n"},
/* it */ {IDGS_COMMAND_S_UNKNOWN_IT, "Comando `%s' sconosciuto.\n"},
/* ko */ {IDGS_COMMAND_S_UNKNOWN_KO, ""},  /* fuzzy */
/* nl */ {IDGS_COMMAND_S_UNKNOWN_NL, "Commando `%s' is onbekend.\n"},
/* pl */ {IDGS_COMMAND_S_UNKNOWN_PL, "Polecenie `%s' nieznane.\n"},
/* ru */ {IDGS_COMMAND_S_UNKNOWN_RU, "Command `%s' unknown.\n"},
/* sv */ {IDGS_COMMAND_S_UNKNOWN_SV, "Kommandot \"%s\" r oknt.\n"},
/* tr */ {IDGS_COMMAND_S_UNKNOWN_TR, "`%s' komutu bilinmiyor.\n"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_NO_HELP_AVAILABLE_FOR_S,    N_("No help available for `%s'\n")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_NO_HELP_AVAILABLE_FOR_S_DA, "Ingen hjlp tilgngelig for \"%s\"\n"},
/* de */ {IDGS_NO_HELP_AVAILABLE_FOR_S_DE, "Es ist keine Hilfe fr `%s' verfgbar\n"},
/* es */ {IDGS_NO_HELP_AVAILABLE_FOR_S_ES, "Sin ayuda disponible para `%s'\n"},
/* fr */ {IDGS_NO_HELP_AVAILABLE_FOR_S_FR, "Aucune aide  propos de`%s'\n"},
/* hu */ {IDGS_NO_HELP_AVAILABLE_FOR_S_HU, "Nincs sg a `%s' parancshoz\n"},
/* it */ {IDGS_NO_HELP_AVAILABLE_FOR_S_IT, "Nessun help disponibile per `%s'\n"},
/* ko */ {IDGS_NO_HELP_AVAILABLE_FOR_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_NO_HELP_AVAILABLE_FOR_S_NL, "Geen hulp beschikbaar voor `%s'\n"},
/* pl */ {IDGS_NO_HELP_AVAILABLE_FOR_S_PL, "Pomoc dla '%s' niedostpna\n"},
/* ru */ {IDGS_NO_HELP_AVAILABLE_FOR_S_RU, "No help available for `%s'\n"},
/* sv */ {IDGS_NO_HELP_AVAILABLE_FOR_S_SV, "Hjlp saknas fr \"%s\"\n"},
/* tr */ {IDGS_NO_HELP_AVAILABLE_FOR_S_TR, "`%s' iin mevcut bir yardm metni yok\n"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_SYNTAX_S_S,    N_("\nSyntax: %s %s\n")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SYNTAX_S_S_DA, "\nSyntax: %s %s\n"},
/* de */ {IDGS_SYNTAX_S_S_DE, "\nSyntax: %s %s\n"},
/* es */ {IDGS_SYNTAX_S_S_ES, "\nSintaxis: %s %s\n"},
/* fr */ {IDGS_SYNTAX_S_S_FR, "\nSyntaxe: %s %s\n"},
/* hu */ {IDGS_SYNTAX_S_S_HU, "\nSzintaxis: %s %s\n"},
/* it */ {IDGS_SYNTAX_S_S_IT, "\nSintassi: %s %s\n"},
/* ko */ {IDGS_SYNTAX_S_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SYNTAX_S_S_NL, "\nSyntaxis: %s %s\n"},
/* pl */ {IDGS_SYNTAX_S_S_PL, "\nSkadnia: %s %s\n"},
/* ru */ {IDGS_SYNTAX_S_S_RU, "\nSyntax: %s %s\n"},
/* sv */ {IDGS_SYNTAX_S_S_SV, "\nSyntax: %s %s\n"},
/* tr */ {IDGS_SYNTAX_S_S_TR, "\nSzdizimi: %s %s\n"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_ABBREVIATION_S,    N_("Abbreviation: %s\n")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ABBREVIATION_S_DA, "Forkortelse: %s\n"},
/* de */ {IDGS_ABBREVIATION_S_DE, "Abkrzung: %s\n"},
/* es */ {IDGS_ABBREVIATION_S_ES, "Abreviacin: %s\n"},
/* fr */ {IDGS_ABBREVIATION_S_FR, "Abbrviation: %s\n"},
/* hu */ {IDGS_ABBREVIATION_S_HU, "Rvidts: %s\n"},
/* it */ {IDGS_ABBREVIATION_S_IT, "Abbreviazione: %s\n"},
/* ko */ {IDGS_ABBREVIATION_S_KO, ": %s\n"},
/* nl */ {IDGS_ABBREVIATION_S_NL, "Afkorting: %s\n"},
/* pl */ {IDGS_ABBREVIATION_S_PL, "Skrt: %s\n"},
/* ru */ {IDGS_ABBREVIATION_S_RU, "Abbreviation: %s\n"},
/* sv */ {IDGS_ABBREVIATION_S_SV, "Frkortning: %s\n"},
/* tr */ {IDGS_ABBREVIATION_S_TR, "Ksaltma: %s\n"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_AVAILABLE_COMMANDS_ARE,    N_("Available commands are:")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_AVAILABLE_COMMANDS_ARE_DA, "Tilgngelige kommandoer:"},
/* de */ {IDGS_AVAILABLE_COMMANDS_ARE_DE, "Zulssige Kommandos sind:"},
/* es */ {IDGS_AVAILABLE_COMMANDS_ARE_ES, "Los comandos disponibles son:"},
/* fr */ {IDGS_AVAILABLE_COMMANDS_ARE_FR, "Les commandes disponibles sont:"},
/* hu */ {IDGS_AVAILABLE_COMMANDS_ARE_HU, ""},  /* fuzzy */
/* it */ {IDGS_AVAILABLE_COMMANDS_ARE_IT, "I comandi disponibili sono:"},
/* ko */ {IDGS_AVAILABLE_COMMANDS_ARE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_AVAILABLE_COMMANDS_ARE_NL, "Beschikbare commando's zijn:"},
/* pl */ {IDGS_AVAILABLE_COMMANDS_ARE_PL, "Dostpne opcje to:"},
/* ru */ {IDGS_AVAILABLE_COMMANDS_ARE_RU, "Available commands are:"},
/* sv */ {IDGS_AVAILABLE_COMMANDS_ARE_SV, "Tillgngliga kommandon:"},
/* tr */ {IDGS_AVAILABLE_COMMANDS_ARE_TR, "Kullanlabilir komutlar:"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MACHINE_STATE_COMMANDS,    N_("Machine state commands:")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MACHINE_STATE_COMMANDS_DA, "Kommandoer for maskinstatus:"},
/* de */ {IDGS_MACHINE_STATE_COMMANDS_DE, "Maschinen Zustandskommandos:"},
/* es */ {IDGS_MACHINE_STATE_COMMANDS_ES, "Comandos estado mquina:"},
/* fr */ {IDGS_MACHINE_STATE_COMMANDS_FR, "Commandes de statut de machine:"},
/* hu */ {IDGS_MACHINE_STATE_COMMANDS_HU, ""},  /* fuzzy */
/* it */ {IDGS_MACHINE_STATE_COMMANDS_IT, "Comandi di stato del computer:"},
/* ko */ {IDGS_MACHINE_STATE_COMMANDS_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MACHINE_STATE_COMMANDS_NL, "Machine status commando's:"},
/* pl */ {IDGS_MACHINE_STATE_COMMANDS_PL, "Komendy stanu maszyny:"},
/* ru */ {IDGS_MACHINE_STATE_COMMANDS_RU, "Machine state commands:"},
/* sv */ {IDGS_MACHINE_STATE_COMMANDS_SV, "Kommandon fr maskinstatus:"},
/* tr */ {IDGS_MACHINE_STATE_COMMANDS_TR, "Makine durum komutlar:"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MEMSPACE,    N_("memspace")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MEMSPACE_DA, "huk.omrde"},
/* de */ {IDGS_MEMSPACE_DE, "Speicherbereich"},
/* es */ {IDGS_MEMSPACE_ES, "espacio de memoria"},
/* fr */ {IDGS_MEMSPACE_FR, "espace mmoire"},
/* hu */ {IDGS_MEMSPACE_HU, ""},  /* fuzzy */
/* it */ {IDGS_MEMSPACE_IT, "spazio di memoria"},
/* ko */ {IDGS_MEMSPACE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MEMSPACE_NL, "geheugenruimte"},
/* pl */ {IDGS_MEMSPACE_PL, "memspace"},
/* ru */ {IDGS_MEMSPACE_RU, "memspace"},
/* sv */ {IDGS_MEMSPACE_SV, "minnesomrde"},
/* tr */ {IDGS_MEMSPACE_TR, "bellekalan"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_BANKNAME,    N_("bankname")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_BANKNAME_DA, "banknavn"},
/* de */ {IDGS_BANKNAME_DE, "Speicherbank"},
/* es */ {IDGS_BANKNAME_ES, "Nombre de banco"},
/* fr */ {IDGS_BANKNAME_FR, "nom de la banque"},
/* hu */ {IDGS_BANKNAME_HU, ""},  /* fuzzy */
/* it */ {IDGS_BANKNAME_IT, "nome banco"},
/* ko */ {IDGS_BANKNAME_KO, ""},  /* fuzzy */
/* nl */ {IDGS_BANKNAME_NL, "banknaam"},
/* pl */ {IDGS_BANKNAME_PL, "bankname"},
/* ru */ {IDGS_BANKNAME_RU, "bankname"},
/* sv */ {IDGS_BANKNAME_SV, "banknamn"},
/* tr */ {IDGS_BANKNAME_TR, "bankismi"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_BANK_DESCRIPTION,    N_("If bankname is not given, print the possible banks for the memspace.\nIf bankname is given set the current bank in the memspace to the given\nbank.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_BANK_DESCRIPTION_DA, "Hvis banknavn ikke angives vises mulige banker for hukommelsesomrdet.\nHvis banknavn angives sttes aktuel bank i hukommelsesomrdet til den\nangivne bank."},
/* de */ {IDGS_MON_BANK_DESCRIPTION_DE, "Falls `bankname' nicht angegeben wird, Ausgabe der mglichen Bnke in `memspace'.\nFalls `bankname' angegeben wird, setze aktuelle Bank in `memspace' mit angegebener Bank."},
/* es */ {IDGS_MON_BANK_DESCRIPTION_ES, "Si no se pone el nombre del banco, imprimir los bancos posibles para el espacio de memoria.\nSi se da el nombre de banco se usa como espacio de memoria actual \nbanco."},
/* fr */ {IDGS_MON_BANK_DESCRIPTION_FR, "Si le nom de la banque n'est pas donn, afficher les banques possible pour\ncet espace mmoire. Si le nom de la banque est donne, rgler la banques\ncourante de l'espace mmoire  cette banque slectionne."},
/* hu */ {IDGS_MON_BANK_DESCRIPTION_HU, "Ha a lap szma nincs megadva, kirja a lehetsges lapokat a memria trbl.\nHa meg van adva, az aktulis lap szmot a memria trben a megadott lapra lltja."},
/* it */ {IDGS_MON_BANK_DESCRIPTION_IT, "Se non viene specificato il nome del banco, stampa tutti i banchi\npossibili per lo spazio di memoria.\nSe viene specificato il nome del banco, imposta il banco attuale nello\nspazio di memoria specificato."},
/* ko */ {IDGS_MON_BANK_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_BANK_DESCRIPTION_NL, "Als de banknaam niet is opgegeven, worden de mogelijke banken voor de\ngeheugenruimte weergegeven. Als de banknaam is opgegeven, wordt de\nhuidige bank in de geheugenruimte gezet volgens de opgegeven banknaam."},
/* pl */ {IDGS_MON_BANK_DESCRIPTION_PL, "Jeli nie podano nazwy banku, pokazuje moliwe banki pamici.\nJeli podano nazw banku, ustawia obecny bank pamici na\ndany bank."},
/* ru */ {IDGS_MON_BANK_DESCRIPTION_RU, "If bankname is not given, print the possible banks for the memspace.\nIf bankname is given set the current bank in the memspace to the given\nbank."},
/* sv */ {IDGS_MON_BANK_DESCRIPTION_SV, "Om banknamn inte anges, skriv ut mjliga bankar fr minnesomrdet.\nOm banknamn anges, stt aktuell bank i minnesomrdet till den givna\nbanken."},
/* tr */ {IDGS_MON_BANK_DESCRIPTION_TR, "Eer bank ismi verilmemise, bellek alan iin uygun banklar yazdrlr.\nEer bank ismi verilmise, geerli bank bellek alan iinde verilen\nbanka eitlenir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_BACKTRACE_DESCRIPTION,    N_("Print JSR call chain (most recent call first). Stack offset\nrelative to SP+1 is printed in parentheses. This is a best guess\nonly.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_BACKTRACE_DESCRIPTION_DA, "Vis JSR-kaldekde (seneste kald verst). Stakafstand\nrelativ til SP+1 vises i parantes. Dette er kun et\ngt."},
/* de */ {IDGS_MON_BACKTRACE_DESCRIPTION_DE, "Zeige JSR Aufrufkette (letzter Aufruf zuerst). Stack offset\nwird relative zu SP+1 in Klammern gezeigt. Dies ist jedoch nur\neine Schtzung."},
/* es */ {IDGS_MON_BACKTRACE_DESCRIPTION_ES, "Imprimir cadena de llamada JSR (la llamada ms reciente primero). Stack offset\nrelativo a  SP+1 se imprime entre parntesis. Esta es una buena suposicin\nslo."},
/* fr */ {IDGS_MON_BACKTRACE_DESCRIPTION_FR, "Afficher la chaine d'appels JSR (plus rcent appel en premier)\nL'emplacement de la pile relatif  SP+1 est affich entre\nparanthses. Il ne s'agit que de la meilleure estimation possible."},
/* hu */ {IDGS_MON_BACKTRACE_DESCRIPTION_HU, "JSR hvs lista kirsa (legutbbi elszr). A verem SP+1\nhelyen lv tartalma zrjelben. Ez csak\negy legjobb becsls."},
/* it */ {IDGS_MON_BACKTRACE_DESCRIPTION_IT, "Stampa la catena di chiamate JSR (la chiamata pi recente per prima).\nL'offset dello stack relativo a SP+1  stampato tra parentesi. Questo \nsolo l'ipotesi migliore."},
/* ko */ {IDGS_MON_BACKTRACE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_BACKTRACE_DESCRIPTION_NL, "Toon JSR gebruik (meest recent gebruikt eerst). Het relatieve begin van de stack\nten opzichte van SP+1 zal worden getoond\ntussen de aanhalingstekens. Dit is op basis van de beste gok."},
/* pl */ {IDGS_MON_BACKTRACE_DESCRIPTION_PL, "Pokazuje acuch wezwa JSR. Wyrwnanie stosu relatywne\ndo SP+1 jest pokazane w nawiasach. Warto jest szacowana."},
/* ru */ {IDGS_MON_BACKTRACE_DESCRIPTION_RU, "Print JSR call chain (most recent call first). Stack offset\nrelative to SP+1 is printed in parentheses. This is a best guess\nonly."},
/* sv */ {IDGS_MON_BACKTRACE_DESCRIPTION_SV, "Skriv JSR-anropskedja (senaste anrop frst). Stackavstnd\nrelativt till SP+1 visas inom parantes. Detta r bara en\ngissning."},
/* tr */ {IDGS_MON_BACKTRACE_DESCRIPTION_TR, "JSR ar zincirini yazdr (en son arlar ncelikli). Yt ofseti\nSP+1'e bal olarak parantez iersinde yazdrlr. Bu yalnzca en iyi\ntahmindir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_CPU_DESCRIPTION,    N_("Specify the type of CPU currently used (6502/z80).")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_CPU_DESCRIPTION_DA, "Angiv typen af CPU der anvendes for jeblikket (6502/z80)."},
/* de */ {IDGS_MON_CPU_DESCRIPTION_DE, "CPU Typ setzen (6502/z80)"},
/* es */ {IDGS_MON_CPU_DESCRIPTION_ES, "Especificar el tipo de CPU usada (6502/z80)."},
/* fr */ {IDGS_MON_CPU_DESCRIPTION_FR, "Spcifiez le type de processeur utilis (6502/z80)."},
/* hu */ {IDGS_MON_CPU_DESCRIPTION_HU, "A processzor tpusnak megadsa (6502/z80)."},
/* it */ {IDGS_MON_CPU_DESCRIPTION_IT, "Specifica il tipo di CPU utilizzata al momento (6502/z80)."},
/* ko */ {IDGS_MON_CPU_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_CPU_DESCRIPTION_NL, "Geef de soort CPU op die op dit moment in gebruik is (6502/z80)."},
/* pl */ {IDGS_MON_CPU_DESCRIPTION_PL, "Okrel typ obecnie uywanego CPU (6502/z80)."},
/* ru */ {IDGS_MON_CPU_DESCRIPTION_RU, "Specify the type of CPU currently used (6502/z80)."},
/* sv */ {IDGS_MON_CPU_DESCRIPTION_SV, "Ange typ av CPU som anvnds fr nrvarande (6502/z80)."},
/* tr */ {IDGS_MON_CPU_DESCRIPTION_TR, "u anda kullanlmakta olan CPU tipini belirleyin (6502/z80)."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_COUNT,    N_("count")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_COUNT_DA, "antal"},
/* de */ {IDGS_COUNT_DE, "Zhler"},
/* es */ {IDGS_COUNT_ES, "contador"},
/* fr */ {IDGS_COUNT_FR, "compte"},
/* hu */ {IDGS_COUNT_HU, ""},  /* fuzzy */
/* it */ {IDGS_COUNT_IT, "contatore"},
/* ko */ {IDGS_COUNT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_COUNT_NL, "hoeveelheid"},
/* pl */ {IDGS_COUNT_PL, "count"},
/* ru */ {IDGS_COUNT_RU, "count"},
/* sv */ {IDGS_COUNT_SV, "antal"},
/* tr */ {IDGS_COUNT_TR, "adet"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_CPUHISTORY_DESCRIPTION,    N_("Show <count> last executed commands.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_CPUHISTORY_DESCRIPTION_DA, "Vis <antal> senest eksekverede instruktioner."},
/* de */ {IDGS_MON_CPUHISTORY_DESCRIPTION_DE, "Zeige [<Zhler>] zuletzt ausgefhrte Kommandos"},
/* es */ {IDGS_MON_CPUHISTORY_DESCRIPTION_ES, "Show <contador> ltimo comando ejecutado."},
/* fr */ {IDGS_MON_CPUHISTORY_DESCRIPTION_FR, "Afficher les <count> dernires commandes excutes."},
/* hu */ {IDGS_MON_CPUHISTORY_DESCRIPTION_HU, "<darab> utoljra vgrehajtott utasts mutatsa."},
/* it */ {IDGS_MON_CPUHISTORY_DESCRIPTION_IT, "Mostra gli ultimi <contatore> comandi eseguiti."},
/* ko */ {IDGS_MON_CPUHISTORY_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_CPUHISTORY_DESCRIPTION_NL, "Toon <hoeveelheid> laatst uitgevoerde commando's."},
/* pl */ {IDGS_MON_CPUHISTORY_DESCRIPTION_PL, "Pokazuje <ilo> ostatnio wykonanych polece."},
/* ru */ {IDGS_MON_CPUHISTORY_DESCRIPTION_RU, "Show <count> last executed commands."},
/* sv */ {IDGS_MON_CPUHISTORY_DESCRIPTION_SV, "Visa <antal> senast exekverade kommandon."},
/* tr */ {IDGS_MON_CPUHISTORY_DESCRIPTION_TR, "<adet> son altrlan komutlar gster."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_FILENAME,    N_("filename")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_FILENAME_DA, "filnavn"},
/* de */ {IDGS_FILENAME_DE, "Dateiname"},
/* es */ {IDGS_FILENAME_ES, "Nombre fichero"},
/* fr */ {IDGS_FILENAME_FR, "nom de fichier"},
/* hu */ {IDGS_FILENAME_HU, ""},  /* fuzzy */
/* it */ {IDGS_FILENAME_IT, "nome file"},
/* ko */ {IDGS_FILENAME_KO, ""},  /* fuzzy */
/* nl */ {IDGS_FILENAME_NL, "bestandsnaam"},
/* pl */ {IDGS_FILENAME_PL, "filename"},
/* ru */ {IDGS_FILENAME_RU, " "},
/* sv */ {IDGS_FILENAME_SV, "filnamn"},
/* tr */ {IDGS_FILENAME_TR, "dosyaismi"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DUMP_DESCRIPTION,    N_("Write a snapshot of the machine into the file specified.\nThis snapshot is compatible with a snapshot written out by the UI.\nNote: No ROM images are included into the dump.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_DUMP_DESCRIPTION_DA, "Skriv et snapshot til den angivne fil.\nDette snapshot er kompatibelt med dem, der oprettes fra menuen.\nOBS: ROM-images inkluderes ikke i snapshot."},
/* de */ {IDGS_MON_DUMP_DESCRIPTION_DE, "Schreibe eine Snapsho Datei der Maschine auf die angebene Datei.\nDieser Snapshot ist kompatible zu einem Snapshot initiiert aus dem Men.\nHinweis: Die ROM Images werden im Snapshot nicht inkludiert."},
/* es */ {IDGS_MON_DUMP_DESCRIPTION_ES, "Grabar Instantnea de la mquina en el fichero especificado.\nEsta Instantnea es compatible con la grabada por el UI.\nNota: Ninguna imagen ROM se incluye en la copia."},
/* fr */ {IDGS_MON_DUMP_DESCRIPTION_FR, "crire un instantan de la machine dans le fichier spcifi.\nCet instantan est compatible avec les instantans de l'IU.\nNote: Aucune image ROM n'est incluse dans l'instantan."},
/* hu */ {IDGS_MON_DUMP_DESCRIPTION_HU, "Pillanatkp rsa a gprl a megadott fjlba. A pillanatkp\nkompatibilis azzal, amelyet a grafikus fellet hoz ltre.\nMegjegyzs: a ROM kpmsok nem kerlnek bele."},
/* it */ {IDGS_MON_DUMP_DESCRIPTION_IT, "Scrive uno snapshot del computer sul file specificato.\nQuesto snapshot  compatibile con uno snapshot scritto dall'IU.\nNota: Le immagini ROM non sono incluse nel dump."},
/* ko */ {IDGS_MON_DUMP_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_DUMP_DESCRIPTION_NL, "Schrijf een momentopname van de machine naar het opgegeven bestand.\nDeze momentopname is compatibel met een momentopname zoals geschreven \nvanuit het menu.\nNB: ROM bestanden zijn niet opgenomen in de momentopname."},
/* pl */ {IDGS_MON_DUMP_DESCRIPTION_PL, "Zapis zrzutu maszyny do danego pliku.\nZrzut ten jest kompatybilny ze zrzutami zapisywanymi przez UI.\nUwaga: W zrzucie nie s zawarte adne obrazy ROM."},
/* ru */ {IDGS_MON_DUMP_DESCRIPTION_RU, "Write a snapshot of the machine into the file specified.\nThis snapshot is compatible with a snapshot written out by the UI.\nNote: No ROM images are included into the dump."},
/* sv */ {IDGS_MON_DUMP_DESCRIPTION_SV, "Skriv en gonblicksbild av maskinen till den angivna filen.\ngonblicksbilden r kompatibel med de som skapas frn menyn.\nObservera: ROM-avbildningar inkluderas inte i bilden."},
/* tr */ {IDGS_MON_DUMP_DESCRIPTION_TR, "Belirtilen dosya iersine makinenin anlk grntsn yaz.\nBu anlk grnt UI dndan yazdrlan anlk grnt ile uyumludur.\nNot: Hibir ROM imaj dkm iersinde yer almaz."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_ADDRESS,    N_("address")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ADDRESS_DA, "adresse"},
/* de */ {IDGS_ADDRESS_DE, "Adresse"},
/* es */ {IDGS_ADDRESS_ES, "direccin"},
/* fr */ {IDGS_ADDRESS_FR, "adresse"},
/* hu */ {IDGS_ADDRESS_HU, ""},  /* fuzzy */
/* it */ {IDGS_ADDRESS_IT, "indirizzo"},
/* ko */ {IDGS_ADDRESS_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ADDRESS_NL, "adres"},
/* pl */ {IDGS_ADDRESS_PL, "address"},
/* ru */ {IDGS_ADDRESS_RU, ""},  /* fuzzy */
/* sv */ {IDGS_ADDRESS_SV, "adress"},
/* tr */ {IDGS_ADDRESS_TR, "adres"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_GOTO_DESCRIPTION,    N_("Change the PC to ADDRESS and continue execution")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_GOTO_DESCRIPTION_DA, "ndr programtlleren (PC) til ADRESSE og fortst eksekvering"},
/* de */ {IDGS_MON_GOTO_DESCRIPTION_DE, "Setze PC auf ADRESSE und setze Ausfhrung fort"},
/* es */ {IDGS_MON_GOTO_DESCRIPTION_ES, "Cambiar el  PC con direccin y continuar la ejecucin"},
/* fr */ {IDGS_MON_GOTO_DESCRIPTION_FR, "Modifier le PC  l'ADRESSE et continuer l'excution"},
/* hu */ {IDGS_MON_GOTO_DESCRIPTION_HU, "A PC lltsa ADDRESS cmre s folytats"},
/* it */ {IDGS_MON_GOTO_DESCRIPTION_IT, "Cambia il PC in INDIRIZZO e continua l'esecuzione"},
/* ko */ {IDGS_MON_GOTO_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_GOTO_DESCRIPTION_NL, "Zet de PC naar ADRES en ga door met de uitvoering van instructies."},
/* pl */ {IDGS_MON_GOTO_DESCRIPTION_PL, "Zmie PC na ADRES i wykonuj dalej"},
/* ru */ {IDGS_MON_GOTO_DESCRIPTION_RU, "      "},
/* sv */ {IDGS_MON_GOTO_DESCRIPTION_SV, "ndra PC till ADRESS och fortstt exekveringen"},
/* tr */ {IDGS_MON_GOTO_DESCRIPTION_TR, "PC'yi ADDRESS'e evirip altrmaya devam edin"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_IO_DESCRIPTION,    N_("Print out the I/O area of the emulated machine.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_IO_DESCRIPTION_DA, "Udskriv I/O-omrdet for den emulerede maskine."},
/* de */ {IDGS_MON_IO_DESCRIPTION_DE, "Zeige den I/O Bereich der emulierten Maschine."},
/* es */ {IDGS_MON_IO_DESCRIPTION_ES, "Imprimir el rea de entrada/salida de la mquina emulada."},
/* fr */ {IDGS_MON_IO_DESCRIPTION_FR, "Afficher la zone d'E/S de la machine mule."},
/* hu */ {IDGS_MON_IO_DESCRIPTION_HU, "Az emullt gp I/O tartomnynak mutatsa."},
/* it */ {IDGS_MON_IO_DESCRIPTION_IT, "Stampa l'area di I/O del computer emulato."},
/* ko */ {IDGS_MON_IO_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_IO_DESCRIPTION_NL, "Toon het I/O gebied van de gemuleerde machine."},
/* pl */ {IDGS_MON_IO_DESCRIPTION_PL, "Poka obszar we/wy emulowanej maszyny."},
/* ru */ {IDGS_MON_IO_DESCRIPTION_RU, "Print out the I/O area of the emulated machine."},
/* sv */ {IDGS_MON_IO_DESCRIPTION_SV, "Skriv I/O-omrdet fr den emulerade maskinen."},
/* tr */ {IDGS_MON_IO_DESCRIPTION_TR, "Emle edilen makinenin G/ alann yazdr."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_EXPORT_DESCRIPTION,    N_("Print out list of attached expansion port devices.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_EXPORT_DESCRIPTION_DA, "Udskriv liste over tilsluttede udviddelsesportenheder"},
/* de */ {IDGS_MON_EXPORT_DESCRIPTION_DE, "Zeige eine Liste der Gerte am Expansion Port."},
/* es */ {IDGS_MON_EXPORT_DESCRIPTION_ES, "Imprimir lista perifricos insertados en puertos de expansin."},
/* fr */ {IDGS_MON_EXPORT_DESCRIPTION_FR, "Afficher la liste des priphriques attachs aux ports d'expansion."},
/* hu */ {IDGS_MON_EXPORT_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_EXPORT_DESCRIPTION_IT, "Stampa lista dei dispositivi collegati sulla porta di espansione."},
/* ko */ {IDGS_MON_EXPORT_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_EXPORT_DESCRIPTION_NL, "Druk een lijst van gekoppelde uitbreidingspoort apparaten af."},
/* pl */ {IDGS_MON_EXPORT_DESCRIPTION_PL, "Wydrukuj list podczonych urzdze portw rozszerze."},
/* ru */ {IDGS_MON_EXPORT_DESCRIPTION_RU, "Print out list of attached expansion port devices."},
/* sv */ {IDGS_MON_EXPORT_DESCRIPTION_SV, "Skriv ut lista ver anslutna expansionsportsenheter."},
/* tr */ {IDGS_MON_EXPORT_DESCRIPTION_TR, "Geniletme yuvasna takl aygtlarn listesini yazdr."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_NEXT_DESCRIPTION,    N_("Advance to the next instruction.  Subroutines are treated as\na single instruction.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_NEXT_DESCRIPTION_DA, "G frem til nste instruktion. Subrutiner bliver behandlet som\nen enkelt instruktion."},
/* de */ {IDGS_MON_NEXT_DESCRIPTION_DE, "Fahre bis zur nchsten Instruktion fort.\nUnterroutinen werden wie eine einzelne Instruktion behandelt."},
/* es */ {IDGS_MON_NEXT_DESCRIPTION_ES, "Avanzar a la siguiente instruccin.  Subrutinas sern tratadas como\ninstrucciones simples."},
/* fr */ {IDGS_MON_NEXT_DESCRIPTION_FR, "Avancer  la prochaine instruction. Les sous-routines sont\ntraites comme tant une seule instruction."},
/* hu */ {IDGS_MON_NEXT_DESCRIPTION_HU, "A kvetkez utastsra lps.  A szubrutinokat egy\nutastsnak tekinti."},
/* it */ {IDGS_MON_NEXT_DESCRIPTION_IT, "Passa alla prossima istruzione. Le subrutine sono trattate come\nuna singola istruzione."},
/* ko */ {IDGS_MON_NEXT_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_NEXT_DESCRIPTION_NL, "Ga naar de volgende instructie. Subroutines worden behandeld als een\nenkele instructie."},
/* pl */ {IDGS_MON_NEXT_DESCRIPTION_PL, "Przechodzi do nastpnej instrukcji. Procedury s traktowane\njak pojedyncze instrukcje."},
/* ru */ {IDGS_MON_NEXT_DESCRIPTION_RU, "Advance to the next instruction.  Subroutines are treated as\na single instruction."},
/* sv */ {IDGS_MON_NEXT_DESCRIPTION_SV, "G till nsta instruktion. Underrutiner hanteras som en\nenda instruktion."},
/* tr */ {IDGS_MON_NEXT_DESCRIPTION_TR, "Sonraki komuta ilerle.  Altrutinler tek bir komutmu\ngibi ilendi."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_REG_NAME,    N_("reg_name")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_REG_NAME_DA, "regnavn"},
/* de */ {IDGS_REG_NAME_DE, "Register Name"},
/* es */ {IDGS_REG_NAME_ES, "Nombre registro"},
/* fr */ {IDGS_REG_NAME_FR, "reg_name"},
/* hu */ {IDGS_REG_NAME_HU, ""},  /* fuzzy */
/* it */ {IDGS_REG_NAME_IT, "nome registro"},
/* ko */ {IDGS_REG_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDGS_REG_NAME_NL, "register naam"},
/* pl */ {IDGS_REG_NAME_PL, "reg_name"},
/* ru */ {IDGS_REG_NAME_RU, "reg_name"},
/* sv */ {IDGS_REG_NAME_SV, "regnamn"},
/* tr */ {IDGS_REG_NAME_TR, "reg_ismi"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_NUMBER,    N_("number")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_NUMBER_DA, "nummer"},
/* de */ {IDGS_NUMBER_DE, "Nummer"},
/* es */ {IDGS_NUMBER_ES, "nmero"},
/* fr */ {IDGS_NUMBER_FR, "numro"},
/* hu */ {IDGS_NUMBER_HU, ""},  /* fuzzy */
/* it */ {IDGS_NUMBER_IT, "numero"},
/* ko */ {IDGS_NUMBER_KO, ""},
/* nl */ {IDGS_NUMBER_NL, "nummer"},
/* pl */ {IDGS_NUMBER_PL, "numer"},
/* ru */ {IDGS_NUMBER_RU, "number"},
/* sv */ {IDGS_NUMBER_SV, "nummer"},
/* tr */ {IDGS_NUMBER_TR, "say"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_REGISTERS_DESCRIPTION,    N_("Assign respective registers.  With no parameters, display register\nvalues.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_REGISTERS_DESCRIPTION_DA, "Tildel vrdi til registre. Uden parametre vises nuvrende vrdier\ni registrene."},
/* de */ {IDGS_MON_REGISTERS_DESCRIPTION_DE, "Zuweisung auf entsprechende Register. Ohne Parameter, zeige Register Werte."},
/* es */ {IDGS_MON_REGISTERS_DESCRIPTION_ES, "Asignar registros respectivos. Sin parmetros, mostrar valores\nregistros."},
/* fr */ {IDGS_MON_REGISTERS_DESCRIPTION_FR, "Assigner des registres respectifs. Sans paramtres, affichera\nles valeurs des registres."},
/* hu */ {IDGS_MON_REGISTERS_DESCRIPTION_HU, "Megadott regiszterek belltsa. Paramterek nlkl, a regiszterek\ntartalmnak kirsa."},
/* it */ {IDGS_MON_REGISTERS_DESCRIPTION_IT, "Assegna i rispettivi registri. Senza parametri, mostra i valori dei\nregistri."},
/* ko */ {IDGS_MON_REGISTERS_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_REGISTERS_DESCRIPTION_NL, "Vul opgegeven registers met de toebehorende waarde. Zonder parameter, toon\nde huidige waarden in de registers."},
/* pl */ {IDGS_MON_REGISTERS_DESCRIPTION_PL, "Przyporzdkowuje odpowiednie rejestry. Bez podanych parametrw\npokazuje wartoci rejestrw."},
/* ru */ {IDGS_MON_REGISTERS_DESCRIPTION_RU, "Assign respective registers.  With no parameters, display register\nvalues."},
/* sv */ {IDGS_MON_REGISTERS_DESCRIPTION_SV, "Tilldela respektive register. Utan parametrar visas innehllet\ni registren."},
/* tr */ {IDGS_MON_REGISTERS_DESCRIPTION_TR, "Srayla registerlara ata.  parametreler olmadan, register deerlerini\ngrntle."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_RESET_DESCRIPTION,    N_("Reset the machine or drive. Type: 0 = soft, 1 = hard, 8-11 = drive.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_RESET_DESCRIPTION_DA, "Reset maskine eller diskettedrev. Type: 0 = bld, 1 = hrd,\n8-11 = diskettedrev."},
/* de */ {IDGS_MON_RESET_DESCRIPTION_DE, "Reset der Maschine oder des Laufwerks. Typ: 0 = soft, 1 = hart, 8-11 = Laufwerk."},
/* es */ {IDGS_MON_RESET_DESCRIPTION_ES, "Reiniciar mquina o unidad disco. Tipo: 0 = soft, 1 = hard, 8-11 = unidad disco."},
/* fr */ {IDGS_MON_RESET_DESCRIPTION_FR, "Rinitialiser la machine ou le lecteur. (0=Soft, 1=Hard, 8-11=Lecteur)"},
/* hu */ {IDGS_MON_RESET_DESCRIPTION_HU, "A szmtgp vagy meghajt jraindtsa. Tpus: 0 = meleg, 1 = hideg, 8-11 = meghajt."},
/* it */ {IDGS_MON_RESET_DESCRIPTION_IT, "Resetta il computer o il drive. Tipo: 0 = soft, 1 = hard, 8-11 = drive."},
/* ko */ {IDGS_MON_RESET_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_RESET_DESCRIPTION_NL, "Reset de machine of drive. Soort: 0 = zacht, 1 = hard, 8-11 = drive."},
/* pl */ {IDGS_MON_RESET_DESCRIPTION_PL, "Reset maszyny lub napdu. Typ: 0 = mikki, 1 = twardy, 8-11 = napdu."},
/* ru */ {IDGS_MON_RESET_DESCRIPTION_RU, "Reset the machine or drive. Type: 0 = soft, 1 = hard, 8-11 = drive."},
/* sv */ {IDGS_MON_RESET_DESCRIPTION_SV, "terstll maskinen eller diskettstationen. Typ: 0 = mjuk, 1 = hrd,\n8-11 = diskettstation."},
/* tr */ {IDGS_MON_RESET_DESCRIPTION_TR, "Makine ya da srcy resetle. Tip: 0 = soft, 1 = hard, 8-11 = drive."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_RETURN_DESCRIPTION,    N_("Continues execution and returns to the monitor just before the next\nRTS or RTI is executed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_RETURN_DESCRIPTION_DA, "Fortst eksekveringen og vend tilbage til monitoren lige inden nste\nRTS eller RTI udfres."},
/* de */ {IDGS_MON_RETURN_DESCRIPTION_DE, "Setzt Ausfhrung fort und retourniert bevor der nchsten RTS oder RTI instruction."},
/* es */ {IDGS_MON_RETURN_DESCRIPTION_ES, "Continuar ejecucin y volver al monitor justo antes que la siguiente\nRTS o RTI sea ejecutada."},
/* fr */ {IDGS_MON_RETURN_DESCRIPTION_FR, "Continuer l'excution et retourner au moniteur juste avant la prochaine\nexcution de RTS ou RTI."},
/* hu */ {IDGS_MON_RETURN_DESCRIPTION_HU, "Folytatja a vgrehajtst s visszatr a monitorba a kvetkez\nRTS vagy RTI utasts eltt."},
/* it */ {IDGS_MON_RETURN_DESCRIPTION_IT, "Continua l'esecuzione e ritorna al monitor subito prima della prossima\nesecuzione di RTS o RTI."},
/* ko */ {IDGS_MON_RETURN_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_RETURN_DESCRIPTION_NL, "Ga door met uitvoeren van instructies en keer terug naar de monitor net voordat de\nvolgende RTS of RTI wordt uitgevoerd."},
/* pl */ {IDGS_MON_RETURN_DESCRIPTION_PL, "Wykonuje dalej i wraca do monitora tu przed wykonaniem\nnastpnego RTS lub RTI."},
/* ru */ {IDGS_MON_RETURN_DESCRIPTION_RU, "Continues execution and returns to the monitor just before the next\nRTS or RTI is executed."},
/* sv */ {IDGS_MON_RETURN_DESCRIPTION_SV, "Fortstt exekveringen och terg till monitorn precis innan nsta\nRTS eller RTI exekveras."},
/* tr */ {IDGS_MON_RETURN_DESCRIPTION_TR, "almaya devam eder ve sonraki RTS ya da RTI altrlmadan hemen nce\nmonitre geri dner."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_SCREEN_DESCRIPTION,    N_("Displays the contents of the screen.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_SCREEN_DESCRIPTION_DA, "Viser skrmens indhold."},
/* de */ {IDGS_MON_SCREEN_DESCRIPTION_DE, "Zeigt Bildschirminhalt."},
/* es */ {IDGS_MON_SCREEN_DESCRIPTION_ES, "Mostrar los contenidos de la pantalla."},
/* fr */ {IDGS_MON_SCREEN_DESCRIPTION_FR, "Affiche le contenu de l'cran."},
/* hu */ {IDGS_MON_SCREEN_DESCRIPTION_HU, "A kperny tartalmnak mutatsa."},
/* it */ {IDGS_MON_SCREEN_DESCRIPTION_IT, "Mostra il contenuto dello schermo."},
/* ko */ {IDGS_MON_SCREEN_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_SCREEN_DESCRIPTION_NL, "Toont de inhoud van het scherm."},
/* pl */ {IDGS_MON_SCREEN_DESCRIPTION_PL, "Pokazuje zawarto ekranu."},
/* ru */ {IDGS_MON_SCREEN_DESCRIPTION_RU, "  ."},
/* sv */ {IDGS_MON_SCREEN_DESCRIPTION_SV, "Visar skrmens innehll."},
/* tr */ {IDGS_MON_SCREEN_DESCRIPTION_TR, "Ekran ieriini grntler."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_STEP_DESCRIPTION,    N_("Single-step through instructions.  COUNT allows stepping\nmore than a single instruction at a time.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_STEP_DESCRIPTION_DA, "G skridtvis gennem instruktioner. Hvis ANTAL angives kan\nflere instruktioner udfres i hvert skridt."},
/* de */ {IDGS_MON_STEP_DESCRIPTION_DE, "Einzelschritt Ausfhrung durch Instruktionen. COUNT erlaubt die Ausfhrung\nmehrerer Instruktionen auf einmal."},
/* es */ {IDGS_MON_STEP_DESCRIPTION_ES, "Salto simple a travs de la instruccin.  el CONTADOR permite el salto de\nms de una instruccin a la vez."},
/* fr */ {IDGS_MON_STEP_DESCRIPTION_FR, "Instructions  tape-unique. COUNT permet de faire pas--pas plus qu'une seule instruction  la fois."},
/* hu */ {IDGS_MON_STEP_DESCRIPTION_HU, "Lpkeds egyesvel az utastsokon.  A DARAB-bal bellthat,\nha tbb utastst kell ugrani egyszerre."},
/* it */ {IDGS_MON_STEP_DESCRIPTION_IT, "Modalit single step attraverso le istruzioni. Il CONTATORE permette\ndi attraversare pi di una singola istruzione per volta."},
/* ko */ {IDGS_MON_STEP_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_STEP_DESCRIPTION_NL, "Stap voor stap door de instructies. AANTAL zorgt ervoor dat er meerdere\ninstructies worden uitgevoerd in een keer."},
/* pl */ {IDGS_MON_STEP_DESCRIPTION_PL, "Przechodzi przez instrukcje krok po kroku. COUNT pozwala\nprzechodzi przez wicej ni jedn instrukcj na raz."},
/* ru */ {IDGS_MON_STEP_DESCRIPTION_RU, "Single-step through instructions.  COUNT allows stepping\nmore than a single instruction at a time."},
/* sv */ {IDGS_MON_STEP_DESCRIPTION_SV, "Stega genom instruktioner. ANTAL gr det mjligt att stega\ngenom mer n en enkel instruktion i varje steg."},
/* tr */ {IDGS_MON_STEP_DESCRIPTION_TR, "Komutlara doru tek-adm.  COUNT bir defada birden fazla\nkomutu admlamaya izin verir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_STOPWATCH_DESCRIPTION,    N_("Print the CPU cycle counter of the current device. 'reset' sets the counter to 0.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_STOPWATCH_DESCRIPTION_DA, "Udskriv CPU-cyklus-tller for den nuvrende enhed. \"reset\" stter tlleren til 0."},
/* de */ {IDGS_MON_STOPWATCH_DESCRIPTION_DE, "Zeige CPU Zykluszhler des aktuellen Gerts. 'reset' setzt den Zhler\nauf 0."},
/* es */ {IDGS_MON_STOPWATCH_DESCRIPTION_ES, "Imprimir contador de ciclos del perifrico actual. 'reset' pone el contador a 0."},
/* fr */ {IDGS_MON_STOPWATCH_DESCRIPTION_FR, "Afficher le compteur du cycle CPU du ppiphrique actuel. 'reset' remet ce compteur  0."},
/* hu */ {IDGS_MON_STOPWATCH_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_STOPWATCH_DESCRIPTION_IT, "Stampa il numero di cicli di CPU del device attuale. 'reset' imposta il contatore a 0."},
/* ko */ {IDGS_MON_STOPWATCH_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_STOPWATCH_DESCRIPTION_NL, "Toon de CPU cycli teller voor het huidige apparaat. 'reset' zet de teller naar 0."},
/* pl */ {IDGS_MON_STOPWATCH_DESCRIPTION_PL, "Poka licznik cykli CPU obecnego urzdzenia. 'reset' zeruje licznik."},
/* ru */ {IDGS_MON_STOPWATCH_DESCRIPTION_RU, "Print the CPU cycle counter of the current device. 'reset' sets the counter to 0."},
/* sv */ {IDGS_MON_STOPWATCH_DESCRIPTION_SV, "Visa processorcykelrknaren fr aktuell enhet. \"reset\" stter rknaren p 0."},
/* tr */ {IDGS_MON_STOPWATCH_DESCRIPTION_TR, "Mevcut cihazn CPU cycle sayacn yazdr. 'reset' sayac 0'a getirir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_UNDUMP_DESCRIPTION,    N_("Read a snapshot of the machine from the file specified.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_UNDUMP_DESCRIPTION_DA, "Indls snapshot af maskinen fra den angivne fil."},
/* de */ {IDGS_MON_UNDUMP_DESCRIPTION_DE, "Lese einen Snapshot der Maschine aus der angegebenen Datei."},
/* es */ {IDGS_MON_UNDUMP_DESCRIPTION_ES, "Leer Instantnea de una mquina desde el fichero especificado."},
/* fr */ {IDGS_MON_UNDUMP_DESCRIPTION_FR, "Lire un instantan de machine depuis le fichier spcifi."},
/* hu */ {IDGS_MON_UNDUMP_DESCRIPTION_HU, "A pillanatkp betltse a megadott fjlbl."},
/* it */ {IDGS_MON_UNDUMP_DESCRIPTION_IT, "Legge lo snapshot del computer dal file specificato."},
/* ko */ {IDGS_MON_UNDUMP_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_UNDUMP_DESCRIPTION_NL, "Lees een momentopname van de machine vanuit het opgegeven bestand."},
/* pl */ {IDGS_MON_UNDUMP_DESCRIPTION_PL, "Odczytaj zrzut maszyny z okrelonego pliku."},
/* ru */ {IDGS_MON_UNDUMP_DESCRIPTION_RU, "Read a snapshot of the machine from the file specified."},
/* sv */ {IDGS_MON_UNDUMP_DESCRIPTION_SV, "Ls en gonblicksbild fr maskinen frn den angivna filen."},
/* tr */ {IDGS_MON_UNDUMP_DESCRIPTION_TR, "Belirtilen dosyadan makinenin anlk grntsn oku."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_SYMBOL_TABLE_COMMANDS,    N_("Symbol table commands:")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SYMBOL_TABLE_COMMANDS_DA, "Symboltabel-kommandoer:"},
/* de */ {IDGS_SYMBOL_TABLE_COMMANDS_DE, "Symbol Tabellen Kommandos:"},
/* es */ {IDGS_SYMBOL_TABLE_COMMANDS_ES, "Tabla smbolo comando:"},
/* fr */ {IDGS_SYMBOL_TABLE_COMMANDS_FR, "Commandes de la table de symboles:"},
/* hu */ {IDGS_SYMBOL_TABLE_COMMANDS_HU, ""},  /* fuzzy */
/* it */ {IDGS_SYMBOL_TABLE_COMMANDS_IT, "Comandi tabella dei simboli:"},
/* ko */ {IDGS_SYMBOL_TABLE_COMMANDS_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SYMBOL_TABLE_COMMANDS_NL, "Symbool tabel commando's:"},
/* pl */ {IDGS_SYMBOL_TABLE_COMMANDS_PL, "Polecenia tablicy symboli:"},
/* ru */ {IDGS_SYMBOL_TABLE_COMMANDS_RU, "Symbol table commands:"},
/* sv */ {IDGS_SYMBOL_TABLE_COMMANDS_SV, "Kommandon fr symboltabell:"},
/* tr */ {IDGS_SYMBOL_TABLE_COMMANDS_TR, "Sembol tablosu komutlar:"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_LABEL,    N_("label")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_LABEL_DA, "etiket"},
/* de */ {IDGS_LABEL_DE, "Bezeichner"},
/* es */ {IDGS_LABEL_ES, "Etiqueta"},
/* fr */ {IDGS_LABEL_FR, "label"},
/* hu */ {IDGS_LABEL_HU, ""},  /* fuzzy */
/* it */ {IDGS_LABEL_IT, "etichetta"},
/* ko */ {IDGS_LABEL_KO, ""},  /* fuzzy */
/* nl */ {IDGS_LABEL_NL, "label"},
/* pl */ {IDGS_LABEL_PL, "oznaczenie"},
/* ru */ {IDGS_LABEL_RU, "label"},
/* sv */ {IDGS_LABEL_SV, "etikett"},
/* tr */ {IDGS_LABEL_TR, "etiket"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_ADD_LABEL_DESCRIPTION,    N_("<memspace> is one of: C: 8: 9: 10: 11:\n<address>  is the address which should get the label.\n<label>    is the name of the label; it must start with a dot (\".\").\n\nMap a given address to a label.  This label can be used when entering\nassembly code and is shown during disassembly.  Additionally, it can\nbe used whenever an address must be specified.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_ADD_LABEL_DESCRIPTION_DA, "<huk.omrde>   er en af C: 8: 9: 10: eller 11:\n<adresse>      Er adressen som skal have etiketten.\n<etiket>       er navnet p etiketten; skal starte med punktum (\".\").\n\nSt en etiket for en adresse. Etiketten kan angives nr der indtastes\nassemblerkode, og vises ved disassemblering. Desuden kan den bruges\nhvor en adresse skal angives."},
/* de */ {IDGS_MON_ADD_LABEL_DESCRIPTION_DE, "<Speicherbereich> ist aus: C: 8: 9: 10: 11:\n<Adresse>         bezeichnet die Adresse welche mit dem Bezeichner assoziert werden soll.\n<Bezeichner>      Name des Bezeichners; Muss mit einem Punkt (\".\") starten.\n\nAssoziiert einen Bezeichner mit einer Adresse. Dieser Bezeichner kann \nbei der Eingabe von Asssmblercode benutzt werden und wird auch beim\nDisassemblieren gezeigt. Darber hinaus kann der Bezeichner berall\ndort genutzt werden, wo eine Adresseingabe ntig ist."},
/* es */ {IDGS_MON_ADD_LABEL_DESCRIPTION_ES, "<espacio memoria> es uno de: C: 8: 9: 10: 11:\n<direccin>  es la direccin donde estar la etiqueta.\n<etiqueta>   es el nombre de la etiqueta; debe empezar con un punto (\".\").\n\nMapea la direccin dada a una etiqueta que se usar cuando se inserte\ncdigo ensamblador y se mostrar durante el desensamblado.  Adicionalmente\npuede ser usada siempre que se deba especificar una direccin."},
/* fr */ {IDGS_MON_ADD_LABEL_DESCRIPTION_FR, "<memspace> est un des choix suivants (C: 8: 9: 10: 11:)\n<address>  est l'adresse qui devrait prendre le label.\n<label>    est le nom de l'tiquette; il doit commencer par un point (\".\").\n\nAssocie une adresse a une tiquette. Cette tiquette peut tre utilis en entrant\ndu code assembleur et est montr durant le dassemblement. Aussi, vous pouvez\nl'utiliser  tout moment ou une adresse doit tre entre."},
/* hu */ {IDGS_MON_ADD_LABEL_DESCRIPTION_HU, "A <memria tr> ezek kzl: C: 8: 9: 10: 11:\n<cm>  amelyik cmhez a cmkt rendelje.\n<cmke>    a cmke neve; ponttal kell kezddjn (\".\").\n\nAz adott cm rendelse a cmkhez.  Ez a cmke hasznlhat assembly\nprogram bersakor, s visszafejtskor megjelenik.  Mindig hasznlhat,\namikor valamilyen cmet kell megadni."},
/* it */ {IDGS_MON_ADD_LABEL_DESCRIPTION_IT, "<spazio di memoria>  uno tra: C: 8: 9: 10: 11:\n<indirizzo>  l'indirizzo a cui deve essere associata l'etichettal.\n<etichetta>  il nome dell'etichetta; deve iniziare con un punto (\".\").\n\nAssocia l'indirizzo specificato all'etichetta. Questa etichetta pu\nessere usata quando si inserisce codice assembly ed  mostrata\nnella disassemblazione. In aggiunta, pu essere usata ogni volta che\ndeve essere specificato un indirizzo."},
/* ko */ {IDGS_MON_ADD_LABEL_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_ADD_LABEL_DESCRIPTION_NL, "<geheugenruimte> is n van: C: 8: 9: 10: 11:\n<adres>          is het adres waaraan het label gekoppeld moet worden.\n<label>          is de naam van het label; de naam moet beginnen met een punt\n                 (\".\").\n\nKoppel een opgegeven adres aan een label. Dit label kan worden gebruikt bij\nhet invoeren van assembleer code en wordt getoond bij een disassemblering.\nTevens kan het label gebruikt worden in plaats van het adres."},
/* pl */ {IDGS_MON_ADD_LABEL_DESCRIPTION_PL, "<memspace> to jeden z: C: 8: 9: 10: 11:\n<address> to adres, pod ktry ma i oznaczenie.\n<label> to nazwa oznaczenia, musi zaczyna si kropk (\".\").\n\nMapuje dany adres pod oznaczenie. Mona go uy\nprzy wprowadzaniu kodu asemblowania, a pokazywane jest\npodczas deasemblowania. Oznaczenia tego mona go uywa\nzawsze gdy trzeba wskaza dany adres."},
/* ru */ {IDGS_MON_ADD_LABEL_DESCRIPTION_RU, "<memspace> is one of: C: 8: 9: 10: 11:\n<address>  is the address which should get the label.\n<label>    is the name of the label; it must start with a dot (\".\").\n\nMap a given address to a label.  This label can be used when entering\nassembly code and is shown during disassembly.  Additionally, it can\nbe used whenever an address must be specified."},
/* sv */ {IDGS_MON_ADD_LABEL_DESCRIPTION_SV, "<minnesomrde> r en av: C: 8: 9: 10: 11:\n<adress>       r adressen som ska f etiketten.\n<etikett>      r namnet p etiketten; mste starta med punkt (\".\").\n\nKoppla en adress till en etikett. Etiketten kan anges nr assemblerkod\nmatas in och visas vid disassemblering. I tillgg kan den anvndas\nnrhelst en adress mste anges."},
/* tr */ {IDGS_MON_ADD_LABEL_DESCRIPTION_TR, "<bellekalan> bunlardan biridir: C: 8: 9: 10: 11:\n<adres>       etiketin duraca adresi belirler.\n<etiket>      etiketin ismidir; nokta karakteriyle balamaldr (\".\").\n\nEtiketi verilen adrese eletir.  Bu etiket assembly kod girilirken kullanlr\nve disassembly srasnda gsterilir.  Ek olarak, ne zaman bir adres\nbelirtilmesi gerekse kullanlabilir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DELETE_LABEL_DESCRIPTION,    N_("<memspace> is one of: C: 8: 9: 10: 11:\n<label>    is the name of the label; it must start with a dot (\".\").\n\nDelete a previously defined label.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_DELETE_LABEL_DESCRIPTION_DA, "<huk.omrde>   er en af C: 8: 9: 10: eller 11:\n<etiket>       er navnet p etiketten; skal starte med punktum (\".\").\n\nFjern en tidligere oprettet etiket."},
/* de */ {IDGS_MON_DELETE_LABEL_DESCRIPTION_DE, "<Speicherbereich> ist aus: C: 8: 9: 10: 11:\n<Bezeichner>      Name des Bezeichners; Muss mit einem Punkt (\".\") starten.\n\nLscht einen zuvor definierten Bezeichner."},
/* es */ {IDGS_MON_DELETE_LABEL_DESCRIPTION_ES, "<espacio memoria> es uno de: C: 8: 9: 10: 11:\n<etiqueta>    es el nombre de la etiqueta; y debe comenzar por un punto (\".\").\n\nBorrar una etiqueta previamente definida."},
/* fr */ {IDGS_MON_DELETE_LABEL_DESCRIPTION_FR, "<memspace> est un des choix suivants (C: 8: 9: 10: 11:)\n<label>    est le nom de l'tiquette et commence par un point (\".\").\n\nDtruit une tiquette pralablement cre."},
/* hu */ {IDGS_MON_DELETE_LABEL_DESCRIPTION_HU, "<memria tr> egy ezek kzl: C: 8: 9: 10: 11:\n<cmke>    a cmke neve; ponttal kell kezddjn (\".\").\n\nElzleg megadott cmke trlse."},
/* it */ {IDGS_MON_DELETE_LABEL_DESCRIPTION_IT, "<spazio di memoria>  uno tra: C: 8: 9: 10: 11:\n<etichetta>  il nome dell'etichetta; deve iniziare con un punto (\".\").\n\nCancella una etichetta definita precedentemente."},
/* ko */ {IDGS_MON_DELETE_LABEL_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_DELETE_LABEL_DESCRIPTION_NL, "<geheugenruimte> is n van: C: 8: 9: 10: 11:\n<label>          is de naam van het label; de naam moet beginnen met een\npunt (\".\").\n\nVerwijder een gekoppeld label."},
/* pl */ {IDGS_MON_DELETE_LABEL_DESCRIPTION_PL, "<memspace> to jeden z: C: 8: 9: 10: 11:\n<label> to nazwa oznaczenia, musi zaczyna si kropk (\".\").\n\nKasuje poprzednio zdefiniowane oznaczenie."},
/* ru */ {IDGS_MON_DELETE_LABEL_DESCRIPTION_RU, "<memspace> is one of: C: 8: 9: 10: 11:\n<label>    is the name of the label; it must start with a dot (\".\").\n\nDelete a previously defined label."},
/* sv */ {IDGS_MON_DELETE_LABEL_DESCRIPTION_SV, "<minnesomrde> r en av: C: 8: 9: 10: 11:\n<etikett>      r namnet p etiketten; mste starta med punkt (\".\").\n\nTa bort en tidigare angiven etikett."},
/* tr */ {IDGS_MON_DELETE_LABEL_DESCRIPTION_TR, "<bellekalan> bunlardan biridir: C: 8: 9: 10: 11:\n<etiket>      etiketin ismidir; nokta karakteriyle balamaldr (\".\").\n\nnceden tanmlanm bir etiketi sil."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_LOAD_LABELS_DESCRIPTION,    N_("Load a file containing a mapping of labels to addresses.  If no memory\nspace is specified, the default readspace is used.\n\nThe format of the file is the one written out by the `save_labels' command;\nit consists of some `add_label' commands, written one after the other.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_LOAD_LABELS_DESCRIPTION_DA, "Indls en fil som indeholder mapning fra labels til adresser.\nHvis der ikke angives hukommelsesomrde, anvendes det normale lseomrde.\n\nFormatet p filen er det, som skrives af \"save_labels\"-kommandoen;\ndet bestr af \"add_label\"-kommandoer efter hinanden."},
/* de */ {IDGS_MON_LOAD_LABELS_DESCRIPTION_DE, "Ldt eine Datei mit Zuordnung von Adressen zu Bezeichnern. Wenn kein \nSpeicherbereich angegeben wurde, wird der Standard Speicherplatz\nverwendet. Das Format der Datei wird durch das Kommande `save_lables'\ndefiniert. Es besteht aus eine Reihe von `add_label' Kommandos,\nhintereinander angeordnet."},
/* es */ {IDGS_MON_LOAD_LABELS_DESCRIPTION_ES, "Carga fichero conteniendo mapeado de etiquetas de direcciones.  Si no\nhay espacio de memoria especificado, se usa el espacio por defecto.\n\nEl formato de fichero es el usado por el comando grabar etiquetas;\nConsiste en algunos comandos`aadir etiqueta' , grabado uno despus del otro."},
/* fr */ {IDGS_MON_LOAD_LABELS_DESCRIPTION_FR, "Charge un fichier contenant des tiquettes d'adresses. Si aucune adresse\nmmoire n'est spcifie, l'adressage par dfaut est utilis.\n\nLe format du fichier est celui utilis par la commande `save_labels';\nIl consiste de quelques commandes `add_label', crites l'une aprs l'autre."},
/* hu */ {IDGS_MON_LOAD_LABELS_DESCRIPTION_HU, "Cmkkrl cmekre lekpezseket tartalmaz fjl betltse.  Ha nincs memria\ntr megadva, az alap tr lesz hasznlva.\n\nA fjl formtuma megegyezik a `save_labels' parancs ltal kirtval;\nnhny egyms utn rt `add_label' parancsbl ll."},
/* it */ {IDGS_MON_LOAD_LABELS_DESCRIPTION_IT, "Carica un file che contiente l'associazione tra le etichette e gli indirizzi.\nSe non  specificato alcuno spazio di memoria, viene usato lo spazio\ndi lettura predefinito.\n\nIl formato del file  quello dato in output dal comando `save_labels';\n composto da alcuni comandi `add_label', scritti uno di seguito all'altro."},
/* ko */ {IDGS_MON_LOAD_LABELS_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_LOAD_LABELS_DESCRIPTION_NL, "Laad een bestand met de koppelingen tussen labels en adressen. Als er geen\ngeheugenruimte is opgegeven, zal de standaard geheugenruimte worden gebruikt.\nHet formaat van het bestand is die door het commando 'save_labels' wordt\ngeschreven; het bestaat uit een aantal 'add_label' commando's na elkaar."},
/* pl */ {IDGS_MON_LOAD_LABELS_DESCRIPTION_PL, "Wczytuje plik zawierajcy mapowanie oznacze pod adresy. Jeli nie\nokrelono zakresu pamici, uywany jest domylny zakres pamici.\n\nFormat pliku jest zapisywany komend`save_labels',\nktra skada si z komend `add_label', zapisanych jedna po drugiej."},
/* ru */ {IDGS_MON_LOAD_LABELS_DESCRIPTION_RU, "Load a file containing a mapping of labels to addresses.  If no memory\nspace is specified, the default readspace is used.\n\nThe format of the file is the one written out by the `save_labels' command;\nit consists of some `add_label' commands, written one after the other."},
/* sv */ {IDGS_MON_LOAD_LABELS_DESCRIPTION_SV, "Ls in en fil som innehller koppling frn etiketter till adresser.\nOm inget minnesomrde anges anvndas standard-lsadressen.\n\nFormatet p filen r samma som skrivs av \"save_labels\"-kommandot;\ndet bestr av ngra \"add_label\"-kommandon efter varandra."},
/* tr */ {IDGS_MON_LOAD_LABELS_DESCRIPTION_TR, "Etiketleri adreslerle eletirilmi bir dosya ykleyin.  Eer bellek\nalan belirtilmemise, varsaylan okuma alan kullanlr.\n\nDosyann biimi `save_labels' komutu ile yazlm olandr;\nbu pe pee yazlm `add_label' komutlarndan ibarettir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_SAVE_LABELS_DESCRIPTION,    N_("Save labels to a file.  If no memory space is specified, all of the\nlabels are saved.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_SAVE_LABELS_DESCRIPTION_DA, "Gem etiketter til fil. Hvis der ikke angives et hukommelsesomrde\ngemmes alle etiketter."},
/* de */ {IDGS_MON_SAVE_LABELS_DESCRIPTION_DE, "Speichere Bezeichner in eine Datei. Wenn kein Speicherbereich\nangegeben wurde, werden alle Bezeichner gespeichert."},
/* es */ {IDGS_MON_SAVE_LABELS_DESCRIPTION_ES, "Grabar etiquetas en fichero. Si no se define espacio de memoria,\nse graban todas las etiquetas."},
/* fr */ {IDGS_MON_SAVE_LABELS_DESCRIPTION_FR, "Enregistres les tiquettes dans un fichier. Si aucune adresse mmoire\nn'est spcifie, toutes les tiquettes mmoires sont sauvegardes."},
/* hu */ {IDGS_MON_SAVE_LABELS_DESCRIPTION_HU, "Cmkk mentse fjlba.  Ha nincs memria tartomny megadva, az\nsszes cmkt menti."},
/* it */ {IDGS_MON_SAVE_LABELS_DESCRIPTION_IT, "Salva le etichette su file. Se non  specificato alcuno spazio di memoria,\nvengono salvate tutte le etichette."},
/* ko */ {IDGS_MON_SAVE_LABELS_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_SAVE_LABELS_DESCRIPTION_NL, "Sla de labels op in een bestand. Als er geen geheugenruimte is opgegeven,\nworden alle labels opgeslagen."},
/* pl */ {IDGS_MON_SAVE_LABELS_DESCRIPTION_PL, "Zapisuje oznaczenia do pliku. Jeli nie okrelono obszaru pamici,\nzapisywanie s wszystkie oznaczenia."},
/* ru */ {IDGS_MON_SAVE_LABELS_DESCRIPTION_RU, "Save labels to a file.  If no memory space is specified, all of the\nlabels are saved."},
/* sv */ {IDGS_MON_SAVE_LABELS_DESCRIPTION_SV, "Spara etiketter till en fil. Om inget minnesomrde anges sparas alla\netiketterna."},
/* tr */ {IDGS_MON_SAVE_LABELS_DESCRIPTION_TR, "Etiketleri bir dosyaya kaydet.  Eer bellek alan belirtilmemise, tm\netiketler kaydedilir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_SHOW_LABELS_DESCRIPTION,    N_("Display current label mappings.  If no memory space is specified, show\nall labels from default address space.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_SHOW_LABELS_DESCRIPTION_DA, ""},  /* fuzzy */
/* de */ {IDGS_MON_SHOW_LABELS_DESCRIPTION_DE, "Zeige aktuelle Bezeichner Zuordnungen. Wenn kein Speicherbereich angegeben\nwurde, werden alle Bezeichner im Standard Adressraum gezeigt."},
/* es */ {IDGS_MON_SHOW_LABELS_DESCRIPTION_ES, ""},  /* fuzzy */
/* fr */ {IDGS_MON_SHOW_LABELS_DESCRIPTION_FR, ""},  /* fuzzy */
/* hu */ {IDGS_MON_SHOW_LABELS_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_SHOW_LABELS_DESCRIPTION_IT, ""},  /* fuzzy */
/* ko */ {IDGS_MON_SHOW_LABELS_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_SHOW_LABELS_DESCRIPTION_NL, "Toon huidige label koppelingen. Als er geen geheugenruimte is opgegeven,\nworden alle labels van de standaard geheugenruimte getoond."},
/* pl */ {IDGS_MON_SHOW_LABELS_DESCRIPTION_PL, "Poka obecne mapowania oznacze. Jeli nie okrelono obszaru pamici,\nwywietlane s wszystkie oznaczenia z domylnych obszarw pamici. "},
/* ru */ {IDGS_MON_SHOW_LABELS_DESCRIPTION_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MON_SHOW_LABELS_DESCRIPTION_SV, ""},  /* fuzzy */
/* tr */ {IDGS_MON_SHOW_LABELS_DESCRIPTION_TR, ""},  /* fuzzy */
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_CLEAR_LABELS_DESCRIPTION,    N_("Clear current label mappings.  If no memory space is specified, clear\nall labels from default address space.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_CLEAR_LABELS_DESCRIPTION_DA, ""},  /* fuzzy */
/* de */ {IDGS_MON_CLEAR_LABELS_DESCRIPTION_DE, "Lsche aktuelle Bezeichner Zuordnungen. Wenn kein Speicherbereich angegeben\nwurde, werden alle Bezeichner im Standard Adressraum gelscht."},
/* es */ {IDGS_MON_CLEAR_LABELS_DESCRIPTION_ES, ""},  /* fuzzy */
/* fr */ {IDGS_MON_CLEAR_LABELS_DESCRIPTION_FR, ""},  /* fuzzy */
/* hu */ {IDGS_MON_CLEAR_LABELS_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_CLEAR_LABELS_DESCRIPTION_IT, ""},  /* fuzzy */
/* ko */ {IDGS_MON_CLEAR_LABELS_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_CLEAR_LABELS_DESCRIPTION_NL, "Verwijder huidige label koppelingen. Als er geen geheugenruimte is opgegeven,\nworden alle labels van de standaard geheugenruimte verwijderd."},
/* pl */ {IDGS_MON_CLEAR_LABELS_DESCRIPTION_PL, "Wyczy obecne oznaczenia mapowania. Jeli nie okrelono obszaru\npamici, kasowane s wszystkie oznaczenia z domylnego obszaru pamici."},
/* ru */ {IDGS_MON_CLEAR_LABELS_DESCRIPTION_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MON_CLEAR_LABELS_DESCRIPTION_SV, ""},  /* fuzzy */
/* tr */ {IDGS_MON_CLEAR_LABELS_DESCRIPTION_TR, ""},  /* fuzzy */
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_ASSEMBLER_AND_MEMORY_COMMANDS,    N_("Assembler and memory commands:")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_DA, "Assembler- og hukommelseskommandoer:"},
/* de */ {IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_DE, "Assembler und Speicher Kommandos:"},
/* es */ {IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_ES, "Comandos Ensamblador y de memoria:"},
/* fr */ {IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_FR, "Commandes assembleur et mmoire:"},
/* hu */ {IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_HU, ""},  /* fuzzy */
/* it */ {IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_IT, "Comandi assembler e memoria:"},
/* ko */ {IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_NL, "Assembler en geheugen commando's:"},
/* pl */ {IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_PL, "Asembler i polecenia pamici:"},
/* ru */ {IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_RU, "Assembler and memory commands:"},
/* sv */ {IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_SV, "Assembler- och minneskommandon:"},
/* tr */ {IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_TR, "Assembler ve bellek komutlar:"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_DATA_LIST,    N_("data_list")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_DATA_LIST_DA, "dataliste"},
/* de */ {IDGS_DATA_LIST_DE, "Datenliste"},
/* es */ {IDGS_DATA_LIST_ES, "lista datos"},
/* fr */ {IDGS_DATA_LIST_FR, "data_list"},
/* hu */ {IDGS_DATA_LIST_HU, ""},  /* fuzzy */
/* it */ {IDGS_DATA_LIST_IT, "lista di dati"},
/* ko */ {IDGS_DATA_LIST_KO, ""},  /* fuzzy */
/* nl */ {IDGS_DATA_LIST_NL, "data_lijst"},
/* pl */ {IDGS_DATA_LIST_PL, "data_list"},
/* ru */ {IDGS_DATA_LIST_RU, "data_list"},
/* sv */ {IDGS_DATA_LIST_SV, "datalista"},
/* tr */ {IDGS_DATA_LIST_TR, "veri_listesi"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_WRITE_DESCRIPTION,    N_("Write the specified data at `address'.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_WRITE_DESCRIPTION_DA, "Gem angivne data p \"adresse\"."},
/* de */ {IDGS_MON_WRITE_DESCRIPTION_DE, "Schreibe das angegebene Datum auf `Adresse'."},
/* es */ {IDGS_MON_WRITE_DESCRIPTION_ES, "Grabar el dato especificado en `direccin'."},
/* fr */ {IDGS_MON_WRITE_DESCRIPTION_FR, "crire toutes les donnes spcifies  `address'."},
/* hu */ {IDGS_MON_WRITE_DESCRIPTION_HU, "A megadott adat `cm' helyre rsa."},
/* it */ {IDGS_MON_WRITE_DESCRIPTION_IT, "Scrive il dato specificato all'indirizzo."},
/* ko */ {IDGS_MON_WRITE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_WRITE_DESCRIPTION_NL, "Schrijf de opgegeven gegevens op `adres'."},
/* pl */ {IDGS_MON_WRITE_DESCRIPTION_PL, "Zapisuje okrelone dane w 'adresie'."},
/* ru */ {IDGS_MON_WRITE_DESCRIPTION_RU, "Write the specified data at `address'."},
/* sv */ {IDGS_MON_WRITE_DESCRIPTION_SV, "Skriv angiven data p \"adress\"."},
/* tr */ {IDGS_MON_WRITE_DESCRIPTION_TR, "`adres' blmnde belirlenmi bir veri yaz."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_INSTRUCTION,    N_("instruction")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_INSTRUCTION_DA, "instruktion"},
/* de */ {IDGS_INSTRUCTION_DE, "Instruktion"},
/* es */ {IDGS_INSTRUCTION_ES, "Instruccin"},
/* fr */ {IDGS_INSTRUCTION_FR, "instruction"},
/* hu */ {IDGS_INSTRUCTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_INSTRUCTION_IT, "istruzione"},
/* ko */ {IDGS_INSTRUCTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_INSTRUCTION_NL, "instructie"},
/* pl */ {IDGS_INSTRUCTION_PL, "instruction"},
/* ru */ {IDGS_INSTRUCTION_RU, "instruction"},
/* sv */ {IDGS_INSTRUCTION_SV, "instruktion"},
/* tr */ {IDGS_INSTRUCTION_TR, "komut"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_ASSEMBLE_DESCRIPTION,    N_("Assemble instructions to the specified address.  If only one\ninstruction is specified, enter assembly mode (enter an empty line to\nexit assembly mode).")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_ASSEMBLE_DESCRIPTION_DA, "Skriv assemblerinstruktioner til adresse. Hvis kun en instruktion\nangives, skiftes til assembler-tilstand (indtast en tom linje for\nat afslutte assembler-tilstanden)."},
/* de */ {IDGS_MON_ASSEMBLE_DESCRIPTION_DE, "Assmbler Instruktionen zur angebenen Adresse. Wenn nur eine Instruktion\nangegeben wurde, wird der assemblier Modus aktiviert (Eingabe einer leeren\nZeile beendet den assemblier Modus)."},
/* es */ {IDGS_MON_ASSEMBLE_DESCRIPTION_ES, "Ensambla instrucciones en la direccin especificada.  Si slo se\nespecifica una instruccin, entra en modo ensamblador, (entrar \nuna linea vaca para salir)."},
/* fr */ {IDGS_MON_ASSEMBLE_DESCRIPTION_FR, "Assembler les instructions  l'adresse spcifie. Si seulement\nune instruction est spcifie, entrez le mode assembleur (entrez\nune ligne vide pour quitter le mode assembleur)."},
/* hu */ {IDGS_MON_ASSEMBLE_DESCRIPTION_HU, "Utastsok fordtsa a megadott cmre. Ha csak egy utasts\nvan, fordt mdba lp (res sort kell berni a kilpshez)."},
/* it */ {IDGS_MON_ASSEMBLE_DESCRIPTION_IT, "Assembla le istruzioni a partire dall'indirizzo specificato. Se solo una\nistruzione  specificata, entra in modalit assembly (inserire una\nlinea vuota per uscire da questa modalit)."},
/* ko */ {IDGS_MON_ASSEMBLE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_ASSEMBLE_DESCRIPTION_NL, "Assembleer instructies naar het opgegeven adres. Als er alleen een instructie\nis opgegeven, wordt de assembleer modus ingeschakeld (geef een lege regel\nin om de assembleer modus te verlaten)."},
/* pl */ {IDGS_MON_ASSEMBLE_DESCRIPTION_PL, "Assembluje instrukcje pod podanym adresem. Jeli podano tylko\njedn instrukcj, wchodzi w tryb asemblowania (pusta linia\nwychodzi z trybu asemblowania)."},
/* ru */ {IDGS_MON_ASSEMBLE_DESCRIPTION_RU, "Assemble instructions to the specified address.  If only one\ninstruction is specified, enter assembly mode (enter an empty line to\nexit assembly mode)."},
/* sv */ {IDGS_MON_ASSEMBLE_DESCRIPTION_SV, "Assemblera instruktioner till angiven adress. Om endast en\ninstruktion angavs, aktivera assemblerlge (mata in en tom rad\nfr att avsluta assemblerlget)."},
/* tr */ {IDGS_MON_ASSEMBLE_DESCRIPTION_TR, "Komutlar belirlenmi adrese evir.  Eer yalnzca bir\nkomut belirlenmise, assembly moduna gir (assembly modundan kmak iin\nbo bir satr girin)."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_ADDRESS_RANGE,    N_("address_range")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ADDRESS_RANGE_DA, "adresseomrde"},
/* de */ {IDGS_ADDRESS_RANGE_DE, "Adressbereich"},
/* es */ {IDGS_ADDRESS_RANGE_ES, "Rango de direccin"},
/* fr */ {IDGS_ADDRESS_RANGE_FR, "plage_dadresses"},
/* hu */ {IDGS_ADDRESS_RANGE_HU, ""},  /* fuzzy */
/* it */ {IDGS_ADDRESS_RANGE_IT, "intervallo indirizzi"},
/* ko */ {IDGS_ADDRESS_RANGE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ADDRESS_RANGE_NL, "adres_bereik"},
/* pl */ {IDGS_ADDRESS_RANGE_PL, "address_range"},
/* ru */ {IDGS_ADDRESS_RANGE_RU, "address_range"},
/* sv */ {IDGS_ADDRESS_RANGE_SV, "adressomrde"},
/* tr */ {IDGS_ADDRESS_RANGE_TR, "adres_aral"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_COMPARE_DESCRIPTION,    N_("Compare memory from the source specified by the address range to the\ndestination specified by the address.  The regions may overlap.  Any\nvalues that miscompare are displayed using the default displaytype.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_COMPARE_DESCRIPTION_DA, "Sammenlign hukommelse fra kilden, angivet ved adresseomrdet med\nmlet, angivet ved adresse. Omrderne kan overlappe. Alle vrdier\nsom er forskellige vil blive vist med standard visning."},
/* de */ {IDGS_MON_COMPARE_DESCRIPTION_DE, "Vergleiche angegebenen Adressbereich mit der Zieladresse.\nDie Bereiche knnen berlappen. Ungleiche Werte werden mit dem\nStandardanzeigetyp gezeigt."},
/* es */ {IDGS_MON_COMPARE_DESCRIPTION_ES, "Compara memoria desde la fuente especificada por el rango de direcciones\ndestino. La regin puede estar superpuesta. Cualquier valor diferente se\nmostrar usando el tipo de pantalla por defecto."},
/* fr */ {IDGS_MON_COMPARE_DESCRIPTION_FR, "Comparer la mmoire de la source spcifie par la plage d'adresse  la\ndestination spcifie par l'adresse. Les rgions peuvent se chevaucher.\nToute valeur discordante est affiche avec le type d'affichage par dfaut."},
/* hu */ {IDGS_MON_COMPARE_DESCRIPTION_HU, "A forrs memriatartomny sszehasonltsa a cllal megadott\nmemriatartomnnyal. A tartomnyok tfedse megengedett.  Minden\nmeg nem egyez rtket kir az alap adat tpussal."},
/* it */ {IDGS_MON_COMPARE_DESCRIPTION_IT, "Confronta la memoria della sorgente specificata dall'intervallo di\nindirizzi con la destinazione specificata dall'indirizzo. Le regioni possono\nsovrapporsi. Qualsiasi valore che non corrisponde  visualizzato\nutilizzando il tipo di dato predefinito."},
/* ko */ {IDGS_MON_COMPARE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_COMPARE_DESCRIPTION_NL, "Vergelijk geheugen van de bron opgegeven door de adres reeks met het doel\nopgegeven door het adres. De reeksen mogen overlappen. De data die niet\ngelijk is zal worden getoond volgens de huidige weergavesoort."},
/* pl */ {IDGS_MON_COMPARE_DESCRIPTION_PL, "Porwnuje pami z podanego zakresu adresw z podanym adresem.\nRejony mog si pokrywa. Wszystkie niepasujce wartoci s pokazane\ndomylnym typem danych."},
/* ru */ {IDGS_MON_COMPARE_DESCRIPTION_RU, "Compare memory from the source specified by the address range to the\ndestination specified by the address.  The regions may overlap.  Any\nvalues that miscompare are displayed using the default displaytype."},
/* sv */ {IDGS_MON_COMPARE_DESCRIPTION_SV, "Jmfr minne frn kllan som anges av adressomrdet mot destinationen\nsom anges av adressen. Omrdena kan vara verlappande. Alla vrden\nsom skiljer sig vid jmfrelsen visas med standardvisningssttet."},
/* tr */ {IDGS_MON_COMPARE_DESCRIPTION_TR, "Bellei adresle belirtilen kaynaktan adresle belirtilen hedefin bulunduu\naralkta karlatr.  Blgeler belki st ste binebilir.  Uyumayan\nherhangi bir deer varsaylan grntleme tipine bal olarak grntlenir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_CHECKNUM,    N_("checknum")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CHECKNUM_DA, "checknum"},
/* de */ {IDGS_CHECKNUM_DE, "Checknummer"},
/* es */ {IDGS_CHECKNUM_ES, "nmero comprobacin"},
/* fr */ {IDGS_CHECKNUM_FR, "checknum"},
/* hu */ {IDGS_CHECKNUM_HU, ""},  /* fuzzy */
/* it */ {IDGS_CHECKNUM_IT, "checknum"},
/* ko */ {IDGS_CHECKNUM_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CHECKNUM_NL, "checknum"},
/* pl */ {IDGS_CHECKNUM_PL, "checknum"},
/* ru */ {IDGS_CHECKNUM_RU, "checknum"},
/* sv */ {IDGS_CHECKNUM_SV, "kontrollnr"},
/* tr */ {IDGS_CHECKNUM_TR, "kontrolnumaras"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DELETE_DESCRIPTION,    N_("Delete checkpoint `checknum'. If no checkpoint is specified delete all checkpoints.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_DELETE_DESCRIPTION_DA, ""},  /* fuzzy */
/* de */ {IDGS_MON_DELETE_DESCRIPTION_DE, "Lsche Checkpoint `Checknummer'. Falls kein Checkpoint angegeben wird,\nlsche alle Checkpoints."},
/* es */ {IDGS_MON_DELETE_DESCRIPTION_ES, "Borrar Punto de control `checknum'. Si no se especifica ninguno, se borran todos."},
/* fr */ {IDGS_MON_DELETE_DESCRIPTION_FR, ""},  /* fuzzy */
/* hu */ {IDGS_MON_DELETE_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_DELETE_DESCRIPTION_IT, "Cancella il punto di controllo `checknum'. Se non viene specificato alcun punto di controllo saranno cancellati tutti i punti di controllo."},
/* ko */ {IDGS_MON_DELETE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_DELETE_DESCRIPTION_NL, "Wis checkpunt 'checknum'. Als er geen checkpunt is gegeven, worden alle checkpunten gewist."},
/* pl */ {IDGS_MON_DELETE_DESCRIPTION_PL, "Skasuj punkt kontrolny 'checknum'. Jeli nie okrelono punktu kontrolnego, skasuj wszystkie."},
/* ru */ {IDGS_MON_DELETE_DESCRIPTION_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MON_DELETE_DESCRIPTION_SV, "Ta bort kontrollpunkten \"kontrollnr\". Om ingen kontrollpunkt har angivits, ta bort samtliga kontrollpunkter."},
/* tr */ {IDGS_MON_DELETE_DESCRIPTION_TR, ""},  /* fuzzy */
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DISASS_DESCRIPTION,    N_("Disassemble instructions.  If two addresses are specified, they are\nused as a start and end address.  If only one is specified, it is\ntreated as the start address and a default number of instructions are\ndisassembled.  If no addresses are specified, a default number of\ninstructions are disassembled from the dot address.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_DISASS_DESCRIPTION_DA, "Disassemblr instruktioner. Hvis der angives to adresser anvendes disse\nsom start- og slutadresse. Angives kun en adresse bruges denne som startadresse\nog et standard antal instruktioner disassembleres. Hvis ingen adresse\nangives disassembleres et standard antal instruktioner fra den aktuelle\nadresse."},
/* de */ {IDGS_MON_DISASS_DESCRIPTION_DE, "Disassembliere Instruktionen. Wenn zwei Adressen angegeben werden,\nwerden diese als Start- und Zieladresse interpretiert. Wenn nur eine\nAdress angegeben wird, wird diese asl Startadresse interpretiert und\ndie Standardanzahl an Instruktionen werden disassembliert. Wenn keine\nAdresse angegeben wird, wird von der aktuellen Adresse disassembliert."},
/* es */ {IDGS_MON_DISASS_DESCRIPTION_ES, "Desensamblar instrucciones. Si se especifican dos direcciones, se\nusan como direcciones de inicio y final. Si solo se suministra una, ser\ntratada como direccin de inicio y un nmero por defecto de  instrucciones\nsern desensambladas. Si no se especifica ninguna direccin, un nmero\npor defecto de instrucciones se desensamblaran desde la direccin pre\ndefinida"},
/* fr */ {IDGS_MON_DISASS_DESCRIPTION_FR, "Dsassembler les instructions. Si deux adresse sont spcifies, elles\nseront utilises comme adresse de dpart et de fin. Si une seule adresse\nest spcifie, elle sera traite comme adresse de dpart et un nombre\npar dfaut d'instructions seront dsassembles. Si aucune adresse n'est\nspcifie, un nombre par dfaut d'instructions seront dsassembles\ndepuis l'adresse marque d'un point."},
/* hu */ {IDGS_MON_DISASS_DESCRIPTION_HU, "Utastsok visszafejtse. Ha kt cm van megadva, els s utols\ncmknt rtelmezi ket. Ha csak egy, akkor els cmknt, s az alap\nszm utasts kerl visszafejtsre. Ha nincs cm megadva, az aktulis\ncmtl kezdi a visszafejtst, s a szoksos szm utastst r ki."},
/* it */ {IDGS_MON_DISASS_DESCRIPTION_IT, "Disassembla le istruzioni. Se sono specificati due indirizzi, questi\nsono utilizzati come indirizzo di inizio e fine. Se ne viene specificato\nsolo uno,  usato come indirizzo di partenza e viene disassemblato\nil numero di istruzioni predefinito. Se non viene specificato nessun\nindirizzo, viene disassemblato il numero di istruzioni predefinito\ndall'indirizzo dot."},
/* ko */ {IDGS_MON_DISASS_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_DISASS_DESCRIPTION_NL, "Disassembleer instructies. Als er twee adressen zijn opgegeven, worden\ndeze gebruikt als een start en eind adres. Als er maar n adres is\nopgegeven, wordt deze gebruikt als het start adres en een standaard\naantal instructies zal worden gedisassembleerd. Als er geen adressen zijn\nopgegeven, wordt een standaard aantal instructies gedisassembleerd vanaf\nhet huidige adres."},
/* pl */ {IDGS_MON_DISASS_DESCRIPTION_PL, "Deasembluje instrukcje. Jeli podano dwa adresy, uywane s jako\nadres pocztkowy i kocowy. Jeli podano tylko jeden, jest uywany\njako adres pocztkowy i deasemblowana jest domylna liczba instrukcji\nz adresu dot."},
/* ru */ {IDGS_MON_DISASS_DESCRIPTION_RU, "Disassemble instructions.  If two addresses are specified, they are\nused as a start and end address.  If only one is specified, it is\ntreated as the start address and a default number of instructions are\ndisassembled.  If no addresses are specified, a default number of\ninstructions are disassembled from the dot address."},
/* sv */ {IDGS_MON_DISASS_DESCRIPTION_SV, "Disassemblera instruktioner. Om tv adresser anges anvnds de som\nstart- och slutadress. Om endast en anges anvnds den som startadress\noch ett standardantal instruktioner disassembleras. Om ingen adress\nanges disassembleras ett standardantal instruktioner frn punktadressen."},
/* tr */ {IDGS_MON_DISASS_DESCRIPTION_TR, "Komutlar disassemble et.  Eer iki adres girildiyse, bunlar balang\nve biti adresleri olarak kullanlr.  Eer tek adres girildiyse, bu\nadres balang adresi olarak kabul edilir ve varsaylan sayda komutlar\ndisassemble edilir.  Eer hi adres girilmediyse, varsaylan sayda\nkomutlar nokta balang adresinden itibaren disassemble edilir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_FILL_DESCRIPTION,    N_("Fill memory in the specified address range with the data in\n<data_list>.  If the size of the address range is greater than the size\nof the data_list, the data_list is repeated.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_FILL_DESCRIPTION_DA, "Fyld hukommelsen i det angivne adresseomrde med data fra <dataliste>.\nHvis strrelsen p adresseomrdet er strre end strrelsen af dataliste\ngentages indholdet i dataliste."},
/* de */ {IDGS_MON_FILL_DESCRIPTION_DE, "Flle den angegebenen Adressbereich mit den Daten aus <Datenliste>.\nWenn die Gre des Adressbereichs grer als <Datenliste> ist, werden\ndie Daten wiederholt."},
/* es */ {IDGS_MON_FILL_DESCRIPTION_ES, "Rellenar memoria en el rango especificado con el dato contenido en\n <lista datos>. Si el tamao del rango es mayor que el <lista datos>\nse repite lista datos."},
/* fr */ {IDGS_MON_FILL_DESCRIPTION_FR, "Remplir la plage d'adresses mmoire avec les donnes de\n<data_list>. Si la longueur de la plage d'adresses est\nplus grande que cette de la data_list, alors la data_list\nsera rpte."},
/* hu */ {IDGS_MON_FILL_DESCRIPTION_HU, "A memria kitltse az <adat_lista> paramterben megadott adatokkal.\nHa a cmtartomny nagyobb, mint a lista, ismtelni fogja azt."},
/* it */ {IDGS_MON_FILL_DESCRIPTION_IT, "Riempe la memoria nell'intervallo di indirizzi specificato con i dati\npresenti in <lista di dati>. Se la dimensione dell'intervallo  maggiore\ndella dimensione della lista di dati, la lista di dati  ripetuta."},
/* ko */ {IDGS_MON_FILL_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_FILL_DESCRIPTION_NL, "Vul het geheugen van de opgegeven adresreeks op met de data in <data_lijst>.\nAls de grootte van de adresreeks groter is dan de grootte van de data_lijst,\nzal de data_lijst worden herhaald."},
/* pl */ {IDGS_MON_FILL_DESCRIPTION_PL, "Wypenia pami w danym zakresie adresw danymi z <lista_danych>.\nJeli wielko zakresu adresw jest wiksza ni wielko listy_danych,\nlista_danych jest powtarzana."},
/* ru */ {IDGS_MON_FILL_DESCRIPTION_RU, "Fill memory in the specified address range with the data in\n<data_list>.  If the size of the address range is greater than the size\nof the data_list, the data_list is repeated."},
/* sv */ {IDGS_MON_FILL_DESCRIPTION_SV, "Fyll minnet i det angivna omrdet med data i <datalista>.\nOm storleken p adressomrdet r strre n storleken p datalistan\nrepeteras innehllet i datalistan."},
/* tr */ {IDGS_MON_FILL_DESCRIPTION_TR, "<veri_listesi>'nde bulunan verilerle belirtilen bellek araln doldur.\nEer verilen adres aral veri_listesi'nden bykse, veri_listesi'nde\nyer alan veriler tekrar ettirilir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_HUNT_DESCRIPTION,    N_("Hunt memory in the specified address range for the data in\n<data_list>.  If the data is found, the starting address of the match\nis displayed.  The entire range is searched for all possible matches.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_HUNT_DESCRIPTION_DA, "Sg i hukommelsen i det angivne dataomrde efter <dataliste>.\nHvis data findes vises startadressen for matchet. Hele\nomrdet gennemsges for at finde alle mulige match."},
/* de */ {IDGS_MON_HUNT_DESCRIPTION_DE, "Suche in angebenen Adressbereich nach <Datenliste>. Wenn die Daten gefunden\nwurden, wird die Startadresse gezeigt. Der komplette Bereich wird alle\nVorkommnisse von <Datenliste> untersucht."},
/* es */ {IDGS_MON_HUNT_DESCRIPTION_ES, "Buscar en memoria en el rango de direcciones especificado por\n<lista datos>. Si se encuentra, se muestra la direccin del dato.\nSe busca en todo el rango buscando posibles concordancias."},
/* fr */ {IDGS_MON_HUNT_DESCRIPTION_FR, "Rechercher  l'intrieur de la plage d'adresses pour les\ndonnes de <data_list>. Si les donnes sont trouves,\nl'adresse de dpart de la concordance est affiche. La\nplage complte est recherche pour toutes les concordances\npossibles."},
/* hu */ {IDGS_MON_HUNT_DESCRIPTION_HU, "Az <adat_lista> adat keresse a memriban. Ha megtallja a sorozatot,\na kezdcmt kirja. Az egsz tartomnyt vgignzi az sszes lehetsges\ntallat felfedezshez."},
/* it */ {IDGS_MON_HUNT_DESCRIPTION_IT, "Cerca nell'intervallo di indirizzi specificato i dati nella <lista di dati>.\nSe il dato  trovato, viene visualizzato l'indirizzo iniziale della\ncorrispondenza. Tutto l'intervallo viene ricercato per tutte le possibili\ncorrispondenze."},
/* ko */ {IDGS_MON_HUNT_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_HUNT_DESCRIPTION_NL, "Zoek het adresbereik voor de data in <data_lijst>. Als de data is gevonden,\n wordt het startadres getoond. Er zal door de hele reeks worden gezocht."},
/* pl */ {IDGS_MON_HUNT_DESCRIPTION_PL, "Szukaj danych z <lista_danych> w pamici w podanym zakresie\nadresw. Jeli znaleziono dane, pokazany jest pocztkowy adres\ntrafienia. Cay zakres jest przeszukiwany dla wszystkich moliwych	rafie."},
/* ru */ {IDGS_MON_HUNT_DESCRIPTION_RU, "Hunt memory in the specified address range for the data in\n<data_list>.  If the data is found, the starting address of the match\nis displayed.  The entire range is searched for all possible matches."},
/* sv */ {IDGS_MON_HUNT_DESCRIPTION_SV, "Sk i minnet i det angivna omrdet med data efter <datalista>.\nOm data ptrffas visas startadressen fr trffen. Hela\nomrdet genomsks fr att hitta alla mjliga trffar."},
/* tr */ {IDGS_MON_HUNT_DESCRIPTION_TR, "<veri_listesi>'nde bulunan veriler iin belirtilen bellek aralnda\narama yap.  Eer veri bulunursa, eleen adres aralnn balang\nadresi grntlenir.  Tm alan mmkn olan elemeler iin aranacaktr."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_ADDRESS_OPT_RANGE,    N_("address_opt_range")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ADDRESS_OPT_RANGE_DA, "adresse_evt_omrde"},
/* de */ {IDGS_ADDRESS_OPT_RANGE_DE, "Optionaler Adressbereich"},
/* es */ {IDGS_ADDRESS_OPT_RANGE_ES, "Rango direccin"},
/* fr */ {IDGS_ADDRESS_OPT_RANGE_FR, "plage_dadresses_opt"},
/* hu */ {IDGS_ADDRESS_OPT_RANGE_HU, ""},  /* fuzzy */
/* it */ {IDGS_ADDRESS_OPT_RANGE_IT, "intervallo di indirizzi opzionale"},
/* ko */ {IDGS_ADDRESS_OPT_RANGE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ADDRESS_OPT_RANGE_NL, "optionele_adres_bereik"},
/* pl */ {IDGS_ADDRESS_OPT_RANGE_PL, "address_opt_range"},
/* ru */ {IDGS_ADDRESS_OPT_RANGE_RU, "address_opt_range"},
/* sv */ {IDGS_ADDRESS_OPT_RANGE_SV, "adress_ev_omrde"},
/* tr */ {IDGS_ADDRESS_OPT_RANGE_TR, "opsiyonel_adres_aral"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_I_DESCRIPTION,    N_("Display memory contents as PETSCII text.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_I_DESCRIPTION_DA, "Vis hukommelsesindhold som PETSCII-text."},
/* de */ {IDGS_MON_I_DESCRIPTION_DE, "Zeige Speicherinhalt als PETSCII Text."},
/* es */ {IDGS_MON_I_DESCRIPTION_ES, "Mostrar contenido memoria como texto PETSCII."},
/* fr */ {IDGS_MON_I_DESCRIPTION_FR, "Afficher le contenu de la mmoire en tant que texte PETSCII."},
/* hu */ {IDGS_MON_I_DESCRIPTION_HU, "Memria tartalom mutatsa PETSCII szvegknt."},
/* it */ {IDGS_MON_I_DESCRIPTION_IT, "Mostra il contenuto della memoria come testo PETSCII."},
/* ko */ {IDGS_MON_I_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_I_DESCRIPTION_NL, "Toon geheugeninhoud als PETSCII tekst."},
/* pl */ {IDGS_MON_I_DESCRIPTION_PL, "Poka zawarto pamici jako tekst PETSCII."},
/* ru */ {IDGS_MON_I_DESCRIPTION_RU, "Display memory contents as PETSCII text."},
/* sv */ {IDGS_MON_I_DESCRIPTION_SV, "Visa minnesinnehll som PETSCII-text."},
/* tr */ {IDGS_MON_I_DESCRIPTION_TR, "Bellek ieriini PETSCII yaz biiminde grntle."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_II_DESCRIPTION,    N_("Display memory contents as screen code text.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_II_DESCRIPTION_DA, "Vis hukommelses-indhold som skrm-koder."},
/* de */ {IDGS_MON_II_DESCRIPTION_DE, "Zeige Speicherinhalt als Bildschirmcode Text."},
/* es */ {IDGS_MON_II_DESCRIPTION_ES, "Mostrar contenidos de memoria con cdigo texto pantalla."},
/* fr */ {IDGS_MON_II_DESCRIPTION_FR, "Afficher le contenu de la mmoire en tant que texte avec codes-cran."},
/* hu */ {IDGS_MON_II_DESCRIPTION_HU, "Memria tartalom megjelentse kperny kd szvegknt."},
/* it */ {IDGS_MON_II_DESCRIPTION_IT, "Mostra il contenuto della memoria come testo screen code."},
/* ko */ {IDGS_MON_II_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_II_DESCRIPTION_NL, "Toon geheugen inhoud als schermcode tekst."},
/* pl */ {IDGS_MON_II_DESCRIPTION_PL, "Poka zawarto pamici jako tekst screen code."},
/* ru */ {IDGS_MON_II_DESCRIPTION_RU, "Display memory contents as screen code text."},
/* sv */ {IDGS_MON_II_DESCRIPTION_SV, "Visa minnesinnehll som skrmkodstext."},
/* tr */ {IDGS_MON_II_DESCRIPTION_TR, "Bellek ieriini ekran kodu yaz biiminde grntle."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_DATA_TYPE,    N_("data_type")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_DATA_TYPE_DA, "datatype"},
/* de */ {IDGS_DATA_TYPE_DE, "Datentyp"},
/* es */ {IDGS_DATA_TYPE_ES, "tipo datos"},
/* fr */ {IDGS_DATA_TYPE_FR, "type_de_donnes"},
/* hu */ {IDGS_DATA_TYPE_HU, ""},  /* fuzzy */
/* it */ {IDGS_DATA_TYPE_IT, "dati"},
/* ko */ {IDGS_DATA_TYPE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_DATA_TYPE_NL, "data_soort"},
/* pl */ {IDGS_DATA_TYPE_PL, "data_type"},
/* ru */ {IDGS_DATA_TYPE_RU, "data_type"},
/* sv */ {IDGS_DATA_TYPE_SV, "datatyp"},
/* tr */ {IDGS_DATA_TYPE_TR, "veri_tipi"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_MEM_DESCRIPTION,    N_("Display the contents of memory.  If no datatype is given, the default\nis used.  If only one address is specified, the length of data\ndisplayed is based on the datatype.  If no addresses are given, the\n'dot' address is used.\nPlease note: due to the ambiguous meaning of 'b' and 'd' these data-\ntypes must be given in uppercase!")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_MEM_DESCRIPTION_DA, "Vis hukommelsens indhold. Hvis datatype ikke angives, bruges standard.\nHvis kun en adresse angives, justeres lngden p visningen baseret\np datatypen. Hvis der ikke angives nogen adresse anvendes \"punktum\"-adressen.\nNote: P grund af tvetydighed for 'b' og 'd' skal disse datatyper\nangives med store bogstaver!"},
/* de */ {IDGS_MON_MEM_DESCRIPTION_DE, "Zeige Speicherinhalt. Wenn kein Datentyp angegeben wurde, wird der\nStandarddatentyp verwendet. Wenn nur eine Adresse angegeben wird, hngt\ndie Lnge der Daten vom Datentyp ab. Wenn keine Adresse angeben wurde, \nwird die aktuelle Adresse verwendet.\nAchtung: Wegen der Mehrdeutigkeit von `b' und `d', mssen die\nDatentypen in Grobuchstaben angegeben werden!"},
/* es */ {IDGS_MON_MEM_DESCRIPTION_ES, "Mostrar el contenido de memoria. Si no se da tipo de datos, se usa el\npor defecto. Si slo se da una direccin, la longitud de dato\nmostrado se basa en el tipo dato. Si no se dan direcciones, se \nusa la direccin 'dot'Por favor, note que debido al ambiguo significado de 'b' y 'd' estos\ntipos de dato se mostrararn en maysculas."},
/* fr */ {IDGS_MON_MEM_DESCRIPTION_FR, "Affiche le contenu de la mmoire. Si aucun type de donnes est donn,\nle type par dfaut est utilis. Si une seule adresse est spcifie,\nla longueur des donnes affiches est base sur le type de donnes.\nSi aucune adresse n'est donne, l'adresse marque d'un point est utilise.\nSVP noter que vu l'ambigut de 'b' et 'd' ces types de donnes\ndoivent tres donns en lettres majuscules!"},
/* hu */ {IDGS_MON_MEM_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_MEM_DESCRIPTION_IT, "Mostra il contenuto della memoria. Se non  specificato alcun tipo di\ndato, verr utilizzato quello predefinito. Se  specificato solo un indirizzo,\nla lunghezza del dato visualizzato  basata sul tipo. Se non  specificato\nnessun indirizzo, varr utilizzato l'indirizzo 'dot'.Nota bene: a causa del significato ambiguo di 'b' e 'd' questi tipi di dati\ndevono essere inseriti in maiuscolo!"},
/* ko */ {IDGS_MON_MEM_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_MEM_DESCRIPTION_NL, "Toon de geheugeninhoud. Als er geen datasoort is opgegeven, zal de standaard\nworden gebruikt. Als er maar n adres is opgegeven, zal de lengte van de\ngetoonde data gebaseerd worden op de datasoort. Als er geen adres is opgegeven,\nzal het huidige adres worden gebruikt. Door de onduidelijke betekenis \nvan 'b' en 'd' moeten deze datasoorten opgegeven worden in hoofdletters!"},
/* pl */ {IDGS_MON_MEM_DESCRIPTION_PL, "Pokazuje zawarto pamici. Jeli nie ustalono typu danych, jest\nuywany domylny. Jeli okrelono tylko jeden adres, dugo\npokazanych danych zaley od ich typu. Jeli nie podano adresu,\nuywany jest adres 'kropka'. Uwaga: w zwizku z wieloznacznoci 'b' i 'd', te typy danych\nnaley poda wielk liter!"},
/* ru */ {IDGS_MON_MEM_DESCRIPTION_RU, "Display the contents of memory.  If no datatype is given, the default\nis used.  If only one address is specified, the length of data\ndisplayed is based on the datatype.  If no addresses are given, the\n'dot' address is used.\nPlease note: due to the ambiguous meaning of 'b' and 'd' these data-\ntypes must be given in uppercase!"},
/* sv */ {IDGS_MON_MEM_DESCRIPTION_SV, "Visa minnets innehll. Om ingen datatyp anges, anvnds standard.\nOm endast en adress anges, justeras lngden p visad data baserat\np datatypen. Om ingen adress anges anvnds \"punkt\"-adressen.\nObservera: p grund av tvetydig betydelse av \"b\" och \"d\" mste dessa\ndatatyper anges med stora bokstver!"},
/* tr */ {IDGS_MON_MEM_DESCRIPTION_TR, "Bellek ieriini gster.  Eer veri tipi girilmemise, varsaylan\nkullanlr.  Yalnzca bir adres belirtilmise, gsterilen verinin\nuzunluu veri tipine baldr.  Eer hi adres girilmemise, 'nokta'\nadresi kullanlr.\nLtfen dikkat: 'b' ve 'd'nin karmak anlamlarndan tr bu veri\ntipleri bykharf olarak verilmelidir!"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_MEMCHAR_DESCRIPTION,    N_("Display the contents of memory as character data.  If only one address\nis specified, only one character is displayed.  If no addresses are\ngiven, the ``dot'' address is used.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_MEMCHAR_DESCRIPTION_DA, "Vis hukommelsens indhold som tegndata. Hvis kun en adresse\nangives, vises kun et tegn. Hvis ingen adresse angives benyttes\n\"punktum\"-adressen."},
/* de */ {IDGS_MON_MEMCHAR_DESCRIPTION_DE, "Zeige den Inhalt von Speicher als Character Daten. Wenn nur eine Adresse\nangegeben wurde, wird nur ein Zeichen gezeigt. Wenn keine Adresse angegeben\nwurde, wird die aktuelle Adresse verwendet."},
/* es */ {IDGS_MON_MEMCHAR_DESCRIPTION_ES, "Mostrar el contenido de memoria como datos de carcter. Si slo se una\ndireccin es especificada, slo se muestra un carcter. Si no se da\nninguna direccin, se usa la direccin 'dot'."},
/* fr */ {IDGS_MON_MEMCHAR_DESCRIPTION_FR, "Affiche le contenu de la mmoire en tant que caractres. Si une seule\nadresse est spcifie, un seul caractre est donn. si aucune adresse\nn'est spcifie, alors l'adresse marque d'un point est utilise."},
/* hu */ {IDGS_MON_MEMCHAR_DESCRIPTION_HU, "A memria tartalmnak megjelentse karakter grafikaknt.  Ha csak egy cm\nadott, egyetlen karakter rajzoldik ki.  Ha nincs cm megadva,\na ``pont'' cmet hasznlja."},
/* it */ {IDGS_MON_MEMCHAR_DESCRIPTION_IT, "Mosta il contenuto della memoria come dati caratteri. Se  specificato\nsolo un indirizzo, verr visualizzato solo un carattere. Se non \nspecificato alcun indirizzo, varr utilizzato l'indirizzo ``dot'' ."},
/* ko */ {IDGS_MON_MEMCHAR_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_MEMCHAR_DESCRIPTION_NL, "Toon de geheugeninhoud als karakterdata. Als er maar n adres is\nopgegeven, zal er maar n karakter worden weergegeven. Als er geen\nadres is opgegeven, zal het huidige adres gebruikt worden."},
/* pl */ {IDGS_MON_MEMCHAR_DESCRIPTION_PL, "Poka zawarto pamici jako dane znakowe. Jeli podano tylko jeden\nadres, pokazany jest tylko jeden znak. Jeli nie podano adresw, uyty\njest adres 'kropka'."},
/* ru */ {IDGS_MON_MEMCHAR_DESCRIPTION_RU, "Display the contents of memory as character data.  If only one address\nis specified, only one character is displayed.  If no addresses are\ngiven, the ``dot'' address is used."},
/* sv */ {IDGS_MON_MEMCHAR_DESCRIPTION_SV, "Visa minnets innehll som teckendata. Om endast en adress\nanges, visas endast ett tecken. Om ingen adress anges anvnds\n\"punkt\"-adressen."},
/* tr */ {IDGS_MON_MEMCHAR_DESCRIPTION_TR, "Bellek ieriini karakter verisi olarak gster.  Yalnzca bir adres\nbelirtilmise, yalnzca tek karakter grntlenir.  Eer hi adres\ngirilmemise, 'nokta' adresi kullanlr."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_FORMAT,    N_("Format")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_FORMAT_DA, "Format"},
/* de */ {IDGS_FORMAT_DE, "Format"},
/* es */ {IDGS_FORMAT_ES, "Formato"},
/* fr */ {IDGS_FORMAT_FR, "Format"},
/* hu */ {IDGS_FORMAT_HU, "Formtum"},
/* it */ {IDGS_FORMAT_IT, "Formato"},
/* ko */ {IDGS_FORMAT_KO, " "},
/* nl */ {IDGS_FORMAT_NL, "Formaat"},
/* pl */ {IDGS_FORMAT_PL, "Format"},
/* ru */ {IDGS_FORMAT_RU, ""},
/* sv */ {IDGS_FORMAT_SV, "Format"},
/* tr */ {IDGS_FORMAT_TR, "Biim"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_MEMMAPSAVE_DESCRIPTION,    N_("Save the memmap as a picture. Format is:\n0 = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_MEMMAPSAVE_DESCRIPTION_DA, "Gem memmap som billede. Format:\n0 = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* de */ {IDGS_MON_MEMMAPSAVE_DESCRIPTION_DE, "Speicher die memmap als Bilddaten. Formate:\n0 = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* es */ {IDGS_MON_MEMMAPSAVE_DESCRIPTION_ES, "Graba mapa memoria como grfico. el formato es:\n0 = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* fr */ {IDGS_MON_MEMMAPSAVE_DESCRIPTION_FR, "Sauvegarder le plan de la mmoire comme une image.\nLes formats sont:\n0 = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* hu */ {IDGS_MON_MEMMAPSAVE_DESCRIPTION_HU, "Memria trkp mentse kpknt. A formtum:\n0 = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* it */ {IDGS_MON_MEMMAPSAVE_DESCRIPTION_IT, "Salva la mappa di memoria come immagine. I Formati sono:\n0 = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* ko */ {IDGS_MON_MEMMAPSAVE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_MEMMAPSAVE_DESCRIPTION_NL, "Sla de memmap op als een afbeelding. Formaat is:\n0 = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* pl */ {IDGS_MON_MEMMAPSAVE_DESCRIPTION_PL, "Zapisz map pamici jako obrazek. Format:\n0 = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* ru */ {IDGS_MON_MEMMAPSAVE_DESCRIPTION_RU, "Save the memmap as a picture. Format is:\n0 = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* sv */ {IDGS_MON_MEMMAPSAVE_DESCRIPTION_SV, "Sparar minneskartan som en bild. Format:\n0 = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* tr */ {IDGS_MON_MEMMAPSAVE_DESCRIPTION_TR, "Bellek haritasn resim olarak kaydet. Biim:\n0 = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MASK,    N_("mask")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MASK_DA, "maske"},
/* de */ {IDGS_MASK_DE, "Maske"},
/* es */ {IDGS_MASK_ES, "mscara"},
/* fr */ {IDGS_MASK_FR, "masque"},
/* hu */ {IDGS_MASK_HU, ""},  /* fuzzy */
/* it */ {IDGS_MASK_IT, "maschera"},
/* ko */ {IDGS_MASK_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MASK_NL, "masker"},
/* pl */ {IDGS_MASK_PL, "mask"},
/* ru */ {IDGS_MASK_RU, "mask"},
/* sv */ {IDGS_MASK_SV, "mask"},
/* tr */ {IDGS_MASK_TR, "maske"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_MEMMAPSHOW_DESCRIPTION,    N_("Show the memmap. The mask can be specified to show only those\nlocations with accesses of certain type(s). The mask is a number\nwith the bits \"ioRWXrwx\", where RWX are for ROM and rwx for RAM.\nOptionally, an address range can be specified.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_MEMMAPSHOW_DESCRIPTION_DA, "Vis memmap. Masken kan angives for kun at vise de celler, som\ner tilget med valgte typer tilgang. Masken er et tal med\nbitsne \"ioRWXrwx\", hvor RWX er ROM og rwx er RAM.\nEt adresseomrde kan eventuelt angives."},
/* de */ {IDGS_MON_MEMMAPSHOW_DESCRIPTION_DE, "Zeige die memmap. Die Maske kann so definiert werden, dass nur jene Orte\nmit Zugriff auf spezifische Typ(en) gezeigt werden. Die Maske ist eine Nummer\nmit Bits \"ioRWXrwx\", wobei RWX fr ROM und rwx fr RAM steht.\nOptional kann ein Adressbereich definiert werden."},
/* es */ {IDGS_MON_MEMMAPSHOW_DESCRIPTION_ES, "Mostrar el mapa de memoria. La mascara puede definirse para mostrar\nslo aquellas localizaciones con un determinado tipo(s). La mscara es\nun nmero con bits \"ioRVXrvx\", donde RWX son para ROM y rwx son\npara RAM. Opcionalmente, se puede especificar un rango de direcciones."},
/* fr */ {IDGS_MON_MEMMAPSHOW_DESCRIPTION_FR, "Affiche le plan de la mmoire. Un masque peut tre spcifi pour\nne montrer que les emplacements avec accs  certains type(s).\nLe masque est un nombre avec les bits \"ioRWXrwx\", ou RWX est\npour le ROM et rwx pour le RAM.\nOptionnellement, une plage d'adresses peut tre spcifie."},
/* hu */ {IDGS_MON_MEMMAPSHOW_DESCRIPTION_HU, "A memria trkp mutatsa. A maszk gy llthat, hogy csak azokat a\nhelyeket mutassa, amelyek a megadott elrssel rendelkeznek. A maszk\negy szm az \"ioRWXrwx\" bitekkel, ahol az RWX a ROM-ra, az rwx a RAM-ra\nvonatkozik. Tetszs szerint egy cmtartomny is megadhat."},
/* it */ {IDGS_MON_MEMMAPSHOW_DESCRIPTION_IT, "Mostra la mappa di memoria. La maschera pu essere specificata per\nmostrare solo quelle locazioni con accessi di un certo tipo. La maschera\n un numero con i bit \"ioRWXrwx\", dove RWX sono per la ROM e\nrwx per la RAM.\nOpzionalmente, pu essere specificato anche un intervallo di indirizzi."},
/* ko */ {IDGS_MON_MEMMAPSHOW_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_MEMMAPSHOW_DESCRIPTION_NL, "Toon de memmap. Het masker kan worden opgegeven zodat er alleen de\nadressen met toegangen van een bepaalde soort(en) zal worden getoond.\nHet masker is een nummer met de bits \"ioRWXrwx\", waar RWX staat voor ROM,\nen rwx voor RAM. Er kan optioneel een adresbereik worden opgegeven."},
/* pl */ {IDGS_MON_MEMMAPSHOW_DESCRIPTION_PL, "Pokazuje map pamici. By pokaza tylko obszar dostpw danego typu,\nmona okreli mask. Maska to numer zawierajcy bity \"ioRWXrwx\", gdzie\nRWX to ROM, a rwx to RAM. Opcjonalnie mona okreli zakres adresw."},
/* ru */ {IDGS_MON_MEMMAPSHOW_DESCRIPTION_RU, "Show the memmap. The mask can be specified to show only those\nlocations with accesses of certain type(s). The mask is a number\nwith the bits \"ioRWXrwx\", where RWX are for ROM and rwx for RAM.\nOptionally, an address range can be specified."},
/* sv */ {IDGS_MON_MEMMAPSHOW_DESCRIPTION_SV, "Visa minneskartan. Masken kan anges fr att endast visa de\nceller som gller specifik(a) typ(er). Masken r ett tal\nmed bitarna \"ioRWXrwx\", dr RWX r fr ROM och rwx r fr\nRAM. Ett minnesomrde kan eventuellt anges."},
/* tr */ {IDGS_MON_MEMMAPSHOW_DESCRIPTION_TR, "Bellek haritasn gster. Maske, yalnzca belirli tiplerce eriilebilen\nkonumlarda belirtilebilir. Maske \"ioRWXrwx\" bitlerinden oluan bir\nsaydr. RWX ROM'u, rwx RAM'i ifade eder. Opsiyonel olarak bir adres\naral belirtilebilir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_MEMMAPZAP_DESCRIPTION,    N_("Clear the memmap.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_MEMMAPZAP_DESCRIPTION_DA, "Nulstil memmap."},
/* de */ {IDGS_MON_MEMMAPZAP_DESCRIPTION_DE, "Lsche die memmap."},
/* es */ {IDGS_MON_MEMMAPZAP_DESCRIPTION_ES, "Limpiar mapa de memoria."},
/* fr */ {IDGS_MON_MEMMAPZAP_DESCRIPTION_FR, "Effacer le plan de la mmoire."},
/* hu */ {IDGS_MON_MEMMAPZAP_DESCRIPTION_HU, "A memria trkp trlse."},
/* it */ {IDGS_MON_MEMMAPZAP_DESCRIPTION_IT, "Cancella la mappa di meoria."},
/* ko */ {IDGS_MON_MEMMAPZAP_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_MEMMAPZAP_DESCRIPTION_NL, "Veeg de memmap schoon."},
/* pl */ {IDGS_MON_MEMMAPZAP_DESCRIPTION_PL, "Wyczy map pamici."},
/* ru */ {IDGS_MON_MEMMAPZAP_DESCRIPTION_RU, "Clear the memmap."},
/* sv */ {IDGS_MON_MEMMAPZAP_DESCRIPTION_SV, "Tm minneskartan."},
/* tr */ {IDGS_MON_MEMMAPZAP_DESCRIPTION_TR, "Bellek haritasn temizle."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_MEMSPRITE_DESCRIPTION,    N_("Display the contents of memory as sprite data.  If only one address is\nspecified, only one sprite is displayed.  If no addresses are given,\nthe ``dot'' address is used.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_MEMSPRITE_DESCRIPTION_DA, "Vis hukommelsens indhold som spritedata. Hvis kun en adresse\nangives, vises kun en sprite. Hvis ingen adresse angives bruges\n\"punktum\"-adressen."},
/* de */ {IDGS_MON_MEMSPRITE_DESCRIPTION_DE, "Zeige den Speicher als Sprite Daten. Wenn nur eine Adresse angegeben wurde,\nwird nur ein Sprite gezeitg. Wenn keine Adresse angegeben wurde, wird\ndie aktuelle Adresse verwendet."},
/* es */ {IDGS_MON_MEMSPRITE_DESCRIPTION_ES, "Mostrar el contenido de memoria como datos de sprites, Si slo se \nespecifica una direccin, solo se muestra un sprite. Si no se dan\ndirecciones, se usa la direccin 'dot'."},
/* fr */ {IDGS_MON_MEMSPRITE_DESCRIPTION_FR, "Afficher le contenu de la mmoire en tant que donnes sprite. Si une\nseule adresse est spcifie, un seul sprite est affich. Si aucune\nadresse n'est spcifie, le sprite  l'adresse marque d'un point est\naffich."},
/* hu */ {IDGS_MON_MEMSPRITE_DESCRIPTION_HU, "A memria tartalmnak megjelentse sprite adatkne. Ha csak egy cm\nvan megadva, egyetlen sprite-ot mutat.  Ha egyltaln nincs cm megadva,\naz aktulis cmet hasznlja."},
/* it */ {IDGS_MON_MEMSPRITE_DESCRIPTION_IT, "Mostra il contenuto della memoria come dati sprite. Se  specificato\nsolo un indirizzo, verr mostrato solo uno sprite. Se non  specificato\nalcun indirizzo, varr utilizzato l'indirizzo ``dot''."},
/* ko */ {IDGS_MON_MEMSPRITE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_MEMSPRITE_DESCRIPTION_NL, "Toon de geheugeninhoud als sprite data. Als er maar n adres is opgegeven,\nzal er maar n sprite worden getoond. Als er geen adres is opgegeven,\nzal het huidige adres worden gebruikt."},
/* pl */ {IDGS_MON_MEMSPRITE_DESCRIPTION_PL, "Pokazuje zawarto pamici jako dane duszkw. Jeli podano tylko jeden\nadres, pokazywany jest tylko jeden duszek. Jeli nie podano adresu,\nuywany jest adres ``dot'."},
/* ru */ {IDGS_MON_MEMSPRITE_DESCRIPTION_RU, "Display the contents of memory as sprite data.  If only one address is\nspecified, only one sprite is displayed.  If no addresses are given,\nthe ``dot'' address is used."},
/* sv */ {IDGS_MON_MEMSPRITE_DESCRIPTION_SV, "Visa minnets innehll som spritedata. Om endast en adress\nanges, visas endast en sprite. Om ingen adress anges anvnds\n\"punkt\"-adressen."},
/* tr */ {IDGS_MON_MEMSPRITE_DESCRIPTION_TR, "Bellek ieriini yaratk verisi olarak gster.  Yalnzca bir adres\nbelirtilmise, yalnzca tek yaratk grntlenir.  Eer hi adres\ngirilmemise, 'nokta' adresi kullanlr."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_MOVE_DESCRIPTION,    N_("Move memory from the source specified by the address range to\nthe destination specified by the address.  The regions may overlap.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_MOVE_DESCRIPTION_DA, "Kopir data fra kilden angivet af hukommelsesomrdet til destinationen\nsom angives af adressen. Regionerne kan overlappe."},
/* de */ {IDGS_MON_MOVE_DESCRIPTION_DE, "Verschiebe Speicher von Startadresse definiert durch den Adressbereich zum\nZielbereich definiert durch die Adresse. Die Bereiche knnen berlappend sein."},
/* es */ {IDGS_MON_MOVE_DESCRIPTION_ES, "Mueve memoria desde la fuente especificada por rango de direcciones\nal destino especificado en direccin. La regin puede estas superpuesta."},
/* fr */ {IDGS_MON_MOVE_DESCRIPTION_FR, "Dplacer la mmoire de la source spcifie par la plage d'adresses\n la destination spcifie par l'adresse. Les rgions peuvent se\nchevaucher."},
/* hu */ {IDGS_MON_MOVE_DESCRIPTION_HU, "Memria msolsa a forrs terletrl a cl cm ltal meghatrozott\nterletre. A tartomnyok tfedse megengedett."},
/* it */ {IDGS_MON_MOVE_DESCRIPTION_IT, "Sposta la memoria dalla sorgente specificata dall'intervallo di indirizzi\nalla destinazione specificata dall'indirizzo. Le regioni possono\nsovrapporsi."},
/* ko */ {IDGS_MON_MOVE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_MOVE_DESCRIPTION_NL, "Verplaats data van de opgegeven bron adres reeks naar het doel adres. De\nreeksen kunnen overlappen."},
/* pl */ {IDGS_MON_MOVE_DESCRIPTION_PL, "Przesuwa pami z okrelonego zakresu adresw pod podany adres.\nZakresy mog si pokrywa."},
/* ru */ {IDGS_MON_MOVE_DESCRIPTION_RU, "Move memory from the source specified by the address range to\nthe destination specified by the address.  The regions may overlap."},
/* sv */ {IDGS_MON_MOVE_DESCRIPTION_SV, "Flytta minne frn klladressen som anges av minnesomrdet\ntill destinationen som anges av adressen. Regionerna kan vara\nverlappande."},
/* tr */ {IDGS_MON_MOVE_DESCRIPTION_TR, "Bellei belirtilmi kaynak adres aralndan belirtilmi hedef\nadresine ta.  Alanlar st ste binebilir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_CHECKPOINT_COMMANDS,    N_("Checkpoint commands:")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CHECKPOINT_COMMANDS_DA, "Checkpoint-kommandoer:"},
/* de */ {IDGS_CHECKPOINT_COMMANDS_DE, "Checkpoint Kommandos:"},
/* es */ {IDGS_CHECKPOINT_COMMANDS_ES, "Comandos de control:"},
/* fr */ {IDGS_CHECKPOINT_COMMANDS_FR, "Commandes de points d'arrt:"},
/* hu */ {IDGS_CHECKPOINT_COMMANDS_HU, ""},  /* fuzzy */
/* it */ {IDGS_CHECKPOINT_COMMANDS_IT, "Comandi punti di controllo:"},
/* ko */ {IDGS_CHECKPOINT_COMMANDS_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CHECKPOINT_COMMANDS_NL, "Checkpunt commando's:"},
/* pl */ {IDGS_CHECKPOINT_COMMANDS_PL, "Komendy punktw kontrolnych:"},
/* ru */ {IDGS_CHECKPOINT_COMMANDS_RU, "Checkpoint commands:"},
/* sv */ {IDGS_CHECKPOINT_COMMANDS_SV, "Kommandon fr brytpunkter:"},
/* tr */ {IDGS_CHECKPOINT_COMMANDS_TR, "Kontrol Noktas komutlar:"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_COND_EXPR,    N_("cond_expr")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_COND_EXPR_DA, "betingelse"},
/* de */ {IDGS_COND_EXPR_DE, "bedingter Ausdruck"},
/* es */ {IDGS_COND_EXPR_ES, "Expr_cond"},
/* fr */ {IDGS_COND_EXPR_FR, "expr_cond"},
/* hu */ {IDGS_COND_EXPR_HU, ""},  /* fuzzy */
/* it */ {IDGS_COND_EXPR_IT, "espressione condizione"},
/* ko */ {IDGS_COND_EXPR_KO, ""},  /* fuzzy */
/* nl */ {IDGS_COND_EXPR_NL, "cond_expr"},
/* pl */ {IDGS_COND_EXPR_PL, "cond_expr"},
/* ru */ {IDGS_COND_EXPR_RU, "cond_expr"},
/* sv */ {IDGS_COND_EXPR_SV, "villkorsuttryck"},
/* tr */ {IDGS_COND_EXPR_TR, "koul_idafesi"},
#endif

/*
   Translators: this command was extended:

   - "load|store|exec" option added

   TODO: update these languages: DA, DE, HU, IT, NL, SV, TR
*/

/* monitor/mon_command.c */
/* en */ {IDGS_MON_BREAK_DESCRIPTION,    N_("Set a breakpoint, If no address is given, the currently valid break-\npoints are printed.\nIf an address is given, a breakpoint is set for that address and the\nbreakpoint number is printed.\n`load|store|exec' is either `load', `store' or `exec' (or any combina-\ntion of these) to specify on which operation the monitor breaks. If\nnot specified, the monitor breaks on `exec'.\nA conditional expression can also be specified for the breakpoint.\nFor more information on conditions, see the CONDITION command.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_BREAK_DESCRIPTION_DA, "St et breakpoint. Hvis der ikke angives en adresse vises en liste\nover nuvrende gyldige breakpoints.\nHvis der angives en adresse vil der blive sat et breakpoint p\ndenne, og breakpointets nummer udskrives.\n`load|store|exec' er enten `load', `store' eller `exec' (eller en\nvilkrlig kombination), og angiver p hvilken operation monitoren\nafbryder. Hvis intet angives vil monitoren afbryde p `exec'.\nDer kan ogs angives en betingelse for det angivne breakpoint. For\nyderligere information om betingede udtryk, se kommandoen CONDITION."},
/* de */ {IDGS_MON_BREAK_DESCRIPTION_DE, "Setze einen Breakpoint. Wenn keine Adresse angegeben wurde, werden die\naktuellen gltigen Breakpoints gezeigt. \nWenn eine Adresse angegebene wurde, wird ein Breakpoint auf diese Adresse\ngesetzt und die Breakpoint Nummer wird ausgegeben.\n`load|store|exec' ist entweder `load', `store' oder `exec' (oder eine\nKombination) und dient zur Angabe, bei welcher Operation der Monitor\nanhalten soll. Wenn keine Angabe gemacht wird, stoppt der Monitor bei\n`exec'.\nEin bedingter Ausdruck kann zu Breakpoints zugeordnet werden. Fr\nmehr Informations ber bedingte Ausdrcke, bitte Kommando CONDITION\nansehen."},
/* es */ {IDGS_MON_BREAK_DESCRIPTION_ES, "Poner punto de ruptura. Si no se da direccin, se imprime el actual punto\nde control. Si se da una direccin, se activa un punto de ruptura en la misma\ny se imprime el nmero de punto de ruptura.\n`load|store|exec' es cualquiera de `load', `store' or `exec' (o combinacin\nde ellos) a especificar en que operacin el monitor se detiene. Si no se\nespecifica, el monitor se detiene en `exec'.\nSe puede especificar tambin una condicin para el punto de ruptura.\nPara ms informacin sobre condiciones, ver el comando CONDITION."},
/* fr */ {IDGS_MON_BREAK_DESCRIPTION_FR, "Crer un point d'arrt. Si aucune adresse n'est spcifie, les points\nd'arrt valides sont affichs.\nsi une adresse est spcifie, un point d'arrt est cr pour cette\nadresse et le numro de point d'arrt est affich.\n`load|store|exec' est soit `load', `store' ou `exec' (ou toute\ncombinaison) pour spcifier  quelle opration le moniteur arrte.\nSi aucun n'est spcifi, le moniteur arrte  `exec'.\nUne expression conditionnelle peut aussi tre spcifie pour le\npoint d'arrt. Pour plus d'informations sur les conditions,\nvoir la commande CONDITION."},
/* hu */ {IDGS_MON_BREAK_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_BREAK_DESCRIPTION_IT, "Imposta un breakpoint. Se non viene specificato alcun indirizzo,\nvengono stampati i breakpoint attuali.\nSe viene specificato un indirizzo, viene impostato un breakpoint\nper tale indirizzo e viene stampato il suo numero.\n`load|store|exec'  uno tra `load', `store' o `exec' (or una qualunque\ncombinazione di questi) per specificare su quale operazione il monitor\ninterromper. Se non specificato, il monitor interrompe su `exec'.\nPu anche essere specificata una condizione per il breakpoint.\nPer ulteriori informazioni, vedere il comando CONDITION."},
/* ko */ {IDGS_MON_BREAK_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_BREAK_DESCRIPTION_NL, "Zet een breekpunt, als er geen adres is opgegeven, zullen de huidige\ngeldige breekpunten worden geprint. Als er een adres is opgegeven,\nzal er een breekpunt gezet worden voor dat adres en het nummer van het\nbreekpunt zal worden getoond.\n`load|store|exec' is `load', `store' of `exec' (of een combinatie) die\ngebruikt zal worden om aan te geven bij welke operatie de monitor zou\nmoeten starten. Als er niets is opgegeven, zal de monitor op 'exec'\nstarten.\nEen conditie kan worden opgegeven voor het breekpunt. Voor meer\ninformatie over condities zie de CONDITION commando."},
/* pl */ {IDGS_MON_BREAK_DESCRIPTION_PL, "Ustawia punkt wstrzymania. Jeli nie podano adresu, pokazywane s\nobecnie aktywne punkty wstrzymania.\nJeli podano adres, ustawiany jest punkt wstrzymania dla tego adresu\ni pokazywany jest numer punktu wstrzymania.\n`load|store|exec' to `load', `store' lub `exec' (albo ich poczenia),\nokrelajce  podczas ktrych operacji nastpuje bd. Jeli nic\nnie okrelono, monitor przerywa dziaanie na `exec'.\nMona rwnie okreli wyraenie warunkowe dla punktu wstrzymania.\nBy znale wicej informacji o warunkach, zobacz polecenie CONDITION."},
/* ru */ {IDGS_MON_BREAK_DESCRIPTION_RU, "Set a breakpoint, If no address is given, the currently valid break-\npoints are printed.\nIf an address is given, a breakpoint is set for that address and the\nbreakpoint number is printed.\n`load|store|exec' is either `load', `store' or `exec' (or any combina-\ntion of these) to specify on which operation the monitor breaks. If\nnot specified, the monitor breaks on `exec'.\nA conditional expression can also be specified for the breakpoint.\nFor more information on conditions, see the CONDITION command."},
/* sv */ {IDGS_MON_BREAK_DESCRIPTION_SV, "Stt en vervakningspunkt, Om ingen adress anges visas de \nvervakningspunkter som r giltiga.\nOm en adress anges stts en brytpunkt p den adressen och dess\nnummer visas.\n\"load|store|exec\" r antingen \"load\", \"store\" eller \"exec\"\n(eller en kombination drutav) fr att ange p vilken operation\nmonitorn stoppar. Om det inte anges bryter monitorn p \"exec\".\nEtt villkorsuttryck kan ocks anges fr brytpunkten.\nFr mer information om villkor, se kommandot CONDITION."},
/* tr */ {IDGS_MON_BREAK_DESCRIPTION_TR, "Kesme noktas koy, eer adres girilmemise, geerli mevcut izleme\nnoktalar yazdrlr.\nEer bir adres girilmise, o adres iin bir kesme noktas iaretlenir\nve kesme noktas says yazdrlr.\n`ykle|depola|yrt' iin `ykle', `depola' ya da `yrt' (ya da herhangi\nbir kombinasyonu) takip edilmek istenen operasyona gre belirtilmelidir.\nEer belirtilmemise, takip ilemi `yrt'de sona erer.\nAyn zamanda kesme noktas iin bir koul ifadesi de belirtilebilir.\nKoullar ile ilgili daha ok bilgi almak iin, CONDITION komutuna\nbakabilirsiniz."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_COMMAND,    N_("Command")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_COMMAND_DA, "Kommando"},
/* de */ {IDGS_COMMAND_DE, "Kommando"},
/* es */ {IDGS_COMMAND_ES, "Comando"},
/* fr */ {IDGS_COMMAND_FR, "Commande"},
/* hu */ {IDGS_COMMAND_HU, ""},  /* fuzzy */
/* it */ {IDGS_COMMAND_IT, "Comando"},
/* ko */ {IDGS_COMMAND_KO, ""},
/* nl */ {IDGS_COMMAND_NL, "Commando"},
/* pl */ {IDGS_COMMAND_PL, "Polecenie"},
/* ru */ {IDGS_COMMAND_RU, "Command"},
/* sv */ {IDGS_COMMAND_SV, "Kommando"},
/* tr */ {IDGS_COMMAND_TR, "Komut"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_COMMAND_DESCRIPTION,    N_("Specify `command' as the command to execute when checkpoint `checknum'\nis hit.  Note that the `x' command is not yet supported as a\ncommand argument.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_COMMAND_DESCRIPTION_DA, "Angiv \"kommando\" som kommando der skal eksekveres nr ckeckpoint\n\"checknum\" ns. Vr opmrksom p at kommandoen \"x\" endnu ikke\ner understttet som parameter."},
/* de */ {IDGS_MON_COMMAND_DESCRIPTION_DE, "Definiere `Kommando', welches bei Checkpoint `Checknum' ausgefhrt wird.\nAchtung Kommando `x' wird zurzeit noch nicht als Kommando Argument\nuntersttzt."},
/* es */ {IDGS_MON_COMMAND_DESCRIPTION_ES, "Especificar 'comando' como el comando a ejecutar cuando el punto de control\n'checknum' est activo. notar que el comando 'x' no est soportado como\nargumento de comando."},
/* fr */ {IDGS_MON_COMMAND_DESCRIPTION_FR, "Spcifier `command' comme commande  excuter quand le point d'arrt\n`checknum' est atteint. Noter que la commande `x' n'est pas encore\nsupporte comme argument de commande."},
/* hu */ {IDGS_MON_COMMAND_DESCRIPTION_HU, "`parancs' megadsa egy `ell_pont_szm' sorszmval adott ellenrzsi pont\nelrsekor trtn vgrehajtsra.  Az `x' parancs egyelre nem hasznlhat\nitt paramterknt."},
/* it */ {IDGS_MON_COMMAND_DESCRIPTION_IT, "Specifica `comando' come il comando da eseguire quando\nviene incontrato il punto di controllo `checknum'. Nota che \nil comando `x' non  ancora supportato come parametro."},
/* ko */ {IDGS_MON_COMMAND_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_COMMAND_DESCRIPTION_NL, "Geef `commando' als het commando om uit te voeren wanneer checkpunt `checknum'\nwordt uitgevoerd. NB: het `x' commando is op dit moment geen geldige\nparameter."},
/* pl */ {IDGS_MON_COMMAND_DESCRIPTION_PL, "Okrel 'command' jako polecenie do wykonania przy osigniciu punktu 'checknum.'\nPolecenie 'x' nie jest jeszcze obsugiwane jako argument polecenia."},
/* ru */ {IDGS_MON_COMMAND_DESCRIPTION_RU, "Specify `command' as the command to execute when checkpoint `checknum'\nis hit.  Note that the `x' command is not yet supported as a\ncommand argument."},
/* sv */ {IDGS_MON_COMMAND_DESCRIPTION_SV, "Ange \"kommando\" som kommando att exekvera nr vid trff p\nkontrollpunkten\"kontrollnr\". Observera att kommandot \"x\" nnu\ninte stds som kommandoparameter."},
/* tr */ {IDGS_MON_COMMAND_DESCRIPTION_TR, "Kontrol noktas `kontrolnumaras'na ulaldnda `komut' olarak\naltrlacak komutu belirt.  Henz `x' komutunun bir komut argman\nolarak desteklenmediini not edin."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_CONDITION_DESCRIPTION,    N_("Each time the specified checkpoint is examined, the condition is\nevaluated. If it evalutes to true, the checkpoint is activated.\nOtherwise, it is ignored. If registers are specified in the expression,\nthe values used are those at the time the checkpoint is examined, not\nwhen the condition is set.\nThe condition can use registers (A, X, Y, PC, SP, FL and other cpu\nspecific registers (see manual)) and compare them (==, !=, <, >, <=, >=)\nagainst other registers or constants.\nRegisters can be the registers of other devices; this is denoted by\na memspace prefix (i.e., c:, 8:, 9:, 10:, 11:\nExamples: A == 0, X == Y, 8:X == X)\n")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_CONDITION_DESCRIPTION_DA, ""},  /* fuzzy */
/* de */ {IDGS_MON_CONDITION_DESCRIPTION_DE, "Bei jeder berprfung des Checkpoints, wird die Bedingung evaluiert.\nIst das Ergebnis `Wahr', wird der Checkpoint aktiviert, sonst ingnoriert.\nWenn Register benutzt werden, werden deren Werte zum Zeitpunkt der \nberprfung herangezogen, nicht zum Zeitpunkt des Setzens der Bedingung.\nDie Bedingung kann Register benutzen (A, X, Y, PC, SP, FL und andere\nCPU spezifische Register (siehe Handbuch)) und gegen andere Register oder\nKonstanten vergleichen (==, !=, <, >, <=, >=).\nRegister knnen auch Gerteregister sein; dazu wird die memspace Prefix-syntax \nverwendet: c:, 8:, 9:, 10:, 11:\nBeispiel: A == 0, X == Y, 8:X == X\n"},
/* es */ {IDGS_MON_CONDITION_DESCRIPTION_ES, "Cada vez que un punto de control se examine, la condicin se\nevaluar. Si la condicin es cierta, se activa el punto de control.\nSi no, se ignora. Si los registros estn especificado en la condicin,\nse usan los valores en el momento en el que se examina el punto\nde ruptura, no en el momento de poner la condicin.\nLa condicin puede usar los registros (.A, .X, .Y, .PC, .SP)  y compararlos\nm (==, !=, <, >, <=, >=) con otros registros y constantes.\nLos registros pueden ser de otros perifricos, esto se denota por el\nprefijo de espacio memoria (ej., c:, 8:, 9:, 10:, 11:\nEjemplos: .A == 0, .X == .Y, 8:.X == .X\n"},
/* fr */ {IDGS_MON_CONDITION_DESCRIPTION_FR, ""},  /* fuzzy */
/* hu */ {IDGS_MON_CONDITION_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_CONDITION_DESCRIPTION_IT, "Ogni volta che si esamina il punto di controllo specificato, viene valutata\nla condizione. Se  vera, il punto di controllo  attivato.\nAltrimenti viene ignorato. Se nell'espressione sono specificati i registri,\nquesti valori sono quelli usati quando viene esaminato il punto di controllo,\nnon quando viene impostata la condizione.\nLa condizione pu fare uso dei registri (A, X, Y, PC, SP, FL e altri registri\nspecifici della cpu (vedi manuale)) e confrontarli (==, !=, <, >, <=, >=)\ncon altri registri o costanti.\nI registri possono essere registri di altre periferiche; questo  denotato da\nun prefisso che specifica lo spazio di memoria (cio, c:, 8:, 9:, 10:, 11:)\nAlcuni esempi: A == 0, X == Y, 8:X == X)\n"},
/* ko */ {IDGS_MON_CONDITION_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_CONDITION_DESCRIPTION_NL, "Elke keer dat het opgegeven checkpunt wordt onderzocht zal de conditie worden\ngevalueerd. Als de evaluatie positief is dan zal de checkpunt geactiveerd\nworden, bij negatief zal er niets worden gedaan. Als er registers zijn\nopgegeven in de expressie dan zullen de waarden in die registers gebruikt\nworden op het moment dat de checkpunt wordt onderzocht, niet op het moment\ndat de conditie is opgegeven.\nDe conditie kan gebruik maken van registers (A, X, Y, PC, SP, FL en andere\nspecifieke registers (zie handleiding) en kan ze vergelijken\n (==, !=, <, >, <=, >=) met andere registers of constanten\nRegisters kunnen de registers van andere apparaten zijn; de manier van opgeven\nis door een geheugenruimte prefix (bijvoorbeeld: c:, 8:, 9:, 10:, 11:\nVoorbeelden: A == 0, X == Y, 8:X == X\n"},
/* pl */ {IDGS_MON_CONDITION_DESCRIPTION_PL, "Podczas analizy punktu kontrolnego okrelany jest stan.\nJeli jest okrelony jako 'prawda', punkt kontrolny jest\nuaktywniany. W innym razie jest ignorowany. Jeli w wyraeniu\npodano rejestry, uywane s wartoci z czasu szacowania punktu\nkontrolnego, nie z czasu ustawienia stanu.\nStan moe korzysta z rejestrw A, X, Y, PC, SP, FL, jak rwnie\ninnych, konkretnych dla danego procesora (patrz w instrukcji) i porwnywa je\n(==, !=, <, >, <=, >=) z innymi rejestrami lub staymi. Rejestry mog by\nrejestrami innych urzdze, co jest okrelone przedrostkiem przestrzeni\npamici (np. c:, 8:, 9:, 10:, 11:\nPrzykady: A == 0, X == Y, 8:X == X)\n"},
/* ru */ {IDGS_MON_CONDITION_DESCRIPTION_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MON_CONDITION_DESCRIPTION_SV, ""},  /* fuzzy */
/* tr */ {IDGS_MON_CONDITION_DESCRIPTION_TR, ""},  /* fuzzy */
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DISABLE_DESCRIPTION,    N_("Disable checkpoint `checknum'. If no checkpoint is given all checkpoints will be disabled.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_DISABLE_DESCRIPTION_DA, ""},  /* fuzzy */
/* de */ {IDGS_MON_DISABLE_DESCRIPTION_DE, "Deaktiviere Checkpoint `Checknummer'. Falls kein Checkpoint angegeben wird,\nwerden alle Checkpoints deaktiviert."},
/* es */ {IDGS_MON_DISABLE_DESCRIPTION_ES, "Deshabilitar Punto de control `checknum'. Si no se especifica ninguno, se deshabilitan todos."},
/* fr */ {IDGS_MON_DISABLE_DESCRIPTION_FR, ""},  /* fuzzy */
/* hu */ {IDGS_MON_DISABLE_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_DISABLE_DESCRIPTION_IT, "Disattiva il punto di controllo `checknum'. Se non viene specificato alcun punto di controllo saranno disattivati tutti i punti di controllo."},
/* ko */ {IDGS_MON_DISABLE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_DISABLE_DESCRIPTION_NL, "Checkpunt 'checknum' uitschakelen. Als er geen checkpunt is gegeven, worden alle checkpunten uitgeschakeld."},
/* pl */ {IDGS_MON_DISABLE_DESCRIPTION_PL, "Wycz punkt kontrolny 'checknum'. Jeli nie okrelono punktu kontrolnego, skasuj wszystkie."},
/* ru */ {IDGS_MON_DISABLE_DESCRIPTION_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MON_DISABLE_DESCRIPTION_SV, ""},  /* fuzzy */
/* tr */ {IDGS_MON_DISABLE_DESCRIPTION_TR, ""},  /* fuzzy */
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_ENABLE_DESCRIPTION,    N_("Enable checkpoint `checknum'. If no checkpoint is given all checkpoints will be enabled.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_ENABLE_DESCRIPTION_DA, ""},  /* fuzzy */
/* de */ {IDGS_MON_ENABLE_DESCRIPTION_DE, "Aktiviere Checkpoint `Checknummer'. Falls kein Checkpoint angegeben wird,\nwerden alle Checkpoints aktiviert."},
/* es */ {IDGS_MON_ENABLE_DESCRIPTION_ES, "Permitir Punto de control `checknum'. Si no se especifica ninguno, se habilitan todos."},
/* fr */ {IDGS_MON_ENABLE_DESCRIPTION_FR, ""},  /* fuzzy */
/* hu */ {IDGS_MON_ENABLE_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_ENABLE_DESCRIPTION_IT, "Attiva il punto di controllo `checknum'. Se non viene specificato alcun punto di controllo saranno attivati tutti i punti di controllo."},
/* ko */ {IDGS_MON_ENABLE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_ENABLE_DESCRIPTION_NL, "Checkpunt 'checknum' inschakelen. Als er geen checkpunt is gegeven, worden alle checkpunten ingeschakeld."},
/* pl */ {IDGS_MON_ENABLE_DESCRIPTION_PL, "Wcz punkt kontrolny 'checknum'. Jeli nie okrelono punktu kontrolnego, skasuj wszystkie."},
/* ru */ {IDGS_MON_ENABLE_DESCRIPTION_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MON_ENABLE_DESCRIPTION_SV, ""},  /* fuzzy */
/* tr */ {IDGS_MON_ENABLE_DESCRIPTION_TR, ""},  /* fuzzy */
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_IGNORE_DESCRIPTION,    N_("Ignore a checkpoint a given number of crossings.  If no count is given,\nthe default value is 1.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_IGNORE_DESCRIPTION_DA, "Ignorr et checkpoint det angivne antal gange. Hvis antal ikke angives\nbruges standardvrdien 1."},
/* de */ {IDGS_MON_IGNORE_DESCRIPTION_DE, "Ignoriere den Checkpoint fr die angegebene Anzahl an Aktivierungen.\nWenn kein `Zhler' angegeben wurde, wird der Standardwert 1 verwendet."},
/* es */ {IDGS_MON_IGNORE_DESCRIPTION_ES, "Ignorar un punto control un numero determinado de veces. Si no se da contador,\nel valor por defecto es 1."},
/* fr */ {IDGS_MON_IGNORE_DESCRIPTION_FR, "Ignorer un point d'arrt un certain nombre de passages. Si aucun compte\nn'est donne, la valeur par dfaut de 1 sera utilise."},
/* hu */ {IDGS_MON_IGNORE_DESCRIPTION_HU, "Az ellenrzsi pont figyelmen kvl hagysa megadott szm thaladskor.  Ha nincs\nszm megadva, az alaprtelmezett rtk 1."},
/* it */ {IDGS_MON_IGNORE_DESCRIPTION_IT, "Ignora un punto di controllo un numero specificato di occorrenze. Se\nnon  specificato alcun valore, quello predefinito  1."},
/* ko */ {IDGS_MON_IGNORE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_IGNORE_DESCRIPTION_NL, "Negeer een checkpunt een opgegeven aantal keer. Als er geen aantal is\nopgegeven, wordt de standaardwaarde van 1 gebruikt."},
/* pl */ {IDGS_MON_IGNORE_DESCRIPTION_PL, "Ignoruje punkt kontrolny dan ilo razy. Jeli nie podano tej iloci,\ndomylna warto wynosi 1."},
/* ru */ {IDGS_MON_IGNORE_DESCRIPTION_RU, "Ignore a checkpoint a given number of crossings.  If no count is given,\nthe default value is 1."},
/* sv */ {IDGS_MON_IGNORE_DESCRIPTION_SV, "Ignorera en kontrollpunkt det givna antalet gnger. Om inget antal ges\nr standardvrdet 1."},
/* tr */ {IDGS_MON_IGNORE_DESCRIPTION_TR, "Bir kontrol noktasn verilen adette gei iin yoksay.  Eer adet verilmemise,\nvarsaylan deer 1'dir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_UNTIL_DESCRIPTION,    N_("If no address is given, the currently valid breakpoints are printed.\nIf an address is given, a temporary breakpoint is set for that address\nand the breakpoint number is printed.  Control is returned to the\nemulator by this command.  The breakpoint is deleted once it is hit.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_UNTIL_DESCRIPTION_DA, "Hvis ingen adresse angives vises de aktuelle breakpoints. Hvis en\nadresse angives sttes et midlertidigt breakpoint, og nummeret p\nbreakpointet vises. Kontrollen returneres til emulatoren af denne\nkommando. Breakpointet fjernes nr det ns."},
/* de */ {IDGS_MON_UNTIL_DESCRIPTION_DE, "Wenn keine Adresse angegeben wurde, werden die aktuell gltigen \nBreakpoints angezeigt. Wenn eine Adresse angegeben wurde, wird ein \ntemporrer Breakpoint auf dieser Adresse gesetzt und die Breakpoint Nummer wird\nangezeigt. Die Kontrolle wirdd bei diesem Kommando an die Emulation gegeben.\nDer Breakpoint wird gelscht, wenn er einmal getroffen wurde."},
/* es */ {IDGS_MON_UNTIL_DESCRIPTION_ES, "Si no se da direccin, se imprime el ltimo punto de ruptura vlido.\nSi se da direccin, se activa un punto de ruptura para la direccin\ny se imprime el nmero del punto de ruptura. El control se devuelve al\nemulador por el comando. El punto de ruptura se borra una vez se encuentra."},
/* fr */ {IDGS_MON_UNTIL_DESCRIPTION_FR, "Si aucune adresse n'est donne, les points d'arrts prsentement valides\nseront affichs. Si aucune adresse n'est donne, un point d'arrt\ntemporaire est cr pour cette adresse et le numro de point d'arrt\nest affich. Le contrle retourne  l'mulateur suite  cette commande.\nLe point d'arrt est supprim une fois atteint."},
/* hu */ {IDGS_MON_UNTIL_DESCRIPTION_HU, "Ha nincs cm megadva, a jelenleg rvnyes trspontokat rja ki.\nHa van adott cm, egy ideiglenes trspontot helyez el az adott cmre,\ns a trspont szma kirdik.  A vezrls visszakerl az emultorhoz\ne parancs ltal. A trspont elrsekor trldik."},
/* it */ {IDGS_MON_UNTIL_DESCRIPTION_IT, "Se non viene specificato alcun indirizzo, vengono stampati i\nbreakpoint attualmente validi. Se viene specificato un indirizzo,\nviene impostato un breakpoint temporaneo per tale indirizzo e\nviene stampato il suo numero. Il controllo ritorna all'emulatore\nper mezzo di questo comando. Il breakpoint  cancellato quando\nviene incontrato."},
/* ko */ {IDGS_MON_UNTIL_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_UNTIL_DESCRIPTION_NL, "Als er geen adres is opgegeven, zullen de huidig geldige breekpunten\nworden geprint. Als er een adres is opgegeven, wordt er een tijdelijk\nbreekpunt gezet voor dat adres en het breekpunt nummer zal worden\ngetoond. Na het geven van dit commando zal er teruggekeerd worden naar de\nemulator. Het breekpunt zal worden verwijderd na het uitvoeren."},
/* pl */ {IDGS_MON_UNTIL_DESCRIPTION_PL, "Jeli nie podano adresu, pokazywane s obecne punkty wstrzymania.\nJeli podano adres, ustawiany jest tymczasowy punkt wstrzymania\ni pokazywany jest numer punktu wstrzymania. To polecenie przywraca\nkontrol do emulatora. Punkt wstrzymania jest kasowany po jego osigniciu."},
/* ru */ {IDGS_MON_UNTIL_DESCRIPTION_RU, "If no address is given, the currently valid breakpoints are printed.\nIf an address is given, a temporary breakpoint is set for that address\nand the breakpoint number is printed.  Control is returned to the\nemulator by this command.  The breakpoint is deleted once it is hit."},
/* sv */ {IDGS_MON_UNTIL_DESCRIPTION_SV, "Om du inte anger ngon adress visas de fr nrvarande giltiga\nbrytpunkterna. Om en adress anges stts en temporr brytpunkt fr\nden adressen och numret p den nya brytpunkten visas. Styrningen\nterlmnas till emulatorn fr det hr kommandot. Brytpunkten\ntas bort nr den har ntts."},
/* tr */ {IDGS_MON_UNTIL_DESCRIPTION_TR, "Eer adres girilmemise, geerli mevcut kesme noktalar yazdrlr.\nEer bir adres girilmise, o adres iin geici bir kesme noktas\niaretlenir ve kesme noktas says yazdrlr.  Kontrol bu komutla\nemlatre dndrlr.  Bir kere eriildii zaman kesme noktas silinir."},
#endif

/*
   Translators: this command was extended:

   - "loadstore" option is now "load|store|exec"
   - conditional expression was added

   TODO: update these languages: DA, DE, HU, IT, NL, SV, TR
*/

/* monitor/mon_command.c */
/* en */ {IDGS_MON_WATCH_DESCRIPTION,    N_("Set a watchpoint. If no address is given, the currently valid watch-\npoints are printed. If a single address is specified, set a watchpoint\nfor that address.  If two addresses are specified, set a watchpoint\nfor the memory locations between the two addresses.\n`load|store|exec' is either `load', `store' or `exec' (or any combina-\ntion of these) to specify on which operation the monitor breaks. If\nnot specified, the monitor breaks on `load' and `store'.\n")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_WATCH_DESCRIPTION_DA, "St et watchpoint. Hvis der ikke angives en adresse vises en liste\nover nuvrende gyldige watchpoints. Hvis der angives en enkelt\nadresse sttes et watchpoint p adressen. Hvis der angives to adresser\nsttes et watchpoint for hukommelsesomrdet mellem adresserne.\n`load|store|exec' er enten `load', `store' eller `exec' (eller en\nvilkrlig kombination), og angiver p hvilken operation monitoren\nafbryder. Hvis intet angives vil monitoren afbryde p `load' og\n`store'.\n"},
/* de */ {IDGS_MON_WATCH_DESCRIPTION_DE, "Setze einen Watchpoint. Wenn eine einzelne Adresse angegeben wurde, setze \nden Watchpoint fr diese Adresse. Wenn zwei Adressen angegeben wurden, \nsetze den Watchpoint auf die Adressen zwischen den beiden Adressen.\n`load|store|exec' ist entweder `load', `store' oder `exec' (oder eine\nKombination) und dient zur Angabe, bei welcher Operation der Monitor\nanhalten soll. Wenn keine Angabe gemacht wird, stoppt der Monitor bei\n`exec'.\nWenn keine Angabe gemacht wurde, hlt der Monitor bei bei `load' und\n`store' Operationen an.\n"},
/* es */ {IDGS_MON_WATCH_DESCRIPTION_ES, "Poner punto de visualizacin. Si no se da direccin se mostrar el\nactualmente vlido. Si se da una direccin simple, se pondr un punto\nde visualizacin en la misma\nSi se dan dos direcciones se activar un punto de visualizacin para las\nlocalizaciones de memoria entre ambas direcciones.\n`load|store|exec' es cualquiera de `load', `store' or `exec' (o alguna com-\nbinacin de ellos) para especificar en que operacin el monitor se detiene\nSi no se especifica, Se detiene en  `load' y `store'.\n"},
/* fr */ {IDGS_MON_WATCH_DESCRIPTION_FR, "Cre un point de surveillance. Si aucune adresse n'est spcifie, les\npoints de surveillance valides sont affichs. Si une adresse est\nspcifie, cre un point de surveillance  cette adresse. Si deux\nadresses sont spcifis, cre un point de surveillance pour les\nadresses mmoire situes entre les deux adresses.\n`load|store|exec' est soit `load', `store' ou `exec' (or toute\ncombinaison) pour spcifier  quelle opration le moniteur arrte. Si\naucune n'est spcifi, le moniteur arrte  `load' et `store'.\n"},
/* hu */ {IDGS_MON_WATCH_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_WATCH_DESCRIPTION_IT, "Imposta un watchpoint. Se non viene specificato alcun indirizzo,\nvengono stampati i watchpoint attuali. Se viene specificato solo un\nsolo indirizzo, imposta un watchpoint per tale indirizzo. Se vengono\nspecificati due indirizzi, imposta un watchpoint per le locazioni di \nmemoria comprese tra i due indirizzi.\n`load|store|exec'  uno tra `load', `store' o `exec' (or una qualunque\ncombinazione di questi) per specificare su quale operazione il monitor\ninterromper. Se non specificato, il monitor interrompe su `load' e\n`store'.\n"},
/* ko */ {IDGS_MON_WATCH_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_WATCH_DESCRIPTION_NL, "Zet een kijkpunt. Als er geen adres is opgegeven, zullen de huidige\ngeldige kijkpunten worden getoond. Als er een enkel adres is opgegeven,\nzal er een kijkpunt worden gezet voor dat adres. Als er twee\nadressen zijn opgegeven, zal er een kijkpunt worden gezet voor de\nadressen tussen de twee adressen.\n`load|store|exec' is `load',  `store' of `exec' om aan te geven bij\nwelke operatie de monitor zou moeten starten. Als deze niet opgegeven\nis, zal de monitor starten bij `load' en `store' operaties.\n"},
/* pl */ {IDGS_MON_WATCH_DESCRIPTION_PL, "Ustawia punkt ledzenia. Jeli nie podano adresu, pokazywane s\nobecnie aktualne punkty ledzenia. Jeli okrelono pojedynczy adres,\nustawia punkt ledzenia na ten adres. Jsli okrelono dwa adresy,\nustawia punkt ledzenia dla obszaru pamici pomidzy tymi dwoma\nadresami.\n`load|store|exec' to `load', `store' lub `exec' (albo ich poczenia),\nokrelajce  podczas ktrych operacji nastpuje bd. Jeli nic\nnie okrelono, monitor przerywa dziaanie na `load' i `store'.\n"},
/* ru */ {IDGS_MON_WATCH_DESCRIPTION_RU, "Set a watchpoint. If no address is given, the currently valid watch-\npoints are printed. If a single address is specified, set a watchpoint\nfor that address.  If two addresses are specified, set a watchpoint\nfor the memory locations between the two addresses.\n`load|store|exec' is either `load', `store' or `exec' (or any combina-\ntion of these) to specify on which operation the monitor breaks. If\nnot specified, the monitor breaks on `load' and `store'.\n"},
/* sv */ {IDGS_MON_WATCH_DESCRIPTION_SV, "Stt en vervakningspunkt. Om du inte anger ngon adress, visas\nnu giltiga vervakningspunkter. Om du anger en ensam adress stts en\nvervakningspunkt fr adressen. Om tv adresser anges stts en\nvervakningspunkt fr minnesomrdet mellan adresserna.\n\"load|store|exec\" r antingen \"load\". \"store\" eller \"exec\" (eller en\nkombination drutav) och anger vilken operation monitorn skall\nstoppa fr. Om den inte anges stoppar emulatorn p bde \"load\" och\n\"store\".\n"},
/* tr */ {IDGS_MON_WATCH_DESCRIPTION_TR, "Bir grntleme noktas koy. Eer hi adres verilmemise, mevcut geerli\ngrntleme noktalar yazdrlr. Eer tek bir adres belirtilmise,\ngrntleme noktasn o adrese koy.  Eer iki adres belirtilmise, grntleme\nnoktasn o iki adres arasnda kalan adreslere koy.\n`ykle|depola|yrt' monitrn kesildii operatre bal olarak `ykle'\n`depola' ya da `yrt' (ya da herhangi bir kombinasyonunda) ilemlerinde\nalabilir. Eer belirtilmemise, monitr `ykle' ve `depola'da kesilecektir.\n"},
#endif

/*
   Translators: this command was extended:

   - "load|store|exec" option added
   - conditional expression was added

   TODO: update these languages: DA, DE, HU, IT, NL, SV, TR
*/

/* monitor/mon_command.c */
/* en */ {IDGS_MON_TRACE_DESCRIPTION,    N_("Set a tracepoint. If no address is given, the currently valid trace-\npoints are printed. If a single address is specified, set a tracepoint\nfor that address.  If two addresses are specified, set a tracepoint\nfor the memory locations between the two addresses.\n`load|store|exec' is either `load', `store' or `exec' (or any combina-\ntion of these) to specify on which operation the monitor breaks. If\nnot specified, the monitor traces all three operations.\n")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_TRACE_DESCRIPTION_DA, "St et tracepoint. Hvis der ikke angives en adresse vises en liste\nover nuvrende gyldige tracepoints. Hvis der angives en enkelt\nadresse sttes et tracepoint p adressen. Hvis der angives to adresser\nsttes et tracepoint for hukommelsesomrdet mellem adresserne.\n`load|store|exec' er enten `load', `store' eller `exec' (eller en\nvilkrlig kombination), og angiver p hvilken operation monitoren\ntracer. Hvis intet angives vil monitoren trace alle 3 operationer.\n"},
/* de */ {IDGS_MON_TRACE_DESCRIPTION_DE, "Setze einen Tracepoint. Wenn keine Adresse angegeben wird, werden die\naktuellen gltigen Tracepoints ausgegeben. Wenn eine einzelne Adresse\nangegeben wurde, setze den Watchpoint fr diese Adresse. Wenn zwei\nAdressen angegeben wurden, setze den Watchpoint auf die Adressen\nzwischen den beiden Adressen.\n`load|store|exec' ist entweder `load', `store' oder `exec' (oder eine\nKombination) und dient zur Angabe, bei welcher Operation der Monitor\nanhalten soll. Wenn keine Angabe gemacht wird, beobachtet der Monitor\nalle Operationen.\n"},
/* es */ {IDGS_MON_TRACE_DESCRIPTION_ES, "Poner punto rastreo. Si no se da direccin, Se mostrar el actualmente\nvlido. Si se da una sola direccin, se activa un punto para esa direccin.\nSi se dan dos, se activa el punto para las localizaciones de memoria entre\nlas dos direcciones.\n`load|store|exec' es cualquiera `load', `store' or `exec' (o una combina-\ncin de ellas) para indicar en cual de ellas se detiene el monitor. Si no se\nespecifican el monitor rastrea todas las tres operaciones.\n"},
/* fr */ {IDGS_MON_TRACE_DESCRIPTION_FR, "Cre un point de trace. Si aucune adresse n'est spcifie, les\npoints de trace valides sont affichs. Si une adresse est spcifie,\ncre un point de trace  cette adresse. Si deux adresses sont\nspcifis, cre un point de trace pour les adresses mmoire situes\nentre les deux adresses.\n`load|store|exec' est soit `load', `store' ou `exec' (or toute\ncombinaison) pour spcifier  quelle opration le moniteur arrte. Si\naucune n'est spcifi, le moniteur trace toutes les oprations.\n"},
/* hu */ {IDGS_MON_TRACE_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_TRACE_DESCRIPTION_IT, "Imposta un tracepoint. Se non viene specificato alcun indirizzo,\nvengono stampati i tracepoint attuali. Se viene specificato solo un\nsolo indirizzo, imposta un tracepoint per tale indirizzo. Se vengono\nspecificati due indirizzi, imposta un tracepoint per le locazioni di \nmemoria comprese tra i due indirizzi.\n`load|store|exec'  uno tra `load', `store' o `exec' (or una qualunque\ncombinazione di questi) per specificare su quale operazione il monitor\ninterromper. Se non specificato, il monitor traccer tutte e tre le\noperazioni.\n"},
/* ko */ {IDGS_MON_TRACE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_TRACE_DESCRIPTION_NL, "Zet een traceerpunt. Als er geen adres is opgegeven, zullen de huidige\ngeldige traceerpunten worden getoond. Als er een enkel adres is opgegeven,\nzal er een traceerpunt worden gezet voor dat adres. Als er twee\nadressen zijn opgegeven, zal er een traceerpunt worden gezet voor de\nadressen tussen de twee adressen.\n`load|store|exec' is `load', `store' of 'exec' om aan te geven bij welke\noperatie de monitor zou moeten starten. Als deze niet opgegeven is, zal\nde monitor starten bij alle operaties.\n"},
/* pl */ {IDGS_MON_TRACE_DESCRIPTION_PL, "Ustawia punkt ledzenia. Jeli nie podano adresu, pokazywane s\nwaciwe obecnie punkty ledzenia. Jeli podano jeden adres,\nustawia punkt ledzenia tego adresu. Jeli podano dwa adresy,\nustawia punkt ledzenia obszaru pamici pomidzy nimi.\n`load|store|exec' to `load', `store' lub `exec' (albo ich poczenia),\nokrelajce  podczas ktrych operacji nastpuje bd. Jeli nic\nnie okrelono, monitor ledzi wszystkie trzy rodzaje operacji.\n"},
/* ru */ {IDGS_MON_TRACE_DESCRIPTION_RU, "Set a tracepoint. If no address is given, the currently valid trace-\npoints are printed. If a single address is specified, set a tracepoint\nfor that address.  If two addresses are specified, set a tracepoint\nfor the memory locations between the two addresses.\n`load|store|exec' is either `load', `store' or `exec' (or any combina-\ntion of these) to specify on which operation the monitor breaks. If\nnot specified, the monitor traces all three operations.\n"},
/* sv */ {IDGS_MON_TRACE_DESCRIPTION_SV, "Stt en sprningspunkt. Om ingen adress anges visas befintliga\nsprningspunkter. Om du anger en ensam adress stts en sprningspunkt\nfr adressen. Om tv adresser anges stts en sprningspunkt fr\nminnesomrdet mellan adresserna.\n\"load|store|exec\" r antingen \"load\", \"store\" eller \"exec\" (eller en\nkombination drutav) och anger vilken operation monitorn skall stoppa\nfr. Om den inte anges sprar monitorn alla tre operationerna.\n"},
/* tr */ {IDGS_MON_TRACE_DESCRIPTION_TR, "Bir izleme noktas koy. Eer bir adres belirtilmemise, mevcut geerli\nizleme noktalar yazdrlr. Eer tek bir adres belirtilmise, izleme\nnoktasn o adrese koy.  Eer iki adres belirtilmise, izleme noktasn\no iki adres arasnda kalan adreslere koy.\n`ykle|depola|yrt' monitrn kesildii operatre bal olarak `ykle'\n`depola' ya da `yrt' (ya da herhangi bir kombinasyonunda) ilemlerinde\nalabilir. Eer belirtilmemise, monitr her  ilemi de izleyecektir.\n"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MONITOR_STATE_COMMANDS,    N_("Monitor state commands:")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MONITOR_STATE_COMMANDS_DA, "Monitorstatuskommandoer:"},
/* de */ {IDGS_MONITOR_STATE_COMMANDS_DE, "Monitor Zustand Kommandos:"},
/* es */ {IDGS_MONITOR_STATE_COMMANDS_ES, "Comandos de estado del Monitor:"},
/* fr */ {IDGS_MONITOR_STATE_COMMANDS_FR, "Commandes du statut du moniteur:"},
/* hu */ {IDGS_MONITOR_STATE_COMMANDS_HU, ""},  /* fuzzy */
/* it */ {IDGS_MONITOR_STATE_COMMANDS_IT, "Comandi stato monitor:"},
/* ko */ {IDGS_MONITOR_STATE_COMMANDS_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MONITOR_STATE_COMMANDS_NL, "Monitor status commando's:"},
/* pl */ {IDGS_MONITOR_STATE_COMMANDS_PL, "Monitoruj polecenia stanu:"},
/* ru */ {IDGS_MONITOR_STATE_COMMANDS_RU, "Monitor state commands:"},
/* sv */ {IDGS_MONITOR_STATE_COMMANDS_SV, "Kommandon fr monitorstatus:"},
/* tr */ {IDGS_MONITOR_STATE_COMMANDS_TR, "Monitr durum komutlar:"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DEVICE_DESCRIPTION,    N_("Set the default memory device to either the computer `c:' or the\nspecified disk drive (`8:', `9:').")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_DEVICE_DESCRIPTION_DA, "St det valgte hukommelses omrde til enten computeren \"c:\" eller\ndet angivne diskettedrev (\"8:\", \"9:\")."},
/* de */ {IDGS_MON_DEVICE_DESCRIPTION_DE, "Setze das aktuelle Speichergert entweder auf `c:' \noder das angegebene Laufwerk (`8:', `9:')."},
/* es */ {IDGS_MON_DEVICE_DESCRIPTION_ES, "Seleccionar el perifrico memoria por defecto entre  `c:' o la\nunidad de disco especificada (`8:', `9:')."},
/* fr */ {IDGS_MON_DEVICE_DESCRIPTION_FR, "Rgle le priphrique mmoire par dfaut  soit l'ordinateur `c:'\nou au lecteur de disque spcifi (`8:', `9:')."},
/* hu */ {IDGS_MON_DEVICE_DESCRIPTION_HU, "Az alaprtelmezett memria eszkz belltsa a szmtgpre `c:' vagy\na megadott lemezmeghajtra (`8:', `9:')."},
/* it */ {IDGS_MON_DEVICE_DESCRIPTION_IT, "Imposta la periferica di memoria predefinita o sul computer `c:'\noppure sul disk drive specificato (`8:', `9:')."},
/* ko */ {IDGS_MON_DEVICE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_DEVICE_DESCRIPTION_NL, "Zet het standaard geheugen apparaat naar f de computer `c:' f de\nopgegeven disk drive (`8:', `9:')."},
/* pl */ {IDGS_MON_DEVICE_DESCRIPTION_PL, "Ustawia komputer `c:', lub okrelon stacj dyskw (`8:', `9:')\njako domylne urzdzenie pamici."},
/* ru */ {IDGS_MON_DEVICE_DESCRIPTION_RU, "Set the default memory device to either the computer `c:' or the\nspecified disk drive (`8:', `9:')."},
/* sv */ {IDGS_MON_DEVICE_DESCRIPTION_SV, "Stt frvald minnesenhet antingen till datorn \"c:\" eller\nden angivna diskettenheten (\"8:\", \"9:\")."},
/* tr */ {IDGS_MON_DEVICE_DESCRIPTION_TR, "Varsaylan bellek aygtn bilgisayar `c:' ya da (`8:', `9:') ile\nbelirtilmi disket drc olarak belirle."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_EXIT_DESCRIPTION,    N_("Leave the monitor and return to execution.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_EXIT_DESCRIPTION_DA, "Forlad monitoren og g tilbage til eksekvering."},
/* de */ {IDGS_MON_EXIT_DESCRIPTION_DE, "Verlasse Monitor und setze Ausfhrung fort."},
/* es */ {IDGS_MON_EXIT_DESCRIPTION_ES, "Dejar el monitor y volver a la ejecucin."},
/* fr */ {IDGS_MON_EXIT_DESCRIPTION_FR, "Quitte le moniteur et retourne  l'excution."},
/* hu */ {IDGS_MON_EXIT_DESCRIPTION_HU, "A monitor elhagysa s a vgrehajts folytatsa."},
/* it */ {IDGS_MON_EXIT_DESCRIPTION_IT, "Esce dal monitor e ritorna all'esecuzione."},
/* ko */ {IDGS_MON_EXIT_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_EXIT_DESCRIPTION_NL, "Verlaat de monitor en ga terug naar de uitvoering."},
/* pl */ {IDGS_MON_EXIT_DESCRIPTION_PL, "Opu monitor i wr do wykonywania"},
/* ru */ {IDGS_MON_EXIT_DESCRIPTION_RU, "Leave the monitor and return to execution."},
/* sv */ {IDGS_MON_EXIT_DESCRIPTION_SV, "Lmna monitorn och terg till programkrningen."},
/* tr */ {IDGS_MON_EXIT_DESCRIPTION_TR, "Monitr terk et ve altrmaya geri dn."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_QUIT_DESCRIPTION,    N_("Exit the emulator immediately.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_QUIT_DESCRIPTION_DA, "Afslut emulatoren jblikkeligt."},
/* de */ {IDGS_MON_QUIT_DESCRIPTION_DE, "Emulator sofort beenden."},
/* es */ {IDGS_MON_QUIT_DESCRIPTION_ES, "Salir inmediatamente del emulador."},
/* fr */ {IDGS_MON_QUIT_DESCRIPTION_FR, "Quitter l'mulateur immdiatement."},
/* hu */ {IDGS_MON_QUIT_DESCRIPTION_HU, "Azonnali kilps az emultorbl."},
/* it */ {IDGS_MON_QUIT_DESCRIPTION_IT, "Esci immediatamente dall'emulatore."},
/* ko */ {IDGS_MON_QUIT_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_QUIT_DESCRIPTION_NL, "Onmiddelijk de emulator afsluiten."},
/* pl */ {IDGS_MON_QUIT_DESCRIPTION_PL, "Natychmiast wyjd z emulatora."},
/* ru */ {IDGS_MON_QUIT_DESCRIPTION_RU, "   ."},
/* sv */ {IDGS_MON_QUIT_DESCRIPTION_SV, "Avsluta emulatorn omedelbart."},
/* tr */ {IDGS_MON_QUIT_DESCRIPTION_TR, "Emlasyondan derhal k."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_RADIX_DESCRIPTION,    N_("Set the default radix to hex, decimal, octal, or binary.  With no\nargument, the current radix is printed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_RADIX_DESCRIPTION_DA, "St standardradix til hex, decimal, oktal eller binr. Hvis der\nikke angives et argument vises det aktuelle radix."},
/* de */ {IDGS_MON_RADIX_DESCRIPTION_DE, "Setze die Standardzahlenbasis auf Hexadezimal, Dezimal, Oktal oder Binr.\nBei keinem Argument wird die akteulle Zahlenbasis ausgegeben."},
/* es */ {IDGS_MON_RADIX_DESCRIPTION_ES, "Seleccionar sistema numrico por defecto como hex, decimal, octal, o binario.\nSi no se da argumento, se imprime el sistema numrico en uso."},
/* fr */ {IDGS_MON_RADIX_DESCRIPTION_FR, "Rgle la base par dfaut  hex, decimal, octal ou binary. Avec\naucun argument, la base actuelle est affich."},
/* hu */ {IDGS_MON_RADIX_DESCRIPTION_HU, "Az alap szmrendszer hexadecimlis, decimlis, oktlis vagy binris.\nParamter nlkl az aktulisat mutatja."},
/* it */ {IDGS_MON_RADIX_DESCRIPTION_IT, "Imposta la radice predefinita a esadecimale, decimale, ottale o\nbinaria. Senza parametro viene stampata la radice attuale."},
/* ko */ {IDGS_MON_RADIX_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_RADIX_DESCRIPTION_NL, "Zet de standaard radix naar hex, decimaal, octaal of binair. Als er\ngeen parameter is opgegeven, zal de huidige radix worden getoond."},
/* pl */ {IDGS_MON_RADIX_DESCRIPTION_PL, "Ustawia domylny korze na heksadecymalny, decymalny, emkowy\nlub binarny. Bez podanego argumentu, pokazywany jest obecny korze."},
/* ru */ {IDGS_MON_RADIX_DESCRIPTION_RU, "Set the default radix to hex, decimal, octal, or binary.  With no\nargument, the current radix is printed."},
/* sv */ {IDGS_MON_RADIX_DESCRIPTION_SV, "Stt standardradix till hex, decimal, oktal eller binr. Om du\ninte ger ngot argument visas nuvarande radix."},
/* tr */ {IDGS_MON_RADIX_DESCRIPTION_TR, "Varsaylan say tabann 16'l, 10'lu, 8'li ya da 2'li yap.\nArgmansz olarak geerli say taban yazdrlr."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_SIDEFX_DESCRIPTION,    N_("Control how monitor generated reads affect memory locations that have\nread side-effects.  If the argument is 'on' then reads may cause\nside-effects.  If the argument is 'off' then reads don't cause\nside-effects.  If the argument is 'toggle' then the current mode is\nswitched.  No argument displays the current state.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_SIDEFX_DESCRIPTION_DA, "Bestemmer hvordan lsninger i monitoren pvirker hukommelsesomrder,\nder har sedeeffekter ved lsning. Hvis argumentet er \"on\" kan lsninger\nforesage sideeffekter. Hvis argumentet er \"off\" vil lsninger ikke\nforesage sideeffekter. Hvis argumentet er \"toggle\" skiftes\nden nuvrende tilstand. Hvis der ikke angives noget argument vises\nden nuvrende tilstand."},
/* de */ {IDGS_MON_SIDEFX_DESCRIPTION_DE, "Steuerung, wie die vom Monitor erzeugten Lesezugriffe die Speicherzellen\nmit Lese-Seiteneffekten betreffen.\nBei Argument \"on\" werden Lese-Seiteneffekte erzeugt.\nBei Argument \"off\" werden keine Lese-Seiteneffekte erzeugt.\nBei Argument \"toggle\" wird das Verhalten vertauscht.\nBei keinem Argument wird das aktuelle Verhalten ausgegeben."},
/* es */ {IDGS_MON_SIDEFX_DESCRIPTION_ES, "Controla como manejar las lecturas de localizaciones de memoria generadas por el\nmonitor que tengan efectos colaterales, Si el argumento es 'on' las lecturas causarn\nefectos colaterales. Si el argumento es 'off' no se causarn efectos colaterales. Si el\nargumento es 'intercambiar' se intercambiara el modo en uso. Sin argumentos, se \nmostrar el estado en uso."},
/* fr */ {IDGS_MON_SIDEFX_DESCRIPTION_FR, "Contrle comment les lectures du moniteur affecte les emplacements\nmmoire ayant des effets secondaires de lecture. Si l'argument est\n'on' alors les lectures peuvent causer des effets secondaires. Si\nl'argument est 'off' les lectures n'en causeront pas. Si l'argument\nest 'toggle' alors le mode actuel est commut. Aucun argument ne peut\nafficher le mode en cours."},
/* hu */ {IDGS_MON_SIDEFX_DESCRIPTION_HU, "Belltja, hogyan hatnak a monitorprogram memria olvassai azokra a\nmemriahelyekre, amelyeknek olvass-mellkhatsai vannak. Ha a paramter\n'on', az olvassok okozhatnak mellkhatsokat. Ha a paramter 'off', akkor pedig\nnem okoznak. Ha a paramter 'toggle', az aktulis mdot tkapcsolja.\nParamter nlkli hvs kirja az aktulis mdot."},
/* it */ {IDGS_MON_SIDEFX_DESCRIPTION_IT, "Controlla come le letture generate dal monitor affliggono le locazioni\ndi memoria che hanno degli effetti collaterali sulla lettura.\nSe il paremetro  'on', le letture possono causare effetti collaterali.\nSe il parametro  'off', le letture non causano effetti collaterali.\nSe il parametro  'scambia', la modalit attuale viene invertita.\nNessun parametro mostra lo stato attuale."},
/* ko */ {IDGS_MON_SIDEFX_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_SIDEFX_DESCRIPTION_NL, "Geef aan hoe de leesacties van de monitor de geheugenlocaties met lees\nbij-effecten benvloedt. Als de parameter 'off' is, zullen lees acties\ngeen bij-effecten vertonen. Als de parameter 'on' is, zullen lees\nacties bij-effecten vertonen. Als de parameter 'toggle' is, zal de\nhuidige modus worden gewisseld. Als er geen parameter is, zal de\nhuidige modus worden getoond."},
/* pl */ {IDGS_MON_SIDEFX_DESCRIPTION_PL, "Kontroluje w jaki sposb wygenerowane w monitorze odczyty pooenia\nwpywaj na obszary pamici, ktre maj efekty uboczne odczytu.\nJeli argument to 'on', wtedy odczyty mog powodowa efekty uboczne.\nJeli argument to 'off', wtedy odczyty nie powoduj efektw ubocznych.\nJeli argument to 'toggle', obecny tryb jest przeczany.\nBrak argumentu pokazuje obecny stan."},
/* ru */ {IDGS_MON_SIDEFX_DESCRIPTION_RU, "Control how monitor generated reads affect memory locations that have\nread side-effects.  If the argument is 'on' then reads may cause\nside-effects.  If the argument is 'off' then reads don't cause\nside-effects.  If the argument is 'toggle' then the current mode is\nswitched.  No argument displays the current state."},
/* sv */ {IDGS_MON_SIDEFX_DESCRIPTION_SV, "Styr hur lsningar i monitorn pverkar minnesomrden som har\nsidoeffekter vid lsning. Om argumentet r \"on\" tillts lsningar\natt orsaka sidoeffekter. Om argumentet r \"off\" tillts inte\nlsningar att orsaka sidoeffekter. Om argumentet r \"toggle\" byts\ndet nuvarande lget. Om du inte anger ngra argument visas\nnuvarande lge."},
/* tr */ {IDGS_MON_SIDEFX_DESCRIPTION_TR, "Okuma yan etkileri bulunan bellek konumlarn monitr tarafndan oluturulan\nokumalarn nasl etkilediini kontrol et.  Argman 'on' ise, okumalar yan\netkiye neden olabilir.  Argman 'off' ise okumalarn bir yan etkisi\nolmayacaktr.  Eer argman 'toggle' ise geerli mod deitirilecektir.\nArgman verilmemesi o anki durumu grntler."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_DISK_COMMANDS,    N_("Disk commands:")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_DISK_COMMANDS_DA, "Diskettekommandoer:"},
/* de */ {IDGS_DISK_COMMANDS_DE, "Disk Kommandos:"},
/* es */ {IDGS_DISK_COMMANDS_ES, "Comandos de disco:"},
/* fr */ {IDGS_DISK_COMMANDS_FR, "Commandes de disque:"},
/* hu */ {IDGS_DISK_COMMANDS_HU, ""},  /* fuzzy */
/* it */ {IDGS_DISK_COMMANDS_IT, "Comandi disco:"},
/* ko */ {IDGS_DISK_COMMANDS_KO, ""},  /* fuzzy */
/* nl */ {IDGS_DISK_COMMANDS_NL, "Disk commando's:"},
/* pl */ {IDGS_DISK_COMMANDS_PL, "Polecenia dyskowe:"},
/* ru */ {IDGS_DISK_COMMANDS_RU, "Disk commands:"},
/* sv */ {IDGS_DISK_COMMANDS_SV, "Diskettkommandon:"},
/* tr */ {IDGS_DISK_COMMANDS_TR, "Disk komutlar:"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_DISK_COMMAND,    N_("disk command")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_DISK_COMMAND_DA, "diskkommando"},
/* de */ {IDGS_DISK_COMMAND_DE, "Disk Kommando"},
/* es */ {IDGS_DISK_COMMAND_ES, "comando disco"},
/* fr */ {IDGS_DISK_COMMAND_FR, "commande de disque"},
/* hu */ {IDGS_DISK_COMMAND_HU, ""},  /* fuzzy */
/* it */ {IDGS_DISK_COMMAND_IT, "comando disco"},
/* ko */ {IDGS_DISK_COMMAND_KO, ""},  /* fuzzy */
/* nl */ {IDGS_DISK_COMMAND_NL, "disk commando"},
/* pl */ {IDGS_DISK_COMMAND_PL, "disk command"},
/* ru */ {IDGS_DISK_COMMAND_RU, "disk command"},
/* sv */ {IDGS_DISK_COMMAND_SV, "diskkommando"},
/* tr */ {IDGS_DISK_COMMAND_TR, "disk komutu"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_AT_DESCRIPTION,    N_("Perform a disk command on the currently attached disk image on drive 8.\nThe specified disk command is sent to the drive's channel #15.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_AT_DESCRIPTION_DA, "Udfrer en diskkommando p det diskette-image, der er tilsluttet\ndrev 8. Diskkommandoen sendes til drevets kanal #15."},
/* de */ {IDGS_MON_AT_DESCRIPTION_DE, "Fhre ein Diskkommando auf dem aktuell eingelegtem Diskimage auf Laufwerk 8\naus.\nDas angegebene Kommando wird auf dem Laufwerks Kommandokanal #15 geschickt."},
/* es */ {IDGS_MON_AT_DESCRIPTION_ES, "Realiza un comando de disco en el actualmente insertado en unidad disco 8.\nEl comando de disco especificado se enva a travs del canal de control #15."},
/* fr */ {IDGS_MON_AT_DESCRIPTION_FR, "Performe une commande disque  l'image disque actuellement attache au\nlecteur #8. La commande spcifie est envoye au canal #15 du lecteur."},
/* hu */ {IDGS_MON_AT_DESCRIPTION_HU, "Lemez parancs vgrehajtsa az aktulisan csatolt lemezen, a 8-as egysgen.\nA megadott lemez parancsot a meghajt #15-s csatornjra kldi."},
/* it */ {IDGS_MON_AT_DESCRIPTION_IT, "Esegue un comando disco sull'immagine disco attualmente presente nel\ndrive 8. Il comando specificato  inviato al canale #15 del drive."},
/* ko */ {IDGS_MON_AT_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_AT_DESCRIPTION_NL, "Voer een disk commando uit op het huidig gekoppeld disk bestand in drive\n8, Het opgegeven disk commando zal worden gestuurd naar kanaal #15 van de\ndrive."},
/* pl */ {IDGS_MON_AT_DESCRIPTION_PL, "Wykonaj polecenie dyskowe na obecnie zamontowanym obrazie dyskietki\nw stacji 8. Dane polecenie jest wysyane na kana #15 stacji."},
/* ru */ {IDGS_MON_AT_DESCRIPTION_RU, "Perform a disk command on the currently attached disk image on drive 8.\nThe specified disk command is sent to the drive's channel #15."},
/* sv */ {IDGS_MON_AT_DESCRIPTION_SV, "Utfr ett diskkommando p den diskettavbildning som r ansluten till\nenhet 8. Diskkommandot snds p diskettenhetens kanal nummer 15."},
/* tr */ {IDGS_MON_AT_DESCRIPTION_TR, "8 nolu srcde takl disk imaj zerinde bir disk komutu altr.\nBelirtilen disk komutu srcnn 15 numaral kanalna gnderilir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_DEVICE,    N_("device")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_DEVICE_DA, "enhed"},
/* de */ {IDGS_DEVICE_DE, "Gert"},
/* es */ {IDGS_DEVICE_ES, "perifrico"},
/* fr */ {IDGS_DEVICE_FR, "priphrique"},
/* hu */ {IDGS_DEVICE_HU, ""},  /* fuzzy */
/* it */ {IDGS_DEVICE_IT, "dispositivo"},
/* ko */ {IDGS_DEVICE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_DEVICE_NL, "apparaat"},
/* pl */ {IDGS_DEVICE_PL, "device"},
/* ru */ {IDGS_DEVICE_RU, "device"},
/* sv */ {IDGS_DEVICE_SV, "enhet"},
/* tr */ {IDGS_DEVICE_TR, "aygt"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_FILE_INDEX,    N_("file_index")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_FILE_INDEX_DA, "fil_indeks"},
/* de */ {IDGS_FILE_INDEX_DE, "Datei_Index"},
/* es */ {IDGS_FILE_INDEX_ES, "ndice de fichero"},
/* fr */ {IDGS_FILE_INDEX_FR, "index_fichier"},
/* hu */ {IDGS_FILE_INDEX_HU, ""},  /* fuzzy */
/* it */ {IDGS_FILE_INDEX_IT, "file_index"},
/* ko */ {IDGS_FILE_INDEX_KO, ""},  /* fuzzy */
/* nl */ {IDGS_FILE_INDEX_NL, "bestandsindex"},
/* pl */ {IDGS_FILE_INDEX_PL, "file_index"},
/* ru */ {IDGS_FILE_INDEX_RU, "file_index"},
/* sv */ {IDGS_FILE_INDEX_SV, "filindex"},
/* tr */ {IDGS_FILE_INDEX_TR, "dosya_indeksi"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_AUTOSTART_DESCRIPTION,    N_("autostart a given disk/tape image or program")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_AUTOSTART_DESCRIPTION_DA, "Autostart et givent disk-/bnd-image eller program"},
/* de */ {IDGS_MON_AUTOSTART_DESCRIPTION_DE, "Autostart ein Disk/Band Image oder Programm"},
/* es */ {IDGS_MON_AUTOSTART_DESCRIPTION_ES, "Autoarranque imagen de disco/cinta  programa"},
/* fr */ {IDGS_MON_AUTOSTART_DESCRIPTION_FR, "Autodmarrage d'une image disque/datassette ou programme"},
/* hu */ {IDGS_MON_AUTOSTART_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_AUTOSTART_DESCRIPTION_IT, "Avvia automaticamente immagine un'immagine disco/cassetta o programma"},
/* ko */ {IDGS_MON_AUTOSTART_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_AUTOSTART_DESCRIPTION_NL, "autostart een opgegeven disk-/tapebestand of programma"},
/* pl */ {IDGS_MON_AUTOSTART_DESCRIPTION_PL, "automatycznie uruchom dany program albo obraz dysku lub tamy"},
/* ru */ {IDGS_MON_AUTOSTART_DESCRIPTION_RU, "autostart a given disk/tape image or program"},
/* sv */ {IDGS_MON_AUTOSTART_DESCRIPTION_SV, "starta given disk-/bandavbildningsfil eller program automatiskt"},
/* tr */ {IDGS_MON_AUTOSTART_DESCRIPTION_TR, "verilen disk/teyp imajn ya da program otomatik balat"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_AUTOLOAD_DESCRIPTION,    N_("autoload given disk/tape image or program")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_AUTOLOAD_DESCRIPTION_DA, "Autoload et givent disk-/bnd-image eller program"},
/* de */ {IDGS_MON_AUTOLOAD_DESCRIPTION_DE, "Autoload ein Disk/Band Image oder Programm"},
/* es */ {IDGS_MON_AUTOLOAD_DESCRIPTION_ES, "Autocarga imagen de disco/cinta  programa"},
/* fr */ {IDGS_MON_AUTOLOAD_DESCRIPTION_FR, "Charger automatiquement une image de disque/datassette"},
/* hu */ {IDGS_MON_AUTOLOAD_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_AUTOLOAD_DESCRIPTION_IT, "Carica automaticamente immagine un'immagine disco/cassetta o programma"},
/* ko */ {IDGS_MON_AUTOLOAD_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_AUTOLOAD_DESCRIPTION_NL, "autolaad een opgegeven disk-/tapebestand of programma"},
/* pl */ {IDGS_MON_AUTOLOAD_DESCRIPTION_PL, "automatycznie wczytaj dany program albo obraz dysku lub tamy"},
/* ru */ {IDGS_MON_AUTOLOAD_DESCRIPTION_RU, "autoload given disk/tape image or program"},
/* sv */ {IDGS_MON_AUTOLOAD_DESCRIPTION_SV, "ls in given disk-/bandavbildningsfil eller program automatiskt"},
/* tr */ {IDGS_MON_AUTOLOAD_DESCRIPTION_TR, "verilen disk/teyp imajn ya da program otomatik yklet"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_ATTACH_DESCRIPTION,    N_("Attach file to device. (device 32 = cart)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_ATTACH_DESCRIPTION_DA, "Tilslut en fil til enhed. (enhed 32 = cartridge)"},
/* de */ {IDGS_MON_ATTACH_DESCRIPTION_DE, "Benutze Datei fr das Gert. (Gert 32 = Modul)"},
/* es */ {IDGS_MON_ATTACH_DESCRIPTION_ES, "Inserta fichero en perifrico (perifrico 32=cartucho)"},
/* fr */ {IDGS_MON_ATTACH_DESCRIPTION_FR, "Attacher un fichier  un priphrique. (Priph. 32 = cartouche)"},
/* hu */ {IDGS_MON_ATTACH_DESCRIPTION_HU, "Fjl csatolsa az eszkzhz. (32-es eszkz = cart)"},
/* it */ {IDGS_MON_ATTACH_DESCRIPTION_IT, "Seleziona il file per la periferica. (periferica 32 = cartuccia)"},
/* ko */ {IDGS_MON_ATTACH_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_ATTACH_DESCRIPTION_NL, "Koppel bestand aan apparaat. (apparaat 32 = cart)"},
/* pl */ {IDGS_MON_ATTACH_DESCRIPTION_PL, "Podcz plik pod urzdzenie (urzdzenie 32 = cart)"},
/* ru */ {IDGS_MON_ATTACH_DESCRIPTION_RU, "Attach file to device. (device 32 = cart)"},
/* sv */ {IDGS_MON_ATTACH_DESCRIPTION_SV, "Anslut en fil till en enhet. (enhet 32 = insticksmodul)"},
/* tr */ {IDGS_MON_ATTACH_DESCRIPTION_TR, "Aygta dosya yerletir. (aygt 32 = kartu)"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_BLOAD_DESCRIPTION,    N_("Load the specified file into memory at the specified address.\nIf device is 0, the file is read from the file system.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_BLOAD_DESCRIPTION_DA, "Indls den angivne fil til hukommelsen p den angivne adresse.\nHvis enhed er 0 lses fra filsystemet."},
/* de */ {IDGS_MON_BLOAD_DESCRIPTION_DE, "Lade angegebene Datei in den Speicher an die angegebene Adresse.\nBei Gert 0, wird die Datei vom Dateisystem gelesen."},
/* es */ {IDGS_MON_BLOAD_DESCRIPTION_ES, "Cargar el fichero especificado en memoria en la direccin indicada en\ndireccin. Si el perifrico es 0 el fichero se lee desde sistema."},
/* fr */ {IDGS_MON_BLOAD_DESCRIPTION_FR, "Charge le fichier spcifi en mmoire  l'adresse spcifie.\nSi le priphrique est 0, le fichier est lu du systme de fichier."},
/* hu */ {IDGS_MON_BLOAD_DESCRIPTION_HU, "A megadott fjl betltse a memriba a megadott cmre.\nHa az eszkz 0, a fjlt a fjlrendszerbl olvassa."},
/* it */ {IDGS_MON_BLOAD_DESCRIPTION_IT, "Carica il file specificato in memoria all'indirizzo specificato.\nSe la periferica  0, il file  letto dal file system."},
/* ko */ {IDGS_MON_BLOAD_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_BLOAD_DESCRIPTION_NL, "Laad het opgegeven bestand naar het geheugen met het opgegeven adres.\nAls het apparaat 0 is, zal het bestand van het bestandssysteem\nworden geladen."},
/* pl */ {IDGS_MON_BLOAD_DESCRIPTION_PL, "Wczytaj dany plik do pamici w okrelonym adresie.\nJeli urzdzenie to 0, plik jest czytany z systemu plikw."},
/* ru */ {IDGS_MON_BLOAD_DESCRIPTION_RU, "Load the specified file into memory at the specified address.\nIf device is 0, the file is read from the file system."},
/* sv */ {IDGS_MON_BLOAD_DESCRIPTION_SV, "Ls den angivna filen till minnet p den angivna adressen.\nOm enheten r 0 lses filen frn filsystemet."},
/* tr */ {IDGS_MON_BLOAD_DESCRIPTION_TR, "Belirtilmi dosyay belirtilen adresten itibaren bellee ykle.\nAygt 0 ise, dosya dosya sistemi zerinden okunur."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_TRACK,    N_("track")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_TRACK_DA, "spor"},
/* de */ {IDGS_TRACK_DE, "Spur"},
/* es */ {IDGS_TRACK_ES, "Pista"},
/* fr */ {IDGS_TRACK_FR, "piste"},
/* hu */ {IDGS_TRACK_HU, ""},  /* fuzzy */
/* it */ {IDGS_TRACK_IT, "traccia"},
/* ko */ {IDGS_TRACK_KO, ""},  /* fuzzy */
/* nl */ {IDGS_TRACK_NL, "spoor"},
/* pl */ {IDGS_TRACK_PL, "track"},
/* ru */ {IDGS_TRACK_RU, "track"},
/* sv */ {IDGS_TRACK_SV, "spr"},
/* tr */ {IDGS_TRACK_TR, "track"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_SECTOR,    N_("sector")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SECTOR_DA, "sektor"},
/* de */ {IDGS_SECTOR_DE, "Sektor"},
/* es */ {IDGS_SECTOR_ES, "sector"},
/* fr */ {IDGS_SECTOR_FR, "secteur"},
/* hu */ {IDGS_SECTOR_HU, ""},  /* fuzzy */
/* it */ {IDGS_SECTOR_IT, "settore"},
/* ko */ {IDGS_SECTOR_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SECTOR_NL, "sector"},
/* pl */ {IDGS_SECTOR_PL, "sector"},
/* ru */ {IDGS_SECTOR_RU, ""},
/* sv */ {IDGS_SECTOR_SV, "sektor"},
/* tr */ {IDGS_SECTOR_TR, "sektr"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_BLOCK_READ_DESCRIPTION,    N_("Read the block at the specified track and sector.  If an address is\nspecified, the data is loaded into memory.  If no address is given, the\ndata is displayed using the default datatype.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_BLOCK_READ_DESCRIPTION_DA, "Lser en blok fra det angivne spor og sektor. Hvis en adresse angives\nindlses data til hukommelsen. Hvis der ikke angives nogen adresse vises\nindholdet med standarddatatypen."},
/* de */ {IDGS_MON_BLOCK_READ_DESCRIPTION_DE, "Lese den Block von angegebener Spur und Sektor. Wenn eine Adresse\nangegeben wurde, lade in auf die entsprechende Adresse. Wenn keine Adresse\nangegeben ist, zeige die Daten im aktuellen Anzeigemodus fr Daten."},
/* es */ {IDGS_MON_BLOCK_READ_DESCRIPTION_ES, "Leer bloque en la pista y sector especificados. Si la direccin se\nespecifica, el dato se carga en memoria, si no, el dato se muestra\nusando el tipo dato por defecto."},
/* fr */ {IDGS_MON_BLOCK_READ_DESCRIPTION_FR, "Lit le bloc  la piste et au secteur spcifis. Si une adresse est\nspcifie, les donnes sont charges en mmoire. Si aucune adresse\nn'est spcifie, les donnes sont affichs en utilisant le type de\ndonnes par dfaut."},
/* hu */ {IDGS_MON_BLOCK_READ_DESCRIPTION_HU, "Blokk beolvassa a megadott svbl s szektorbl.,  Ha egy cm is meg\nvan adva, az adatot a memriba tlti.  Ha az nincs, az\nadatot az alapbellts szerinti formban mutatja."},
/* it */ {IDGS_MON_BLOCK_READ_DESCRIPTION_IT, "Legge il blocco dalla traccia e settore specificati. Se  specificato\nun indirizzo, il dato  caricato in memoria. Se non  specificato alcun\nindirizzo, il dato  mostrato usando il tipo di dato predefinito."},
/* ko */ {IDGS_MON_BLOCK_READ_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_BLOCK_READ_DESCRIPTION_NL, "Lees het blok van het opgegeven spoor en sector. Als er een adres is\nopgegeven, zal de data naar dat adres in het geheugen worden geladen.\nAls er geen adres is opgegeven, zal de data worden getoond met de\nhuidige datasoort."},
/* pl */ {IDGS_MON_BLOCK_READ_DESCRIPTION_PL, "Czytaj blok z danej cieki i sektora. Jeli okrelono adres, dane s\nwczytywane do pamici. Jeli nie podano adresu, dane s pokazane\nw domylnym typie danych."},
/* ru */ {IDGS_MON_BLOCK_READ_DESCRIPTION_RU, "Read the block at the specified track and sector.  If an address is\nspecified, the data is loaded into memory.  If no address is given, the\ndata is displayed using the default datatype."},
/* sv */ {IDGS_MON_BLOCK_READ_DESCRIPTION_SV, "Lser blocket p det angivna spret och sektorn. Om du anger en\nadress lses data till minnet. Om du inte anger ngon adress visas\ninnehllet enligt standarddatatypen."},
/* tr */ {IDGS_MON_BLOCK_READ_DESCRIPTION_TR, "Belirtilmi track ve sektrdeki blou oku.  Eer bir adres belirtilmise,\nveri bellee yklenir.  Eer adres belirtilmemise, veri varsaylan veri\ntipi kullanlarak grntlenir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_BSAVE_DESCRIPTION,    N_("Save the memory from address1 to address2 to the specified file.\nIf device is 0, the file is written to the file system.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_BSAVE_DESCRIPTION_DA, "Gem hukommelsen fra adresse1 til adresse2 til den angivne fil.\nHvis enhed er 0 skrives til filsystemet."},
/* de */ {IDGS_MON_BSAVE_DESCRIPTION_DE, "Speichere den Speicherinhalt von Adresse1 zu Adresse2 in die angegebene Datei.\nWenn das Gert 0 angegeben wurde, speichere im Dateisystem."},
/* es */ {IDGS_MON_BSAVE_DESCRIPTION_ES, "Grabar la memoria entre direccin1 y direccin2 al fichero indicado.\nSi el perifrico es 0, el fichero se graba en el fichero del sistema."},
/* fr */ {IDGS_MON_BSAVE_DESCRIPTION_FR, "Sauvegarde la mmoire depuis adress1 jusqu' adress2 dans le\nfichier spcifi. Si le priphrique est 0, alors le fichier\nest crit dans le systme de fichier."},
/* hu */ {IDGS_MON_BSAVE_DESCRIPTION_HU, "A memria cm1 s cm2 kztti rsznek fjlba mentse.\nHa az eszkz 0, a fjl a fjlrendszerbe kerl."},
/* it */ {IDGS_MON_BSAVE_DESCRIPTION_IT, "Salva la memoria compresa tra indirizzo1 e indirizzo2 sul file specificato.\nSe la periferica  0, il file  scritto sul file system."},
/* ko */ {IDGS_MON_BSAVE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_BSAVE_DESCRIPTION_NL, "Sla het geheugen tussen adres1 en adres2 op naar het opgegeven bestand.\nAls het apparaat 0 is, zal het bestand naar het bestandssysteem worden\ngeschreven."},
/* pl */ {IDGS_MON_BSAVE_DESCRIPTION_PL, "Zapisz pami z adres1 do adres2 do okrelonego pliku.\nJeli urzdzenie to 0, plik jest zapisywany do systemu plikw."},
/* ru */ {IDGS_MON_BSAVE_DESCRIPTION_RU, "Save the memory from address1 to address2 to the specified file.\nIf device is 0, the file is written to the file system."},
/* sv */ {IDGS_MON_BSAVE_DESCRIPTION_SV, "Spara minnet frn adress1 till adress2 till den angivna filen.\nOm enheten r 0 skrivs filen till filsystemet."},
/* tr */ {IDGS_MON_BSAVE_DESCRIPTION_TR, "Adres1'den adres2'ye kadar olan bellei belirtilen dosyaya kaydet.\nEer aygt 0 ise, dosya dosya sistemine yazlr."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_BLOCK_WRITE_DESCRIPTION,    N_("Write a block of data at `address' on the specified track and sector\nof disk in drive 8.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_BLOCK_WRITE_DESCRIPTION_DA, "Skriv datablok p \"adresse\" til det angivne spor og sektor\np disken i drev 8."},
/* de */ {IDGS_MON_BLOCK_WRITE_DESCRIPTION_DE, "Schreibe einen Datenblock von `Adresse' auf die angegebene Spure und Sektor\nin die Imagedatei von Laufwerk 8."},
/* es */ {IDGS_MON_BLOCK_WRITE_DESCRIPTION_ES, "Grabar un bloque de datos en 'direccin' en la pista y sector indicados\ndel disco en la unidad de discos 8."},
/* fr */ {IDGS_MON_BLOCK_WRITE_DESCRIPTION_FR, "crit un bloc de donnes  `address' sur la piste et le secteur\nspcifis du disque dans le lecteur #8."},
/* hu */ {IDGS_MON_BLOCK_WRITE_DESCRIPTION_HU, "Egy adat blokk rsa `cm' helyrl a megadott svba s szektorba\na 8-as meghajtn."},
/* it */ {IDGS_MON_BLOCK_WRITE_DESCRIPTION_IT, "Scrive il blocco di dati all'indirizzo sulla traccia e settore specificati\ndel disco nel drive 8."},
/* ko */ {IDGS_MON_BLOCK_WRITE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_BLOCK_WRITE_DESCRIPTION_NL, "Schrijf een data blok van `adres' naar het opgegeven spoor en sector van\nde disk in drive 8."},
/* pl */ {IDGS_MON_BLOCK_WRITE_DESCRIPTION_PL, "Zapisz blok danych w `address' w podanej ciece i sektorze\ndysku w stacji 8."},
/* ru */ {IDGS_MON_BLOCK_WRITE_DESCRIPTION_RU, "Write a block of data at `address' on the specified track and sector\nof disk in drive 8."},
/* sv */ {IDGS_MON_BLOCK_WRITE_DESCRIPTION_SV, "Skriv ett datablock p \"adress\" till det angivna spret och sektorn\np disken i enhet 8."},
/* tr */ {IDGS_MON_BLOCK_WRITE_DESCRIPTION_TR, "Belirtilmi track ve sektrlerde `adres'te yer alan veri blounu 8\nnumaral srcdeki diske yaz."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_DIRECTORY,    N_("Directory")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_DIRECTORY_DA, "Katalog"},
/* de */ {IDGS_DIRECTORY_DE, "Verzeichnis"},
/* es */ {IDGS_DIRECTORY_ES, "Directorio"},
/* fr */ {IDGS_DIRECTORY_FR, "Rpertoire"},
/* hu */ {IDGS_DIRECTORY_HU, ""},  /* fuzzy */
/* it */ {IDGS_DIRECTORY_IT, "Directory"},
/* ko */ {IDGS_DIRECTORY_KO, "丮"},
/* nl */ {IDGS_DIRECTORY_NL, "Directory"},
/* pl */ {IDGS_DIRECTORY_PL, "Katalog"},
/* ru */ {IDGS_DIRECTORY_RU, ""},
/* sv */ {IDGS_DIRECTORY_SV, "Katalog"},
/* tr */ {IDGS_DIRECTORY_TR, "Dizin"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_P_DIRECTORY,    N_("<Directory>")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_P_DIRECTORY_DA, "<Katalog>"},
/* de */ {IDGS_P_DIRECTORY_DE, "<Verzeichnis>"},
/* es */ {IDGS_P_DIRECTORY_ES, "<Directorio>"},
/* fr */ {IDGS_P_DIRECTORY_FR, "<Rpertoire>"},
/* hu */ {IDGS_P_DIRECTORY_HU, ""},  /* fuzzy */
/* it */ {IDGS_P_DIRECTORY_IT, "<Directory>"},
/* ko */ {IDGS_P_DIRECTORY_KO, "<丮>"},
/* nl */ {IDGS_P_DIRECTORY_NL, "<Directory>"},
/* pl */ {IDGS_P_DIRECTORY_PL, "<Katalog>"},
/* ru */ {IDGS_P_DIRECTORY_RU, "<>"},
/* sv */ {IDGS_P_DIRECTORY_SV, "<Katalog>"},
/* tr */ {IDGS_P_DIRECTORY_TR, "<Dizin>"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_CD_DESCRIPTION,    N_("Change current working directory.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_CD_DESCRIPTION_DA, "Skift aktuelt arbejdskatalog"},
/* de */ {IDGS_MON_CD_DESCRIPTION_DE, "Arbeitsverzeichnis ndern."},
/* es */ {IDGS_MON_CD_DESCRIPTION_ES, "Cambiar directorio de trabajo actual."},
/* fr */ {IDGS_MON_CD_DESCRIPTION_FR, "Modifier le rpertoire en cours."},
/* hu */ {IDGS_MON_CD_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_CD_DESCRIPTION_IT, "Cambia la directory di lavoro."},
/* ko */ {IDGS_MON_CD_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_CD_DESCRIPTION_NL, "Verander de huidige werkmap."},
/* pl */ {IDGS_MON_CD_DESCRIPTION_PL, "Zmie obecny katalog roboczy"},
/* ru */ {IDGS_MON_CD_DESCRIPTION_RU, "   ."},
/* sv */ {IDGS_MON_CD_DESCRIPTION_SV, "ndra aktuell arbetskatalog"},
/* tr */ {IDGS_MON_CD_DESCRIPTION_TR, "Geerli alma dizinini deitir."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DETACH_DESCRIPTION,    N_("Detach file from device. (device 32 = cart)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_DETACH_DESCRIPTION_DA, "Frakobl filen fra enheden. (enhed 32 = cartridge)"},
/* de */ {IDGS_MON_DETACH_DESCRIPTION_DE, "Entferne Datei von Gert. (Gert 32 = Modul)"},
/* es */ {IDGS_MON_DETACH_DESCRIPTION_ES, "Extraer fichero desde el perifrico (perifrico 32 = cartucho)"},
/* fr */ {IDGS_MON_DETACH_DESCRIPTION_FR, "Dtacher un fichier d'un priphrique. (Priph. 32 = cartouche)"},
/* hu */ {IDGS_MON_DETACH_DESCRIPTION_HU, "Fjl levlasztsa az eszkzrl. (32-es eszkz = cart)"},
/* it */ {IDGS_MON_DETACH_DESCRIPTION_IT, "Rimuovi il file dalla periferica. (periferica 32 = cart)"},
/* ko */ {IDGS_MON_DETACH_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_DETACH_DESCRIPTION_NL, "Ontkoppel bestand van apparaat. (apparaat 32 = cart)"},
/* pl */ {IDGS_MON_DETACH_DESCRIPTION_PL, "Odcz plik od urzdzenia (urzdzenie 32 = cart)"},
/* ru */ {IDGS_MON_DETACH_DESCRIPTION_RU, "Detach file from device. (device 32 = cart)"},
/* sv */ {IDGS_MON_DETACH_DESCRIPTION_SV, "Koppla frn filen frn enheten. (enhet 32 = insticksmodul)"},
/* tr */ {IDGS_MON_DETACH_DESCRIPTION_TR, "Aygttan dosya kart. (aygt 32 = kartu)"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DIR_DESCRIPTION,    N_("Display the directory contents.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_DIR_DESCRIPTION_DA, "Vis katalogets indhold."},
/* de */ {IDGS_MON_DIR_DESCRIPTION_DE, "Zeige den Verzeichnisinhalt."},
/* es */ {IDGS_MON_DIR_DESCRIPTION_ES, "Mostrar los contenidos del directorio"},
/* fr */ {IDGS_MON_DIR_DESCRIPTION_FR, "Affiche le contenu du rpertoire."},
/* hu */ {IDGS_MON_DIR_DESCRIPTION_HU, "A knyvtr tartalmnak mutatsa."},
/* it */ {IDGS_MON_DIR_DESCRIPTION_IT, "Mostra il contenuto della directory."},
/* ko */ {IDGS_MON_DIR_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_DIR_DESCRIPTION_NL, "Toon de directory-inhoud."},
/* pl */ {IDGS_MON_DIR_DESCRIPTION_PL, "Poka zawarto katalogu."},
/* ru */ {IDGS_MON_DIR_DESCRIPTION_RU, "  ."},
/* sv */ {IDGS_MON_DIR_DESCRIPTION_SV, "Visa katalogens innehll."},
/* tr */ {IDGS_MON_DIR_DESCRIPTION_TR, "Dizin ieriini grntle."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_LIST_DESCRIPTION,    N_("List disk contents.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_LIST_DESCRIPTION_DA, "Vis diskens indhold."},
/* de */ {IDGS_MON_LIST_DESCRIPTION_DE, "Zeige den Verzeichnisinhalt."},
/* es */ {IDGS_MON_LIST_DESCRIPTION_ES, "Listado contenidos disco"},
/* fr */ {IDGS_MON_LIST_DESCRIPTION_FR, "Affiche le contenu du disque."},
/* hu */ {IDGS_MON_LIST_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_LIST_DESCRIPTION_IT, "Elenca i contenuti del disco."},
/* ko */ {IDGS_MON_LIST_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_LIST_DESCRIPTION_NL, "Toon disk inhoud."},
/* pl */ {IDGS_MON_LIST_DESCRIPTION_PL, "Poka zawarto dysku"},
/* ru */ {IDGS_MON_LIST_DESCRIPTION_RU, "List disk contents."},
/* sv */ {IDGS_MON_LIST_DESCRIPTION_SV, "Visa diskens innehll"},
/* tr */ {IDGS_MON_LIST_DESCRIPTION_TR, "Disk ieriini listele."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_LOAD_DESCRIPTION,    N_("Load the specified file into memory at the specified address. Set BASIC\npointers appropriately if loaded into computer memory (not all emulators).\nUse (otherwise ignored) two-byte load address from file if no address\nspecified.\nIf device is 0, the file is read from the file system.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_LOAD_DESCRIPTION_DA, "Indls filen i hukommelsen p den angivne adresse. Opdaterer\nBASIC-pointers ved lsning til computerens hukommelse (ikke alle\nemulatorer). Hvis ingen adresse angives bruges load-adressen fra(som ellers ignoreres).\nHvis enhed er 0 lses fra filsystemet."},
/* de */ {IDGS_MON_LOAD_DESCRIPTION_DE, "Lade die angegebene Datei in den Speicher auf die angegebene Adresse.\nSetze den BASIC Zeiger entsprechend, wenn in den Rechnerspeicher geladen \nwurde (nicht bei allen Emulatoren!).\nVerwende (sonst ignoriert) die zwei-Byte Lade-Adresse aus der Datei, wenn\nkeine Adresse angegeben wurde.\nBei Gert 0, wird die Datei vom Dateisystem gelade."},
/* es */ {IDGS_MON_LOAD_DESCRIPTION_ES, "Cargar el fichero especificado en la direccin de memoria indicada. Actualizar\npunteros BASIC apropiadamente si se carga en la memoria del ordenador\n(no en todos los emuladores).\nUsar direccin de dos bytes del fichero si no se indica otra direccin.\nSi el perifrico es 0, el fichero se lee del sistema."},
/* fr */ {IDGS_MON_LOAD_DESCRIPTION_FR, "Charge le fichier spcifi en mmoire  l'adresse spcifie. Rgle les\npointeurs BASIC correctement si charge dans la mmoire de l'ordinateur\n(sur certains mulateurs seulement). Utilise l'adresse  deux bits du\nfichier si aucune adresse de chargement n'est spcifie.\nSi le priphrique est 0, le fichier est lu du systme de fichiers."},
/* hu */ {IDGS_MON_LOAD_DESCRIPTION_HU, "A megadott fjl betltse a megadott cmre. A BASIC mutatkat\na megfelel mdon belltja, ha a szmtgp memriba tlti az adatot\n(nem minden emultornl). Ha nincs cm megadva, az amgy figyelmen hagyott\nkt bjtos betltsi cmet hasznlja a fjlbl.\nHa az eszkz 0, a fjlt a fjlrendszerrl olvassa."},
/* it */ {IDGS_MON_LOAD_DESCRIPTION_IT, "Carica il file specificato in memoria all'indirizzo specificato. Imposta\ni puntatori del BASIC in modo appropriato se caricato nella memoria\ndel computer (non su tutti gli emulatori).\nUsa (altrimenti ignora) l'indirizzo di caricamento su due byte del file\nse non viene specificato alcun indirizzo.\nSe la periferica  0, il file viene letto dal file system."},
/* ko */ {IDGS_MON_LOAD_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_LOAD_DESCRIPTION_NL, "Laad het opgegeven bestand naar het geheugen op het opgegeven adres. Zet de BASIC\nstart en eind indicators correct als het bestand naar het computer geheugen\ngeladen wordt (niet alle emulators). De eerste twee bytes van het bestand\nzullen als laad adres worden gebruikt als er geen adres is opgegeven. Als\nhet apparaat 0 is, zal het bestand van het bestandssysteem worden geladen."},
/* pl */ {IDGS_MON_LOAD_DESCRIPTION_PL, "Wczytaj podany plik do pamici w konkretnym adresie. Ustaw wskaniki\nBASIC odpowiednio, jesli zostan wczytane do pamici komputera\n(nie wszystkie emulatory). Uyj (w innym razie ignoruje) dwubajtowego\nadresu wczytywania z pliku, jeli nie zosta podany adres.\nJeli urzdzenie jest 0, plik zostaje oczytany z systemu plikw."},
/* ru */ {IDGS_MON_LOAD_DESCRIPTION_RU, "Load the specified file into memory at the specified address. Set BASIC\npointers appropriately if loaded into computer memory (not all emulators).\nUse (otherwise ignored) two-byte load address from file if no address\nspecified.\nIf device is 0, the file is read from the file system."},
/* sv */ {IDGS_MON_LOAD_DESCRIPTION_SV, "Ls in den angivna filen i minnet p den angivna adressen. Stter\nmotsvarande BASIC-pekare vid lsning till datorminnet (inte alla\nemulatorer). Om ingen adress anges anvnds tvbytesadressen i filen(ignoreras annars).\nOm enheten r 0 lses filen frn filsystemet."},
/* tr */ {IDGS_MON_LOAD_DESCRIPTION_TR, "Belirtilmi dosyay belirtilen adresten itibaren bellee ykle. Eer\nbilgisayar belleine yklenmise BASIC imlelerini uygun bir biimde\nayarla (tm emlatrlerde deil). Eer adres belirtilmemise iki bytelk\ndosya ykleme adresini kullan (dier ihtimalde yoksay).\nEer aygt 0 ise, dosya dosya sisteminden okunur."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_PWD_DESCRIPTION,    N_("Show current working directory.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_PWD_DESCRIPTION_DA, "Vis aktuelt arbejdskatalog."},
/* de */ {IDGS_MON_PWD_DESCRIPTION_DE, "Zeige aktuelles Arbeitsverzeichnis."},
/* es */ {IDGS_MON_PWD_DESCRIPTION_ES, "Muestra el directorio de trabajo actual"},
/* fr */ {IDGS_MON_PWD_DESCRIPTION_FR, "Voir le rpertoire en cours."},
/* hu */ {IDGS_MON_PWD_DESCRIPTION_HU, "Munkaknyvtr mutatsa."},
/* it */ {IDGS_MON_PWD_DESCRIPTION_IT, "Mostra la directory di lavoro attuale."},
/* ko */ {IDGS_MON_PWD_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_PWD_DESCRIPTION_NL, "Toon de huidige werkdirectory."},
/* pl */ {IDGS_MON_PWD_DESCRIPTION_PL, "Poka obecny katalog roboczy."},
/* ru */ {IDGS_MON_PWD_DESCRIPTION_RU, "   ."},
/* sv */ {IDGS_MON_PWD_DESCRIPTION_SV, "Visa aktuell arbetskatalog."},
/* tr */ {IDGS_MON_PWD_DESCRIPTION_TR, "Geerli alma dizinini gster."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_SAVE_DESCRIPTION,    N_("Save the memory from address1 to address2 to the specified file.\nWrite two-byte load address.\nIf device is 0, the file is written to the file system.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_SAVE_DESCRIPTION_DA, "Gem hukommelsen fra  adresse1 til adresse2 til den angivne fil.\nSkriv 2-byte loadadresse i starten af filen.\nHvis enhed er 0 skrives til filsystemet."},
/* de */ {IDGS_MON_SAVE_DESCRIPTION_DE, "Speichere den Speicher von Adresse1 bis Adresse2 in die angegebene Datei.\nSchreibe eine zwei-Byte Lade Adresse.\nBei Gert 0, wird dei Datei in das Dateisystem geschrieben."},
/* es */ {IDGS_MON_SAVE_DESCRIPTION_ES, "Graba memoria entre direccin1 y direccin2 al fichero indicado.\nGraba direccin de carga de dos bytes.\nSi el perifrico es 0, se graba en el sistema."},
/* fr */ {IDGS_MON_SAVE_DESCRIPTION_FR, "Sauvegarde la mmoire depuis adress1 jusqu' adress2 dans le\nfichier spcifi. crit l'adresse  deux bits de chargement dans\nle fichier. Si le priphrique est 0, le fichier est crit dans\nle systme de fichier."},
/* hu */ {IDGS_MON_SAVE_DESCRIPTION_HU, "A memria cm1 s cm2 kztti tartomnynak fjlba mentse.\nA ktbjtos betltsi cmet is kirja.\nHa az eszkz 0, a fjlt a fjlrendszeren hozza ltre."},
/* it */ {IDGS_MON_SAVE_DESCRIPTION_IT, "Salva la memoria compresa tra indirizzo1 e indirizzo2 sul file\nspecificato.\nScrive l'indirizzo di caricamento su due byte.\nSe la periferica  0, il file  scritto sul file system."},
/* ko */ {IDGS_MON_SAVE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_SAVE_DESCRIPTION_NL, "Sla het geheugen tussen adres1 en adres2 op naar het opgegeven bestand.\nSchrijf een laad adres van twee bytes.\nAls het apparaat 0 is, zal het bestand geschreven worden naar het\nbestandssysteem."},
/* pl */ {IDGS_MON_SAVE_DESCRIPTION_PL, "Zapisz pami od address1 do address2 do podanego pliku.\nZapisz dwubajtowy adres wczytania.\nJeli urzdzenie jest 0, plik zostaje zapisany do systemu plikw."},
/* ru */ {IDGS_MON_SAVE_DESCRIPTION_RU, "Save the memory from address1 to address2 to the specified file.\nWrite two-byte load address.\nIf device is 0, the file is written to the file system."},
/* sv */ {IDGS_MON_SAVE_DESCRIPTION_SV, "Spara minnet frn adress1 till adress2 till den angivna filen.\nSkriv tvbytes inlsningsadress.\nOm enheten r 0 skrivs filen till filsystemet."},
/* tr */ {IDGS_MON_SAVE_DESCRIPTION_TR, "Adres1'den adres2'ye kadar olan bellei belirtilen dosyaya kaydet.\nki bytelk ykeme adresini yaz.\nEer aygt 0 ise, dosya dosya sistemine yazlr."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_OTHER_COMMANDS,    N_("Other commands:")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_OTHER_COMMANDS_DA, "Andre kommandoer:"},
/* de */ {IDGS_OTHER_COMMANDS_DE, "Andere Kommandos:"},
/* es */ {IDGS_OTHER_COMMANDS_ES, "Otros comandos:"},
/* fr */ {IDGS_OTHER_COMMANDS_FR, "Autres commandes:"},
/* hu */ {IDGS_OTHER_COMMANDS_HU, ""},  /* fuzzy */
/* it */ {IDGS_OTHER_COMMANDS_IT, "Altri comandi:"},
/* ko */ {IDGS_OTHER_COMMANDS_KO, ""},  /* fuzzy */
/* nl */ {IDGS_OTHER_COMMANDS_NL, "Andere commando's:"},
/* pl */ {IDGS_OTHER_COMMANDS_PL, "Pozostae polecenia:"},
/* ru */ {IDGS_OTHER_COMMANDS_RU, " :"},
/* sv */ {IDGS_OTHER_COMMANDS_SV, "Andra kommandon:"},
/* tr */ {IDGS_OTHER_COMMANDS_TR, "Dier komutlar:"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DISPLAY_NUMBER_DESCRIPTION,    N_("Display the specified number in decimal, hex, octal and binary.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_DA, "Vis det angivne tal som decimal, hexadecimal, oktal og binrt."},
/* de */ {IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_DE, "Zeige die angegebene Zahl in dezimal, hexadezimal, oktal oder binr."},
/* es */ {IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_ES, "Mostrar el numero indicado en decimal, hex, octal y binario."},
/* fr */ {IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_FR, "Affiche le nombre spcifi en dcimal, hexa, octal et binaire."},
/* hu */ {IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_HU, "A megadott szm kirsa decimlisan, hexadecimlisan, oktlisan s binrisan."},
/* it */ {IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_IT, "Mostra il numero specificato in decimale, esadecimale, ottale e binario."},
/* ko */ {IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_NL, "Toon het opgegeven nummer in decimaal, hex, octaal en binair."},
/* pl */ {IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_PL, "Poka dan liczb w systemie dziesitnym, szesnastkowym, semkowym i binarnym."},
/* ru */ {IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_RU, "Display the specified number in decimal, hex, octal and binary."},
/* sv */ {IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_SV, "Visa det angivna talet decimalt, hexadecimalt, oktalt och binrt."},
/* tr */ {IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_TR, "Belirtilen sayy 10'lu, 16'l, 8'li ya da 2'li olarak grntle."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_CARTFREEZE_DESCRIPTION,    N_("Use cartridge freeze.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_CARTFREEZE_DESCRIPTION_DA, "Brug cartridge frys-funktion."},
/* de */ {IDGS_MON_CARTFREEZE_DESCRIPTION_DE, "Erweiterungsmodul Freeze benutzen."},
/* es */ {IDGS_MON_CARTFREEZE_DESCRIPTION_ES, "Usar congelacin cartucho"},
/* fr */ {IDGS_MON_CARTFREEZE_DESCRIPTION_FR, "Geler la cartouche."},
/* hu */ {IDGS_MON_CARTFREEZE_DESCRIPTION_HU, "Cartridge fagyaszts hasznlata."},
/* it */ {IDGS_MON_CARTFREEZE_DESCRIPTION_IT, "Usa freeze della cartuccia."},
/* ko */ {IDGS_MON_CARTFREEZE_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_CARTFREEZE_DESCRIPTION_NL, "Gebruik cartridge freeze."},
/* pl */ {IDGS_MON_CARTFREEZE_DESCRIPTION_PL, "Uyj zamroenia kartrida"},
/* ru */ {IDGS_MON_CARTFREEZE_DESCRIPTION_RU, "Use cartridge freeze."},
/* sv */ {IDGS_MON_CARTFREEZE_DESCRIPTION_SV, "Anvnd insticksmodulens frysfunktion."},
/* tr */ {IDGS_MON_CARTFREEZE_DESCRIPTION_TR, "Kartu freeze kullan"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_HELP_DESCRIPTION,    N_("If no argument is given, prints out a list of all available commands\nIf an argument is given, prints out specific help for that command.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_HELP_DESCRIPTION_DA, "Hvis der ikke angives et argument vises en liste over mulige kommandoer.\nAngives et argument vises hjlp for denne kommando."},
/* de */ {IDGS_MON_HELP_DESCRIPTION_DE, "Wenn kein Argement angegeben wurde, werden alle Kommandos ausgegeben.\nMit Argument, zeige die Hilfe fr das angegebene Kommand."},
/* es */ {IDGS_MON_HELP_DESCRIPTION_ES, "Si no se muestran argumentos, imprime salida de todos los comandos disponibles\nSi se da un argumento, imprime la ayuda especfica para el comando."},
/* fr */ {IDGS_MON_HELP_DESCRIPTION_FR, "Si aucun argument n'est donn, affiche une liste des commandes disponibles\nSi un argument est donne, affiche l'aide spcifique  la commande donne."},
/* hu */ {IDGS_MON_HELP_DESCRIPTION_HU, "Ha nincs paramter, az sszes ltez parancs listjt mutatja.\nHa van, az adott parancshoz mutatja a sgt."},
/* it */ {IDGS_MON_HELP_DESCRIPTION_IT, "Se non viene specificato alcun argomeno, stampa l'elenco di tutti i\ncomandi disponibili.\nSe viene specificato un argomento, stampa l'aiuto relativo a quel\ncomando."},
/* ko */ {IDGS_MON_HELP_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_HELP_DESCRIPTION_NL, "Als er geen parameter is opgegeven, zal een lijst van alle commando's\nworden weergegeven. Als er een parameter is opgegeven, zal de help voor\nhet opgegeven commando worden weergegeven."},
/* pl */ {IDGS_MON_HELP_DESCRIPTION_PL, "Jeli nie jest podany argument, pokazuje list dostpnych polece.\nJeli zosta podany argument, pokazuje pomoc do tego polecenia."},
/* ru */ {IDGS_MON_HELP_DESCRIPTION_RU, "If no argument is given, prints out a list of all available commands\nIf an argument is given, prints out specific help for that command."},
/* sv */ {IDGS_MON_HELP_DESCRIPTION_SV, "Om du inte anger ngra argument visas alla tillgngliga kommandon.\nOm du anger ett argument visas hjlp fr det specifika kommandot."},
/* tr */ {IDGS_MON_HELP_DESCRIPTION_TR, "Eer hi argman verilmemise, tm mevcut komutlarn listesi yazdrlr\nEer bir argman verilmise, o komuta zel yardm bilgisi yazdrlr."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_STRING,    N_("string")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_STRING_DA, "streng"},
/* de */ {IDGS_STRING_DE, "String"},
/* es */ {IDGS_STRING_ES, "cadena"},
/* fr */ {IDGS_STRING_FR, "chaine"},
/* hu */ {IDGS_STRING_HU, ""},  /* fuzzy */
/* it */ {IDGS_STRING_IT, "stringa"},
/* ko */ {IDGS_STRING_KO, ""},  /* fuzzy */
/* nl */ {IDGS_STRING_NL, "tekenreeks"},
/* pl */ {IDGS_STRING_PL, "string"},
/* ru */ {IDGS_STRING_RU, "string"},
/* sv */ {IDGS_STRING_SV, "strng"},
/* tr */ {IDGS_STRING_TR, "yaz"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_KEYBUF_DESCRIPTION,    N_("Put the specified string into the keyboard buffer.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_KEYBUF_DESCRIPTION_DA, "Indst den angivne streng i tastatur-bufferen."},
/* de */ {IDGS_MON_KEYBUF_DESCRIPTION_DE, "Definierte Eingabe in Tastaturpuffer bereitstellen."},
/* es */ {IDGS_MON_KEYBUF_DESCRIPTION_ES, "Introduce la cadena indicada en el bfer de teclado."},
/* fr */ {IDGS_MON_KEYBUF_DESCRIPTION_FR, "Placer la chane spcifie dans le tampon clavier."},
/* hu */ {IDGS_MON_KEYBUF_DESCRIPTION_HU, "A megadott sztring elhelyezse a billentyzet pufferben."},
/* it */ {IDGS_MON_KEYBUF_DESCRIPTION_IT, "Metti la stringa specificata nel buffer di tastiera."},
/* ko */ {IDGS_MON_KEYBUF_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_KEYBUF_DESCRIPTION_NL, "Plaats de opgegeven tekenreeks in de toetsenbordbuffer."},
/* pl */ {IDGS_MON_KEYBUF_DESCRIPTION_PL, "Umie dany cig znakw w buforze klawiatury"},
/* ru */ {IDGS_MON_KEYBUF_DESCRIPTION_RU, "Put the specified string into the keyboard buffer."},
/* sv */ {IDGS_MON_KEYBUF_DESCRIPTION_SV, "Lgg den angivna strngen i tangentbordsbufferten."},
/* tr */ {IDGS_MON_KEYBUF_DESCRIPTION_TR, "Klavye arabelleine belirtilen yazy koy."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_PLAYBACK_DESCRIPTION,    N_("Monitor commands from the specified file are read and executed.  This\ncommand stops at the end of file or when a STOP command is read.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_PLAYBACK_DESCRIPTION_DA, "Monitorkommandoer indlses fra den angivne fil og udfres. Kommandoen\nstopper nr slutningen af filen ns, eller nr der opdages en STOP-kommando."},
/* de */ {IDGS_MON_PLAYBACK_DESCRIPTION_DE, "Monitor Kommandos aus der angegebenen Datei werden gelesen und ausgefhrt.\nDieses Kommando stoppt, wenn das Ende der Datei erreicht wurde, oder das\nKommando STOP gelesen wurde."},
/* es */ {IDGS_MON_PLAYBACK_DESCRIPTION_ES, "Los comandos de monitor incluidos en el fichero indicado, han sido ledos y ejecutados\nEstos comandos se detendrn al finalizar el fichero o cuando se lea un comando STOP."},
/* fr */ {IDGS_MON_PLAYBACK_DESCRIPTION_FR, "Les commandes moniteur du fichier spcifi sont lues et xcutes.\nCette commande s'arrte  la fin du fichier ou lorsqu'une commande\nSTOP est lue."},
/* hu */ {IDGS_MON_PLAYBACK_DESCRIPTION_HU, "A monitor parancsokat beolvassa s vgrehajtja a megadott fjlbl.\nA fjl vgig halad, vagy egy beolvasott STOP parancsig."},
/* it */ {IDGS_MON_PLAYBACK_DESCRIPTION_IT, "I comandi del monitor sono letti ed eseguiti dal file specificato. Questo\ncomando si arresta alla fine del file o quando viene letto il comando\nSTOP."},
/* ko */ {IDGS_MON_PLAYBACK_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_PLAYBACK_DESCRIPTION_NL, "Monitor commando's van het opgegeven bestand zullen worden gelezen en\nuitgevoerd. Dit commando stopt aan het einde van het bestand of wanneer\neen STOP commando wordt gelezen."},
/* pl */ {IDGS_MON_PLAYBACK_DESCRIPTION_PL, "Polecenia monitora z podanego pliku s odczytywane i wykonywane.\nTa komenda zatrzymuje si na kocu pliku, bd przy odczycie komendy STOP."},
/* ru */ {IDGS_MON_PLAYBACK_DESCRIPTION_RU, "Monitor commands from the specified file are read and executed.  This\ncommand stops at the end of file or when a STOP command is read."},
/* sv */ {IDGS_MON_PLAYBACK_DESCRIPTION_SV, "Monitorkommandon lses in och krs frn den angivna filen. Kommandot\nstoppar vid filslut eller nr ett STOP-kommando lses."},
/* tr */ {IDGS_MON_PLAYBACK_DESCRIPTION_TR, "Belirtilen dosyadaki monitr komutlar okundu ve altrld.  Bu\nkomut dosya sonunda ya da STOP komutu okunduunda sonlanr."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_EXPRESSION,    N_("expression")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_EXPRESSION_DA, "udtryk"},
/* de */ {IDGS_EXPRESSION_DE, "Ausdruck"},
/* es */ {IDGS_EXPRESSION_ES, "expresin"},
/* fr */ {IDGS_EXPRESSION_FR, "expression"},
/* hu */ {IDGS_EXPRESSION_HU, ""},  /* fuzzy */
/* it */ {IDGS_EXPRESSION_IT, "espressione"},
/* ko */ {IDGS_EXPRESSION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_EXPRESSION_NL, "expressie"},
/* pl */ {IDGS_EXPRESSION_PL, "expression"},
/* ru */ {IDGS_EXPRESSION_RU, "expression"},
/* sv */ {IDGS_EXPRESSION_SV, "uttryck"},
/* tr */ {IDGS_EXPRESSION_TR, "ifade"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_PRINT_DESCRIPTION,    N_("Evaluate the specified expression and output the result.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_PRINT_DESCRIPTION_DA, "Evalur det angivne udtryk og vis resultatet."},
/* de */ {IDGS_MON_PRINT_DESCRIPTION_DE, "Evaluiere den angegebenen Ausdruck und zeige das Ergebnis."},
/* es */ {IDGS_MON_PRINT_DESCRIPTION_ES, "Evaluar la expresin y mostrar los resultados."},
/* fr */ {IDGS_MON_PRINT_DESCRIPTION_FR, "value l'expression spcifie et affiche le rsultat."},
/* hu */ {IDGS_MON_PRINT_DESCRIPTION_HU, "Kirtkeli a megadott kifejezst s kirja az eredmnyt."},
/* it */ {IDGS_MON_PRINT_DESCRIPTION_IT, "Calcola l'espressione specificata e mostra il risultato."},
/* ko */ {IDGS_MON_PRINT_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_PRINT_DESCRIPTION_NL, "Evalueer de opgegeven expressie en toon het resultaat."},
/* pl */ {IDGS_MON_PRINT_DESCRIPTION_PL, "Oszacuj okrelone wyraenie i podaj rezultat."},
/* ru */ {IDGS_MON_PRINT_DESCRIPTION_RU, "Evaluate the specified expression and output the result."},
/* sv */ {IDGS_MON_PRINT_DESCRIPTION_SV, "Utvrdera det angivna uttrycket och visa resultatet."},
/* tr */ {IDGS_MON_PRINT_DESCRIPTION_TR, "Belirtilen ifadeyi deerlendir ve sonucun ktsn ver."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_RECORD_DESCRIPTION,    N_("After this command, all commands entered are written to the specified\nfile until the STOP command is entered.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_RECORD_DESCRIPTION_DA, "Efter denne kommando skrives alle kommandoer til den angivne fil,\nindtil der angives en STOP-kommando."},
/* de */ {IDGS_MON_RECORD_DESCRIPTION_DE, "Nach diesem Kommando werden alle eingebenen Kommands in die angegebene\nDatei gespeicher solang bis das Kommando STOP eingegeben wurde."},
/* es */ {IDGS_MON_RECORD_DESCRIPTION_ES, "Despus de este comando, todos los posteriormente introducidos se grabaran\nen el fichero indicado hasta que se entre el comando STOP."},
/* fr */ {IDGS_MON_RECORD_DESCRIPTION_FR, "Aprs cette commande, toutes les commandes entres sont crites au\nfichier spcifi jusqu' ce qu'une commande STOP soit entre."},
/* hu */ {IDGS_MON_RECORD_DESCRIPTION_HU, "Ezutn a parancs utn az sszes parancsot a megadott fjlba\nrja, amg STOP parancs nem rkezik."},
/* it */ {IDGS_MON_RECORD_DESCRIPTION_IT, "Dopo questo comando, tutti i comandi inseriti saranno scritti sul file\nspecificato fino a quando verr inserito il comando STOP."},
/* ko */ {IDGS_MON_RECORD_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_RECORD_DESCRIPTION_NL, "Na dit commando zullen alle opgegeven commando's worden geschreven naar\nhet opgegeven bestand totdat het STOP commando wordt opgegeven."},
/* pl */ {IDGS_MON_RECORD_DESCRIPTION_PL, "Po tym poleceniu wszystkie wprowadzone polecenia s zapisywane\ndo podanego pliku, pki nie zostanie wprowadzone polecenie STOP."},
/* ru */ {IDGS_MON_RECORD_DESCRIPTION_RU, "After this command, all commands entered are written to the specified\nfile until the STOP command is entered."},
/* sv */ {IDGS_MON_RECORD_DESCRIPTION_SV, "Efter detta kommando kommer alla kommandon som anges att skrivas till\nden angivna filen tills ett STOP-kommando anges."},
/* tr */ {IDGS_MON_RECORD_DESCRIPTION_TR, "Bu komuttan sonra, tm girilen komutlar ve STOP komutunu grene dek\nbelirtilen dosyaya yazlacaktr."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_RESOURCE,    N_("resource")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_RESOURCE_DA, "resource"},
/* de */ {IDGS_RESOURCE_DE, "Ressource"},
/* es */ {IDGS_RESOURCE_ES, "fuente"},
/* fr */ {IDGS_RESOURCE_FR, "ressource"},
/* hu */ {IDGS_RESOURCE_HU, ""},  /* fuzzy */
/* it */ {IDGS_RESOURCE_IT, "risorsa"},
/* ko */ {IDGS_RESOURCE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_RESOURCE_NL, "bron"},
/* pl */ {IDGS_RESOURCE_PL, "resource"},
/* ru */ {IDGS_RESOURCE_RU, "resource"},
/* sv */ {IDGS_RESOURCE_SV, "resurs"},
/* tr */ {IDGS_RESOURCE_TR, "kaynak"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_RESOURCEGET_DESCRIPTION,    N_("Displays the value of the resource.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_RESOURCEGET_DESCRIPTION_DA, "Viser vrdien for ressourcen."},
/* de */ {IDGS_MON_RESOURCEGET_DESCRIPTION_DE, "Zeige den Werde der Ressource."},
/* es */ {IDGS_MON_RESOURCEGET_DESCRIPTION_ES, "Mostrar el valor del recurso"},
/* fr */ {IDGS_MON_RESOURCEGET_DESCRIPTION_FR, "Affiche la valeur de la ressource."},
/* hu */ {IDGS_MON_RESOURCEGET_DESCRIPTION_HU, "Az erforrs rtknek kirsa."},
/* it */ {IDGS_MON_RESOURCEGET_DESCRIPTION_IT, "Mostra il valore della risorsa."},
/* ko */ {IDGS_MON_RESOURCEGET_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_RESOURCEGET_DESCRIPTION_NL, "Toont de waarde van de bron."},
/* pl */ {IDGS_MON_RESOURCEGET_DESCRIPTION_PL, "Pokazuje warto zasobu"},
/* ru */ {IDGS_MON_RESOURCEGET_DESCRIPTION_RU, "Displays the value of the resource."},
/* sv */ {IDGS_MON_RESOURCEGET_DESCRIPTION_SV, "Visar vrdet fr resursen."},
/* tr */ {IDGS_MON_RESOURCEGET_DESCRIPTION_TR, "Kaynan deerini grntler."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_VALUE,    N_("value")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_VALUE_DA, "vrdi"},
/* de */ {IDGS_VALUE_DE, "Wert"},
/* es */ {IDGS_VALUE_ES, "valor"},
/* fr */ {IDGS_VALUE_FR, "valeur"},
/* hu */ {IDGS_VALUE_HU, ""},  /* fuzzy */
/* it */ {IDGS_VALUE_IT, "valore"},
/* ko */ {IDGS_VALUE_KO, "ġ"},
/* nl */ {IDGS_VALUE_NL, "waarde"},
/* pl */ {IDGS_VALUE_PL, "warto"},
/* ru */ {IDGS_VALUE_RU, "value"},
/* sv */ {IDGS_VALUE_SV, "vrde"},
/* tr */ {IDGS_VALUE_TR, "deer"},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_RESOURCESET_DESCRIPTION,    N_("Sets the value of the resource.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_RESOURCESET_DESCRIPTION_DA, "Stter vrdien for ressourcen."},
/* de */ {IDGS_MON_RESOURCESET_DESCRIPTION_DE, "Setze den Werde der Ressource."},
/* es */ {IDGS_MON_RESOURCESET_DESCRIPTION_ES, "Seleccionar el valor de los recursos"},
/* fr */ {IDGS_MON_RESOURCESET_DESCRIPTION_FR, "Dfinir la valeur de la ressource."},
/* hu */ {IDGS_MON_RESOURCESET_DESCRIPTION_HU, "Az erforrs rtknek belltsa."},
/* it */ {IDGS_MON_RESOURCESET_DESCRIPTION_IT, "Imposta il valore della risorsa."},
/* ko */ {IDGS_MON_RESOURCESET_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_RESOURCESET_DESCRIPTION_NL, "Stel de waarde in van de bron."},
/* pl */ {IDGS_MON_RESOURCESET_DESCRIPTION_PL, "Ustawia warto zasobu."},
/* ru */ {IDGS_MON_RESOURCESET_DESCRIPTION_RU, "Sets the value of the resource."},
/* sv */ {IDGS_MON_RESOURCESET_DESCRIPTION_SV, "Stller in ett vrde fr resursen."},
/* tr */ {IDGS_MON_RESOURCESET_DESCRIPTION_TR, "Kaynan deerini belirler."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_LOAD_RESOURCES_DESCRIPTION,    N_("Loads resources from file.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_LOAD_RESOURCES_DESCRIPTION_DA, "Indls indstillinger fra fil."},
/* de */ {IDGS_MON_LOAD_RESOURCES_DESCRIPTION_DE, "Einstellungen aus Datei laden"},
/* es */ {IDGS_MON_LOAD_RESOURCES_DESCRIPTION_ES, "Cargar recursos desde fichero."},
/* fr */ {IDGS_MON_LOAD_RESOURCES_DESCRIPTION_FR, "Charger ressources depuis fichier."},
/* hu */ {IDGS_MON_LOAD_RESOURCES_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_LOAD_RESOURCES_DESCRIPTION_IT, "Carica le risorse da file."},
/* ko */ {IDGS_MON_LOAD_RESOURCES_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_LOAD_RESOURCES_DESCRIPTION_NL, "Laad instellingen van bestand"},
/* pl */ {IDGS_MON_LOAD_RESOURCES_DESCRIPTION_PL, "Wczytaj zasoby z pliku."},
/* ru */ {IDGS_MON_LOAD_RESOURCES_DESCRIPTION_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MON_LOAD_RESOURCES_DESCRIPTION_SV, "Lser in resurser frn fil."},
/* tr */ {IDGS_MON_LOAD_RESOURCES_DESCRIPTION_TR, "Kaynaklar dosyadan ykler."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_SAVE_RESOURCES_DESCRIPTION,    N_("Saves resources to file.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_SAVE_RESOURCES_DESCRIPTION_DA, "Gem indstillinger til fil."},
/* de */ {IDGS_MON_SAVE_RESOURCES_DESCRIPTION_DE, "Einstellungen speichern unter"},
/* es */ {IDGS_MON_SAVE_RESOURCES_DESCRIPTION_ES, "Grabar recursos a fichero."},
/* fr */ {IDGS_MON_SAVE_RESOURCES_DESCRIPTION_FR, "Enregistrer les ressources dans un fichier."},
/* hu */ {IDGS_MON_SAVE_RESOURCES_DESCRIPTION_HU, ""},  /* fuzzy */
/* it */ {IDGS_MON_SAVE_RESOURCES_DESCRIPTION_IT, "Salva le risorse su file."},
/* ko */ {IDGS_MON_SAVE_RESOURCES_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_SAVE_RESOURCES_DESCRIPTION_NL, "Sla instellingen op naar bestand"},
/* pl */ {IDGS_MON_SAVE_RESOURCES_DESCRIPTION_PL, "Zapisz zasoby do pliku."},
/* ru */ {IDGS_MON_SAVE_RESOURCES_DESCRIPTION_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MON_SAVE_RESOURCES_DESCRIPTION_SV, "Sparar resurser till fil."},
/* tr */ {IDGS_MON_SAVE_RESOURCES_DESCRIPTION_TR, "Kaynaklar dosyaya kaydeder."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_STOP_DESCRIPTION,    N_("Stop recording commands.  See `record'.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_STOP_DESCRIPTION_DA, "Afslut optagelse. Se \"record\"."},
/* de */ {IDGS_MON_STOP_DESCRIPTION_DE, "Stoppe die Aufnahme von Kommandos. Siehe auch `Record'."},
/* es */ {IDGS_MON_STOP_DESCRIPTION_ES, "Detener comando de grabacin. Ver 'grabacin'"},
/* fr */ {IDGS_MON_STOP_DESCRIPTION_FR, "Arrte l'enregistrement de commandes. Voir `record'."},
/* hu */ {IDGS_MON_STOP_DESCRIPTION_HU, "A parancsok rgztsnek befejezse.  Lsd `record'"},
/* it */ {IDGS_MON_STOP_DESCRIPTION_IT, "Ferma il comando di registrazione. Guarda `registra'."},
/* ko */ {IDGS_MON_STOP_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_STOP_DESCRIPTION_NL, "Stop de opname van commando's. Zie 'record'."},
/* pl */ {IDGS_MON_STOP_DESCRIPTION_PL, "Przesta zapisywa polecenia. Zobacz `record'."},
/* ru */ {IDGS_MON_STOP_DESCRIPTION_RU, "Stop recording commands.  See `record'."},
/* sv */ {IDGS_MON_STOP_DESCRIPTION_SV, "Sluta spela in kommandon. Se \"record\"."},
/* tr */ {IDGS_MON_STOP_DESCRIPTION_TR, "Kayt komutlarn durdur.  `record'a bak."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_SCREENSHOT_DESCRIPTION,    N_("Take a screenshot. Format is:\ndefault = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_SCREENSHOT_DESCRIPTION_DA, "Gem et screenshot. Format er:\nstandard = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* de */ {IDGS_MON_SCREENSHOT_DESCRIPTION_DE, "Erzeuge Screenshot. Format ist:\nStandard = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* es */ {IDGS_MON_SCREENSHOT_DESCRIPTION_ES, "Tomar Captura de pantalla. El formato es:\npor defecto = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* fr */ {IDGS_MON_SCREENSHOT_DESCRIPTION_FR, "Prend un imprime-cran. Les formats sont:\nDfaut = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* hu */ {IDGS_MON_SCREENSHOT_DESCRIPTION_HU, "Kpernykp ksztse. A formtum lehet:\nalap = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* it */ {IDGS_MON_SCREENSHOT_DESCRIPTION_IT, "Cattura schermo. Il formato :\npredefinito = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* ko */ {IDGS_MON_SCREENSHOT_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_SCREENSHOT_DESCRIPTION_NL, "Sla een schermafdruk op. Formaat is:\nstandaard = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* pl */ {IDGS_MON_SCREENSHOT_DESCRIPTION_PL, "Zrb zrzut ekranu. Format:\ndomylny = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* ru */ {IDGS_MON_SCREENSHOT_DESCRIPTION_RU, "Take a screenshot. Format is:\ndefault = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* sv */ {IDGS_MON_SCREENSHOT_DESCRIPTION_SV, "Ta en skrmbild. Format r:\nstandard = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
/* tr */ {IDGS_MON_SCREENSHOT_DESCRIPTION_TR, "Ekran grnts al. Biim:\nvarsaylan = BMP, 1 = PCX, 2 = PNG, 3 = GIF, 4 = IFF."},
#endif

/* monitor/mon_command.c */
/* en */ {IDGS_MON_TAPECTRL_DESCRIPTION,    N_("Control the datasette. Valid commands:\n0 = stop, 1 = start, 2 = forward, 3 = rewind, 4 = record,\n5 = reset, 6 = reset counter.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MON_TAPECTRL_DESCRIPTION_DA, "Styr datasette. Lovlige kommandoer:\n0 = stop, 1 = start, 2 = spol frem, 3 = spol tilbage,\n4 = optag, 5 = reset, 6 = nulstil tller."},
/* de */ {IDGS_MON_TAPECTRL_DESCRIPTION_DE, "Steuere die Datasette. Gltige Kommandos sind:\n0 = Stop, 1 = Start, 2 = Forwrts, 3 = Rckwrts, 4 = Aufnahme,\n5 = Reset, 6 = Reset Zhler."},
/* es */ {IDGS_MON_TAPECTRL_DESCRIPTION_ES, "Control unidad cinta, comandos validos:\n0 = alto, 1 = inicio, 2 = avance, 3 = rebobinar, 4 = grabar,\n5 = reinicio, 6 = reiniciar contador."},
/* fr */ {IDGS_MON_TAPECTRL_DESCRIPTION_FR, "Contrle du datassette. Les commandes valides sont :\n0 = STOP, 1 = PLAY, 2 = Avancer, 3 = Reculer, 4 = REC,\n5 = Rinitialiser le ruban, 6 = Rinitialiser le compteur."},
/* hu */ {IDGS_MON_TAPECTRL_DESCRIPTION_HU, "Szalagos egysg vezrlse. rvnyes parancsok:\n0 = start, 1 = indt, 2 = elre, 3 = vissza, 4 = felvtel,\n5 = jraindt, 6 = szmllt nullz"},
/* it */ {IDGS_MON_TAPECTRL_DESCRIPTION_IT, "Controlla il registratore. Comandi validi:\n0 = ferma, 1 = avvia, 2 = avanti, 3 = indietro, 4 = registra,\n5 = reset, 6 = reset contatore."},
/* ko */ {IDGS_MON_TAPECTRL_DESCRIPTION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MON_TAPECTRL_DESCRIPTION_NL, "Geef datasette commando's. Geldige commando's:\n0 = stop, 1 = start, 2 = vooruit, 3 = terug, 4 = opnemen,\n5 = reset, 6 = reset teller."},
/* pl */ {IDGS_MON_TAPECTRL_DESCRIPTION_PL, "Kontrola magnetofonu. Waciwe polecenia:\n0 = stop, 1 = start, 2 = naprzd, 3 = przewi, 4 = nagrywaj,\n5 = reset, 6 = reset licznika."},
/* ru */ {IDGS_MON_TAPECTRL_DESCRIPTION_RU, "Control the datasette. Valid commands:\n0 = stop, 1 = start, 2 = forward, 3 = rewind, 4 = record,\n5 = reset, 6 = reset counter."},
/* sv */ {IDGS_MON_TAPECTRL_DESCRIPTION_SV, "Styr bandspelaren. Giltiga kommandon:\n0 = stoppa, 1 = starta, 2 = spola framt, 3 = spola bakt,\n4 = spela in, 5 = terstll, 6 = nollstll rknare."},
/* tr */ {IDGS_MON_TAPECTRL_DESCRIPTION_TR, "Teybi kontrol et. Geerli komutlar:\n0 = durdur, 1 = balat, 2 = ileri, 3 = geri, 4 = kayt,\n5 = reset, 6 = reset sayac."},
#endif

/* joyport.c */
/* en */ {IDGS_CONTROL_PORT,    N_("Control port")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CONTROL_PORT_DA, ""},  /* fuzzy */
/* de */ {IDGS_CONTROL_PORT_DE, "Control Port"},
/* es */ {IDGS_CONTROL_PORT_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CONTROL_PORT_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CONTROL_PORT_HU, ""},  /* fuzzy */
/* it */ {IDGS_CONTROL_PORT_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CONTROL_PORT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CONTROL_PORT_NL, "Spel connector"},
/* pl */ {IDGS_CONTROL_PORT_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CONTROL_PORT_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CONTROL_PORT_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CONTROL_PORT_TR, ""},  /* fuzzy */
#endif

/* joyport.c */
/* en */ {IDGS_CONTROL_PORT_1,    N_("Control port 1")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CONTROL_PORT_1_DA, ""},  /* fuzzy */
/* de */ {IDGS_CONTROL_PORT_1_DE, "Control Port 1"},
/* es */ {IDGS_CONTROL_PORT_1_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CONTROL_PORT_1_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CONTROL_PORT_1_HU, ""},  /* fuzzy */
/* it */ {IDGS_CONTROL_PORT_1_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CONTROL_PORT_1_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CONTROL_PORT_1_NL, "Spel connector 1"},
/* pl */ {IDGS_CONTROL_PORT_1_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CONTROL_PORT_1_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CONTROL_PORT_1_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CONTROL_PORT_1_TR, ""},  /* fuzzy */
#endif

/* joyport.c */
/* en */ {IDGS_CONTROL_PORT_2,    N_("Control port 2")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CONTROL_PORT_2_DA, ""},  /* fuzzy */
/* de */ {IDGS_CONTROL_PORT_2_DE, "Control Port 2"},
/* es */ {IDGS_CONTROL_PORT_2_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CONTROL_PORT_2_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CONTROL_PORT_2_HU, ""},  /* fuzzy */
/* it */ {IDGS_CONTROL_PORT_2_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CONTROL_PORT_2_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CONTROL_PORT_2_NL, "Spel connector 2"},
/* pl */ {IDGS_CONTROL_PORT_2_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CONTROL_PORT_2_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CONTROL_PORT_2_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CONTROL_PORT_2_TR, ""},  /* fuzzy */
#endif

/* joyport.c */
/* en */ {IDGS_SIDCARD_CONTROL_PORT,    N_("SIDCard control port")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SIDCARD_CONTROL_PORT_DA, ""},  /* fuzzy */
/* de */ {IDGS_SIDCARD_CONTROL_PORT_DE, "SIDCard Control Port"},
/* es */ {IDGS_SIDCARD_CONTROL_PORT_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SIDCARD_CONTROL_PORT_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SIDCARD_CONTROL_PORT_HU, ""},  /* fuzzy */
/* it */ {IDGS_SIDCARD_CONTROL_PORT_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SIDCARD_CONTROL_PORT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SIDCARD_CONTROL_PORT_NL, "SIDCard spel connector"},
/* pl */ {IDGS_SIDCARD_CONTROL_PORT_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SIDCARD_CONTROL_PORT_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SIDCARD_CONTROL_PORT_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SIDCARD_CONTROL_PORT_TR, ""},  /* fuzzy */
#endif

/* joyport.c */
/* en */ {IDGS_USERPORT_JOY_ADAPTER_PORT_1,    N_("Userport joystick adapter port 1")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_USERPORT_JOY_ADAPTER_PORT_1_DA, ""},  /* fuzzy */
/* de */ {IDGS_USERPORT_JOY_ADAPTER_PORT_1_DE, "Userport Joystick Adapter Port 1"},
/* es */ {IDGS_USERPORT_JOY_ADAPTER_PORT_1_ES, ""},  /* fuzzy */
/* fr */ {IDGS_USERPORT_JOY_ADAPTER_PORT_1_FR, ""},  /* fuzzy */
/* hu */ {IDGS_USERPORT_JOY_ADAPTER_PORT_1_HU, ""},  /* fuzzy */
/* it */ {IDGS_USERPORT_JOY_ADAPTER_PORT_1_IT, ""},  /* fuzzy */
/* ko */ {IDGS_USERPORT_JOY_ADAPTER_PORT_1_KO, ""},  /* fuzzy */
/* nl */ {IDGS_USERPORT_JOY_ADAPTER_PORT_1_NL, "Userport joystick adapter poort 1"},
/* pl */ {IDGS_USERPORT_JOY_ADAPTER_PORT_1_PL, ""},  /* fuzzy */
/* ru */ {IDGS_USERPORT_JOY_ADAPTER_PORT_1_RU, ""},  /* fuzzy */
/* sv */ {IDGS_USERPORT_JOY_ADAPTER_PORT_1_SV, ""},  /* fuzzy */
/* tr */ {IDGS_USERPORT_JOY_ADAPTER_PORT_1_TR, ""},  /* fuzzy */
#endif

/* joyport.c */
/* en */ {IDGS_USERPORT_JOY_ADAPTER_PORT_2,    N_("Userport joystick adapter port 2")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_USERPORT_JOY_ADAPTER_PORT_2_DA, ""},  /* fuzzy */
/* de */ {IDGS_USERPORT_JOY_ADAPTER_PORT_2_DE, "Userport Joystick Adapter Port 2"},
/* es */ {IDGS_USERPORT_JOY_ADAPTER_PORT_2_ES, ""},  /* fuzzy */
/* fr */ {IDGS_USERPORT_JOY_ADAPTER_PORT_2_FR, ""},  /* fuzzy */
/* hu */ {IDGS_USERPORT_JOY_ADAPTER_PORT_2_HU, ""},  /* fuzzy */
/* it */ {IDGS_USERPORT_JOY_ADAPTER_PORT_2_IT, ""},  /* fuzzy */
/* ko */ {IDGS_USERPORT_JOY_ADAPTER_PORT_2_KO, ""},  /* fuzzy */
/* nl */ {IDGS_USERPORT_JOY_ADAPTER_PORT_2_NL, "Userport joystick adapter poort 2"},
/* pl */ {IDGS_USERPORT_JOY_ADAPTER_PORT_2_PL, ""},  /* fuzzy */
/* ru */ {IDGS_USERPORT_JOY_ADAPTER_PORT_2_RU, ""},  /* fuzzy */
/* sv */ {IDGS_USERPORT_JOY_ADAPTER_PORT_2_SV, ""},  /* fuzzy */
/* tr */ {IDGS_USERPORT_JOY_ADAPTER_PORT_2_TR, ""},  /* fuzzy */
#endif

/* joyport.c */
/* en */ {IDGS_SELECTED_PORT_NOT_PRESENT,    N_("Selected port (%d) is not present on this emulator")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SELECTED_PORT_NOT_PRESENT_DA, ""},  /* fuzzy */
/* de */ {IDGS_SELECTED_PORT_NOT_PRESENT_DE, "Ausgewhltes Port (%d) ist in diesem Emulator nicht verfgbar"},
/* es */ {IDGS_SELECTED_PORT_NOT_PRESENT_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SELECTED_PORT_NOT_PRESENT_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SELECTED_PORT_NOT_PRESENT_HU, ""},  /* fuzzy */
/* it */ {IDGS_SELECTED_PORT_NOT_PRESENT_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SELECTED_PORT_NOT_PRESENT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SELECTED_PORT_NOT_PRESENT_NL, "Geselecteerde poort (%d) is niet aanwezig in deze emulator"},
/* pl */ {IDGS_SELECTED_PORT_NOT_PRESENT_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SELECTED_PORT_NOT_PRESENT_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SELECTED_PORT_NOT_PRESENT_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SELECTED_PORT_NOT_PRESENT_TR, ""},  /* fuzzy */
#endif

/* joyport.c */
/* en */ {IDGS_SELECTED_JOYPORT_DEV_NOT_REG,    N_("Selected control port device %d is not registered")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SELECTED_JOYPORT_DEV_NOT_REG_DA, ""},  /* fuzzy */
/* de */ {IDGS_SELECTED_JOYPORT_DEV_NOT_REG_DE, "Ausgewhltes Port Gert %d ist nicht registriert"},
/* es */ {IDGS_SELECTED_JOYPORT_DEV_NOT_REG_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SELECTED_JOYPORT_DEV_NOT_REG_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SELECTED_JOYPORT_DEV_NOT_REG_HU, ""},  /* fuzzy */
/* it */ {IDGS_SELECTED_JOYPORT_DEV_NOT_REG_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SELECTED_JOYPORT_DEV_NOT_REG_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SELECTED_JOYPORT_DEV_NOT_REG_NL, "Geselecteerde spel connector apparaat %d is niet geregistreerd"},
/* pl */ {IDGS_SELECTED_JOYPORT_DEV_NOT_REG_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SELECTED_JOYPORT_DEV_NOT_REG_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SELECTED_JOYPORT_DEV_NOT_REG_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SELECTED_JOYPORT_DEV_NOT_REG_TR, ""},  /* fuzzy */
#endif

/* joyport.c */
/* en */ {IDGS_SELECTED_JOYPORT_DEV_ALREADY_ATTACHED,    N_("Selected control port device %s on %s is already attached to %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SELECTED_JOYPORT_DEV_ALREADY_ATTACHED_DA, ""},  /* fuzzy */
/* de */ {IDGS_SELECTED_JOYPORT_DEV_ALREADY_ATTACHED_DE, "Ausgewhltes Control Port Gert %s auf Port %s ist schon in Port %s in Verwendung"},
/* es */ {IDGS_SELECTED_JOYPORT_DEV_ALREADY_ATTACHED_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SELECTED_JOYPORT_DEV_ALREADY_ATTACHED_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SELECTED_JOYPORT_DEV_ALREADY_ATTACHED_HU, ""},  /* fuzzy */
/* it */ {IDGS_SELECTED_JOYPORT_DEV_ALREADY_ATTACHED_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SELECTED_JOYPORT_DEV_ALREADY_ATTACHED_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SELECTED_JOYPORT_DEV_ALREADY_ATTACHED_NL, "Geselecteerde spel connector apparaat %s op %s is al gekoppeld aan %s"},
/* pl */ {IDGS_SELECTED_JOYPORT_DEV_ALREADY_ATTACHED_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SELECTED_JOYPORT_DEV_ALREADY_ATTACHED_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SELECTED_JOYPORT_DEV_ALREADY_ATTACHED_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SELECTED_JOYPORT_DEV_ALREADY_ATTACHED_TR, ""},  /* fuzzy */
#endif

/* joyport.c */
/* en */ {IDGS_SELECTED_JOYPORT_SAME_INPUT_RES,    N_("Selected control port device %s on %s uses same host input resource (%s) as the device attached to %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SELECTED_JOYPORT_SAME_INPUT_RES_DA, ""},  /* fuzzy */
/* de */ {IDGS_SELECTED_JOYPORT_SAME_INPUT_RES_DE, "Ausgewhltes Control Port Gert %s auf Port %s benutzt die gleiche Host\nInput Resource (%s) wie das auf Port %s benutzte Gert"},
/* es */ {IDGS_SELECTED_JOYPORT_SAME_INPUT_RES_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SELECTED_JOYPORT_SAME_INPUT_RES_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SELECTED_JOYPORT_SAME_INPUT_RES_HU, ""},  /* fuzzy */
/* it */ {IDGS_SELECTED_JOYPORT_SAME_INPUT_RES_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SELECTED_JOYPORT_SAME_INPUT_RES_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SELECTED_JOYPORT_SAME_INPUT_RES_NL, "Geselecteerd spel connector apparaat %s op %s gebruikt dezelfde fysieke invoerinstelling (%s) als het apparaat dat gekoppeld is aan %s"},
/* pl */ {IDGS_SELECTED_JOYPORT_SAME_INPUT_RES_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SELECTED_JOYPORT_SAME_INPUT_RES_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SELECTED_JOYPORT_SAME_INPUT_RES_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SELECTED_JOYPORT_SAME_INPUT_RES_TR, ""},  /* fuzzy */
#endif

/* joyport.c */
/* en */ {IDGS_SELECTED_DEVICE_NOT_THIS_PORT,    N_("Selected control port device %s cannot be attached to %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SELECTED_DEVICE_NOT_THIS_PORT_DA, ""},  /* fuzzy */
/* de */ {IDGS_SELECTED_DEVICE_NOT_THIS_PORT_DE, "Ausgewhltes Control Port Gert %s kann nicht auf Port %s verwendet werden"},
/* es */ {IDGS_SELECTED_DEVICE_NOT_THIS_PORT_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SELECTED_DEVICE_NOT_THIS_PORT_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SELECTED_DEVICE_NOT_THIS_PORT_HU, ""},  /* fuzzy */
/* it */ {IDGS_SELECTED_DEVICE_NOT_THIS_PORT_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SELECTED_DEVICE_NOT_THIS_PORT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SELECTED_DEVICE_NOT_THIS_PORT_NL, "Geselecteerd spel connector apparaat %s kan niet worden gekoppeld aan %s"},
/* pl */ {IDGS_SELECTED_DEVICE_NOT_THIS_PORT_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SELECTED_DEVICE_NOT_THIS_PORT_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SELECTED_DEVICE_NOT_THIS_PORT_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SELECTED_DEVICE_NOT_THIS_PORT_TR, ""},  /* fuzzy */
#endif


/* joyport.c */
/* en */ {IDGS_HOST_MOUSE,    N_("host mouse")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_HOST_MOUSE_DA, ""},  /* fuzzy */
/* de */ {IDGS_HOST_MOUSE_DE, "Host Maus"},
/* es */ {IDGS_HOST_MOUSE_ES, ""},  /* fuzzy */
/* fr */ {IDGS_HOST_MOUSE_FR, ""},  /* fuzzy */
/* hu */ {IDGS_HOST_MOUSE_HU, ""},  /* fuzzy */
/* it */ {IDGS_HOST_MOUSE_IT, ""},  /* fuzzy */
/* ko */ {IDGS_HOST_MOUSE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_HOST_MOUSE_NL, "fysieke muis"},
/* pl */ {IDGS_HOST_MOUSE_PL, ""},  /* fuzzy */
/* ru */ {IDGS_HOST_MOUSE_RU, ""},  /* fuzzy */
/* sv */ {IDGS_HOST_MOUSE_SV, ""},  /* fuzzy */
/* tr */ {IDGS_HOST_MOUSE_TR, ""},  /* fuzzy */
#endif

/* joyport.c */
/* en */ {IDGS_HOST_SAMPLER,    N_("host sampler (audio input device)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_HOST_SAMPLER_DA, ""},  /* fuzzy */
/* de */ {IDGS_HOST_SAMPLER_DE, "Host Sampler (Audio Input Gert)"},
/* es */ {IDGS_HOST_SAMPLER_ES, ""},  /* fuzzy */
/* fr */ {IDGS_HOST_SAMPLER_FR, ""},  /* fuzzy */
/* hu */ {IDGS_HOST_SAMPLER_HU, ""},  /* fuzzy */
/* it */ {IDGS_HOST_SAMPLER_IT, ""},  /* fuzzy */
/* ko */ {IDGS_HOST_SAMPLER_KO, ""},  /* fuzzy */
/* nl */ {IDGS_HOST_SAMPLER_NL, "fysieke sampler (geluidsinvoer apparaat)"},
/* pl */ {IDGS_HOST_SAMPLER_PL, ""},  /* fuzzy */
/* ru */ {IDGS_HOST_SAMPLER_RU, ""},  /* fuzzy */
/* sv */ {IDGS_HOST_SAMPLER_SV, ""},  /* fuzzy */
/* tr */ {IDGS_HOST_SAMPLER_TR, ""},  /* fuzzy */
#endif

/* joyport.c */
/* en */ {IDGS_NONE,    N_("None")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_NONE_DA, "Ingen"},
/* de */ {IDGS_NONE_DE, "Kein"},
/* es */ {IDGS_NONE_ES, "No"},
/* fr */ {IDGS_NONE_FR, "Aucun"},
/* hu */ {IDGS_NONE_HU, "Nincs"},
/* it */ {IDGS_NONE_IT, "Nessuno"},
/* ko */ {IDGS_NONE_KO, ""},
/* nl */ {IDGS_NONE_NL, "Geen"},
/* pl */ {IDGS_NONE_PL, "Brak"},
/* ru */ {IDGS_NONE_RU, "None"},
/* sv */ {IDGS_NONE_SV, "Ingen"},
/* tr */ {IDGS_NONE_TR, "Yok"},
#endif

/* joystick.c */
/* en */ {IDGS_JOYSTICK,    N_("Joystick")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_JOYSTICK_DA, "Joystick"},
/* de */ {IDGS_JOYSTICK_DE, "Joystick"},
/* es */ {IDGS_JOYSTICK_ES, "Joystick"},
/* fr */ {IDGS_JOYSTICK_FR, "Joystick"},
/* hu */ {IDGS_JOYSTICK_HU, "Botkormny"},
/* it */ {IDGS_JOYSTICK_IT, "Joystick"},
/* ko */ {IDGS_JOYSTICK_KO, "̽ƽ"},
/* nl */ {IDGS_JOYSTICK_NL, "Joystick"},
/* pl */ {IDGS_JOYSTICK_PL, "Joystick"},
/* ru */ {IDGS_JOYSTICK_RU, ""},
/* sv */ {IDGS_JOYSTICK_SV, "Styrspak"},
/* tr */ {IDGS_JOYSTICK_TR, "Joystick"},
#endif

/* mouse.c */
/* en */ {IDGS_PADDLES,    N_("Paddles")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_PADDLES_DA, "Paddles"},
/* de */ {IDGS_PADDLES_DE, "Paddles"},
/* es */ {IDGS_PADDLES_ES, "Paddles"},
/* fr */ {IDGS_PADDLES_FR, "Paddles"},
/* hu */ {IDGS_PADDLES_HU, ""},  /* fuzzy */
/* it */ {IDGS_PADDLES_IT, "Paddle"},
/* ko */ {IDGS_PADDLES_KO, "е"},
/* nl */ {IDGS_PADDLES_NL, "Paddles"},
/* pl */ {IDGS_PADDLES_PL, "Pokrta sterujce"},
/* ru */ {IDGS_PADDLES_RU, "Paddles"},
/* sv */ {IDGS_PADDLES_SV, "Paddlar"},
/* tr */ {IDGS_PADDLES_TR, "Paddlelar"},
#endif

/* mouse.c */
/* en */ {IDGS_MOUSE_1351,    N_("Mouse (1351)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MOUSE_1351_DA, ""},  /* fuzzy */
/* de */ {IDGS_MOUSE_1351_DE, "Maus (1351)"},
/* es */ {IDGS_MOUSE_1351_ES, ""},  /* fuzzy */
/* fr */ {IDGS_MOUSE_1351_FR, ""},  /* fuzzy */
/* hu */ {IDGS_MOUSE_1351_HU, ""},  /* fuzzy */
/* it */ {IDGS_MOUSE_1351_IT, ""},  /* fuzzy */
/* ko */ {IDGS_MOUSE_1351_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MOUSE_1351_NL, "Muis (1351)"},
/* pl */ {IDGS_MOUSE_1351_PL, ""},  /* fuzzy */
/* ru */ {IDGS_MOUSE_1351_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MOUSE_1351_SV, ""},  /* fuzzy */
/* tr */ {IDGS_MOUSE_1351_TR, ""},  /* fuzzy */
#endif

/* mouse.c */
/* en */ {IDGS_MOUSE_NEOS,    N_("Mouse (NEOS)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MOUSE_NEOS_DA, ""},  /* fuzzy */
/* de */ {IDGS_MOUSE_NEOS_DE, "Maus (NEOS)"},
/* es */ {IDGS_MOUSE_NEOS_ES, ""},  /* fuzzy */
/* fr */ {IDGS_MOUSE_NEOS_FR, ""},  /* fuzzy */
/* hu */ {IDGS_MOUSE_NEOS_HU, ""},  /* fuzzy */
/* it */ {IDGS_MOUSE_NEOS_IT, ""},  /* fuzzy */
/* ko */ {IDGS_MOUSE_NEOS_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MOUSE_NEOS_NL, "Muis (NEOS)"},
/* pl */ {IDGS_MOUSE_NEOS_PL, ""},  /* fuzzy */
/* ru */ {IDGS_MOUSE_NEOS_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MOUSE_NEOS_SV, ""},  /* fuzzy */
/* tr */ {IDGS_MOUSE_NEOS_TR, ""},  /* fuzzy */
#endif

/* mouse.c */
/* en */ {IDGS_MOUSE_AMIGA,    N_("Mouse (Amiga)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MOUSE_AMIGA_DA, ""},  /* fuzzy */
/* de */ {IDGS_MOUSE_AMIGA_DE, "Maus (Amiga)"},
/* es */ {IDGS_MOUSE_AMIGA_ES, ""},  /* fuzzy */
/* fr */ {IDGS_MOUSE_AMIGA_FR, ""},  /* fuzzy */
/* hu */ {IDGS_MOUSE_AMIGA_HU, ""},  /* fuzzy */
/* it */ {IDGS_MOUSE_AMIGA_IT, ""},  /* fuzzy */
/* ko */ {IDGS_MOUSE_AMIGA_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MOUSE_AMIGA_NL, "Muis (Amiga)"},
/* pl */ {IDGS_MOUSE_AMIGA_PL, ""},  /* fuzzy */
/* ru */ {IDGS_MOUSE_AMIGA_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MOUSE_AMIGA_SV, ""},  /* fuzzy */
/* tr */ {IDGS_MOUSE_AMIGA_TR, ""},  /* fuzzy */
#endif

/* mouse.c */
/* en */ {IDGS_MOUSE_CX22,    N_("Mouse (CX-22)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MOUSE_CX22_DA, ""},  /* fuzzy */
/* de */ {IDGS_MOUSE_CX22_DE, "Maus (CX-22)"},
/* es */ {IDGS_MOUSE_CX22_ES, ""},  /* fuzzy */
/* fr */ {IDGS_MOUSE_CX22_FR, ""},  /* fuzzy */
/* hu */ {IDGS_MOUSE_CX22_HU, ""},  /* fuzzy */
/* it */ {IDGS_MOUSE_CX22_IT, ""},  /* fuzzy */
/* ko */ {IDGS_MOUSE_CX22_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MOUSE_CX22_NL, "Muis (CX-22)"},
/* pl */ {IDGS_MOUSE_CX22_PL, ""},  /* fuzzy */
/* ru */ {IDGS_MOUSE_CX22_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MOUSE_CX22_SV, ""},  /* fuzzy */
/* tr */ {IDGS_MOUSE_CX22_TR, ""},  /* fuzzy */
#endif

/* mouse.c */
/* en */ {IDGS_MOUSE_ATARI_ST,    N_("Mouse (Atari ST)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MOUSE_ATARI_ST_DA, ""},  /* fuzzy */
/* de */ {IDGS_MOUSE_ATARI_ST_DE, "Maus (Atari ST)"},
/* es */ {IDGS_MOUSE_ATARI_ST_ES, ""},  /* fuzzy */
/* fr */ {IDGS_MOUSE_ATARI_ST_FR, ""},  /* fuzzy */
/* hu */ {IDGS_MOUSE_ATARI_ST_HU, ""},  /* fuzzy */
/* it */ {IDGS_MOUSE_ATARI_ST_IT, ""},  /* fuzzy */
/* ko */ {IDGS_MOUSE_ATARI_ST_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MOUSE_ATARI_ST_NL, "Muis (Atari ST)"},
/* pl */ {IDGS_MOUSE_ATARI_ST_PL, ""},  /* fuzzy */
/* ru */ {IDGS_MOUSE_ATARI_ST_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MOUSE_ATARI_ST_SV, ""},  /* fuzzy */
/* tr */ {IDGS_MOUSE_ATARI_ST_TR, ""},  /* fuzzy */
#endif

/* mouse.c */
/* en */ {IDGS_MOUSE_SMART,    N_("Mouse (SmartMouse)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MOUSE_SMART_DA, ""},  /* fuzzy */
/* de */ {IDGS_MOUSE_SMART_DE, "Maus (SmartMouse)"},
/* es */ {IDGS_MOUSE_SMART_ES, ""},  /* fuzzy */
/* fr */ {IDGS_MOUSE_SMART_FR, ""},  /* fuzzy */
/* hu */ {IDGS_MOUSE_SMART_HU, ""},  /* fuzzy */
/* it */ {IDGS_MOUSE_SMART_IT, ""},  /* fuzzy */
/* ko */ {IDGS_MOUSE_SMART_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MOUSE_SMART_NL, "Muis (SmartMouse)"},
/* pl */ {IDGS_MOUSE_SMART_PL, ""},  /* fuzzy */
/* ru */ {IDGS_MOUSE_SMART_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MOUSE_SMART_SV, ""},  /* fuzzy */
/* tr */ {IDGS_MOUSE_SMART_TR, ""},  /* fuzzy */
#endif

/* mouse.c */
/* en */ {IDGS_MOUSE_MICROMYS,    N_("Mouse (Micromys)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MOUSE_MICROMYS_DA, ""},  /* fuzzy */
/* de */ {IDGS_MOUSE_MICROMYS_DE, "Maus (Micromys)"},
/* es */ {IDGS_MOUSE_MICROMYS_ES, ""},  /* fuzzy */
/* fr */ {IDGS_MOUSE_MICROMYS_FR, ""},  /* fuzzy */
/* hu */ {IDGS_MOUSE_MICROMYS_HU, ""},  /* fuzzy */
/* it */ {IDGS_MOUSE_MICROMYS_IT, ""},  /* fuzzy */
/* ko */ {IDGS_MOUSE_MICROMYS_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MOUSE_MICROMYS_NL, "Muis (Micromys)"},
/* pl */ {IDGS_MOUSE_MICROMYS_PL, ""},  /* fuzzy */
/* ru */ {IDGS_MOUSE_MICROMYS_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MOUSE_MICROMYS_SV, ""},  /* fuzzy */
/* tr */ {IDGS_MOUSE_MICROMYS_TR, ""},  /* fuzzy */
#endif

/* mouse.c */
/* en */ {IDGS_KOALAPAD,    N_("KoalaPad")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_KOALAPAD_DA, ""},  /* fuzzy */
/* de */ {IDGS_KOALAPAD_DE, "KoalaPad"},
/* es */ {IDGS_KOALAPAD_ES, ""},  /* fuzzy */
/* fr */ {IDGS_KOALAPAD_FR, ""},  /* fuzzy */
/* hu */ {IDGS_KOALAPAD_HU, ""},  /* fuzzy */
/* it */ {IDGS_KOALAPAD_IT, ""},  /* fuzzy */
/* ko */ {IDGS_KOALAPAD_KO, ""},  /* fuzzy */
/* nl */ {IDGS_KOALAPAD_NL, "KoalaPad"},
/* pl */ {IDGS_KOALAPAD_PL, ""},  /* fuzzy */
/* ru */ {IDGS_KOALAPAD_RU, ""},  /* fuzzy */
/* sv */ {IDGS_KOALAPAD_SV, ""},  /* fuzzy */
/* tr */ {IDGS_KOALAPAD_TR, ""},  /* fuzzy */
#endif

/* joyport/sampler2bit.c */
/* en */ {IDGS_SAMPLER_2BIT,    N_("Sampler (2bit)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SAMPLER_2BIT_DA, ""},  /* fuzzy */
/* de */ {IDGS_SAMPLER_2BIT_DE, "Sampler (2bit)"},
/* es */ {IDGS_SAMPLER_2BIT_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SAMPLER_2BIT_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SAMPLER_2BIT_HU, ""},  /* fuzzy */
/* it */ {IDGS_SAMPLER_2BIT_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SAMPLER_2BIT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SAMPLER_2BIT_NL, "Sampler (2bit)"},
/* pl */ {IDGS_SAMPLER_2BIT_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SAMPLER_2BIT_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SAMPLER_2BIT_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SAMPLER_2BIT_TR, ""},  /* fuzzy */
#endif

/* joyport/sampler4bit.c */
/* en */ {IDGS_SAMPLER_4BIT,    N_("Sampler (4bit)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SAMPLER_4BIT_DA, ""},  /* fuzzy */
/* de */ {IDGS_SAMPLER_4BIT_DE, "Sampler (4bit)"},
/* es */ {IDGS_SAMPLER_4BIT_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SAMPLER_4BIT_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SAMPLER_4BIT_HU, ""},  /* fuzzy */
/* it */ {IDGS_SAMPLER_4BIT_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SAMPLER_4BIT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SAMPLER_4BIT_NL, "Sampler (4bit)"},
/* pl */ {IDGS_SAMPLER_4BIT_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SAMPLER_4BIT_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SAMPLER_4BIT_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SAMPLER_4BIT_TR, ""},  /* fuzzy */
#endif

/* joyport/bbrtc.c */
/* en */ {IDGS_BBRTC,    N_("BBRTC")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_BBRTC_DA, ""},  /* fuzzy */
/* de */ {IDGS_BBRTC_DE, "BBRTC"},
/* es */ {IDGS_BBRTC_ES, ""},  /* fuzzy */
/* fr */ {IDGS_BBRTC_FR, ""},  /* fuzzy */
/* hu */ {IDGS_BBRTC_HU, ""},  /* fuzzy */
/* it */ {IDGS_BBRTC_IT, ""},  /* fuzzy */
/* ko */ {IDGS_BBRTC_KO, ""},  /* fuzzy */
/* nl */ {IDGS_BBRTC_NL, "BBRTC"},
/* pl */ {IDGS_BBRTC_PL, ""},  /* fuzzy */
/* ru */ {IDGS_BBRTC_RU, ""},  /* fuzzy */
/* sv */ {IDGS_BBRTC_SV, ""},  /* fuzzy */
/* tr */ {IDGS_BBRTC_TR, ""},  /* fuzzy */
#endif

/* joyport/paperclip64.c */
/* en */ {IDGS_PAPERCLIP64_DONGLE,    N_("Paperclip64 dongle")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_PAPERCLIP64_DONGLE_DA, ""},  /* fuzzy */
/* de */ {IDGS_PAPERCLIP64_DONGLE_DE, "Paperclip64 Dongle"},
/* es */ {IDGS_PAPERCLIP64_DONGLE_ES, ""},  /* fuzzy */
/* fr */ {IDGS_PAPERCLIP64_DONGLE_FR, ""},  /* fuzzy */
/* hu */ {IDGS_PAPERCLIP64_DONGLE_HU, ""},  /* fuzzy */
/* it */ {IDGS_PAPERCLIP64_DONGLE_IT, ""},  /* fuzzy */
/* ko */ {IDGS_PAPERCLIP64_DONGLE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_PAPERCLIP64_DONGLE_NL, "Paperclip64 dongle"},
/* pl */ {IDGS_PAPERCLIP64_DONGLE_PL, ""},  /* fuzzy */
/* ru */ {IDGS_PAPERCLIP64_DONGLE_RU, ""},  /* fuzzy */
/* sv */ {IDGS_PAPERCLIP64_DONGLE_SV, ""},  /* fuzzy */
/* tr */ {IDGS_PAPERCLIP64_DONGLE_TR, ""},  /* fuzzy */
#endif

/* joyport/coplin_keypad.c */
/* en */ {IDGS_COPLIN_KEYPAD,    N_("Coplin Keypad")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_COPLIN_KEYPAD_DA, ""},  /* fuzzy */
/* de */ {IDGS_COPLIN_KEYPAD_DE, "Coplin Keypad"},
/* es */ {IDGS_COPLIN_KEYPAD_ES, ""},  /* fuzzy */
/* fr */ {IDGS_COPLIN_KEYPAD_FR, ""},  /* fuzzy */
/* hu */ {IDGS_COPLIN_KEYPAD_HU, ""},  /* fuzzy */
/* it */ {IDGS_COPLIN_KEYPAD_IT, ""},  /* fuzzy */
/* ko */ {IDGS_COPLIN_KEYPAD_KO, ""},  /* fuzzy */
/* nl */ {IDGS_COPLIN_KEYPAD_NL, "Coplin toetsenblok"},
/* pl */ {IDGS_COPLIN_KEYPAD_PL, ""},  /* fuzzy */
/* ru */ {IDGS_COPLIN_KEYPAD_RU, ""},  /* fuzzy */
/* sv */ {IDGS_COPLIN_KEYPAD_SV, ""},  /* fuzzy */
/* tr */ {IDGS_COPLIN_KEYPAD_TR, ""},  /* fuzzy */
#endif

/* joyport/script64_dongle.c */
/* en */ {IDGS_SCRIPT64_DONGLE,    N_("Script 64 dongle")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SCRIPT64_DONGLE_DA, ""},  /* fuzzy */
/* de */ {IDGS_SCRIPT64_DONGLE_DE, ""},  /* fuzzy */
/* es */ {IDGS_SCRIPT64_DONGLE_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SCRIPT64_DONGLE_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SCRIPT64_DONGLE_HU, ""},  /* fuzzy */
/* it */ {IDGS_SCRIPT64_DONGLE_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SCRIPT64_DONGLE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SCRIPT64_DONGLE_NL, "Script 64 dongle"},
/* pl */ {IDGS_SCRIPT64_DONGLE_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SCRIPT64_DONGLE_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SCRIPT64_DONGLE_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SCRIPT64_DONGLE_TR, ""},  /* fuzzy */
#endif

/* joyport/vizawrite64_dongle.c */
/* en */ {IDGS_VIZAWRITE64_DONGLE,    N_("VizaWrite 64 dongle")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_VIZAWRITE64_DONGLE_DA, ""},  /* fuzzy */
/* de */ {IDGS_VIZAWRITE64_DONGLE_DE, ""},  /* fuzzy */
/* es */ {IDGS_VIZAWRITE64_DONGLE_ES, ""},  /* fuzzy */
/* fr */ {IDGS_VIZAWRITE64_DONGLE_FR, ""},  /* fuzzy */
/* hu */ {IDGS_VIZAWRITE64_DONGLE_HU, ""},  /* fuzzy */
/* it */ {IDGS_VIZAWRITE64_DONGLE_IT, ""},  /* fuzzy */
/* ko */ {IDGS_VIZAWRITE64_DONGLE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_VIZAWRITE64_DONGLE_NL, "VizaWrite 64 dongle"},
/* pl */ {IDGS_VIZAWRITE64_DONGLE_PL, ""},  /* fuzzy */
/* ru */ {IDGS_VIZAWRITE64_DONGLE_RU, ""},  /* fuzzy */
/* sv */ {IDGS_VIZAWRITE64_DONGLE_SV, ""},  /* fuzzy */
/* tr */ {IDGS_VIZAWRITE64_DONGLE_TR, ""},  /* fuzzy */
#endif

/* joyport/cx21.c */
/* en */ {IDGS_CX21,    N_("Atari CX21 keypad")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CX21_DA, ""},  /* fuzzy */
/* de */ {IDGS_CX21_DE, "Atari CX-21 Keypad"},
/* es */ {IDGS_CX21_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CX21_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CX21_HU, ""},  /* fuzzy */
/* it */ {IDGS_CX21_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CX21_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CX21_NL, "Atari CX21 toetsenblok"},
/* pl */ {IDGS_CX21_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CX21_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CX21_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CX21_TR, ""},  /* fuzzy */
#endif

/* joyport/cx85.c */
/* en */ {IDGS_CX85,    N_("Atari CX85 keypad")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CX85_DA, ""},  /* fuzzy */
/* de */ {IDGS_CX85_DE, "Atari CX85 keypad"},
/* es */ {IDGS_CX85_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CX85_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CX85_HU, ""},  /* fuzzy */
/* it */ {IDGS_CX85_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CX85_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CX85_NL, "Atari CX85 toetsenblok"},
/* pl */ {IDGS_CX85_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CX85_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CX85_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CX85_TR, ""},  /* fuzzy */
#endif

/* joyport/rushware_keypad.c */
/* en */ {IDGS_RUSHWARE_KEYPAD,    N_("RushWare Keypad")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_RUSHWARE_KEYPAD_DA, ""},  /* fuzzy */
/* de */ {IDGS_RUSHWARE_KEYPAD_DE, "RushWare Keypad"},
/* es */ {IDGS_RUSHWARE_KEYPAD_ES, ""},  /* fuzzy */
/* fr */ {IDGS_RUSHWARE_KEYPAD_FR, ""},  /* fuzzy */
/* hu */ {IDGS_RUSHWARE_KEYPAD_HU, ""},  /* fuzzy */
/* it */ {IDGS_RUSHWARE_KEYPAD_IT, ""},  /* fuzzy */
/* ko */ {IDGS_RUSHWARE_KEYPAD_KO, ""},  /* fuzzy */
/* nl */ {IDGS_RUSHWARE_KEYPAD_NL, "RushWare toetsenblok"},
/* pl */ {IDGS_RUSHWARE_KEYPAD_PL, ""},  /* fuzzy */
/* ru */ {IDGS_RUSHWARE_KEYPAD_RU, ""},  /* fuzzy */
/* sv */ {IDGS_RUSHWARE_KEYPAD_SV, ""},  /* fuzzy */
/* tr */ {IDGS_RUSHWARE_KEYPAD_TR, ""},  /* fuzzy */
#endif

/* joyport/cardkey.c */
/* en */ {IDGS_CARDKEY,    N_("Cardco Cardkey 1 keypad")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CARDKEY_DA, ""},  /* fuzzy */
/* de */ {IDGS_CARDKEY_DE, "Cardco Cardkey 1 Keypad"},
/* es */ {IDGS_CARDKEY_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CARDKEY_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CARDKEY_HU, ""},  /* fuzzy */
/* it */ {IDGS_CARDKEY_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CARDKEY_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CARDKEY_NL, "Cardco Cardkey 1 toetsenblok"},
/* pl */ {IDGS_CARDKEY_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CARDKEY_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CARDKEY_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CARDKEY_TR, ""},  /* fuzzy */
#endif

/* lightpen.c */
/* en */ {IDGS_LIGHTPEN_UP,    N_("Light Pen (up trigger)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_LIGHTPEN_UP_DA, ""},  /* fuzzy */
/* de */ {IDGS_LIGHTPEN_UP_DE, "Lichgriffel (Up Trigger)"},
/* es */ {IDGS_LIGHTPEN_UP_ES, ""},  /* fuzzy */
/* fr */ {IDGS_LIGHTPEN_UP_FR, ""},  /* fuzzy */
/* hu */ {IDGS_LIGHTPEN_UP_HU, ""},  /* fuzzy */
/* it */ {IDGS_LIGHTPEN_UP_IT, ""},  /* fuzzy */
/* ko */ {IDGS_LIGHTPEN_UP_KO, ""},  /* fuzzy */
/* nl */ {IDGS_LIGHTPEN_UP_NL, "Light Pen (up trigger)"},
/* pl */ {IDGS_LIGHTPEN_UP_PL, ""},  /* fuzzy */
/* ru */ {IDGS_LIGHTPEN_UP_RU, ""},  /* fuzzy */
/* sv */ {IDGS_LIGHTPEN_UP_SV, ""},  /* fuzzy */
/* tr */ {IDGS_LIGHTPEN_UP_TR, ""},  /* fuzzy */
#endif

/* lightpen.c */
/* en */ {IDGS_LIGHTPEN_LEFT,    N_("Light Pen (left trigger)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_LIGHTPEN_LEFT_DA, ""},  /* fuzzy */
/* de */ {IDGS_LIGHTPEN_LEFT_DE, "Lichtgriffel (Left Trigger)"},
/* es */ {IDGS_LIGHTPEN_LEFT_ES, ""},  /* fuzzy */
/* fr */ {IDGS_LIGHTPEN_LEFT_FR, ""},  /* fuzzy */
/* hu */ {IDGS_LIGHTPEN_LEFT_HU, ""},  /* fuzzy */
/* it */ {IDGS_LIGHTPEN_LEFT_IT, ""},  /* fuzzy */
/* ko */ {IDGS_LIGHTPEN_LEFT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_LIGHTPEN_LEFT_NL, "Light Pen (left trigger)"},
/* pl */ {IDGS_LIGHTPEN_LEFT_PL, ""},  /* fuzzy */
/* ru */ {IDGS_LIGHTPEN_LEFT_RU, ""},  /* fuzzy */
/* sv */ {IDGS_LIGHTPEN_LEFT_SV, ""},  /* fuzzy */
/* tr */ {IDGS_LIGHTPEN_LEFT_TR, ""},  /* fuzzy */
#endif

/* lightpen.c */
/* en */ {IDGS_DATEL_LIGHTPEN,    N_("Datel Light Pen")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_DATEL_LIGHTPEN_DA, ""},  /* fuzzy */
/* de */ {IDGS_DATEL_LIGHTPEN_DE, "Datel Lichtgriffel"},
/* es */ {IDGS_DATEL_LIGHTPEN_ES, ""},  /* fuzzy */
/* fr */ {IDGS_DATEL_LIGHTPEN_FR, ""},  /* fuzzy */
/* hu */ {IDGS_DATEL_LIGHTPEN_HU, ""},  /* fuzzy */
/* it */ {IDGS_DATEL_LIGHTPEN_IT, ""},  /* fuzzy */
/* ko */ {IDGS_DATEL_LIGHTPEN_KO, ""},  /* fuzzy */
/* nl */ {IDGS_DATEL_LIGHTPEN_NL, "Datel Light Pen"},
/* pl */ {IDGS_DATEL_LIGHTPEN_PL, ""},  /* fuzzy */
/* ru */ {IDGS_DATEL_LIGHTPEN_RU, ""},  /* fuzzy */
/* sv */ {IDGS_DATEL_LIGHTPEN_SV, ""},  /* fuzzy */
/* tr */ {IDGS_DATEL_LIGHTPEN_TR, ""},  /* fuzzy */
#endif

/* lightpen.c */
/* en */ {IDGS_MAGNUM_LIGHT_PHASER,    N_("Magnum Light Phaser")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MAGNUM_LIGHT_PHASER_DA, "Magnum Light Phaser"},
/* de */ {IDGS_MAGNUM_LIGHT_PHASER_DE, "Magnum Light Phaser"},
/* es */ {IDGS_MAGNUM_LIGHT_PHASER_ES, "Magnum Light Phaser"},
/* fr */ {IDGS_MAGNUM_LIGHT_PHASER_FR, "Magnum Light Phaser"},
/* hu */ {IDGS_MAGNUM_LIGHT_PHASER_HU, ""},  /* fuzzy */
/* it */ {IDGS_MAGNUM_LIGHT_PHASER_IT, "Magnum Light Phaser"},
/* ko */ {IDGS_MAGNUM_LIGHT_PHASER_KO, "Magnum Ʈ "},
/* nl */ {IDGS_MAGNUM_LIGHT_PHASER_NL, "Magnum Light Phaser"},
/* pl */ {IDGS_MAGNUM_LIGHT_PHASER_PL, "Magnum Light Phaser"},
/* ru */ {IDGS_MAGNUM_LIGHT_PHASER_RU, "Magnum Light Phaser"},
/* sv */ {IDGS_MAGNUM_LIGHT_PHASER_SV, "Magnum Light Phaser"},
/* tr */ {IDGS_MAGNUM_LIGHT_PHASER_TR, "Magnum Light Phaser"},
#endif

/* lightpen.c */
/* en */ {IDGS_STACK_LIGHT_RIFLE,    N_("Stack Light Rifle")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_STACK_LIGHT_RIFLE_DA, "Stack Light Rifle"},
/* de */ {IDGS_STACK_LIGHT_RIFLE_DE, "Stack Light Rifle"},
/* es */ {IDGS_STACK_LIGHT_RIFLE_ES, "Stack Light Rifle"},
/* fr */ {IDGS_STACK_LIGHT_RIFLE_FR, "Stack Light Rifle"},
/* hu */ {IDGS_STACK_LIGHT_RIFLE_HU, ""},  /* fuzzy */
/* it */ {IDGS_STACK_LIGHT_RIFLE_IT, "Stack Light Rifle"},
/* ko */ {IDGS_STACK_LIGHT_RIFLE_KO, "Stack Ʈ "},
/* nl */ {IDGS_STACK_LIGHT_RIFLE_NL, "Stack Light Rifle"},
/* pl */ {IDGS_STACK_LIGHT_RIFLE_PL, "Stack Light Rifle"},
/* ru */ {IDGS_STACK_LIGHT_RIFLE_RU, "Stack Light Rifle"},
/* sv */ {IDGS_STACK_LIGHT_RIFLE_SV, "Stack Light Rifle"},
/* tr */ {IDGS_STACK_LIGHT_RIFLE_TR, "Stack In Tfei"},
#endif

/* lightpen.c */
/* en */ {IDGS_INKWELL_LIGHTPEN,    N_("Inkwell Light Pen")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_INKWELL_LIGHTPEN_DA, ""},  /* fuzzy */
/* de */ {IDGS_INKWELL_LIGHTPEN_DE, "Inkwell Lichgriffel"},
/* es */ {IDGS_INKWELL_LIGHTPEN_ES, ""},  /* fuzzy */
/* fr */ {IDGS_INKWELL_LIGHTPEN_FR, ""},  /* fuzzy */
/* hu */ {IDGS_INKWELL_LIGHTPEN_HU, ""},  /* fuzzy */
/* it */ {IDGS_INKWELL_LIGHTPEN_IT, ""},  /* fuzzy */
/* ko */ {IDGS_INKWELL_LIGHTPEN_KO, ""},  /* fuzzy */
/* nl */ {IDGS_INKWELL_LIGHTPEN_NL, "Inkwell Light Pen"},
/* pl */ {IDGS_INKWELL_LIGHTPEN_PL, ""},  /* fuzzy */
/* ru */ {IDGS_INKWELL_LIGHTPEN_RU, ""},  /* fuzzy */
/* sv */ {IDGS_INKWELL_LIGHTPEN_SV, ""},  /* fuzzy */
/* tr */ {IDGS_INKWELL_LIGHTPEN_TR, ""},  /* fuzzy */
#endif

/* joyport.c */
/* en */ {IDGS_SET_JOYPORT_S_DEVICE,    N_("Set %s device (0: None")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SET_JOYPORT_S_DEVICE_DA, ""},  /* fuzzy */
/* de */ {IDGS_SET_JOYPORT_S_DEVICE_DE, "Gert %s whlen (0: Kein"},
/* es */ {IDGS_SET_JOYPORT_S_DEVICE_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SET_JOYPORT_S_DEVICE_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SET_JOYPORT_S_DEVICE_HU, ""},  /* fuzzy */
/* it */ {IDGS_SET_JOYPORT_S_DEVICE_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SET_JOYPORT_S_DEVICE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SET_JOYPORT_S_DEVICE_NL, "Stel %s apparaat in (0: Geen"},
/* pl */ {IDGS_SET_JOYPORT_S_DEVICE_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SET_JOYPORT_S_DEVICE_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SET_JOYPORT_S_DEVICE_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SET_JOYPORT_S_DEVICE_TR, ""},  /* fuzzy */
#endif

/* samplerdrv/sampler.c */
/* en */ {IDGS_SAMPLER_USED_BY,    N_("Sampler system already in use by %s.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SAMPLER_USED_BY_DA, ""},  /* fuzzy */
/* de */ {IDGS_SAMPLER_USED_BY_DE, "Sample System bereits von %s benutzt."},
/* es */ {IDGS_SAMPLER_USED_BY_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SAMPLER_USED_BY_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SAMPLER_USED_BY_HU, ""},  /* fuzzy */
/* it */ {IDGS_SAMPLER_USED_BY_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SAMPLER_USED_BY_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SAMPLER_USED_BY_NL, "Sampler systeem wordt al gebruikt door %s."},
/* pl */ {IDGS_SAMPLER_USED_BY_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SAMPLER_USED_BY_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SAMPLER_USED_BY_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SAMPLER_USED_BY_TR, ""},  /* fuzzy */
#endif

/* userport/userport_joystick.c */
/* en */ {IDGS_CGA_JOY_ADAPTER,    N_("CGA userport joy adapter")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CGA_JOY_ADAPTER_DA, "CGA brugerportjoystickadapter"},
/* de */ {IDGS_CGA_JOY_ADAPTER_DE, "CGA Userport Joystick Adapter"},
/* es */ {IDGS_CGA_JOY_ADAPTER_ES, "Adaptador de puerto de juegos CGA"},
/* fr */ {IDGS_CGA_JOY_ADAPTER_FR, "Adaptateur joystick port utilisateur CGA"},
/* hu */ {IDGS_CGA_JOY_ADAPTER_HU, "CGA userport botkormny adapter"},
/* it */ {IDGS_CGA_JOY_ADAPTER_IT, "Adattatore joystick CGA su userport"},
/* ko */ {IDGS_CGA_JOY_ADAPTER_KO, "CGA Ʈ  ƴ"},
/* nl */ {IDGS_CGA_JOY_ADAPTER_NL, "CGA userport joy adapter"},
/* pl */ {IDGS_CGA_JOY_ADAPTER_PL, "Zcze CGA userportu joysticka"},
/* ru */ {IDGS_CGA_JOY_ADAPTER_RU, "CGA userport joy adapter"},
/* sv */ {IDGS_CGA_JOY_ADAPTER_SV, "CGA-anvndarportsspakadapter"},
/* tr */ {IDGS_CGA_JOY_ADAPTER_TR, "CGA userport joy dntrc"},
#endif

/* userport/userport_joystick.c */
/* en */ {IDGS_PET_JOY_ADAPTER,    N_("PET userport joy adapter")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_PET_JOY_ADAPTER_DA, "PET brugerportjoystickadapter"},
/* de */ {IDGS_PET_JOY_ADAPTER_DE, "PET Userport Joystick Adapter"},
/* es */ {IDGS_PET_JOY_ADAPTER_ES, "Adaptador de puerto de juegos PET"},
/* fr */ {IDGS_PET_JOY_ADAPTER_FR, "Adaptateur joystick port utilisateur PET"},
/* hu */ {IDGS_PET_JOY_ADAPTER_HU, "PET userport botkormny adapter"},
/* it */ {IDGS_PET_JOY_ADAPTER_IT, "Adattatore joystick PET su userport"},
/* ko */ {IDGS_PET_JOY_ADAPTER_KO, "PET Ʈ  ƴ"},
/* nl */ {IDGS_PET_JOY_ADAPTER_NL, "PET userport joy adapter"},
/* pl */ {IDGS_PET_JOY_ADAPTER_PL, "Zcze PET userportu joysticka"},
/* ru */ {IDGS_PET_JOY_ADAPTER_RU, "PET userport joy adapter"},
/* sv */ {IDGS_PET_JOY_ADAPTER_SV, "PET-anvndarportsspakadapter"},
/* tr */ {IDGS_PET_JOY_ADAPTER_TR, "PET userport joy dntrc"},
#endif

/* userport/userport_joystick.c */
/* en */ {IDGS_HUMMER_JOY_ADAPTER,    N_("Hummer userport joy adapter")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_HUMMER_JOY_ADAPTER_DA, "Hummer brugerport joystick adapter"},
/* de */ {IDGS_HUMMER_JOY_ADAPTER_DE, "Hummer Userport Joystick Adapter"},
/* es */ {IDGS_HUMMER_JOY_ADAPTER_ES, "Adaptador de puerto de juegos Hummer"},
/* fr */ {IDGS_HUMMER_JOY_ADAPTER_FR, "Adaptateur joystick port utilisateur Hummer"},
/* hu */ {IDGS_HUMMER_JOY_ADAPTER_HU, ""},  /* fuzzy */
/* it */ {IDGS_HUMMER_JOY_ADAPTER_IT, "Adattatore joystick HUMMER su userport"},
/* ko */ {IDGS_HUMMER_JOY_ADAPTER_KO, "Hummer Ʈ  ƴ"},
/* nl */ {IDGS_HUMMER_JOY_ADAPTER_NL, "Hummer userport joystick adapter"},
/* pl */ {IDGS_HUMMER_JOY_ADAPTER_PL, "Zcze Hummer userportu joysticka"},
/* ru */ {IDGS_HUMMER_JOY_ADAPTER_RU, "Hummer userport joy adapter"},
/* sv */ {IDGS_HUMMER_JOY_ADAPTER_SV, "Hummer-anvndarportsspakadapter"},
/* tr */ {IDGS_HUMMER_JOY_ADAPTER_TR, "Hummer userport joy dntrc"},
#endif

/* userport/userport_joystick.c */
/* en */ {IDGS_OEM_JOY_ADAPTER,    N_("OEM userport joy adapter")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_OEM_JOY_ADAPTER_DA, "OEM brugerportjoystickadapter"},
/* de */ {IDGS_OEM_JOY_ADAPTER_DE, "OEM Userport Joystick Adapter"},
/* es */ {IDGS_OEM_JOY_ADAPTER_ES, "Adaptador de puerto de juegos OEM"},
/* fr */ {IDGS_OEM_JOY_ADAPTER_FR, "Adaptateur joystick port utilisateur OEM"},
/* hu */ {IDGS_OEM_JOY_ADAPTER_HU, "OEM userport botkormny adapter"},
/* it */ {IDGS_OEM_JOY_ADAPTER_IT, "Adattatore joystick OEM su userport"},
/* ko */ {IDGS_OEM_JOY_ADAPTER_KO, "OEM Ʈ  ƴ"},
/* nl */ {IDGS_OEM_JOY_ADAPTER_NL, "OEM userport joy adapter"},
/* pl */ {IDGS_OEM_JOY_ADAPTER_PL, "Zcze OEM userportu joysticka"},
/* ru */ {IDGS_OEM_JOY_ADAPTER_RU, "OEM userport joy adapter"},
/* sv */ {IDGS_OEM_JOY_ADAPTER_SV, "OEM-anvndarportsspakadapter"},
/* tr */ {IDGS_OEM_JOY_ADAPTER_TR, "OEM userport joy dntrc"},
#endif

/* userport/userport_joystick.c */
/* en */ {IDGS_HIT_JOY_ADAPTER,    N_("HIT userport joy adapter")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_HIT_JOY_ADAPTER_DA, "HIT brugerportjoystickadapter"},
/* de */ {IDGS_HIT_JOY_ADAPTER_DE, "HIT Userport Joystick Adapter"},
/* es */ {IDGS_HIT_JOY_ADAPTER_ES, "Adaptador de puerto de juegos HIT"},
/* fr */ {IDGS_HIT_JOY_ADAPTER_FR, "Adaptateur joystick port utilisateur HIT"},
/* hu */ {IDGS_HIT_JOY_ADAPTER_HU, "HIT userport botkormny adapter"},
/* it */ {IDGS_HIT_JOY_ADAPTER_IT, "Adattatore joystick HIT su userport"},
/* ko */ {IDGS_HIT_JOY_ADAPTER_KO, "HIT Ʈ  ƴ"},
/* nl */ {IDGS_HIT_JOY_ADAPTER_NL, "HIT userport joy adapter"},
/* pl */ {IDGS_HIT_JOY_ADAPTER_PL, "Zcze HIT userportu joysticka"},
/* ru */ {IDGS_HIT_JOY_ADAPTER_RU, "HIT userport joy adapter"},
/* sv */ {IDGS_HIT_JOY_ADAPTER_SV, "HIT-anvndarportsspakadapter"},
/* tr */ {IDGS_HIT_JOY_ADAPTER_TR, "HIT userport joy dntrc"},
#endif

/* userport/userport_joystick.c */
/* en */ {IDGS_KINGSOFT_JOY_ADAPTER,    N_("KingSoft userport joy adapter")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_KINGSOFT_JOY_ADAPTER_DA, ""},  /* fuzzy */
/* de */ {IDGS_KINGSOFT_JOY_ADAPTER_DE, "Kingsoft Userport Joy Adapter"},
/* es */ {IDGS_KINGSOFT_JOY_ADAPTER_ES, ""},  /* fuzzy */
/* fr */ {IDGS_KINGSOFT_JOY_ADAPTER_FR, ""},  /* fuzzy */
/* hu */ {IDGS_KINGSOFT_JOY_ADAPTER_HU, ""},  /* fuzzy */
/* it */ {IDGS_KINGSOFT_JOY_ADAPTER_IT, ""},  /* fuzzy */
/* ko */ {IDGS_KINGSOFT_JOY_ADAPTER_KO, ""},  /* fuzzy */
/* nl */ {IDGS_KINGSOFT_JOY_ADAPTER_NL, "Kingsoft userport joy adapter"},
/* pl */ {IDGS_KINGSOFT_JOY_ADAPTER_PL, ""},  /* fuzzy */
/* ru */ {IDGS_KINGSOFT_JOY_ADAPTER_RU, ""},  /* fuzzy */
/* sv */ {IDGS_KINGSOFT_JOY_ADAPTER_SV, ""},  /* fuzzy */
/* tr */ {IDGS_KINGSOFT_JOY_ADAPTER_TR, ""},  /* fuzzy */
#endif

/* userport/userport_joystick.c */
/* en */ {IDGS_STARBYTE_JOY_ADAPTER,    N_("StarByte userport joy adapter")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_STARBYTE_JOY_ADAPTER_DA, ""},  /* fuzzy */
/* de */ {IDGS_STARBYTE_JOY_ADAPTER_DE, "Starbyte Userport Joy Adapter"},
/* es */ {IDGS_STARBYTE_JOY_ADAPTER_ES, ""},  /* fuzzy */
/* fr */ {IDGS_STARBYTE_JOY_ADAPTER_FR, ""},  /* fuzzy */
/* hu */ {IDGS_STARBYTE_JOY_ADAPTER_HU, ""},  /* fuzzy */
/* it */ {IDGS_STARBYTE_JOY_ADAPTER_IT, ""},  /* fuzzy */
/* ko */ {IDGS_STARBYTE_JOY_ADAPTER_KO, ""},  /* fuzzy */
/* nl */ {IDGS_STARBYTE_JOY_ADAPTER_NL, "Starbyte userport joy adapter"},
/* pl */ {IDGS_STARBYTE_JOY_ADAPTER_PL, ""},  /* fuzzy */
/* ru */ {IDGS_STARBYTE_JOY_ADAPTER_RU, ""},  /* fuzzy */
/* sv */ {IDGS_STARBYTE_JOY_ADAPTER_SV, ""},  /* fuzzy */
/* tr */ {IDGS_STARBYTE_JOY_ADAPTER_TR, ""},  /* fuzzy */
#endif

/* userport/userport_rtc_58321a.c */
/* en */ {IDGS_USERPORT_RTC58321A,    N_("Userport RTC (RTC58321A)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_USERPORT_RTC58321A_DA, ""},  /* fuzzy */
/* de */ {IDGS_USERPORT_RTC58321A_DE, "Userport RTC (RTC58321A)"},
/* es */ {IDGS_USERPORT_RTC58321A_ES, ""},  /* fuzzy */
/* fr */ {IDGS_USERPORT_RTC58321A_FR, ""},  /* fuzzy */
/* hu */ {IDGS_USERPORT_RTC58321A_HU, ""},  /* fuzzy */
/* it */ {IDGS_USERPORT_RTC58321A_IT, ""},  /* fuzzy */
/* ko */ {IDGS_USERPORT_RTC58321A_KO, ""},  /* fuzzy */
/* nl */ {IDGS_USERPORT_RTC58321A_NL, "Userport RTC (RTC58321A)"},
/* pl */ {IDGS_USERPORT_RTC58321A_PL, ""},  /* fuzzy */
/* ru */ {IDGS_USERPORT_RTC58321A_RU, ""},  /* fuzzy */
/* sv */ {IDGS_USERPORT_RTC58321A_SV, ""},  /* fuzzy */
/* tr */ {IDGS_USERPORT_RTC58321A_TR, ""},  /* fuzzy */
#endif

/* userport/userport_rtc_ds1307.c */
/* en */ {IDGS_USERPORT_DS1307,    N_("Userport RTC (DS1307)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_USERPORT_DS1307_DA, ""},  /* fuzzy */
/* de */ {IDGS_USERPORT_DS1307_DE, "Userport RTC (DS1307)"},
/* es */ {IDGS_USERPORT_DS1307_ES, ""},  /* fuzzy */
/* fr */ {IDGS_USERPORT_DS1307_FR, ""},  /* fuzzy */
/* hu */ {IDGS_USERPORT_DS1307_HU, ""},  /* fuzzy */
/* it */ {IDGS_USERPORT_DS1307_IT, ""},  /* fuzzy */
/* ko */ {IDGS_USERPORT_DS1307_KO, ""},  /* fuzzy */
/* nl */ {IDGS_USERPORT_DS1307_NL, "Userport RTC (DS1307)"},
/* pl */ {IDGS_USERPORT_DS1307_PL, ""},  /* fuzzy */
/* ru */ {IDGS_USERPORT_DS1307_RU, ""},  /* fuzzy */
/* sv */ {IDGS_USERPORT_DS1307_SV, ""},  /* fuzzy */
/* tr */ {IDGS_USERPORT_DS1307_TR, ""},  /* fuzzy */
#endif

/* userport/userport_diag_586220_harness.c */
/* en */ {IDGS_USERPORT_DIAG_586220_HARNESS,    N_("Userport diag 586220 harness")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_USERPORT_DIAG_586220_HARNESS_DA, ""},  /* fuzzy */
/* de */ {IDGS_USERPORT_DIAG_586220_HARNESS_DE, "Userport Diag 586220 Harness"},
/* es */ {IDGS_USERPORT_DIAG_586220_HARNESS_ES, ""},  /* fuzzy */
/* fr */ {IDGS_USERPORT_DIAG_586220_HARNESS_FR, ""},  /* fuzzy */
/* hu */ {IDGS_USERPORT_DIAG_586220_HARNESS_HU, ""},  /* fuzzy */
/* it */ {IDGS_USERPORT_DIAG_586220_HARNESS_IT, ""},  /* fuzzy */
/* ko */ {IDGS_USERPORT_DIAG_586220_HARNESS_KO, ""},  /* fuzzy */
/* nl */ {IDGS_USERPORT_DIAG_586220_HARNESS_NL, "Userport diag 586220 gareel"},
/* pl */ {IDGS_USERPORT_DIAG_586220_HARNESS_PL, ""},  /* fuzzy */
/* ru */ {IDGS_USERPORT_DIAG_586220_HARNESS_RU, ""},  /* fuzzy */
/* sv */ {IDGS_USERPORT_DIAG_586220_HARNESS_SV, ""},  /* fuzzy */
/* tr */ {IDGS_USERPORT_DIAG_586220_HARNESS_TR, ""},  /* fuzzy */
#endif

/* tapeport/tapertc.c */
/* en */ {IDGS_TAPE_RTC,    N_("Tape RTC (PCF8583)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_TAPE_RTC_DA, ""},  /* fuzzy */
/* de */ {IDGS_TAPE_RTC_DE, "Band RTC (PCF8583)"},
/* es */ {IDGS_TAPE_RTC_ES, ""},  /* fuzzy */
/* fr */ {IDGS_TAPE_RTC_FR, ""},  /* fuzzy */
/* hu */ {IDGS_TAPE_RTC_HU, ""},  /* fuzzy */
/* it */ {IDGS_TAPE_RTC_IT, ""},  /* fuzzy */
/* ko */ {IDGS_TAPE_RTC_KO, ""},  /* fuzzy */
/* nl */ {IDGS_TAPE_RTC_NL, "Tape RTC (PCF8583)"},
/* pl */ {IDGS_TAPE_RTC_PL, ""},  /* fuzzy */
/* ru */ {IDGS_TAPE_RTC_RU, ""},  /* fuzzy */
/* sv */ {IDGS_TAPE_RTC_SV, ""},  /* fuzzy */
/* tr */ {IDGS_TAPE_RTC_TR, ""},  /* fuzzy */
#endif

/* tapeport/sense-dongle.c */
/* en */ {IDGS_SENSE_DONGLE,    N_("Sense dongle")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SENSE_DONGLE_DA, ""},  /* fuzzy */
/* de */ {IDGS_SENSE_DONGLE_DE, "Sense Dongle"},
/* es */ {IDGS_SENSE_DONGLE_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SENSE_DONGLE_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SENSE_DONGLE_HU, ""},  /* fuzzy */
/* it */ {IDGS_SENSE_DONGLE_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SENSE_DONGLE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SENSE_DONGLE_NL, "Sense dongle"},
/* pl */ {IDGS_SENSE_DONGLE_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SENSE_DONGLE_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SENSE_DONGLE_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SENSE_DONGLE_TR, ""},  /* fuzzy */
#endif

/* userport/userport_dac.c */
/* en */ {IDGS_USERPORT_DAC,    N_("Userport DAC")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_USERPORT_DAC_DA, "Brugerport DAC"},
/* de */ {IDGS_USERPORT_DAC_DE, "Userport DAC"},
/* es */ {IDGS_USERPORT_DAC_ES, "Puerto de usuario DAC"},
/* fr */ {IDGS_USERPORT_DAC_FR, "DAC port utilisateur"},
/* hu */ {IDGS_USERPORT_DAC_HU, ""},  /* fuzzy */
/* it */ {IDGS_USERPORT_DAC_IT, "DAC su userport "},
/* ko */ {IDGS_USERPORT_DAC_KO, "Ʈ DAC"},
/* nl */ {IDGS_USERPORT_DAC_NL, "Userport DAC"},
/* pl */ {IDGS_USERPORT_DAC_PL, "Userport DAC"},
/* ru */ {IDGS_USERPORT_DAC_RU, ""},  /* fuzzy */
/* sv */ {IDGS_USERPORT_DAC_SV, "Anvndarport-D/A-omvandlare"},
/* tr */ {IDGS_USERPORT_DAC_TR, "Userport DAC"},
#endif

/* userport/userport_digimax.c */
/* en */ {IDGS_USERPORT_DIGIMAX,    N_("Userport DigiMAX")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_USERPORT_DIGIMAX_DA, ""},  /* fuzzy */
/* de */ {IDGS_USERPORT_DIGIMAX_DE, "Userport DigiMAX"},
/* es */ {IDGS_USERPORT_DIGIMAX_ES, ""},  /* fuzzy */
/* fr */ {IDGS_USERPORT_DIGIMAX_FR, ""},  /* fuzzy */
/* hu */ {IDGS_USERPORT_DIGIMAX_HU, ""},  /* fuzzy */
/* it */ {IDGS_USERPORT_DIGIMAX_IT, ""},  /* fuzzy */
/* ko */ {IDGS_USERPORT_DIGIMAX_KO, ""},  /* fuzzy */
/* nl */ {IDGS_USERPORT_DIGIMAX_NL, "Userport DigiMAX"},
/* pl */ {IDGS_USERPORT_DIGIMAX_PL, ""},  /* fuzzy */
/* ru */ {IDGS_USERPORT_DIGIMAX_RU, ""},  /* fuzzy */
/* sv */ {IDGS_USERPORT_DIGIMAX_SV, ""},  /* fuzzy */
/* tr */ {IDGS_USERPORT_DIGIMAX_TR, ""},  /* fuzzy */
#endif

/* userport/userport_4bit_sampler.c */
/* en */ {IDGS_USERPORT_4BIT_SAMPLER,    N_("Userport 4bit sampler")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_USERPORT_4BIT_SAMPLER_DA, ""},  /* fuzzy */
/* de */ {IDGS_USERPORT_4BIT_SAMPLER_DE, "Userport 4bit Sampler"},
/* es */ {IDGS_USERPORT_4BIT_SAMPLER_ES, ""},  /* fuzzy */
/* fr */ {IDGS_USERPORT_4BIT_SAMPLER_FR, ""},  /* fuzzy */
/* hu */ {IDGS_USERPORT_4BIT_SAMPLER_HU, ""},  /* fuzzy */
/* it */ {IDGS_USERPORT_4BIT_SAMPLER_IT, ""},  /* fuzzy */
/* ko */ {IDGS_USERPORT_4BIT_SAMPLER_KO, ""},  /* fuzzy */
/* nl */ {IDGS_USERPORT_4BIT_SAMPLER_NL, "Userport 4bit sampler"},
/* pl */ {IDGS_USERPORT_4BIT_SAMPLER_PL, ""},  /* fuzzy */
/* ru */ {IDGS_USERPORT_4BIT_SAMPLER_RU, ""},  /* fuzzy */
/* sv */ {IDGS_USERPORT_4BIT_SAMPLER_SV, ""},  /* fuzzy */
/* tr */ {IDGS_USERPORT_4BIT_SAMPLER_TR, ""},  /* fuzzy */
#endif

/* userport/userport_8bss.c */
/* en */ {IDGS_USERPORT_8BSS,    N_("Userport 8bit stereo sampler")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_USERPORT_8BSS_DA, ""},  /* fuzzy */
/* de */ {IDGS_USERPORT_8BSS_DE, "Userport 8bit Stereo Sampler"},
/* es */ {IDGS_USERPORT_8BSS_ES, ""},  /* fuzzy */
/* fr */ {IDGS_USERPORT_8BSS_FR, ""},  /* fuzzy */
/* hu */ {IDGS_USERPORT_8BSS_HU, ""},  /* fuzzy */
/* it */ {IDGS_USERPORT_8BSS_IT, ""},  /* fuzzy */
/* ko */ {IDGS_USERPORT_8BSS_KO, ""},  /* fuzzy */
/* nl */ {IDGS_USERPORT_8BSS_NL, "Userport 8bit stereo sampler"},
/* pl */ {IDGS_USERPORT_8BSS_PL, ""},  /* fuzzy */
/* ru */ {IDGS_USERPORT_8BSS_RU, ""},  /* fuzzy */
/* sv */ {IDGS_USERPORT_8BSS_SV, ""},  /* fuzzy */
/* tr */ {IDGS_USERPORT_8BSS_TR, ""},  /* fuzzy */
#endif

/* printerdrv/interface_userport.c */
/* en */ {IDGS_USERPORT_PRINTER,    N_("Userport printer")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_USERPORT_PRINTER_DA, ""},  /* fuzzy */
/* de */ {IDGS_USERPORT_PRINTER_DE, "Userport Drucker"},
/* es */ {IDGS_USERPORT_PRINTER_ES, ""},  /* fuzzy */
/* fr */ {IDGS_USERPORT_PRINTER_FR, ""},  /* fuzzy */
/* hu */ {IDGS_USERPORT_PRINTER_HU, ""},  /* fuzzy */
/* it */ {IDGS_USERPORT_PRINTER_IT, ""},  /* fuzzy */
/* ko */ {IDGS_USERPORT_PRINTER_KO, ""},  /* fuzzy */
/* nl */ {IDGS_USERPORT_PRINTER_NL, "Userport printer"},
/* pl */ {IDGS_USERPORT_PRINTER_PL, ""},  /* fuzzy */
/* ru */ {IDGS_USERPORT_PRINTER_RU, ""},  /* fuzzy */
/* sv */ {IDGS_USERPORT_PRINTER_SV, ""},  /* fuzzy */
/* tr */ {IDGS_USERPORT_PRINTER_TR, ""},  /* fuzzy */
#endif

/* datasette.c */
/* en */ {IDGS_DATASETTE,    N_("Datasette")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_DATASETTE_DA, ""},  /* fuzzy */
/* de */ {IDGS_DATASETTE_DE, "Datasette"},
/* es */ {IDGS_DATASETTE_ES, ""},  /* fuzzy */
/* fr */ {IDGS_DATASETTE_FR, ""},  /* fuzzy */
/* hu */ {IDGS_DATASETTE_HU, ""},  /* fuzzy */
/* it */ {IDGS_DATASETTE_IT, ""},  /* fuzzy */
/* ko */ {IDGS_DATASETTE_KO, ""},  /* fuzzy */
/* nl */ {IDGS_DATASETTE_NL, "Datasette"},
/* pl */ {IDGS_DATASETTE_PL, ""},  /* fuzzy */
/* ru */ {IDGS_DATASETTE_RU, ""},  /* fuzzy */
/* sv */ {IDGS_DATASETTE_SV, ""},  /* fuzzy */
/* tr */ {IDGS_DATASETTE_TR, ""},  /* fuzzy */
#endif

/* tapeport/tapelog.c */
/* en */ {IDGS_TAPE_LOG,    N_("Tape Log")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_TAPE_LOG_DA, ""},  /* fuzzy */
/* de */ {IDGS_TAPE_LOG_DE, "Bandlog"},
/* es */ {IDGS_TAPE_LOG_ES, ""},  /* fuzzy */
/* fr */ {IDGS_TAPE_LOG_FR, ""},  /* fuzzy */
/* hu */ {IDGS_TAPE_LOG_HU, ""},  /* fuzzy */
/* it */ {IDGS_TAPE_LOG_IT, ""},  /* fuzzy */
/* ko */ {IDGS_TAPE_LOG_KO, ""},  /* fuzzy */
/* nl */ {IDGS_TAPE_LOG_NL, "Tape Log"},
/* pl */ {IDGS_TAPE_LOG_PL, ""},  /* fuzzy */
/* ru */ {IDGS_TAPE_LOG_RU, ""},  /* fuzzy */
/* sv */ {IDGS_TAPE_LOG_SV, ""},  /* fuzzy */
/* tr */ {IDGS_TAPE_LOG_TR, ""},  /* fuzzy */
#endif

/* tapeport/tape_diag_586220_harness.c */
/* en */ {IDGS_TAPE_DIAG_586220_HARNESS,    N_("Tape 586220 diagnostics harness module")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_TAPE_DIAG_586220_HARNESS_DA, ""},  /* fuzzy */
/* de */ {IDGS_TAPE_DIAG_586220_HARNESS_DE, "Tape 586220 Diagnose Harness Modul"},
/* es */ {IDGS_TAPE_DIAG_586220_HARNESS_ES, ""},  /* fuzzy */
/* fr */ {IDGS_TAPE_DIAG_586220_HARNESS_FR, ""},  /* fuzzy */
/* hu */ {IDGS_TAPE_DIAG_586220_HARNESS_HU, ""},  /* fuzzy */
/* it */ {IDGS_TAPE_DIAG_586220_HARNESS_IT, ""},  /* fuzzy */
/* ko */ {IDGS_TAPE_DIAG_586220_HARNESS_KO, ""},  /* fuzzy */
/* nl */ {IDGS_TAPE_DIAG_586220_HARNESS_NL, "Tape 586220 diagnostics gareel module"},
/* pl */ {IDGS_TAPE_DIAG_586220_HARNESS_PL, ""},  /* fuzzy */
/* ru */ {IDGS_TAPE_DIAG_586220_HARNESS_RU, ""},  /* fuzzy */
/* sv */ {IDGS_TAPE_DIAG_586220_HARNESS_SV, ""},  /* fuzzy */
/* tr */ {IDGS_TAPE_DIAG_586220_HARNESS_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_EOF_WRITING_MODULE_S_SNAPSHOT_S,    N_("EOF while writing to module %s in snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_EOF_WRITING_MODULE_S_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_EOF_WRITING_MODULE_S_SNAPSHOT_S_DE, "EOF beim Schreben von Modul %s in Snapshot %s"},
/* es */ {IDGS_EOF_WRITING_MODULE_S_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_EOF_WRITING_MODULE_S_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_EOF_WRITING_MODULE_S_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_EOF_WRITING_MODULE_S_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_EOF_WRITING_MODULE_S_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_EOF_WRITING_MODULE_S_SNAPSHOT_S_NL, "EOF tijdens het schrijven naar module %s in momentopnamebestand %s"},
/* pl */ {IDGS_EOF_WRITING_MODULE_S_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_EOF_WRITING_MODULE_S_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_EOF_WRITING_MODULE_S_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_EOF_WRITING_MODULE_S_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_EOF_WRITING_SNAPSHOT_S,    N_("EOF while writing to snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_EOF_WRITING_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_EOF_WRITING_SNAPSHOT_S_DE, "EOF beim Schreiben auf Snapshot %s"},
/* es */ {IDGS_EOF_WRITING_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_EOF_WRITING_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_EOF_WRITING_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_EOF_WRITING_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_EOF_WRITING_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_EOF_WRITING_SNAPSHOT_S_NL, "EOF tijdens het schrijven naar momentopnamebestand %s"},
/* pl */ {IDGS_EOF_WRITING_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_EOF_WRITING_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_EOF_WRITING_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_EOF_WRITING_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_ERROR_WRITING_ARRAY_MODULE_S_SNAPSHOT_S,    N_("Error writing array to module %s in snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ERROR_WRITING_ARRAY_MODULE_S_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_ERROR_WRITING_ARRAY_MODULE_S_SNAPSHOT_S_DE, "Fehler beim Schreiben (Array) auf Modul %s in Snapshot %s"},
/* es */ {IDGS_ERROR_WRITING_ARRAY_MODULE_S_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_ERROR_WRITING_ARRAY_MODULE_S_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_ERROR_WRITING_ARRAY_MODULE_S_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_ERROR_WRITING_ARRAY_MODULE_S_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_ERROR_WRITING_ARRAY_MODULE_S_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ERROR_WRITING_ARRAY_MODULE_S_SNAPSHOT_S_NL, "Fout bij het schrijven van een blok naar module %s in momentopnamebestand %s"},
/* pl */ {IDGS_ERROR_WRITING_ARRAY_MODULE_S_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_ERROR_WRITING_ARRAY_MODULE_S_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_ERROR_WRITING_ARRAY_MODULE_S_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_ERROR_WRITING_ARRAY_MODULE_S_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_ERROR_WRITING_ARRAY_SNAPSHOT_S,    N_("Error writing array to snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ERROR_WRITING_ARRAY_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_ERROR_WRITING_ARRAY_SNAPSHOT_S_DE, "Fehler bei Schreiben (Array) auf Snapshot %s"},
/* es */ {IDGS_ERROR_WRITING_ARRAY_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_ERROR_WRITING_ARRAY_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_ERROR_WRITING_ARRAY_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_ERROR_WRITING_ARRAY_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_ERROR_WRITING_ARRAY_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ERROR_WRITING_ARRAY_SNAPSHOT_S_NL, "Fout bij het schrijven van een block naar momentopnamebestand %s"},
/* pl */ {IDGS_ERROR_WRITING_ARRAY_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_ERROR_WRITING_ARRAY_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_ERROR_WRITING_ARRAY_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_ERROR_WRITING_ARRAY_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_EOF_READING_MODULE_S_SNAPSHOT_S,    N_("EOF while reading from module %s in snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_EOF_READING_MODULE_S_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_EOF_READING_MODULE_S_SNAPSHOT_S_DE, "EOF beim Lesen von Modul %s in Snapshot %s"},
/* es */ {IDGS_EOF_READING_MODULE_S_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_EOF_READING_MODULE_S_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_EOF_READING_MODULE_S_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_EOF_READING_MODULE_S_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_EOF_READING_MODULE_S_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_EOF_READING_MODULE_S_SNAPSHOT_S_NL, "EOF tijdens het lezen van module %s in momentopnamebestand %s"},
/* pl */ {IDGS_EOF_READING_MODULE_S_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_EOF_READING_MODULE_S_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_EOF_READING_MODULE_S_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_EOF_READING_MODULE_S_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_EOF_READING_SNAPSHOT_S,    N_("EOF while reading from snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_EOF_READING_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_EOF_READING_SNAPSHOT_S_DE, "EOF beim Lesen von Snapshot %s"},
/* es */ {IDGS_EOF_READING_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_EOF_READING_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_EOF_READING_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_EOF_READING_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_EOF_READING_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_EOF_READING_SNAPSHOT_S_NL, "EOF tijdens het lezen van momentopnamebestand %s"},
/* pl */ {IDGS_EOF_READING_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_EOF_READING_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_EOF_READING_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_EOF_READING_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_ERROR_READING_ARRAY_MODULE_S_SNAPSHOT_S,    N_("Error reading array from module %s in snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ERROR_READING_ARRAY_MODULE_S_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_ERROR_READING_ARRAY_MODULE_S_SNAPSHOT_S_DE, "Fehler beim Lesen von Modul %s in Snapshot %s"},
/* es */ {IDGS_ERROR_READING_ARRAY_MODULE_S_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_ERROR_READING_ARRAY_MODULE_S_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_ERROR_READING_ARRAY_MODULE_S_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_ERROR_READING_ARRAY_MODULE_S_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_ERROR_READING_ARRAY_MODULE_S_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ERROR_READING_ARRAY_MODULE_S_SNAPSHOT_S_NL, "Fout bij het lezen van een blok van module %s in momentopnamebestand %s"},
/* pl */ {IDGS_ERROR_READING_ARRAY_MODULE_S_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_ERROR_READING_ARRAY_MODULE_S_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_ERROR_READING_ARRAY_MODULE_S_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_ERROR_READING_ARRAY_MODULE_S_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_ERROR_READING_ARRAY_SNAPSHOT_S,    N_("Error reading array from snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ERROR_READING_ARRAY_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_ERROR_READING_ARRAY_SNAPSHOT_S_DE, "Fehler beim Lesen von Snapshot %s"},
/* es */ {IDGS_ERROR_READING_ARRAY_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_ERROR_READING_ARRAY_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_ERROR_READING_ARRAY_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_ERROR_READING_ARRAY_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_ERROR_READING_ARRAY_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ERROR_READING_ARRAY_SNAPSHOT_S_NL, "Fout bij het lezen van een blok van momentopnamebestand %s"},
/* pl */ {IDGS_ERROR_READING_ARRAY_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_ERROR_READING_ARRAY_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_ERROR_READING_ARRAY_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_ERROR_READING_ARRAY_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_ERROR_WRITING_STRING_MODULE_S_SNAPSHOT_S,    N_("Error writing string to module %s in snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ERROR_WRITING_STRING_MODULE_S_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_ERROR_WRITING_STRING_MODULE_S_SNAPSHOT_S_DE, "Fehler beim Schreiben (String) auf Modul %s in Snapshot %s"},
/* es */ {IDGS_ERROR_WRITING_STRING_MODULE_S_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_ERROR_WRITING_STRING_MODULE_S_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_ERROR_WRITING_STRING_MODULE_S_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_ERROR_WRITING_STRING_MODULE_S_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_ERROR_WRITING_STRING_MODULE_S_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ERROR_WRITING_STRING_MODULE_S_SNAPSHOT_S_NL, "Fout bij het schrijven van tekst naar module %s in momentopnamebestand %s"},
/* pl */ {IDGS_ERROR_WRITING_STRING_MODULE_S_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_ERROR_WRITING_STRING_MODULE_S_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_ERROR_WRITING_STRING_MODULE_S_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_ERROR_WRITING_STRING_MODULE_S_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_ERROR_WRITING_STRING_SNAPSHOT_S,    N_("Error writing string to snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ERROR_WRITING_STRING_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_ERROR_WRITING_STRING_SNAPSHOT_S_DE, "Fehler beim Schreiben (String)auf Snapshot %s"},
/* es */ {IDGS_ERROR_WRITING_STRING_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_ERROR_WRITING_STRING_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_ERROR_WRITING_STRING_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_ERROR_WRITING_STRING_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_ERROR_WRITING_STRING_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ERROR_WRITING_STRING_SNAPSHOT_S_NL, "Fout bij het schrijven van tekst naar momentopnamebestand %s"},
/* pl */ {IDGS_ERROR_WRITING_STRING_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_ERROR_WRITING_STRING_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_ERROR_WRITING_STRING_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_ERROR_WRITING_STRING_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_OUT_OF_BOUNDS_READING_MODULE_S_SNAPSHOT_S,    N_("Out of bounds reading error in module %s in snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_OUT_OF_BOUNDS_READING_MODULE_S_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_OUT_OF_BOUNDS_READING_MODULE_S_SNAPSHOT_S_DE, "Lesefehler (Out-of-bounds) in Modul %s in Snapshot %s"},
/* es */ {IDGS_OUT_OF_BOUNDS_READING_MODULE_S_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_OUT_OF_BOUNDS_READING_MODULE_S_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_OUT_OF_BOUNDS_READING_MODULE_S_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_OUT_OF_BOUNDS_READING_MODULE_S_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_OUT_OF_BOUNDS_READING_MODULE_S_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_OUT_OF_BOUNDS_READING_MODULE_S_SNAPSHOT_S_NL, "Buiten de grenzen leesfout in module %s in momentopnamebestand %s"},
/* pl */ {IDGS_OUT_OF_BOUNDS_READING_MODULE_S_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_OUT_OF_BOUNDS_READING_MODULE_S_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_OUT_OF_BOUNDS_READING_MODULE_S_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_OUT_OF_BOUNDS_READING_MODULE_S_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_OUT_OF_BOUNDS_READING_SNAPSHOT_S,    N_("Out of bounds reading error in snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_OUT_OF_BOUNDS_READING_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_OUT_OF_BOUNDS_READING_SNAPSHOT_S_DE, "Lesefehler (Out-of-bounds) in Snapshot %s"},
/* es */ {IDGS_OUT_OF_BOUNDS_READING_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_OUT_OF_BOUNDS_READING_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_OUT_OF_BOUNDS_READING_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_OUT_OF_BOUNDS_READING_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_OUT_OF_BOUNDS_READING_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_OUT_OF_BOUNDS_READING_SNAPSHOT_S_NL, "Buiten de grenzen fout bij het lezen van momentopnamebestand %s"},
/* pl */ {IDGS_OUT_OF_BOUNDS_READING_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_OUT_OF_BOUNDS_READING_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_OUT_OF_BOUNDS_READING_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_OUT_OF_BOUNDS_READING_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_ILLEGAL_OFFSET_CREATE_MODULE_S_SNAPSHOT_S,    N_("Illegal offset while attempting to create module %s in snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ILLEGAL_OFFSET_CREATE_MODULE_S_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_ILLEGAL_OFFSET_CREATE_MODULE_S_SNAPSHOT_S_DE, "Fehler ber Erstellung von Modul %s in Snapshot %s (Illegal offset)"},
/* es */ {IDGS_ILLEGAL_OFFSET_CREATE_MODULE_S_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_ILLEGAL_OFFSET_CREATE_MODULE_S_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_ILLEGAL_OFFSET_CREATE_MODULE_S_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_ILLEGAL_OFFSET_CREATE_MODULE_S_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_ILLEGAL_OFFSET_CREATE_MODULE_S_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ILLEGAL_OFFSET_CREATE_MODULE_S_SNAPSHOT_S_NL, "Fout beginafstand tijdens het maken van module %s in momentopnamebestand %s"},
/* pl */ {IDGS_ILLEGAL_OFFSET_CREATE_MODULE_S_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_ILLEGAL_OFFSET_CREATE_MODULE_S_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_ILLEGAL_OFFSET_CREATE_MODULE_S_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_ILLEGAL_OFFSET_CREATE_MODULE_S_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_CANNOT_FIND_1ST_MODULE_SNAPSHOT_S,    N_("Cannot find first module in snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_FIND_1ST_MODULE_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_CANNOT_FIND_1ST_MODULE_SNAPSHOT_S_DE, "Kann erstes Modul in Snapshot %s nicht finden"},
/* es */ {IDGS_CANNOT_FIND_1ST_MODULE_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CANNOT_FIND_1ST_MODULE_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CANNOT_FIND_1ST_MODULE_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_CANNOT_FIND_1ST_MODULE_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CANNOT_FIND_1ST_MODULE_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_FIND_1ST_MODULE_SNAPSHOT_S_NL, "Kan de eerste module in momentopnamebestand %s niet vinden"},
/* pl */ {IDGS_CANNOT_FIND_1ST_MODULE_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CANNOT_FIND_1ST_MODULE_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CANNOT_FIND_1ST_MODULE_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CANNOT_FIND_1ST_MODULE_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_ERROR_MODULE_HEADER_SNAPSHOT_S,    N_("Error while reading module header in snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ERROR_MODULE_HEADER_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_ERROR_MODULE_HEADER_SNAPSHOT_S_DE, "Fehler beim Lesen des Modulheaders in Snapshot %s"},
/* es */ {IDGS_ERROR_MODULE_HEADER_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_ERROR_MODULE_HEADER_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_ERROR_MODULE_HEADER_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_ERROR_MODULE_HEADER_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_ERROR_MODULE_HEADER_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ERROR_MODULE_HEADER_SNAPSHOT_S_NL, "Fout bij het lezen van het begin van een module in momentopnamebestand %s"},
/* pl */ {IDGS_ERROR_MODULE_HEADER_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_ERROR_MODULE_HEADER_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_ERROR_MODULE_HEADER_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_ERROR_MODULE_HEADER_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_CANNOT_FIND_MODULE_S_SNAPSHOT_S,    N_("Cannot find module %s in snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_FIND_MODULE_S_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_CANNOT_FIND_MODULE_S_SNAPSHOT_S_DE, "Kann Modul %s in Snapshot %s nicht finden"},
/* es */ {IDGS_CANNOT_FIND_MODULE_S_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CANNOT_FIND_MODULE_S_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CANNOT_FIND_MODULE_S_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_CANNOT_FIND_MODULE_S_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CANNOT_FIND_MODULE_S_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_FIND_MODULE_S_SNAPSHOT_S_NL, "Kan de module %s niet vinden in momentopnamebestand %s"},
/* pl */ {IDGS_CANNOT_FIND_MODULE_S_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CANNOT_FIND_MODULE_S_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CANNOT_FIND_MODULE_S_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CANNOT_FIND_MODULE_S_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_ERROR_CLOSING_MODULE_S_SNAPSHOT_S,    N_("Error closing module %s in snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ERROR_CLOSING_MODULE_S_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_ERROR_CLOSING_MODULE_S_SNAPSHOT_S_DE, "Fehler beim Schliessen von Modul %s in Snapshot %s"},
/* es */ {IDGS_ERROR_CLOSING_MODULE_S_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_ERROR_CLOSING_MODULE_S_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_ERROR_CLOSING_MODULE_S_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_ERROR_CLOSING_MODULE_S_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_ERROR_CLOSING_MODULE_S_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ERROR_CLOSING_MODULE_S_SNAPSHOT_S_NL, "Fout bij het sluiten van module %s in momentopnamebestand %s"},
/* pl */ {IDGS_ERROR_CLOSING_MODULE_S_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_ERROR_CLOSING_MODULE_S_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_ERROR_CLOSING_MODULE_S_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_ERROR_CLOSING_MODULE_S_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_ERROR_SKIPPING_MODULE_SNAPSHOT_S,    N_("Error skipping module in snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_ERROR_SKIPPING_MODULE_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_ERROR_SKIPPING_MODULE_SNAPSHOT_S_DE, "Fehler beim berspringen eines Moduls in Snapshot %s"},
/* es */ {IDGS_ERROR_SKIPPING_MODULE_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_ERROR_SKIPPING_MODULE_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_ERROR_SKIPPING_MODULE_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_ERROR_SKIPPING_MODULE_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_ERROR_SKIPPING_MODULE_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_ERROR_SKIPPING_MODULE_SNAPSHOT_S_NL, "Fout bij het overslaan van module in momentopnamebestand %s"},
/* pl */ {IDGS_ERROR_SKIPPING_MODULE_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_ERROR_SKIPPING_MODULE_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_ERROR_SKIPPING_MODULE_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_ERROR_SKIPPING_MODULE_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_CANNOT_CREATE_SNAPSHOT_S,    N_("Cannot create snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_DE, "Kann Snapshot %s nicht erzeugen"},
/* es */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_NL, "Kan momentopnamebestand %s niet maken"},
/* pl */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_CANNOT_WRITE_MAGIC_STRING_SNAPSHOT_S,    N_("Cannot write magic string to snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_WRITE_MAGIC_STRING_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_CANNOT_WRITE_MAGIC_STRING_SNAPSHOT_S_DE, "Kann Magic String in Snapshot %s nicht schreiben"},
/* es */ {IDGS_CANNOT_WRITE_MAGIC_STRING_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CANNOT_WRITE_MAGIC_STRING_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CANNOT_WRITE_MAGIC_STRING_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_CANNOT_WRITE_MAGIC_STRING_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CANNOT_WRITE_MAGIC_STRING_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_WRITE_MAGIC_STRING_SNAPSHOT_S_NL, "Kan de magische tekenreeks niet schrijven naar momentopnamebestand %s"},
/* pl */ {IDGS_CANNOT_WRITE_MAGIC_STRING_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CANNOT_WRITE_MAGIC_STRING_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CANNOT_WRITE_MAGIC_STRING_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CANNOT_WRITE_MAGIC_STRING_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_CANNOT_WRITE_VERSION_SNAPSHOT_S,    N_("Cannot write version to snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_WRITE_VERSION_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_CANNOT_WRITE_VERSION_SNAPSHOT_S_DE, "Kann Version in Snapshot %s nicht schreiben"},
/* es */ {IDGS_CANNOT_WRITE_VERSION_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CANNOT_WRITE_VERSION_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CANNOT_WRITE_VERSION_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_CANNOT_WRITE_VERSION_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CANNOT_WRITE_VERSION_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_WRITE_VERSION_SNAPSHOT_S_NL, "Kan de versie niet schrijven naar momentopnamebestand %s"},
/* pl */ {IDGS_CANNOT_WRITE_VERSION_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CANNOT_WRITE_VERSION_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CANNOT_WRITE_VERSION_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CANNOT_WRITE_VERSION_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_CANNOT_WRITE_MACHINE_NAME_SNAPSHOT_S,    N_("Cannot write machine name to snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_WRITE_MACHINE_NAME_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_CANNOT_WRITE_MACHINE_NAME_SNAPSHOT_S_DE, "Kann Maschinennamen in Snapshot %s nicht schreiben"},
/* es */ {IDGS_CANNOT_WRITE_MACHINE_NAME_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CANNOT_WRITE_MACHINE_NAME_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CANNOT_WRITE_MACHINE_NAME_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_CANNOT_WRITE_MACHINE_NAME_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CANNOT_WRITE_MACHINE_NAME_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_WRITE_MACHINE_NAME_SNAPSHOT_S_NL, "Kan de machine naam niet schrijven naar momentopnamebestand %s"},
/* pl */ {IDGS_CANNOT_WRITE_MACHINE_NAME_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CANNOT_WRITE_MACHINE_NAME_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CANNOT_WRITE_MACHINE_NAME_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CANNOT_WRITE_MACHINE_NAME_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_CANNOT_OPEN_SNAPSHOT_S_READING,    N_("Cannot open snapshot %s for reading")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_OPEN_SNAPSHOT_S_READING_DA, ""},  /* fuzzy */
/* de */ {IDGS_CANNOT_OPEN_SNAPSHOT_S_READING_DE, "Kann Snapshot %s nicht ffnen"},
/* es */ {IDGS_CANNOT_OPEN_SNAPSHOT_S_READING_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CANNOT_OPEN_SNAPSHOT_S_READING_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CANNOT_OPEN_SNAPSHOT_S_READING_HU, ""},  /* fuzzy */
/* it */ {IDGS_CANNOT_OPEN_SNAPSHOT_S_READING_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CANNOT_OPEN_SNAPSHOT_S_READING_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_OPEN_SNAPSHOT_S_READING_NL, "Kan het momentopnamebestand %s niet openen voor lezen"},
/* pl */ {IDGS_CANNOT_OPEN_SNAPSHOT_S_READING_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CANNOT_OPEN_SNAPSHOT_S_READING_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CANNOT_OPEN_SNAPSHOT_S_READING_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CANNOT_OPEN_SNAPSHOT_S_READING_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_MAGIC_STRING_MISMATCH_SNAPSHOT_S,    N_("Magic string mismatch in snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_MAGIC_STRING_MISMATCH_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_MAGIC_STRING_MISMATCH_SNAPSHOT_S_DE, "Magic String Fehler in Snapshot %s"},
/* es */ {IDGS_MAGIC_STRING_MISMATCH_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_MAGIC_STRING_MISMATCH_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_MAGIC_STRING_MISMATCH_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_MAGIC_STRING_MISMATCH_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_MAGIC_STRING_MISMATCH_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_MAGIC_STRING_MISMATCH_SNAPSHOT_S_NL, "Magische tekenreeks is niet wat is verwacht in momentopnamebestand %s"},
/* pl */ {IDGS_MAGIC_STRING_MISMATCH_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_MAGIC_STRING_MISMATCH_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_MAGIC_STRING_MISMATCH_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_MAGIC_STRING_MISMATCH_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_CANNOT_READ_VERSION_SNAPSHOT_S,    N_("Cannot read version from snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_READ_VERSION_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_CANNOT_READ_VERSION_SNAPSHOT_S_DE, "Kann Versionsnummer von Snapshot %s nicht lesen"},
/* es */ {IDGS_CANNOT_READ_VERSION_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CANNOT_READ_VERSION_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CANNOT_READ_VERSION_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_CANNOT_READ_VERSION_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CANNOT_READ_VERSION_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_READ_VERSION_SNAPSHOT_S_NL, "Kan de versie niet lezen van momentopnamebestand %s"},
/* pl */ {IDGS_CANNOT_READ_VERSION_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CANNOT_READ_VERSION_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CANNOT_READ_VERSION_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CANNOT_READ_VERSION_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_CANNOT_READ_MACHINE_NAME_SNAPSHOT_S,    N_("Cannot read machine name from snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CANNOT_READ_MACHINE_NAME_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_CANNOT_READ_MACHINE_NAME_SNAPSHOT_S_DE, "Kann Maschinenname von Snapshot %s nicht lesen"},
/* es */ {IDGS_CANNOT_READ_MACHINE_NAME_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CANNOT_READ_MACHINE_NAME_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CANNOT_READ_MACHINE_NAME_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_CANNOT_READ_MACHINE_NAME_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CANNOT_READ_MACHINE_NAME_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CANNOT_READ_MACHINE_NAME_SNAPSHOT_S_NL, "Kan de machine naam niet lezen van momentopnamebestand %s"},
/* pl */ {IDGS_CANNOT_READ_MACHINE_NAME_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CANNOT_READ_MACHINE_NAME_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CANNOT_READ_MACHINE_NAME_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CANNOT_READ_MACHINE_NAME_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_WRONG_MACHINE_TYPE_SNAPSHOT_S,    N_("Wrong machine type in snapshot %s, snapshot type: %s, current machine: %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_WRONG_MACHINE_TYPE_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_WRONG_MACHINE_TYPE_SNAPSHOT_S_DE, "Falscher Maschinentyp in Snapshot %s, Typ: %s, aktuelle Maschine: %s"},
/* es */ {IDGS_WRONG_MACHINE_TYPE_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_WRONG_MACHINE_TYPE_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_WRONG_MACHINE_TYPE_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_WRONG_MACHINE_TYPE_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_WRONG_MACHINE_TYPE_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_WRONG_MACHINE_TYPE_SNAPSHOT_S_NL, "Verkeerd machine soort in momentopnamebestand %s, soort in bestand: %s, huidige soort: %s"},
/* pl */ {IDGS_WRONG_MACHINE_TYPE_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_WRONG_MACHINE_TYPE_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_WRONG_MACHINE_TYPE_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_WRONG_MACHINE_TYPE_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_EOF_CLOSING_SNAPSHOT_S,    N_("EOF while closing snapshot %s")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_EOF_CLOSING_SNAPSHOT_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_EOF_CLOSING_SNAPSHOT_S_DE, "EOF beim Schliessen von Snapshot %s"},
/* es */ {IDGS_EOF_CLOSING_SNAPSHOT_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_EOF_CLOSING_SNAPSHOT_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_EOF_CLOSING_SNAPSHOT_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_EOF_CLOSING_SNAPSHOT_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_EOF_CLOSING_SNAPSHOT_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_EOF_CLOSING_SNAPSHOT_S_NL, "EOF tijdens het afsluiten van momentopnamebestand %s"},
/* pl */ {IDGS_EOF_CLOSING_SNAPSHOT_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_EOF_CLOSING_SNAPSHOT_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_EOF_CLOSING_SNAPSHOT_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_EOF_CLOSING_SNAPSHOT_S_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_SNAPSHOT_HIGHER_VERSION,    N_("Snapshot %s has a higher version than what your current emulator supports, please upgrade VICE")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SNAPSHOT_HIGHER_VERSION_DA, ""},  /* fuzzy */
/* de */ {IDGS_SNAPSHOT_HIGHER_VERSION_DE, "Snapshot %s bentigt einen neuere Version von Vice. Bitte Upgraden!"},
/* es */ {IDGS_SNAPSHOT_HIGHER_VERSION_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SNAPSHOT_HIGHER_VERSION_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SNAPSHOT_HIGHER_VERSION_HU, ""},  /* fuzzy */
/* it */ {IDGS_SNAPSHOT_HIGHER_VERSION_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SNAPSHOT_HIGHER_VERSION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SNAPSHOT_HIGHER_VERSION_NL, "Momentopnamebestand %s heeft een hogere versie dan wat de huidige emulator ondersteunt, download een recente versie van VICE"},
/* pl */ {IDGS_SNAPSHOT_HIGHER_VERSION_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SNAPSHOT_HIGHER_VERSION_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SNAPSHOT_HIGHER_VERSION_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SNAPSHOT_HIGHER_VERSION_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_INCOMPATIBLE_SNAPSHOT,    N_("Snapshot %s is incompatible (too old)")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_INCOMPATIBLE_SNAPSHOT_DA, ""},  /* fuzzy */
/* de */ {IDGS_INCOMPATIBLE_SNAPSHOT_DE, "Snapshot %s ist nicht kompatibel (zu alt)"},
/* es */ {IDGS_INCOMPATIBLE_SNAPSHOT_ES, ""},  /* fuzzy */
/* fr */ {IDGS_INCOMPATIBLE_SNAPSHOT_FR, ""},  /* fuzzy */
/* hu */ {IDGS_INCOMPATIBLE_SNAPSHOT_HU, ""},  /* fuzzy */
/* it */ {IDGS_INCOMPATIBLE_SNAPSHOT_IT, ""},  /* fuzzy */
/* ko */ {IDGS_INCOMPATIBLE_SNAPSHOT_KO, ""},  /* fuzzy */
/* nl */ {IDGS_INCOMPATIBLE_SNAPSHOT_NL, "Momentopname %s is niet compatibel (te oud)"},
/* pl */ {IDGS_INCOMPATIBLE_SNAPSHOT_PL, ""},  /* fuzzy */
/* ru */ {IDGS_INCOMPATIBLE_SNAPSHOT_RU, ""},  /* fuzzy */
/* sv */ {IDGS_INCOMPATIBLE_SNAPSHOT_SV, ""},  /* fuzzy */
/* tr */ {IDGS_INCOMPATIBLE_SNAPSHOT_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_SNAPSHOT_VICE_VERSION,    N_("Snapshot was created by VICE Version %d.%d.%d")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SNAPSHOT_VICE_VERSION_DA, ""},  /* fuzzy */
/* de */ {IDGS_SNAPSHOT_VICE_VERSION_DE, "Snapshot wurde von VICE Version %d.%d.%d erzeugt"},
/* es */ {IDGS_SNAPSHOT_VICE_VERSION_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SNAPSHOT_VICE_VERSION_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SNAPSHOT_VICE_VERSION_HU, ""},  /* fuzzy */
/* it */ {IDGS_SNAPSHOT_VICE_VERSION_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SNAPSHOT_VICE_VERSION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SNAPSHOT_VICE_VERSION_NL, "Momentopname was gemaakt met VICE Versie %d.%d.%d"},
/* pl */ {IDGS_SNAPSHOT_VICE_VERSION_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SNAPSHOT_VICE_VERSION_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SNAPSHOT_VICE_VERSION_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SNAPSHOT_VICE_VERSION_TR, ""},  /* fuzzy */
#endif

/* snapshot.c */
/* en */ {IDGS_SNAPSHOT_OLD_VICE_VERSION,    N_("Snapshot was created by VICE Version 2.4.30 or older")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_SNAPSHOT_OLD_VICE_VERSION_DA, ""},  /* fuzzy */
/* de */ {IDGS_SNAPSHOT_OLD_VICE_VERSION_DE, "Snapshot wurde von VICE Version 2.4.30 oder lter erzeugt"},
/* es */ {IDGS_SNAPSHOT_OLD_VICE_VERSION_ES, ""},  /* fuzzy */
/* fr */ {IDGS_SNAPSHOT_OLD_VICE_VERSION_FR, ""},  /* fuzzy */
/* hu */ {IDGS_SNAPSHOT_OLD_VICE_VERSION_HU, ""},  /* fuzzy */
/* it */ {IDGS_SNAPSHOT_OLD_VICE_VERSION_IT, ""},  /* fuzzy */
/* ko */ {IDGS_SNAPSHOT_OLD_VICE_VERSION_KO, ""},  /* fuzzy */
/* nl */ {IDGS_SNAPSHOT_OLD_VICE_VERSION_NL, "Momentopname was gemaakt met VICE Versie 2.4.30 of ouder"},
/* pl */ {IDGS_SNAPSHOT_OLD_VICE_VERSION_PL, ""},  /* fuzzy */
/* ru */ {IDGS_SNAPSHOT_OLD_VICE_VERSION_RU, ""},  /* fuzzy */
/* sv */ {IDGS_SNAPSHOT_OLD_VICE_VERSION_SV, ""},  /* fuzzy */
/* tr */ {IDGS_SNAPSHOT_OLD_VICE_VERSION_TR, ""},  /* fuzzy */
#endif

/* c64/cart/clockport-rrnet.c */
/* en */ {IDGS_CLOCKPORT_RRNET_IN_USE_BY_S,    N_("ClockPort RRNET already in use by %s.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CLOCKPORT_RRNET_IN_USE_BY_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_CLOCKPORT_RRNET_IN_USE_BY_S_DE, "Clockport RRNET bereits von %s benutzt."},
/* es */ {IDGS_CLOCKPORT_RRNET_IN_USE_BY_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CLOCKPORT_RRNET_IN_USE_BY_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CLOCKPORT_RRNET_IN_USE_BY_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_CLOCKPORT_RRNET_IN_USE_BY_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CLOCKPORT_RRNET_IN_USE_BY_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CLOCKPORT_RRNET_IN_USE_BY_S_NL, "ClockPort RRNET wordt al gebruikt door %s."},
/* pl */ {IDGS_CLOCKPORT_RRNET_IN_USE_BY_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CLOCKPORT_RRNET_IN_USE_BY_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CLOCKPORT_RRNET_IN_USE_BY_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CLOCKPORT_RRNET_IN_USE_BY_S_TR, ""},  /* fuzzy */
#endif

/* c64/cart/clockport-mp3at64.c */
/* en */ {IDGS_CLOCKPORT_MP3AT64_IN_USE_BY_S,    N_("ClockPort MP3@64 already in use by %s.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CLOCKPORT_MP3AT64_IN_USE_BY_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_CLOCKPORT_MP3AT64_IN_USE_BY_S_DE, "Clockport MP3@64 bereits von %s benutzt."},
/* es */ {IDGS_CLOCKPORT_MP3AT64_IN_USE_BY_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CLOCKPORT_MP3AT64_IN_USE_BY_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CLOCKPORT_MP3AT64_IN_USE_BY_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_CLOCKPORT_MP3AT64_IN_USE_BY_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CLOCKPORT_MP3AT64_IN_USE_BY_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CLOCKPORT_MP3AT64_IN_USE_BY_S_NL, "ClockPort MP3@64 wordt al gebruikt door %s."},
/* pl */ {IDGS_CLOCKPORT_MP3AT64_IN_USE_BY_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CLOCKPORT_MP3AT64_IN_USE_BY_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CLOCKPORT_MP3AT64_IN_USE_BY_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CLOCKPORT_MP3AT64_IN_USE_BY_S_TR, ""},  /* fuzzy */
#endif

/* c64/cart/cs8900io.c */
/* en */ {IDGS_CS8900_IN_USE_BY_S,    N_("CS8900 already in use by %s.")},
#ifdef HAS_TRANSLATION
/* da */ {IDGS_CS8900_IN_USE_BY_S_DA, ""},  /* fuzzy */
/* de */ {IDGS_CS8900_IN_USE_BY_S_DE, "CS8900 bereits von %s benutzt."},
/* es */ {IDGS_CS8900_IN_USE_BY_S_ES, ""},  /* fuzzy */
/* fr */ {IDGS_CS8900_IN_USE_BY_S_FR, ""},  /* fuzzy */
/* hu */ {IDGS_CS8900_IN_USE_BY_S_HU, ""},  /* fuzzy */
/* it */ {IDGS_CS8900_IN_USE_BY_S_IT, ""},  /* fuzzy */
/* ko */ {IDGS_CS8900_IN_USE_BY_S_KO, ""},  /* fuzzy */
/* nl */ {IDGS_CS8900_IN_USE_BY_S_NL, "CS8900 wordt al gebruikt door %s."},
/* pl */ {IDGS_CS8900_IN_USE_BY_S_PL, ""},  /* fuzzy */
/* ru */ {IDGS_CS8900_IN_USE_BY_S_RU, ""},  /* fuzzy */
/* sv */ {IDGS_CS8900_IN_USE_BY_S_SV, ""},  /* fuzzy */
/* tr */ {IDGS_CS8900_IN_USE_BY_S_TR, ""},  /* fuzzy */
#endif

/* ------------------------ COMMAND LINE OPTION STRINGS -------------------- */

/* joystick.c */
/* en */ {IDCLS_ENABLE_JOY_OPPOSITE,    N_("Enable opposite joystick directions")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_JOY_OPPOSITE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_JOY_OPPOSITE_DE, "Gegenberliegende Joystick Richtungen zulassen"},
/* es */ {IDCLS_ENABLE_JOY_OPPOSITE_ES, "Permitir direcciones opuestas del joystick"},
/* fr */ {IDCLS_ENABLE_JOY_OPPOSITE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_JOY_OPPOSITE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_JOY_OPPOSITE_IT, "Attiva direzioni opposte joystick"},
/* ko */ {IDCLS_ENABLE_JOY_OPPOSITE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_JOY_OPPOSITE_NL, "Tegenovergestelde richtingen toestaan"},
/* pl */ {IDCLS_ENABLE_JOY_OPPOSITE_PL, "Pozwl na przeciwstawne kierunki joysticka"},
/* ru */ {IDCLS_ENABLE_JOY_OPPOSITE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_JOY_OPPOSITE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_JOY_OPPOSITE_TR, ""},  /* fuzzy */
#endif

/* joystick.c */
/* en */ {IDCLS_DISABLE_JOY_OPPOSITE,    N_("Disable opposite joystick directions")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_JOY_OPPOSITE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_JOY_OPPOSITE_DE, "Gegenberliegende Joystick Richtungen verhindern"},
/* es */ {IDCLS_DISABLE_JOY_OPPOSITE_ES, "Inhabilitar direcciones opuestas del joystick"},
/* fr */ {IDCLS_DISABLE_JOY_OPPOSITE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_JOY_OPPOSITE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_JOY_OPPOSITE_IT, "Disattiva direzioni opposte joystick"},
/* ko */ {IDCLS_DISABLE_JOY_OPPOSITE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_JOY_OPPOSITE_NL, "Tegenovergestelde richtingen niet toestaan"},
/* pl */ {IDCLS_DISABLE_JOY_OPPOSITE_PL, "Nie pozwl na przeciwstawne kierunki joysticka"},
/* ru */ {IDCLS_DISABLE_JOY_OPPOSITE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_JOY_OPPOSITE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_JOY_OPPOSITE_TR, ""},  /* fuzzy */
#endif

/* joystick.c */
/* en */ {IDCLS_ENABLE_KEYSET,    N_("Enable keyset")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_KEYSET_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_KEYSET_DE, "Tastaturbelegung aktivieren"},
/* es */ {IDCLS_ENABLE_KEYSET_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_KEYSET_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_KEYSET_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_KEYSET_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_KEYSET_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_KEYSET_NL, "Keyset inschakelen"},
/* pl */ {IDCLS_ENABLE_KEYSET_PL, "Wcz zestaw klawiszy"},
/* ru */ {IDCLS_ENABLE_KEYSET_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_KEYSET_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_KEYSET_TR, ""},  /* fuzzy */
#endif

/* joystick.c */
/* en */ {IDCLS_DISABLE_KEYSET,    N_("Disable keyset")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_KEYSET_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_KEYSET_DE, "Tastaturbelegung deaktivieren"},
/* es */ {IDCLS_DISABLE_KEYSET_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_KEYSET_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_KEYSET_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_KEYSET_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_KEYSET_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_KEYSET_NL, "Keyset uitschakelen"},
/* pl */ {IDCLS_DISABLE_KEYSET_PL, "Wycz zestaw klawiszy"},
/* ru */ {IDCLS_DISABLE_KEYSET_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_KEYSET_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_KEYSET_TR, ""},  /* fuzzy */
#endif

/* autostart.c */
/* en */ {IDCLS_AUTOSTART_LOAD_TO_BASIC_START,    N_("On autostart, load to BASIC start (without ',1')")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_AUTOSTART_LOAD_TO_BASIC_START_DA, "Indls til BASIC start ved autostart (uden ',1')"},
/* de */ {IDCLS_AUTOSTART_LOAD_TO_BASIC_START_DE, "Bei Autostart, lade an BASIC Start (ohne ',1')"},
/* es */ {IDCLS_AUTOSTART_LOAD_TO_BASIC_START_ES, "En autoarranque, carga en inicio del BASIC (sin ',1')"},
/* fr */ {IDCLS_AUTOSTART_LOAD_TO_BASIC_START_FR, "Lors de l'autodmarrage, charger au BASIC (sans ',1')"},
/* hu */ {IDCLS_AUTOSTART_LOAD_TO_BASIC_START_HU, ""},  /* fuzzy */
/* it */ {IDCLS_AUTOSTART_LOAD_TO_BASIC_START_IT, "All'avvio automatico, carica all'inizio del BASIC (senza ',1')"},
/* ko */ {IDCLS_AUTOSTART_LOAD_TO_BASIC_START_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_AUTOSTART_LOAD_TO_BASIC_START_NL, "Bij autostarten, laad naar BASIC start (zonder ',1')"},
/* pl */ {IDCLS_AUTOSTART_LOAD_TO_BASIC_START_PL, "Przy autostarcie wczytuj do BASIC-a (bez ',1')"},
/* ru */ {IDCLS_AUTOSTART_LOAD_TO_BASIC_START_RU, "On autostart, load to BASIC start (without ',1')"},
/* sv */ {IDCLS_AUTOSTART_LOAD_TO_BASIC_START_SV, "Vid autostart, hmta till BASIC-start (utan \",1\")"},
/* tr */ {IDCLS_AUTOSTART_LOAD_TO_BASIC_START_TR, "Otomatik balatldnda, BASIC balangcna ykle (',1' olmadan)"},
#endif

/* autostart.c */
/* en */ {IDCLS_AUTOSTART_LOAD_WITH_1,    N_("On autostart, load with ',1'")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_AUTOSTART_LOAD_WITH_1_DA, "Indls med ',1' ved autostart"},
/* de */ {IDCLS_AUTOSTART_LOAD_WITH_1_DE, "Bei Autostart, lade mit ',1'"},
/* es */ {IDCLS_AUTOSTART_LOAD_WITH_1_ES, "En autoarranque, carga con ',1'"},
/* fr */ {IDCLS_AUTOSTART_LOAD_WITH_1_FR, " l'autodmarrage, charger avec ',1'"},
/* hu */ {IDCLS_AUTOSTART_LOAD_WITH_1_HU, ""},  /* fuzzy */
/* it */ {IDCLS_AUTOSTART_LOAD_WITH_1_IT, "All'avvio automatico, carica con ',1'"},
/* ko */ {IDCLS_AUTOSTART_LOAD_WITH_1_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_AUTOSTART_LOAD_WITH_1_NL, "Bij autostarten, laad met ',1'"},
/* pl */ {IDCLS_AUTOSTART_LOAD_WITH_1_PL, "Przy autostarcie wczytuj z ',1'"},
/* ru */ {IDCLS_AUTOSTART_LOAD_WITH_1_RU, "On autostart, load with ',1'"},
/* sv */ {IDCLS_AUTOSTART_LOAD_WITH_1_SV, "Vid autostart, hmta med \",1\""},
/* tr */ {IDCLS_AUTOSTART_LOAD_WITH_1_TR, "Otomatik balatldnda, ',1' ile ykle"},
#endif

/* autostart.c */
/* en */ {IDCLS_ENABLE_AUTOSTARTWITHCOLON,    N_("On autostart, use the 'RUN' command with a colon, i.e., 'RUN:'")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_AUTOSTARTWITHCOLON_DA, "Brug \"RUN\"-kommando med kolon ved autostart, dvs. \"RUN:\""},
/* de */ {IDCLS_ENABLE_AUTOSTARTWITHCOLON_DE, "Bei Autostart soll 'RUN' mit Doppelpunkt ausgefhrt werden ('RUN:')"},
/* es */ {IDCLS_ENABLE_AUTOSTARTWITHCOLON_ES, "En autoarranque, usa el comando 'RUN' con dos puntos, ej. 'RUN:'"},
/* fr */ {IDCLS_ENABLE_AUTOSTARTWITHCOLON_FR, " l'autodmarrage, utiliser la commande 'RUN' avec le deux-points (soit 'RUN:')"},
/* hu */ {IDCLS_ENABLE_AUTOSTARTWITHCOLON_HU, "Automatikus indtsnl a 'RUN' parancs kettsponttal, vagyis 'RUN:'"},
/* it */ {IDCLS_ENABLE_AUTOSTARTWITHCOLON_IT, "All'avvio automatico, usa il comando 'RUN' con i due punti; cio 'RUN:'"},
/* ko */ {IDCLS_ENABLE_AUTOSTARTWITHCOLON_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_AUTOSTARTWITHCOLON_NL, "Bij het autostarten, gebruik het 'RUN' commando met een dubbele punt, dus 'RUN:'"},
/* pl */ {IDCLS_ENABLE_AUTOSTARTWITHCOLON_PL, "Przy autostarcie uywaj polecenia 'RUN' z dwukropkiem, tj. 'RUN:'"},
/* ru */ {IDCLS_ENABLE_AUTOSTARTWITHCOLON_RU, "On autostart, use the 'RUN' command with a colon, i.e., 'RUN:'"},
/* sv */ {IDCLS_ENABLE_AUTOSTARTWITHCOLON_SV, "Vid autostart, anvnd \"RUN\"-kommando med kolon, dvs. \"RUN:\""},
/* tr */ {IDCLS_ENABLE_AUTOSTARTWITHCOLON_TR, "Otomatik balatldnda, 'RUN' komutunu ':' ile kullan, yani, 'RUN:'"},
#endif

/* autostart.c */
/* en */ {IDCLS_DISABLE_AUTOSTARTWITHCOLON,    N_("On autostart, do not use the 'RUN' command with a colon; i.e., 'RUN'")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_AUTOSTARTWITHCOLON_DA, "Brug ikke \"RUN\"-kommando med kolon ved autostart, dvs. \"RUN\""},
/* de */ {IDCLS_DISABLE_AUTOSTARTWITHCOLON_DE, "Bei Autostart soll 'RUN' ohne Doppelpunkt ausgefhrt werden ('RUN')"},
/* es */ {IDCLS_DISABLE_AUTOSTARTWITHCOLON_ES, "En autoarranque, no usar el comando 'RUN' con dos puntos, ej.'RUN'"},
/* fr */ {IDCLS_DISABLE_AUTOSTARTWITHCOLON_FR, " l'autodmarrage, NE PAS utiliser le deux-points avec la commande 'RUN'"},
/* hu */ {IDCLS_DISABLE_AUTOSTARTWITHCOLON_HU, "Automatikus indtsnak a 'RUN' parancs kettspont nlkl, vagyis 'RUN'"},
/* it */ {IDCLS_DISABLE_AUTOSTARTWITHCOLON_IT, "All'avvio automatico, non usare il comando 'RUN' con i due punti; cio 'RUN'"},
/* ko */ {IDCLS_DISABLE_AUTOSTARTWITHCOLON_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_AUTOSTARTWITHCOLON_NL, "Bij het autostarten, gebruik het 'RUN' commando niet met een dubbele punt, dus 'RUN'"},
/* pl */ {IDCLS_DISABLE_AUTOSTARTWITHCOLON_PL, "Przy autostarcie uywaj polecenia 'RUN' bez dwukropka, tj. 'RUN'"},
/* ru */ {IDCLS_DISABLE_AUTOSTARTWITHCOLON_RU, "On autostart, do not use the 'RUN' command with a colon; i.e., 'RUN'"},
/* sv */ {IDCLS_DISABLE_AUTOSTARTWITHCOLON_SV, "Vid autostart, anvnd inte \"RUN\"-kommando med kolon, dvs. \"RUN\""},
/* tr */ {IDCLS_DISABLE_AUTOSTARTWITHCOLON_TR, "Otomatik balatldnda, 'RUN' komutunu ':' ile kullanma, yani, 'RUN'"},
#endif

/* autostart.c */
/* en */ {IDCLS_ENABLE_AUTOSTART_HANDLE_TDE,    N_("Handle True Drive Emulation on autostart")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_DA, "Anvend gte drev-emulering ved autostart"},
/* de */ {IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_DE, "Przise Floppy Emulation bei Autostart beachten"},
/* es */ {IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_ES, "Manejar en autoarranque emulacin de disco verdadera"},
/* fr */ {IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_FR, "Activer l'mulation Relle de Lecteur  l'autodmarrage"},
/* hu */ {IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_HU, "Vals lemezegysg emulci kezelse autostartnl"},
/* it */ {IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_IT, "Emulazione hardware dei drive all'avvio automatico"},
/* ko */ {IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_NL, "Hanteer Hardwarematige Drive Emulatie bij autostarten"},
/* pl */ {IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_PL, "Wcz rzeczywist emulacj napdu przy autostarcie"},
/* ru */ {IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_RU, "Handle True Drive Emulation on autostart"},
/* sv */ {IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_SV, "Hantera kta diskettenhetsemulering vid autostart"},
/* tr */ {IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_TR, "Otomatik balatmada Gerek Src Emlasyonu'nu denetle"},
#endif

/* autostart.c */
/* en */ {IDCLS_DISABLE_AUTOSTART_HANDLE_TDE,    N_("Do not handle True Drive Emulation on autostart")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_DA, "Anvend ikke gte drev-emulering ved autostart"},
/* de */ {IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_DE, "Przise Floppy Emulation bei Autostart nicht beachten"},
/* es */ {IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_ES, "No manejar en autoarranque emulacin de disco verdadera"},
/* fr */ {IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_FR, "Ne pas utiliser l'mulation relle de lecteur  l'autodmarrage"},
/* hu */ {IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_HU, "Vals lemezegysg emulcit nem kezeli autostartnl"},
/* it */ {IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_IT, "Non gestire l'emulazione hardware dei drive all'avvio automatico"},
/* ko */ {IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_NL, "Hanteer geen hardwarematige drive emulatie bij autostarten"},
/* pl */ {IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_PL, "Nie wczaj rzeczywistej emulacji napdu przy autostarcie"},
/* ru */ {IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_RU, "Do not handle True Drive Emulation on autostart"},
/* sv */ {IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_SV, "Hantera inte kta diskettenhetsemulering vid autostart"},
/* tr */ {IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_TR, "Balangta Gerek Src Emlasyonu'nu Denetleme"},
#endif

/* autostart.c */
/* en */ {IDCLS_ENABLE_WARP_MODE_AUTOSTART,    N_("Enable warp mode during autostart")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_WARP_MODE_AUTOSTART_DA, "Aktivr warp-tilstand under autostart"},
/* de */ {IDCLS_ENABLE_WARP_MODE_AUTOSTART_DE, "Warp Mode whrend Autostart aktivieren"},
/* es */ {IDCLS_ENABLE_WARP_MODE_AUTOSTART_ES, "Permitir modo ultrarrpido durante autoarranque"},
/* fr */ {IDCLS_ENABLE_WARP_MODE_AUTOSTART_FR, "Activer Mode Turbo durant l'autodmarrage"},
/* hu */ {IDCLS_ENABLE_WARP_MODE_AUTOSTART_HU, "Hipergyors md engedlyezse autostartnl"},
/* it */ {IDCLS_ENABLE_WARP_MODE_AUTOSTART_IT, "Attiva la modalit turbo all'avvio automatico"},
/* ko */ {IDCLS_ENABLE_WARP_MODE_AUTOSTART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_WARP_MODE_AUTOSTART_NL, "Warp modus tijdens autostarten inschakelen"},
/* pl */ {IDCLS_ENABLE_WARP_MODE_AUTOSTART_PL, "Wcz tryb przypieszony podczas automatycznego startu"},
/* ru */ {IDCLS_ENABLE_WARP_MODE_AUTOSTART_RU, "Enable warp mode during autostart"},
/* sv */ {IDCLS_ENABLE_WARP_MODE_AUTOSTART_SV, "Aktivera warplge fr autostart"},
/* tr */ {IDCLS_ENABLE_WARP_MODE_AUTOSTART_TR, "Otomatik balatma esnasnda warp modu aktif et"},
#endif

/* autostart.c */
/* en */ {IDCLS_DISABLE_WARP_MODE_AUTOSTART,    N_("Disable warp mode during autostart")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_WARP_MODE_AUTOSTART_DA, "Deaktivr warp-tilstand under autostart"},
/* de */ {IDCLS_DISABLE_WARP_MODE_AUTOSTART_DE, "Warp Mode whren Autostart deaktivieren"},
/* es */ {IDCLS_DISABLE_WARP_MODE_AUTOSTART_ES, "Deshabilitar modo ultrarrpido durante autoarranque"},
/* fr */ {IDCLS_DISABLE_WARP_MODE_AUTOSTART_FR, "Dsactiver le mode Turbo"},
/* hu */ {IDCLS_DISABLE_WARP_MODE_AUTOSTART_HU, "Hipergyors md tiltsa autostartnl"},
/* it */ {IDCLS_DISABLE_WARP_MODE_AUTOSTART_IT, "Disattiva la modalit turbo all'avvio automatico"},
/* ko */ {IDCLS_DISABLE_WARP_MODE_AUTOSTART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_WARP_MODE_AUTOSTART_NL, "Warp modus tijdens autostarten uitschakelen"},
/* pl */ {IDCLS_DISABLE_WARP_MODE_AUTOSTART_PL, "Wycz tryb przypieszony podczas automatycznego startu"},
/* ru */ {IDCLS_DISABLE_WARP_MODE_AUTOSTART_RU, "Disable warp mode during autostart"},
/* sv */ {IDCLS_DISABLE_WARP_MODE_AUTOSTART_SV, "Inaktivera warplge fr autostart"},
/* tr */ {IDCLS_DISABLE_WARP_MODE_AUTOSTART_TR, "Otomatik balatma esnasnda warp modu pasifletir"},
#endif

/* autostart.c */
/* en */ {IDCLS_SET_AUTOSTART_MODE_FOR_PRG,    N_("Set autostart mode for PRG files (0: VirtualFS, 1: Inject, 2: Disk image)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_AUTOSTART_MODE_FOR_PRG_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_AUTOSTART_MODE_FOR_PRG_DE, "Autstart Modus fr PRG Dateien definieren (0: VirtualFS, 1:Inject, 2:\nDiskimage)"},
/* es */ {IDCLS_SET_AUTOSTART_MODE_FOR_PRG_ES, "Seleccionar modo autoarranque para ficheros PRG (0: VirtualFS, 1: Inject, 2: Imagen disco)"},
/* fr */ {IDCLS_SET_AUTOSTART_MODE_FOR_PRG_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_AUTOSTART_MODE_FOR_PRG_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_AUTOSTART_MODE_FOR_PRG_IT, "Imposta avvio automatico per i file PRG (0: VirtualFS, 1: Inject, 2: Disk image)"},
/* ko */ {IDCLS_SET_AUTOSTART_MODE_FOR_PRG_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_AUTOSTART_MODE_FOR_PRG_NL, "Stel autostart modus in voor PRG bestanden (0: VirtualFS, 1: Injecteer, 2: Disk bestand)"},
/* pl */ {IDCLS_SET_AUTOSTART_MODE_FOR_PRG_PL, "Okrel tryb autostartu z plikw PRG (0: wirtualny system plikw, 1: wstrzyknicie, 2: obraz dysku)"},
/* ru */ {IDCLS_SET_AUTOSTART_MODE_FOR_PRG_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_AUTOSTART_MODE_FOR_PRG_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_AUTOSTART_MODE_FOR_PRG_TR, ""},  /* fuzzy */
#endif

/* autostart.c */
/* en */ {IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG,    N_("Set disk image for autostart of PRG files")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_DA, "Vlg diskimage for autostart af PRG-filer"},
/* de */ {IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_DE, "Disk Imagedatei fr Autstart whlen"},
/* es */ {IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_ES, "Seleccionar imagen disco para autoarranque ficheros PRG"},
/* fr */ {IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_FR, "Rgler l'image disque pour autodmarrage de fichiers PRG"},
/* hu */ {IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_HU, "Lmeez kpms megadsa PRG automatikus indtshoz"},
/* it */ {IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_IT, "Imposta immagine disco per l'avvio automatico dei file PRG"},
/* ko */ {IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_NL, "Stel disk bestand in voor het autostarten van PRG bestanden"},
/* pl */ {IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_PL, "Okrel obraz dysku do autostartu z plikw PRG"},
/* ru */ {IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_RU, "Set disk image for autostart of PRG files"},
/* sv */ {IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_SV, "Ange diskavbildning fr autostart av PRG-filer"},
/* tr */ {IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_TR, "PRG dosyalarnn otomatik balatlmas iin disk imaj ayarla"},
#endif

/* autostart.c */
/* en */ {IDCLS_SET_AUTOSTART_DELAY,    N_("Set initial autostart delay (0: use default)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_AUTOSTART_DELAY_DA, "Angiv autostart-forsinkelse (0: brug standard)"},
/* de */ {IDCLS_SET_AUTOSTART_DELAY_DE, "Setze initiale Autostart Verzgerung (0: benutze Standard)"},
/* es */ {IDCLS_SET_AUTOSTART_DELAY_ES, "Seleccionar retardo inicial autoarranque (Por defecto 0)"},
/* fr */ {IDCLS_SET_AUTOSTART_DELAY_FR, "Dfinir le dlai initial d'autodmarrage (0: utiliser dfaut)"},
/* hu */ {IDCLS_SET_AUTOSTART_DELAY_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_AUTOSTART_DELAY_IT, "Imposta ritardo iniziale all'avvio automatico (0: usa predefinito)"},
/* ko */ {IDCLS_SET_AUTOSTART_DELAY_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_AUTOSTART_DELAY_NL, "Stel vertraging in bij begin van het autostarten (0: gebruik de standaard waarde)"},
/* pl */ {IDCLS_SET_AUTOSTART_DELAY_PL, "Okrel pocztkowe opnienie autostartu (0: domylne)"},
/* ru */ {IDCLS_SET_AUTOSTART_DELAY_RU, "Set initial autostart delay (0: use default)"},
/* sv */ {IDCLS_SET_AUTOSTART_DELAY_SV, "Ange inledande frdrjning fr autostart (0: anvnd standard)"},
/* tr */ {IDCLS_SET_AUTOSTART_DELAY_TR, "Otomatik balatmada rastgele gecikmeyi ayarla (0: varsaylan kullan)"},
#endif

/* autostart.c */
/* en */ {IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY,    N_("Enable random initial autostart delay.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY_DA, "Aktivr tilfldig autostart-forsinkelse"},
/* de */ {IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY_DE, "Zuflle Verzgerung whrend Autostart aktivieren,"},
/* es */ {IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY_ES, "Permitir retardo arranque inicial aleatorio."},
/* fr */ {IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY_FR, "Activer le Mode Turbo"},
/* hu */ {IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY_IT, "Attiva ritardo casuale all'avvio automatico."},
/* ko */ {IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY_NL, "Willekeurige vertraging bij begin van het autostarten inschakelen."},
/* pl */ {IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY_PL, "Wcz losowe opnienie na pocztku autostartu."},
/* ru */ {IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY_RU, "Enable random initial autostart delay."},
/* sv */ {IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY_SV, "Aktivera slumpmssig inledande autostartfrdrjning"},
/* tr */ {IDCLS_ENABLE_AUTOSTART_RANDOM_DELAY_TR, "Otomatik balatmada rastgele gecikmeyi aktif et"},
#endif

/* autostart.c */
/* en */ {IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY,    N_("Disable random initial autostart delay.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY_DA, "Deaktivr tilfldig autostart-forsinkelse"},
/* de */ {IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY_DE, "Zuflle Verzgerung whrend Autostart deaktivieren."},
/* es */ {IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY_ES, "Deshabilitar retardo arranque inicial aleatorio."},
/* fr */ {IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY_FR, "Dsactiver le dlai alatoire initial d'autodmarrage."},
/* hu */ {IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY_IT, "Disattiva ritardo casuale all'avvio automatico."},
/* ko */ {IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY_NL, "Willekeurige vertraging bij begin van het autostarten uitschakelen."},
/* pl */ {IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY_PL, "Wycz losowe opnienie na pocztku autostartu."},
/* ru */ {IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY_RU, "Disable random initial autostart delay."},
/* sv */ {IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY_SV, "Inaktivera slumpmssig inledande autostartfrdrjning"},
/* tr */ {IDCLS_DISABLE_AUTOSTART_RANDOM_DELAY_TR, "Otomatik balatmada rastgele gecikmeyi pasifletir"},
#endif

/* vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_ENABLE_VFLI_MOD,    N_("Enable VFLI modification.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_VFLI_MOD_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_VFLI_MOD_DE, "VFLI Emulation aktivieren"},
/* es */ {IDCLS_ENABLE_VFLI_MOD_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_VFLI_MOD_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_VFLI_MOD_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_VFLI_MOD_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_VFLI_MOD_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_VFLI_MOD_NL, "VFLI modificatie inschakelen"},
/* pl */ {IDCLS_ENABLE_VFLI_MOD_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_VFLI_MOD_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_VFLI_MOD_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_VFLI_MOD_TR, ""},  /* fuzzy */
#endif

/* vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_DISABLE_VFLI_MOD,    N_("Disable VFLI modification.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_VFLI_MOD_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_VFLI_MOD_DE, "VFLI Emulation deaktivieren"},
/* es */ {IDCLS_DISABLE_VFLI_MOD_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_VFLI_MOD_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_VFLI_MOD_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_VFLI_MOD_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_VFLI_MOD_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_VFLI_MOD_NL, "VFLI modificatie uitschakelen"},
/* pl */ {IDCLS_DISABLE_VFLI_MOD_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_VFLI_MOD_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_VFLI_MOD_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_VFLI_MOD_TR, ""},  /* fuzzy */
#endif

/* machine.c */
/* en */ {IDCLS_SET_MACHINE_JAM_ACTION,    N_("Set action on CPU JAM: (0: Ask, 1: continue, 2: Monitor, 3: Reset, 4: Hard Reset, 5: Quit Emulator)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_MACHINE_JAM_ACTION_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_MACHINE_JAM_ACTION_DE, "Aktion bei CPU JAM: (0: Nachfrage, 1: Weitermachen, 2: Monitor, 3:\nReset, 4: Hard Reset, 5: Emulator beenden)"},
/* es */ {IDCLS_SET_MACHINE_JAM_ACTION_ES, "Seleccionar action on CPU JAM: (0: Preguntar, 1: continuar, 2: Monitor, 3: Reinicio, 4: Reinicio frio, 5: Salir emulador)"},
/* fr */ {IDCLS_SET_MACHINE_JAM_ACTION_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_MACHINE_JAM_ACTION_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_MACHINE_JAM_ACTION_IT, "Imposta azione al JAM della CPU: (0: Chiedi, 1: continua, 2: Monitor, 3: Reset, 4: Hard Reset, 5: Esci)"},
/* ko */ {IDCLS_SET_MACHINE_JAM_ACTION_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_MACHINE_JAM_ACTION_NL, "Geef de actie op bij een CPU VASTLOPER: (0: Vraag, 1: Doorgaan, 2: Monitor, 3: Reset, 4: Harde Reset, 5: Emulator uitschakelen)"},
/* pl */ {IDCLS_SET_MACHINE_JAM_ACTION_PL, "Ustal dziaanie przy zatkaniu si procesora: (0: zapytanie, 1: kontynuacja, 2: monitorowanie, 3: reset, 4: twardy reset, 5: wyjcie z emulatora)"},
/* ru */ {IDCLS_SET_MACHINE_JAM_ACTION_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_MACHINE_JAM_ACTION_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_MACHINE_JAM_ACTION_TR, ""},  /* fuzzy */
#endif

/* machine.c */
/* en */ {IDCLS_SET_EXIT_SCREENSHOT,    N_("Set name of screenshot to save when emulator exits.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_EXIT_SCREENSHOT_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_EXIT_SCREENSHOT_DE, "Name fr Screenshot Datei beim Beenden."},
/* es */ {IDCLS_SET_EXIT_SCREENSHOT_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SET_EXIT_SCREENSHOT_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_EXIT_SCREENSHOT_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_EXIT_SCREENSHOT_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SET_EXIT_SCREENSHOT_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_EXIT_SCREENSHOT_NL, "Geef de naam op van de schermafdruk die wordt opgeslagen wanneer de emulator wordt afgesloten."},
/* pl */ {IDCLS_SET_EXIT_SCREENSHOT_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_SET_EXIT_SCREENSHOT_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_EXIT_SCREENSHOT_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_EXIT_SCREENSHOT_TR, ""},  /* fuzzy */
#endif

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
   c64/psid.c, plus4/plus4-cmdline-options.c,
   vic20/vic20-cmdline-options.c, scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_USE_PAL_SYNC_FACTOR,    N_("Use PAL sync factor")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_USE_PAL_SYNC_FACTOR_DA, "Anvend PAL-synkfaktor"},
/* de */ {IDCLS_USE_PAL_SYNC_FACTOR_DE, "PAL Sync Faktor benutzen"},
/* es */ {IDCLS_USE_PAL_SYNC_FACTOR_ES, "Usar factor sincronizacin PAL"},
/* fr */ {IDCLS_USE_PAL_SYNC_FACTOR_FR, "Utiliser PAL"},
/* hu */ {IDCLS_USE_PAL_SYNC_FACTOR_HU, "PAL szinkron faktor hasznlata"},
/* it */ {IDCLS_USE_PAL_SYNC_FACTOR_IT, "Usa fattore di sincronizzazione PAL"},
/* ko */ {IDCLS_USE_PAL_SYNC_FACTOR_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_USE_PAL_SYNC_FACTOR_NL, "Gebruik PAL synchronisatiefactor"},
/* pl */ {IDCLS_USE_PAL_SYNC_FACTOR_PL, "Uywaj synchronizacji PAL"},
/* ru */ {IDCLS_USE_PAL_SYNC_FACTOR_RU, "Use PAL sync factor"},
/* sv */ {IDCLS_USE_PAL_SYNC_FACTOR_SV, "Anvnd PAL-synkfaktor"},
/* tr */ {IDCLS_USE_PAL_SYNC_FACTOR_TR, "PAL senkron faktr kullan"},
#endif

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
   c64/psid.c, plus4/plus4-cmdline-options.c,
   vic20/vic20-cmdline-options.c, scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_USE_NTSC_SYNC_FACTOR,    N_("Use NTSC sync factor")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_USE_NTSC_SYNC_FACTOR_DA, "Anvend NTSC-synkfaktor"},
/* de */ {IDCLS_USE_NTSC_SYNC_FACTOR_DE, "NTSC Sync Faktor benutzen"},
/* es */ {IDCLS_USE_NTSC_SYNC_FACTOR_ES, "Usar factor sincronizacin NTSC"},
/* fr */ {IDCLS_USE_NTSC_SYNC_FACTOR_FR, "Utiliser NTSC"},
/* hu */ {IDCLS_USE_NTSC_SYNC_FACTOR_HU, "NTSC szinkron faktor hasznlata"},
/* it */ {IDCLS_USE_NTSC_SYNC_FACTOR_IT, "Usa fattore di sincronizzazione NTSC"},
/* ko */ {IDCLS_USE_NTSC_SYNC_FACTOR_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_USE_NTSC_SYNC_FACTOR_NL, "Gebruik NTSC synchronisatiefactor"},
/* pl */ {IDCLS_USE_NTSC_SYNC_FACTOR_PL, "Uywaj synchronizacji NTSC"},
/* ru */ {IDCLS_USE_NTSC_SYNC_FACTOR_RU, "Use NTSC sync factor"},
/* sv */ {IDCLS_USE_NTSC_SYNC_FACTOR_SV, "Anvnd NTSC-synkfaktor"},
/* tr */ {IDCLS_USE_NTSC_SYNC_FACTOR_TR, "NTSC senkron faktr kullan"},
#endif

/* c64/c64-cmdline-options.c, c64/psid.c, scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_USE_PALN_SYNC_FACTOR,    N_("Use PAL-N sync factor")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_USE_PALN_SYNC_FACTOR_DA, "Anvend PAL-N synkfaktor"},
/* de */ {IDCLS_USE_PALN_SYNC_FACTOR_DE, "PAL Sync Faktor benutzen"},
/* es */ {IDCLS_USE_PALN_SYNC_FACTOR_ES, "Usar factor sincronizacin PAL-N"},
/* fr */ {IDCLS_USE_PALN_SYNC_FACTOR_FR, "Utiliser le facteur de synchronisation PAL-N"},
/* hu */ {IDCLS_USE_PALN_SYNC_FACTOR_HU, ""},  /* fuzzy */
/* it */ {IDCLS_USE_PALN_SYNC_FACTOR_IT, "Usa fattore di sincronizzazione PAL-N"},
/* ko */ {IDCLS_USE_PALN_SYNC_FACTOR_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_USE_PALN_SYNC_FACTOR_NL, "Gebruik PAL-N synchronisatiefactor"},
/* pl */ {IDCLS_USE_PALN_SYNC_FACTOR_PL, "Uywaj synchronizacji PAL-N"},
/* ru */ {IDCLS_USE_PALN_SYNC_FACTOR_RU, "Use PAL-N sync factor"},
/* sv */ {IDCLS_USE_PALN_SYNC_FACTOR_SV, "Anvnd PAL N-synkfaktor"},
/* tr */ {IDCLS_USE_PALN_SYNC_FACTOR_TR, "PAL-N senkron faktr kullan"},
#endif

/* c64/c64-cmdline-options.c, scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_SET_BURST_MOD,    N_("Burst modification (0 = None, 1 = CIA1, 2 = CIA2)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_BURST_MOD_DA, "Burst modification (0 = ingen, 1 = CIA1, 2 = CIA2)"},
/* de */ {IDCLS_SET_BURST_MOD_DE, "Burst Modifikation (0 = Kein, 1 = CIA1, 2 = CIA2)"},
/* es */ {IDCLS_SET_BURST_MOD_ES, "Modificacin arranque (0=No, 1=CIA1, 2=CIA2)"},
/* fr */ {IDCLS_SET_BURST_MOD_FR, "Modification Burst (0 = Aucune, 1 = CIA1, 2 = CIA2)"},
/* hu */ {IDCLS_SET_BURST_MOD_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_BURST_MOD_IT, "Burst modification (0 = Nessuna, 1 = CIA1, 2 = CIA2)"},
/* ko */ {IDCLS_SET_BURST_MOD_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_BURST_MOD_NL, "Burst modificatie (0 = Geen, 1 = CIA1, 2 = CIA2)"},
/* pl */ {IDCLS_SET_BURST_MOD_PL, "Modyfikacja trybu synchronicznego (0 = Brak, 1 = CIA1, 2 = CIA2)"},
/* ru */ {IDCLS_SET_BURST_MOD_RU, "Burst modification (0 = None, 1 = CIA1, 2 = CIA2)"},
/* sv */ {IDCLS_SET_BURST_MOD_SV, "Burstmodifiering (0 = ingen, 1 = CIA1, 2 = CIA2)"},
/* tr */ {IDCLS_SET_BURST_MOD_TR, "Burst deiiklii (0 = Yok, 1 = CIA1, 2 = CIA2)"},
#endif

/* c64/c64-cmdline-options.c, scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_SET_IEC_RESET,    N_("Computer reset goes to IEC bus (0 = No, 1 = Yes)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_IEC_RESET_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_IEC_RESET_DE, "Computer Reset auf IEC Bus (0 = Nein, 1 = Ja)"},
/* es */ {IDCLS_SET_IEC_RESET_ES, "Reinicio del ordenador va a IEC bus (0 = No, 1 = S)"},
/* fr */ {IDCLS_SET_IEC_RESET_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_IEC_RESET_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_IEC_RESET_IT, "Reset del computer va sul bus IEC (0 = No, 1 = S)"},
/* ko */ {IDCLS_SET_IEC_RESET_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_IEC_RESET_NL, "Computer reset gaat naar de IEC bus (0 = Nee, 1 = Ja)"},
/* pl */ {IDCLS_SET_IEC_RESET_PL, "Reset komputera uywa szyny IEC (0 = nie, 1 = tak)"},
/* ru */ {IDCLS_SET_IEC_RESET_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_IEC_RESET_SV, "Datornollstllning gr till IEC-bussen (0 = nej, 1 = ja)"},
/* tr */ {IDCLS_SET_IEC_RESET_TR, ""},  /* fuzzy */
#endif

/* c128/c128-cmdline-options.c, c128/functionrom.c,
   c64/c64-cmdline-options.c, c64/cart/georam.c,
   c64/cart/ramcart.c, c64/cart/reu.c, c64/cart/c64cart.c,
   c64/cart/ide64.c, cbm2/cbm2-cmdline-options.c,
   drive/iec/iec-cmdline-options.c, drive/iec128dcr/iec128dcr-cmdline-options.c,
   drive/ieee/ieee-cmdline-options.c, drive/tcbm/tcbm-cmdline-options.c,
   fsdevice/fsdevice-cmdline-options.c, pet/pet-cmdline-options.c,
   plus4/plus4-cmdline-options.c, printerdrv/driver-select.c,
   printerdrv/output-select.c, printerdrv/output-text.c,
   rs232drv/rs232drv.c, vic20/vic20-cmdline-options.c,
   vic20/vic20cartridge.c, video/video-cmdline-options.c,
   fliplist.c, initcmdline.c, log.c, sound.c, c64/plus60k.c,
   c64/c64_256k.c, pet/petreu.c, c64/plus256k.c, scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_P_NAME,    N_("<Name>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_NAME_DA, ""},  /* fuzzy */
/* de */ {IDCLS_P_NAME_DE, "<Name>"},
/* es */ {IDCLS_P_NAME_ES, "<nombre>"},
/* fr */ {IDCLS_P_NAME_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_P_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_NAME_IT, "<Nome>"},
/* ko */ {IDCLS_P_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_NAME_NL, "<Naam>"},
/* pl */ {IDCLS_P_NAME_PL, "<Nazwa>"},
/* ru */ {IDCLS_P_NAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_P_NAME_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_P_NAME_TR, ""},  /* fuzzy */
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_INT_KERNEL_NAME,    N_("Specify name of international Kernal ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_INT_KERNEL_NAME_DA, "Angiv navn p internationalt kerne-ROM-image"},
/* de */ {IDCLS_SPECIFY_INT_KERNEL_NAME_DE, "Namen fr internationale Kernal ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_INT_KERNEL_NAME_ES, "Especificar nombre imagen ROM Kernal internacional"},
/* fr */ {IDCLS_SPECIFY_INT_KERNEL_NAME_FR, "Spcifier le nom de l'image Kernal internationale"},
/* hu */ {IDCLS_SPECIFY_INT_KERNEL_NAME_HU, "Adja meg a nemzetkzi Kernal ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_INT_KERNEL_NAME_IT, "Specifica il nome immagine della ROM del Kernal internazionale"},
/* ko */ {IDCLS_SPECIFY_INT_KERNEL_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_INT_KERNEL_NAME_NL, "Geef de naam van het internationaal Kernal ROM bestand"},
/* pl */ {IDCLS_SPECIFY_INT_KERNEL_NAME_PL, "Okrel nazw obrazu midzynarodowego ROM-u Kernala"},
/* ru */ {IDCLS_SPECIFY_INT_KERNEL_NAME_RU, "Specify name of international Kernal ROM image"},
/* sv */ {IDCLS_SPECIFY_INT_KERNEL_NAME_SV, "Ange namn p internationell kernal-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_INT_KERNEL_NAME_TR, "Uluslararas Kernal ROM imajnn ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_DE_KERNEL_NAME,    N_("Specify name of German Kernal ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_DE_KERNEL_NAME_DA, "Angiv navn p tysk kerne-ROM-image"},
/* de */ {IDCLS_SPECIFY_DE_KERNEL_NAME_DE, "Name fr deutsche Kernal ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_DE_KERNEL_NAME_ES, "Especificar nombre imagen ROM Kernal alemn"},
/* fr */ {IDCLS_SPECIFY_DE_KERNEL_NAME_FR, "Spcifier le nom de l'image Kernal allemande"},
/* hu */ {IDCLS_SPECIFY_DE_KERNEL_NAME_HU, "Adja meg a nmet Kernal ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_DE_KERNEL_NAME_IT, "Specifica il nome immagine della ROM del Kernal tedesca"},
/* ko */ {IDCLS_SPECIFY_DE_KERNEL_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_DE_KERNEL_NAME_NL, "Geef de naam van het Duitse Kernal ROM bestand"},
/* pl */ {IDCLS_SPECIFY_DE_KERNEL_NAME_PL, "Podaj nazw obrazu niemieckiego ROM-u Kernala"},
/* ru */ {IDCLS_SPECIFY_DE_KERNEL_NAME_RU, "Specify name of German Kernal ROM image"},
/* sv */ {IDCLS_SPECIFY_DE_KERNEL_NAME_SV, "Ange namn p tysk kernal-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_DE_KERNEL_NAME_TR, "Alman Kernal ROM imajnn ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_FI_KERNEL_NAME,    N_("Specify name of Finnish Kernal ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_FI_KERNEL_NAME_DA, "Angiv navn p finsk kerne-ROM-image"},
/* de */ {IDCLS_SPECIFY_FI_KERNEL_NAME_DE, "Name fr finnische Kernal ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_FI_KERNEL_NAME_ES, "Especificar nombre imagen ROM Kernal finlands"},
/* fr */ {IDCLS_SPECIFY_FI_KERNEL_NAME_FR, "Spcifier le nom de l'image Kernal finlandaise"},
/* hu */ {IDCLS_SPECIFY_FI_KERNEL_NAME_HU, "Adja meg a finn Kernal ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_FI_KERNEL_NAME_IT, "Specifica il nome immagine della ROM del Kernal finlandese"},
/* ko */ {IDCLS_SPECIFY_FI_KERNEL_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_FI_KERNEL_NAME_NL, "Geef de naam van het Finse Kernal ROM bestand"},
/* pl */ {IDCLS_SPECIFY_FI_KERNEL_NAME_PL, "Okrel nazw obrazu fiskiego ROM-u Kernala"},
/* ru */ {IDCLS_SPECIFY_FI_KERNEL_NAME_RU, "Specify name of Finnish Kernal ROM image"},
/* sv */ {IDCLS_SPECIFY_FI_KERNEL_NAME_SV, "Ange namn p finsk kernal-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_FI_KERNEL_NAME_TR, "Finlandiya Kernal ROM imajnn ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_FR_KERNEL_NAME,    N_("Specify name of French Kernal ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_FR_KERNEL_NAME_DA, "Angiv navn p fransk kerne-ROM-image"},
/* de */ {IDCLS_SPECIFY_FR_KERNEL_NAME_DE, "Name fr franzsische Kernal ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_FR_KERNEL_NAME_ES, "Especificar nombre imagen ROM Kernal francs"},
/* fr */ {IDCLS_SPECIFY_FR_KERNEL_NAME_FR, "Spcifier le nom de l'image Kernal franaise"},
/* hu */ {IDCLS_SPECIFY_FR_KERNEL_NAME_HU, "Adja meg a francia Kernal ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_FR_KERNEL_NAME_IT, "Specifica il nome immagine della ROM del Kernal francese"},
/* ko */ {IDCLS_SPECIFY_FR_KERNEL_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_FR_KERNEL_NAME_NL, "Geef de naam van het Franse Kernal ROM bestand"},
/* pl */ {IDCLS_SPECIFY_FR_KERNEL_NAME_PL, "Okrel nazw obrazu francuskiego ROM-u Kernala"},
/* ru */ {IDCLS_SPECIFY_FR_KERNEL_NAME_RU, "Specify name of French Kernal ROM image"},
/* sv */ {IDCLS_SPECIFY_FR_KERNEL_NAME_SV, "Ange namn p fransk kernal-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_FR_KERNEL_NAME_TR, "Fransz Kernal ROM imajnn ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_IT_KERNEL_NAME,    N_("Specify name of Italian Kernal ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_IT_KERNEL_NAME_DA, "Angiv navn p italiensk kerne-ROM-image"},
/* de */ {IDCLS_SPECIFY_IT_KERNEL_NAME_DE, "Name fr italienische Kernal ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_IT_KERNEL_NAME_ES, "Especificar nombre imagen ROM Kernal italiano"},
/* fr */ {IDCLS_SPECIFY_IT_KERNEL_NAME_FR, "Spcifier le nom de l'image Kernal italienne"},
/* hu */ {IDCLS_SPECIFY_IT_KERNEL_NAME_HU, "Adja meg az olasz Kernal ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_IT_KERNEL_NAME_IT, "Specifica il nome immagine della ROM del Kernal italiana"},
/* ko */ {IDCLS_SPECIFY_IT_KERNEL_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_IT_KERNEL_NAME_NL, "Geef de naam van het Italiaanse Kernal ROM bestand"},
/* pl */ {IDCLS_SPECIFY_IT_KERNEL_NAME_PL, "Okrel nazw obrazu woskiego ROM-u Kernala"},
/* ru */ {IDCLS_SPECIFY_IT_KERNEL_NAME_RU, "Specify name of Italian Kernal ROM image"},
/* sv */ {IDCLS_SPECIFY_IT_KERNEL_NAME_SV, "Ange namn p italiensk kernal-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_IT_KERNEL_NAME_TR, "talyan Kernal ROM imajnn ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_NO_KERNEL_NAME,    N_("Specify name of Norwegian Kernal ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_NO_KERNEL_NAME_DA, "Angiv navn p norsk kerne-ROM-image"},
/* de */ {IDCLS_SPECIFY_NO_KERNEL_NAME_DE, "Name fr norwegische Kernal ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_NO_KERNEL_NAME_ES, "Especificar nombre imagen ROM noruego"},
/* fr */ {IDCLS_SPECIFY_NO_KERNEL_NAME_FR, "Spcifier le nom de l'image Kernal norvgienne"},
/* hu */ {IDCLS_SPECIFY_NO_KERNEL_NAME_HU, "Adja meg a norvg Kernal ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_NO_KERNEL_NAME_IT, "Specifica il nome immagine della ROM del Kernal norvegese"},
/* ko */ {IDCLS_SPECIFY_NO_KERNEL_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_NO_KERNEL_NAME_NL, "Geef de naam van het Noorse Kernal ROM bestand"},
/* pl */ {IDCLS_SPECIFY_NO_KERNEL_NAME_PL, "Okrel nazw obrazu norweskiego ROM-u Kernala"},
/* ru */ {IDCLS_SPECIFY_NO_KERNEL_NAME_RU, "Specify name of Norwegian Kernal ROM image"},
/* sv */ {IDCLS_SPECIFY_NO_KERNEL_NAME_SV, "Ange namn p norsk kernal-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_NO_KERNEL_NAME_TR, "Norve Kernal ROM imajnn ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_SV_KERNEL_NAME,    N_("Specify name of Swedish Kernal ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_SV_KERNEL_NAME_DA, "Angiv navn p svensk kerne-ROM-image"},
/* de */ {IDCLS_SPECIFY_SV_KERNEL_NAME_DE, "Name fr schwedische Kernal ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_SV_KERNEL_NAME_ES, "Especificar nombre imagen ROM Kernal sueco"},
/* fr */ {IDCLS_SPECIFY_SV_KERNEL_NAME_FR, "Spcifier le nom de l'image Kernal sudoise"},
/* hu */ {IDCLS_SPECIFY_SV_KERNEL_NAME_HU, "Adja meg s svd Kernal ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_SV_KERNEL_NAME_IT, "Specifica il nome immagine della ROM del Kernal svedese"},
/* ko */ {IDCLS_SPECIFY_SV_KERNEL_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_SV_KERNEL_NAME_NL, "Geef de naam van het Zweedse Kernal ROM bestand"},
/* pl */ {IDCLS_SPECIFY_SV_KERNEL_NAME_PL, "Okrel nazw obrazu szwedzkiego ROM-u Kernala"},
/* ru */ {IDCLS_SPECIFY_SV_KERNEL_NAME_RU, "Specify name of Swedish Kernal ROM image"},
/* sv */ {IDCLS_SPECIFY_SV_KERNEL_NAME_SV, "Ange namn p svensk kernal-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_SV_KERNEL_NAME_TR, "sve Kernal ROM imajnn ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CH_KERNEL_NAME,    N_("Specify name of Swiss Kernal ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_CH_KERNEL_NAME_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_CH_KERNEL_NAME_DE, "Name fr schweizer Kernal ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_CH_KERNEL_NAME_ES, "Especificar nombre imagen Kernal ROM suizo"},
/* fr */ {IDCLS_SPECIFY_CH_KERNEL_NAME_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_CH_KERNEL_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_CH_KERNEL_NAME_IT, "Specifica il nome immagine della ROM del Kernal svizzera"},
/* ko */ {IDCLS_SPECIFY_CH_KERNEL_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_CH_KERNEL_NAME_NL, "Geef de naam van het Zwitserse Kernal ROM bestand"},
/* pl */ {IDCLS_SPECIFY_CH_KERNEL_NAME_PL, "Okrel nazw obrazu szwajcarskiego ROM-u Kernala"},
/* ru */ {IDCLS_SPECIFY_CH_KERNEL_NAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_CH_KERNEL_NAME_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_CH_KERNEL_NAME_TR, ""},  /* fuzzy */
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_BASIC_ROM_NAME_LOW,    N_("Specify name of BASIC ROM image (lower part)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_DA, "Angiv navn p BASIC ROM-image (lav del)"},
/* de */ {IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_DE, "Namen fr Basic ROM Datei spezifizieren (unterer Teil)"},
/* es */ {IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_ES, "Especificar nombre imagen BASIC ROM (parte baja)"},
/* fr */ {IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_FR, "Spcifier le nom de l'image BASIC ROM (partie basse)"},
/* hu */ {IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_HU, "Adja meg a BASIC ROM kpms nevt (als rsz)"},
/* it */ {IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_IT, "Specifica il nome immagine della ROM del BASIC (parte inferiore)"},
/* ko */ {IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_NL, "Geef de naam van het BASIC ROM bestand (laag gedeelte)"},
/* pl */ {IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_PL, "Okrel nazw obrazu ROM BASIC (nisza partia)"},
/* ru */ {IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_RU, "Specify name of BASIC ROM image (lower part)"},
/* sv */ {IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_SV, "Ange namn p BASIC ROM-avbildning (nedre delen)"},
/* tr */ {IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_TR, "BASIC ROM imajnn (alt ksm) ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH,    N_("Specify name of BASIC ROM image (higher part)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_DA, "Angiv navn p BASIC ROM-image (hj del)"},
/* de */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_DE, "Namen fr Basic ROM Datei spezifizieren (oberer Teil)"},
/* es */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_ES, "Especificar nombre imagen BASIC ROM (parte alta)"},
/* fr */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_FR, "Spcifier le nom de l'image BASIC ROM (partie haute)"},
/* hu */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_HU, "Adja meg a BASIC ROM kpms nevt (fels rsz)"},
/* it */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_IT, "Specifica il nome immagine della ROM del BASIC (parte superiore)"},
/* ko */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_NL, "Geef de naam van het BASIC ROM bestand (hoog gedeelte)"},
/* pl */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_PL, "Okrel nazw obrazu ROM BASIC (wysza partia)"},
/* ru */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_RU, "Specify name of BASIC ROM image (higher part)"},
/* sv */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_SV, "Ange namn p BASIC ROM-avbildning (vre delen)"},
/* tr */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_TR, "BASIC ROM imajnn (st ksm) ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME,    N_("Specify name of international character generator ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_DA, "Angiv navn p internationalt tegngenerator-ROM-image"},
/* de */ {IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_DE, "Name fr internationale Charakter ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_ES, "Especificar nombre imagen ROM generador caracteres internacional"},
/* fr */ {IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_FR, "Spcifier le nom de l'image du gnrateur de caractres internationaux"},
/* hu */ {IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_HU, "Adja meg a nemzetkzi karaktergenertor ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_IT, "Specifica il nome immagine della ROM del generatore di caratteri internazionale"},
/* ko */ {IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_NL, "Geef de naam van het internationaal CHARGEN ROM bestand"},
/* pl */ {IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_PL, "Okrel nazw obrazu ROM generatora znakw midzynarodowych"},
/* ru */ {IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_RU, "Specify name of international character generator ROM image"},
/* sv */ {IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_SV, "Ange namn p internationell teckengenerator-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_TR, "Uluslararas Karakter Oluturucu ROM imajnn ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME,    N_("Specify name of German character generator ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_DA, "Angiv navn p tysk tegngenerator-ROM-image"},
/* de */ {IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_DE, "Name fr deutsche Charakter ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_ES, "Especificar nombre imagen ROM generador caracteres alemn"},
/* fr */ {IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_FR, "Spcifier le nom de l'image du gnrateur de caractres allemands"},
/* hu */ {IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_HU, "Adja meg a nmet karaktergenertor ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_IT, "Specifica il nome immagine della ROM del generatore di caratteri tedesco"},
/* ko */ {IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_NL, "Geef de naam van het Duitse CHARGEN ROM bestand"},
/* pl */ {IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_PL, "Okrel nazw obrazu ROM generatora niemieckich znakw"},
/* ru */ {IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_RU, "  ROM    "},
/* sv */ {IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_SV, "Ange namn p tysk teckengenerator-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_TR, "Alman Karakter Oluturucu ROM imajnn ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME,    N_("Specify name of French character generator ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_DA, "Angiv navn p fransk tegngenerator-ROM-image"},
/* de */ {IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_DE, "Name fr franzsische Charakter ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_ES, "Especificar nombre imagen ROM generador caracteres francs"},
/* fr */ {IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_FR, "Spcifier le nom de l'image du gnrateur de caractres franais"},
/* hu */ {IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_HU, "Adja meg a francia karaktergenertor ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_IT, "Specifica il nome immagine della ROM del generatore di caratteri francese"},
/* ko */ {IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_NL, "Geef de naam van het Franse CHARGEN ROM bestand"},
/* pl */ {IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_PL, "Okrel nazw obrazu ROM generatora francuskich znakw"},
/* ru */ {IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_RU, "  ROM    "},
/* sv */ {IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_SV, "Ange namn p fransk teckengenerator-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_TR, "Finlandiya Karakter Oluturucu ROM imajnn ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME,    N_("Specify name of Swedish character generator ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_DA, "Angiv navn p svensk tegngenerator-ROM-image"},
/* de */ {IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_DE, "Name fr schwedische Charakter ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_ES, "Especificar nombre imagen ROM generador caracteres sueco"},
/* fr */ {IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_FR, "Spcifier le nom de l'image du gnrateur de caractres sudois"},
/* hu */ {IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_HU, "Adja meg a svd karaktergenertor ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_IT, "Specifica il nome immagine della ROM del generatore di caratteri svedese"},
/* ko */ {IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_NL, "Geef de naam van het Zweedse CHARGEN ROM bestand"},
/* pl */ {IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_PL, "Okrel nazw obrazu ROM generatora szwedzkich znakw"},
/* ru */ {IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_RU, "  ROM    "},
/* sv */ {IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_SV, "Ange namn p svensk teckengenerator-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_TR, "sve Karakter Oluturucu ROM imajnn ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CH_CHARGEN_ROM_NAME,    N_("Specify name of Swedish character generator ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_CH_CHARGEN_ROM_NAME_DA, "Angiv navn p svensk tegngenerator-ROM-image"},
/* de */ {IDCLS_SPECIFY_CH_CHARGEN_ROM_NAME_DE, "Name fr schwedische Charakter ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_CH_CHARGEN_ROM_NAME_ES, "Especificar nombre imagen ROM generador caracteres sueco"},
/* fr */ {IDCLS_SPECIFY_CH_CHARGEN_ROM_NAME_FR, "Spcifier le nom de l'image du gnrateur de caractres sudois"},
/* hu */ {IDCLS_SPECIFY_CH_CHARGEN_ROM_NAME_HU, "Adja meg a svd karaktergenertor ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_CH_CHARGEN_ROM_NAME_IT, "Specifica il nome immagine della ROM del generatore di caratteri svedese"},
/* ko */ {IDCLS_SPECIFY_CH_CHARGEN_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_CH_CHARGEN_ROM_NAME_NL, "Geef de naam van het Zweedse CHARGEN ROM bestand"},
/* pl */ {IDCLS_SPECIFY_CH_CHARGEN_ROM_NAME_PL, "Okrel nazw obrazu ROM generatora szwedzkich znakw"},
/* ru */ {IDCLS_SPECIFY_CH_CHARGEN_ROM_NAME_RU, "  ROM    "},
/* sv */ {IDCLS_SPECIFY_CH_CHARGEN_ROM_NAME_SV, "Ange namn p svensk teckengenerator-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_CH_CHARGEN_ROM_NAME_TR, "sve Karakter Oluturucu ROM imajnn ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_C64_MODE_KERNAL_NAME,    N_("Specify name of C64 mode Kernal ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_DA, "Angiv navn p C64-kerne-ROM-image"},
/* de */ {IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_DE, "Name fr C64 Modus Kernal ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_ES, "Especificar nombre imagen ROM Kernal modo C64"},
/* fr */ {IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_FR, "Spcifier le nom de l'image Kernal du mode C64"},
/* hu */ {IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_HU, "Adja meg a C64 md Kernal ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_IT, "Specifica il nome immagine della ROM del Kernal in modalit C64"},
/* ko */ {IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_NL, "Geef de naam van het Kernal ROM bestand voor de C64 modus"},
/* pl */ {IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_PL, "Okrel nazw obrazu ROM Kernala trybu C64"},
/* ru */ {IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_RU, "Specify name of C64 mode Kernal ROM image"},
/* sv */ {IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_SV, "Ange namn p C64-kernal-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_TR, "C64 modu Kernal ROM imajnn ismini belirt"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_C64_MODE_BASIC_NAME,    N_("Specify name of C64 mode BASIC ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_C64_MODE_BASIC_NAME_DA, "Angiv navn p C64-BASIC-ROM-image"},
/* de */ {IDCLS_SPECIFY_C64_MODE_BASIC_NAME_DE, "Name fr C64 Modus Basic ROM Datei spezifizieren"},
/* es */ {IDCLS_SPECIFY_C64_MODE_BASIC_NAME_ES, "Especificar nombre imagen BASIC ROM modo C64"},
/* fr */ {IDCLS_SPECIFY_C64_MODE_BASIC_NAME_FR, "Spcifier le nom de l'image BASIC ROM du mode C64"},
/* hu */ {IDCLS_SPECIFY_C64_MODE_BASIC_NAME_HU, "Adja meg a C64 md BASIC ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_C64_MODE_BASIC_NAME_IT, "Specifica il nome immagine della ROM in modalit C64"},
/* ko */ {IDCLS_SPECIFY_C64_MODE_BASIC_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_C64_MODE_BASIC_NAME_NL, "Geef de naam van het BASIC ROM bestand voor de C64 modus"},
/* pl */ {IDCLS_SPECIFY_C64_MODE_BASIC_NAME_PL, "Okrel nazw obrazu ROM BASIC trybu C64"},
/* ru */ {IDCLS_SPECIFY_C64_MODE_BASIC_NAME_RU, "  ROM   C64 BASIC"},
/* sv */ {IDCLS_SPECIFY_C64_MODE_BASIC_NAME_SV, "Ange namn p C64-BASIC-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_C64_MODE_BASIC_NAME_TR, "C64 modu BASIC ROM imajnn ismini belirt"},
#endif

/* vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_ENABLE_OEM_JOY,    N_("Enable the OEM userport joystick adapter")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_OEM_JOY_DA, "Aktivr OEM brugerportjoystickadapter"},
/* de */ {IDCLS_ENABLE_OEM_JOY_DE, "OEM Userport Joystick Adapter aktivieren"},
/* es */ {IDCLS_ENABLE_OEM_JOY_ES, "Permitir adaptador puerto joystick OEM"},
/* fr */ {IDCLS_ENABLE_OEM_JOY_FR, "Activer l'adaptateur joystick port utilisateur OEM"},
/* hu */ {IDCLS_ENABLE_OEM_JOY_HU, "OEM userport botkormny adapter engedlyezse"},
/* it */ {IDCLS_ENABLE_OEM_JOY_IT, "Attiva adattatore joystick OEM su userport"},
/* ko */ {IDCLS_ENABLE_OEM_JOY_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_OEM_JOY_NL, "OEM userport joystick adapter inschakelen"},
/* pl */ {IDCLS_ENABLE_OEM_JOY_PL, "Wcz zcze OEM userportu joysticka"},
/* ru */ {IDCLS_ENABLE_OEM_JOY_RU, "Enable the OEM userport joystick adapter"},
/* sv */ {IDCLS_ENABLE_OEM_JOY_SV, "Aktivera OEM-anvndarportspelportsadapter"},
/* tr */ {IDCLS_ENABLE_OEM_JOY_TR, "OEM userport joystick dntrcy aktif et"},
#endif

/* vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_DISABLE_OEM_JOY,    N_("Disable the OEM userport joystick adapter")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_OEM_JOY_DA, "Deaktivr OEM brugerportjoystickadapter"},
/* de */ {IDCLS_DISABLE_OEM_JOY_DE, "OEM Userport Joystick Adapter deaktivieren"},
/* es */ {IDCLS_DISABLE_OEM_JOY_ES, "Deshabilitar adaptador puerto joystick OEM"},
/* fr */ {IDCLS_DISABLE_OEM_JOY_FR, "Dsactiver l'adaptateur OEM Joystick port utilisateur"},
/* hu */ {IDCLS_DISABLE_OEM_JOY_HU, "OEM userport botkormny adapter tiltsa"},
/* it */ {IDCLS_DISABLE_OEM_JOY_IT, "Disattiva adattatore joystick OEM su userport"},
/* ko */ {IDCLS_DISABLE_OEM_JOY_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_OEM_JOY_NL, "OEM userport joystick adapter uitschakelen"},
/* pl */ {IDCLS_DISABLE_OEM_JOY_PL, "Wycz zcze OEM userportu joysticka"},
/* ru */ {IDCLS_DISABLE_OEM_JOY_RU, "Disable the OEM userport joystick adapter"},
/* sv */ {IDCLS_DISABLE_OEM_JOY_SV, "Inaktivera OEM-anvndarportspelportsadapter"},
/* tr */ {IDCLS_DISABLE_OEM_JOY_TR, "OEM userport joystick dntrcy pasifletir"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_ENABLE_IEE488,    N_("Enable the IEEE488 interface emulation")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_IEE488_DA, "Aktivr emulering af IEEE488-interface"},
/* de */ {IDCLS_ENABLE_IEE488_DE, "IEEE488 Schnittstellen-Emulation aktivieren"},
/* es */ {IDCLS_ENABLE_IEE488_ES, "Permitir emulacin interface IEEE488"},
/* fr */ {IDCLS_ENABLE_IEE488_FR, "Activer l'interface d'mulation IEEE488"},
/* hu */ {IDCLS_ENABLE_IEE488_HU, "IEEE488 interfsz emulci engedlyezse"},
/* it */ {IDCLS_ENABLE_IEE488_IT, "Attiva emulazione interfaccia IEEE488"},
/* ko */ {IDCLS_ENABLE_IEE488_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_IEE488_NL, "IEEE488 interface emulatie inschakelen"},
/* pl */ {IDCLS_ENABLE_IEE488_PL, "Wcz emulacj interfejsu IEEE488"},
/* ru */ {IDCLS_ENABLE_IEE488_RU, "Enable the IEEE488 interface emulation"},
/* sv */ {IDCLS_ENABLE_IEE488_SV, "Aktivera emulering av IEEE488-grnssnitt"},
/* tr */ {IDCLS_ENABLE_IEE488_TR, "IEEE488 arabirim emlasyonunu aktif et"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_DISABLE_IEE488,    N_("Disable the IEEE488 interface emulation")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_IEE488_DA, "Deaktivr emulering af IEEE488-interface"},
/* de */ {IDCLS_DISABLE_IEE488_DE, "IEEE488 Schnittstellen-Emulation deaktivieren"},
/* es */ {IDCLS_DISABLE_IEE488_ES, "Deshabilitar emulacin interface IEEE488"},
/* fr */ {IDCLS_DISABLE_IEE488_FR, "Dsactiver l'interface d'mulation IEEE488"},
/* hu */ {IDCLS_DISABLE_IEE488_HU, "IEEE488 interfsz emulci tiltsa"},
/* it */ {IDCLS_DISABLE_IEE488_IT, "Disattiva emulazione interfaccia IEEE488"},
/* ko */ {IDCLS_DISABLE_IEE488_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_IEE488_NL, "IEEE488 interface emulatie uitschakelen"},
/* pl */ {IDCLS_DISABLE_IEE488_PL, "Wycz emulacj interfejsu IEEE488"},
/* ru */ {IDCLS_DISABLE_IEE488_RU, "Disable the IEEE488 interface emulation"},
/* sv */ {IDCLS_DISABLE_IEE488_SV, "Inaktivera emulering av IEEE488-grnssnitt"},
/* tr */ {IDCLS_DISABLE_IEE488_TR, "IEEE488 arabirim emlasyonunu pasifletir"},
#endif

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c */
/* en */ {IDCLS_P_REVISION,    N_("<Revision>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_REVISION_DA, "<Udgave>"},
/* de */ {IDCLS_P_REVISION_DE, "<Revision>"},
/* es */ {IDCLS_P_REVISION_ES, "<Revisin>"},
/* fr */ {IDCLS_P_REVISION_FR, "<Rvision>"},
/* hu */ {IDCLS_P_REVISION_HU, "<Vltozatszm>"},
/* it */ {IDCLS_P_REVISION_IT, "<Revisione>"},
/* ko */ {IDCLS_P_REVISION_KO, "<>"},
/* nl */ {IDCLS_P_REVISION_NL, "<Revisie>"},
/* pl */ {IDCLS_P_REVISION_PL, "<Wersja>"},
/* ru */ {IDCLS_P_REVISION_RU, "<Revision>"},
/* sv */ {IDCLS_P_REVISION_SV, "<Utgva>"},
/* tr */ {IDCLS_P_REVISION_TR, "<Revizyon>"},
#endif

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c */
/* en */ {IDCLS_PATCH_KERNAL_TO_REVISION,    N_("Patch the Kernal ROM to the specified <revision> (1: rev. 1, 2: rev. 2, 3: rev. 3, 67/sx: sx64, 100/4064: 4064)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PATCH_KERNAL_TO_REVISION_DA, ""},  /* fuzzy */
/* de */ {IDCLS_PATCH_KERNAL_TO_REVISION_DE, "Kernal ROM auf <revision> modifzieren (1: rev. 1, 2: rev. 2, 3: rev. 3, 67/sx: sx64, 100/4064: 4064)"},
/* es */ {IDCLS_PATCH_KERNAL_TO_REVISION_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_PATCH_KERNAL_TO_REVISION_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_PATCH_KERNAL_TO_REVISION_HU, ""},  /* fuzzy */
/* it */ {IDCLS_PATCH_KERNAL_TO_REVISION_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_PATCH_KERNAL_TO_REVISION_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PATCH_KERNAL_TO_REVISION_NL, "Verbeter de Kernal ROM naar de opgegeven <revisie> (1: rev. 1, 2: rev. 2, 3: rev. 3, 67/sx: sx64, 100/4064: 4064)"},
/* pl */ {IDCLS_PATCH_KERNAL_TO_REVISION_PL, "Zaataj ROM Kernala do konkretnej <wersji> (1: rev. 1, 2: rev. 2, 3: rev. 3, 67/sx: sx64, 100/4064: 4064)"},
/* ru */ {IDCLS_PATCH_KERNAL_TO_REVISION_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_PATCH_KERNAL_TO_REVISION_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_PATCH_KERNAL_TO_REVISION_TR, ""},  /* fuzzy */
#endif

#if defined(HAVE_RS232DEV) || defined(HAVE_RS232NET)
/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c
   scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DEXX_ACIA_RS232_EMU,    N_("Enable the ACIA RS232 interface emulation")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_DA, "Aktivr ACIA RS232-interface emulering"},
/* de */ {IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_DE, "ACIA RS232 Schnittstellen-Emulation aktivieren"},
/* es */ {IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_ES, "Permitir emulacin interface ACIA RS232"},
/* fr */ {IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_FR, "Activer l'mulation de l'interface ACIA RS232"},
/* hu */ {IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_IT, "Attiva emulazione interfaccia ACIA RS232"},
/* ko */ {IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_NL, "ACIA RS232 interface emulatie inschakelen"},
/* pl */ {IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_PL, "Wcz emulacj interfejsu ACIA RS232"},
/* ru */ {IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_RU, "Enable the ACIA RS232 interface emulation"},
/* sv */ {IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_SV, "Aktivera ACIA RS232-grnssnittsemulering"},
/* tr */ {IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_TR, "ACIA RS232 arabirim emlasyonunu aktif et"},
#endif

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
   scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DEXX_ACIA_RS232_EMU,    N_("Disable the ACIA RS232 interface emulation")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_DA, "Deaktivr ACIA-RS232-interface emulering"},
/* de */ {IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_DE, "ACIA RS232 Schnittstellen-Emulation deaktivieren"},
/* es */ {IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_ES, "Deshabilitar emulacin interface ACIA RS232"},
/* fr */ {IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_FR, "Dsactiver l'mulation de l'interface ACIA RS232"},
/* hu */ {IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_IT, "Disattiva emulazione interfaccia ACIA RS232"},
/* ko */ {IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_NL, "ACIA RS232 interface emulatie uitschakelen"},
/* pl */ {IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_PL, "Wycz emulacj interfejsu ACIA RS232"},
/* ru */ {IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_RU, "Disable the ACIA RS232 interface emulation"},
/* sv */ {IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_SV, "Inaktivera ACIA-RS232-grnssnittsemulering"},
/* tr */ {IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_TR, "ACIA RS232 arabirim emlasyonunu pasifletir"},
#endif

/* c64/cart/c64acia1.c */
/* en */ {IDCLS_P_IRQ,    N_("<interrupt>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_IRQ_DA, ""},  /* fuzzy */
/* de */ {IDCLS_P_IRQ_DE, "<Interrupt>"},
/* es */ {IDCLS_P_IRQ_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_P_IRQ_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_P_IRQ_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_IRQ_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_P_IRQ_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_IRQ_NL, "<interrupt>"},
/* pl */ {IDCLS_P_IRQ_PL, "<przerwanie>"},
/* ru */ {IDCLS_P_IRQ_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_P_IRQ_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_P_IRQ_TR, ""},  /* fuzzy */
#endif

/* c64/cart/c64acia1.c */
/* en */ {IDCLS_SET_ACIA_IRQ,    N_("Set the ACIA interrupt (0: None, 1: NMI, 2: IRQ)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_ACIA_IRQ_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_ACIA_IRQ_DE, "ACIA Interrupt setzen (0: None, 1: NMI, 2: IRQ)"},
/* es */ {IDCLS_SET_ACIA_IRQ_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SET_ACIA_IRQ_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_ACIA_IRQ_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_ACIA_IRQ_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SET_ACIA_IRQ_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_ACIA_IRQ_NL, "Stel de ACIA interrupt in (0: Geen, 1: NMI, 2: IRQ)"},
/* pl */ {IDCLS_SET_ACIA_IRQ_PL, "Ustaw przerwanie ACIA (0:Brak, 1: NMI, 2: IRQ)"},
/* ru */ {IDCLS_SET_ACIA_IRQ_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_ACIA_IRQ_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_ACIA_IRQ_TR, ""},  /* fuzzy */
#endif

/* c64/cart/c64acia1.c */
/* en */ {IDCLS_SET_ACIA_MODE,    N_("Set the ACIA mode (0: Normal, 1: Swiftlink, 2: Turbo232)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_ACIA_MODE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_ACIA_MODE_DE, "ACIA Modus setzen (0: Normal, 1: Swiftlink, 2: Turbo232)"},
/* es */ {IDCLS_SET_ACIA_MODE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SET_ACIA_MODE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_ACIA_MODE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_ACIA_MODE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SET_ACIA_MODE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_ACIA_MODE_NL, "Stel de ACIA modus in (0: normaal, 1: Swiftlink, 2: Turbo232)"},
/* pl */ {IDCLS_SET_ACIA_MODE_PL, "Okrel tryb ACIA (0:Zwyky, 1: Swiftlink, 2: Turbo232)"},
/* ru */ {IDCLS_SET_ACIA_MODE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_ACIA_MODE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_ACIA_MODE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/c64acia1.c */
/* en */ {IDCLS_SET_ACIA_BASE,    N_("Set the base address of the ACIA cartridge")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_ACIA_BASE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_ACIA_BASE_DE, "Basis Adresse fr ACIA Erweiterung"},
/* es */ {IDCLS_SET_ACIA_BASE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SET_ACIA_BASE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_ACIA_BASE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_ACIA_BASE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SET_ACIA_BASE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_ACIA_BASE_NL, "Stel het basisadres in van de ACIA cartridge"},
/* pl */ {IDCLS_SET_ACIA_BASE_PL, "Ustaw adres bazowy kartrida ACIA"},
/* ru */ {IDCLS_SET_ACIA_BASE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_ACIA_BASE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_ACIA_BASE_TR, ""},  /* fuzzy */
#endif
#endif


/* plus4/plus4acia.c */
/* en */ {IDCLS_ENABLE_ACIA_EMU,    N_("Enable the ACIA emulation")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_ACIA_EMU_DA, "Aktivr ACIA-emulering"},
/* de */ {IDCLS_ENABLE_ACIA_EMU_DE, "ACIA Emulation aktivieren"},
/* es */ {IDCLS_ENABLE_ACIA_EMU_ES, "Habilitar emulacin ACIA"},
/* fr */ {IDCLS_ENABLE_ACIA_EMU_FR, "Activer l'mulation ACIA"},
/* hu */ {IDCLS_ENABLE_ACIA_EMU_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_ACIA_EMU_IT, "Attiva emulazione ACIA"},
/* ko */ {IDCLS_ENABLE_ACIA_EMU_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_ACIA_EMU_NL, "ACIA emulatie inschakelen"},
/* pl */ {IDCLS_ENABLE_ACIA_EMU_PL, "Wcz emulacj ACIA"},
/* ru */ {IDCLS_ENABLE_ACIA_EMU_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_ACIA_EMU_SV, "Aktivera ACIA-emuleringen"},
/* tr */ {IDCLS_ENABLE_ACIA_EMU_TR, "ACIA emlasyonunu aktif et"},
#endif

/* plus4/plus4acia.c */
/* en */ {IDCLS_DISABLE_ACIA_EMU,    N_("Disable the ACIA emulation")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_ACIA_EMU_DA, "Deaktivr ACIA-emulering"},
/* de */ {IDCLS_DISABLE_ACIA_EMU_DE, "ACIA Emulation deaktivieren"},
/* es */ {IDCLS_DISABLE_ACIA_EMU_ES, "Deshabilitar emulacin ACIA"},
/* fr */ {IDCLS_DISABLE_ACIA_EMU_FR, "Dsactiver l'mulation ACIA"},
/* hu */ {IDCLS_DISABLE_ACIA_EMU_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_ACIA_EMU_IT, "Disattiva emulazione ACIA"},
/* ko */ {IDCLS_DISABLE_ACIA_EMU_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_ACIA_EMU_NL, "ACIA emulatie uitschakelen"},
/* pl */ {IDCLS_DISABLE_ACIA_EMU_PL, "Wycz emulacj ACIA"},
/* ru */ {IDCLS_DISABLE_ACIA_EMU_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_ACIA_EMU_SV, "Inaktivera ACIA-emuleringen"},
/* tr */ {IDCLS_DISABLE_ACIA_EMU_TR, "ACIA emlasyonunu pasifletir"},
#endif

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
   c64/psid.c, cbm2/cbm2-cmdline-options.c,
   pet/pet-cmdline-options.c, plus4/plus4-cmdline-options.c,
   vdc/vdc-cmdline-options.c, vic20/vic20-cmdline-options.c,
   scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_P_NUMBER,    N_("<number>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_NUMBER_DA, "<nummer>"},
/* de */ {IDCLS_P_NUMBER_DE, "<Nummer>"},
/* es */ {IDCLS_P_NUMBER_ES, "<nmero>"},
/* fr */ {IDCLS_P_NUMBER_FR, "<numro>"},
/* hu */ {IDCLS_P_NUMBER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_NUMBER_IT, "<numero>"},
/* ko */ {IDCLS_P_NUMBER_KO, "<>"},
/* nl */ {IDCLS_P_NUMBER_NL, "<nummer>"},
/* pl */ {IDCLS_P_NUMBER_PL, "<numer>"},
/* ru */ {IDCLS_P_NUMBER_RU, "<number>"},
/* sv */ {IDCLS_P_NUMBER_SV, "<nummer>"},
/* tr */ {IDCLS_P_NUMBER_TR, "<say>"},
#endif

#ifdef COMMON_KBD
/* keyboard.c */
/* en */ {IDCLS_SPECIFY_KEYMAP_FILE_INDEX,    N_("Specify index of keymap file (0=symbolic, 1=positional, 2=symbolic (user), 3=positional (user))")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_KEYMAP_FILE_INDEX_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_KEYMAP_FILE_INDEX_DE, "Index fr Kymap Datei festlegen (0=symbol, 1=positional), 2=symbolisch\n(Benutzer), 3=positional (Benutzer))"},
/* es */ {IDCLS_SPECIFY_KEYMAP_FILE_INDEX_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SPECIFY_KEYMAP_FILE_INDEX_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_KEYMAP_FILE_INDEX_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_KEYMAP_FILE_INDEX_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SPECIFY_KEYMAP_FILE_INDEX_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_KEYMAP_FILE_INDEX_NL, "Geef index van het toetstoewijzingsbestand (0=symbolisch, 1=positioneel, 2=symbolisch (gebruiker), 3=positioneel (gebruiker))"},
/* pl */ {IDCLS_SPECIFY_KEYMAP_FILE_INDEX_PL, "Podaj indeks ukadu klawiatury (0=symbol, 1=pozycja, 2=symbol (uytkownika), 3=pozycja (uytkownika))"},
/* ru */ {IDCLS_SPECIFY_KEYMAP_FILE_INDEX_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_KEYMAP_FILE_INDEX_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_KEYMAP_FILE_INDEX_TR, ""},  /* fuzzy */
#endif

/* keyboard.c */
/* FIXME: generate dynamically */
/* en */ {IDCLS_SPECIFY_KEYBOARD_TYPE,    N_("Specify emulated keyboard type")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_KEYBOARD_TYPE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_KEYBOARD_TYPE_DE, "Emulation fr Tastaturtyp auswhlen"},
/* es */ {IDCLS_SPECIFY_KEYBOARD_TYPE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SPECIFY_KEYBOARD_TYPE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_KEYBOARD_TYPE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_KEYBOARD_TYPE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SPECIFY_KEYBOARD_TYPE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_KEYBOARD_TYPE_NL, "Geef gemuleerd toetsenbord soort"},
/* pl */ {IDCLS_SPECIFY_KEYBOARD_TYPE_PL, "Wybierz rodzaj emulowanej klawiatury"},
/* ru */ {IDCLS_SPECIFY_KEYBOARD_TYPE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_KEYBOARD_TYPE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_KEYBOARD_TYPE_TR, ""},  /* fuzzy */
#endif

/* keyboard.c */
/* FIXME: generate dynamically */
/* en */ {IDCLS_SPECIFY_KEYBOARD_MAPPING,    N_("Specify host keyboard layout")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_KEYBOARD_MAPPING_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_KEYBOARD_MAPPING_DE, "Host Tastatur Layout auswhlen"},
/* es */ {IDCLS_SPECIFY_KEYBOARD_MAPPING_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SPECIFY_KEYBOARD_MAPPING_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_KEYBOARD_MAPPING_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_KEYBOARD_MAPPING_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SPECIFY_KEYBOARD_MAPPING_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_KEYBOARD_MAPPING_NL, "Geef host toetsenbordindeling"},
/* pl */ {IDCLS_SPECIFY_KEYBOARD_MAPPING_PL, "Okrel ukad klawiatury hosta"},
/* ru */ {IDCLS_SPECIFY_KEYBOARD_MAPPING_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_KEYBOARD_MAPPING_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_KEYBOARD_MAPPING_TR, ""},  /* fuzzy */
#endif

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
   plus4/plus4-cmdline-options.c, vic20/vic20-cmdline-options.c,
   scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME,    N_("Specify name of symbolic keymap file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_DA, "Angiv filnavn for symbolsk tastatur"},
/* de */ {IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_DE, "Bitte Namen fr symbolische Keymap Datei whlen"},
/* es */ {IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_ES, "Especificar nombre fichero del mapa de teclado simblico"},
/* fr */ {IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_FR, "Spcifier le nom du fichier de mappage clavier symbolique"},
/* hu */ {IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_HU, "Adja meg a szimbolikus lekpzsfjl nevt"},
/* it */ {IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_IT, "Specifica il nome del file della mappa simbolica della tastiera"},
/* ko */ {IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_NL, "Geef naam van het symbolisch toetstoewijzingsbestand"},
/* pl */ {IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_PL, "Okrel nazw pliku symbolicznego ukadu klawiatury"},
/* ru */ {IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_RU, "Specify name of symbolic keymap file"},
/* sv */ {IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_SV, "Ange fil fr symbolisk tangentbordsemulering"},
/* tr */ {IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_TR, "Sembolik tu haritas dosyasnn ismini belirt"},
#endif

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
   plus4/plus4-cmdline-options.c, vic20/vic20-cmdline-options.c,
   scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME,    N_("Specify name of positional keymap file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_DA, "Angiv fil for positionsbestemt tastatur"},
/* de */ {IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_DE, "Bitte Namen fr positions Keymap Datei whlen"},
/* es */ {IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_ES, "Especificar nombre fichero del mapa de teclado posicional"},
/* fr */ {IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_FR, "Spcifier le nom du fichier de mappage clavier positionnel"},
/* hu */ {IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_HU, "Adja meg a pozci szerinti lekpzsfjl nevt"},
/* it */ {IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_IT, "Specifica il nome del file della mappa posizionale della tastiera"},
/* ko */ {IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_NL, "Geef naam van het positioneel toetstoewijzingsbestand"},
/* pl */ {IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_PL, "Okrel nazw pliku pozycyjnego ukadu klawiatury"},
/* ru */ {IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_RU, "Specify name of positional keymap file"},
/* sv */ {IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_SV, "Ange fil fr positionsriktig tangentbordsemulering"},
/* tr */ {IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_TR, "Konumsal tu haritas dosyasnn ismini belirt"},
#endif
#endif

/* c128/c128mmu.c */
/* en */ {IDCLS_ACTIVATE_40_COL_MODE,    N_("Activate 40 column mode")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ACTIVATE_40_COL_MODE_DA, "Aktivr 40-kolonners tilstand"},
/* de */ {IDCLS_ACTIVATE_40_COL_MODE_DE, "40 Spalten Modus aktivieren"},
/* es */ {IDCLS_ACTIVATE_40_COL_MODE_ES, "Activar modo 40 columnas"},
/* fr */ {IDCLS_ACTIVATE_40_COL_MODE_FR, "Activer le mode 40 colonnes"},
/* hu */ {IDCLS_ACTIVATE_40_COL_MODE_HU, "40 oszlopos md aktivlsa"},
/* it */ {IDCLS_ACTIVATE_40_COL_MODE_IT, "Attiva modalit a 40 colonne"},
/* ko */ {IDCLS_ACTIVATE_40_COL_MODE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ACTIVATE_40_COL_MODE_NL, "Activeer 40 kolomsmodus"},
/* pl */ {IDCLS_ACTIVATE_40_COL_MODE_PL, "Wcz tryb 40 kolumn"},
/* ru */ {IDCLS_ACTIVATE_40_COL_MODE_RU, "  40 "},
/* sv */ {IDCLS_ACTIVATE_40_COL_MODE_SV, "Aktivera 40-kolumnerslge"},
/* tr */ {IDCLS_ACTIVATE_40_COL_MODE_TR, "40 stun modunu aktif et"},
#endif

/* c128/c128mmu.c */
/* en */ {IDCLS_ACTIVATE_80_COL_MODE,    N_("Activate 80 column mode")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ACTIVATE_80_COL_MODE_DA, "Aktivr 80-kolonners tilstand"},
/* de */ {IDCLS_ACTIVATE_80_COL_MODE_DE, "80 Spalten Modus aktivieren"},
/* es */ {IDCLS_ACTIVATE_80_COL_MODE_ES, "Activar modo 80 columnas"},
/* fr */ {IDCLS_ACTIVATE_80_COL_MODE_FR, "Activer le mode 80 colonnes"},
/* hu */ {IDCLS_ACTIVATE_80_COL_MODE_HU, "80 oszlopos md aktivlsa"},
/* it */ {IDCLS_ACTIVATE_80_COL_MODE_IT, "Attiva modalit a 80 colonne"},
/* ko */ {IDCLS_ACTIVATE_80_COL_MODE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ACTIVATE_80_COL_MODE_NL, "Activeer 80 kolomsmodus"},
/* pl */ {IDCLS_ACTIVATE_80_COL_MODE_PL, "Wcz tryb 80 kolumn"},
/* ru */ {IDCLS_ACTIVATE_80_COL_MODE_RU, "  80 "},
/* sv */ {IDCLS_ACTIVATE_80_COL_MODE_SV, "Aktivera 80-kolumnerslge"},
/* tr */ {IDCLS_ACTIVATE_80_COL_MODE_TR, "80 stun modunu aktif et"},
#endif

/* c128/c128mmu.c */
/* en */ {IDCLS_GO64_MODE,    N_("Always switch to C64 mode on reset")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_GO64_MODE_DA, "Skift altid til C64-tilstand ved reset"},
/* de */ {IDCLS_GO64_MODE_DE, "Immer bei Reset in C64 Modus schalten"},
/* es */ {IDCLS_GO64_MODE_ES, "Al reiniciar, pasar siempre al modo C64"},
/* fr */ {IDCLS_GO64_MODE_FR, "Toujours revenir au mode C64 au redmarrage"},
/* hu */ {IDCLS_GO64_MODE_HU, "Mindig C64 mdban jraindts utn"},
/* it */ {IDCLS_GO64_MODE_IT, "Vai sempre in modalit C64 al reset"},
/* ko */ {IDCLS_GO64_MODE_KO, "ٽ ϸ ׻ C64   ٲϴ"},
/* nl */ {IDCLS_GO64_MODE_NL, "Start altijd op in C64 modus na reset"},
/* pl */ {IDCLS_GO64_MODE_PL, "Przy restarcie zawsze przeczaj w tryb C64"},
/* ru */ {IDCLS_GO64_MODE_RU, "Always switch to C64 mode on reset"},
/* sv */ {IDCLS_GO64_MODE_SV, "Vxla alltid till C64-lge vid terstllning"},
/* tr */ {IDCLS_GO64_MODE_TR, "Resetlendiinde her zaman C64 moduna ge"},
#endif

/* c128/c128mmu.c */
/* en */ {IDCLS_GO128_MODE,    N_("Always switch to C128 mode on reset")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_GO128_MODE_DA, "Skift altid til C128-tilstand ved reset"},
/* de */ {IDCLS_GO128_MODE_DE, "Immer be Reset in C128 Modus schalten"},
/* es */ {IDCLS_GO128_MODE_ES, "Al reiniciar, pasar siempre al modo C128"},
/* fr */ {IDCLS_GO128_MODE_FR, "Toujours revenir au mode C128 au redmarrage"},
/* hu */ {IDCLS_GO128_MODE_HU, "Mindig C128 md jraindts utn"},
/* it */ {IDCLS_GO128_MODE_IT, "Vai sempre in modalit C128 al reset"},
/* ko */ {IDCLS_GO128_MODE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_GO128_MODE_NL, "Start altijd op in C128 modus na reset"},
/* pl */ {IDCLS_GO128_MODE_PL, "Przy restarcie zawsze przeczaj w tryb C128"},
/* ru */ {IDCLS_GO128_MODE_RU, "    C128  "},
/* sv */ {IDCLS_GO128_MODE_SV, "Vxla alltid till C128-lge vid terstllning"},
/* tr */ {IDCLS_GO128_MODE_TR, "Resetlendiinde her zaman C128 moduna ge"},
#endif

/* c128/functionrom.c */
/* en */ {IDCLS_SPECIFY_INT_FUNC_ROM_NAME,    N_("Specify name of internal Function ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_INT_FUNC_ROM_NAME_DA, "Angiv navn p internt funktions-ROM-image"},
/* de */ {IDCLS_SPECIFY_INT_FUNC_ROM_NAME_DE, "Name der internen Funktions ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_INT_FUNC_ROM_NAME_ES, "Especificar nombre imagen ROM funcin interna"},
/* fr */ {IDCLS_SPECIFY_INT_FUNC_ROM_NAME_FR, "Spcifier le nom de l'image ROM des fonctions internes"},
/* hu */ {IDCLS_SPECIFY_INT_FUNC_ROM_NAME_HU, "Adja meg a bels Function ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_INT_FUNC_ROM_NAME_IT, "Specifica il nome immagine della Function ROM interna"},
/* ko */ {IDCLS_SPECIFY_INT_FUNC_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_INT_FUNC_ROM_NAME_NL, "Geef de naam van het intern functie ROM bestand"},
/* pl */ {IDCLS_SPECIFY_INT_FUNC_ROM_NAME_PL, "Okrel nazw obrazu wewntrznego Function ROM-u"},
/* ru */ {IDCLS_SPECIFY_INT_FUNC_ROM_NAME_RU, "Specify name of internal Function ROM image"},
/* sv */ {IDCLS_SPECIFY_INT_FUNC_ROM_NAME_SV, "Ange namn p intern funktions-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_INT_FUNC_ROM_NAME_TR, "Dahili Function ROM imajnn ismini belirt"},
#endif

/* c128/functionrom.c */
/* en */ {IDCLS_SPECIFY_EXT_FUNC_ROM_NAME,    N_("Specify name of external Function ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_DA, "Angiv navn p externt funktions-ROM-image"},
/* de */ {IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_DE, "Name der externen Funktions ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_ES, "Especificar nombre imagen ROM funcin externa"},
/* fr */ {IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_FR, "Spcifier le nom de l'image ROM des fonctions externes"},
/* hu */ {IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_HU, "Adja meg a kls Function ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_IT, "Specifica il nome immagine della Function ROM esterna"},
/* ko */ {IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_NL, "Geef de naam van het extern functie ROM bestand"},
/* pl */ {IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_PL, "Okrel nazw obrazu zewntrznego Function ROM-u"},
/* ru */ {IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_RU, "Specify name of external Function ROM image"},
/* sv */ {IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_SV, "Ange namn p extern funktions-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_TR, "Harici Function ROM imajnn ismini belirt"},
#endif

/* c128/functionrom.c */
/* en */ {IDCLS_ENABLE_INT_FUNC_ROM,    N_("Type of internal Function ROM: (0: None, 1: ROM, 2: RAM, 3: RTC)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_INT_FUNC_ROM_DA, "Typen af intern funktions-ROM: (0: Ingen, 1: ROM, 2: RAM, 3:RTC)"},
/* de */ {IDCLS_ENABLE_INT_FUNC_ROM_DE, "Typ des internen Funktions ROM: (0: Kein, 1: ROM, 2: RAM, 3: RTC)"},
/* es */ {IDCLS_ENABLE_INT_FUNC_ROM_ES, "Tipo de Function ROM interna: (0: None, 1: ROM, 2: RAM, 3: RTC)"},
/* fr */ {IDCLS_ENABLE_INT_FUNC_ROM_FR, "Type de ROM Fonction interne: (0: Aucun, 1: ROM, 2: RAM, 3: RTC)"},
/* hu */ {IDCLS_ENABLE_INT_FUNC_ROM_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_INT_FUNC_ROM_IT, "Tipo di Function ROM interna: (0: None, 1: ROM, 2: RAM, 3: RTC)"},
/* ko */ {IDCLS_ENABLE_INT_FUNC_ROM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_INT_FUNC_ROM_NL, "Intern functie ROM soort: (0: Geen, 1: ROM, 2: RAM, 3: RTC)"},
/* pl */ {IDCLS_ENABLE_INT_FUNC_ROM_PL, "Typ wewntrznego Function ROM-u: (0: aden, 1: ROM, 2: RAM, 3: RTC)"},
/* ru */ {IDCLS_ENABLE_INT_FUNC_ROM_RU, "Type of internal Function ROM: (0: None, 1: ROM, 2: RAM, 3: RTC)"},
/* sv */ {IDCLS_ENABLE_INT_FUNC_ROM_SV, "Typ fr intern funktions-ROM (0: ingen, 1: ROM, 2: RAM, 3: RTC)"},
/* tr */ {IDCLS_ENABLE_INT_FUNC_ROM_TR, "Dahili Function ROM Tipi: (0: Yok, 1: ROM, 2: RAM, 3: RTC)"},
#endif

/* c128/functionrom.c */
/* en */ {IDCLS_ENABLE_EXT_FUNC_ROM,    N_("Type of external Function ROM: (0: None, 1: ROM, 2: RAM, 3: RTC)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_EXT_FUNC_ROM_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_EXT_FUNC_ROM_DE, "Typ des esternen Funktions ROM: (0: Kein, 1: ROM, 2: RAM, 3: RTC)"},
/* es */ {IDCLS_ENABLE_EXT_FUNC_ROM_ES, "Tipo de Function ROM externa: (0: None, 1: ROM, 2: RAM, 3: RTC)"},
/* fr */ {IDCLS_ENABLE_EXT_FUNC_ROM_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_EXT_FUNC_ROM_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_EXT_FUNC_ROM_IT, "Tipo di Function ROM esterna: (0: None, 1: ROM, 2: RAM, 3: RTC)"},
/* ko */ {IDCLS_ENABLE_EXT_FUNC_ROM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_EXT_FUNC_ROM_NL, "Extern functie ROM soort: (0: Geen, 1: ROM, 2: RAM, 3: RTC)"},
/* pl */ {IDCLS_ENABLE_EXT_FUNC_ROM_PL, "Typ zewntrznego Function ROM-u: (0: aden, 1: ROM, 2: RAM, 3: RTC)"},
/* ru */ {IDCLS_ENABLE_EXT_FUNC_ROM_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_EXT_FUNC_ROM_SV, "Typ fr extern funktions-ROM (0: ingen, 1: ROM, 2: RAM, 3: RTC)"},
/* tr */ {IDCLS_ENABLE_EXT_FUNC_ROM_TR, ""},  /* fuzzy */
#endif

/* c128/functionrom.c */
/* en */ {IDCLS_ENABLE_INT_FUNC_RTC_SAVE,    N_("Enable saving of the internal function RTC data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_INT_FUNC_RTC_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_INT_FUNC_RTC_SAVE_DE, "Interne Funktions RTC Daten bei nderung speichern."},
/* es */ {IDCLS_ENABLE_INT_FUNC_RTC_SAVE_ES, "Permitir grabar datos de Internal Function RTC cuando cambien"},
/* fr */ {IDCLS_ENABLE_INT_FUNC_RTC_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_INT_FUNC_RTC_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_INT_FUNC_RTC_SAVE_IT, "Attiva il salvataggio dei dati RTC della internal function alla modifica."},
/* ko */ {IDCLS_ENABLE_INT_FUNC_RTC_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_INT_FUNC_RTC_SAVE_NL, "Opslaan van de interne functie RTC gegevens bij wijziging inschakelen."},
/* pl */ {IDCLS_ENABLE_INT_FUNC_RTC_SAVE_PL, "Zapisuj dane zegara czasu rzeczywistego wewntrznego Function ROM-u przy zmianie"},
/* ru */ {IDCLS_ENABLE_INT_FUNC_RTC_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_INT_FUNC_RTC_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_INT_FUNC_RTC_SAVE_TR, ""},  /* fuzzy */
#endif

/* c128/functionrom.c */
/* en */ {IDCLS_DISABLE_INT_FUNC_RTC_SAVE,    N_("Disable saving of the internal function RTC data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_INT_FUNC_RTC_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_INT_FUNC_RTC_SAVE_DE, "Interne Funktions RTC Daten bei nderung nicht speichern."},
/* es */ {IDCLS_DISABLE_INT_FUNC_RTC_SAVE_ES, "Deshabilitar grabar datos de Internal Function RTC cuando cambien"},
/* fr */ {IDCLS_DISABLE_INT_FUNC_RTC_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_INT_FUNC_RTC_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_INT_FUNC_RTC_SAVE_IT, "Disattiva il salvataggio dei dati RTC della internal function alla modifica."},
/* ko */ {IDCLS_DISABLE_INT_FUNC_RTC_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_INT_FUNC_RTC_SAVE_NL, "Opslaan van de interne functie RTC gegevens bij wijziging uitschakelen."},
/* pl */ {IDCLS_DISABLE_INT_FUNC_RTC_SAVE_PL, "Nie zapisuj danych zegara czasu rzeczywistego wewntrznego Function ROM-u przy zmianie"},
/* ru */ {IDCLS_DISABLE_INT_FUNC_RTC_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_INT_FUNC_RTC_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_INT_FUNC_RTC_SAVE_TR, ""},  /* fuzzy */
#endif

/* c128/functionrom.c */
/* en */ {IDCLS_ENABLE_EXT_FUNC_RTC_SAVE,    N_("Enable saving of the external function RTC data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_EXT_FUNC_RTC_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_EXT_FUNC_RTC_SAVE_DE, "Externe Funktions RTC Daten bei nderung speichern."},
/* es */ {IDCLS_ENABLE_EXT_FUNC_RTC_SAVE_ES, "Permitir grabar datos de External Function RTC cuando cambien"},
/* fr */ {IDCLS_ENABLE_EXT_FUNC_RTC_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_EXT_FUNC_RTC_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_EXT_FUNC_RTC_SAVE_IT, "Attiva il salvataggio dei dati RTC della external function alla modifica."},
/* ko */ {IDCLS_ENABLE_EXT_FUNC_RTC_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_EXT_FUNC_RTC_SAVE_NL, "Opslaan van de externe functie RTC gegevens bij wijziging inschakelen."},
/* pl */ {IDCLS_ENABLE_EXT_FUNC_RTC_SAVE_PL, "Zapisuj dane zegara czasu rzeczywistego zewntrznego Function ROM-u przy zmianie"},
/* ru */ {IDCLS_ENABLE_EXT_FUNC_RTC_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_EXT_FUNC_RTC_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_EXT_FUNC_RTC_SAVE_TR, ""},  /* fuzzy */
#endif

/* c128/functionrom.c */
/* en */ {IDCLS_DISABLE_EXT_FUNC_RTC_SAVE,    N_("Disable saving of the external function RTC data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_EXT_FUNC_RTC_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_EXT_FUNC_RTC_SAVE_DE, "Externe Funktions RTC Daten bei nderung nicht speichern."},
/* es */ {IDCLS_DISABLE_EXT_FUNC_RTC_SAVE_ES, "Deshabilitar grabar datos de External Function RTC cuando cambien"},
/* fr */ {IDCLS_DISABLE_EXT_FUNC_RTC_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_EXT_FUNC_RTC_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_EXT_FUNC_RTC_SAVE_IT, "Disattiva il salvataggio dei dati RTC della external function alla modifica."},
/* ko */ {IDCLS_DISABLE_EXT_FUNC_RTC_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_EXT_FUNC_RTC_SAVE_NL, "Opslaan van de externe functie RTC gegevens bij wijziging uitschakelen."},
/* pl */ {IDCLS_DISABLE_EXT_FUNC_RTC_SAVE_PL, "Nie zapisuj danych zegara czasu rzeczywistego zewntrznego Function ROM-u przy zmianie"},
/* ru */ {IDCLS_DISABLE_EXT_FUNC_RTC_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_EXT_FUNC_RTC_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_EXT_FUNC_RTC_SAVE_TR, ""},  /* fuzzy */
#endif

/* c64/c64-cmdline-options.c, c64/psid.c, scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_USE_OLD_NTSC_SYNC_FACTOR,    N_("Use old NTSC sync factor")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_USE_OLD_NTSC_SYNC_FACTOR_DA, "Anvend gammel NTSC-synkfaktor"},
/* de */ {IDCLS_USE_OLD_NTSC_SYNC_FACTOR_DE, "Alten NTSC Sync Faktor verwenden"},
/* es */ {IDCLS_USE_OLD_NTSC_SYNC_FACTOR_ES, "Usar antiguo factor de sincronizacin NTSC"},
/* fr */ {IDCLS_USE_OLD_NTSC_SYNC_FACTOR_FR, "Utiliser l'ancien mode NTSC"},
/* hu */ {IDCLS_USE_OLD_NTSC_SYNC_FACTOR_HU, "Rgi NTSC szinkron faktor hasznlata"},
/* it */ {IDCLS_USE_OLD_NTSC_SYNC_FACTOR_IT, "Usa il vecchio fattore di sincronizzazione NTSC"},
/* ko */ {IDCLS_USE_OLD_NTSC_SYNC_FACTOR_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_USE_OLD_NTSC_SYNC_FACTOR_NL, "Gebruik oude NTSC synchronisatiefactor"},
/* pl */ {IDCLS_USE_OLD_NTSC_SYNC_FACTOR_PL, "Uywaj starej synchronizacji NTSC"},
/* ru */ {IDCLS_USE_OLD_NTSC_SYNC_FACTOR_RU, "Use old NTSC sync factor"},
/* sv */ {IDCLS_USE_OLD_NTSC_SYNC_FACTOR_SV, "Anvnd gammal NTSC-synkfaktor"},
/* tr */ {IDCLS_USE_OLD_NTSC_SYNC_FACTOR_TR, "Eski NTSC senkron faktr kullan"},
#endif

/* c64/c64-cmdline-options.c, viciisc/vicii-cmdline-options.c,
   scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_P_MODEL,    N_("<Model>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_MODEL_DA, "<Model>"},
/* de */ {IDCLS_P_MODEL_DE, "<Modell>"},
/* es */ {IDCLS_P_MODEL_ES, "<Modelo>"},
/* fr */ {IDCLS_P_MODEL_FR, "<Modle>"},
/* hu */ {IDCLS_P_MODEL_HU, "<Modell>"},
/* it */ {IDCLS_P_MODEL_IT, "<Modello>"},
/* ko */ {IDCLS_P_MODEL_KO, "<>"},
/* nl */ {IDCLS_P_MODEL_NL, "<Model>"},
/* pl */ {IDCLS_P_MODEL_PL, "<Model>"},
/* ru */ {IDCLS_P_MODEL_RU, "<>"},
/* sv */ {IDCLS_P_MODEL_SV, "<Modell>"},
/* tr */ {IDCLS_P_MODEL_TR, "<Model>"},
#endif

/* c64/c64-cmdline-options.c, scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_SET_BOTH_CIA_MODELS,    N_("Set both CIA models (0 = old 6526, 1 = new 6526A)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_BOTH_CIA_MODELS_DA, "Vlg type for begge CIA-kredse (0=gammel 6526, 1=ny 6526A)"},
/* de */ {IDCLS_SET_BOTH_CIA_MODELS_DE, "Whle beide CIA Modelle (0 = alt 6526, 1 = neu 6526A)"},
/* es */ {IDCLS_SET_BOTH_CIA_MODELS_ES, "Seleccionar ambos modelos de CIA (0 = antiguo 6526, 1 = nuevo 6526A)"},
/* fr */ {IDCLS_SET_BOTH_CIA_MODELS_FR, "Dfinir les deux modles CIA (0 = ancien 5626, 1 = rcent 6526A)"},
/* hu */ {IDCLS_SET_BOTH_CIA_MODELS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_BOTH_CIA_MODELS_IT, "Imposta entrambi i modelli CIA (0 = 6526 vecchio, 1 = 6526A nuovo)"},
/* ko */ {IDCLS_SET_BOTH_CIA_MODELS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_BOTH_CIA_MODELS_NL, "Stel model in voor beide CIA's (0 = oud 6526, 1 = nieuw 6526A)"},
/* pl */ {IDCLS_SET_BOTH_CIA_MODELS_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_SET_BOTH_CIA_MODELS_RU, "Set both CIA models (0 = old 6526, 1 = new 6526A)"},
/* sv */ {IDCLS_SET_BOTH_CIA_MODELS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_BOTH_CIA_MODELS_TR, "Her iki CIA modelini belirle (0 = eski 6526, 1 = yeni 6526A)"},
#endif

/* c64/c64-cmdline-options.c, scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_SET_CIA1_MODEL,    N_("Set CIA 1 model (0 = old 6526, 1 = new 6526A)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_CIA1_MODEL_DA, "Vlg CIA 1 type (0=gammel 6526, 1=ny 6526A)"},
/* de */ {IDCLS_SET_CIA1_MODEL_DE, "Whle CIA 1 Modell (0 = alt 6526, 1 = neu 6526A)"},
/* es */ {IDCLS_SET_CIA1_MODEL_ES, "Seleccionar CIA 1 Poner CIA 1 model (0 = antiguo 6526, 1 = nuevo 6526A)"},
/* fr */ {IDCLS_SET_CIA1_MODEL_FR, "Dfinir le modle CIA 2 (0 = ancien 5626, 1 = rcent 6526A)"},
/* hu */ {IDCLS_SET_CIA1_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_CIA1_MODEL_IT, "Imposta modello CIA 1 (0 = 6526 vecchio, 1 = 6526A nuovo)"},
/* ko */ {IDCLS_SET_CIA1_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_CIA1_MODEL_NL, "Stel CIA 1 model in (0 = oud 6526, 1 = nieuw 6526A)"},
/* pl */ {IDCLS_SET_CIA1_MODEL_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_SET_CIA1_MODEL_RU, "Set CIA 1 model (0 = old 6526, 1 = new 6526A)"},
/* sv */ {IDCLS_SET_CIA1_MODEL_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_CIA1_MODEL_TR, "CIA 1 modelini belirle (0 = eski 6526, 1 = yeni 6526A)"},
#endif

/* c64/c64-cmdline-options.c, scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_SET_CIA2_MODEL,    N_("Set CIA 2 model (0 = old 6526, 1 = new 6526A)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_CIA2_MODEL_DA, "Vlg CIA 2 type (0=gammel 6526, 1=ny 6526A)"},
/* de */ {IDCLS_SET_CIA2_MODEL_DE, "Whle CIA 2 Modell (0 = alt 6526, 1 = neu 6526A)\""},
/* es */ {IDCLS_SET_CIA2_MODEL_ES, "Seleccionar CIA 2 model (0 = antiguo 6526, 1 = nuevo 6526A)"},
/* fr */ {IDCLS_SET_CIA2_MODEL_FR, "Dfinir le modle CIA 1 (0 = ancien 5626, 1 = rcent 6526A)"},
/* hu */ {IDCLS_SET_CIA2_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_CIA2_MODEL_IT, "Imposta modello CIA 2 (0 = 6526 vecchio, 1 = 6526A nuovo)"},
/* ko */ {IDCLS_SET_CIA2_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_CIA2_MODEL_NL, "Stel CIA 2 model in (0 = oud 6526, 1 = nieuw 6526A)"},
/* pl */ {IDCLS_SET_CIA2_MODEL_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_SET_CIA2_MODEL_RU, "Set CIA 2 model (0 = old 6526, 1 = new 6526A)"},
/* sv */ {IDCLS_SET_CIA2_MODEL_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_CIA2_MODEL_TR, "CIA 2 modelini belirle (0 = eski 6526, 1 = yeni 6526A)"},
#endif

/* c64/c64-cmdline-options.c */
/* en */ {IDCLS_SET_C64_MODEL,    N_("Set C64 model (c64/c64c/c64old, ntsc/newntsc/oldntsc, drean, jap, c64gs, pet64, ultimax)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_C64_MODEL_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_C64_MODEL_DE, "Whle C64 Modell (c64/c64c/c64old, ntsc/newntsc/oldntsc, drean, jap, c64gs, pet64, ultimax)"},
/* es */ {IDCLS_SET_C64_MODEL_ES, "Seleccionar modelo C64 (c64/c64c/c64old, ntsc/newntsc/oldntsc, drean, jap, c64gs, pet64, ultimax)"},
/* fr */ {IDCLS_SET_C64_MODEL_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_C64_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_C64_MODEL_IT, "Imposta modello C64 (c64/c64c/c64old, ntsc/newntsc/oldntsc, drean, jap, c64gs, pet64, ultimax)"},
/* ko */ {IDCLS_SET_C64_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_C64_MODEL_NL, "Stel C64 model in (c64/c64c/c64old, ntsc/newntsc/oldntsc, drean, jap, c64gs, pet64, ultimax)"},
/* pl */ {IDCLS_SET_C64_MODEL_PL, "Wybierz model C64 (c64/c64c/c64old, ntsc/newntsc/oldntsc, drean, jap, c64gs, pet64, ultimax)"},
/* ru */ {IDCLS_SET_C64_MODEL_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_C64_MODEL_SV, "Vlj C64-modell (c64/c64c/c64old, ntsc/newntsc/oldntsc, drean, jap, c64gs, pet64, ultimax)"},
/* tr */ {IDCLS_SET_C64_MODEL_TR, ""},  /* fuzzy */
#endif

/* scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_SET_SCPU64_MODEL,    N_("Set C64 model (c64/c64c/c64old, ntsc/newntsc/oldntsc, drean, jap, c64gs)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_SCPU64_MODEL_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_SCPU64_MODEL_DE, "Whle C64 Modell (c64/c64c/c64old, ntsc/newntsc/oldntsc, drean, jap, c64gs)"},
/* es */ {IDCLS_SET_SCPU64_MODEL_ES, "Seleccionar modelo C64 (c64/c64c/c64old, ntsc/newntsc/oldntsc, drean, jap, c64gs)"},
/* fr */ {IDCLS_SET_SCPU64_MODEL_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_SCPU64_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_SCPU64_MODEL_IT, "Imposta modello C64 (c64/c64c/c64old, ntsc/newntsc/oldntsc, drean, jap, c64gs)"},
/* ko */ {IDCLS_SET_SCPU64_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_SCPU64_MODEL_NL, "Stel C64 model in (c64/c64c/c64old, ntsc/newntsc/oldntsc, drean, jap, c64gs)"},
/* pl */ {IDCLS_SET_SCPU64_MODEL_PL, "Wybierz model C64 (c64/c64c/c64old, ntsc/newntsc/oldntsc, drean, jap, c64gs)"},
/* ru */ {IDCLS_SET_SCPU64_MODEL_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_SCPU64_MODEL_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_SCPU64_MODEL_TR, ""},  /* fuzzy */
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SET_C128_MODEL,    N_("Set C128 model (c128/c128dcr, pal/ntsc)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_C128_MODEL_DA, "Angiv C128-model (c128/c128dcr, pal/ntsc)"},
/* de */ {IDCLS_SET_C128_MODEL_DE, "Whle C128 Modell (c128/c128dcr, pal/ntsc)"},
/* es */ {IDCLS_SET_C128_MODEL_ES, "Seleccionar modelo C128 (c128/c128dcr, pal/ntsc)"},
/* fr */ {IDCLS_SET_C128_MODEL_FR, "Dfinir le modle C128 (c128/c128dcr, pal/ntsc)"},
/* hu */ {IDCLS_SET_C128_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_C128_MODEL_IT, "Imposta modello C128 (c128/c128dcr, pal/ntsc)"},
/* ko */ {IDCLS_SET_C128_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_C128_MODEL_NL, "Stel C128 model in (c128/c128dcr, pal/ntsc)"},
/* pl */ {IDCLS_SET_C128_MODEL_PL, "Ustaw model C128 (c128/c128dcr, pal/ntsc)"},
/* ru */ {IDCLS_SET_C128_MODEL_RU, "Set C128 model (c128/c128dcr, pal/ntsc)"},
/* sv */ {IDCLS_SET_C128_MODEL_SV, "Vlj C128-modell (c128/c128dcr, pal/ntsc)"},
/* tr */ {IDCLS_SET_C128_MODEL_TR, "C128 modelini belirle (c128/c128dcr, pal/ntsc)"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SET_C128_MACHINE_TYPE,    N_("Set C128 machine type (0: International, 1: Finnish, 2: French, 3: German, 4: Italian, 5: Norwegian, 6: Swedish, 7: Swiss)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_C128_MACHINE_TYPE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_C128_MACHINE_TYPE_DE, "Whle C128 Modell (0: International, 1: Finnisch, 2: Franzsisch, 3: Deutsch, 4: Italienisch , 5: Norwegisch, 6: Schwedisch, 7: Schweiz)"},
/* es */ {IDCLS_SET_C128_MACHINE_TYPE_ES, "Seleccionar tipo de mquina C128 (0: Internacional, 1: Finlandesa, 2: Francesa, 3: Alemana, 4: Italiana, 5: Noruega, 6: Sueca, 7: Suiza)"},
/* fr */ {IDCLS_SET_C128_MACHINE_TYPE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_C128_MACHINE_TYPE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_C128_MACHINE_TYPE_IT, "Imposta tipo C128 (0: Internazionale, 1: Finlandese, 2: Francese, 3: Tedesco, 4: Italiano, 5: Norvegese, 6: Svedese, 7: Svizzero)"},
/* ko */ {IDCLS_SET_C128_MACHINE_TYPE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_C128_MACHINE_TYPE_NL, "Stel C128 machine soort in (0: Internationaal, 1: Fins, 2: Frans, 3: Duits, 4: Italiaans, 5: Noors, 6: Zweeds, 7: Zwitsers)"},
/* pl */ {IDCLS_SET_C128_MACHINE_TYPE_PL, "Wybierz typ maszyny C128 (0: Midzynarodowy, 1: Fiski, 2: Francuski, 3: Niemiecki, 4: Woski, 5: Norweski, 6: Szwedzki, 7: Szwajcarski)"},
/* ru */ {IDCLS_SET_C128_MACHINE_TYPE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_C128_MACHINE_TYPE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_C128_MACHINE_TYPE_TR, ""},  /* fuzzy */
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_ENABLE_C128_FULL_BANKS,    N_("Enable RAM banks 2 and 3")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_C128_FULL_BANKS_DA, "Aktivr RAM-bank 2 og 3"},
/* de */ {IDCLS_ENABLE_C128_FULL_BANKS_DE, "RAM Bnke 2 und 3 aktivieren"},
/* es */ {IDCLS_ENABLE_C128_FULL_BANKS_ES, "Permitir bancos 2 y 3"},
/* fr */ {IDCLS_ENABLE_C128_FULL_BANKS_FR, "Activer les banques RAM 2 et 3"},
/* hu */ {IDCLS_ENABLE_C128_FULL_BANKS_HU, "2-es s 3-as RAM bankok engedlyezse"},
/* it */ {IDCLS_ENABLE_C128_FULL_BANKS_IT, "Attiva banchi RAM 2 e 3"},
/* ko */ {IDCLS_ENABLE_C128_FULL_BANKS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_C128_FULL_BANKS_NL, "RAM bank 2 en 3 inschakelen"},
/* pl */ {IDCLS_ENABLE_C128_FULL_BANKS_PL, "Wcz banki RAM 2 i 3"},
/* ru */ {IDCLS_ENABLE_C128_FULL_BANKS_RU, "Enable RAM banks 2 and 3"},
/* sv */ {IDCLS_ENABLE_C128_FULL_BANKS_SV, "Aktivera RAM-bank 2 och 3"},
/* tr */ {IDCLS_ENABLE_C128_FULL_BANKS_TR, "RAM banklar 2 ve 3' aktif et"},
#endif

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_DISABLE_C128_FULL_BANKS,    N_("Disable RAM banks 2 and 3")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_C128_FULL_BANKS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_C128_FULL_BANKS_DE, "RAM Bnke 2 und 3 deaktivieren"},
/* es */ {IDCLS_DISABLE_C128_FULL_BANKS_ES, "Inhabilitar bancos 2 y 3"},
/* fr */ {IDCLS_DISABLE_C128_FULL_BANKS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_C128_FULL_BANKS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_C128_FULL_BANKS_IT, "Disattiva banchi RAM 2 e 3"},
/* ko */ {IDCLS_DISABLE_C128_FULL_BANKS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_C128_FULL_BANKS_NL, "RAM bank 2 en 3 uitschakelen"},
/* pl */ {IDCLS_DISABLE_C128_FULL_BANKS_PL, "Wycz banki RAM 2 i 3"},
/* ru */ {IDCLS_DISABLE_C128_FULL_BANKS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_C128_FULL_BANKS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_C128_FULL_BANKS_TR, ""},  /* fuzzy */
#endif

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SET_PLUS4_MODEL,    N_("Set Plus4 model (c16/c16pal/c16ntsc, plus4/plus4pal/plus4ntsc, v364/cv364, c232)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_PLUS4_MODEL_DA, "Angiv Plus4-modem (c16/c16pal/c16ntsc, plus4/plus4pal/plus4ntsc, v364/cv364, c232)"},
/* de */ {IDCLS_SET_PLUS4_MODEL_DE, "Setze Plus4 Modell (c16/c16pal/c16ntsc, plus4/plus4pal/plus4ntsc, v364/cv364, c232)"},
/* es */ {IDCLS_SET_PLUS4_MODEL_ES, "Seleccionar Plus4 model (c16/c16pal/c16ntsc, plus4/plus4pal/plus4ntsc, v364/cv364, c232)"},
/* fr */ {IDCLS_SET_PLUS4_MODEL_FR, "Dfinir le modle Plus4 (c16/c16pal/c16ntsc, plus4/plus4pal/plus4ntsc, v364/cv364, c232)"},
/* hu */ {IDCLS_SET_PLUS4_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_PLUS4_MODEL_IT, "Imposta modello Plus4 (c16/c16pal/c16ntsc, plus4/plus4pal/plus4ntsc, v364/cv364, c232)"},
/* ko */ {IDCLS_SET_PLUS4_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_PLUS4_MODEL_NL, "Stel Plus4 model in (c16/c16pal/c16ntsc, plus4/plus4pal/plus4ntsc, v364/cv364, c232)"},
/* pl */ {IDCLS_SET_PLUS4_MODEL_PL, "Ustaw model Plus4 (c16/c16pal/c16ntsc, plus4/plus4pal/plus4ntsc, v364/cv364, c232)"},
/* ru */ {IDCLS_SET_PLUS4_MODEL_RU, "Set Plus4 model (c16/c16pal/c16ntsc, plus4/plus4pal/plus4ntsc, v364/cv364, c232)"},
/* sv */ {IDCLS_SET_PLUS4_MODEL_SV, "Vlj Plus4-modell (c16/c16pal/c16ntsc, plus4/plus4pal/plus4ntsc, v364/cv364, c232)"},
/* tr */ {IDCLS_SET_PLUS4_MODEL_TR, "Plus4 modelini ayarla (c16/c16pal/c16ntsc, plus4/plus4pal/plus4ntsc, v364/cv364, c232)"},
#endif

/* vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_SET_VIC20_MODEL,    N_("Set VIC20 model (vic20/vic20pal/vic20ntsc, vic21)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_VIC20_MODEL_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_VIC20_MODEL_DE, "Whle VIC20 Modell (vic20/vic20pal/vic20ntsc, vic21)"},
/* es */ {IDCLS_SET_VIC20_MODEL_ES, "Seleccionar modelo  VIC20 (vic20/vic20pal/vic20ntsc, vic21)"},
/* fr */ {IDCLS_SET_VIC20_MODEL_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_VIC20_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_VIC20_MODEL_IT, "Imposta modello VIC20 (vic20/vic20pal/vic20ntsc, vic21)"},
/* ko */ {IDCLS_SET_VIC20_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_VIC20_MODEL_NL, "Stel VIC20 model in (vic20/vic20pal/vic20ntsc, vic21)"},
/* pl */ {IDCLS_SET_VIC20_MODEL_PL, "Wybierz model VIC20 (vic20/vic20pal/vic20ntsc, vic21)"},
/* ru */ {IDCLS_SET_VIC20_MODEL_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_VIC20_MODEL_SV, "Vlj VIC20-modell (vic20/vic20pal/vic20ntsc, vic21)"},
/* tr */ {IDCLS_SET_VIC20_MODEL_TR, ""},  /* fuzzy */
#endif

/* c64dtv/c64dtv-cmdline-options.c */
/* en */ {IDCLS_SET_DTV_MODEL,    N_("Set DTV model (v2/v2pal/v2ntsc, v3/v3pal/v3ntsc, hummer)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_DTV_MODEL_DA, "Angiv DTV-model (v2/v2pal/v2ntsc, v3/v3pal/v3ntsc, hummer)"},
/* de */ {IDCLS_SET_DTV_MODEL_DE, "Setze DTV Modell (v2/v2pal/v2ntsc, v3/v3pal/v3ntsc, hummer)"},
/* es */ {IDCLS_SET_DTV_MODEL_ES, "Seleccionar DTV model (v2/v2pal/v2ntsc, v3/v3pal/v3ntsc, hummer)"},
/* fr */ {IDCLS_SET_DTV_MODEL_FR, "Dfinir le modle DTV (v2/v2pal/v2ntsc, v3/v3pal/v3ntsc, hummer)"},
/* hu */ {IDCLS_SET_DTV_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_DTV_MODEL_IT, "Imposta modello DTV (v2/v2pal/v2ntsc, v3/v3pal/v3ntsc, hummer)"},
/* ko */ {IDCLS_SET_DTV_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_DTV_MODEL_NL, "Stel DTV model in (v2/v2pal/v2ntsc, v3/v3pal/v3ntsc, hummer)"},
/* pl */ {IDCLS_SET_DTV_MODEL_PL, "Ustaw model DTV (v2/v2pal/v2ntsc, v3/v3pal/v3ntsc, hummer)"},
/* ru */ {IDCLS_SET_DTV_MODEL_RU, "Set DTV model (v2/v2pal/v2ntsc, v3/v3pal/v3ntsc, hummer)"},
/* sv */ {IDCLS_SET_DTV_MODEL_SV, "Vlj DTV-modell (v2/v2pal/v2ntsc, v3/v3pal/v3ntsc, hummer)"},
/* tr */ {IDCLS_SET_DTV_MODEL_TR, "DTV modelini ayarla (v2/v2pal/v2ntsc, v3/v3pal/v3ntsc, hummer)"},
#endif

/* c64/c64-cmdline-options.c, cbm2/cbm2-cmdline-options.c,
   pet/pet-cmdline-options.c, plus4/plus4-cmdline-options.c,
   vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_KERNAL_ROM_NAME,    N_("Specify name of Kernal ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_KERNAL_ROM_NAME_DA, "Angiv navn p kernal-ROM-image"},
/* de */ {IDCLS_SPECIFY_KERNAL_ROM_NAME_DE, "Name von Kernal ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_KERNAL_ROM_NAME_ES, "Especificar nombre de la imagen ROM Kernal"},
/* fr */ {IDCLS_SPECIFY_KERNAL_ROM_NAME_FR, "Spcifier le nom de l'image ROM Kernal"},
/* hu */ {IDCLS_SPECIFY_KERNAL_ROM_NAME_HU, "Adja meg a Kernal ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_KERNAL_ROM_NAME_IT, "Specifica il nome immagine della ROM del Kernal"},
/* ko */ {IDCLS_SPECIFY_KERNAL_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_KERNAL_ROM_NAME_NL, "Geef de naam van het Kernal ROM bestand"},
/* pl */ {IDCLS_SPECIFY_KERNAL_ROM_NAME_PL, "Okrel nazw obrazu ROM Kernala"},
/* ru */ {IDCLS_SPECIFY_KERNAL_ROM_NAME_RU, "Specify name of Kernal ROM image"},
/* sv */ {IDCLS_SPECIFY_KERNAL_ROM_NAME_SV, "Ange namn p kernal-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_KERNAL_ROM_NAME_TR, "Kernal ROM imajnn ismini belirt"},
#endif

/* scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_SCPU64_ROM_NAME,    N_("Specify name of SCPU64 ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_SCPU64_ROM_NAME_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_SCPU64_ROM_NAME_DE, "Name von SCPU64 ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_SCPU64_ROM_NAME_ES, "Especificar nombre imagen ROM SCPU64"},
/* fr */ {IDCLS_SPECIFY_SCPU64_ROM_NAME_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_SCPU64_ROM_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_SCPU64_ROM_NAME_IT, "Specifica il nome immagine della ROM della SCPU64"},
/* ko */ {IDCLS_SPECIFY_SCPU64_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_SCPU64_ROM_NAME_NL, "Geef de naam van het SCPU64 ROM bestand"},
/* pl */ {IDCLS_SPECIFY_SCPU64_ROM_NAME_PL, "Okrel nazw obrazu ROM SCPU64"},
/* ru */ {IDCLS_SPECIFY_SCPU64_ROM_NAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_SCPU64_ROM_NAME_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_SCPU64_ROM_NAME_TR, ""},  /* fuzzy */
#endif

/* c64/c64-cmdline-options.c, cbm2/cbm2-cmdline-options.c,
   pet/pet-cmdline-options.c, plus4/plus4-cmdline-options.c,
   vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_BASIC_ROM_NAME,    N_("Specify name of BASIC ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_BASIC_ROM_NAME_DA, "Angiv navn p BASIC-ROM-image"},
/* de */ {IDCLS_SPECIFY_BASIC_ROM_NAME_DE, "Name von Basic ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_BASIC_ROM_NAME_ES, "Especificar nombre de la imagen ROM BASIC"},
/* fr */ {IDCLS_SPECIFY_BASIC_ROM_NAME_FR, "Spcifier le nom de l'image BASIC ROM"},
/* hu */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HU, "Adja meg a BASIC ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_BASIC_ROM_NAME_IT, "Specifica il nome immagine della ROM del BASIC"},
/* ko */ {IDCLS_SPECIFY_BASIC_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_BASIC_ROM_NAME_NL, "Geef de naam van het BASIC ROM bestand"},
/* pl */ {IDCLS_SPECIFY_BASIC_ROM_NAME_PL, "Okrel nazw obrazu BASIC ROM"},
/* ru */ {IDCLS_SPECIFY_BASIC_ROM_NAME_RU, "Specify name of BASIC ROM image"},
/* sv */ {IDCLS_SPECIFY_BASIC_ROM_NAME_SV, "Ange namn p BASIC-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_BASIC_ROM_NAME_TR, "BASIC ROM imajnn ismini belirt"},
#endif

/* c64/c64-cmdline-options.c, cbm2/cbm2-cmdline-options.c,
   pet/pet-cmdline-options.c, vic20/vic20-cmdline-options.c,
   scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CHARGEN_ROM_NAME,    N_("Specify name of character generator ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_CHARGEN_ROM_NAME_DA, "Angiv navn p BASIC-ROM-image"},
/* de */ {IDCLS_SPECIFY_CHARGEN_ROM_NAME_DE, "Name von Character ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_CHARGEN_ROM_NAME_ES, "Especificar el nombre de la imagen ROM generador de caracteres"},
/* fr */ {IDCLS_SPECIFY_CHARGEN_ROM_NAME_FR, "Spcifier le nom de l'image du gnrateur de caractres"},
/* hu */ {IDCLS_SPECIFY_CHARGEN_ROM_NAME_HU, "Adja meg a karaktergenertor ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_CHARGEN_ROM_NAME_IT, "Specifica il nome della ROM del generatore di caratteri"},
/* ko */ {IDCLS_SPECIFY_CHARGEN_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_CHARGEN_ROM_NAME_NL, "Geef de naam van het CHARGEN ROM bestand"},
/* pl */ {IDCLS_SPECIFY_CHARGEN_ROM_NAME_PL, "Okrel nazw obrazu ROM tworzenia znakw"},
/* ru */ {IDCLS_SPECIFY_CHARGEN_ROM_NAME_RU, "Specify name of character generator ROM image"},
/* sv */ {IDCLS_SPECIFY_CHARGEN_ROM_NAME_SV, "Ange namn p teckengenerator-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_CHARGEN_ROM_NAME_TR, "Karakter Oluturucu ROM imajnn ismini belirt"},
#endif

#ifdef COMMON_KBD
/* c64/c64-cmdline-options.c, scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2,    N_("Specify index of keymap file (0=sym, 1=symDE, 2=pos)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_DA, "Angiv indeks for tastaturindstillingsfil (0=symbolsk, 1=symbolsk tysk, 2=positionsbestemt)"},
/* de */ {IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_DE, "Index fr Keymap Datei festlegen (0=symbol, 1=symDE, 2=positional)"},
/* es */ {IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_ES, "Especificar ndice fichero mapa teclado (0=sim, 1=simAL, 2=pos)"},
/* fr */ {IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_FR, "Spcifier l'index du fichier keymap (0=sym, 1=symDE, 2=pos)"},
/* hu */ {IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_HU, "Adja meg a billentyzet lekpzsi fjl tpust (0=szimbolikus, 1=nmet szimbolikus, 2=pozci szerinti)"},
/* it */ {IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_IT, "Specifica l'indice del file della mappa della tastiera (0=sim, 1=simGER, 2=pos)"},
/* ko */ {IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_NL, "Geef de index van het toetstoewijzingsbestand (0=sym, 1=symDE, 2=pos)"},
/* pl */ {IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_PL, "Podaj indeks dla ukadu klawiatury (0=symbol, 1=symbolDE, 2=pozycja)"},
/* ru */ {IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_RU, "Specify index of keymap file (0=sym, 1=symDE, 2=pos)"},
/* sv */ {IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_SV, "Ange index fr fr tangentbordsinstllningsfil (0=symbolisk, 1=symbolisk tysk, 2=positionsriktig)"},
/* tr */ {IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_TR, "Tu haritas dosyasnn indeksini belirt (0=sembol, 1=sembol Almanca, 2=konumsal)"},
#endif

/* c64/c64-cmdline-options.c, scpu64/scpu64-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP,    N_("Specify name of symbolic German keymap file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_DA, "Angiv fil for tysk symbolsk tastaturindstilling"},
/* de */ {IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_DE, "Name von symbolischer Keymap Datei whlen"},
/* es */ {IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_ES, "Especificar nombre del fichero teclado simblico alemn"},
/* fr */ {IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_FR, "Spcifier le nom du fichier symbolique de mappage clavier"},
/* hu */ {IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_HU, "Adja meg a nevt a nmet billentyzet lekpzs fjlnak"},
/* it */ {IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_IT, "Specifica il nome del file della mappa simbolica della tastiera tedesca"},
/* ko */ {IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_NL, "Geef de naam van het symbolische Duitse toetstoewijzingsbestand"},
/* pl */ {IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_PL, "Okrel nazw pliku symbolicznego niemieckiego ukadu klawiatury"},
/* ru */ {IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_RU, "Specify name of symbolic German keymap file"},
/* sv */ {IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_SV, "Ange fil fr tysk symbolisk tangentbordsemulering"},
/* tr */ {IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_TR, "Sembolik Almanca tu haritas dosyasnn ismini belirt"},
#endif
#endif

/* c64/c64gluelogic.c */
/* en */ {IDCLS_SET_GLUE_LOGIC_TYPE,    N_("Set glue logic type (0 = discrete, 1 = 252535-01)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_GLUE_LOGIC_TYPE_DA, "Vlg glue logic type (0=diskret, 1=252535-01)"},
/* de */ {IDCLS_SET_GLUE_LOGIC_TYPE_DE, "Setze Glue-Lokig Typ (0 = diskret, 1 = 252535-01)"},
/* es */ {IDCLS_SET_GLUE_LOGIC_TYPE_ES, "Seleccionar tipo de 'glue' lgico (0 = discrete, 1 = 252535-01)"},
/* fr */ {IDCLS_SET_GLUE_LOGIC_TYPE_FR, "Dfinir le type de logique glue (0 = discrte, 1 = 252535-01)"},
/* hu */ {IDCLS_SET_GLUE_LOGIC_TYPE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_GLUE_LOGIC_TYPE_IT, "Imposta il tipo di glue logic (0 = discreta, 1 = 252535-01)"},
/* ko */ {IDCLS_SET_GLUE_LOGIC_TYPE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_GLUE_LOGIC_TYPE_NL, "Stel glue logic type in (0 = discreet, 1 = 252535-01)"},
/* pl */ {IDCLS_SET_GLUE_LOGIC_TYPE_PL, "Ustaw typ glue logic (0 = dyskretna, 1 = 252535-01)"},
/* ru */ {IDCLS_SET_GLUE_LOGIC_TYPE_RU, "Set glue logic type (0 = discrete, 1 = 252535-01)"},
/* sv */ {IDCLS_SET_GLUE_LOGIC_TYPE_SV, "Vlj typ av klisterlogik (0 = diskret, 1 = 252535-01)"},
/* tr */ {IDCLS_SET_GLUE_LOGIC_TYPE_TR, "Glue logic tipini ayarla (0 = balanty kes, 1 = 252535-01)"},
#endif

/* c64dtv/c64dtv-cmdline-options.c */
/* en */ {IDCLS_ENABLE_HUMMER_ADC,    N_("Enable Hummer ADC")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_HUMMER_ADC_DA, "Aktivr Hummer ADC"},
/* de */ {IDCLS_ENABLE_HUMMER_ADC_DE, "Hummer ADC Aktivieren"},
/* es */ {IDCLS_ENABLE_HUMMER_ADC_ES, "Permitir Hummer ADC"},
/* fr */ {IDCLS_ENABLE_HUMMER_ADC_FR, "Activer Hummer ADC"},
/* hu */ {IDCLS_ENABLE_HUMMER_ADC_HU, "Hummer ADC engedlyezse"},
/* it */ {IDCLS_ENABLE_HUMMER_ADC_IT, "Attiva Hummer ADC"},
/* ko */ {IDCLS_ENABLE_HUMMER_ADC_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_HUMMER_ADC_NL, "Hummer ADC inschakelen"},
/* pl */ {IDCLS_ENABLE_HUMMER_ADC_PL, "Wcz Hummer ADC"},
/* ru */ {IDCLS_ENABLE_HUMMER_ADC_RU, "Enable Hummer ADC"},
/* sv */ {IDCLS_ENABLE_HUMMER_ADC_SV, "Aktivera Hummer-A/D-omvandlare"},
/* tr */ {IDCLS_ENABLE_HUMMER_ADC_TR, "Hummer ADC'yi aktif et"},
#endif

/* c64dtv/c64dtv-cmdline-options.c */
/* en */ {IDCLS_DISABLE_HUMMER_ADC,    N_("Disable Hummer ADC")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_HUMMER_ADC_DA, "Deaktivr Hummer ADC"},
/* de */ {IDCLS_DISABLE_HUMMER_ADC_DE, "Hummer ADC deaktivieren"},
/* es */ {IDCLS_DISABLE_HUMMER_ADC_ES, "Deshabilitar Hummer ADC"},
/* fr */ {IDCLS_DISABLE_HUMMER_ADC_FR, "Dsactiver Hummer ADC"},
/* hu */ {IDCLS_DISABLE_HUMMER_ADC_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_HUMMER_ADC_IT, "Disattiva Hummer ADC"},
/* ko */ {IDCLS_DISABLE_HUMMER_ADC_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_HUMMER_ADC_NL, "Hummer ADC uitschakelen"},
/* pl */ {IDCLS_DISABLE_HUMMER_ADC_PL, "Wycz Hummer ADC"},
/* ru */ {IDCLS_DISABLE_HUMMER_ADC_RU, "Disable Hummer ADC"},
/* sv */ {IDCLS_DISABLE_HUMMER_ADC_SV, "Inaktivera Hummer-A/D-omvandlare"},
/* tr */ {IDCLS_DISABLE_HUMMER_ADC_TR, "Hummer ADC'yi pasifletir"},
#endif

/* c64/c64io.c, vic20/vic20io.c */
/* en */ {IDCLS_SELECT_CONFLICT_HANDLING,    N_("Select the way the I/O collisions should be handled, (0: error message and detach all involved carts, 1: error message and detach last attached involved carts, 2: warning in log and 'AND' the valid return values")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SELECT_CONFLICT_HANDLING_DA, "Vlg hvordan I/O-kollisioner skal hndteres (0: fejlbesked og afbryd alle involverede cartridges, 1: fejlbesked og afbryd senest tilsluttede cartridge, 2: Advarsel i log og returner 'logisk OG' af de gyldige returvrdier)"},
/* de */ {IDCLS_SELECT_CONFLICT_HANDLING_DE, "Whle, wie I/O Kollisionen behandelt werden sollen, (0: Fehler Meldung\nund Entfernen smtlicher betroffener Module, 1: Fehler Meldung und\nEntfernen des letzten Moduls, 2: Warnung im Log und liefere logische\nUND-Verknpfung gltiger Rckgabewerte"},
/* es */ {IDCLS_SELECT_CONFLICT_HANDLING_ES, "Seleccionar la forma en que las colisiones deben ser manejadas, (0: mensaje de error y desconectar todas los cartuchos involucrados, 1: mensaje de error y desconectar el ltimo cartucho involucrado, 2: advertencia en  log y 'AND' los valores vlidos de retorno"},
/* fr */ {IDCLS_SELECT_CONFLICT_HANDLING_FR, "Slectionner la faon que les collisions E/S devraient tre traites, (0: message d'erreur et dtachement de toutes les cartouches impliques, 1: message d'erreur et dtachement de la dernire cartouches impliques  avoir t attache, 2: message d'avertissement avec journalisation et 'ET' les valeurs de retour valides"},
/* hu */ {IDCLS_SELECT_CONFLICT_HANDLING_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SELECT_CONFLICT_HANDLING_IT, "Seleziona come gestire le collisioni di I/O, (0: messaggio di errore e rimozione di tutte le cartucce coinvolte, 1: messaggio di errore e rimozione delle ultima cartucce coinvolte, 2: warning nei log e 'AND' il valore di ritorno valido"},
/* ko */ {IDCLS_SELECT_CONFLICT_HANDLING_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SELECT_CONFLICT_HANDLING_NL, "Selecteer de manier waarop I/O conflicten worden afgehandeld, (0: foutmelding en ontkoppel alle betrokken cartridges, 1: foutmelding en ontkoppel alle cartridges behalve de eerste cartridge, 2: waarschuwing in het logbestand en doe een logische 'AND' met de teruggegeven waarden"},
/* pl */ {IDCLS_SELECT_CONFLICT_HANDLING_PL, "Wybierz metod obsugi konfliktw we/wy, (0: komunikat bdu i odczenie wszystkich konfliktujcych kartridw, 1: komunikat bdu i odczenie ostatnio podczonych konfliktujcych kartridw, 2: ostrzeenie w logu i 'AND' waciwe wartoci)"},
/* ru */ {IDCLS_SELECT_CONFLICT_HANDLING_RU, "Select the way the I/O collisions should be handled, (0: error message and detach all involved carts, 1: error message and detach last attached involved carts, 2: warning in log and 'AND' the valid return values"},
/* sv */ {IDCLS_SELECT_CONFLICT_HANDLING_SV, "Vljer hur I/O-kollisioner skall hanteras, (0: felmeddelande och koppla frn alla inblandade moduler, 1: felmeddelande och koppla frn sist anslutna inblandade modul, 2: varning i logg och logisk OCH p giltiga returvrden)"},
/* tr */ {IDCLS_SELECT_CONFLICT_HANDLING_TR, "G/ akmalarnn deerlendirilme yntemini se, (0: hata mesaj ve tm ilgili cihazlarn karlmas, 1: hata mesaj ve en son taklm tm ilgili cihazlarn karlmas, 2: log'a uyar yazlmas ve geerli dn deerlerinin 'VE'lenmesi"},
#endif

/* userport/userport.c */
/* en */ {IDCLS_SELECT_USERPORT_CONFLICT_HANDLING,    N_("Select the way the Userport collisions should be handled, (0: error message and detach all involved devices, 1: error message and detach last attached involved device, 2: warning in log and 'AND' the valid return values")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SELECT_USERPORT_CONFLICT_HANDLING_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SELECT_USERPORT_CONFLICT_HANDLING_DE, "Whle, wie Userport Kollisionen behandelt werden sollen, (0: Fehler Meldung\nund Entfernen smtlicher betroffener Gerte, 1: Fehler Meldung und\nEntfernen des letzten Gerts, 2: Warnung im Log und liefere logische\nUND-Verknpfung gltiger Rckgabewerte"},
/* es */ {IDCLS_SELECT_USERPORT_CONFLICT_HANDLING_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SELECT_USERPORT_CONFLICT_HANDLING_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SELECT_USERPORT_CONFLICT_HANDLING_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SELECT_USERPORT_CONFLICT_HANDLING_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SELECT_USERPORT_CONFLICT_HANDLING_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SELECT_USERPORT_CONFLICT_HANDLING_NL, "Selecteer de manier waarop userport conflicten worden afgehandeld, (0: foutmelding en ontkoppel alle betrokken apparaten, 1: foutmelding en ontkoppel alle apparaten behalve het eerste apparaat, 2: waarschuwing in het logbestand en doe een logische 'AND' met de teruggegeven waarden"},
/* pl */ {IDCLS_SELECT_USERPORT_CONFLICT_HANDLING_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_SELECT_USERPORT_CONFLICT_HANDLING_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SELECT_USERPORT_CONFLICT_HANDLING_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SELECT_USERPORT_CONFLICT_HANDLING_TR, ""},  /* fuzzy */
#endif

/* c64/cart/c64tpi.c */
/* en */ {IDCLS_ENABLE_IEEE488_INTERFACE,    N_("Enable the IEEE488 interface emulation")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_IEEE488_INTERFACE_DA, "Aktivr emulering af IEEE488-interface"},
/* de */ {IDCLS_ENABLE_IEEE488_INTERFACE_DE, "IEEE488 Schnittstellen-Emulation aktivieren"},
/* es */ {IDCLS_ENABLE_IEEE488_INTERFACE_ES, "Permitir emulacin interface IEEE488"},
/* fr */ {IDCLS_ENABLE_IEEE488_INTERFACE_FR, "Activer l'interface d'mulation IEEE488"},
/* hu */ {IDCLS_ENABLE_IEEE488_INTERFACE_HU, "IEEE488 interfsz emulci engedlyezse"},
/* it */ {IDCLS_ENABLE_IEEE488_INTERFACE_IT, "Attiva emulazione interfaccia IEEE488"},
/* ko */ {IDCLS_ENABLE_IEEE488_INTERFACE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_IEEE488_INTERFACE_NL, "IEEE488 interface emulatie inschakelen"},
/* pl */ {IDCLS_ENABLE_IEEE488_INTERFACE_PL, "Wcz emulacj interfejsu IEEE488"},
/* ru */ {IDCLS_ENABLE_IEEE488_INTERFACE_RU, "Enable the IEEE488 interface emulation"},
/* sv */ {IDCLS_ENABLE_IEEE488_INTERFACE_SV, "Aktivera emulering av IEEE488-grnssnitt"},
/* tr */ {IDCLS_ENABLE_IEEE488_INTERFACE_TR, "IEEE488 arabirim emlasyonunu aktif et"},
#endif

/* c64/cart/c64tpi.c */
/* en */ {IDCLS_DISABLE_IEEE488_INTERFACE,    N_("Disable the IEEE488 interface emulation")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_IEEE488_INTERFACE_DA, "Deaktivr emulering af IEEE488-interface"},
/* de */ {IDCLS_DISABLE_IEEE488_INTERFACE_DE, "IEEE488 Schnittstellen-Emulation deaktivieren"},
/* es */ {IDCLS_DISABLE_IEEE488_INTERFACE_ES, "Deshabilitar emulacin interface IEEE488"},
/* fr */ {IDCLS_DISABLE_IEEE488_INTERFACE_FR, "Dsactiver l'interface d'mulation IEEE488"},
/* hu */ {IDCLS_DISABLE_IEEE488_INTERFACE_HU, "IEEE488 interfsz emulci tiltsa"},
/* it */ {IDCLS_DISABLE_IEEE488_INTERFACE_IT, "Disattiva emulazione interfaccia IEEE488"},
/* ko */ {IDCLS_DISABLE_IEEE488_INTERFACE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_IEEE488_INTERFACE_NL, "IEEE488 interface emulatie uitschakelen"},
/* pl */ {IDCLS_DISABLE_IEEE488_INTERFACE_PL, "Wycz emulacj interfejsu IEEE488"},
/* ru */ {IDCLS_DISABLE_IEEE488_INTERFACE_RU, "Disable the IEEE488 interface emulation"},
/* sv */ {IDCLS_DISABLE_IEEE488_INTERFACE_SV, "Inaktivera emulering av IEEE488-grnssnitt"},
/* tr */ {IDCLS_DISABLE_IEEE488_INTERFACE_TR, "IEEE488 arabirim emlasyonunu pasifletir"},
#endif

/* c64/cart/c64tpi.c */
/* en */ {IDCLS_SPECIFY_IEEE488_INTERFACE_NAME,    N_("specify IEEE488 interface image name")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_IEEE488_INTERFACE_NAME_DA, "angiv IEEE488-interface image navn"},
/* de */ {IDCLS_SPECIFY_IEEE488_INTERFACE_NAME_DE, "IEEE488 Schnittstellenmodul Imagename"},
/* es */ {IDCLS_SPECIFY_IEEE488_INTERFACE_NAME_ES, "Especificar nombre imagen interface IEEE488"},
/* fr */ {IDCLS_SPECIFY_IEEE488_INTERFACE_NAME_FR, "spcifier le nom de l'image d'interface IEEE-488"},
/* hu */ {IDCLS_SPECIFY_IEEE488_INTERFACE_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_IEEE488_INTERFACE_NAME_IT, "specifica il nome immagine dell'interfaccia IEEE488"},
/* ko */ {IDCLS_SPECIFY_IEEE488_INTERFACE_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_IEEE488_INTERFACE_NAME_NL, "Geef de naam van het IEEE488 interface bestand"},
/* pl */ {IDCLS_SPECIFY_IEEE488_INTERFACE_NAME_PL, "Okrel nazw obrazu interfejsu IEEE488"},
/* ru */ {IDCLS_SPECIFY_IEEE488_INTERFACE_NAME_RU, "specify IEEE488 interface image name"},
/* sv */ {IDCLS_SPECIFY_IEEE488_INTERFACE_NAME_SV, "ange namn p IEEE488-grnssnittsfil"},
/* tr */ {IDCLS_SPECIFY_IEEE488_INTERFACE_NAME_TR, "IEEE488 arabirimi imaj ismini belirleyin"},
#endif

/* samplerdrv/file_drv.c */
/* en */ {IDCLS_SPECIFY_SAMPLE_NAME,    N_("Specify name of sample file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_SAMPLE_NAME_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_SAMPLE_NAME_DE, "Namen fr Sample Datei whlen"},
/* es */ {IDCLS_SPECIFY_SAMPLE_NAME_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SPECIFY_SAMPLE_NAME_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_SAMPLE_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_SAMPLE_NAME_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SPECIFY_SAMPLE_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_SAMPLE_NAME_NL, "Geef naam van het samplebestand"},
/* pl */ {IDCLS_SPECIFY_SAMPLE_NAME_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_SPECIFY_SAMPLE_NAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_SAMPLE_NAME_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_SAMPLE_NAME_TR, ""},  /* fuzzy */
#endif

/* tapeport/tape_diag_586220_harness.c */
/* en */ {IDCLS_ENABLE_TAPE_DIAG_586220_HARNESS,    N_("Enable the tape part of the 586220 diagnostics harness")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_TAPE_DIAG_586220_HARNESS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_TAPE_DIAG_586220_HARNESS_DE, "586220 Diagnose Harness fr Bandteil aktivieren"},
/* es */ {IDCLS_ENABLE_TAPE_DIAG_586220_HARNESS_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_TAPE_DIAG_586220_HARNESS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_TAPE_DIAG_586220_HARNESS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_TAPE_DIAG_586220_HARNESS_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_TAPE_DIAG_586220_HARNESS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_TAPE_DIAG_586220_HARNESS_NL, "Tape onderdeel van de 586220 diagnostics gareel inschakelen"},
/* pl */ {IDCLS_ENABLE_TAPE_DIAG_586220_HARNESS_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_TAPE_DIAG_586220_HARNESS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_TAPE_DIAG_586220_HARNESS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_TAPE_DIAG_586220_HARNESS_TR, ""},  /* fuzzy */
#endif

/* tapeport/tape_diag_586220_harness.c */
/* en */ {IDCLS_DISABLE_TAPE_DIAG_586220_HARNESS,    N_("Disable the tape part of the 586220 diagnostics harness")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_TAPE_DIAG_586220_HARNESS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_TAPE_DIAG_586220_HARNESS_DE, "586220 Diagnose Harness fr Bandteil deaktivieren"},
/* es */ {IDCLS_DISABLE_TAPE_DIAG_586220_HARNESS_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_TAPE_DIAG_586220_HARNESS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_TAPE_DIAG_586220_HARNESS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_TAPE_DIAG_586220_HARNESS_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_TAPE_DIAG_586220_HARNESS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_TAPE_DIAG_586220_HARNESS_NL, "Tape onderdeel van de 586220 diagnostics gareel uitschakelen"},
/* pl */ {IDCLS_DISABLE_TAPE_DIAG_586220_HARNESS_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_TAPE_DIAG_586220_HARNESS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_TAPE_DIAG_586220_HARNESS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_TAPE_DIAG_586220_HARNESS_TR, ""},  /* fuzzy */
#endif

/* tapeport/tapelog.c */
/* en */ {IDCLS_ENABLE_TAPELOG,    N_("Enable the tape log device")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_TAPELOG_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_TAPELOG_DE, "Bandlog Gert aktivieren"},
/* es */ {IDCLS_ENABLE_TAPELOG_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_TAPELOG_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_TAPELOG_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_TAPELOG_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_TAPELOG_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_TAPELOG_NL, "Tape log apparaat inschakelen"},
/* pl */ {IDCLS_ENABLE_TAPELOG_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_TAPELOG_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_TAPELOG_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_TAPELOG_TR, ""},  /* fuzzy */
#endif

/* tapeport/tapelog.c */
/* en */ {IDCLS_DISABLE_TAPELOG,    N_("Disable the tape log device")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_TAPELOG_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_TAPELOG_DE, "Bandlog Gert deaktivieren"},
/* es */ {IDCLS_DISABLE_TAPELOG_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_TAPELOG_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_TAPELOG_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_TAPELOG_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_TAPELOG_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_TAPELOG_NL, "Tape log apparaat uitschakelen"},
/* pl */ {IDCLS_DISABLE_TAPELOG_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_TAPELOG_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_TAPELOG_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_TAPELOG_TR, ""},  /* fuzzy */
#endif

/* tapeport/tapelog.c */
/* en */ {IDCLS_ENABLE_TAPELOG_LOG_TO_FILE,    N_("Enable logging to a file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_TAPELOG_LOG_TO_FILE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_TAPELOG_LOG_TO_FILE_DE, "Logging auf Datei aktivieren"},
/* es */ {IDCLS_ENABLE_TAPELOG_LOG_TO_FILE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_TAPELOG_LOG_TO_FILE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_TAPELOG_LOG_TO_FILE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_TAPELOG_LOG_TO_FILE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_TAPELOG_LOG_TO_FILE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_TAPELOG_LOG_TO_FILE_NL, "Logboekvermeldingen schrijven naar een bestand inschakelen"},
/* pl */ {IDCLS_ENABLE_TAPELOG_LOG_TO_FILE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_TAPELOG_LOG_TO_FILE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_TAPELOG_LOG_TO_FILE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_TAPELOG_LOG_TO_FILE_TR, ""},  /* fuzzy */
#endif

/* tapeport/tapelog.c */
/* en */ {IDCLS_ENABLE_TAPELOG_LOG_TO_LOG,    N_("Enable logging to the emulator log file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_TAPELOG_LOG_TO_LOG_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_TAPELOG_LOG_TO_LOG_DE, "Logging auf Emaulatorlogdatei aktivieren"},
/* es */ {IDCLS_ENABLE_TAPELOG_LOG_TO_LOG_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_TAPELOG_LOG_TO_LOG_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_TAPELOG_LOG_TO_LOG_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_TAPELOG_LOG_TO_LOG_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_TAPELOG_LOG_TO_LOG_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_TAPELOG_LOG_TO_LOG_NL, "Schrijven naar het emulator log bestand inschakelen"},
/* pl */ {IDCLS_ENABLE_TAPELOG_LOG_TO_LOG_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_TAPELOG_LOG_TO_LOG_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_TAPELOG_LOG_TO_LOG_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_TAPELOG_LOG_TO_LOG_TR, ""},  /* fuzzy */
#endif

/* tapeport/tapelog.c */
/* en */ {IDCLS_SPECIFY_TAPELOG_NAME,    N_("Specify tape log file name")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_TAPELOG_NAME_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_TAPELOG_NAME_DE, "Bandlogdateiname auswhlen"},
/* es */ {IDCLS_SPECIFY_TAPELOG_NAME_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SPECIFY_TAPELOG_NAME_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_TAPELOG_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_TAPELOG_NAME_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SPECIFY_TAPELOG_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_TAPELOG_NAME_NL, "Geef de naam van het tape logbestand"},
/* pl */ {IDCLS_SPECIFY_TAPELOG_NAME_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_SPECIFY_TAPELOG_NAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_TAPELOG_NAME_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_TAPELOG_NAME_TR, ""},  /* fuzzy */
#endif

/* c64/cart/georam.c */
/* en */ {IDCLS_ENABLE_GEORAM,    N_("Enable the GEO-RAM expansion unit")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_GEORAM_DA, "Aktivr GEO-RAM-udviddelsesenheden"},
/* de */ {IDCLS_ENABLE_GEORAM_DE, "GEO-RAM Erweiterung aktivieren"},
/* es */ {IDCLS_ENABLE_GEORAM_ES, "Permitir unidad expansin GEO-RAM"},
/* fr */ {IDCLS_ENABLE_GEORAM_FR, "Activer l'unit d'expansion GEO-RAM"},
/* hu */ {IDCLS_ENABLE_GEORAM_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_GEORAM_IT, "Attiva l'espansione GEO-RAM"},
/* ko */ {IDCLS_ENABLE_GEORAM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_GEORAM_NL, "GEO-RAM uitbreidingseenheid inschakelen"},
/* pl */ {IDCLS_ENABLE_GEORAM_PL, "Wcz jednostk rozszerzenia GEO-RAM"},
/* ru */ {IDCLS_ENABLE_GEORAM_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_GEORAM_SV, "Aktivera GEORAM-expansionsenhet"},
/* tr */ {IDCLS_ENABLE_GEORAM_TR, "GEO-RAM geniletme birimini aktif et"},
#endif

/* c64/cart/georam.c */
/* en */ {IDCLS_DISABLE_GEORAM,    N_("Disable the GEO-RAM expansion unit")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_GEORAM_DA, "Deaktivr GEO-RAM-udviddelsesenhed"},
/* de */ {IDCLS_DISABLE_GEORAM_DE, "GEO-RAM Erweiterung deaktivieren"},
/* es */ {IDCLS_DISABLE_GEORAM_ES, "Deshabilitar unidad expansin GEO-RAM"},
/* fr */ {IDCLS_DISABLE_GEORAM_FR, "Dsactiver l'unit d'expansion GEO-RAM"},
/* hu */ {IDCLS_DISABLE_GEORAM_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_GEORAM_IT, "Disattiva l'espansione GEO-RAM"},
/* ko */ {IDCLS_DISABLE_GEORAM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_GEORAM_NL, "GEO-RAM uitbreidingseenheid uitschakelen"},
/* pl */ {IDCLS_DISABLE_GEORAM_PL, "Wycz jednostk rozszerzenia GEO-RAM"},
/* ru */ {IDCLS_DISABLE_GEORAM_RU, "  GEORAM"},
/* sv */ {IDCLS_DISABLE_GEORAM_SV, "Inaktivera GEO RAM-expansionsenhet"},
/* tr */ {IDCLS_DISABLE_GEORAM_TR, "GEO-RAM geniletme birimini pasifletir"},
#endif

/* c64/cart/georam.c */
/* en */ {IDCLS_SPECIFY_GEORAM_NAME,    N_("Specify name of GEORAM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_GEORAM_NAME_DA, "Angiv navn p GEORAM-image"},
/* de */ {IDCLS_SPECIFY_GEORAM_NAME_DE, "GEORAM Imagedatei whlen"},
/* es */ {IDCLS_SPECIFY_GEORAM_NAME_ES, "Especificar nombre imagen GEORAM"},
/* fr */ {IDCLS_SPECIFY_GEORAM_NAME_FR, "Spcifier le nom de l'image GEO-RAM"},
/* hu */ {IDCLS_SPECIFY_GEORAM_NAME_HU, "Adja meg a GEORAM kpms nevt"},
/* it */ {IDCLS_SPECIFY_GEORAM_NAME_IT, "Specifica il nome immagine GEORAM"},
/* ko */ {IDCLS_SPECIFY_GEORAM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_GEORAM_NAME_NL, "Geef de naam van het GEORAM bestand"},
/* pl */ {IDCLS_SPECIFY_GEORAM_NAME_PL, "Okrel nazw obrazu GEORAM"},
/* ru */ {IDCLS_SPECIFY_GEORAM_NAME_RU, "Specify name of GEORAM image"},
/* sv */ {IDCLS_SPECIFY_GEORAM_NAME_SV, "Ange namn p GEORAM-avbildning"},
/* tr */ {IDCLS_SPECIFY_GEORAM_NAME_TR, "GEORAM imajnn ismini belirt"},
#endif

/* c64/cart/georam.c */
/* en */ {IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE,    N_("Allow writing to GEORAM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE_DA, "Tillad skrivning til GEORAM-image."},
/* de */ {IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE_DE, "Schreibzugriff auf GEORAM Image erlauben"},
/* es */ {IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE_ES, "Permitir grabacin sobre imagen GEORAM"},
/* fr */ {IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE_FR, "Permettre l'criture sur l'image GEO-RAM"},
/* hu */ {IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE_IT, "Attiva la scrittura su immagine GEORAM"},
/* ko */ {IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE_NL, "Schrijven naar GEORAM bestand toestaan"},
/* pl */ {IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE_PL, "Pozwl na zapis do obrazu GEORAM"},
/* ru */ {IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE_RU, "Allow writing to GEORAM image"},
/* sv */ {IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE_SV, "Tillt skrivning till GEORAM-avbildning"},
/* tr */ {IDCLS_ALLOW_WRITING_TO_GEORAM_IMAGE_TR, "GEORAM imajna yazmay aktif et"},
#endif

/* c64/cart/georam.c */
/* en */ {IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE,    N_("Do not write to GEORAM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE_DA, "Skriv ikke til GEORAM-image"},
/* de */ {IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE_DE, "Kein Schreibzugriff auf GEORAM Image"},
/* es */ {IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE_ES, "No grabar en imagen GEORAM"},
/* fr */ {IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE_FR, "Ne pas crire sur l'image GEO-RAM"},
/* hu */ {IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE_IT, "Disattiva la scrittura su immagine GEORAM"},
/* ko */ {IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE_NL, "Schrijf niet naar GEORAM bestand"},
/* pl */ {IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE_PL, "Nie zapisuj do obrazu GEORAM"},
/* ru */ {IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE_RU, "Do not write to GEORAM image"},
/* sv */ {IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE_SV, "Skriv inte till GEORAM-avbildning"},
/* tr */ {IDCLS_DO_NOT_WRITE_TO_GEORAM_IMAGE_TR, "GEORAM imajna yazma"},
#endif

/* c64/cart/georam.c */
/* en */ {IDCLS_SWAP_CART_IO,    N_("Swap io mapping (map cart I/O-1 to VIC20 I/O-3 and cart I/O-2 to VIC20 I/O-2)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SWAP_CART_IO_DA, "Ombyt I/O-forbindelse (forbind cart I/O-1 til VIC20 I/O-3 og cart I/O-2 til VIC20 I/O-2)"},
/* de */ {IDCLS_SWAP_CART_IO_DE, "Vertausche IO Zuordnung (cart I/O-1 auf VIC20 I/O-3 und cart I/O-2 auf VIC20 I/O-2)"},
/* es */ {IDCLS_SWAP_CART_IO_ES, "Intercambiar mapeado IO (map cart I/O-1 to VIC20 I/O-3 and cart I/O-2 to VIC20 I/O-2)"},
/* fr */ {IDCLS_SWAP_CART_IO_FR, "changer le mappage E/S (mapper I/O-1 cartouche  I/O-3 VIC20 et I/O-2 cartouche  I/O-2 VIC20)"},
/* hu */ {IDCLS_SWAP_CART_IO_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SWAP_CART_IO_IT, "Scambia mapping di I/O (mappa I/O-1 cart su I/O-3 VIC20 e I/O-2 cart su I/O-2 VIC20)"},
/* ko */ {IDCLS_SWAP_CART_IO_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SWAP_CART_IO_NL, "Verwissel de io toewijzing (verwijs cart I/O-1 naar VIC20 I/O-3 en cart I/O-2 naar VIC20 I/O-2)"},
/* pl */ {IDCLS_SWAP_CART_IO_PL, "Zamie mapowanie we/wy (mapuj  we/wy-1  kartrida do we/wy-3 VIC20 i we/wy-2 kartida do we/wy-2 VIC20)"},
/* ru */ {IDCLS_SWAP_CART_IO_RU, "Swap io mapping (map cart I/O-1 to VIC20 I/O-3 and cart I/O-2 to VIC20 I/O-2)"},
/* sv */ {IDCLS_SWAP_CART_IO_SV, "Vxla io-mappning (mappa modul-I/O 1 till VIC20-I/O 3 och modul-I/O 2 till VIC20-I/O 2)"},
/* tr */ {IDCLS_SWAP_CART_IO_TR, "G/ haritalamasn yer deitir (harita kart G/-1 ile VIC20 G/-3 ve kart G/-2 ile VIC20 G/-2)"},
#endif

/* c64/cart/georam.c */
/* en */ {IDCLS_DONT_SWAP_CART_IO,    N_("Don't swap io mapping (map cart I/O-1 to VIC20 I/O-2 and cart I/O-2 to VIC20 I/O-3)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DONT_SWAP_CART_IO_DA, "Ombyt ikke I/O-forbindelse (forbind cart I/O-1 til VIC20 I/O-2 og cart I/O-2 til VIC20 I/O-3)"},
/* de */ {IDCLS_DONT_SWAP_CART_IO_DE, "Keine Vertauschung der IO Zuordnung (cart I/O-1 auf VIC20 I/O-2 und cart I/O-2 auf VIC20 I/O-3)"},
/* es */ {IDCLS_DONT_SWAP_CART_IO_ES, "No intercambiar mapeado IO (map cart I/O-1 to VIC20 I/O-2 and cart I/O-2 to VIC20 I/O-3)"},
/* fr */ {IDCLS_DONT_SWAP_CART_IO_FR, "Ne pas changer le mappage E/S (mapper I/O-1 cartouche  I/O-2 VIC20 et I/O-2 cartouche  I/O-3 VIC20)"},
/* hu */ {IDCLS_DONT_SWAP_CART_IO_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DONT_SWAP_CART_IO_IT, "Non scambiare mapping di I/O (mappa I/O-1 cart su I/O-2 VIC20 e I/O-2 cart su I/O-3 VIC20)"},
/* ko */ {IDCLS_DONT_SWAP_CART_IO_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DONT_SWAP_CART_IO_NL, "Verwissel de io toewijzing niet (verwijs cart I/O-1 naar VIC20 I/O-2 en cart I/O-2 naar VIC20 I/O-3)"},
/* pl */ {IDCLS_DONT_SWAP_CART_IO_PL, "Nie zamieniaj mapowania we/wy (mapuj  we/wy-1  kartrida do we/wy-2 VIC20 i we/wy-2 kartida do we/wy-3 VIC20)"},
/* ru */ {IDCLS_DONT_SWAP_CART_IO_RU, "Don't swap io mapping (map cart I/O-1 to VIC20 I/O-2 and cart I/O-2 to VIC20 I/O-3)"},
/* sv */ {IDCLS_DONT_SWAP_CART_IO_SV, "Vxla inte io-mappning (mappa modul-I/O 1 till VIC20-I/O 2 och modul-I/O 2 till VIC20-I/O 3)"},
/* tr */ {IDCLS_DONT_SWAP_CART_IO_TR, "G/ haritalamasn yer deitirme (harita kart G/-1 ile VIC20 G/-2 ve kart G/-2 ile VIC20 G/-3)"},
#endif

/* c64/cart/sfx_soundexpander.c, c64/cart/sfx_soundsampler.c */
/* en */ {IDCLS_MAP_CART_IO_2,    N_("Swap io mapping (map cart I/O to VIC20 I/O-2)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MAP_CART_IO_2_DA, "Ombyt I/O-forbindelse (forbind cart I/O til VIC20 I/O-2)"},
/* de */ {IDCLS_MAP_CART_IO_2_DE, "Vertausche IO Zuordnung (cart I/O auf VIC20 I/O-2)"},
/* es */ {IDCLS_MAP_CART_IO_2_ES, "Intercambiar mapeado IO (map cart I/O to VIC20 I/O-2)"},
/* fr */ {IDCLS_MAP_CART_IO_2_FR, "changer le mappage E/S (mapper I/O cartouche  I/O-2 VIC20)"},
/* hu */ {IDCLS_MAP_CART_IO_2_HU, ""},  /* fuzzy */
/* it */ {IDCLS_MAP_CART_IO_2_IT, "Scambia mapping di I/O (mappa I/O cart su I/O-2 VIC20)"},
/* ko */ {IDCLS_MAP_CART_IO_2_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_MAP_CART_IO_2_NL, "Verwissel de io toewijzing (verwijs cart I/O naar VIC20 I/O-2)"},
/* pl */ {IDCLS_MAP_CART_IO_2_PL, "Zamie mapowanie we/wy (mapuj  we/wy  kartrida do we/wy-2 VIC20)"},
/* ru */ {IDCLS_MAP_CART_IO_2_RU, "Swap io mapping (map cart I/O to VIC20 I/O-2)"},
/* sv */ {IDCLS_MAP_CART_IO_2_SV, "Vxla io-mappning (mappa modul-I/O till VIC20-I/O 2)"},
/* tr */ {IDCLS_MAP_CART_IO_2_TR, "G/ haritalamasn yer deitir (harita kart G/ ile VIC20 G/-2)"},
#endif

/* c64/cart/sfx_soundexpander.c, c64/cart/sfx_soundsampler.c */
/* en */ {IDCLS_MAP_CART_IO_3,    N_("Don't swap io mapping (map cart I/O to VIC20 I/O-3)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MAP_CART_IO_3_DA, "Ombyt ikke I/O-forbindelse (forbind cart I/O til VIC20 I/O-3)"},
/* de */ {IDCLS_MAP_CART_IO_3_DE, "Keine Vertauschung der IO Zuordnung (cart I/O auf VIC20 I/O-3)"},
/* es */ {IDCLS_MAP_CART_IO_3_ES, "No intercambia mapeado IO (map cart I/O to VIC20 I/O-3)"},
/* fr */ {IDCLS_MAP_CART_IO_3_FR, "Ne pas changer le mappage E/S (mapper I/O cartouche  I/O-3 VIC20)"},
/* hu */ {IDCLS_MAP_CART_IO_3_HU, ""},  /* fuzzy */
/* it */ {IDCLS_MAP_CART_IO_3_IT, "Non scambiare mapping di I/O (mappa I/O cart su I/O-3 VIC20)"},
/* ko */ {IDCLS_MAP_CART_IO_3_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_MAP_CART_IO_3_NL, "Verwissel de io toewijzing niet (verwijs cart I/O naar VIC20 I/O-3)"},
/* pl */ {IDCLS_MAP_CART_IO_3_PL, "Nie zamieniaj mapowania we/wy (mapuj  we/wy  kartrida do we/wy-3 VIC20)"},
/* ru */ {IDCLS_MAP_CART_IO_3_RU, "Don't swap io mapping (map cart I/O to VIC20 I/O-3)"},
/* sv */ {IDCLS_MAP_CART_IO_3_SV, "Vxla io-mappning (mappa modul-I/O till VIC20-I/O 3)"},
/* tr */ {IDCLS_MAP_CART_IO_3_TR, "G/ haritalamasn yer deitirme (harita kart G/ ile VIC20 G/-3)"},
#endif

/* c64/cart/georam.c, c64/cart/ramcart.c, c64/cart/reu.c, pet/petreu.c */
/* en */ {IDCLS_P_SIZE_IN_KB,    N_("<size in KB>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_SIZE_IN_KB_DA, "<strrelse i kB>"},
/* de */ {IDCLS_P_SIZE_IN_KB_DE, "<Gre in KB>"},
/* es */ {IDCLS_P_SIZE_IN_KB_ES, "<tamao en KB>"},
/* fr */ {IDCLS_P_SIZE_IN_KB_FR, "<taille en ko>"},
/* hu */ {IDCLS_P_SIZE_IN_KB_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_SIZE_IN_KB_IT, "<dimensione in KB>"},
/* ko */ {IDCLS_P_SIZE_IN_KB_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_SIZE_IN_KB_NL, "<grootte in KB>"},
/* pl */ {IDCLS_P_SIZE_IN_KB_PL, "<rozmiar w KB>"},
/* ru */ {IDCLS_P_SIZE_IN_KB_RU, "<  >"},
/* sv */ {IDCLS_P_SIZE_IN_KB_SV, "<storlek i KB>"},
/* tr */ {IDCLS_P_SIZE_IN_KB_TR, "<KB cinsinden boyut>"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_P_SIZE,    N_("<size>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_SIZE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_P_SIZE_DE, "<Gre>"},
/* es */ {IDCLS_P_SIZE_ES, "<Tamao>"},
/* fr */ {IDCLS_P_SIZE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_P_SIZE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_SIZE_IT, "<dimensione>"},
/* ko */ {IDCLS_P_SIZE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_SIZE_NL, "<grootte>"},
/* pl */ {IDCLS_P_SIZE_PL, "<wielko>"},
/* ru */ {IDCLS_P_SIZE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_P_SIZE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_P_SIZE_TR, ""},  /* fuzzy */
#endif

/* pet/pet-sidcart.c */
/* en */ {IDCLS_P_ADDRESS,    N_("<address>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_ADDRESS_DA, "<adresse>"},
/* de */ {IDCLS_P_ADDRESS_DE, "<Adresse>"},
/* es */ {IDCLS_P_ADDRESS_ES, "<direccin>"},
/* fr */ {IDCLS_P_ADDRESS_FR, "<adresse>"},
/* hu */ {IDCLS_P_ADDRESS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_ADDRESS_IT, "<indirizzo>"},
/* ko */ {IDCLS_P_ADDRESS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_ADDRESS_NL, "<adres>"},
/* pl */ {IDCLS_P_ADDRESS_PL, "<address>"},
/* ru */ {IDCLS_P_ADDRESS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_P_ADDRESS_SV, "<adress>"},
/* tr */ {IDCLS_P_ADDRESS_TR, "<adres>"},
#endif

/* pet/pet-sidcart.c */
/* en */ {IDCLS_P_CLOCK,    N_("<clock>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_CLOCK_DA, ""},  /* fuzzy */
/* de */ {IDCLS_P_CLOCK_DE, "<Takt>"},
/* es */ {IDCLS_P_CLOCK_ES, "<Reloj>"},
/* fr */ {IDCLS_P_CLOCK_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_P_CLOCK_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_CLOCK_IT, "<clock>"},
/* ko */ {IDCLS_P_CLOCK_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_CLOCK_NL, "<klok>"},
/* pl */ {IDCLS_P_CLOCK_PL, "<zegar>"},
/* ru */ {IDCLS_P_CLOCK_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_P_CLOCK_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_P_CLOCK_TR, ""},  /* fuzzy */
#endif

/* c64/cart/georam.c */
/* en */ {IDCLS_GEORAM_SIZE,    N_("Size of the GEORAM expansion unit")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_GEORAM_SIZE_DA, "Strrelse af GEORAM-udviddelsesenhed"},
/* de */ {IDCLS_GEORAM_SIZE_DE, "Gre der GEORAM Erweiterung"},
/* es */ {IDCLS_GEORAM_SIZE_ES, "Tamao de la unidad expansin GEORAM"},
/* fr */ {IDCLS_GEORAM_SIZE_FR, "Taille de l'unit d'expansion GEO-RAM"},
/* hu */ {IDCLS_GEORAM_SIZE_HU, "GEORAM Expansion Unit mrete"},
/* it */ {IDCLS_GEORAM_SIZE_IT, "Dimensione dell'espansione GEORAM"},
/* ko */ {IDCLS_GEORAM_SIZE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_GEORAM_SIZE_NL, "Grootte van de GEORAM uitbreidingseenheid"},
/* pl */ {IDCLS_GEORAM_SIZE_PL, "Rozmiar jednostki rozszerzenia GEORAM"},
/* ru */ {IDCLS_GEORAM_SIZE_RU, "Size of the GEORAM expansion unit"},
/* sv */ {IDCLS_GEORAM_SIZE_SV, "Storlek p GEORAM-expansionsenhet"},
/* tr */ {IDCLS_GEORAM_SIZE_TR, "GEORAM geniletme biriminin boyutu"},
#endif

/* pet/petreu.c */
/* en */ {IDCLS_ENABLE_PETREU,    N_("Enable the PET Ram and Expansion Unit")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_PETREU_DA, "Aktivr PET REU"},
/* de */ {IDCLS_ENABLE_PETREU_DE, "PET RAM Speicher und Erweiterungsmodul aktivieren"},
/* es */ {IDCLS_ENABLE_PETREU_ES, "Permitir PET ram y Unidad Expansin"},
/* fr */ {IDCLS_ENABLE_PETREU_FR, "Activer l'expansion d'unit et de RAM du PET"},
/* hu */ {IDCLS_ENABLE_PETREU_HU, "PET RAM and Expansion Unit engedlyezse"},
/* it */ {IDCLS_ENABLE_PETREU_IT, "Attiva la RAM e l'unit di espansione del PET"},
/* ko */ {IDCLS_ENABLE_PETREU_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_PETREU_NL, "PET RAM en uitbreidingseenheid inschakelen"},
/* pl */ {IDCLS_ENABLE_PETREU_PL, "Wcz PET Ram i Expansion Unit"},
/* ru */ {IDCLS_ENABLE_PETREU_RU, "Enable the PET Ram and Expansion Unit"},
/* sv */ {IDCLS_ENABLE_PETREU_SV, "Aktivera PET Ram- och -expansionsenhet"},
/* tr */ {IDCLS_ENABLE_PETREU_TR, "PET Ram ve Geniletme Birimi'ni aktif et"},
#endif

/* pet/petreu.c */
/* en */ {IDCLS_DISABLE_PETREU,    N_("Disable the PET Ram and Expansion Unit")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_PETREU_DA, "Deaktivr PET REU"},
/* de */ {IDCLS_DISABLE_PETREU_DE, "PET RAM Speicher und Erweiterungsmodul dektivieren"},
/* es */ {IDCLS_DISABLE_PETREU_ES, "Deshabilitar PET RAM y Unidad Expansin"},
/* fr */ {IDCLS_DISABLE_PETREU_FR, "Dsactiver l'expansion d'unit et de RAM du PET"},
/* hu */ {IDCLS_DISABLE_PETREU_HU, "PET RAM and Expansion Unit tiltsa"},
/* it */ {IDCLS_DISABLE_PETREU_IT, "Disattiva la RAM e l'unit di espansione del PET"},
/* ko */ {IDCLS_DISABLE_PETREU_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_PETREU_NL, "PET RAM en uitbreidingseenheid uitschakelen"},
/* pl */ {IDCLS_DISABLE_PETREU_PL, "Wycz PET Ram i Expansion Unit"},
/* ru */ {IDCLS_DISABLE_PETREU_RU, "Disable the PET Ram and Expansion Unit"},
/* sv */ {IDCLS_DISABLE_PETREU_SV, "Inaktivera PET Ram- och -expansionsenhet"},
/* tr */ {IDCLS_DISABLE_PETREU_TR, "PET Ram ve Geniletme Birimi'ni pasifletir"},
#endif

/* pet/petreu.c */
/* en */ {IDCLS_SPECIFY_PETREU_NAME,    N_("Specify name of PET Ram and Expansion Unit image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_PETREU_NAME_DA, "Angiv navn p PET REU-image"},
/* de */ {IDCLS_SPECIFY_PETREU_NAME_DE, "Namen fr PET RAM Speicher und Erweiterungsmodul whlen"},
/* es */ {IDCLS_SPECIFY_PETREU_NAME_ES, "Especificar nombre imagen PET Ram y Unidad Expansin"},
/* fr */ {IDCLS_SPECIFY_PETREU_NAME_FR, "Spcifier le nom de l'image dunit d'expansion RAM"},
/* hu */ {IDCLS_SPECIFY_PETREU_NAME_HU, "Adja meg a PET RAM and Expansion Unit kpms nevt"},
/* it */ {IDCLS_SPECIFY_PETREU_NAME_IT, "Specifica il nome immagine della RAM e dell'unit di espansione del PET"},
/* ko */ {IDCLS_SPECIFY_PETREU_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_PETREU_NAME_NL, "Geef de naam van het PET RAM en uitbreidingseenheid bestand"},
/* pl */ {IDCLS_SPECIFY_PETREU_NAME_PL, "Okrel nazw obrazu PET Ram i Expansion Unit"},
/* ru */ {IDCLS_SPECIFY_PETREU_NAME_RU, "Specify name of PET Ram and Expansion Unit image"},
/* sv */ {IDCLS_SPECIFY_PETREU_NAME_SV, "Ange namn p PET Ram- och -expansionsenhet"},
/* tr */ {IDCLS_SPECIFY_PETREU_NAME_TR, "PET Ram ve Geniletme Birimi'nin ismini belirt"},
#endif

/* pet/petreu.c */
/* en */ {IDCLS_PETREU_SIZE,    N_("Size of the PET Ram and Expansion Unit. (128/512/1024/2048)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PETREU_SIZE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_PETREU_SIZE_DE, "Gre des PET RAM Speicher und Erweiterungsmodul. (128/512/1024/2048)"},
/* es */ {IDCLS_PETREU_SIZE_ES, "Tamao de PET Ram y Unidad Expansin. (128/512/1024/2048)"},
/* fr */ {IDCLS_PETREU_SIZE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_PETREU_SIZE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_PETREU_SIZE_IT, "Dimensione della RAM e dell'unit di espansione del PET. (128/512/1024/2048)"},
/* ko */ {IDCLS_PETREU_SIZE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PETREU_SIZE_NL, "Grootte van de PET RAM en uitbreidingseenheid. (128/512/1024/2048)"},
/* pl */ {IDCLS_PETREU_SIZE_PL, "Rozmiar PET Ram i Expansion Unit. (128/512/1024/2048)"},
/* ru */ {IDCLS_PETREU_SIZE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_PETREU_SIZE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_PETREU_SIZE_TR, ""},  /* fuzzy */
#endif

/* pet/petdww.c */
/* en */ {IDCLS_SPECIFY_PETDWW_NAME,    N_("Specify name of PET DWW image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_PETDWW_NAME_DA, "Angiv navn p PET DWW-image"},
/* de */ {IDCLS_SPECIFY_PETDWW_NAME_DE, "Namen fr PET DWW Imagedatei whlen"},
/* es */ {IDCLS_SPECIFY_PETDWW_NAME_ES, "Especificar nombre imagen PET DWW"},
/* fr */ {IDCLS_SPECIFY_PETDWW_NAME_FR, "Spcifier le nom de l'image PET DWW"},
/* hu */ {IDCLS_SPECIFY_PETDWW_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_PETDWW_NAME_IT, "Specifica il nome immagine PET DWW"},
/* ko */ {IDCLS_SPECIFY_PETDWW_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_PETDWW_NAME_NL, "Geef de naam van het PET DWW bestand"},
/* pl */ {IDCLS_SPECIFY_PETDWW_NAME_PL, "Okrel nazw obrazu PET DWW"},
/* ru */ {IDCLS_SPECIFY_PETDWW_NAME_RU, "Specify name of PET DWW image"},
/* sv */ {IDCLS_SPECIFY_PETDWW_NAME_SV, "Ange namn p PET DWW-avbildning"},
/* tr */ {IDCLS_SPECIFY_PETDWW_NAME_TR, "PET DWW imajnn ismini belirt"},
#endif

/* pet/petdww.c */
/* en */ {IDCLS_ENABLE_PETDWW,    N_("Enable the PET DWW hi-res board")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_PETDWW_DA, "Aktivr PET DWW hjoplsningskort"},
/* de */ {IDCLS_ENABLE_PETDWW_DE, "PET DWW hi-res Karte aktivieren"},
/* es */ {IDCLS_ENABLE_PETDWW_ES, "Permitir tablero de alta resolucin PET DWW"},
/* fr */ {IDCLS_ENABLE_PETDWW_FR, "Activer la carte haute-rs PET DWW"},
/* hu */ {IDCLS_ENABLE_PETDWW_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_PETDWW_IT, "Attiva la scheda hi-res PET DWW"},
/* ko */ {IDCLS_ENABLE_PETDWW_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_PETDWW_NL, "PET DWW hi-res bord inschakelen"},
/* pl */ {IDCLS_ENABLE_PETDWW_PL, "Wcz ukad PET DWW hi-res"},
/* ru */ {IDCLS_ENABLE_PETDWW_RU, "Enable the PET DWW hi-res board"},
/* sv */ {IDCLS_ENABLE_PETDWW_SV, "Aktivera PET DWW-hgupplsningskort"},
/* tr */ {IDCLS_ENABLE_PETDWW_TR, "PET DWW hi-res boardunu aktif et"},
#endif

/* pet/petdww.c */
/* en */ {IDCLS_DISABLE_PETDWW,    N_("Disable the PET DWW hi-res board")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_PETDWW_DA, "Deaktivr PET DWW hjoplsningskort"},
/* de */ {IDCLS_DISABLE_PETDWW_DE, "PET DWW Hi-Res Karte deaktivieren"},
/* es */ {IDCLS_DISABLE_PETDWW_ES, "Deshabilitar tablero de alta resolucin PET DWW"},
/* fr */ {IDCLS_DISABLE_PETDWW_FR, "Dsactiver la carte haute-rs PET DWW"},
/* hu */ {IDCLS_DISABLE_PETDWW_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_PETDWW_IT, "Disattiva la scheda hi-res PET DWW"},
/* ko */ {IDCLS_DISABLE_PETDWW_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_PETDWW_NL, "PET DWW hi-res bord uitschakelen"},
/* pl */ {IDCLS_DISABLE_PETDWW_PL, "Wycz pyt PET DWW hi-res"},
/* ru */ {IDCLS_DISABLE_PETDWW_RU, "Disable the PET DWW hi-res board"},
/* sv */ {IDCLS_DISABLE_PETDWW_SV, "Inaktivera PET DWW-hgupplsningskort"},
/* tr */ {IDCLS_DISABLE_PETDWW_TR, "PET DWW hi-res boardu pasifletir"},
#endif

/* userport/userport_dac.c */
/* en */ {IDCLS_ENABLE_USERPORT_DAC,    N_("Enable Userport DAC for sound output")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_USERPORT_DAC_DA, "Aktivr brugerport DAC for lydoutput"},
/* de */ {IDCLS_ENABLE_USERPORT_DAC_DE, "Userport DAC Sound aktivieren"},
/* es */ {IDCLS_ENABLE_USERPORT_DAC_ES, "Permitir puerto DAC para salida de sonido"},
/* fr */ {IDCLS_ENABLE_USERPORT_DAC_FR, "Activer DAC port utilisateur comme sortie de son"},
/* hu */ {IDCLS_ENABLE_USERPORT_DAC_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_USERPORT_DAC_IT, "Attiva DAC su userport per la riproduzione audio"},
/* ko */ {IDCLS_ENABLE_USERPORT_DAC_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_USERPORT_DAC_NL, "Userport DAC voor geluidsuitvoer inschakelen"},
/* pl */ {IDCLS_ENABLE_USERPORT_DAC_PL, "Wcz userport DAC jako wyjcie dwiku"},
/* ru */ {IDCLS_ENABLE_USERPORT_DAC_RU, "Enable Userport DAC for sound output"},
/* sv */ {IDCLS_ENABLE_USERPORT_DAC_SV, "Aktivera D/A-omvandlare p anvndarporten fr ljudutdata"},
/* tr */ {IDCLS_ENABLE_USERPORT_DAC_TR, "Ses k iin Userport DAC' aktif et"},
#endif

/* userport/userport_dac.c */
/* en */ {IDCLS_DISABLE_USERPORT_DAC,    N_("Disable Userport DAC for sound output")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_USERPORT_DAC_DA, "Deaktivr brugerport DAC for lydoutput"},
/* de */ {IDCLS_DISABLE_USERPORT_DAC_DE, "Userport DAC Sound deaktivieren"},
/* es */ {IDCLS_DISABLE_USERPORT_DAC_ES, "Deshabilitar puerto DAC para salida de sonido"},
/* fr */ {IDCLS_DISABLE_USERPORT_DAC_FR, "Dsactiver DAC port utilisateur comme sortie de son"},
/* hu */ {IDCLS_DISABLE_USERPORT_DAC_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_USERPORT_DAC_IT, "Disattiva DAC su userport per la riproduzione audio"},
/* ko */ {IDCLS_DISABLE_USERPORT_DAC_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_USERPORT_DAC_NL, "Userport DAC voor geluidsuitvoer uitschakelen"},
/* pl */ {IDCLS_DISABLE_USERPORT_DAC_PL, "Wycz userport DAC jako wycie dwiku"},
/* ru */ {IDCLS_DISABLE_USERPORT_DAC_RU, "Disable Userport DAC for sound output"},
/* sv */ {IDCLS_DISABLE_USERPORT_DAC_SV, "Inaktivera D/A-omvandlare p anvndarporten fr ljudutdata"},
/* tr */ {IDCLS_DISABLE_USERPORT_DAC_TR, "Ses k iin Userport DAC' pasifletir"},
#endif

/* userport/userport_joystick.c */
/* en */ {IDCLS_ENABLE_USERPORT_JOY,    N_("Enable Userport joystick adapter")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_USERPORT_JOY_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_USERPORT_JOY_DE, "Userport Joystick Adapter aktivieren"},
/* es */ {IDCLS_ENABLE_USERPORT_JOY_ES, "Permitir adaptador puerto joystick"},
/* fr */ {IDCLS_ENABLE_USERPORT_JOY_FR, "Activer l'adaptateur joystick port utilisateur"},
/* hu */ {IDCLS_ENABLE_USERPORT_JOY_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_USERPORT_JOY_IT, "Attiva adattatore joystick su userport"},
/* ko */ {IDCLS_ENABLE_USERPORT_JOY_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_USERPORT_JOY_NL, "Userport joystick adapter inschakelen"},
/* pl */ {IDCLS_ENABLE_USERPORT_JOY_PL, "Wcz zcze userportu joysticka"},
/* ru */ {IDCLS_ENABLE_USERPORT_JOY_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_USERPORT_JOY_SV, "Aktivera adapter fr anvndarportstyrspakar"},
/* tr */ {IDCLS_ENABLE_USERPORT_JOY_TR, ""},  /* fuzzy */
#endif

/* userport/userport_joystick.c */
/* en */ {IDCLS_DISABLE_USERPORT_JOY,    N_("Disable Userport joystick adapter")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_USERPORT_JOY_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_USERPORT_JOY_DE, "Userport Joystick Adapter deaktivieren"},
/* es */ {IDCLS_DISABLE_USERPORT_JOY_ES, "Deshabilitar adaptador puerto joystick"},
/* fr */ {IDCLS_DISABLE_USERPORT_JOY_FR, "Dsactiver l'adaptateur Joystick port utilisateur"},
/* hu */ {IDCLS_DISABLE_USERPORT_JOY_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_USERPORT_JOY_IT, "Disattiva adattatore joystick su userport"},
/* ko */ {IDCLS_DISABLE_USERPORT_JOY_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_USERPORT_JOY_NL, "Userport joystick adapter uitschakelen"},
/* pl */ {IDCLS_DISABLE_USERPORT_JOY_PL, "Wycz zcze userportu joysticka"},
/* ru */ {IDCLS_DISABLE_USERPORT_JOY_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_USERPORT_JOY_SV, "Inativera adapter fr anvndarportstyrspakar"},
/* tr */ {IDCLS_DISABLE_USERPORT_JOY_TR, ""},  /* fuzzy */
#endif

/* userport/userport_joystick.c */
/* en */ {IDCLS_SET_USERPORT_JOY_TYPE,    N_("Set Userport joystick adapter type (0: CGA/Protovision, 1: PET, 2: Hummer, 3: OEM, 4: DXS/HIT, 5: Kingsoft, 6: Starbyte)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_USERPORT_JOY_TYPE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_USERPORT_JOY_TYPE_DE, "Setze Userport Joystick adapter Typ (0: CGA/Protovision, 1: PET, 2: Hummer, 3: OEM, 4: DXS/HIT, 5: Kingsoft, 6: Starbyte)"},
/* es */ {IDCLS_SET_USERPORT_JOY_TYPE_ES, "Seleccionar tipo adaptador para puerto joystick  (0: CGA/Protovision, 1: PET, 2: Hummer, 3: OEM, 4: DXS/HIT, 5: Kingsoft, 6: Starbyte)"},
/* fr */ {IDCLS_SET_USERPORT_JOY_TYPE_FR, "Dfinir le type de joystick port utilisateur (0: CGA/Protovision, 1: PET, 2: Hummer, 3: OEM, 4: DXS/HIT, 5: Kingsoft, 6: Starbyte)"},
/* hu */ {IDCLS_SET_USERPORT_JOY_TYPE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_USERPORT_JOY_TYPE_IT, "Imposta il tipo di adattatore joystick su userport (0: CGA/Protovision, 1: PET, 2: Hummer, 3: OEM, 4: DXS/HIT, 5: Kingsoft, 6: Starbyte)"},
/* ko */ {IDCLS_SET_USERPORT_JOY_TYPE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_USERPORT_JOY_TYPE_NL, "Stel Userport joystick adapter soort in (0: CGA/Protovision, 1: PET, 2: Hummer, 3: OEM, 4: DXS/HIT, 5: Kingsoft, 6: Starbyte)"},
/* pl */ {IDCLS_SET_USERPORT_JOY_TYPE_PL, "Okrel typ zcza userportu joysticka (0: CGA/Protovision, 1: PET, 2: Hummer, 3: OEM, 4: DXS/HIT, 5: Kingsoft, 6: Starbyte)"},
/* ru */ {IDCLS_SET_USERPORT_JOY_TYPE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_USERPORT_JOY_TYPE_SV, "Vlj typ av styrspakadapter fr anvndarporten (0: CGA/Protovision, 1: PET, 2: Hummer, 3: OEM, 4: DXS/HIT, 5: Kingsoft, 6: Starbyte)"},
/* tr */ {IDCLS_SET_USERPORT_JOY_TYPE_TR, ""},  /* fuzzy */
#endif

/* userport/userport_rtc_58321a.c */
/* en */ {IDCLS_ENABLE_USERPORT_RTC_58321A,    N_("Enable Userport RTC (58321a)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_USERPORT_RTC_58321A_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_USERPORT_RTC_58321A_DE, "Userport RTC (58321a) aktivieren"},
/* es */ {IDCLS_ENABLE_USERPORT_RTC_58321A_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_USERPORT_RTC_58321A_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_USERPORT_RTC_58321A_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_USERPORT_RTC_58321A_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_USERPORT_RTC_58321A_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_USERPORT_RTC_58321A_NL, "Userport RTC (58321a) inschakelen"},
/* pl */ {IDCLS_ENABLE_USERPORT_RTC_58321A_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_USERPORT_RTC_58321A_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_USERPORT_RTC_58321A_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_USERPORT_RTC_58321A_TR, ""},  /* fuzzy */
#endif

/* userport/userport_rtc_58321a.c */
/* en */ {IDCLS_DISABLE_USERPORT_RTC_58321A,    N_("Disable Userport RTC (58321a)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_USERPORT_RTC_58321A_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_USERPORT_RTC_58321A_DE, "Userport RTC (58321a) deaktivieren"},
/* es */ {IDCLS_DISABLE_USERPORT_RTC_58321A_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_USERPORT_RTC_58321A_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_USERPORT_RTC_58321A_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_USERPORT_RTC_58321A_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_USERPORT_RTC_58321A_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_USERPORT_RTC_58321A_NL, "Userport RTC (58321a) uitschakelen"},
/* pl */ {IDCLS_DISABLE_USERPORT_RTC_58321A_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_USERPORT_RTC_58321A_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_USERPORT_RTC_58321A_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_USERPORT_RTC_58321A_TR, ""},  /* fuzzy */
#endif

/* userport/userport_rtc_58321a.c */
/* en */ {IDCLS_ENABLE_USERPORT_RTC_58321A_SAVE,    N_("Enable saving of the Userport RTC (58321a) data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_USERPORT_RTC_58321A_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_USERPORT_RTC_58321A_SAVE_DE, "Userport RTC (58321a) Daten bei nderung speichern."},
/* es */ {IDCLS_ENABLE_USERPORT_RTC_58321A_SAVE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_USERPORT_RTC_58321A_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_USERPORT_RTC_58321A_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_USERPORT_RTC_58321A_SAVE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_USERPORT_RTC_58321A_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_USERPORT_RTC_58321A_SAVE_NL, "Opslaan van de Userport RTC (58321a) gegevens bij wijziging inschakelen."},
/* pl */ {IDCLS_ENABLE_USERPORT_RTC_58321A_SAVE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_USERPORT_RTC_58321A_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_USERPORT_RTC_58321A_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_USERPORT_RTC_58321A_SAVE_TR, ""},  /* fuzzy */
#endif

/* userport/userport_rtc_58321a.c */
/* en */ {IDCLS_DISABLE_USERPORT_RTC_58321A_SAVE,    N_("Disable saving of the Userport RTC (58321a) data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_USERPORT_RTC_58321A_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_USERPORT_RTC_58321A_SAVE_DE, "Userport RTC (58321a) Daten bei nderung nicht speichern."},
/* es */ {IDCLS_DISABLE_USERPORT_RTC_58321A_SAVE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_USERPORT_RTC_58321A_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_USERPORT_RTC_58321A_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_USERPORT_RTC_58321A_SAVE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_USERPORT_RTC_58321A_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_USERPORT_RTC_58321A_SAVE_NL, "Opslaan van de Userport RTC (58321a) gegevens bij wijziging uitschakelen."},
/* pl */ {IDCLS_DISABLE_USERPORT_RTC_58321A_SAVE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_USERPORT_RTC_58321A_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_USERPORT_RTC_58321A_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_USERPORT_RTC_58321A_SAVE_TR, ""},  /* fuzzy */
#endif

/* userport/userport_rtc_ds1307.c */
/* en */ {IDCLS_ENABLE_USERPORT_RTC_DS1307,    N_("Enable Userport RTC (DS1307)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_DE, "Userport RTC (DS1307) aktivieren"},
/* es */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_NL, "Userport RTC (DS1307) inschakelen"},
/* pl */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_TR, ""},  /* fuzzy */
#endif

/* userport/userport_rtc_ds1307.c */
/* en */ {IDCLS_DISABLE_USERPORT_RTC_DS1307,    N_("Disable Userport RTC (DS1307)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_DE, "Userport RTC (DS1307) deaktivieren"},
/* es */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_NL, "Userport RTC (DS1307) uitschakelen"},
/* pl */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_TR, ""},  /* fuzzy */
#endif

/* userport/userport_rtc_ds1307.c */
/* en */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_SAVE,    N_("Enable saving of the Userport RTC (DS1307) data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_SAVE_DE, "Userport RTC (DS1307) Daten bei nderung speichern."},
/* es */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_SAVE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_SAVE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_SAVE_NL, "Opslaan van de Userport RTC (DS1307) gegevens bij wijziging inschakelen."},
/* pl */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_SAVE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_USERPORT_RTC_DS1307_SAVE_TR, ""},  /* fuzzy */
#endif

/* userport/userport_rtc_ds1307.c */
/* en */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_SAVE,    N_("Disable saving of the Userport RTC (DS1307) data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_SAVE_DE, "Userport RTC (DS1307) Daten bei nderung nicht speichern."},
/* es */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_SAVE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_SAVE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_SAVE_NL, "Opslaan van de Userport RTC (DS1307) gegevens bij wijziging uitschakelen."},
/* pl */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_SAVE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_USERPORT_RTC_DS1307_SAVE_TR, ""},  /* fuzzy */
#endif

/* userport/userport_diag_586220_harness.c */
/* en */ {IDCLS_ENABLE_USERPORT_DIAG_586220_HARNESS,    N_("Enable Userport diag 586220 harness module")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_USERPORT_DIAG_586220_HARNESS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_USERPORT_DIAG_586220_HARNESS_DE, "Userport Diag 586220 Harnessmodul aktivieren"},
/* es */ {IDCLS_ENABLE_USERPORT_DIAG_586220_HARNESS_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_USERPORT_DIAG_586220_HARNESS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_USERPORT_DIAG_586220_HARNESS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_USERPORT_DIAG_586220_HARNESS_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_USERPORT_DIAG_586220_HARNESS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_USERPORT_DIAG_586220_HARNESS_NL, "Userport diag 586220 gareel module inschakelen"},
/* pl */ {IDCLS_ENABLE_USERPORT_DIAG_586220_HARNESS_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_USERPORT_DIAG_586220_HARNESS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_USERPORT_DIAG_586220_HARNESS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_USERPORT_DIAG_586220_HARNESS_TR, ""},  /* fuzzy */
#endif

/* userport/userport_diag_586220_harness.c */
/* en */ {IDCLS_DISABLE_USERPORT_DIAG_586220_HARNESS,    N_("Disable Userport diag 586220 harness module")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_USERPORT_DIAG_586220_HARNESS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_USERPORT_DIAG_586220_HARNESS_DE, "Userport Diag 586220 Harnessmodul deaktivieren"},
/* es */ {IDCLS_DISABLE_USERPORT_DIAG_586220_HARNESS_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_USERPORT_DIAG_586220_HARNESS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_USERPORT_DIAG_586220_HARNESS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_USERPORT_DIAG_586220_HARNESS_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_USERPORT_DIAG_586220_HARNESS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_USERPORT_DIAG_586220_HARNESS_NL, "Userport diag 586220 gareel module uitschakelen"},
/* pl */ {IDCLS_DISABLE_USERPORT_DIAG_586220_HARNESS_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_USERPORT_DIAG_586220_HARNESS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_USERPORT_DIAG_586220_HARNESS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_USERPORT_DIAG_586220_HARNESS_TR, ""},  /* fuzzy */
#endif

/* joyport/bbrtc.c */
/* en */ {IDCLS_ENABLE_BBRTC_SAVE,    N_("Enable saving of the BBRTC data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_BBRTC_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_BBRTC_SAVE_DE, "BBRTC Daten bei nderung speichern."},
/* es */ {IDCLS_ENABLE_BBRTC_SAVE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_BBRTC_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_BBRTC_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_BBRTC_SAVE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_BBRTC_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_BBRTC_SAVE_NL, "Opslaan van de BBRTC gegevens bij wijziging inschakelen."},
/* pl */ {IDCLS_ENABLE_BBRTC_SAVE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_BBRTC_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_BBRTC_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_BBRTC_SAVE_TR, ""},  /* fuzzy */
#endif

/* joyport/bbrtc.c */
/* en */ {IDCLS_DISABLE_BBRTC_SAVE,    N_("Disable saving of the BBRTC data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_BBRTC_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_BBRTC_SAVE_DE, "BBRTC Daten bei nderung nicht speichern."},
/* es */ {IDCLS_DISABLE_BBRTC_SAVE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_BBRTC_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_BBRTC_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_BBRTC_SAVE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_BBRTC_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_BBRTC_SAVE_NL, "Opslaan van de BBRTC gegevens bij wijziging uitschakelen."},
/* pl */ {IDCLS_DISABLE_BBRTC_SAVE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_BBRTC_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_BBRTC_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_BBRTC_SAVE_TR, ""},  /* fuzzy */
#endif

/* tapeport/sense-dongle.c */
/* en */ {IDCLS_ENABLE_TAPE_SENSE_DONGLE,    N_("Enable tape sense dongle")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_TAPE_SENSE_DONGLE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_TAPE_SENSE_DONGLE_DE, "Band Sense Dongle aktivieren"},
/* es */ {IDCLS_ENABLE_TAPE_SENSE_DONGLE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_TAPE_SENSE_DONGLE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_TAPE_SENSE_DONGLE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_TAPE_SENSE_DONGLE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_TAPE_SENSE_DONGLE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_TAPE_SENSE_DONGLE_NL, "Tape sense dongle inschakelen"},
/* pl */ {IDCLS_ENABLE_TAPE_SENSE_DONGLE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_TAPE_SENSE_DONGLE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_TAPE_SENSE_DONGLE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_TAPE_SENSE_DONGLE_TR, ""},  /* fuzzy */
#endif

/* tapeport/sense-dongle.c */
/* en */ {IDCLS_DISABLE_TAPE_SENSE_DONGLE,    N_("Disable tape sense dongle")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_TAPE_SENSE_DONGLE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_TAPE_SENSE_DONGLE_DE, "Band Sense Dongle deaktivieren"},
/* es */ {IDCLS_DISABLE_TAPE_SENSE_DONGLE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_TAPE_SENSE_DONGLE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_TAPE_SENSE_DONGLE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_TAPE_SENSE_DONGLE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_TAPE_SENSE_DONGLE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_TAPE_SENSE_DONGLE_NL, "Tape sense dongle uitschakelen"},
/* pl */ {IDCLS_DISABLE_TAPE_SENSE_DONGLE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_TAPE_SENSE_DONGLE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_TAPE_SENSE_DONGLE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_TAPE_SENSE_DONGLE_TR, ""},  /* fuzzy */
#endif

/* tapeport/dtl-basic-dongle.c */
/* en */ {IDCLS_ENABLE_DTL_BASIC_DONGLE,    N_("Enable DTL Basic dongle")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_DTL_BASIC_DONGLE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_DTL_BASIC_DONGLE_DE, "DTL Basic Dongle aktivieren"},
/* es */ {IDCLS_ENABLE_DTL_BASIC_DONGLE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_DTL_BASIC_DONGLE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_DTL_BASIC_DONGLE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_DTL_BASIC_DONGLE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_DTL_BASIC_DONGLE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_DTL_BASIC_DONGLE_NL, "DTL Basic dongle inschakelen"},
/* pl */ {IDCLS_ENABLE_DTL_BASIC_DONGLE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_DTL_BASIC_DONGLE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_DTL_BASIC_DONGLE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_DTL_BASIC_DONGLE_TR, ""},  /* fuzzy */
#endif

/* tapeport/dtl-basic-dongle.c */
/* en */ {IDCLS_DISABLE_DTL_BASIC_DONGLE,    N_("Enable DTL Basic dongle")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_DTL_BASIC_DONGLE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_DTL_BASIC_DONGLE_DE, "DTL Basic Dongle aktivieren"},
/* es */ {IDCLS_DISABLE_DTL_BASIC_DONGLE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_DTL_BASIC_DONGLE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_DTL_BASIC_DONGLE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_DTL_BASIC_DONGLE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_DTL_BASIC_DONGLE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_DTL_BASIC_DONGLE_NL, "DTL Basic dongle inschakelen"},
/* pl */ {IDCLS_DISABLE_DTL_BASIC_DONGLE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_DTL_BASIC_DONGLE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_DTL_BASIC_DONGLE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_DTL_BASIC_DONGLE_TR, ""},  /* fuzzy */
#endif

/* tapeport/tapertc.c */
/* en */ {IDCLS_ENABLE_TAPERTC,    N_("Enable CP Clock F83 (PCF8583 RTC)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_TAPERTC_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_TAPERTC_DE, "CP Clock F83 (PCF8583 RTC) aktivieren"},
/* es */ {IDCLS_ENABLE_TAPERTC_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_TAPERTC_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_TAPERTC_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_TAPERTC_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_TAPERTC_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_TAPERTC_NL, "CP Clock F83 (PCF8583 RTC) inschakelen"},
/* pl */ {IDCLS_ENABLE_TAPERTC_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_TAPERTC_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_TAPERTC_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_TAPERTC_TR, ""},  /* fuzzy */
#endif

/* tapeport/tapertc.c */
/* en */ {IDCLS_DISABLE_TAPERTC,    N_("Disable CP Clock F83 (PCF8583 RTC)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_TAPERTC_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_TAPERTC_DE, "CP Clock F83 (PCF8583 RTC) deaktivieren"},
/* es */ {IDCLS_DISABLE_TAPERTC_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_TAPERTC_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_TAPERTC_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_TAPERTC_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_TAPERTC_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_TAPERTC_NL, "CP Clock F83 (PCF8583 RTC) uitschakelen"},
/* pl */ {IDCLS_DISABLE_TAPERTC_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_TAPERTC_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_TAPERTC_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_TAPERTC_TR, ""},  /* fuzzy */
#endif

/* tapeport/tapertc.c */
/* en */ {IDCLS_ENABLE_TAPERTC_SAVE,    N_("Enable saving of the CP Clock F83 (PCF8583 RTC) data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_TAPERTC_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_TAPERTC_SAVE_DE, "CP Clock F83 (PCF8583 RTC) Daten bei nderung speichern."},
/* es */ {IDCLS_ENABLE_TAPERTC_SAVE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_TAPERTC_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_TAPERTC_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_TAPERTC_SAVE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_TAPERTC_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_TAPERTC_SAVE_NL, "Opslaan van de CP Clock F83 (PCF8583 RTC) gegevens bij wijziging inschakelen."},
/* pl */ {IDCLS_ENABLE_TAPERTC_SAVE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_TAPERTC_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_TAPERTC_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_TAPERTC_SAVE_TR, ""},  /* fuzzy */
#endif

/* tapeport/tapertc.c */
/* en */ {IDCLS_DISABLE_TAPERTC_SAVE,    N_("Disable saving of the CP Clock F83 (PCF8583 RTC) data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_TAPERTC_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_TAPERTC_SAVE_DE, "CP Clock F83 (PCF8583 RTC) Daten bei nderung nicht speichern."},
/* es */ {IDCLS_DISABLE_TAPERTC_SAVE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_TAPERTC_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_TAPERTC_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_TAPERTC_SAVE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_TAPERTC_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_TAPERTC_SAVE_NL, "Opslaan van de CP Clock F83 (PCF8583 RTC) gegevens bij wijziging uitschakelen."},
/* pl */ {IDCLS_DISABLE_TAPERTC_SAVE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_TAPERTC_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_TAPERTC_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_TAPERTC_SAVE_TR, ""},  /* fuzzy */
#endif

/* userport/userport_4bit_sampler.c */
/* en */ {IDCLS_ENABLE_USERPORT_4BIT_SAMPLER,    N_("Enable Userport 4bit sampler")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_USERPORT_4BIT_SAMPLER_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_USERPORT_4BIT_SAMPLER_DE, "Userport 4bit Sampler aktivieren"},
/* es */ {IDCLS_ENABLE_USERPORT_4BIT_SAMPLER_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_USERPORT_4BIT_SAMPLER_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_USERPORT_4BIT_SAMPLER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_USERPORT_4BIT_SAMPLER_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_USERPORT_4BIT_SAMPLER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_USERPORT_4BIT_SAMPLER_NL, "Userport 4bit sampler inschakelen"},
/* pl */ {IDCLS_ENABLE_USERPORT_4BIT_SAMPLER_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_USERPORT_4BIT_SAMPLER_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_USERPORT_4BIT_SAMPLER_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_USERPORT_4BIT_SAMPLER_TR, ""},  /* fuzzy */
#endif

/* userport/userport_4bit_sampler.c */
/* en */ {IDCLS_DISABLE_USERPORT_4BIT_SAMPLER,    N_("Disable Userport 4bit sampler")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_USERPORT_4BIT_SAMPLER_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_USERPORT_4BIT_SAMPLER_DE, "Userport 4bit Sampler deaktivieren"},
/* es */ {IDCLS_DISABLE_USERPORT_4BIT_SAMPLER_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_USERPORT_4BIT_SAMPLER_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_USERPORT_4BIT_SAMPLER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_USERPORT_4BIT_SAMPLER_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_USERPORT_4BIT_SAMPLER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_USERPORT_4BIT_SAMPLER_NL, "Userport 4bit sampler uitschakelen"},
/* pl */ {IDCLS_DISABLE_USERPORT_4BIT_SAMPLER_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_USERPORT_4BIT_SAMPLER_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_USERPORT_4BIT_SAMPLER_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_USERPORT_4BIT_SAMPLER_TR, ""},  /* fuzzy */
#endif

/* userport/userport_8bss.c */
/* en */ {IDCLS_ENABLE_USERPORT_8BSS,    N_("Enable Userport 8bit stereo sampler")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_USERPORT_8BSS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_USERPORT_8BSS_DE, "Userport 8bit Sampler aktivieren"},
/* es */ {IDCLS_ENABLE_USERPORT_8BSS_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_USERPORT_8BSS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_USERPORT_8BSS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_USERPORT_8BSS_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_USERPORT_8BSS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_USERPORT_8BSS_NL, "Userport 8bit stereo sampler inschakelen"},
/* pl */ {IDCLS_ENABLE_USERPORT_8BSS_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_USERPORT_8BSS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_USERPORT_8BSS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_USERPORT_8BSS_TR, ""},  /* fuzzy */
#endif

/* userport/userport_8bss.c */
/* en */ {IDCLS_DISABLE_USERPORT_8BSS,    N_("Disable Userport 8bit stereo sampler")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_USERPORT_8BSS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_USERPORT_8BSS_DE, "Userport 8bit Sampler deaktivieren"},
/* es */ {IDCLS_DISABLE_USERPORT_8BSS_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_USERPORT_8BSS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_USERPORT_8BSS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_USERPORT_8BSS_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_USERPORT_8BSS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_USERPORT_8BSS_NL, "Userport 8bit stereo sampler uitschakelen"},
/* pl */ {IDCLS_DISABLE_USERPORT_8BSS_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_USERPORT_8BSS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_USERPORT_8BSS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_USERPORT_8BSS_TR, ""},  /* fuzzy */
#endif

/* c64/psid.c */
/* en */ {IDCLS_OVERWRITE_PSID_SETTINGS,    N_("Override PSID settings for Video standard and SID model")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_OVERWRITE_PSID_SETTINGS_DA, "Overstyr PSID-indstillinger for Video-standard og SID-model"},
/* de */ {IDCLS_OVERWRITE_PSID_SETTINGS_DE, "PSID Einstellung fr Video Standard und SID Modell verndern"},
/* es */ {IDCLS_OVERWRITE_PSID_SETTINGS_ES, "Sobrescribir ajustes para vdeo standard y modelo SID"},
/* fr */ {IDCLS_OVERWRITE_PSID_SETTINGS_FR, "craser les paramtres PSID pour le standard vido et le modle SID"},
/* hu */ {IDCLS_OVERWRITE_PSID_SETTINGS_HU, "A vide szabvny s a SID modell PSID belltsainak fellbrlsa"},
/* it */ {IDCLS_OVERWRITE_PSID_SETTINGS_IT, "Non tener conto delle impostazioni del PSID per lo standard video e il modello di SID"},
/* ko */ {IDCLS_OVERWRITE_PSID_SETTINGS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_OVERWRITE_PSID_SETTINGS_NL, "Overschrijf PSID instellingen voor videostandaard en SID model"},
/* pl */ {IDCLS_OVERWRITE_PSID_SETTINGS_PL, "Zastp ustawienia PSID standardu wideo i modelu SID"},
/* ru */ {IDCLS_OVERWRITE_PSID_SETTINGS_RU, "Override PSID settings for Video standard and SID model"},
/* sv */ {IDCLS_OVERWRITE_PSID_SETTINGS_SV, "Erstt PSID-instllningar fr videostandard och SID-modell"},
/* tr */ {IDCLS_OVERWRITE_PSID_SETTINGS_TR, "Video standard ve SID modeli iin PSID ayarlarn geersiz kl"},
#endif

/* c64/psid.c */
/* en */ {IDCLS_SPECIFY_PSID_TUNE_NUMBER,    N_("Specify PSID tune <number>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_PSID_TUNE_NUMBER_DA, "Vlg PSID-nummer <nummer>"},
/* de */ {IDCLS_SPECIFY_PSID_TUNE_NUMBER_DE, "PSID Stck <Nummer> whlen"},
/* es */ {IDCLS_SPECIFY_PSID_TUNE_NUMBER_ES, "Especificar PSID tono <nmero>"},
/* fr */ {IDCLS_SPECIFY_PSID_TUNE_NUMBER_FR, "Spcifier le <numro> de piste PSID"},
/* hu */ {IDCLS_SPECIFY_PSID_TUNE_NUMBER_HU, "Adja meg a PSID hangzatok <szm>"},
/* it */ {IDCLS_SPECIFY_PSID_TUNE_NUMBER_IT, "Specifica la melodia <numero> del PSID"},
/* ko */ {IDCLS_SPECIFY_PSID_TUNE_NUMBER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_PSID_TUNE_NUMBER_NL, "Geef PSID melodie <nummer>"},
/* pl */ {IDCLS_SPECIFY_PSID_TUNE_NUMBER_PL, "Okrel ton PSID <numer>"},
/* ru */ {IDCLS_SPECIFY_PSID_TUNE_NUMBER_RU, "Specify PSID tune <number>"},
/* sv */ {IDCLS_SPECIFY_PSID_TUNE_NUMBER_SV, "Ange PSID-lt <nummer>"},
/* tr */ {IDCLS_SPECIFY_PSID_TUNE_NUMBER_TR, "PSID para <numara>'sn belirt"},
#endif

/* c64/cart/ramcart.c */
/* en */ {IDCLS_ENABLE_RAMCART,    N_("Enable the RamCart expansion")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_RAMCART_DA, "Aktivr RamCart-udviddelsen"},
/* de */ {IDCLS_ENABLE_RAMCART_DE, "RamCart Erweiterung aktivieren"},
/* es */ {IDCLS_ENABLE_RAMCART_ES, "Permitir expansin RAMCART"},
/* fr */ {IDCLS_ENABLE_RAMCART_FR, "Activer l'expansion RAMCART"},
/* hu */ {IDCLS_ENABLE_RAMCART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_RAMCART_IT, "Attiva l'espansione RamCart"},
/* ko */ {IDCLS_ENABLE_RAMCART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_RAMCART_NL, "RamCart uitbreiding inschakelen"},
/* pl */ {IDCLS_ENABLE_RAMCART_PL, "Wcz rozszerzenie RamCart"},
/* ru */ {IDCLS_ENABLE_RAMCART_RU, "Enable the RamCart expansion"},
/* sv */ {IDCLS_ENABLE_RAMCART_SV, "Aktivera RamCart-expansion"},
/* tr */ {IDCLS_ENABLE_RAMCART_TR, "RamCart genilemesini aktif et"},
#endif

/* c64/cart/ramcart.c */
/* en */ {IDCLS_DISABLE_RAMCART,    N_("Disable the RamCart expansion")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_RAMCART_DA, "Deaktivr RamCart-udviddelse"},
/* de */ {IDCLS_DISABLE_RAMCART_DE, "RamCart Erweiterung deaktivieren"},
/* es */ {IDCLS_DISABLE_RAMCART_ES, "Deshabilitar expansin RamCart"},
/* fr */ {IDCLS_DISABLE_RAMCART_FR, "Dsactiver l'expansion RAMCART"},
/* hu */ {IDCLS_DISABLE_RAMCART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_RAMCART_IT, "Disattiva l'espansione RamCart"},
/* ko */ {IDCLS_DISABLE_RAMCART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_RAMCART_NL, "RamCart uitbreiding uitschakelen"},
/* pl */ {IDCLS_DISABLE_RAMCART_PL, "Wycz rozszerzenie RamCart"},
/* ru */ {IDCLS_DISABLE_RAMCART_RU, "Disable the RamCart expansion"},
/* sv */ {IDCLS_DISABLE_RAMCART_SV, "Inaktivera RamCart-expansion"},
/* tr */ {IDCLS_DISABLE_RAMCART_TR, "RamCart genilemesini pasifletir"},
#endif

/* c64/cart/ramcart.c */
/* en */ {IDCLS_SPECIFY_RAMCART_NAME,    N_("Specify name of RAMCART image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_RAMCART_NAME_DA, "Angiv navn p RAMCART-image"},
/* de */ {IDCLS_SPECIFY_RAMCART_NAME_DE, "Name fr RAMCART Imagedatei whlen"},
/* es */ {IDCLS_SPECIFY_RAMCART_NAME_ES, "Especificar nombre imagen RAMCART"},
/* fr */ {IDCLS_SPECIFY_RAMCART_NAME_FR, "Spcifier le nom de l'image RAMCART"},
/* hu */ {IDCLS_SPECIFY_RAMCART_NAME_HU, "Adja meg a RAMCART kpms nevt"},
/* it */ {IDCLS_SPECIFY_RAMCART_NAME_IT, "Specifica il nome immagine RAMCART"},
/* ko */ {IDCLS_SPECIFY_RAMCART_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_RAMCART_NAME_NL, "Geef de naam van het RAMCART bestand"},
/* pl */ {IDCLS_SPECIFY_RAMCART_NAME_PL, "Okrel nazw obrazu RAMCART"},
/* ru */ {IDCLS_SPECIFY_RAMCART_NAME_RU, "Specify name of RAMCART image"},
/* sv */ {IDCLS_SPECIFY_RAMCART_NAME_SV, "Ange namn p RAMCART-avbildning"},
/* tr */ {IDCLS_SPECIFY_RAMCART_NAME_TR, "RAMCART imajnn ismini belirt"},
#endif

/* c64/cart/ramcart.c */
/* en */ {IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE,    N_("Allow writing to RAMCart image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE_DA, "Tillad skrivning til RAMCart-image."},
/* de */ {IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE_DE, "Schreibzugriff auf RAMCart Image erlauben"},
/* es */ {IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE_ES, "Permitir grabar en imagen RAMCart"},
/* fr */ {IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE_FR, "Permetre l'criture  l'image RAMCart"},
/* hu */ {IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE_IT, "Attiva scrittura su immagine RAMCart"},
/* ko */ {IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE_NL, "Sta schrijven naar RAMCart bestand toe"},
/* pl */ {IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE_PL, "Pozwl na zapis do obrazu RAMCart"},
/* ru */ {IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE_RU, "Allow writing to RAMCart image"},
/* sv */ {IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE_SV, "Tillt skrivning till RAMCart-avbildning"},
/* tr */ {IDCLS_ALLOW_WRITING_TO_RAMCART_IMAGE_TR, "RAMCart imajna yazmay aktif et"},
#endif

/* c64/cart/ramcart.c */
/* en */ {IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE,    N_("Do not write to RAMCart image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE_DA, "Skriv ikke til RAMcart-image"},
/* de */ {IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE_DE, "Kein Schreibzugriff auf RAMCart Image"},
/* es */ {IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE_ES, "No permitir grabar en imagen RAMCart"},
/* fr */ {IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE_FR, "Ne pas crire sur l'image RAMCart"},
/* hu */ {IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE_IT, "Disattiva scrittura su immagine RAMCart"},
/* ko */ {IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE_NL, "Schrijf niet naar RAMCart bestand"},
/* pl */ {IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE_PL, "Nie zapisuj do obrazu RAMCart"},
/* ru */ {IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE_RU, "Do not write to RAMCart image"},
/* sv */ {IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE_SV, "Skriv inte till RAMCart-avbildning"},
/* tr */ {IDCLS_DO_NOT_WRITE_TO_RAMCART_IMAGE_TR, "RAMCart imajna yazma"},
#endif

/* c64/cart/ramcart.c */
/* en */ {IDCLS_RAMCART_READ_ONLY,    N_("Set the RAMCart switch to read-only")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_RAMCART_READ_ONLY_DA, ""},  /* fuzzy */
/* de */ {IDCLS_RAMCART_READ_ONLY_DE, "RAMCart Schalter auf Schreibschutz"},
/* es */ {IDCLS_RAMCART_READ_ONLY_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_RAMCART_READ_ONLY_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_RAMCART_READ_ONLY_HU, ""},  /* fuzzy */
/* it */ {IDCLS_RAMCART_READ_ONLY_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_RAMCART_READ_ONLY_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_RAMCART_READ_ONLY_NL, "Stel de RAMCart schakelaar in op alleen-lezen"},
/* pl */ {IDCLS_RAMCART_READ_ONLY_PL, "Ustaw RAMCart na tryb tylko do odczytu"},
/* ru */ {IDCLS_RAMCART_READ_ONLY_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_RAMCART_READ_ONLY_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_RAMCART_READ_ONLY_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ramcart.c */
/* en */ {IDCLS_RAMCART_READ_WRITE,    N_("Set the RAMCart switch to read/write")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_RAMCART_READ_WRITE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_RAMCART_READ_WRITE_DE, "RAMCart Schalter auf Schreibzugriff"},
/* es */ {IDCLS_RAMCART_READ_WRITE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_RAMCART_READ_WRITE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_RAMCART_READ_WRITE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_RAMCART_READ_WRITE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_RAMCART_READ_WRITE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_RAMCART_READ_WRITE_NL, "Stel de RAMCart schakelaar in op lezen/schrijven"},
/* pl */ {IDCLS_RAMCART_READ_WRITE_PL, "Ustaw RAMCart na tryb zapisu i odczytu"},
/* ru */ {IDCLS_RAMCART_READ_WRITE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_RAMCART_READ_WRITE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_RAMCART_READ_WRITE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ramcart.c */
/* en */ {IDCLS_RAMCART_SIZE,    N_("Size of the RAMCART expansion. (64/128)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_RAMCART_SIZE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_RAMCART_SIZE_DE, "Gre der RAMCART Erweiterung. (64/128)"},
/* es */ {IDCLS_RAMCART_SIZE_ES, "Tamao expansin RAMCart. (64/128)"},
/* fr */ {IDCLS_RAMCART_SIZE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_RAMCART_SIZE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_RAMCART_SIZE_IT, "Dimensione dell'espansione RAMCART. (64/128)"},
/* ko */ {IDCLS_RAMCART_SIZE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_RAMCART_SIZE_NL, "Grootte van de RAMCART uitbreiding. (64/128)"},
/* pl */ {IDCLS_RAMCART_SIZE_PL, "Rozmiar rozszerzenia RAMCART. (64/128)"},
/* ru */ {IDCLS_RAMCART_SIZE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_RAMCART_SIZE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_RAMCART_SIZE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/debugcart.c */
/* en */ {IDCLS_ENABLE_DEBUGCART,    N_("Enable Debug cartridge")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_DEBUGCART_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_DEBUGCART_DE, "Debug Modul aktivieren"},
/* es */ {IDCLS_ENABLE_DEBUGCART_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_DEBUGCART_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_DEBUGCART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_DEBUGCART_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_DEBUGCART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_DEBUGCART_NL, "Debug cartridge inschakelen"},
/* pl */ {IDCLS_ENABLE_DEBUGCART_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_DEBUGCART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_DEBUGCART_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_DEBUGCART_TR, ""},  /* fuzzy */
#endif

/* c64/cart/debugcart.c */
/* en */ {IDCLS_DISABLE_DEBUGCART,    N_("Disable Debug cartridge")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_DEBUGCART_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_DEBUGCART_DE, "Debug Modul deaktivieren"},
/* es */ {IDCLS_DISABLE_DEBUGCART_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_DEBUGCART_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_DEBUGCART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_DEBUGCART_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_DEBUGCART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_DEBUGCART_NL, "Debug cartridge uitschakelen"},
/* pl */ {IDCLS_DISABLE_DEBUGCART_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_DEBUGCART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_DEBUGCART_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_DEBUGCART_TR, ""},  /* fuzzy */
#endif

/* c64/cart/dqbb.c */
/* en */ {IDCLS_ENABLE_DQBB,    N_("Enable Double Quick Brown Box")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_DQBB_DA, "Aktivr Double Quick Brown Box"},
/* de */ {IDCLS_ENABLE_DQBB_DE, "Double Quick Brown Box aktivieren"},
/* es */ {IDCLS_ENABLE_DQBB_ES, "Permitir Double Quick Brown Box"},
/* fr */ {IDCLS_ENABLE_DQBB_FR, "Activer Double Quick Brown Box"},
/* hu */ {IDCLS_ENABLE_DQBB_HU, "Double Quick Brown Box engedlyezse"},
/* it */ {IDCLS_ENABLE_DQBB_IT, "Attiva Double Quick Brown Box"},
/* ko */ {IDCLS_ENABLE_DQBB_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_DQBB_NL, "Double Quick Brown Box cartridge inschakelen"},
/* pl */ {IDCLS_ENABLE_DQBB_PL, "Wcz Double Quick Brown Box"},
/* ru */ {IDCLS_ENABLE_DQBB_RU, "Enable Double Quick Brown Box"},
/* sv */ {IDCLS_ENABLE_DQBB_SV, "Aktivera Double Quick Brown Box"},
/* tr */ {IDCLS_ENABLE_DQBB_TR, "Double Quick Brown Box' aktif et"},
#endif

/* c64/cart/dqbb.c */
/* en */ {IDCLS_DISABLE_DQBB,    N_("Disable Double Quick Brown Box")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_DQBB_DA, "Deaktivr Double Quick Brown Box"},
/* de */ {IDCLS_DISABLE_DQBB_DE, "Double Quick Brown Box Modul deaktivieren"},
/* es */ {IDCLS_DISABLE_DQBB_ES, "Deshabilitar Double Quick Brown Box"},
/* fr */ {IDCLS_DISABLE_DQBB_FR, "Dsactiver Double Quick Brown Box"},
/* hu */ {IDCLS_DISABLE_DQBB_HU, "Double Quick Brown Box tiltsa"},
/* it */ {IDCLS_DISABLE_DQBB_IT, "Disattiva Double Quick Brown Box"},
/* ko */ {IDCLS_DISABLE_DQBB_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_DQBB_NL, "Double Quick Brown Box cartridge uitschakelen"},
/* pl */ {IDCLS_DISABLE_DQBB_PL, "Wycz Double Quick Brown Box"},
/* ru */ {IDCLS_DISABLE_DQBB_RU, "Disable Double Quick Brown Box"},
/* sv */ {IDCLS_DISABLE_DQBB_SV, "Inaktivera Double Quick Brown Box"},
/* tr */ {IDCLS_DISABLE_DQBB_TR, "Double Quick Brown Box' pasifletir"},
#endif

/* c64/cart/dqbb.c */
/* en */ {IDCLS_SPECIFY_DQBB_NAME,    N_("Specify Double Quick Brown Box filename")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_DQBB_NAME_DA, "Angiv filnavn for Double Quick Brown Box"},
/* de */ {IDCLS_SPECIFY_DQBB_NAME_DE, "Double Quick Brown Box Dateiname spezifizieren"},
/* es */ {IDCLS_SPECIFY_DQBB_NAME_ES, "Especificar fichero imagen Double Quick Brown Box"},
/* fr */ {IDCLS_SPECIFY_DQBB_NAME_FR, "Spcifier nom de fichier Double Quick Brown Box"},
/* hu */ {IDCLS_SPECIFY_DQBB_NAME_HU, "Adja meg a Double Quick Brown Box fjlnevet"},
/* it */ {IDCLS_SPECIFY_DQBB_NAME_IT, "Specifica il nome del file Double Quick Brown Box"},
/* ko */ {IDCLS_SPECIFY_DQBB_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_DQBB_NAME_NL, "Geef de naam van het Double Quick Brown Box cartridge bestand"},
/* pl */ {IDCLS_SPECIFY_DQBB_NAME_PL, "Okrel nazw pliku Double Quick Brown Box"},
/* ru */ {IDCLS_SPECIFY_DQBB_NAME_RU, "Specify Double Quick Brown Box filename"},
/* sv */ {IDCLS_SPECIFY_DQBB_NAME_SV, "Ange filnamn fr Double Quick Brown Box"},
/* tr */ {IDCLS_SPECIFY_DQBB_NAME_TR, "Double Quick Brown Box dosya ismi belirt"},
#endif

/* c64/cart/dqbb.c */
/* en */ {IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE,    N_("Allow writing to DQBB image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE_DA, "Tillad skrivning til DQBB-image."},
/* de */ {IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE_DE, "Schreibzugriff auf DQBB Image erlauben"},
/* es */ {IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE_ES, "Permitir grabacin en imagen DQBB "},
/* fr */ {IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE_FR, "Permettre l'criture  l'image DQBB"},
/* hu */ {IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE_IT, "Attiva scrittura su immagine DQBB"},
/* ko */ {IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE_NL, "Sta schrijven naar DQBB bestand toe"},
/* pl */ {IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE_PL, "Pozwl na zapis do obrazu DQBB"},
/* ru */ {IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE_RU, "Allow writing to DQBB image"},
/* sv */ {IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE_SV, "Tillt skrivning till DQBB-avbildning"},
/* tr */ {IDCLS_ALLOW_WRITING_TO_DQBB_IMAGE_TR, "DQBB imajna yazmay aktif et"},
#endif

/* c64/cart/dqbb.c */
/* en */ {IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE,    N_("Do not write to DQBB image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE_DA, "Skriv ikke til DQBB-image"},
/* de */ {IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE_DE, "Kein Schreibzugriff auf DQBB Image"},
/* es */ {IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE_ES, "No permitir grabacin en imagen DQBB "},
/* fr */ {IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE_FR, "Ne pas crire sur l'image  DQBB"},
/* hu */ {IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE_IT, "Disattiva scrittura su immagine DQBB"},
/* ko */ {IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE_NL, "Schrijf niet naar DQBB bestand"},
/* pl */ {IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE_PL, "Nie zapisuj do obrazu DQBB"},
/* ru */ {IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE_RU, "Do not write to DQBB image"},
/* sv */ {IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE_SV, "Skriv inte till DQBB-avbildning"},
/* tr */ {IDCLS_DO_NOT_WRITE_TO_DQBB_IMAGE_TR, "DQBB imajna yazma"},
#endif

/* c64/cart/isepic.c */
/* en */ {IDCLS_ENABLE_ISEPIC,    N_("Enable the ISEPIC cartridge")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_ISEPIC_DA, "Aktivr ISEPIC-cartridge"},
/* de */ {IDCLS_ENABLE_ISEPIC_DE, "ISEPIC Modul aktivieren"},
/* es */ {IDCLS_ENABLE_ISEPIC_ES, "Permitir cartucho ISEPIC"},
/* fr */ {IDCLS_ENABLE_ISEPIC_FR, "Activer la cartouche ISEPIC"},
/* hu */ {IDCLS_ENABLE_ISEPIC_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_ISEPIC_IT, "Attiva la cartuccia ISEPIC"},
/* ko */ {IDCLS_ENABLE_ISEPIC_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_ISEPIC_NL, "ISEPIC cartridge inschakelen"},
/* pl */ {IDCLS_ENABLE_ISEPIC_PL, "Wcz kartrid ISEPIC"},
/* ru */ {IDCLS_ENABLE_ISEPIC_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_ISEPIC_SV, "Aktivera ISEPIC-modul"},
/* tr */ {IDCLS_ENABLE_ISEPIC_TR, "ISEPIC kartuunu aktif et"},
#endif

/* c64/cart/isepic.c */
/* en */ {IDCLS_DISABLE_ISEPIC,    N_("Disable the ISEPIC cartridge")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_ISEPIC_DA, "Deaktivr ISEPIC-cartridget"},
/* de */ {IDCLS_DISABLE_ISEPIC_DE, "ISEPIC Modul deaktivieren"},
/* es */ {IDCLS_DISABLE_ISEPIC_ES, "Deshabilitar cartucho ISEPIC"},
/* fr */ {IDCLS_DISABLE_ISEPIC_FR, "Dsactiver la cartouche ISEPIC"},
/* hu */ {IDCLS_DISABLE_ISEPIC_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_ISEPIC_IT, "Disattiva la cartuccia ISEPIC"},
/* ko */ {IDCLS_DISABLE_ISEPIC_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_ISEPIC_NL, "ISEPIC cartridge uitschakelen"},
/* pl */ {IDCLS_DISABLE_ISEPIC_PL, "Wycz kartrid ISEPIC"},
/* ru */ {IDCLS_DISABLE_ISEPIC_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_ISEPIC_SV, "Inaktivera ISEPIC-modul"},
/* tr */ {IDCLS_DISABLE_ISEPIC_TR, "ISEPIC kartuunu pasifletir"},
#endif

/* c64/cart/isepic.c */
/* en */ {IDCLS_ENABLE_ISEPIC_SWITCH,    N_("Enable the ISEPIC switch")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_ISEPIC_SWITCH_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_ISEPIC_SWITCH_DE, "ISEPIC Schalter aktivieren"},
/* es */ {IDCLS_ENABLE_ISEPIC_SWITCH_ES, "Permitir conmutacin ISEPIC"},
/* fr */ {IDCLS_ENABLE_ISEPIC_SWITCH_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_ISEPIC_SWITCH_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_ISEPIC_SWITCH_IT, "Attiva l'interrutore  ISEPIC"},
/* ko */ {IDCLS_ENABLE_ISEPIC_SWITCH_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_ISEPIC_SWITCH_NL, "Activeer de ISEPIC schakelaar"},
/* pl */ {IDCLS_ENABLE_ISEPIC_SWITCH_PL, "Ustaw przecznik ISEPIC"},
/* ru */ {IDCLS_ENABLE_ISEPIC_SWITCH_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_ISEPIC_SWITCH_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_ISEPIC_SWITCH_TR, ""},  /* fuzzy */
#endif

/* c64/cart/isepic.c */
/* en */ {IDCLS_DISABLE_ISEPIC_SWITCH,    N_("Disable the ISEPIC switch")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_ISEPIC_SWITCH_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_ISEPIC_SWITCH_DE, "ISEPIC Schalter deaktivieren"},
/* es */ {IDCLS_DISABLE_ISEPIC_SWITCH_ES, "Deshabilitar conmutacin ISEPIC"},
/* fr */ {IDCLS_DISABLE_ISEPIC_SWITCH_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_ISEPIC_SWITCH_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_ISEPIC_SWITCH_IT, "Disattiva l'interrutore  ISEPIC"},
/* ko */ {IDCLS_DISABLE_ISEPIC_SWITCH_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_ISEPIC_SWITCH_NL, "Deactiveer de ISEPIC schakelaar"},
/* pl */ {IDCLS_DISABLE_ISEPIC_SWITCH_PL, "Wycz przecznik ISEPIC"},
/* ru */ {IDCLS_DISABLE_ISEPIC_SWITCH_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_ISEPIC_SWITCH_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_ISEPIC_SWITCH_TR, ""},  /* fuzzy */
#endif

/* c64/cart/isepic.c */
/* en */ {IDCLS_SET_ISEPIC_FILENAME,    N_("Set ISEPIC image name")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_ISEPIC_FILENAME_DA, "Vlg ISEPIC image-navn"},
/* de */ {IDCLS_SET_ISEPIC_FILENAME_DE, "ISEPIC Imagedateiname setzen"},
/* es */ {IDCLS_SET_ISEPIC_FILENAME_ES, "Seleccionar nombre imagen ISEPIC"},
/* fr */ {IDCLS_SET_ISEPIC_FILENAME_FR, "Nom de l'image ISEPIC"},
/* hu */ {IDCLS_SET_ISEPIC_FILENAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_ISEPIC_FILENAME_IT, "Imposta nome immagine ISEPIC"},
/* ko */ {IDCLS_SET_ISEPIC_FILENAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_ISEPIC_FILENAME_NL, "Geef de naam op van het ISEPIC cartridge bestand"},
/* pl */ {IDCLS_SET_ISEPIC_FILENAME_PL, "Okrel nazw obrazu ISEPIC"},
/* ru */ {IDCLS_SET_ISEPIC_FILENAME_RU, "Set ISEPIC image name"},
/* sv */ {IDCLS_SET_ISEPIC_FILENAME_SV, "Namn p ISEPIC-avbildning"},
/* tr */ {IDCLS_SET_ISEPIC_FILENAME_TR, "ISEPIC imaj ismini belirle"},
#endif

/* c64/cart/isepic.c */
/* en */ {IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE,    N_("Allow writing to ISEPIC image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE_DA, "Tillad skrivning til ISEPIC-image"},
/* de */ {IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE_DE, "Schreibzugriff auf ISEPIC Image erlauben"},
/* es */ {IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE_ES, "Permitir grabacin en imagen ISEPIC"},
/* fr */ {IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE_FR, "Permettre l'criture sur l'image ISEPIC"},
/* hu */ {IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE_IT, "Attiva scrittura su immagine ISEPIC"},
/* ko */ {IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE_NL, "Sta schrijven naar ISEPIC bestand toe"},
/* pl */ {IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE_PL, "Pozwl na zapis do obrazu ISEPIC"},
/* ru */ {IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE_RU, "Allow writing to ISEPIC image"},
/* sv */ {IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE_SV, "Tillt skrivning till ISEPIC-avbildning"},
/* tr */ {IDCLS_ALLOW_WRITING_TO_ISEPIC_IMAGE_TR, "ISEPIC imajna yazmay aktif et"},
#endif

/* c64/cart/isepic.c */
/* en */ {IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE,    N_("Do not write to ISEPIC image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE_DA, "Skriv ikke til ISEPIC-image"},
/* de */ {IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE_DE, "Kein Schreibzugriff auf ISEPIC Image"},
/* es */ {IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE_ES, "No permitir grabacin en imagen ISEPIC"},
/* fr */ {IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE_FR, "Ne pas crire sur l'image ISEPIC"},
/* hu */ {IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE_IT, "Disattiva scrittura su immagine ISEPIC"},
/* ko */ {IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE_NL, "Schrijf niet naar ISEPIC bestand"},
/* pl */ {IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE_PL, "Nie zapisuj do obrazu ISEPIC"},
/* ru */ {IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE_RU, "Do not write to ISEPIC image"},
/* sv */ {IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE_SV, "Skriv inte till ISEPIC-avbildning"},
/* tr */ {IDCLS_DO_NOT_WRITE_TO_ISEPIC_IMAGE_TR, "ISEPIC imajna yazma"},
#endif

/* c64/cart/magicvoice.c */
/* en */ {IDCLS_SPECIFY_MAGICVOICE_IMAGE_NAME,    N_("Specify name of Magic Voice ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_MAGICVOICE_IMAGE_NAME_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_MAGICVOICE_IMAGE_NAME_DE, "Name fr Magic Voice ROM Imagedatei whlen"},
/* es */ {IDCLS_SPECIFY_MAGICVOICE_IMAGE_NAME_ES, "Especificar nombre imagen Magic Voice ROM"},
/* fr */ {IDCLS_SPECIFY_MAGICVOICE_IMAGE_NAME_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_MAGICVOICE_IMAGE_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_MAGICVOICE_IMAGE_NAME_IT, "Specifica il nome immagine della ROM Magic Voice"},
/* ko */ {IDCLS_SPECIFY_MAGICVOICE_IMAGE_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_MAGICVOICE_IMAGE_NAME_NL, "Geef de naam van het Magic Voice ROM bestand op"},
/* pl */ {IDCLS_SPECIFY_MAGICVOICE_IMAGE_NAME_PL, "Okrel nazw obrazu ROM Magic Voice"},
/* ru */ {IDCLS_SPECIFY_MAGICVOICE_IMAGE_NAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_MAGICVOICE_IMAGE_NAME_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_MAGICVOICE_IMAGE_NAME_TR, ""},  /* fuzzy */
#endif

/* c64/cart/mmc64.c */
/* en */ {IDCLS_ENABLE_MAGICVOICE,    N_("Enable the Magic Voice cartridge")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_MAGICVOICE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_MAGICVOICE_DE, "DigiMAX Cartridge aktivieren"},
/* es */ {IDCLS_ENABLE_MAGICVOICE_ES, "Permitir cartucho Magic Voice"},
/* fr */ {IDCLS_ENABLE_MAGICVOICE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_MAGICVOICE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_MAGICVOICE_IT, "Attiva la cartuccia Magic Voice"},
/* ko */ {IDCLS_ENABLE_MAGICVOICE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_MAGICVOICE_NL, "Magic Voice cartridge inschakelen"},
/* pl */ {IDCLS_ENABLE_MAGICVOICE_PL, "Wcz kartrid Magic Voice"},
/* ru */ {IDCLS_ENABLE_MAGICVOICE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_MAGICVOICE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_MAGICVOICE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/mmc64.c */
/* en */ {IDCLS_DISABLE_MAGICVOICE,    N_("Disable the Magic Voice cartridge")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_MAGICVOICE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_MAGICVOICE_DE, "DigiMAX Cartridge deaktivieren"},
/* es */ {IDCLS_DISABLE_MAGICVOICE_ES, "Deshabilitar cartucho Magic Voice"},
/* fr */ {IDCLS_DISABLE_MAGICVOICE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_MAGICVOICE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_MAGICVOICE_IT, "Disattiva la  cartuccia Magic Voice"},
/* ko */ {IDCLS_DISABLE_MAGICVOICE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_MAGICVOICE_NL, "Magic Voice cartridge uitschakelen"},
/* pl */ {IDCLS_DISABLE_MAGICVOICE_PL, "Wycz kartrid Magic Voice"},
/* ru */ {IDCLS_DISABLE_MAGICVOICE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_MAGICVOICE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_MAGICVOICE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/mmc64.c */
/* en */ {IDCLS_ENABLE_MMC64,    N_("Enable the MMC64 expansion")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_MMC64_DA, "Aktivr MMC64-udviddelse"},
/* de */ {IDCLS_ENABLE_MMC64_DE, "MMC64 Erweiterung aktivieren"},
/* es */ {IDCLS_ENABLE_MMC64_ES, "Permitir expansin MMC64"},
/* fr */ {IDCLS_ENABLE_MMC64_FR, "Activer l'expansion MMC64"},
/* hu */ {IDCLS_ENABLE_MMC64_HU, "MMC64 bvts engedlyezse"},
/* it */ {IDCLS_ENABLE_MMC64_IT, "Attiva l'espansione MMC64"},
/* ko */ {IDCLS_ENABLE_MMC64_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_MMC64_NL, "MMC64 uitbreiding inschakelen"},
/* pl */ {IDCLS_ENABLE_MMC64_PL, "Wcz rozszerzenie MMC64"},
/* ru */ {IDCLS_ENABLE_MMC64_RU, "Enable the MMC64 expansion"},
/* sv */ {IDCLS_ENABLE_MMC64_SV, "Aktivera MMC64-expansion"},
/* tr */ {IDCLS_ENABLE_MMC64_TR, "MMC64 genilemesini aktif et"},
#endif

/* c64/cart/mmc64.c */
/* en */ {IDCLS_DISABLE_MMC64,    N_("Disable the MMC64 expansion")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_MMC64_DA, "Deaktivr MMC64-udviddelse"},
/* de */ {IDCLS_DISABLE_MMC64_DE, "MMC64 Erweiterung deaktivieren"},
/* es */ {IDCLS_DISABLE_MMC64_ES, "Deshabilitar expansin MMC64"},
/* fr */ {IDCLS_DISABLE_MMC64_FR, "Dsactiver l'expansion MMC64"},
/* hu */ {IDCLS_DISABLE_MMC64_HU, "MMC64 bvts tiltsa"},
/* it */ {IDCLS_DISABLE_MMC64_IT, "Disattiva l'espansione MMC64"},
/* ko */ {IDCLS_DISABLE_MMC64_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_MMC64_NL, "MMC64 uitbreiding uitschakelen"},
/* pl */ {IDCLS_DISABLE_MMC64_PL, "Wycz rozszerzenie MMC64"},
/* ru */ {IDCLS_DISABLE_MMC64_RU, "Disable the MMC64 expansion"},
/* sv */ {IDCLS_DISABLE_MMC64_SV, "Inaktivera MMC64-expansion"},
/* tr */ {IDCLS_DISABLE_MMC64_TR, "MMC64 genilemesini pasifletir"},
#endif

/* c64/cart/mmc64.c */
/* en */ {IDCLS_SPECIFY_MMC64_BIOS_NAME,    N_("Specify name of MMC64 BIOS image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_MMC64_BIOS_NAME_DA, "Angiv navn p MMC64-BIOS-image"},
/* de */ {IDCLS_SPECIFY_MMC64_BIOS_NAME_DE, "Name fr MMC64 BIOS Datei spezifizieren"},
/* es */ {IDCLS_SPECIFY_MMC64_BIOS_NAME_ES, "Especificar nombre imagen BIOS MMC64"},
/* fr */ {IDCLS_SPECIFY_MMC64_BIOS_NAME_FR, "Spcifier le nom de l'image MMC64 BIOS"},
/* hu */ {IDCLS_SPECIFY_MMC64_BIOS_NAME_HU, "Adja meg az MMC64 BIOS kpms nevt"},
/* it */ {IDCLS_SPECIFY_MMC64_BIOS_NAME_IT, "Specifica il nome immagine del BIOS MMC64"},
/* ko */ {IDCLS_SPECIFY_MMC64_BIOS_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_MMC64_BIOS_NAME_NL, "Geef de naam van het MMC64 BIOS bestand"},
/* pl */ {IDCLS_SPECIFY_MMC64_BIOS_NAME_PL, "Okrel nazw obrazu BIOS MMC64"},
/* ru */ {IDCLS_SPECIFY_MMC64_BIOS_NAME_RU, "Specify name of MMC64 BIOS image"},
/* sv */ {IDCLS_SPECIFY_MMC64_BIOS_NAME_SV, "Ange namn p MMC64-BIOS-avbildning"},
/* tr */ {IDCLS_SPECIFY_MMC64_BIOS_NAME_TR, "MMC64 BIOS imajnn ismini belirt"},
#endif

/* c64/cart/mmc64.c */
/* en */ {IDCLS_SPECIFY_MMC64_IMAGE_NAME,    N_("Specify name of MMC64 image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_MMC64_IMAGE_NAME_DA, "Angiv navn p MMC64-image"},
/* de */ {IDCLS_SPECIFY_MMC64_IMAGE_NAME_DE, "Name der MMC64 Imagedatei whlen"},
/* es */ {IDCLS_SPECIFY_MMC64_IMAGE_NAME_ES, "Especificar nombre imagen MMC64"},
/* fr */ {IDCLS_SPECIFY_MMC64_IMAGE_NAME_FR, "Spcifier le nom de l'image MMC64"},
/* hu */ {IDCLS_SPECIFY_MMC64_IMAGE_NAME_HU, "Adja meg az MMC64 kpms nevt"},
/* it */ {IDCLS_SPECIFY_MMC64_IMAGE_NAME_IT, "Specifica il nome immagine MMC64"},
/* ko */ {IDCLS_SPECIFY_MMC64_IMAGE_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_MMC64_IMAGE_NAME_NL, "Geef de naam van het MMC64 bestand"},
/* pl */ {IDCLS_SPECIFY_MMC64_IMAGE_NAME_PL, "Okrel nazw obrazu MMC64"},
/* ru */ {IDCLS_SPECIFY_MMC64_IMAGE_NAME_RU, "Specify name of MMC64 image"},
/* sv */ {IDCLS_SPECIFY_MMC64_IMAGE_NAME_SV, "Ange namn p MMC64-avbildning"},
/* tr */ {IDCLS_SPECIFY_MMC64_IMAGE_NAME_TR, "MMC64 imajnn ismini belirt"},
#endif

/* c64/cart/mmc64.c */
/* en */ {IDCLS_SPECIFY_MMC64_REVISION,    N_("Specify MMC64 revision (0: Rev A, 1: Rev B)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_MMC64_REVISION_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_MMC64_REVISION_DE, "Setze MMC64 Revision (0: Rev A, 1: Rev B)"},
/* es */ {IDCLS_SPECIFY_MMC64_REVISION_ES, "Especificar revisin MMC64 (0: Rev A, 1: Rev B)"},
/* fr */ {IDCLS_SPECIFY_MMC64_REVISION_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_MMC64_REVISION_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_MMC64_REVISION_IT, "Specifica la revisione MMC64 (0: Rev A, 1: Rev B)"},
/* ko */ {IDCLS_SPECIFY_MMC64_REVISION_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_MMC64_REVISION_NL, "Geef de MMC64 revisie (0: Rev A, 1: Rev B)"},
/* pl */ {IDCLS_SPECIFY_MMC64_REVISION_PL, "Okrel wersj MMC64 (0: Rev A, 1: Rev B)"},
/* ru */ {IDCLS_SPECIFY_MMC64_REVISION_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_MMC64_REVISION_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_MMC64_REVISION_TR, ""},  /* fuzzy */
#endif

/* c64/cart/mmc64.c */
/* en */ {IDCLS_SPECIFY_MMC64_SD_TYPE,    N_("Specify MMC64 SD type (0: auto, 1: MMC, 2: SD, 3: SDHC)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_MMC64_SD_TYPE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_MMC64_SD_TYPE_DE, "Setze MMC64 SD Typ (0: Auto, 1: MMC, 2: SD, 3: SDHC)"},
/* es */ {IDCLS_SPECIFY_MMC64_SD_TYPE_ES, "Especificar tipo MMC64 SD (0: auto, 1: MMC, 2: SD, 3: SDHC)"},
/* fr */ {IDCLS_SPECIFY_MMC64_SD_TYPE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_MMC64_SD_TYPE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_MMC64_SD_TYPE_IT, "Specifica il tipo di SD dell'MMC64 (0: auto, 1: MMC, 2: SD, 3: SDHC)"},
/* ko */ {IDCLS_SPECIFY_MMC64_SD_TYPE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_MMC64_SD_TYPE_NL, "Geef het MMC64 SD soort op (0: automatisch, 1: MMC, 2: SD, 3: SDHC)"},
/* pl */ {IDCLS_SPECIFY_MMC64_SD_TYPE_PL, "Okrel typ SD MMC64 (0: Auto, 1: MMC, 2: SD, 3: SDHC)"},
/* ru */ {IDCLS_SPECIFY_MMC64_SD_TYPE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_MMC64_SD_TYPE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_MMC64_SD_TYPE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/mmc64.c */
/* en */ {IDCLS_MMC64_READONLY,    N_("Set the MMC64 card to read-only")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MMC64_READONLY_DA, "Skrivebeskyt MMC64-kort"},
/* de */ {IDCLS_MMC64_READONLY_DE, "MMC64 Karte Schreibschutz"},
/* es */ {IDCLS_MMC64_READONLY_ES, "Seleccionar tarjeta MMC64 en modo slo lectura"},
/* fr */ {IDCLS_MMC64_READONLY_FR, "Dfinir la carte MMC64 en lecture seule"},
/* hu */ {IDCLS_MMC64_READONLY_HU, "MMC64 krtya csak olvashat"},
/* it */ {IDCLS_MMC64_READONLY_IT, "Imposta la card MMC64 in sola lettura"},
/* ko */ {IDCLS_MMC64_READONLY_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_MMC64_READONLY_NL, "Stel de MMC64 in als alleen-lezen"},
/* pl */ {IDCLS_MMC64_READONLY_PL, "Ustaw kart MMC64 na tryb tylko do odczytu"},
/* ru */ {IDCLS_MMC64_READONLY_RU, "Set the MMC64 card to read-only"},
/* sv */ {IDCLS_MMC64_READONLY_SV, "Skrivskydda MMC64-kort"},
/* tr */ {IDCLS_MMC64_READONLY_TR, "MMC64 kartn salt okunura evir"},
#endif

/* c64/cart/mmc64.c */
/* en */ {IDCLS_MMC64_READWRITE,    N_("Set the MMC64 card to read/write")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MMC64_READWRITE_DA, "Tillad skrivning p MMC64-kort"},
/* de */ {IDCLS_MMC64_READWRITE_DE, "MMC64 Karte Schreibzugriff"},
/* es */ {IDCLS_MMC64_READWRITE_ES, "Seleccionar tarjeta MMC64 en modo lectura/grabacin"},
/* fr */ {IDCLS_MMC64_READWRITE_FR, "Dfinir la carte MMC64 en lecture/criture"},
/* hu */ {IDCLS_MMC64_READWRITE_HU, "MMC64 krtya rhat/olvashat"},
/* it */ {IDCLS_MMC64_READWRITE_IT, "Imposta la card MMC64 in lettura/scrittura"},
/* ko */ {IDCLS_MMC64_READWRITE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_MMC64_READWRITE_NL, "Stel de MMC64 in als lezen/schrijven"},
/* pl */ {IDCLS_MMC64_READWRITE_PL, "Ustaw kart MMC64 na tryb zapisu i odczytu"},
/* ru */ {IDCLS_MMC64_READWRITE_RU, "Set the MMC64 card to read/write"},
/* sv */ {IDCLS_MMC64_READWRITE_SV, "Tillt skrivning p MMC64-kort"},
/* tr */ {IDCLS_MMC64_READWRITE_TR, "MMC64 kartn okunur/yazlra evir"},
#endif

/* c64/cart/mmc64.c */
/* en */ {IDCLS_MMC64_BIOS_WRITE,    N_("Save the MMC64 bios when changed")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MMC64_BIOS_WRITE_DA, "Gem MMC64-BIOS ved ndring"},
/* de */ {IDCLS_MMC64_BIOS_WRITE_DE, "MMC64 BIOS speichern bei nderung"},
/* es */ {IDCLS_MMC64_BIOS_WRITE_ES, "Grabar BIOS MMC64 cuando cambie"},
/* fr */ {IDCLS_MMC64_BIOS_WRITE_FR, "Sauvegarder le BIOS MMC64 lorsque modifi"},
/* hu */ {IDCLS_MMC64_BIOS_WRITE_HU, "MMC64 BIOS mentse vltozs utn"},
/* it */ {IDCLS_MMC64_BIOS_WRITE_IT, "Salva il bios MMC64 alla modifica"},
/* ko */ {IDCLS_MMC64_BIOS_WRITE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_MMC64_BIOS_WRITE_NL, "Sla de MMC64 BIOS op bij wijziging"},
/* pl */ {IDCLS_MMC64_BIOS_WRITE_PL, "Zapisuj bios MMC64 przy zmianie"},
/* ru */ {IDCLS_MMC64_BIOS_WRITE_RU, "Save the MMC64 bios when changed"},
/* sv */ {IDCLS_MMC64_BIOS_WRITE_SV, "Spara MMC64-BIOS vid ndring"},
/* tr */ {IDCLS_MMC64_BIOS_WRITE_TR, "MMC64 BIOS'unu deitiinde kaydet"},
#endif

/* c64/cart/mmc64.c */
/* en */ {IDCLS_MMC64_BIOS_READ_ONLY,    N_("Do not save the MMC64 bios when changed")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MMC64_BIOS_READ_ONLY_DA, ""},  /* fuzzy */
/* de */ {IDCLS_MMC64_BIOS_READ_ONLY_DE, "MMC64 BIOS nicht speichern bei nderung"},
/* es */ {IDCLS_MMC64_BIOS_READ_ONLY_ES, "No grabar BIOS MMC64 cuando cambie"},
/* fr */ {IDCLS_MMC64_BIOS_READ_ONLY_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_MMC64_BIOS_READ_ONLY_HU, ""},  /* fuzzy */
/* it */ {IDCLS_MMC64_BIOS_READ_ONLY_IT, "Non salvare il bios MMC64 alla modifica"},
/* ko */ {IDCLS_MMC64_BIOS_READ_ONLY_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_MMC64_BIOS_READ_ONLY_NL, "Sla de MMC64 BIOS niet op bij wijziging"},
/* pl */ {IDCLS_MMC64_BIOS_READ_ONLY_PL, "Nie zapisuj bios-a MMC64 przy zmianie"},
/* ru */ {IDCLS_MMC64_BIOS_READ_ONLY_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_MMC64_BIOS_READ_ONLY_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_MMC64_BIOS_READ_ONLY_TR, ""},  /* fuzzy */
#endif

/* c64/cart/mmc64.c */
/* en */ {IDCLS_MMC64_SET_FLASH_JUMPER,    N_("Set the MMC64 Flash Jumper")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MMC64_SET_FLASH_JUMPER_DA, ""},  /* fuzzy */
/* de */ {IDCLS_MMC64_SET_FLASH_JUMPER_DE, "Aktiviere MMC64 Flash Jumper"},
/* es */ {IDCLS_MMC64_SET_FLASH_JUMPER_ES, "Seleccionar el  MMC64 Flash Jumper"},
/* fr */ {IDCLS_MMC64_SET_FLASH_JUMPER_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_MMC64_SET_FLASH_JUMPER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_MMC64_SET_FLASH_JUMPER_IT, "Imposta il ponticello flash della MMC64"},
/* ko */ {IDCLS_MMC64_SET_FLASH_JUMPER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_MMC64_SET_FLASH_JUMPER_NL, "Stel de MMC64 Flash Jumper in"},
/* pl */ {IDCLS_MMC64_SET_FLASH_JUMPER_PL, "Ustaw zwork MMC64 Flash"},
/* ru */ {IDCLS_MMC64_SET_FLASH_JUMPER_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_MMC64_SET_FLASH_JUMPER_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_MMC64_SET_FLASH_JUMPER_TR, ""},  /* fuzzy */
#endif

/* c64/cart/mmc64.c */
/* en */ {IDCLS_MMC64_UNSET_FLASH_JUMPER,    N_("Remove the MMC64 Flash Jumper")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MMC64_UNSET_FLASH_JUMPER_DA, ""},  /* fuzzy */
/* de */ {IDCLS_MMC64_UNSET_FLASH_JUMPER_DE, "Deaktiviere MMC64 Flash Jumper"},
/* es */ {IDCLS_MMC64_UNSET_FLASH_JUMPER_ES, "Quitar el  MMC64 Flash Jumper"},
/* fr */ {IDCLS_MMC64_UNSET_FLASH_JUMPER_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_MMC64_UNSET_FLASH_JUMPER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_MMC64_UNSET_FLASH_JUMPER_IT, "Rimuovi il ponticello flash della MMC64"},
/* ko */ {IDCLS_MMC64_UNSET_FLASH_JUMPER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_MMC64_UNSET_FLASH_JUMPER_NL, "Verwijder de MMC64 Flash Jumper"},
/* pl */ {IDCLS_MMC64_UNSET_FLASH_JUMPER_PL, "Usu zwork RR Flash"},
/* ru */ {IDCLS_MMC64_UNSET_FLASH_JUMPER_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_MMC64_UNSET_FLASH_JUMPER_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_MMC64_UNSET_FLASH_JUMPER_TR, ""},  /* fuzzy */
#endif

/* c64/cart/rrnetmk3.c */
/* en */ {IDCLS_RRNETMK3_BIOS_WRITE,    N_("Save the RRNETMK3 bios when changed")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_RRNETMK3_BIOS_WRITE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_RRNETMK3_BIOS_WRITE_DE, "RRNETMK3 BIOS speichern bei nderung"},
/* es */ {IDCLS_RRNETMK3_BIOS_WRITE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_RRNETMK3_BIOS_WRITE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_RRNETMK3_BIOS_WRITE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_RRNETMK3_BIOS_WRITE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_RRNETMK3_BIOS_WRITE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_RRNETMK3_BIOS_WRITE_NL, "Sla de RRNET MK3 bios op bij wijziging"},
/* pl */ {IDCLS_RRNETMK3_BIOS_WRITE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_RRNETMK3_BIOS_WRITE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_RRNETMK3_BIOS_WRITE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_RRNETMK3_BIOS_WRITE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/rrnetmk3.c */
/* en */ {IDCLS_RRNETMK3_BIOS_READ_ONLY,    N_("Do not save the RRNETMK3 bios when changed")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_RRNETMK3_BIOS_READ_ONLY_DA, ""},  /* fuzzy */
/* de */ {IDCLS_RRNETMK3_BIOS_READ_ONLY_DE, "RRNETMK3 BIOS nicht speichern bei nderung"},
/* es */ {IDCLS_RRNETMK3_BIOS_READ_ONLY_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_RRNETMK3_BIOS_READ_ONLY_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_RRNETMK3_BIOS_READ_ONLY_HU, ""},  /* fuzzy */
/* it */ {IDCLS_RRNETMK3_BIOS_READ_ONLY_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_RRNETMK3_BIOS_READ_ONLY_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_RRNETMK3_BIOS_READ_ONLY_NL, "Sla de RRNET MK3 bios niet op bij wijziging"},
/* pl */ {IDCLS_RRNETMK3_BIOS_READ_ONLY_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_RRNETMK3_BIOS_READ_ONLY_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_RRNETMK3_BIOS_READ_ONLY_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_RRNETMK3_BIOS_READ_ONLY_TR, ""},  /* fuzzy */
#endif

/* c64/cart/rrnetmk3.c */
/* en */ {IDCLS_RRNETMK3_SET_FLASH_JUMPER,    N_("Set the RRNETMK3 Flash Jumper")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_RRNETMK3_SET_FLASH_JUMPER_DA, ""},  /* fuzzy */
/* de */ {IDCLS_RRNETMK3_SET_FLASH_JUMPER_DE, "Aktiviere RRNETMK3 Flash Jumper"},
/* es */ {IDCLS_RRNETMK3_SET_FLASH_JUMPER_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_RRNETMK3_SET_FLASH_JUMPER_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_RRNETMK3_SET_FLASH_JUMPER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_RRNETMK3_SET_FLASH_JUMPER_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_RRNETMK3_SET_FLASH_JUMPER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_RRNETMK3_SET_FLASH_JUMPER_NL, "Stel de RRNET MK3 Flash Jumper in"},
/* pl */ {IDCLS_RRNETMK3_SET_FLASH_JUMPER_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_RRNETMK3_SET_FLASH_JUMPER_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_RRNETMK3_SET_FLASH_JUMPER_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_RRNETMK3_SET_FLASH_JUMPER_TR, ""},  /* fuzzy */
#endif

/* c64/cart/rrnetmk3.c */
/* en */ {IDCLS_RRNETMK3_UNSET_FLASH_JUMPER,    N_("Remove the RRNETMK3 Flash Jumper")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_RRNETMK3_UNSET_FLASH_JUMPER_DA, ""},  /* fuzzy */
/* de */ {IDCLS_RRNETMK3_UNSET_FLASH_JUMPER_DE, "Deaktiviere RRNETMK3 Flash Jumper"},
/* es */ {IDCLS_RRNETMK3_UNSET_FLASH_JUMPER_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_RRNETMK3_UNSET_FLASH_JUMPER_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_RRNETMK3_UNSET_FLASH_JUMPER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_RRNETMK3_UNSET_FLASH_JUMPER_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_RRNETMK3_UNSET_FLASH_JUMPER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_RRNETMK3_UNSET_FLASH_JUMPER_NL, "Verwijder de RRNET MK3 Flash Jumper"},
/* pl */ {IDCLS_RRNETMK3_UNSET_FLASH_JUMPER_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_RRNETMK3_UNSET_FLASH_JUMPER_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_RRNETMK3_UNSET_FLASH_JUMPER_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_RRNETMK3_UNSET_FLASH_JUMPER_TR, ""},  /* fuzzy */
#endif

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME,    N_("Specify MMC Replay card image filename")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_DA, "Angiv filnavn for MMC Replay kort-image"},
/* de */ {IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_DE, "MMC Replay Modul imeage datei whlen"},
/* es */ {IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_ES, "Especificar fichero imagen tarjeta MMC Replay"},
/* fr */ {IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_FR, "Spcifier le nom du fichier de l'image carte MMC Replay"},
/* hu */ {IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_IT, "Specifica il nome file immagine della card MMC Replay"},
/* ko */ {IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_NL, "Geef de naam van het MMC Replay card bestand"},
/* pl */ {IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_PL, "Okrel nazw pliku obrazu karty MMC Replay"},
/* ru */ {IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_RU, "Specify MMC Replay card image filename"},
/* sv */ {IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_SV, "Ange namn p avbildningsfil fr MMC Replay-kort"},
/* tr */ {IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_TR, "MMC Replay kart imaj dosyaismini belirt"},
#endif

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_SELECT_MMC_REPLAY_SD_TYPE,    N_("Specify MMC Replay SD type (0: auto, 1: MMC, 2: SD, 3: SDHC)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SELECT_MMC_REPLAY_SD_TYPE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SELECT_MMC_REPLAY_SD_TYPE_DE, "Setze MMC Replay SD type (0: Auto, 1: MMC, 2: SD, 3: SDHC)"},
/* es */ {IDCLS_SELECT_MMC_REPLAY_SD_TYPE_ES, "Especificar tipo MMC Replay SD (0: auto, 1: MMC, 2: SD, 3: SDHC)"},
/* fr */ {IDCLS_SELECT_MMC_REPLAY_SD_TYPE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SELECT_MMC_REPLAY_SD_TYPE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SELECT_MMC_REPLAY_SD_TYPE_IT, "Specifica il tipo di SD dell'MMC Replay (0: auto, 1: MMC, 2: SD, 3: SDHC)"},
/* ko */ {IDCLS_SELECT_MMC_REPLAY_SD_TYPE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SELECT_MMC_REPLAY_SD_TYPE_NL, "Geef de MMC Replay SD soort op (0: automatisch, 1: MMC, 2: SD, 3: SDHC)"},
/* pl */ {IDCLS_SELECT_MMC_REPLAY_SD_TYPE_PL, "Okrel typ SD MMC Replay (0: Auto, 1: MMC, 2: SD, 3: SDHC)"},
/* ru */ {IDCLS_SELECT_MMC_REPLAY_SD_TYPE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SELECT_MMC_REPLAY_SD_TYPE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SELECT_MMC_REPLAY_SD_TYPE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE,    N_("Enable writes to MMC Replay card image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_DA, "Tillad skrivning til MMC Replay kort-image"},
/* de */ {IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_DE, "Erlaube Schreibzugriff auf MMC Replay Imagedatei"},
/* es */ {IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_ES, "Permitir grabacin en imagen tarjeta MMC Replay"},
/* fr */ {IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_FR, "Permetre l'criture  l'image MMC Replay"},
/* hu */ {IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_IT, "Attiva scrittura su immagine card MMC Replay"},
/* ko */ {IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_NL, "Schrijven naar MMC Replay card bestand inschakelen"},
/* pl */ {IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_PL, "Wcz zapis do obrazu karty MMC Replay"},
/* ru */ {IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_RU, "Enable writes to MMC Replay card image"},
/* sv */ {IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_SV, "Aktivera skrivning till MMC Replay-kortavbildning"},
/* tr */ {IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_TR, "MMC Replay kart imajnda yazmalar aktif et"},
#endif

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE,    N_("Disable writes to MMC Replay card image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_DA, "Skriv ikke til MMC Replay kort-image"},
/* de */ {IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_DE, "Schreibzugriff auf MMC Replay Imagedatei verhindern"},
/* es */ {IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_ES, "Deshabilitar grabacin en imagen tarjeta MMC Replay"},
/* fr */ {IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_FR, "Interdire l'criture  l'image MMC Replay"},
/* hu */ {IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_IT, "Disattiva scrittura su immagine card MMC Replay"},
/* ko */ {IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_NL, "Schrijven naar het MMC Replay card bestand uitschakelen"},
/* pl */ {IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_PL, "Wycz zapis do obrazu karty MMC Replay"},
/* ru */ {IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_RU, "Disable writes to MMC Replay card image"},
/* sv */ {IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_SV, "Inaktivera skrivning till MMC Replay-kortavbildning"},
/* tr */ {IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_TR, "MMC Replay kart imajnda yazmalar pasifletir"},
#endif

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE,    N_("Specify MMC Replay EEPROM image filename")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_DA, "Angiv filnavn for MMC Replay EEPROM-image"},
/* de */ {IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_DE, "MMC Replay EEPROM Imagedatei whlen"},
/* es */ {IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_ES, "Especificar nombre fichero imagen EEPROM MMC Replay"},
/* fr */ {IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_FR, "Spcifier le nom du fichier de l'image EEPROM MMC Replay"},
/* hu */ {IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_IT, "Specifica il nome file immagine della EEPROM MMC Replay"},
/* ko */ {IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_NL, "Geef de naam van het MMC Replay EEPROM bestand"},
/* pl */ {IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_PL, "Okrel nazw pliku obrazu EEPROM MMC Replay"},
/* ru */ {IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_RU, "Specify MMC Replay EEPROM image filename"},
/* sv */ {IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_SV, "Ange filnamn fr MMC Replay EEPROM-avbildning"},
/* tr */ {IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_TR, "MMC Replay EEPROM imaj dosyaismini belirt"},
#endif

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE,    N_("Enable writes to MMC Replay EEPROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_DA, "Tillad skrivning til MMC Replay EEPROM-image"},
/* de */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_DE, "Erlaube Schreibzugriff auf MMC Replay EEPROM Imagedatei"},
/* es */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_ES, "Permitir grabacin en imagen EEPROM MMC Replay"},
/* fr */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_FR, "Permetre l'criture  l'image MMC Replay EEPROM"},
/* hu */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_IT, "Attiva scrittura su immagine EEPROM MMC Replay"},
/* ko */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_KO, "MMC Replay EEPROM ̹   ϰ ϱ"},
/* nl */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_NL, "Schrijven naar MMC Replay EEPROM bestand inschakelen"},
/* pl */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_PL, "Wcz zapis do obrazu EEPROM MMC Replay"},
/* ru */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_RU, "Enable writes to MMC Replay EEPROM image"},
/* sv */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_SV, "Aktivera skrivning till MMC Replay EEPROM-avbildning"},
/* tr */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_TR, "MMC Replay EEPROM imajnda yazmalar aktif et"},
#endif

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE,    N_("Disable writes to MMC Replay EEPROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_DA, "Skriv ikke til MMC Replay EEPROM-image"},
/* de */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_DE, "Schreibzugriff auf MMC Replay EEPROM Imagedatei verhindern"},
/* es */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_ES, "Deshabilitar grabacin en imagen EEPROM MMC Replay"},
/* fr */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_FR, "Interdire l'criture  l'image MMC Replay EEPROM"},
/* hu */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_IT, "Disattiva scrittura su immagine EEPROM MMC Replay"},
/* ko */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_NL, "Schrijven naar MMC Replay EEPROM bestand uitschakelen"},
/* pl */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_PL, "Wycz zapis do obrazu EEPROM MMC Replay"},
/* ru */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_RU, "Disable writes to MMC Replay EEPROM image"},
/* sv */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_SV, "Inaktivera skrivning till MMC Replay EEPROM-avbildning"},
/* tr */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_TR, "MMC Replay EEPROM imajnda yazmalar pasifletir"},
#endif

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE,    N_("Enable MMC Replay rescue mode")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_DA, "Aktivr MMC Replay fejlsikret tilstand"},
/* de */ {IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_DE, "MMC Replay Rescue Modus aktivieren"},
/* es */ {IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_ES, "Permitir modo rescate MMC Replay "},
/* fr */ {IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_FR, "Activer le mode de secours MMC Replay"},
/* hu */ {IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_IT, "Attiva modalit ripristino MMC Replay"},
/* ko */ {IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_NL, "MMC Replay reddingsmodus inschakelen"},
/* pl */ {IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_PL, "Wcz tryb ratunkowy MMC Replay"},
/* ru */ {IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_RU, "Enable MMC Replay rescue mode"},
/* sv */ {IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_SV, "Aktivera MMC Replay-rddningslge"},
/* tr */ {IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_TR, "MMC Replay kurtarma modunu aktif et"},
#endif

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE,    N_("Disable MMC Replay rescue mode")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_DA, "Deaktivr MMC Replay fejlsikret tilstand"},
/* de */ {IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_DE, "MMC Replay Rescue Modus deaktivieren"},
/* es */ {IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_ES, "Deshabilitar modo rescate MMC Replay "},
/* fr */ {IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_FR, "Dsactiver le mode de secours MMC Replay"},
/* hu */ {IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_IT, "Disattiva modalit ripristino MMC Replay"},
/* ko */ {IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_NL, "MMC Replay reddingsmodus uitschakelen"},
/* pl */ {IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_PL, "Wycz tryb ratunkowy MMC Replay"},
/* ru */ {IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_RU, "Disable MMC Replay rescue mode"},
/* sv */ {IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_SV, "Inaktivera MMC Replay-rddningslge"},
/* tr */ {IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_TR, "MMC Replay kurtarma modunu pasifletir"},
#endif

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE,    N_("Allow writing to MMC Replay image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE_DA, "Tillad skrivning til MMC Replay-image"},
/* de */ {IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE_DE, "Erlaube Schreibzugriff auf MMC Replay Image"},
/* es */ {IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE_ES, "Permitir grabacin en imagen MMC Replay"},
/* fr */ {IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE_FR, "Permetre l'criture  l'image MMC Replay"},
/* hu */ {IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE_IT, "Attiva scrittura su immagine MMC Replay"},
/* ko */ {IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE_NL, "Sta schrijven naar MMC Replay bestand toe"},
/* pl */ {IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE_PL, "Pozwl na zapis do obrazu MMC Replay"},
/* ru */ {IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE_RU, "Allow writing to MMC Replay image"},
/* sv */ {IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE_SV, "Tillt skrivning till MMC Replay-avbildning"},
/* tr */ {IDCLS_ALLOW_WRITING_TO_MMC_REPLAY_IMAGE_TR, "MMC Replay imajna yazmay aktif et"},
#endif

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE,    N_("Do not write to MMC Replay image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE_DA, "Skriv ikke til MMC Replay-image"},
/* de */ {IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE_DE, "Kein Schreibzugriff auf MMC Replay Image"},
/* es */ {IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE_ES, "No grabar en imagen MMC Replay"},
/* fr */ {IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE_FR, "Interdire l'criture  l'image MMC Replay"},
/* hu */ {IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE_IT, "Disattiva scrittura su immagine MMC Replay"},
/* ko */ {IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE_NL, "Schrijf niet naar MMC Replay bestand"},
/* pl */ {IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE_PL, "Nie zapisuj do obrazu MMC Replay"},
/* ru */ {IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE_RU, "Do not write to MMC Replay image"},
/* sv */ {IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE_SV, "Skriv inte till MMC Replay-avbildning"},
/* tr */ {IDCLS_DO_NOT_WRITE_TO_MMC_REPLAY_IMAGE_TR, "MMC Replay imajna yazma"},
#endif

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_SELECT_GMOD2_EEPROM_IMAGE,    N_("Specify GMod2 EEPROM image filename")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SELECT_GMOD2_EEPROM_IMAGE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SELECT_GMOD2_EEPROM_IMAGE_DE, "GMod2 EEPROM Imagedatei whlen"},
/* es */ {IDCLS_SELECT_GMOD2_EEPROM_IMAGE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SELECT_GMOD2_EEPROM_IMAGE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SELECT_GMOD2_EEPROM_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SELECT_GMOD2_EEPROM_IMAGE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SELECT_GMOD2_EEPROM_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SELECT_GMOD2_EEPROM_IMAGE_NL, "Geef de naam van het GMod2 EEPROM bestand"},
/* pl */ {IDCLS_SELECT_GMOD2_EEPROM_IMAGE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_SELECT_GMOD2_EEPROM_IMAGE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SELECT_GMOD2_EEPROM_IMAGE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SELECT_GMOD2_EEPROM_IMAGE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_GMOD2_EEPROM_WRITE_ENABLE,    N_("Enable writes to GMod2 EEPROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_GMOD2_EEPROM_WRITE_ENABLE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_GMOD2_EEPROM_WRITE_ENABLE_DE, "Erlaube Schreibzugriff auf GMod2 EEPROM Image"},
/* es */ {IDCLS_GMOD2_EEPROM_WRITE_ENABLE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_GMOD2_EEPROM_WRITE_ENABLE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_GMOD2_EEPROM_WRITE_ENABLE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_GMOD2_EEPROM_WRITE_ENABLE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_GMOD2_EEPROM_WRITE_ENABLE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_GMOD2_EEPROM_WRITE_ENABLE_NL, "Schrijven naar GMod2 EEPROM bestand inschakelen"},
/* pl */ {IDCLS_GMOD2_EEPROM_WRITE_ENABLE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_GMOD2_EEPROM_WRITE_ENABLE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_GMOD2_EEPROM_WRITE_ENABLE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_GMOD2_EEPROM_WRITE_ENABLE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_GMOD2_EEPROM_WRITE_DISABLE,    N_("Disable writes to GMod2 EEPROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_GMOD2_EEPROM_WRITE_DISABLE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_GMOD2_EEPROM_WRITE_DISABLE_DE, "Schreibzugriff auf GMod2 EEPROM Imagedatei verhindern"},
/* es */ {IDCLS_GMOD2_EEPROM_WRITE_DISABLE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_GMOD2_EEPROM_WRITE_DISABLE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_GMOD2_EEPROM_WRITE_DISABLE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_GMOD2_EEPROM_WRITE_DISABLE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_GMOD2_EEPROM_WRITE_DISABLE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_GMOD2_EEPROM_WRITE_DISABLE_NL, "Schrijven naar GMod2 EEPROM bestand uitschakelen"},
/* pl */ {IDCLS_GMOD2_EEPROM_WRITE_DISABLE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_GMOD2_EEPROM_WRITE_DISABLE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_GMOD2_EEPROM_WRITE_DISABLE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_GMOD2_EEPROM_WRITE_DISABLE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/gmod2.c */
/* en */ {IDCLS_ENABLE_SAVE_GMOD2_ROM_AT_EXIT,    N_("Enable saving of the GMod2 ROM at exit")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_SAVE_GMOD2_ROM_AT_EXIT_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_SAVE_GMOD2_ROM_AT_EXIT_DE, "Speichern des GMod2 ROMs beim Beenden aktivieren"},
/* es */ {IDCLS_ENABLE_SAVE_GMOD2_ROM_AT_EXIT_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_SAVE_GMOD2_ROM_AT_EXIT_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_SAVE_GMOD2_ROM_AT_EXIT_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_SAVE_GMOD2_ROM_AT_EXIT_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_SAVE_GMOD2_ROM_AT_EXIT_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_SAVE_GMOD2_ROM_AT_EXIT_NL, "Opslaan van het GMod2 ROM bestand bij afsluiten inschakelen"},
/* pl */ {IDCLS_ENABLE_SAVE_GMOD2_ROM_AT_EXIT_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_SAVE_GMOD2_ROM_AT_EXIT_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_SAVE_GMOD2_ROM_AT_EXIT_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_SAVE_GMOD2_ROM_AT_EXIT_TR, ""},  /* fuzzy */
#endif

/* c64/cart/gmod2.c */
/* en */ {IDCLS_DISABLE_SAVE_GMOD2_ROM_AT_EXIT,    N_("Disable saving of the GMod2 ROM at exit")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_SAVE_GMOD2_ROM_AT_EXIT_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_SAVE_GMOD2_ROM_AT_EXIT_DE, "Speichern des GMod2 ROMs beim Beenden deaktivieren"},
/* es */ {IDCLS_DISABLE_SAVE_GMOD2_ROM_AT_EXIT_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_SAVE_GMOD2_ROM_AT_EXIT_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_SAVE_GMOD2_ROM_AT_EXIT_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_SAVE_GMOD2_ROM_AT_EXIT_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_SAVE_GMOD2_ROM_AT_EXIT_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_SAVE_GMOD2_ROM_AT_EXIT_NL, "Opslaan van het GMod2 ROM bestand bij afsluiten uitschakelen"},
/* pl */ {IDCLS_DISABLE_SAVE_GMOD2_ROM_AT_EXIT_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_SAVE_GMOD2_ROM_AT_EXIT_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_SAVE_GMOD2_ROM_AT_EXIT_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_SAVE_GMOD2_ROM_AT_EXIT_TR, ""},  /* fuzzy */
#endif

/* c64/cart/retroreplay.c */
/* en */ {IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT,    N_("Enable saving of the RR ROM at exit")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_DA, "Aktivr skrivning af RR ROM ved afslutning"},
/* de */ {IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_DE, "Speichern des RR ROMs beim Beenden aktivieren"},
/* es */ {IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_ES, "Permitir grabar ROM RR al salir"},
/* fr */ {IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_FR, "Activer la sauvegarde du ROM RR  la fin du programme"},
/* hu */ {IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_IT, "Attiva salvataggio ROM della RR all'uscita"},
/* ko */ {IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_NL, "Opslaan van het RR ROM bestand bij afsluiten inschakelen"},
/* pl */ {IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_PL, "Wcz zapis ROM RR przy wyjciu"},
/* ru */ {IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_RU, "Enable saving of the RR ROM at exit"},
/* sv */ {IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_SV, "Aktivera sparande av RR-ROM vid avslutning"},
/* tr */ {IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_TR, "kta RR ROM'un kaydedilmesini aktif et"},
#endif

/* c64/cart/retroreplay.c */
/* en */ {IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT,    N_("Disable saving of the RR ROM at exit")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_DA, "Dektivr skrivning af RR ROM ved afslutning"},
/* de */ {IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_DE, "Speichern des RR ROMs beim Beenden deaktivieren"},
/* es */ {IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_ES, "Deshabilitar grabar ROM RR al salir"},
/* fr */ {IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_FR, "Dsactiver la sauvegarde du ROM RR  la fin du programme"},
/* hu */ {IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_IT, "Disattiva salvataggio ROM della RR all'uscita"},
/* ko */ {IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_NL, "Opslaan van het RR ROM bestand bij afsluiten uitschakelen"},
/* pl */ {IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_PL, "Wycz zapis ROM RR przy wyjciu"},
/* ru */ {IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_RU, "Disable saving of the RR ROM at exit"},
/* sv */ {IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_SV, "Inaktivera sparande av RR-ROM vid avslutning"},
/* tr */ {IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_TR, "kta RR ROM'un kaydedilmesini pasifletir"},
#endif

/* c64/cart/retroreplay.c */
/* en */ {IDCLS_SET_RR_BANK_JUMPER,    N_("Set RR Bank Jumper")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_RR_BANK_JUMPER_DA, "Tilslut RR Bank Jumper"},
/* de */ {IDCLS_SET_RR_BANK_JUMPER_DE, "Aktiviere RR Bank Jumper"},
/* es */ {IDCLS_SET_RR_BANK_JUMPER_ES, "Seleccionar conmutador banco RR"},
/* fr */ {IDCLS_SET_RR_BANK_JUMPER_FR, "Activer le jumper Banque RR"},
/* hu */ {IDCLS_SET_RR_BANK_JUMPER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_RR_BANK_JUMPER_IT, "Imposta ponticello bank della RR"},
/* ko */ {IDCLS_SET_RR_BANK_JUMPER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_RR_BANK_JUMPER_NL, "Stel RR bank jumper in"},
/* pl */ {IDCLS_SET_RR_BANK_JUMPER_PL, "Ustaw zwork RR Bank"},
/* ru */ {IDCLS_SET_RR_BANK_JUMPER_RU, "Set RR Bank Jumper"},
/* sv */ {IDCLS_SET_RR_BANK_JUMPER_SV, "Aktivera RR-bankbygel"},
/* tr */ {IDCLS_SET_RR_BANK_JUMPER_TR, "RR Bank Jumper' tak"},
#endif

/* c64/cart/retroreplay.c */
/* en */ {IDCLS_UNSET_RR_BANK_JUMPER,    N_("Unset RR Bank Jumper")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_UNSET_RR_BANK_JUMPER_DA, "Afbryd RR Bank Jumper"},
/* de */ {IDCLS_UNSET_RR_BANK_JUMPER_DE, "Deaktiviere RR Bank Jumper"},
/* es */ {IDCLS_UNSET_RR_BANK_JUMPER_ES, "Quitar conmutador banco RR"},
/* fr */ {IDCLS_UNSET_RR_BANK_JUMPER_FR, "Ne pas activer le jumper Banque RR"},
/* hu */ {IDCLS_UNSET_RR_BANK_JUMPER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_UNSET_RR_BANK_JUMPER_IT, "Rimuovi ponticello bank della RR"},
/* ko */ {IDCLS_UNSET_RR_BANK_JUMPER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_UNSET_RR_BANK_JUMPER_NL, "Verwijder RR bank jumper"},
/* pl */ {IDCLS_UNSET_RR_BANK_JUMPER_PL, "Usu zwork RR Bank"},
/* ru */ {IDCLS_UNSET_RR_BANK_JUMPER_RU, "Unset RR Bank Jumper"},
/* sv */ {IDCLS_UNSET_RR_BANK_JUMPER_SV, "Inaktivera RR-bankbygel"},
/* tr */ {IDCLS_UNSET_RR_BANK_JUMPER_TR, "RR Bank Jumper' kart"},
#endif

/* c64/cart/retroreplay.c */
/* en */ {IDCLS_SET_RR_FLASH_JUMPER,    N_("Set RR Flash Jumper")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_RR_FLASH_JUMPER_DA, "Tilslut RR Flash jumper"},
/* de */ {IDCLS_SET_RR_FLASH_JUMPER_DE, "Aktviere RR Flash Jumper"},
/* es */ {IDCLS_SET_RR_FLASH_JUMPER_ES, "Seleccionar conmutador RR Flash"},
/* fr */ {IDCLS_SET_RR_FLASH_JUMPER_FR, "Activer le Jumper RR Flash"},
/* hu */ {IDCLS_SET_RR_FLASH_JUMPER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_RR_FLASH_JUMPER_IT, "Imposta ponticello flash della RR"},
/* ko */ {IDCLS_SET_RR_FLASH_JUMPER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_RR_FLASH_JUMPER_NL, "Stel RR Flash Jumper in"},
/* pl */ {IDCLS_SET_RR_FLASH_JUMPER_PL, "Ustaw przecznik RR Flash"},
/* ru */ {IDCLS_SET_RR_FLASH_JUMPER_RU, "Set RR Flash Jumper"},
/* sv */ {IDCLS_SET_RR_FLASH_JUMPER_SV, "Stt RR-flashbygel"},
/* tr */ {IDCLS_SET_RR_FLASH_JUMPER_TR, "RR Flash Jumper' tak"},
#endif

/* c64/cart/retroreplay.c */
/* en */ {IDCLS_UNSET_RR_FLASH_JUMPER,    N_("Unset RR Bank Jumper")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_UNSET_RR_FLASH_JUMPER_DA, "Afbryd RR Bank Jumper"},
/* de */ {IDCLS_UNSET_RR_FLASH_JUMPER_DE, "Deaktiviere RR Bank Jumper"},
/* es */ {IDCLS_UNSET_RR_FLASH_JUMPER_ES, "Quitar conmutador banco RR"},
/* fr */ {IDCLS_UNSET_RR_FLASH_JUMPER_FR, "Ne pas activer le jumper Banque RR"},
/* hu */ {IDCLS_UNSET_RR_FLASH_JUMPER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_UNSET_RR_FLASH_JUMPER_IT, "Rimuovi ponticello bank della RR"},
/* ko */ {IDCLS_UNSET_RR_FLASH_JUMPER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_UNSET_RR_FLASH_JUMPER_NL, "Verwijder RR bank jumper"},
/* pl */ {IDCLS_UNSET_RR_FLASH_JUMPER_PL, "Usu zwork RR Bank"},
/* ru */ {IDCLS_UNSET_RR_FLASH_JUMPER_RU, "Unset RR Bank Jumper"},
/* sv */ {IDCLS_UNSET_RR_FLASH_JUMPER_SV, "Inaktivera RR-bankbygel"},
/* tr */ {IDCLS_UNSET_RR_FLASH_JUMPER_TR, "RR Bank Jumper' kart"},
#endif

/* c64/cart/retroreplay.c */
/* en */ {IDCLS_RR_REVISION,    N_("Set RR Revision (0: Retro Replay, 1: Nordic Replay)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_RR_REVISION_DA, ""},  /* fuzzy */
/* de */ {IDCLS_RR_REVISION_DE, "RR Revision (0: Retro Replay, 1: Nordic Replay)"},
/* es */ {IDCLS_RR_REVISION_ES, "Seleccionar RR Revision (0: Retro Replay, 1: Nordic Replay)"},
/* fr */ {IDCLS_RR_REVISION_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_RR_REVISION_HU, ""},  /* fuzzy */
/* it */ {IDCLS_RR_REVISION_IT, "Imposta revisione RR (0: Retro Replay, 1: Nordic Replay)"},
/* ko */ {IDCLS_RR_REVISION_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_RR_REVISION_NL, "Stel RR Revisie in (0: Retro Replay, 1: Nordic Replay)"},
/* pl */ {IDCLS_RR_REVISION_PL, "Okrel wersj RR (0: Retro Replay, 1: Nordic Replay)"},
/* ru */ {IDCLS_RR_REVISION_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_RR_REVISION_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_RR_REVISION_TR, ""},  /* fuzzy */
#endif

/* c64/cart/supersnapshot.c */
/* en */ {IDCLS_ENABLE_SS_RAM_EXPANSION,    N_("Enable SS 32k RAM expansion")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_SS_RAM_EXPANSION_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_SS_RAM_EXPANSION_DE, "SS 32k RAM Erweiterung aktivieren"},
/* es */ {IDCLS_ENABLE_SS_RAM_EXPANSION_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_SS_RAM_EXPANSION_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_SS_RAM_EXPANSION_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_SS_RAM_EXPANSION_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_SS_RAM_EXPANSION_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_SS_RAM_EXPANSION_NL, "SS 32k RAM uitbreiding inschakelen"},
/* pl */ {IDCLS_ENABLE_SS_RAM_EXPANSION_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_SS_RAM_EXPANSION_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_SS_RAM_EXPANSION_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_SS_RAM_EXPANSION_TR, ""},  /* fuzzy */
#endif

/* c64/cart/supersnapshot.c */
/* en */ {IDCLS_DISABLE_SS_RAM_EXPANSION,    N_("Disable SS 32k RAM expansion")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_SS_RAM_EXPANSION_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_SS_RAM_EXPANSION_DE, "SS 32k RAM Erweiterung deaktivieren"},
/* es */ {IDCLS_DISABLE_SS_RAM_EXPANSION_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_SS_RAM_EXPANSION_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_SS_RAM_EXPANSION_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_SS_RAM_EXPANSION_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_SS_RAM_EXPANSION_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_SS_RAM_EXPANSION_NL, "SS 32k RAM uitbreiding uitschakelen"},
/* pl */ {IDCLS_DISABLE_SS_RAM_EXPANSION_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_SS_RAM_EXPANSION_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_SS_RAM_EXPANSION_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_SS_RAM_EXPANSION_TR, ""},  /* fuzzy */
#endif

/* c64/cart/reu.c */
/* en */ {IDCLS_ENABLE_REU,    N_("Enable the RAM Expansion Unit")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_REU_DA, "Aktivr RAM-udviddelsesenheden"},
/* de */ {IDCLS_ENABLE_REU_DE, "RAM Speichererweiterung aktivieren"},
/* es */ {IDCLS_ENABLE_REU_ES, "Permitir unidad RAM expansion"},
/* fr */ {IDCLS_ENABLE_REU_FR, "Activer l'unit d'expansion RAM"},
/* hu */ {IDCLS_ENABLE_REU_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_REU_IT, "Attiva l'espansione di RAM"},
/* ko */ {IDCLS_ENABLE_REU_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_REU_NL, "RAM uitbreidingseenheid (REU) inschakelen"},
/* pl */ {IDCLS_ENABLE_REU_PL, "Wcz RAM Expansion Unit"},
/* ru */ {IDCLS_ENABLE_REU_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_REU_SV, "Aktivera RAM-expansionsenhet"},
/* tr */ {IDCLS_ENABLE_REU_TR, "RAM Geniletme Birimi'ni aktif et"},
#endif

/* c64/cart/reu.c */
/* en */ {IDCLS_DISABLE_REU,    N_("Disable the RAM Expansion Unit")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_REU_DA, "Deaktivr RAM-udviddelsesenhed"},
/* de */ {IDCLS_DISABLE_REU_DE, "RAM Speichererweiterung deaktivieren"},
/* es */ {IDCLS_DISABLE_REU_ES, "Deshabilitar unidad RAM Expansion"},
/* fr */ {IDCLS_DISABLE_REU_FR, "Dsactiver l'unit d'expansion RAM"},
/* hu */ {IDCLS_DISABLE_REU_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_REU_IT, "Disattiva l'espansione di RAM"},
/* ko */ {IDCLS_DISABLE_REU_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_REU_NL, "RAM uitbreidingseenheid (REU) uitschakelen"},
/* pl */ {IDCLS_DISABLE_REU_PL, "Wycz RAM Expansion Unit"},
/* ru */ {IDCLS_DISABLE_REU_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_REU_SV, "Inaktivera RAM-expansionsenhet"},
/* tr */ {IDCLS_DISABLE_REU_TR, "RAM Geniletme Birimi'ni pasifletir"},
#endif

/* c64/cart/reu.c */
/* en */ {IDCLS_SPECIFY_REU_NAME,    N_("Specify name of REU image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_REU_NAME_DA, "Angiv navn p REU-image"},
/* de */ {IDCLS_SPECIFY_REU_NAME_DE, "Namen fr REU Imagedatei whlen"},
/* es */ {IDCLS_SPECIFY_REU_NAME_ES, "Especificar nombre imagen REU"},
/* fr */ {IDCLS_SPECIFY_REU_NAME_FR, "Spcifier le nom de l'image REU"},
/* hu */ {IDCLS_SPECIFY_REU_NAME_HU, "Adja meg a REU kpms nevt"},
/* it */ {IDCLS_SPECIFY_REU_NAME_IT, "Specifica il nome immagine REU"},
/* ko */ {IDCLS_SPECIFY_REU_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_REU_NAME_NL, "Geef de naam van het REU bestand"},
/* pl */ {IDCLS_SPECIFY_REU_NAME_PL, "Okrel nazw obrazu REU"},
/* ru */ {IDCLS_SPECIFY_REU_NAME_RU, "Specify name of REU image"},
/* sv */ {IDCLS_SPECIFY_REU_NAME_SV, "Ange namn p REU-avbildning"},
/* tr */ {IDCLS_SPECIFY_REU_NAME_TR, "REU imajnn ismini belirt"},
#endif

/* c64/cart/reu.c */
/* en */ {IDCLS_ALLOW_WRITING_TO_REU_IMAGE,    N_("Allow writing to REU image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ALLOW_WRITING_TO_REU_IMAGE_DA, "Tillad skrivning til REU-image"},
/* de */ {IDCLS_ALLOW_WRITING_TO_REU_IMAGE_DE, "Schreibzugriff auf REU Image erlauben"},
/* es */ {IDCLS_ALLOW_WRITING_TO_REU_IMAGE_ES, "Permitir grabar en imagen REU"},
/* fr */ {IDCLS_ALLOW_WRITING_TO_REU_IMAGE_FR, "Permetre l'criture  l'image REU"},
/* hu */ {IDCLS_ALLOW_WRITING_TO_REU_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ALLOW_WRITING_TO_REU_IMAGE_IT, "Attiva scrittura su immagine REU"},
/* ko */ {IDCLS_ALLOW_WRITING_TO_REU_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ALLOW_WRITING_TO_REU_IMAGE_NL, "Sta schrijven naar REU bestand toe"},
/* pl */ {IDCLS_ALLOW_WRITING_TO_REU_IMAGE_PL, "Pozwl na zapis do obrazu REU"},
/* ru */ {IDCLS_ALLOW_WRITING_TO_REU_IMAGE_RU, "Allow writing to REU image"},
/* sv */ {IDCLS_ALLOW_WRITING_TO_REU_IMAGE_SV, "Tillt skrivning till REU-avbildning"},
/* tr */ {IDCLS_ALLOW_WRITING_TO_REU_IMAGE_TR, "REU imajna yazmay aktif et"},
#endif

/* c64/cart/reu.c */
/* en */ {IDCLS_DO_NOT_WRITE_TO_REU_IMAGE,    N_("Do not write to REU image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DO_NOT_WRITE_TO_REU_IMAGE_DA, "Skriv ikke til REU-image"},
/* de */ {IDCLS_DO_NOT_WRITE_TO_REU_IMAGE_DE, "Kein Schreibzugriff auf REU Image"},
/* es */ {IDCLS_DO_NOT_WRITE_TO_REU_IMAGE_ES, "No grabar en imagen REU"},
/* fr */ {IDCLS_DO_NOT_WRITE_TO_REU_IMAGE_FR, "Interdire l'criture  l'image REU"},
/* hu */ {IDCLS_DO_NOT_WRITE_TO_REU_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DO_NOT_WRITE_TO_REU_IMAGE_IT, "Disattiva scrittura su immagine REU"},
/* ko */ {IDCLS_DO_NOT_WRITE_TO_REU_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DO_NOT_WRITE_TO_REU_IMAGE_NL, "Schrijf niet naar REU bestand"},
/* pl */ {IDCLS_DO_NOT_WRITE_TO_REU_IMAGE_PL, "Nie zapisuj do obrazu REU"},
/* ru */ {IDCLS_DO_NOT_WRITE_TO_REU_IMAGE_RU, "Do not write to REU image"},
/* sv */ {IDCLS_DO_NOT_WRITE_TO_REU_IMAGE_SV, "Skriv inte till REU-avbildning"},
/* tr */ {IDCLS_DO_NOT_WRITE_TO_REU_IMAGE_TR, "REU imajna yazma"},
#endif

/* c64/cart/reu.c */
/* en */ {IDCLS_REU_SIZE,    N_("Size of the RAM expansion unit. (128/256/512/1024/2048/4096/8192/16384)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_REU_SIZE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_REU_SIZE_DE, "Gre der RAM Erweiterung. (128/256/512/1024/2048/4096/8192/16384)"},
/* es */ {IDCLS_REU_SIZE_ES, "Tamao de la unidad de expansin RAM. (128/256/512/1024/2048/4096/8192/16384)"},
/* fr */ {IDCLS_REU_SIZE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_REU_SIZE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_REU_SIZE_IT, "Dimensione dell'espansione di RAM. (128/256/512/1024/2048/4096/8192/16384)"},
/* ko */ {IDCLS_REU_SIZE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_REU_SIZE_NL, "Grootte van de RAM uitbreidingseenheid. (128/256/512/1024/2048/4096/8192/16384)"},
/* pl */ {IDCLS_REU_SIZE_PL, "Wielko jednostki rozszerzenia RAM. (128/256/512/1024/2048/4096/8192/16384)"},
/* ru */ {IDCLS_REU_SIZE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_REU_SIZE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_REU_SIZE_TR, ""},  /* fuzzy */
#endif

#ifdef HAVE_PCAP
/* c64/cart/ethernetcart.c */
/* en */ {IDCLS_ENABLE_TFE,    N_("Enable the Ethernet Cartridge in TFE (\"The Final Ethernet\") compatible mode and set default I/O address")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_TFE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_TFE_DE, "Aktiviere Ethernet Erweiterungsmodul in TFE (\"The Final Ethernet\") kompatiblen Modus und setze die Standard I/O Adresse"},
/* es */ {IDCLS_ENABLE_TFE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_TFE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_TFE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_TFE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_TFE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_TFE_NL, "Ethernet Cartridge inschakelen in TFE (\"The Final Ethernet\") compatibel modus en zet het standaard I/O adres"},
/* pl */ {IDCLS_ENABLE_TFE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_TFE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_TFE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_TFE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ethernetcart.c */
/* en */ {IDCLS_ENABLE_RRNET,    N_("Enable the Ethernet Cartridge in RR-Net compatible mode and set default I/O address")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_RRNET_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_RRNET_DE, "Aktiviere Ethernet Erweiterungsmodul in RR-Net kompatiblen Modus uns\nsetze die Standard I/O Adresse"},
/* es */ {IDCLS_ENABLE_RRNET_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_RRNET_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_RRNET_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_RRNET_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_RRNET_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_RRNET_NL, "Ethernet Cartridge inschakelen in RR-Net compatibel modus en zet het standaard I/O adres"},
/* pl */ {IDCLS_ENABLE_RRNET_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_RRNET_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_RRNET_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_RRNET_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ethernetcart.c */
/* en */ {IDCLS_ENABLE_ETHERNETCART,    N_("Enable the Ethernet Cartridge (TFE/RR-Net/64NIC/FB-NET)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_ETHERNETCART_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_ETHERNETCART_DE, "Ethernet Cartridge (TFE/RR-Net/64NIC/FB-NET) aktivieren"},
/* es */ {IDCLS_ENABLE_ETHERNETCART_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_ETHERNETCART_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_ETHERNETCART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_ETHERNETCART_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_ETHERNETCART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_ETHERNETCART_NL, "Ethernet Cartridge (TFE/RR-Net/64NIC/FB-NET) inschakelen"},
/* pl */ {IDCLS_ENABLE_ETHERNETCART_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_ETHERNETCART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_ETHERNETCART_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_ETHERNETCART_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ethernetcart.c */
/* en */ {IDCLS_DISABLE_ETHERNETCART,    N_("Disable the Ethernet Cartridge (TFE/RR-Net/64NIC/FB-NET)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_ETHERNETCART_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_ETHERNETCART_DE, "Ethernet Cartridge  (TFE/RR-Net/64NIC/FB-NET)deaktivieren"},
/* es */ {IDCLS_DISABLE_ETHERNETCART_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_ETHERNETCART_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_ETHERNETCART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_ETHERNETCART_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_ETHERNETCART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_ETHERNETCART_NL, "Ethernet Cartridge (TFE/RR-Net/64NIC/FB-NET) uitschakelen"},
/* pl */ {IDCLS_DISABLE_ETHERNETCART_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_ETHERNETCART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_ETHERNETCART_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_ETHERNETCART_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ethernetcart.c */
/* en */ {IDCLS_ETHERNETCART_BASE,    N_("Base address of the Ethernet Cartridge")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ETHERNETCART_BASE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ETHERNETCART_BASE_DE, "Basis Adresse fr Ethernet Erweiterungmodul"},
/* es */ {IDCLS_ETHERNETCART_BASE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ETHERNETCART_BASE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ETHERNETCART_BASE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ETHERNETCART_BASE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ETHERNETCART_BASE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ETHERNETCART_BASE_NL, "Basisadres van de Ethernet Cartridge"},
/* pl */ {IDCLS_ETHERNETCART_BASE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ETHERNETCART_BASE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ETHERNETCART_BASE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ETHERNETCART_BASE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ethernetcart.c */
/* en */ {IDCLS_ETHERNETCART_MODE,    N_("Mode of Ethernet Cartridge (0: TFE, 1: RR-Net)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ETHERNETCART_MODE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ETHERNETCART_MODE_DE, "Modus des Ethernet Erweiterungsmoduls (0: TFE, 1: RR-Net)"},
/* es */ {IDCLS_ETHERNETCART_MODE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ETHERNETCART_MODE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ETHERNETCART_MODE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ETHERNETCART_MODE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ETHERNETCART_MODE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ETHERNETCART_MODE_NL, "Modus van den Ethernet Cartridge (0: TFE, 1: RR-Net)"},
/* pl */ {IDCLS_ETHERNETCART_MODE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ETHERNETCART_MODE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ETHERNETCART_MODE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ETHERNETCART_MODE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/cs8900io.c */
/* en */ {IDCLS_ETHERNET_INTERFACE,    N_("Set the system ethernet interface")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ETHERNET_INTERFACE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ETHERNET_INTERFACE_DE, "Setze die System Ethernet Schnittstelle"},
/* es */ {IDCLS_ETHERNET_INTERFACE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ETHERNET_INTERFACE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ETHERNET_INTERFACE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ETHERNET_INTERFACE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ETHERNET_INTERFACE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ETHERNET_INTERFACE_NL, "Stel de systeem ethernetinterface in"},
/* pl */ {IDCLS_ETHERNET_INTERFACE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ETHERNET_INTERFACE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ETHERNET_INTERFACE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ETHERNET_INTERFACE_TR, ""},  /* fuzzy */
#endif
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_CART_ATTACH_DETACH_RESET,    N_("Reset machine if a cartridge is attached or detached")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_CART_ATTACH_DETACH_RESET_DA, "Reset maskinen hvis et cartridge tilsluttes eller frakobles"},
/* de */ {IDCLS_CART_ATTACH_DETACH_RESET_DE, "Reset der Maschine wenn ein Erweiterungsmodul eingelegt oder entfernt wird"},
/* es */ {IDCLS_CART_ATTACH_DETACH_RESET_ES, "Reiniciar mquina si un cartucho es insertado o extraido"},
/* fr */ {IDCLS_CART_ATTACH_DETACH_RESET_FR, "Rinitialiser si une cartouche est attache ou dtache"},
/* hu */ {IDCLS_CART_ATTACH_DETACH_RESET_HU, "Reset a cartridge csatolsakorgy levlasztsakor"},
/* it */ {IDCLS_CART_ATTACH_DETACH_RESET_IT, "Fare il reset del computer se una cartuccia  collegata o rimossa"},
/* ko */ {IDCLS_CART_ATTACH_DETACH_RESET_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_CART_ATTACH_DETACH_RESET_NL, "Reset machine als een cartridge wordt gekoppeld of ontkoppeld"},
/* pl */ {IDCLS_CART_ATTACH_DETACH_RESET_PL, "Resetuj maszyn przy zamontowaniu i odmontowaniu kartrida"},
/* ru */ {IDCLS_CART_ATTACH_DETACH_RESET_RU, "Reset machine if a cartridge is attached or detached"},
/* sv */ {IDCLS_CART_ATTACH_DETACH_RESET_SV, "Nollstll maskinen om en insticksmodul kopplas till eller frn"},
/* tr */ {IDCLS_CART_ATTACH_DETACH_RESET_TR, "Bir kartu taklr ya da kartlrsa makineyi resetle"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_CART_ATTACH_DETACH_NO_RESET,    N_("Do not reset machine if a cartridge is attached or detached")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_CART_ATTACH_DETACH_NO_RESET_DA, "Reset ikke maskinen hvis et cartridge tilsluttes eller frakobles"},
/* de */ {IDCLS_CART_ATTACH_DETACH_NO_RESET_DE, "Kein Reset der Maschine wenn ein Erweiterungsmodul eingelegt oder entfernt wird"},
/* es */ {IDCLS_CART_ATTACH_DETACH_NO_RESET_ES, "No reiniciar mquina si un cartucho es insertado o extraido"},
/* fr */ {IDCLS_CART_ATTACH_DETACH_NO_RESET_FR, "Ne pas rinitialiser si une cartouche est attache ou dtache"},
/* hu */ {IDCLS_CART_ATTACH_DETACH_NO_RESET_HU, "Nincs reset a cartridge csatolsakorgy levlasztsakor"},
/* it */ {IDCLS_CART_ATTACH_DETACH_NO_RESET_IT, "Non fare il reset del computer se una cartuccia  collegata o rimossa"},
/* ko */ {IDCLS_CART_ATTACH_DETACH_NO_RESET_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_CART_ATTACH_DETACH_NO_RESET_NL, "Reset machine niet als een cartridge wordt gekoppeld of ontkoppeld"},
/* pl */ {IDCLS_CART_ATTACH_DETACH_NO_RESET_PL, "Nie resetuj maszyny przy zamontowaniu i odmontowaniu kartrida"},
/* ru */ {IDCLS_CART_ATTACH_DETACH_NO_RESET_RU, "Do not reset machine if a cartridge is attached or detached"},
/* sv */ {IDCLS_CART_ATTACH_DETACH_NO_RESET_SV, "Nollstll inte maskinen om en insticksmodul kopplas till eller frn"},
/* tr */ {IDCLS_CART_ATTACH_DETACH_NO_RESET_TR, "Bir kartu taklr ya da kartlrsa makineyi resetleme"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_CRT_CART,    N_("Attach CRT cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_CRT_CART_DA, "Tilslut CRT-cartridge image"},
/* de */ {IDCLS_ATTACH_CRT_CART_DE, "CRT Erweiterungsmodul Image einlegen"},
/* es */ {IDCLS_ATTACH_CRT_CART_ES, "Insertar imagen de cartucho CRT"},
/* fr */ {IDCLS_ATTACH_CRT_CART_FR, "Insrer une cartouche CRT"},
/* hu */ {IDCLS_ATTACH_CRT_CART_HU, "CRT cartridge kpms csatolsa"},
/* it */ {IDCLS_ATTACH_CRT_CART_IT, "Seleziona immagine cartuccia CRT"},
/* ko */ {IDCLS_ATTACH_CRT_CART_KO, "CRT īƮ ̹ ٿÿ"},
/* nl */ {IDCLS_ATTACH_CRT_CART_NL, "Koppel CRT cartridge bestand"},
/* pl */ {IDCLS_ATTACH_CRT_CART_PL, "Zamontuj obraz kartrida CRT"},
/* ru */ {IDCLS_ATTACH_CRT_CART_RU, "Attach CRT cartridge image"},
/* sv */ {IDCLS_ATTACH_CRT_CART_SV, "Anslut CRT-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_CRT_CART_TR, "CRT kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_GENERIC_8KB_CART,    N_("Attach raw 8KB cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_GENERIC_8KB_CART_DA, "Tilslut rt 8kB-cartridge image"},
/* de */ {IDCLS_ATTACH_GENERIC_8KB_CART_DE, "8KB Erweiterungsmodul (raw) Image einlegen"},
/* es */ {IDCLS_ATTACH_GENERIC_8KB_CART_ES, "Insertar imagen de cartucho 8KB"},
/* fr */ {IDCLS_ATTACH_GENERIC_8KB_CART_FR, "Insrer une cartouche 8KO"},
/* hu */ {IDCLS_ATTACH_GENERIC_8KB_CART_HU, "Nyers 8KB-os cartridge kpms csatolsa"},
/* it */ {IDCLS_ATTACH_GENERIC_8KB_CART_IT, "Seleziona immagine cartuccia di 8KB"},
/* ko */ {IDCLS_ATTACH_GENERIC_8KB_CART_KO, "8kb īƮ ̹ ̼"},
/* nl */ {IDCLS_ATTACH_GENERIC_8KB_CART_NL, "Koppel binair 8KB cartridge bestand"},
/* pl */ {IDCLS_ATTACH_GENERIC_8KB_CART_PL, "Zamontuj surowy obraz kartrida 8KB"},
/* ru */ {IDCLS_ATTACH_GENERIC_8KB_CART_RU, "   8 "},
/* sv */ {IDCLS_ATTACH_GENERIC_8KB_CART_SV, "Anslut r 8KB-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_GENERIC_8KB_CART_TR, "Dz 8KB kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_GENERIC_16KB_CART,    N_("Attach raw 16KB cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_GENERIC_16KB_CART_DA, "Tilslut rt 16kB-cartridge image"},
/* de */ {IDCLS_ATTACH_GENERIC_16KB_CART_DE, "16KB Erweiterungsmodul (raw) Image einlegen"},
/* es */ {IDCLS_ATTACH_GENERIC_16KB_CART_ES, "Insertar imagen de cartucho 16KB"},
/* fr */ {IDCLS_ATTACH_GENERIC_16KB_CART_FR, "Insrer une cartouche 16KO"},
/* hu */ {IDCLS_ATTACH_GENERIC_16KB_CART_HU, "Nyers 16KB-os cartridge kpms csatolsa"},
/* it */ {IDCLS_ATTACH_GENERIC_16KB_CART_IT, "Seleziona immagine cartuccia di 16KB"},
/* ko */ {IDCLS_ATTACH_GENERIC_16KB_CART_KO, "16kb īƮ ̹ ̼"},
/* nl */ {IDCLS_ATTACH_GENERIC_16KB_CART_NL, "Koppel binair 16KB cartridge bestand"},
/* pl */ {IDCLS_ATTACH_GENERIC_16KB_CART_PL, "Zamontuj surowy obraz kartrida 16KB"},
/* ru */ {IDCLS_ATTACH_GENERIC_16KB_CART_RU, "   16 "},
/* sv */ {IDCLS_ATTACH_GENERIC_16KB_CART_SV, "Anslut r 16KB-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_GENERIC_16KB_CART_TR, "Dz 16KB kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART,    N_("Attach generic 16kB Ultimax cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART_DA, "Tilslut standard 16kB Ultimax cartridge image"},
/* de */ {IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART_DE, "Generisches 16kB Ultimax Erweiterungsmodul Image einlegen"},
/* es */ {IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART_ES, "Insertar imagen cartucho genrico Ultimax 16KB"},
/* fr */ {IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART_FR, "Attacher une cartouche gnrique 16 ko Ultimax"},
/* hu */ {IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART_IT, "Seleziona immagine cartuccia Ultimax generica di 16kB"},
/* ko */ {IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART_NL, "Koppel algemeen 16KB Ultimax cartridge bestand"},
/* pl */ {IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART_PL, "Zamontuj standardowy obraz kartrida 16kB Ultimax"},
/* ru */ {IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART_RU, "Attach generic 16kB Ultimax cartridge image"},
/* sv */ {IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART_SV, "Anslut vanlig 16KB Ultimax-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_GENERIC_16KB_ULTIMAX_CART_TR, "Jenerik 16KB Ultimax kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_STARDOS_CART,    N_("Attach raw 16KB Stardos cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_STARDOS_CART_DA, "Tilslut rt 16KB StarDOS cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_STARDOS_CART_DE, "16kB Stardos Erweiterungsmodul Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_STARDOS_CART_ES, "Insertar imagen cartucho Stardos 16KB"},
/* fr */ {IDCLS_ATTACH_RAW_STARDOS_CART_FR, "Attacher une image de cartouche 16 ko Stardos"},
/* hu */ {IDCLS_ATTACH_RAW_STARDOS_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_STARDOS_CART_IT, "Seleziona immagine cartuccia Stardos di 16KB"},
/* ko */ {IDCLS_ATTACH_RAW_STARDOS_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_STARDOS_CART_NL, "Koppel binair 16KB Stardos cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_STARDOS_CART_PL, "Zamontuj surowy obraz kartrida 16KB Stardos"},
/* ru */ {IDCLS_ATTACH_RAW_STARDOS_CART_RU, "Attach raw 16KB Stardos cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_STARDOS_CART_SV, "Anslut r 16KB Stardos-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_STARDOS_CART_TR, "Dz 16KB Stardos kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART,    N_("Attach raw 32KB Action Replay MK4 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_DA, "Tilslut rt 32KB Action Replay MK4 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_DE, "32kB Action Replay MK4 Image einlegen"},
/* es */ {IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_ES, "Insertar imagen cartucho Action Replay MK4 32KB"},
/* fr */ {IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_FR, "Attacher une image de cartouche 2 ko Action Replay MK4"},
/* hu */ {IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_IT, "Seleziona immagine cartuccia Action Replay MK4 di 326KB"},
/* ko */ {IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_NL, "Koppel binair 32KB Action Replay MK4 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_PL, "Zamontuj surowy obraz kartrida 32KB Action Replay MK4"},
/* ru */ {IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_RU, "Attach raw 32KB Action Replay MK4 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_SV, "Anslut r 32KB-Action Replay MK4-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_TR, "Dz 32KB Action Replay MK4 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART,    N_("Attach raw 16kB Action Replay MK2 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART_DA, "Tilslut rt 16kB Action Replay MK2 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART_DE, "16kB Action Replay MK2 Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART_ES, "Insertar imagen cartucho Action Replay MK2 16KB"},
/* fr */ {IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART_FR, "Attacher une image de cartouche 16 ko Action Replay MK2"},
/* hu */ {IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART_IT, "Seleziona immagine cartuccia Action Replay MK2 di 16KB"},
/* ko */ {IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART_NL, "Koppel binair 16kB Action Replay MK2 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART_PL, "Zamontuj surowy obraz kartrida 16kB Action Replay MK2"},
/* ru */ {IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART_RU, "Attach raw 16kB Action Replay MK2 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART_SV, "Anslut r 16KB-Action Replay MK2-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_ACTION_REPLAY2_CART_TR, "Dz 16kB Action Replay MK2 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART,    N_("Attach raw 16KB Action Replay MK3 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_DA, "Tilslut rt 16KB Action Replay MK3 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_DE, "16kB Action Replay MK3 Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_ES, "Insertar imagen cartucho Action Replay MK3 16KB"},
/* fr */ {IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_FR, "Attacher une image de cartouche 16 ko Action Replay MK3"},
/* hu */ {IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_IT, "Seleziona immagine cartuccia Action Replay MK3 di 16KB"},
/* ko */ {IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_NL, "Koppel binair 16KB Action Replay MK3 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_PL, "Zamontuj surowy obraz kartrida 16KB Action Replay MK3"},
/* ru */ {IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_RU, "Attach raw 16KB Action Replay MK3 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_SV, "Anslut r 16KB-Action Replay MK3-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_TR, "Dz 16KB Action Replay MK3 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_ACTION_REPLAY_CART,    N_("Attach raw 32KB Action Replay cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_DA, "Tilslut rt 32KB Action Replay cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_DE, "32kB Action Replay Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_ES, "Insertar imagen cartucho Action Replay 32KB"},
/* fr */ {IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_FR, "Insrer une cartouche Action Replay 32KO"},
/* hu */ {IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_HU, "32KB-os Action Replay cartridge kpms csatolsa"},
/* it */ {IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_IT, "Seleziona immagine cartuccia Action Replay di 32KB"},
/* ko */ {IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_NL, "Koppel binair 32KB Action Replay cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_PL, "Zamontuj surowy obraz kartida 32KB Action Replay"},
/* ru */ {IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_RU, "Attach raw 32KB Action Replay cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_SV, "Anslut r 32KB-Action Replay-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_TR, "Dz 32KB Action Replay kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_CAPTURE_CART,    N_("Attach raw 8kB Capture cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_CAPTURE_CART_DA, "Tilslut rt 8kB Capture cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_CAPTURE_CART_DE, "8kB Capture Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_CAPTURE_CART_ES, "Insertar imagen cartucho Capture 8KB"},
/* fr */ {IDCLS_ATTACH_RAW_CAPTURE_CART_FR, "Attacher une image de cartouche 8 ko Capture"},
/* hu */ {IDCLS_ATTACH_RAW_CAPTURE_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_CAPTURE_CART_IT, "Seleziona immagine cartuccia Capture di 8KB"},
/* ko */ {IDCLS_ATTACH_RAW_CAPTURE_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_CAPTURE_CART_NL, "Koppel binair 8kB Capture cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_CAPTURE_CART_PL, "Zamontuj surowy obraz kartrida 8kB Capture"},
/* ru */ {IDCLS_ATTACH_RAW_CAPTURE_CART_RU, "Attach raw 8kB Capture cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_CAPTURE_CART_SV, "Anslut r 8KB Capture-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_CAPTURE_CART_TR, "Dz 8kB Capture kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_COMAL80_CART,    N_("Attach raw 64kB Comal 80 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_COMAL80_CART_DA, "Tilslut rt 64kB Comal 80 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_COMAL80_CART_DE, "64kB Comal 80 Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_COMAL80_CART_ES, "Insertar imagen cartucho Comal 80 64KB"},
/* fr */ {IDCLS_ATTACH_RAW_COMAL80_CART_FR, "Attacher une image de cartouche 64 ko Comal 80"},
/* hu */ {IDCLS_ATTACH_RAW_COMAL80_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_COMAL80_CART_IT, "Seleziona immagine cartuccia Comal 80 di 64kB"},
/* ko */ {IDCLS_ATTACH_RAW_COMAL80_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_COMAL80_CART_NL, "Koppel binair 64kB Comal 80 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_COMAL80_CART_PL, "Zamontuj surowy obraz kartrida 64kB Comal 80"},
/* ru */ {IDCLS_ATTACH_RAW_COMAL80_CART_RU, "Attach raw 64kB Comal 80 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_COMAL80_CART_SV, "Anslut r 64kB Comal 80-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_COMAL80_CART_TR, "Dz 64kB Comal 80 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_DELA_EP256_CART,    N_("Attach raw Dela EP256 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_DELA_EP256_CART_DA, "Tilslut rt Dela EP256 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_DELA_EP256_CART_DE, "Dela EP256 Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_DELA_EP256_CART_ES, "Insertar imagen cartucho Dela EP256"},
/* fr */ {IDCLS_ATTACH_RAW_DELA_EP256_CART_FR, "Attacher une image de cartouche RAW EP256"},
/* hu */ {IDCLS_ATTACH_RAW_DELA_EP256_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_DELA_EP256_CART_IT, "Seleziona immagine cartuccia Dela EP256"},
/* ko */ {IDCLS_ATTACH_RAW_DELA_EP256_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_DELA_EP256_CART_NL, "Koppel binair Dela EP256 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_DELA_EP256_CART_PL, "Zamontuj surowy obraz kartrida Dela EP256"},
/* ru */ {IDCLS_ATTACH_RAW_DELA_EP256_CART_RU, "Attach raw Dela EP256 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_DELA_EP256_CART_SV, "Anslut r dela EP256-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_DELA_EP256_CART_TR, "Dz Dela EP256 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_DELA_EP64_CART,    N_("Attach raw Dela EP64 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_DELA_EP64_CART_DA, "Tilslut rt Dela EP64 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_DELA_EP64_CART_DE, "Dela EP64 Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_DELA_EP64_CART_ES, "Insertar imagen cartucho Dela EP64"},
/* fr */ {IDCLS_ATTACH_RAW_DELA_EP64_CART_FR, "Attacher une image de cartouche Dela EP64"},
/* hu */ {IDCLS_ATTACH_RAW_DELA_EP64_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_DELA_EP64_CART_IT, "Seleziona immagine cartuccia Dela EP64"},
/* ko */ {IDCLS_ATTACH_RAW_DELA_EP64_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_DELA_EP64_CART_NL, "Koppel binair Dela EO64 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_DELA_EP64_CART_PL, "Zamontuj surowy obraz kartrida EP64"},
/* ru */ {IDCLS_ATTACH_RAW_DELA_EP64_CART_RU, "Attach raw Dela EP64 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_DELA_EP64_CART_SV, "Anslut r Dela EP64-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_DELA_EP64_CART_TR, "Dz Dela EP64 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_DELA_EP7X8_CART,    N_("Attach raw Dela EP7x8 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_DELA_EP7X8_CART_DA, "Tilslut rt Dela EP7x8 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_DELA_EP7X8_CART_DE, "Dela EP7x8 Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_DELA_EP7X8_CART_ES, "Insertar imagen cartucho Dela EP 7x8"},
/* fr */ {IDCLS_ATTACH_RAW_DELA_EP7X8_CART_FR, "Attacher une image de cartouche Dela EP7x8"},
/* hu */ {IDCLS_ATTACH_RAW_DELA_EP7X8_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_DELA_EP7X8_CART_IT, "Seleziona immagine cartuccia Dela EP7x8"},
/* ko */ {IDCLS_ATTACH_RAW_DELA_EP7X8_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_DELA_EP7X8_CART_NL, "Koppel binair Dela ep7x8 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_DELA_EP7X8_CART_PL, "Zamontuj surowy obraz kartrida Dela EP7x8"},
/* ru */ {IDCLS_ATTACH_RAW_DELA_EP7X8_CART_RU, "Attach raw Dela EP7x8 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_DELA_EP7X8_CART_SV, "Anslut r Dela EP7x8-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_DELA_EP7X8_CART_TR, "Dz Dela EP7x8 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_DINAMIC_CART,    N_("Attach raw 128kB Dinamic cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_DINAMIC_CART_DA, "Tilslut rt 128kB Dinamic cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_DINAMIC_CART_DE, "128kB Dinamic Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_DINAMIC_CART_ES, "Insertar imagen cartucho Dinamic 128KB"},
/* fr */ {IDCLS_ATTACH_RAW_DINAMIC_CART_FR, "Attacher une image RAW 128 ko Dinamic"},
/* hu */ {IDCLS_ATTACH_RAW_DINAMIC_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_DINAMIC_CART_IT, "Seleziona immagine cartuccia Dinamic di 128kB"},
/* ko */ {IDCLS_ATTACH_RAW_DINAMIC_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_DINAMIC_CART_NL, "Koppel binair 128kB Dinamic cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_DINAMIC_CART_PL, "Zamontuj surowy obraz kartrida 128kB Dinamic"},
/* ru */ {IDCLS_ATTACH_RAW_DINAMIC_CART_RU, "Attach raw 128kB Dinamic cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_DINAMIC_CART_SV, "Anslut r 12kB Dinamic-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_DINAMIC_CART_TR, "Dz 128kB Dinamic kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART,    N_("Attach raw 8kB Diashow-Maker cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART_DA, "Tilslut rt 8kB Diashow-Maker cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART_DE, "8kB Diashow-Maker Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART_ES, "Insertar imagen cartucho Diashow-Maker 8KB"},
/* fr */ {IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART_FR, "Attacher image RAW 8 ko Diashow-Maker"},
/* hu */ {IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART_IT, "Seleziona immagine cartuccia Diashow-Maker di 8KB"},
/* ko */ {IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART_NL, "Koppel binair 8kB Diashow-Maker cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART_PL, "Zamontuj surowy obraz kartrida 8kB Diashow-Maker"},
/* ru */ {IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART_RU, "Attach raw 8kB Diashow-Maker cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART_SV, "Anslut r 8kB Diashow-Maker-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_DIASHOW_MAKER_CART_TR, "Dz 8kB Diashow-Maker kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_DQBB_CART,    N_("Attach raw 16kB Double Quick Brown Box cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_DQBB_CART_DA, "Tilslut rt 16kB Double Quick Brown Box cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_DQBB_CART_DE, "16kB Double Quick Brown Box Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_DQBB_CART_ES, "Insertar imagen cartucho DBQQ 16KB"},
/* fr */ {IDCLS_ATTACH_RAW_DQBB_CART_FR, "Attacher image RAW 16 ko Cartouche Double Quick Brown Box"},
/* hu */ {IDCLS_ATTACH_RAW_DQBB_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_DQBB_CART_IT, "Seleziona immagine cartuccia Double Quick Brown Box di 16kB"},
/* ko */ {IDCLS_ATTACH_RAW_DQBB_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_DQBB_CART_NL, "Koppel binair 16kB Double Quick Brown Box cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_DQBB_CART_PL, "Zamontuj surowy obraz kartrida Double Quick Brown Box"},
/* ru */ {IDCLS_ATTACH_RAW_DQBB_CART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ATTACH_RAW_DQBB_CART_SV, "Anslut r 16KB Double Quick Brown Box-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_DQBB_CART_TR, "Dz 16kB Double Quick Brown Box kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_EASY_FLASH_CART,    N_("Attach raw EasyFlash cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_EASY_FLASH_CART_DA, "Tilslut rt EasyFlash cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_EASY_FLASH_CART_DE, "Easyflash Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_EASY_FLASH_CART_ES, "Insertar imagen cartucho  EasyFlash"},
/* fr */ {IDCLS_ATTACH_RAW_EASY_FLASH_CART_FR, "Attacher une image de cartouche EasyFlash"},
/* hu */ {IDCLS_ATTACH_RAW_EASY_FLASH_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_EASY_FLASH_CART_IT, "Seleziona immagine cartuccia EasyFlash"},
/* ko */ {IDCLS_ATTACH_RAW_EASY_FLASH_CART_KO, "EasyFlash īƮ ̹ ̼"},
/* nl */ {IDCLS_ATTACH_RAW_EASY_FLASH_CART_NL, "Koppel binair EasyFlash cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_EASY_FLASH_CART_PL, "Zamontuj surowy obraz kartrida EasyFlash"},
/* ru */ {IDCLS_ATTACH_RAW_EASY_FLASH_CART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ATTACH_RAW_EASY_FLASH_CART_SV, "Anslut r EasyFlash-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_EASY_FLASH_CART_TR, "Dz EasyFlash kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_RETRO_REPLAY_CART,    N_("Attach raw 64KB Retro Replay cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_DA, "Tilslut rt 64kB-Retro Replay-cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_DE, "64kB Retro Replay Image einlegen"},
/* es */ {IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_ES, "Insertar imagen cartucho Retro Replay 64KB"},
/* fr */ {IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_FR, "Insrer une cartouche Retro Replay 64KO"},
/* hu */ {IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_HU, "64KB-os Retro Replay cartridge kpms csatolsa"},
/* it */ {IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_IT, "Seleziona immagine cartuccia Retro Replay di 64KB"},
/* ko */ {IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_KO, "64KB Retro Replay īƮ ̹ ̼"},
/* nl */ {IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_NL, "Koppel binair 64KB Retro Replay cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_PL, "Zamontuj surowy obraz kartrida 64KB Retro Replay"},
/* ru */ {IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_RU, "Attach raw 64KB Retro Replay cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_SV, "Anslut r 64KB-Retro Replay-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_TR, "Dz 64KB Retro Replay kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_REX_UTILITY_CART,    N_("Attach raw 8kB REX Utility cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_REX_UTILITY_CART_DA, "Tilslut rt 8kB REX Utility cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_REX_UTILITY_CART_DE, "8kB REX Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_REX_UTILITY_CART_ES, "Insertar imagen cartucho REX Utility 8KB"},
/* fr */ {IDCLS_ATTACH_RAW_REX_UTILITY_CART_FR, "Attacher une image de cartouche 8 ko REX Utility"},
/* hu */ {IDCLS_ATTACH_RAW_REX_UTILITY_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_REX_UTILITY_CART_IT, "Seleziona immagine cartuccia REX Utility di 8kB"},
/* ko */ {IDCLS_ATTACH_RAW_REX_UTILITY_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_REX_UTILITY_CART_NL, "Koppel binair 8kB REX Utility cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_REX_UTILITY_CART_PL, "Zamontuj surowy obraz kartrida 8kB REX Utility"},
/* ru */ {IDCLS_ATTACH_RAW_REX_UTILITY_CART_RU, "Attach raw 8kB REX Utility cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_REX_UTILITY_CART_SV, "Anslut r 8kB REX Utility-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_REX_UTILITY_CART_TR, "Dz 8kB REX Utility kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_SS64_CART,    N_("Attach raw 4kB Snapshot 64 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_SS64_CART_DA, "Tilslut rt 4kB Snapshot 64 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_SS64_CART_DE, "4kB Snapshot 64 Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_SS64_CART_ES, "Insertar imagen cartucho Snapshot 64 4KB"},
/* fr */ {IDCLS_ATTACH_RAW_SS64_CART_FR, "Attacher une image de cartouche 4 ko Snapshot 64"},
/* hu */ {IDCLS_ATTACH_RAW_SS64_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_SS64_CART_IT, "Seleziona immagine cartuccia Snapshot 64 di 4kB"},
/* ko */ {IDCLS_ATTACH_RAW_SS64_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_SS64_CART_NL, "Koppel binair 4kB Snapshot 64 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_SS64_CART_PL, "Zamontuj surowy obraz kartrida 4kB Snapshot 64"},
/* ru */ {IDCLS_ATTACH_RAW_SS64_CART_RU, "Attach raw 4kB Snapshot 64 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_SS64_CART_SV, "Anslut r 4kB Snapshot 64-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_SS64_CART_TR, "Dz 4kB Snapshot 64 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_IDE64_CART,    N_("Attach raw 64KB IDE64 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_IDE64_CART_DA, "Tilslut rt 64kB IDE64-cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_IDE64_CART_DE, "64kB IDE64 Image einlegen"},
/* es */ {IDCLS_ATTACH_RAW_IDE64_CART_ES, "Insertar imagen cartucho IDE64 64KB"},
/* fr */ {IDCLS_ATTACH_RAW_IDE64_CART_FR, "Insrer une cartouche IDE64 64KO"},
/* hu */ {IDCLS_ATTACH_RAW_IDE64_CART_HU, "64KB-os IDE64 cartridge kpms csatolsa"},
/* it */ {IDCLS_ATTACH_RAW_IDE64_CART_IT, "Seleziona immagine cartuccia IDE64 di 64KB"},
/* ko */ {IDCLS_ATTACH_RAW_IDE64_CART_KO, "64kb IDE64 īƮ ̹ ̼"},
/* nl */ {IDCLS_ATTACH_RAW_IDE64_CART_NL, "Koppel binair 64KB IDE64 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_IDE64_CART_PL, "Zamontuj surowy obraz kartrida 64KB IDE64"},
/* ru */ {IDCLS_ATTACH_RAW_IDE64_CART_RU, "Attach raw 64KB IDE64 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_IDE64_CART_SV, "Anslut r 64KB IDE64-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_IDE64_CART_TR, "Dz 64KB IDE64 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_ATOMIC_POWER_CART,    N_("Attach raw 32KB Atomic Power cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_DA, "Tilslut rt 32kB Atomic Power-cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_DE, "32kB Atomic Power Image einlegen"},
/* es */ {IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_ES, "Insertar imagen cartucho Atomic Power 32KB"},
/* fr */ {IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_FR, "Insrer une cartouche Atomic Power 32KO"},
/* hu */ {IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_HU, "32KB-os Atomic Power cartridge kpms csatolsa"},
/* it */ {IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_IT, "Seleziona immagine cartuccia Atomic Power di 32KB"},
/* ko */ {IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_KO, "32kb Atomic Power īƮ ̹ ̼"},
/* nl */ {IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_NL, "Koppel binair 32KB Atomic Power cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_PL, "Zamontuj surowy obraz kartrida 32KB Atomic Power"},
/* ru */ {IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_RU, "Attach raw 32KB Atomic Power cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_SV, "Anslut r 32KB Atomic Power-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_TR, "Dz 32KB Atomic Power kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART,    N_("Attach raw 8KB Epyx FastLoad cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_DA, "Tilslut rt 8kB Epyx FastLoad cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_DE, "8kB Epyx Fastload Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_ES, "Insertar imagen cartucho Epyx Fastload 8KB"},
/* fr */ {IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_FR, "Attacher une image de cartouche 8 ko Epyx FastLoad"},
/* hu */ {IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_IT, "Seleziona immagine cartuccia Epyx FastLoad di 8KB"},
/* ko */ {IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_KO, "8kb Epyx FastLoad īƮ ̹ ̼"},
/* nl */ {IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_NL, "Koppel binair 8KB Epyx FastLoad cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_PL, "Zamontuj surowy obraz kartrida 8KB Epyx FastLoad"},
/* ru */ {IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_RU, "Attach raw 8KB Epyx FastLoad cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_SV, "Anslut r 8KB Epyx FastLoad-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_TR, "Dz 8KB Epyx FastLoad kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_EXOS_CART,    N_("Attach raw 8kB EXOS cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_EXOS_CART_DA, "Tilslut rt 8kB EXOS cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_EXOS_CART_DE, "8kB EXOS Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_EXOS_CART_ES, "Insertar imagen cartucho EXOS 8KB"},
/* fr */ {IDCLS_ATTACH_RAW_EXOS_CART_FR, "Attacher une image de cartouche EXOS"},
/* hu */ {IDCLS_ATTACH_RAW_EXOS_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_EXOS_CART_IT, "Seleziona immagine cartuccia EXOS di 8KB"},
/* ko */ {IDCLS_ATTACH_RAW_EXOS_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_EXOS_CART_NL, "Koppel binair 8kB EXOS cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_EXOS_CART_PL, "Zamontuj surowy obraz kartrida 8kB EXOS"},
/* ru */ {IDCLS_ATTACH_RAW_EXOS_CART_RU, "Attach raw 8kB EXOS cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_EXOS_CART_SV, "Anslut r 8kB EXOS-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_EXOS_CART_TR, "Dz 8kB EXOS kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_EXPERT_CART,    N_("Attach raw 8kB Expert Cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_EXPERT_CART_DA, "Tilslut rt 8kB Expert Cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_EXPERT_CART_DE, "8kB Expert Cartridge Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_EXPERT_CART_ES, "Insertar imagen cartucho Expert 8KB"},
/* fr */ {IDCLS_ATTACH_RAW_EXPERT_CART_FR, "Insrer une image de Cartouche Expert 8 ko"},
/* hu */ {IDCLS_ATTACH_RAW_EXPERT_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_EXPERT_CART_IT, "Seleziona immagine cartuccia Expert Cartridge di 8kB"},
/* ko */ {IDCLS_ATTACH_RAW_EXPERT_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_EXPERT_CART_NL, "Koppel binair 8kB Expert Cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_EXPERT_CART_PL, "Zamontuj surowy obraz 8kB Expert Cartridge"},
/* ru */ {IDCLS_ATTACH_RAW_EXPERT_CART_RU, "Attach raw 8kB Expert Cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_EXPERT_CART_SV, "Anslut r 8kB Expert Cartridge-avbildning"},
/* tr */ {IDCLS_ATTACH_RAW_EXPERT_CART_TR, "Dz 8kB Expert Kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_F64_CART,    N_("Attach raw 32kB Formel 64 image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_F64_CART_DA, "Tilslut rt 32kB Formel 64 image"},
/* de */ {IDCLS_ATTACH_RAW_F64_CART_DE, "32kB Formel 64 Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_F64_CART_ES, "Insertar imagen cartucho Formel 64 de 32KB"},
/* fr */ {IDCLS_ATTACH_RAW_F64_CART_FR, "Attacher une image de cartouche 32 ko Formel 64"},
/* hu */ {IDCLS_ATTACH_RAW_F64_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_F64_CART_IT, "Seleziona immagine cartuccia Formel 64 di 32kb"},
/* ko */ {IDCLS_ATTACH_RAW_F64_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_F64_CART_NL, "Koppel binair 32kB Formel 64 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_F64_CART_PL, "Zamontuj surowy obraz 32kB Formel 64"},
/* ru */ {IDCLS_ATTACH_RAW_F64_CART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ATTACH_RAW_F64_CART_SV, "Anslut r 32kB Formel 64-avbildning"},
/* tr */ {IDCLS_ATTACH_RAW_F64_CART_TR, "Dz 32kB Formel 64 imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_FC1_CART,    N_("Attach raw 16kB Final Cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_FC1_CART_DA, "Tilslut rt 16kB Final Cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_FC1_CART_DE, "16kB Final Cartridge Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_FC1_CART_ES, "Insertar imagen cartucho Final Cartridge 16KB"},
/* fr */ {IDCLS_ATTACH_RAW_FC1_CART_FR, "Attacher une image de cartouche 16 ko Final Cartridge"},
/* hu */ {IDCLS_ATTACH_RAW_FC1_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_FC1_CART_IT, "Seleziona immagine cartuccia Final Cartridge di 16kB"},
/* ko */ {IDCLS_ATTACH_RAW_FC1_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_FC1_CART_NL, "Koppel binair 16kB Final Cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_FC1_CART_PL, "Zamontuj surowy obraz 16kB Final Cartridge"},
/* ru */ {IDCLS_ATTACH_RAW_FC1_CART_RU, "Attach raw 16kB Final Cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_FC1_CART_SV, "Anslut r 16kB Final Cartridge-avbildning"},
/* tr */ {IDCLS_ATTACH_RAW_FC1_CART_TR, "Dz 16kB Final kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_FC3_CART,    N_("Attach raw 64kB Final Cartridge III image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_FC3_CART_DA, "Tilslut rt 64kB Final Cartridge III image"},
/* de */ {IDCLS_ATTACH_RAW_FC3_CART_DE, "64kB Final Cartridge Image III (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_FC3_CART_ES, "Insertar imagen cartucho Final Cartridge III 64KB"},
/* fr */ {IDCLS_ATTACH_RAW_FC3_CART_FR, "Attacher une image de cartouche 64 ko Final Cartridge III"},
/* hu */ {IDCLS_ATTACH_RAW_FC3_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_FC3_CART_IT, "Seleziona immagine cartuccia Final Cartridge III di 64kB"},
/* ko */ {IDCLS_ATTACH_RAW_FC3_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_FC3_CART_NL, "Koppel binair 16kB Final Cartridge III bestand"},
/* pl */ {IDCLS_ATTACH_RAW_FC3_CART_PL, "Zamontuj surowy obraz Final Cartridge III"},
/* ru */ {IDCLS_ATTACH_RAW_FC3_CART_RU, "Attach raw 64kB Final Cartridge III image"},
/* sv */ {IDCLS_ATTACH_RAW_FC3_CART_SV, "Anslut r 64kB Final Cartridge III-avbildning"},
/* tr */ {IDCLS_ATTACH_RAW_FC3_CART_TR, "Dz 64kB Final Cartridge III imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_FCPLUS_CART,    N_("Attach raw 32kB Final Cartridge Plus image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_FCPLUS_CART_DA, "Tilslut rt 32kB Final Cartridge Plus image"},
/* de */ {IDCLS_ATTACH_RAW_FCPLUS_CART_DE, "32kB Final Cartridge Plus Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_FCPLUS_CART_ES, "Insertar imagen cartucho Final Cartridge PLUS 32KB"},
/* fr */ {IDCLS_ATTACH_RAW_FCPLUS_CART_FR, "Attacher une image de cartouche 32 ko Final Cartridge Plus"},
/* hu */ {IDCLS_ATTACH_RAW_FCPLUS_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_FCPLUS_CART_IT, "Seleziona immagine cartuccia Final Cartridge Plus di 32kB"},
/* ko */ {IDCLS_ATTACH_RAW_FCPLUS_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_FCPLUS_CART_NL, "Koppel binair 32kB Final Cartridge Plus bestand"},
/* pl */ {IDCLS_ATTACH_RAW_FCPLUS_CART_PL, "Zamontuj surowy obraz 32kB Final Cartridge Plus"},
/* ru */ {IDCLS_ATTACH_RAW_FCPLUS_CART_RU, "Attach raw 32kB Final Cartridge Plus image"},
/* sv */ {IDCLS_ATTACH_RAW_FCPLUS_CART_SV, "Anslut r 32kB Final Cartridge Plus-fil"},
/* tr */ {IDCLS_ATTACH_RAW_FCPLUS_CART_TR, "Dz 32kB Final Cartridge Plus imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_FREEZE_FRAME_CART,    N_("Attach raw 8kB Freeze Frame image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_FREEZE_FRAME_CART_DA, "Tilslut rt 8kB Freeze Frame image"},
/* de */ {IDCLS_ATTACH_RAW_FREEZE_FRAME_CART_DE, "8kB Freeze Frame Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_FREEZE_FRAME_CART_ES, "Insertar imagen cartucho Freeze Frame 8KB"},
/* fr */ {IDCLS_ATTACH_RAW_FREEZE_FRAME_CART_FR, "Attacher une image de cartouche 8 ko Freeze Frame"},
/* hu */ {IDCLS_ATTACH_RAW_FREEZE_FRAME_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_FREEZE_FRAME_CART_IT, "Seleziona immagine cartuccia Freeze Frame di 8kb"},
/* ko */ {IDCLS_ATTACH_RAW_FREEZE_FRAME_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_FREEZE_FRAME_CART_NL, "Koppel binair 8kB Freeze Frame cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_FREEZE_FRAME_CART_PL, "Zamontuj surowy obraz 8kB Freeze Frame"},
/* ru */ {IDCLS_ATTACH_RAW_FREEZE_FRAME_CART_RU, "Attach raw 8kB Freeze Frame image"},
/* sv */ {IDCLS_ATTACH_RAW_FREEZE_FRAME_CART_SV, "Anslut r 8kB Freeze Frame-avbildning"},
/* tr */ {IDCLS_ATTACH_RAW_FREEZE_FRAME_CART_TR, "Dz 8kB Freeze Frame imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART,    N_("Attach raw 32kB Freeze Machine image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART_DA, "Tilslut rt 32kB Freeze Machine image"},
/* de */ {IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART_DE, "8kB Freeze Machine Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART_ES, "Insertar imagen cartucho Freeze Machine 32KB"},
/* fr */ {IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART_FR, "Attacher une image de cartouche 32 ko Freeze Machine"},
/* hu */ {IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART_IT, "Seleziona immagine cartuccia Freeze Machine di 32kb"},
/* ko */ {IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART_NL, "Koppel binair 32kB Freeze Machine cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART_PL, "Zamontuj surowy obraz 32kB Freeze Machine"},
/* ru */ {IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART_RU, "Attach raw 32kB Freeze Machine image"},
/* sv */ {IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART_SV, "Anslut r 32kB Freeze Machine-avbildning"},
/* tr */ {IDCLS_ATTACH_RAW_FREEZE_MACHINE_CART_TR, "Dz 32kB Freeze Machine imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_FP_PP_CART,    N_("Attach raw 128kB Fun Play/Power Play cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_FP_PP_CART_DA, "Tilslut rt 128kB Fun Play/Power Play cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_FP_PP_CART_DE, "128kB Fun Play/Power Play Cartridge  Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_FP_PP_CART_ES, "Insertar imagen cartucho Fun Play/Power Play 128KB"},
/* fr */ {IDCLS_ATTACH_RAW_FP_PP_CART_FR, "Attacher une image de cartouche 128 ko Fun Play / Power Play"},
/* hu */ {IDCLS_ATTACH_RAW_FP_PP_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_FP_PP_CART_IT, "Seleziona immagine cartuccia Fun Play/Power Play di 128kB"},
/* ko */ {IDCLS_ATTACH_RAW_FP_PP_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_FP_PP_CART_NL, "Koppel binair 128kB Fun Play/Power Play cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_FP_PP_CART_PL, "Zamontuj surowy obraz kartrida 128kB Fun Play/Power Play"},
/* ru */ {IDCLS_ATTACH_RAW_FP_PP_CART_RU, "Attach raw 128kB Fun Play/Power Play cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_FP_PP_CART_SV, "Anslut r 128kB Fun Play/Power Play-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_FP_PP_CART_TR, "Dz 128kB Fun Play/Power Play kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_SS4_CART,    N_("Attach raw 32KB Super Snapshot V4 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_SS4_CART_DA, "Tilslut rt 32kB Super Snapshot V4 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_SS4_CART_DE, "32kB Super Snapshot V4 Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_SS4_CART_ES, "Insertar imagen cartucho Super Snapshot V4 32KB"},
/* fr */ {IDCLS_ATTACH_RAW_SS4_CART_FR, "Attacher une image de cartouche 32 ko Super Snapshot V4"},
/* hu */ {IDCLS_ATTACH_RAW_SS4_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_SS4_CART_IT, "Seleziona immagine cartuccia Super Snapshot V4 di 32KB"},
/* ko */ {IDCLS_ATTACH_RAW_SS4_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_SS4_CART_NL, "Koppel binair 32KB Super Snapshot V4 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_SS4_CART_PL, "Zamontuj surowy obraz kartrida 32KB Super Snapshot V4"},
/* ru */ {IDCLS_ATTACH_RAW_SS4_CART_RU, "Attach raw 32KB Super Snapshot V4 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_SS4_CART_SV, "Anslut r 32KB Super Snapshot V4-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_SS4_CART_TR, "Dz 32KB Super Snapshot V4 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_SS5_CART,    N_("Attach raw 64KB Super Snapshot V5 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_SS5_CART_DA, "Tilslut rt 64kB Super Snapshot V5 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_SS5_CART_DE, "64kB Super Snapshot V5 Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_SS5_CART_ES, "Insertar imagen cartucho Super Snapshot V5 64KB"},
/* fr */ {IDCLS_ATTACH_RAW_SS5_CART_FR, "Attacher une image de cartouche 64 ko Super Snapshot V5"},
/* hu */ {IDCLS_ATTACH_RAW_SS5_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_SS5_CART_IT, "Seleziona immagine cartuccia Super Snapshot V5 di 64KB"},
/* ko */ {IDCLS_ATTACH_RAW_SS5_CART_KO, "64KB Super Snapshot V5 īƮ ̹ ̼"},
/* nl */ {IDCLS_ATTACH_RAW_SS5_CART_NL, "Koppel binair 64KB Super Snapshot V5 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_SS5_CART_PL, "Zamontuj surowy obraz kartrida Super Snapshot V5"},
/* ru */ {IDCLS_ATTACH_RAW_SS5_CART_RU, "Attach raw 64KB Super Snapshot V5 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_SS5_CART_SV, "Anslut r 64KB-Super Snapshot V5-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_SS5_CART_TR, "Dz 64KB Super Snapshot V5 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_CBM_IEEE488_CART,    N_("Attach IEEE-488 Interface cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_CBM_IEEE488_CART_DA, "Tilslut IEEE-488 interface cartridge image"},
/* de */ {IDCLS_ATTACH_CBM_IEEE488_CART_DE, "IEEE Schnittstellen Erweiterungsmodul Image einlegen"},
/* es */ {IDCLS_ATTACH_CBM_IEEE488_CART_ES, "Insertar imagen de cartucho Interface IEEE-488"},
/* fr */ {IDCLS_ATTACH_CBM_IEEE488_CART_FR, "Attacher une image de cartouche Interface IEEE-488"},
/* hu */ {IDCLS_ATTACH_CBM_IEEE488_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_CBM_IEEE488_CART_IT, "Seleziona immagine cartuccia interfaccia IEEE"},
/* ko */ {IDCLS_ATTACH_CBM_IEEE488_CART_KO, "IEEE-488 ̽ īƮ ̹ ٿ"},
/* nl */ {IDCLS_ATTACH_CBM_IEEE488_CART_NL, "Koppel IEEE-488 Interface cartridge bestand"},
/* pl */ {IDCLS_ATTACH_CBM_IEEE488_CART_PL, "Zamontuj obraz kartrida IEEE-488 Interface"},
/* ru */ {IDCLS_ATTACH_CBM_IEEE488_CART_RU, "Attach IEEE-488 Interface cartridge image"},
/* sv */ {IDCLS_ATTACH_CBM_IEEE488_CART_SV, "Anslut IEEE-488-grnssnittsavbildningsfil"},
/* tr */ {IDCLS_ATTACH_CBM_IEEE488_CART_TR, "IEEE-488 Arabirimi kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_ISEPIC_CART,    N_("Attach raw 2kB ISEPIC cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_ISEPIC_CART_DA, "Tilslut rt 2kB ISEPIC-cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_ISEPIC_CART_DE, "2kB ISEPIC Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_ISEPIC_CART_ES, "Insertar imagen cartucho ISEPIC 2KB"},
/* fr */ {IDCLS_ATTACH_RAW_ISEPIC_CART_FR, "Attacher une image de cartouche 2 ko ISEPIC"},
/* hu */ {IDCLS_ATTACH_RAW_ISEPIC_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_ISEPIC_CART_IT, "Seleziona immagine cartuccia ISEPIC di 2kB"},
/* ko */ {IDCLS_ATTACH_RAW_ISEPIC_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_ISEPIC_CART_NL, "Koppel binair 2kB ISEPIC cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_ISEPIC_CART_PL, "Zamontuj surowy obraz kartrida 2kB ISEPIC"},
/* ru */ {IDCLS_ATTACH_RAW_ISEPIC_CART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ATTACH_RAW_ISEPIC_CART_SV, "Anslut r 2kB ISEPIC-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_ISEPIC_CART_TR, "Dz 2kB ISEPIC kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_KCS_CART,    N_("Attach raw 16kB KCS Power cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_KCS_CART_DA, "Tilslut rt 16kB KCS Power Cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_KCS_CART_DE, "16kB KCS Power Cartridge Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_KCS_CART_ES, "Insertar imagen cartucho KCS Power Cartridge 16KB"},
/* fr */ {IDCLS_ATTACH_RAW_KCS_CART_FR, "Attacher une image de cartouche 16 ko KCS Power"},
/* hu */ {IDCLS_ATTACH_RAW_KCS_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_KCS_CART_IT, "Seleziona immagine cartuccia KCS Power di 16kB"},
/* ko */ {IDCLS_ATTACH_RAW_KCS_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_KCS_CART_NL, "Koppel binair 16kB KSC Power cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_KCS_CART_PL, "Zamontuj surowy obraz kartrida 16kB KCS Power"},
/* ru */ {IDCLS_ATTACH_RAW_KCS_CART_RU, "Attach raw 16kB KCS Power cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_KCS_CART_SV, "Anslut r 16KB KCS Power-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_KCS_CART_TR, "Dz 16kB KCS Power kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_KINGSOFT_CART,    N_("Attach raw 24kB Kingsoft cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_KINGSOFT_CART_DA, "Tilslut rt 24kB Snapshot 64 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_KINGSOFT_CART_DE, "24kB Kingsoft Image einlegen"},
/* es */ {IDCLS_ATTACH_RAW_KINGSOFT_CART_ES, "Insertar imagen cartucho 24KB Kingsoft"},
/* fr */ {IDCLS_ATTACH_RAW_KINGSOFT_CART_FR, "Attacher une image de cartouche 24 ko Kingsoft"},
/* hu */ {IDCLS_ATTACH_RAW_KINGSOFT_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_KINGSOFT_CART_IT, "Seleziona immagine cartuccia Kingsoft di 24kB"},
/* ko */ {IDCLS_ATTACH_RAW_KINGSOFT_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_KINGSOFT_CART_NL, "Koppel binair 24kB Kingsoft cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_KINGSOFT_CART_PL, "Zamontuj surowy obraz kartrida 24kB Kingsoft"},
/* ru */ {IDCLS_ATTACH_RAW_KINGSOFT_CART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ATTACH_RAW_KINGSOFT_CART_SV, "Anslut r 24kB-Kingsoft-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_KINGSOFT_CART_TR, "Dz 24kB Kingsoft kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_MACH5_CART,    N_("Attach raw 8kB MACH 5 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_MACH5_CART_DA, "Tilslut rt 8kB MACH 5 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_MACH5_CART_DE, "8kB MAC 5 Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_MACH5_CART_ES, "Insertar imagen cartucho MACH 5 8KB"},
/* fr */ {IDCLS_ATTACH_RAW_MACH5_CART_FR, "Attacher une image de cartouche 8 ko MACH 5"},
/* hu */ {IDCLS_ATTACH_RAW_MACH5_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_MACH5_CART_IT, "Seleziona immagine cartuccia MACH 5 di 8kB"},
/* ko */ {IDCLS_ATTACH_RAW_MACH5_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_MACH5_CART_NL, "Koppel binair 8kB MACH 5 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_MACH5_CART_PL, "Zamontuj surowy obraz kartrida 8kB MACH 5"},
/* ru */ {IDCLS_ATTACH_RAW_MACH5_CART_RU, "Attach raw 8kB MACH 5 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_MACH5_CART_SV, "Anslut r 8kB MACH 5-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_MACH5_CART_TR, "Dz 8kB MACH 5 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_MAGIC_DESK_CART,    N_("Attach raw 32/64/128kB Magic Desk cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_MAGIC_DESK_CART_DA, "Tilslut rt 32/64/128kB Magic Desk cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_MAGIC_DESK_CART_DE, "32/64/128kB Magic Desk Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_MAGIC_DESK_CART_ES, "Insertar imagen cartucho Magic Desc 32/64/128KB"},
/* fr */ {IDCLS_ATTACH_RAW_MAGIC_DESK_CART_FR, "Attacher une image de cartouche 32/64/128 ko Magic Desk"},
/* hu */ {IDCLS_ATTACH_RAW_MAGIC_DESK_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_MAGIC_DESK_CART_IT, "Seleziona immagine cartuccia Magic Desk di 32/64/128kB"},
/* ko */ {IDCLS_ATTACH_RAW_MAGIC_DESK_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_MAGIC_DESK_CART_NL, "Koppel binair 32/64/128kB Magic Desk cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_MAGIC_DESK_CART_PL, "Zamontuj surowy obraz kartrida 32/64/128kB Magic Desk"},
/* ru */ {IDCLS_ATTACH_RAW_MAGIC_DESK_CART_RU, "Attach raw 32/64/128kB Magic Desk cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_MAGIC_DESK_CART_SV, "Anslut r 32/64/128kB Magic Desk-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_MAGIC_DESK_CART_TR, "Dz 32/64/128kB Magic Desk kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART,    N_("Attach raw Magic Formel cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART_DA, "Tilslut rt Magic Formel cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART_DE, "Magic Formel Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART_ES, "Insertar imagen cartucho Magic Formel"},
/* fr */ {IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART_FR, "Attacher une image de cartouche Magic Formel"},
/* hu */ {IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART_IT, "Seleziona immagine cartuccia Magic Formel"},
/* ko */ {IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART_KO, "Magic Formel īƮ ̹ ̼"},
/* nl */ {IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART_NL, "Koppel binair Magic Formel cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART_PL, "Zamontuj surowy obraz kartrida Magic Formel"},
/* ru */ {IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART_RU, "Attach raw Magic Formel cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART_SV, "Anslut r Magic Romel-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_MAGIC_FORMEL_CART_TR, "Dz Magic Formel kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART,    N_("Attach raw 8kB Mikro Assembler cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART_DA, "Tilslut rt 8kB Mikro Assembler cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART_DE, "8kB Mikro Assembler Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART_ES, "Insertar imagen cartucho Mikro Assembler 8KB"},
/* fr */ {IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART_FR, "Attacher une image de cartouche 8 ko Mikor Assembler"},
/* hu */ {IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART_IT, "Seleziona immagine cartuccia Mikro Assembler di 8kB"},
/* ko */ {IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART_NL, "Koppel binair 8KB Mikro Assembler cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART_PL, "Zamontuj surowy obraz kartrida 8kB Mikro Assembler"},
/* ru */ {IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART_RU, "Attach raw 8kB Mikro Assembler cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART_SV, "Anslut r 8kB Mikro Assembler-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_MIKRO_ASSEMBLER_CART_TR, "Dz 8kB Mikro Assembler kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_MMC64_CART,    N_("Attach raw 8kB MMC64 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_MMC64_CART_DA, "Tilslut rt 8kB MMC64 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_MMC64_CART_DE, "8kB MMC64 Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_MMC64_CART_ES, "Insertar imagen cartucho MMC64 8KB"},
/* fr */ {IDCLS_ATTACH_RAW_MMC64_CART_FR, "Attacher une image de cartouche 8 ko MMC64"},
/* hu */ {IDCLS_ATTACH_RAW_MMC64_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_MMC64_CART_IT, "Seleziona immagine cartuccia MMC64 di 8kB"},
/* ko */ {IDCLS_ATTACH_RAW_MMC64_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_MMC64_CART_NL, "Koppel binair 8kB MMC64 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_MMC64_CART_PL, "Zamontuj surowy obraz kartrida 8kB MMC64"},
/* ru */ {IDCLS_ATTACH_RAW_MMC64_CART_RU, "Attach raw 8kB MMC64 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_MMC64_CART_SV, "Anslut r 8kB MMC64-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_MMC64_CART_TR, "Dz 8kB MMC64 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_MMC_REPLAY_CART,    N_("Attach raw 512kB MMC Replay cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_MMC_REPLAY_CART_DA, "Tilslut rt 512kB MMC Replay cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_MMC_REPLAY_CART_DE, "512kB MMC Replay Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_MMC_REPLAY_CART_ES, "Insertar imagen cartucho MMC Replay 512KB"},
/* fr */ {IDCLS_ATTACH_RAW_MMC_REPLAY_CART_FR, "Attacher une image de cartouche 512 ko MMC Replay"},
/* hu */ {IDCLS_ATTACH_RAW_MMC_REPLAY_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_MMC_REPLAY_CART_IT, "Seleziona immagine cartuccia MMC Replay di 512kB"},
/* ko */ {IDCLS_ATTACH_RAW_MMC_REPLAY_CART_KO, "512KB MMC Replay īƮ ̹ ̼"},
/* nl */ {IDCLS_ATTACH_RAW_MMC_REPLAY_CART_NL, "Koppel binair 512kB MMC Replay cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_MMC_REPLAY_CART_PL, "Zamontuj surowy obraz kartrida 512kB MMC Replay"},
/* ru */ {IDCLS_ATTACH_RAW_MMC_REPLAY_CART_RU, "Attach raw 512kB MMC Replay cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_MMC_REPLAY_CART_SV, "Anslut r 512kB MMC Replay-avbildningsfil"},
/* tr */ {IDCLS_ATTACH_RAW_MMC_REPLAY_CART_TR, "Dz 512kB MMC Replay kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_MAGIC_VOICE_CART,    N_("Attach raw 16kB Magic Voice cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_MAGIC_VOICE_CART_DA, "Tilslut rt 16kB Magic Voice cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_MAGIC_VOICE_CART_DE, "16kB Magic Voice Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_MAGIC_VOICE_CART_ES, "Insertar imagen cartucho Magic Voice 16KB"},
/* fr */ {IDCLS_ATTACH_RAW_MAGIC_VOICE_CART_FR, "Attacher une image de cartouche 16 ko Magic Voice"},
/* hu */ {IDCLS_ATTACH_RAW_MAGIC_VOICE_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_MAGIC_VOICE_CART_IT, "Seleziona immagine cartuccia Magic Voice di 16kB"},
/* ko */ {IDCLS_ATTACH_RAW_MAGIC_VOICE_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_MAGIC_VOICE_CART_NL, "Koppel binair 16kB Magic Voice cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_MAGIC_VOICE_CART_PL, "Zamontuj surowy obraz kartrida 16kB Magic Voice"},
/* ru */ {IDCLS_ATTACH_RAW_MAGIC_VOICE_CART_RU, "Attach raw 16kB Magic Voice cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_MAGIC_VOICE_CART_SV, "Anslut r 16kB Magic Voice-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_MAGIC_VOICE_CART_TR, "Dz 16kB Magic Voice kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_OCEAN_CART,    N_("Attach raw Ocean cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_OCEAN_CART_DA, "Tilslut rt Ocean cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_OCEAN_CART_DE, "Ocean Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_OCEAN_CART_ES, "Insertar imagen cartucho Ocean"},
/* fr */ {IDCLS_ATTACH_RAW_OCEAN_CART_FR, "Attacher une image de cartouche RAW Ocean"},
/* hu */ {IDCLS_ATTACH_RAW_OCEAN_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_OCEAN_CART_IT, "Seleziona immagine cartuccia Ocean"},
/* ko */ {IDCLS_ATTACH_RAW_OCEAN_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_OCEAN_CART_NL, "Koppel binair Ocean cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_OCEAN_CART_PL, "Zamontuj surowy obraz kartrida Ocean"},
/* ru */ {IDCLS_ATTACH_RAW_OCEAN_CART_RU, "Attach raw Ocean cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_OCEAN_CART_SV, "Anslut r Ocean-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_OCEAN_CART_TR, "Dz Ocean kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_WESTERMANN_CART,    N_("Attach raw 16KB Westermann Learning cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_WESTERMANN_CART_DA, "Tilslut rt 16kB Westermann Learning cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_WESTERMANN_CART_DE, "16kB Westermann learning Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_WESTERMANN_CART_ES, "Insertar imagen cartucho Wstermann Learning 16KB"},
/* fr */ {IDCLS_ATTACH_RAW_WESTERMANN_CART_FR, "Attacher une image de cartouche 16 ko Westermann Leaning"},
/* hu */ {IDCLS_ATTACH_RAW_WESTERMANN_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_WESTERMANN_CART_IT, "Seleziona immagine cartuccia Westermann Learning di 16KB"},
/* ko */ {IDCLS_ATTACH_RAW_WESTERMANN_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_WESTERMANN_CART_NL, "Koppel binair 16kB Westermann Learning cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_WESTERMANN_CART_PL, "Zamontuj surowy obraz kartrida 16KB Westermann Learning"},
/* ru */ {IDCLS_ATTACH_RAW_WESTERMANN_CART_RU, "Attach raw 16KB Westermann Learning cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_WESTERMANN_CART_SV, "Anslut r 16KB Westermann Learning-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_WESTERMANN_CART_TR, "Dz 16KB Westermann Learning kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_WARPSPEED_CART,    N_("Attach raw 8kB Warp Speed cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_WARPSPEED_CART_DA, "Tilslut rt 8kB Warp Speed cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_WARPSPEED_CART_DE, "8kB Warp Speed Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_WARPSPEED_CART_ES, "Insertar imagen cartucho Warp Speed 8KB"},
/* fr */ {IDCLS_ATTACH_RAW_WARPSPEED_CART_FR, "Attacher une image de cartouche 8 ko Warp Speed"},
/* hu */ {IDCLS_ATTACH_RAW_WARPSPEED_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_WARPSPEED_CART_IT, "Seleziona immagine cartuccia Warp Speed di 8kB"},
/* ko */ {IDCLS_ATTACH_RAW_WARPSPEED_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_WARPSPEED_CART_NL, "Koppel binair 8kB Warp Speed cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_WARPSPEED_CART_PL, "Zamontuj surowy obraz kartrida 8kB Warp Speed"},
/* ru */ {IDCLS_ATTACH_RAW_WARPSPEED_CART_RU, "Attach raw 8kB Warp Speed cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_WARPSPEED_CART_SV, "Anslut r 8kB-Warp Speed-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_WARPSPEED_CART_TR, "Dz 8kB Warp Speed kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_ZAXXON_CART,    N_("Attach raw 16kB Zaxxon cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_ZAXXON_CART_DA, "Tilslut rt 16kB Zaxxon cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_ZAXXON_CART_DE, "16kB Zaxxon Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_ZAXXON_CART_ES, "Insertar imagen cartucho Zaxxon 16KB"},
/* fr */ {IDCLS_ATTACH_RAW_ZAXXON_CART_FR, "Attacher une image de cartouche 16 ko Zaxxon"},
/* hu */ {IDCLS_ATTACH_RAW_ZAXXON_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_ZAXXON_CART_IT, "Seleziona immagine cartuccia Zaxxon di 16kB"},
/* ko */ {IDCLS_ATTACH_RAW_ZAXXON_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_ZAXXON_CART_NL, "Koppel binair 16kB Zaxxon cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_ZAXXON_CART_PL, "Zamontuj surowy obraz kartrida 16kB Zaxxon"},
/* ru */ {IDCLS_ATTACH_RAW_ZAXXON_CART_RU, "Attach raw 16kB Zaxxon cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_ZAXXON_CART_SV, "Anslut r 16kB Zaxxon-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_ZAXXON_CART_TR, "Dz 16kB Zaxxon kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_EASYCALC_CART,    N_("Attach raw 24kB Easy Calc Result cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_EASYCALC_CART_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ATTACH_RAW_EASYCALC_CART_DE, "Easy Calc Result Erweiterungsmodul Image (24kb raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_EASYCALC_CART_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ATTACH_RAW_EASYCALC_CART_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ATTACH_RAW_EASYCALC_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_EASYCALC_CART_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ATTACH_RAW_EASYCALC_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_EASYCALC_CART_NL, "Koppel binair 24kB Easy Calc Result cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_EASYCALC_CART_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ATTACH_RAW_EASYCALC_CART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ATTACH_RAW_EASYCALC_CART_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ATTACH_RAW_EASYCALC_CART_TR, ""},  /* fuzzy */
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_PAGEFOX_CART,    N_("Attach raw 64KB Pagefox cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_PAGEFOX_CART_DA, "Tilslut rt 64kB Pagefox cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_PAGEFOX_CART_DE, "Pagefox Erweiterungsmodul Image einlegen"},
/* es */ {IDCLS_ATTACH_RAW_PAGEFOX_CART_ES, "Insertar imagen cartucho 64KB Pagefox"},
/* fr */ {IDCLS_ATTACH_RAW_PAGEFOX_CART_FR, "Attacher une image de cartouche 64 ko Pagefox"},
/* hu */ {IDCLS_ATTACH_RAW_PAGEFOX_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_PAGEFOX_CART_IT, "Seleziona immagine cartuccia Pagefox di 64KB"},
/* ko */ {IDCLS_ATTACH_RAW_PAGEFOX_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_PAGEFOX_CART_NL, "Koppel binair 64KB Pagefox cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_PAGEFOX_CART_PL, "Zamontuj surowy obraz kartrida 64KB Pagefox"},
/* ru */ {IDCLS_ATTACH_RAW_PAGEFOX_CART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ATTACH_RAW_PAGEFOX_CART_SV, "Anslut r 64KB-Pagefox-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_PAGEFOX_CART_TR, "Dz 64KB Pagefox kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_P64_CART,    N_("Attach raw 256KB Prophet 64 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_P64_CART_DA, "Tilslut rt 256kB Prophet 64 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_P64_CART_DE, "256KB Prophet 64 Erweiterungsmodul Image einlegen"},
/* es */ {IDCLS_ATTACH_RAW_P64_CART_ES, "Insertar imagen cartucho Prohet 64 256KB"},
/* fr */ {IDCLS_ATTACH_RAW_P64_CART_FR, "Attacher une image de cartouche 256 ko Prophet 64"},
/* hu */ {IDCLS_ATTACH_RAW_P64_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_P64_CART_IT, "Seleziona immagine cartuccia Prophet 64 di 256KB"},
/* ko */ {IDCLS_ATTACH_RAW_P64_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_P64_CART_NL, "Koppel binair 256KB Prophet 64 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_P64_CART_PL, "Zamontuj surowy obraz kartrida 256KB Prophet 64"},
/* ru */ {IDCLS_ATTACH_RAW_P64_CART_RU, "Attach raw 256KB Prophet 64 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_P64_CART_SV, "Anslut r 256KB Prophet 64-insticksmodulfil"},
/* tr */ {IDCLS_ATTACH_RAW_P64_CART_TR, "Dz 256KB Prophet 64 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_RAMCART_CART,    N_("Attach raw RamCart cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_RAMCART_CART_DA, "Tilslut rt RamCart cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_RAMCART_CART_DE, "RamCart Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_RAMCART_CART_ES, "Insertar imagen cartucho RamCart"},
/* fr */ {IDCLS_ATTACH_RAW_RAMCART_CART_FR, "Attacher une image de cartouche RAW RAMCART"},
/* hu */ {IDCLS_ATTACH_RAW_RAMCART_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_RAMCART_CART_IT, "Seleziona immagine cartuccia RamCart"},
/* ko */ {IDCLS_ATTACH_RAW_RAMCART_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_RAMCART_CART_NL, "Koppel binair RamCart cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_RAMCART_CART_PL, "Zamontuj surowy obraz kartrida RamCart"},
/* ru */ {IDCLS_ATTACH_RAW_RAMCART_CART_RU, "Attach raw RamCart cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_RAMCART_CART_SV, "Anslut r RamCart-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_RAMCART_CART_TR, "Dz RamCart kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_REU_CART,    N_("Attach raw REU cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_REU_CART_DA, "Tilslut rt REU cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_REU_CART_DE, "REU Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_REU_CART_ES, "Insertar imagen cartucho REU"},
/* fr */ {IDCLS_ATTACH_RAW_REU_CART_FR, "Attacher une image de cartouche RAW REU"},
/* hu */ {IDCLS_ATTACH_RAW_REU_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_REU_CART_IT, "Seleziona immagine cartuccia REU"},
/* ko */ {IDCLS_ATTACH_RAW_REU_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_REU_CART_NL, "Koppel binair REU cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_REU_CART_PL, "Zamontuj surowy obraz kartrida REU"},
/* ru */ {IDCLS_ATTACH_RAW_REU_CART_RU, "Attach raw REU cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_REU_CART_SV, "Anslut r REU-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_REU_CART_TR, "Dz REU kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_REX_EP256_CART,    N_("Attach raw REX EP256 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_REX_EP256_CART_DA, "Tilslut rt REX EP256 cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_REX_EP256_CART_DE, "REX EP256 Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_REX_EP256_CART_ES, "Insertar imagen cartucho REX EP256"},
/* fr */ {IDCLS_ATTACH_RAW_REX_EP256_CART_FR, "Attacher une image de cartouche REX EP256"},
/* hu */ {IDCLS_ATTACH_RAW_REX_EP256_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_REX_EP256_CART_IT, "Seleziona immagine cartuccia REX EP256"},
/* ko */ {IDCLS_ATTACH_RAW_REX_EP256_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_REX_EP256_CART_NL, "Koppel binair REX EP256 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_REX_EP256_CART_PL, "Zamontuj surowy obraz kartrida REX EP256"},
/* ru */ {IDCLS_ATTACH_RAW_REX_EP256_CART_RU, "Attach raw REX EP256 cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_REX_EP256_CART_SV, "Anslut r REX EP256-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_REX_EP256_CART_TR, "Dz REX EP256 kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_RGCD_CART,    N_("Attach raw 64kB RGCD cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_RGCD_CART_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ATTACH_RAW_RGCD_CART_DE, "64kB RGBD Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_RGCD_CART_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ATTACH_RAW_RGCD_CART_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ATTACH_RAW_RGCD_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_RGCD_CART_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ATTACH_RAW_RGCD_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_RGCD_CART_NL, "Koppel binair 64KB RGCD cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_RGCD_CART_PL, "Zamontuj surowy 64KB obraz kartrida  RGCD"},
/* ru */ {IDCLS_ATTACH_RAW_RGCD_CART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ATTACH_RAW_RGCD_CART_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ATTACH_RAW_RGCD_CART_TR, ""},  /* fuzzy */
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_RRNETMK3_CART,    N_("Attach raw 8kB RR-Net MK3 cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_RRNETMK3_CART_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ATTACH_RAW_RRNETMK3_CART_DE, "8kB RR-Net MK3 Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_RRNETMK3_CART_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ATTACH_RAW_RRNETMK3_CART_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ATTACH_RAW_RRNETMK3_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_RRNETMK3_CART_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ATTACH_RAW_RRNETMK3_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_RRNETMK3_CART_NL, "Koppel binair 8kB RRNET MK3 cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_RRNETMK3_CART_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ATTACH_RAW_RRNETMK3_CART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ATTACH_RAW_RRNETMK3_CART_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ATTACH_RAW_RRNETMK3_CART_TR, ""},  /* fuzzy */
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_ROSS_CART,    N_("Attach raw 16/32kB ROSS cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_ROSS_CART_DA, "Tilslut rt 16/32kB ROSS cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_ROSS_CART_DE, "16/32kB ROSS Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_ROSS_CART_ES, "Insertar imagen cartucho ROSS 16/32KB"},
/* fr */ {IDCLS_ATTACH_RAW_ROSS_CART_FR, "Attacher une image de cartouche 16/32 ko ROSS"},
/* hu */ {IDCLS_ATTACH_RAW_ROSS_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_ROSS_CART_IT, "Seleziona immagine cartuccia ROSS di 16/32kB"},
/* ko */ {IDCLS_ATTACH_RAW_ROSS_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_ROSS_CART_NL, "Koppel binair 16/32kB ROSS cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_ROSS_CART_PL, "Zamontuj surowy obraz kartrida 12/32kB ROSS"},
/* ru */ {IDCLS_ATTACH_RAW_ROSS_CART_RU, "Attach raw 16/32kB ROSS cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_ROSS_CART_SV, "Anslut r 16/32kB ROSS-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_ROSS_CART_TR, "Dz 16/32kB ROSS kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_GAME_KILLER_CART,    N_("Attach raw 8KB Game Killer cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_GAME_KILLER_CART_DA, "Tilslut rt 8kB Game Killer cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_GAME_KILLER_CART_DE, "8KB Game Killer Erweiterungsmodul (raw) Image einlegen"},
/* es */ {IDCLS_ATTACH_RAW_GAME_KILLER_CART_ES, "Insertar imagen cartucho Game Killer 8KB"},
/* fr */ {IDCLS_ATTACH_RAW_GAME_KILLER_CART_FR, "Attacher une image de cartouche 8 ko Game Killer"},
/* hu */ {IDCLS_ATTACH_RAW_GAME_KILLER_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_GAME_KILLER_CART_IT, "Seleziona immagine cartuccia Game Killer di 8KB"},
/* ko */ {IDCLS_ATTACH_RAW_GAME_KILLER_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_GAME_KILLER_CART_NL, "Koppel binair 8KB Game Killer cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_GAME_KILLER_CART_PL, "Zamontuj surowy obraz kartrida 8KB Game Killer"},
/* ru */ {IDCLS_ATTACH_RAW_GAME_KILLER_CART_RU, "Attach raw 8KB Game Killer cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_GAME_KILLER_CART_SV, "Anslut r 8KB Game Killer-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_GAME_KILLER_CART_TR, "Dz 8KB Game Killer kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_GEORAM_CART,    N_("Attach raw GEO-RAM cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_GEORAM_CART_DA, "Tilslut rt GEO-RAM cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_GEORAM_CART_DE, "GEO-RAM Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_GEORAM_CART_ES, "Insertar imagen cartucho GEO-RAM"},
/* fr */ {IDCLS_ATTACH_RAW_GEORAM_CART_FR, "Attacher une image de cartouche RAW GEO-RAM"},
/* hu */ {IDCLS_ATTACH_RAW_GEORAM_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_GEORAM_CART_IT, "Seleziona immagine cartuccia GEO-RAM"},
/* ko */ {IDCLS_ATTACH_RAW_GEORAM_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_GEORAM_CART_NL, "Koppel binair GEO-RAM cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_GEORAM_CART_PL, "Zamontuj surowy obraz kartrida GEO-RAM"},
/* ru */ {IDCLS_ATTACH_RAW_GEORAM_CART_RU, "Attach raw GEO-RAM cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_GEORAM_CART_SV, "Anslut r GEO-RAM-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_GEORAM_CART_TR, "Dz GEO-RAM kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_GAME_SYSTEM_CART,    N_("Attach raw 512kB Game System cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ATTACH_RAW_GAME_SYSTEM_CART_DA, "Tilslut rt 512kB Game System cartridge image"},
/* de */ {IDCLS_ATTACH_RAW_GAME_SYSTEM_CART_DE, "512kB Game System Image (raw) einlegen"},
/* es */ {IDCLS_ATTACH_RAW_GAME_SYSTEM_CART_ES, "Insertar imagen cartucho Game System 512KB"},
/* fr */ {IDCLS_ATTACH_RAW_GAME_SYSTEM_CART_FR, "Attacher une image de cartouche 512 ko Game System"},
/* hu */ {IDCLS_ATTACH_RAW_GAME_SYSTEM_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ATTACH_RAW_GAME_SYSTEM_CART_IT, "Seleziona immagine cartuccia Game System di 512kB"},
/* ko */ {IDCLS_ATTACH_RAW_GAME_SYSTEM_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ATTACH_RAW_GAME_SYSTEM_CART_NL, "Koppel binair 512kB Game System cartridge bestand"},
/* pl */ {IDCLS_ATTACH_RAW_GAME_SYSTEM_CART_PL, "Zamontuj surowy obraz kartrida 512kB Game System"},
/* ru */ {IDCLS_ATTACH_RAW_GAME_SYSTEM_CART_RU, "Attach raw 512kB Game System cartridge image"},
/* sv */ {IDCLS_ATTACH_RAW_GAME_SYSTEM_CART_SV, "Anslut r 512kB Game System-insticksmodulavbildning"},
/* tr */ {IDCLS_ATTACH_RAW_GAME_SYSTEM_CART_TR, "Dz 512kB Game System kartu imaj yerletir"},
#endif

/* c64/cart/c64cart.c, c64/expert.c */
/* en */ {IDCLS_ENABLE_EXPERT_CART,    N_("Enable the Expert Cartridge")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_EXPERT_CART_DA, "Aktivr Expert Cartridge"},
/* de */ {IDCLS_ENABLE_EXPERT_CART_DE, "Expert Cartridge aktivieren"},
/* es */ {IDCLS_ENABLE_EXPERT_CART_ES, "Permitir Expert Cartridge"},
/* fr */ {IDCLS_ENABLE_EXPERT_CART_FR, "Activer Cartouche Expert"},
/* hu */ {IDCLS_ENABLE_EXPERT_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_EXPERT_CART_IT, "Attiva Expert Cartridge"},
/* ko */ {IDCLS_ENABLE_EXPERT_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_EXPERT_CART_NL, "Expert Cartridge inschakelen"},
/* pl */ {IDCLS_ENABLE_EXPERT_CART_PL, "Wcz Expert Cartridge"},
/* ru */ {IDCLS_ENABLE_EXPERT_CART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_EXPERT_CART_SV, "Aktivera Expert Cartridge"},
/* tr */ {IDCLS_ENABLE_EXPERT_CART_TR, "Expert Kartuu'nu aktif et"},
#endif

/* c64/expert.c */
/* en */ {IDCLS_DISABLE_EXPERT_CART,    N_("Disable the Expert Cartridge")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_EXPERT_CART_DA, "Deaktivr Expert Cartridge"},
/* de */ {IDCLS_DISABLE_EXPERT_CART_DE, "Expert Cartridge deaktivieren"},
/* es */ {IDCLS_DISABLE_EXPERT_CART_ES, "Deshabilitar Expert Cartridge"},
/* fr */ {IDCLS_DISABLE_EXPERT_CART_FR, "Dsactiver la Cartouche Expert"},
/* hu */ {IDCLS_DISABLE_EXPERT_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_EXPERT_CART_IT, "Disattiva Expert Cartridge"},
/* ko */ {IDCLS_DISABLE_EXPERT_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_EXPERT_CART_NL, "Expert Cartridge uitschakelen"},
/* pl */ {IDCLS_DISABLE_EXPERT_CART_PL, "Wycz Expert Cartridge"},
/* ru */ {IDCLS_DISABLE_EXPERT_CART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_EXPERT_CART_SV, "Inaktivera Expert Cartridge"},
/* tr */ {IDCLS_DISABLE_EXPERT_CART_TR, "Expert Kartuu'nu pasifletir"},
#endif

/* c64/expert.c */
/* en */ {IDCLS_SET_EXPERT_FILENAME,    N_("Set Expert Cartridge image name")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_EXPERT_FILENAME_DA, "Vlg Expert Cartridge image-navn"},
/* de */ {IDCLS_SET_EXPERT_FILENAME_DE, "Expert Cartridge Imagedateiname setzen"},
/* es */ {IDCLS_SET_EXPERT_FILENAME_ES, "Seleccionar nombre imagen Expert Cartridge"},
/* fr */ {IDCLS_SET_EXPERT_FILENAME_FR, "Choisir le nom de l'image de la Cartouche Expert"},
/* hu */ {IDCLS_SET_EXPERT_FILENAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_EXPERT_FILENAME_IT, "Imposta nome immagine Expert Cartridge"},
/* ko */ {IDCLS_SET_EXPERT_FILENAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_EXPERT_FILENAME_NL, "Stel Expert Cartridge bestandsnaam in"},
/* pl */ {IDCLS_SET_EXPERT_FILENAME_PL, "Okrel nazw obrazu Expert Cartridge"},
/* ru */ {IDCLS_SET_EXPERT_FILENAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_EXPERT_FILENAME_SV, "Vlj Expert Cartridge-modulfil"},
/* tr */ {IDCLS_SET_EXPERT_FILENAME_TR, "Expert Kartu imaj ismini belirle"},
#endif

/* c64/expert.c */
/* en */ {IDCLS_SET_EXPERT_MODE,    N_("Set Expert Cartridge mode (0: Off, 1: Prg, 2: On)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_EXPERT_MODE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_EXPERT_MODE_DE, "Setze Expert Cartridge Modus (0: Off, 1: Prg, 2: On)"},
/* es */ {IDCLS_SET_EXPERT_MODE_ES, "Seleccionar modo Expert Cartridge (0: Apagado, 1: Prg, 2: Encendido)"},
/* fr */ {IDCLS_SET_EXPERT_MODE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_EXPERT_MODE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_EXPERT_MODE_IT, "Imposta modalit Expert Cartridge (0: Off, 1: Prg, 2: On)"},
/* ko */ {IDCLS_SET_EXPERT_MODE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_EXPERT_MODE_NL, "Stel de Expert Cartridge modus in (0: uit, 1: prg, 2: aan)"},
/* pl */ {IDCLS_SET_EXPERT_MODE_PL, "Wybierz tryb Expert Cartridge (0: Wyczony, 1: Prg, 2: Wczony)"},
/* ru */ {IDCLS_SET_EXPERT_MODE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_EXPERT_MODE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_EXPERT_MODE_TR, ""},  /* fuzzy */
#endif

/* c64/expert.c */
/* en */ {IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE,    N_("Allow writing to Expert Cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE_DA, "Tillad skrivning til Expert Cartridge image"},
/* de */ {IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE_DE, "Schreibzugriff auf Expert Cartridge Image erlauben"},
/* es */ {IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE_ES, "Permitir grabacin en Expert Cartridge"},
/* fr */ {IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE_FR, "Permettre l'criture sur l'image Cartouche Expert"},
/* hu */ {IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE_IT, "Attiva scrittura su immagine Expert Cartridge"},
/* ko */ {IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE_NL, "Sta schrijven naar Expert Cartridge bestand toe"},
/* pl */ {IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE_PL, "Pozwl na zapis do obrazu Expert Cartridge"},
/* ru */ {IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE_RU, "Allow writing to Expert Cartridge image"},
/* sv */ {IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE_SV, "Tillt skrivning till Expert Cartridge-avbildning"},
/* tr */ {IDCLS_ALLOW_WRITING_TO_EXPERT_IMAGE_TR, "Expert Kartu imajna yazmaya izin ver"},
#endif

/* c64/expert.c */
/* en */ {IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE,    N_("Do not write to Expert Cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE_DA, "Skriv ikke til Expert Cartridge image"},
/* de */ {IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE_DE, "Kein Schreibzugriff auf Expert Cartridge Image"},
/* es */ {IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE_ES, "Deshabilitar grabacin en Expert Cartridge"},
/* fr */ {IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE_FR, "NE PAS permettre l'criture sur l'image de Cartouche Expert"},
/* hu */ {IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE_IT, "Disattiva scrittura su immagine Expert Cartridge"},
/* ko */ {IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE_NL, "Schrijf niet naar Expert Cartridge bestand"},
/* pl */ {IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE_PL, "Nie zapisuj do obrazu Expert Cartridge"},
/* ru */ {IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE_RU, "Do not write to Expert Cartridge image"},
/* sv */ {IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE_SV, "Skriv inte till Expert Cartridge-avbildning"},
/* tr */ {IDCLS_DO_NOT_WRITE_TO_EXPERT_IMAGE_TR, "Expert Kartu imajna yazma"},
#endif

/* c64/cart/c64cart.c */
/* en */ {IDCLS_DISABLE_CART,    N_("Disable default cartridge")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_CART_DA, "Deaktivr standard cartridge"},
/* de */ {IDCLS_DISABLE_CART_DE, "Standard Modul deaktivieren"},
/* es */ {IDCLS_DISABLE_CART_ES, "Deshabilitar cartucho por defecto"},
/* fr */ {IDCLS_DISABLE_CART_FR, "Dsactiver la cartouche par dfaut"},
/* hu */ {IDCLS_DISABLE_CART_HU, "Alap cartridge tiltsa"},
/* it */ {IDCLS_DISABLE_CART_IT, "Disattiva cartuccia predefinita"},
/* ko */ {IDCLS_DISABLE_CART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_CART_NL, "Standaard cartridge uitschakelen"},
/* pl */ {IDCLS_DISABLE_CART_PL, "Wycz domylny kartrid"},
/* ru */ {IDCLS_DISABLE_CART_RU, "Disable default cartridge"},
/* sv */ {IDCLS_DISABLE_CART_SV, "Inaktivera standardinsticksmodul"},
/* tr */ {IDCLS_DISABLE_CART_TR, "Varsaylan kartuu pasifletir"},
#endif

/* plus4/plus4cart.c */
/* en */ {IDCLS_SMART_ATTACH_CART,    N_("Smart-attach cartridge image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SMART_ATTACH_CART_DA, "Smart-tilslut cartridge-image"},
/* de */ {IDCLS_SMART_ATTACH_CART_DE, "Smart-Einlegen Modul Image"},
/* es */ {IDCLS_SMART_ATTACH_CART_ES, "Insertar imagen cartucho inteligentemente"},
/* fr */ {IDCLS_SMART_ATTACH_CART_FR, "Insertion intelligente d'une image de cartouche"},
/* hu */ {IDCLS_SMART_ATTACH_CART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SMART_ATTACH_CART_IT, "Seleziona una cartuccia"},
/* ko */ {IDCLS_SMART_ATTACH_CART_KO, "īƮ ̹ Ʈ-̱ ϱ"},
/* nl */ {IDCLS_SMART_ATTACH_CART_NL, "Slim-koppel cartridge bestand"},
/* pl */ {IDCLS_SMART_ATTACH_CART_PL, "Inteligentnie zamontuj obraz kartrida"},
/* ru */ {IDCLS_SMART_ATTACH_CART_RU, "Smart-attach cartridge image"},
/* sv */ {IDCLS_SMART_ATTACH_CART_SV, "Smartanslut insticksmodulfil"},
/* tr */ {IDCLS_SMART_ATTACH_CART_TR, "Akll kartu imaj yerletir"},
#endif

/* c64/cart/ide64.c */
/* en */ {IDCLS_SPECIFY_IDE64_NAME,    N_("Specify name of IDE64 image file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_IDE64_NAME_DA, "Angiv navn p IDE64-cartridge image"},
/* de */ {IDCLS_SPECIFY_IDE64_NAME_DE, "Namen fr IDE64 Imagedatei whlen"},
/* es */ {IDCLS_SPECIFY_IDE64_NAME_ES, "Especificar nombre fichero imagen IDE64"},
/* fr */ {IDCLS_SPECIFY_IDE64_NAME_FR, "Spcifier le nom de l'image IDE64"},
/* hu */ {IDCLS_SPECIFY_IDE64_NAME_HU, "Adja meg az IDE64 kpms fjlnevt"},
/* it */ {IDCLS_SPECIFY_IDE64_NAME_IT, "Specifica il nome del file immagine dell'IDE64"},
/* ko */ {IDCLS_SPECIFY_IDE64_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_IDE64_NAME_NL, "Geef de naam van het IDE64 bestand"},
/* pl */ {IDCLS_SPECIFY_IDE64_NAME_PL, "Okrel nazw pliku obrazu IDE64"},
/* ru */ {IDCLS_SPECIFY_IDE64_NAME_RU, "Specify name of IDE64 image file"},
/* sv */ {IDCLS_SPECIFY_IDE64_NAME_SV, "Ange namn p IDE64-insticksmodulfil"},
/* tr */ {IDCLS_SPECIFY_IDE64_NAME_TR, "IDE64 imaj dosyasnn ismini belirt"},
#endif

/* c64/cart/ide64.c, gfxoutputdrv/ffmpegdrv.c, datasette.c,
   debug.c, mouse.c, ram.c, sound.c, vsync.c */
/* en */ {IDCLS_P_VALUE,    N_("<value>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_VALUE_DA, "<vrdi>"},
/* de */ {IDCLS_P_VALUE_DE, "<Wert>"},
/* es */ {IDCLS_P_VALUE_ES, "<valor>"},
/* fr */ {IDCLS_P_VALUE_FR, "<valeur>"},
/* hu */ {IDCLS_P_VALUE_HU, "<rtk>"},
/* it */ {IDCLS_P_VALUE_IT, "<valore>"},
/* ko */ {IDCLS_P_VALUE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_VALUE_NL, "<waarde>"},
/* pl */ {IDCLS_P_VALUE_PL, "<warto>"},
/* ru */ {IDCLS_P_VALUE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_P_VALUE_SV, "<vrde>"},
/* tr */ {IDCLS_P_VALUE_TR, "<deer>"},
#endif

/* c64/cart/ide64.c */
/* en */ {IDCLS_SET_AMOUNT_CYLINDERS_IDE64,    N_("Set number of cylinders for the IDE64 emulation. (1..65535)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_AMOUNT_CYLINDERS_IDE64_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_AMOUNT_CYLINDERS_IDE64_DE, "Anzahl der Zylinder fr IDE64 Emulation. (1..65535)"},
/* es */ {IDCLS_SET_AMOUNT_CYLINDERS_IDE64_ES, "Seleccionar nmero de cilindros para emulacin IDE64 (1..65535)"},
/* fr */ {IDCLS_SET_AMOUNT_CYLINDERS_IDE64_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_AMOUNT_CYLINDERS_IDE64_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_AMOUNT_CYLINDERS_IDE64_IT, "Imposta il numero di cilindri dell'emulazione IDE64. (1..65535)"},
/* ko */ {IDCLS_SET_AMOUNT_CYLINDERS_IDE64_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_AMOUNT_CYLINDERS_IDE64_NL, "Stel het aantal cylinders voor de IDE64 emulatie in. (1..65535)"},
/* pl */ {IDCLS_SET_AMOUNT_CYLINDERS_IDE64_PL, "Okrel liczb cylindrw w emulacji IDE64. (1..65535)"},
/* ru */ {IDCLS_SET_AMOUNT_CYLINDERS_IDE64_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_AMOUNT_CYLINDERS_IDE64_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_AMOUNT_CYLINDERS_IDE64_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ide64.c */
/* en */ {IDCLS_SET_AMOUNT_HEADS_IDE64,    N_("Set number of heads for the IDE64 emulation. (1..16)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_AMOUNT_HEADS_IDE64_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_AMOUNT_HEADS_IDE64_DE, "Anzahl der Laufwerkskpfe fr IDE64 Emulation. (1..16)"},
/* es */ {IDCLS_SET_AMOUNT_HEADS_IDE64_ES, "Seleccionar nmero de cabezas para emulacin IDE64 (1..16)"},
/* fr */ {IDCLS_SET_AMOUNT_HEADS_IDE64_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_AMOUNT_HEADS_IDE64_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_AMOUNT_HEADS_IDE64_IT, "Imposta il numero di testine dell'emulazione IDE64. (1..16)"},
/* ko */ {IDCLS_SET_AMOUNT_HEADS_IDE64_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_AMOUNT_HEADS_IDE64_NL, "Stel het aantal koppen voor de IDE64 emulatie in. (1..16)"},
/* pl */ {IDCLS_SET_AMOUNT_HEADS_IDE64_PL, "Okrel liczb gowic w emulacji IDE64. (1..16)"},
/* ru */ {IDCLS_SET_AMOUNT_HEADS_IDE64_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_AMOUNT_HEADS_IDE64_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_AMOUNT_HEADS_IDE64_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ide64.c */
/* en */ {IDCLS_SET_AMOUNT_SECTORS_IDE64,    N_("Set number of sectors for the IDE64 emulation. (1..63)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_AMOUNT_SECTORS_IDE64_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_AMOUNT_SECTORS_IDE64_DE, "Anzahl der Sektoren fr IDE64 Emulation. (1..63)"},
/* es */ {IDCLS_SET_AMOUNT_SECTORS_IDE64_ES, "Seleccionar nmero de sectores para emulacin IDE64 (1..63)"},
/* fr */ {IDCLS_SET_AMOUNT_SECTORS_IDE64_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_AMOUNT_SECTORS_IDE64_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_AMOUNT_SECTORS_IDE64_IT, "Imposta il numero di settori dell'emulazione IDE64. (1..63)"},
/* ko */ {IDCLS_SET_AMOUNT_SECTORS_IDE64_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_AMOUNT_SECTORS_IDE64_NL, "Stel het aantal sectors voor de IDE64 emulatie in. (1..63)"},
/* pl */ {IDCLS_SET_AMOUNT_SECTORS_IDE64_PL, "Okrel liczb sektorw w emulacji IDE64. (1..63)"},
/* ru */ {IDCLS_SET_AMOUNT_SECTORS_IDE64_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_AMOUNT_SECTORS_IDE64_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_AMOUNT_SECTORS_IDE64_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ide64.c */
/* en */ {IDCLS_AUTODETECT_IDE64_GEOMETRY,    N_("Autodetect image size")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_AUTODETECT_IDE64_GEOMETRY_DA, "Autodetektr strrelse p image"},
/* de */ {IDCLS_AUTODETECT_IDE64_GEOMETRY_DE, "Image Gre automatisch erkennen"},
/* es */ {IDCLS_AUTODETECT_IDE64_GEOMETRY_ES, "Autodeteccin del tamao de la imagen"},
/* fr */ {IDCLS_AUTODETECT_IDE64_GEOMETRY_FR, "Autodtection de la taille de l'image"},
/* hu */ {IDCLS_AUTODETECT_IDE64_GEOMETRY_HU, ""},  /* fuzzy */
/* it */ {IDCLS_AUTODETECT_IDE64_GEOMETRY_IT, "Rileva automaticamente immagine"},
/* ko */ {IDCLS_AUTODETECT_IDE64_GEOMETRY_KO, "̹ ũ ڵ ã"},
/* nl */ {IDCLS_AUTODETECT_IDE64_GEOMETRY_NL, "Automatisch detecteren bestandsgrootte"},
/* pl */ {IDCLS_AUTODETECT_IDE64_GEOMETRY_PL, "Automatycznie wykrywaj rozmiar obrazu"},
/* ru */ {IDCLS_AUTODETECT_IDE64_GEOMETRY_RU, "   "},
/* sv */ {IDCLS_AUTODETECT_IDE64_GEOMETRY_SV, "Autodetektera storlek p avbildning"},
/* tr */ {IDCLS_AUTODETECT_IDE64_GEOMETRY_TR, "Imaj boyutunu otomatik algla"},
#endif

/* c64/cart/ide64.c */
/* en */ {IDCLS_NO_AUTODETECT_IDE64_GEOMETRY,    N_("Do not autodetect geometry of formatted images")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_DA, "Autodetektr ikke geometri fra formatterede images"},
/* de */ {IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_DE, "Geometrie von formatierten Imagedateien nicht automatisch erkennen"},
/* es */ {IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_ES, "No autodetectar formato geometra imgenes"},
/* fr */ {IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_FR, "Ne pas dtecter automatiquement la gomtrie des images formattes"},
/* hu */ {IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_HU, "Formzott kpmsok geometrijt ne ismerje fel automatikusan"},
/* it */ {IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_IT, "Non rilevare automaticamente la geometrica delle immagini formattate"},
/* ko */ {IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_NL, "Niet automatisch de grootte van de geformatteerde bestanden detecteren"},
/* pl */ {IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_PL, "Nie wykrywaj geometrii sformatowanych obrazw"},
/* ru */ {IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_RU, "Do not autodetect geometry of formatted images"},
/* sv */ {IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_SV, "Autodetektera inte geometri frn formaterad avbildningsfil"},
/* tr */ {IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_TR, "Formatlanm imajlarn yaplarn otomatik alglama"},
#endif

/* c64/cart/ide64.c */
/* en */ {IDCLS_IDE64_VERSION,    N_("IDE64 cartridge version")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_IDE64_VERSION_DA, ""},  /* fuzzy */
/* de */ {IDCLS_IDE64_VERSION_DE, "IDE64 Modul Version"},
/* es */ {IDCLS_IDE64_VERSION_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_IDE64_VERSION_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_IDE64_VERSION_HU, ""},  /* fuzzy */
/* it */ {IDCLS_IDE64_VERSION_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_IDE64_VERSION_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_IDE64_VERSION_NL, "IDE64 cartridge versie"},
/* pl */ {IDCLS_IDE64_VERSION_PL, "Wersja kartrida IDE64"},
/* ru */ {IDCLS_IDE64_VERSION_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_IDE64_VERSION_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_IDE64_VERSION_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ide64.c */
/* en */ {IDCLS_ENABLE_IDE64_USB_SERVER,    N_("Enable IDE64 USB server")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_IDE64_USB_SERVER_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_IDE64_USB_SERVER_DE, "IDE64 USB Server aktivieren"},
/* es */ {IDCLS_ENABLE_IDE64_USB_SERVER_ES, "Permitir IDE64 USB server"},
/* fr */ {IDCLS_ENABLE_IDE64_USB_SERVER_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_IDE64_USB_SERVER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_IDE64_USB_SERVER_IT, "Attiva server IDE64 USB"},
/* ko */ {IDCLS_ENABLE_IDE64_USB_SERVER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_IDE64_USB_SERVER_NL, "IDE64 USB server inschakelen"},
/* pl */ {IDCLS_ENABLE_IDE64_USB_SERVER_PL, "Wcz serwer USB IDE64"},
/* ru */ {IDCLS_ENABLE_IDE64_USB_SERVER_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_IDE64_USB_SERVER_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_IDE64_USB_SERVER_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ide64.c */
/* en */ {IDCLS_DISABLE_IDE64_USB_SERVER,    N_("Disable IDE64 USB server")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_IDE64_USB_SERVER_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_IDE64_USB_SERVER_DE, "IDE64 USB Server deaktivieren"},
/* es */ {IDCLS_DISABLE_IDE64_USB_SERVER_ES, "Deshabilitar servidor IDE64 USB"},
/* fr */ {IDCLS_DISABLE_IDE64_USB_SERVER_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_IDE64_USB_SERVER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_IDE64_USB_SERVER_IT, "Disattiva server IDE64 USB"},
/* ko */ {IDCLS_DISABLE_IDE64_USB_SERVER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_IDE64_USB_SERVER_NL, "IDE64 USB server uitschakelen"},
/* pl */ {IDCLS_DISABLE_IDE64_USB_SERVER_PL, "Wycz serwer USB IDE64"},
/* ru */ {IDCLS_DISABLE_IDE64_USB_SERVER_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_IDE64_USB_SERVER_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_IDE64_USB_SERVER_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ide64.c */
/* en */ {IDCLS_IDE64_USB_SERVER_ADDRESS,    N_("IDE64 USB server address")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_IDE64_USB_SERVER_ADDRESS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_IDE64_USB_SERVER_ADDRESS_DE, "IDE64 USB Server Adresse"},
/* es */ {IDCLS_IDE64_USB_SERVER_ADDRESS_ES, "Seleccionar direccin servidor IDE64 USB"},
/* fr */ {IDCLS_IDE64_USB_SERVER_ADDRESS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_IDE64_USB_SERVER_ADDRESS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_IDE64_USB_SERVER_ADDRESS_IT, "Indirizzo server IDE64 USB"},
/* ko */ {IDCLS_IDE64_USB_SERVER_ADDRESS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_IDE64_USB_SERVER_ADDRESS_NL, "IDE64 USB serveradres"},
/* pl */ {IDCLS_IDE64_USB_SERVER_ADDRESS_PL, "Adres serwera USB IDE64"},
/* ru */ {IDCLS_IDE64_USB_SERVER_ADDRESS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_IDE64_USB_SERVER_ADDRESS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_IDE64_USB_SERVER_ADDRESS_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ide64.c */
/* en */ {IDCLS_ENABLE_IDE64_RTC_SAVE,    N_("Enable saving of IDE64 RTC data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_IDE64_RTC_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_IDE64_RTC_SAVE_DE, "IDE64 RTC Daten bei nderung speichern."},
/* es */ {IDCLS_ENABLE_IDE64_RTC_SAVE_ES, "Permitir grabar datos IDE64 RTC cuando cambien"},
/* fr */ {IDCLS_ENABLE_IDE64_RTC_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_IDE64_RTC_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_IDE64_RTC_SAVE_IT, "Attiva il salvataggio dei dati RTC dell'IDE64 alla modifica."},
/* ko */ {IDCLS_ENABLE_IDE64_RTC_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_IDE64_RTC_SAVE_NL, "Opslaan van de IDE64 RTC gegevens bij wijziging inschakelen."},
/* pl */ {IDCLS_ENABLE_IDE64_RTC_SAVE_PL, "Zapisuj dane zegara czasu rzeczywistego IDE64 przy zmianie"},
/* ru */ {IDCLS_ENABLE_IDE64_RTC_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_IDE64_RTC_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_IDE64_RTC_SAVE_TR, ""},  /* fuzzy */
#endif

/* c64/cart/ide64.c */
/* en */ {IDCLS_DISABLE_IDE64_RTC_SAVE,    N_("Disable saving of IDE64 RTC data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_IDE64_RTC_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_IDE64_RTC_SAVE_DE, "IDE64 RTC Daten bei nderung nicht speichern."},
/* es */ {IDCLS_DISABLE_IDE64_RTC_SAVE_ES, "Deshabilitar grabar datos IDE64 RTC cuando cambien"},
/* fr */ {IDCLS_DISABLE_IDE64_RTC_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_IDE64_RTC_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_IDE64_RTC_SAVE_IT, "Disattiva il salvataggio dei dati RTC dell'IDE64 alla modifica."},
/* ko */ {IDCLS_DISABLE_IDE64_RTC_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_IDE64_RTC_SAVE_NL, "Opslaan van de IDE64 RTC gegevens bij wijziging uitschakelen."},
/* pl */ {IDCLS_DISABLE_IDE64_RTC_SAVE_PL, "Nie zapisuj danych zegara czasu rzeczywistego IDE64 przy zmianie"},
/* ru */ {IDCLS_DISABLE_IDE64_RTC_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_IDE64_RTC_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_IDE64_RTC_SAVE_TR, ""},  /* fuzzy */
#endif

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_P_MODELNUMBER,    N_("<modelnumber>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_MODELNUMBER_DA, "<modelnummer>"},
/* de */ {IDCLS_P_MODELNUMBER_DE, "<Modell Nummer>"},
/* es */ {IDCLS_P_MODELNUMBER_ES, "<nmero modelo>"},
/* fr */ {IDCLS_P_MODELNUMBER_FR, "<numerodemodele>"},
/* hu */ {IDCLS_P_MODELNUMBER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_MODELNUMBER_IT, "<numero di modello>"},
/* ko */ {IDCLS_P_MODELNUMBER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_MODELNUMBER_NL, "<modelnummer>"},
/* pl */ {IDCLS_P_MODELNUMBER_PL, "<modelnumber>"},
/* ru */ {IDCLS_P_MODELNUMBER_RU, "<modelnumber>"},
/* sv */ {IDCLS_P_MODELNUMBER_SV, "<modellnummer>"},
/* tr */ {IDCLS_P_MODELNUMBER_TR, "<modelnumaras>"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CBM2_MODEL,    N_("Specify CBM-II model to emulate. (610, 620, 620+, 710, 720, 720+)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_CBM2_MODEL_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_CBM2_MODEL_DE, "CBM-II Modell fr Emulation whlen. (610, 620, 620+, 710, 720, 720+)"},
/* es */ {IDCLS_SPECIFY_CBM2_MODEL_ES, "Especificar modelo CBM-II para emular. (610, 620, 620+, 710, 720, 720+)"},
/* fr */ {IDCLS_SPECIFY_CBM2_MODEL_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_CBM2_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_CBM2_MODEL_IT, "Specifica il modello di CBM II da emulare. (610, 620, 620+, 710, 720, 720+)"},
/* ko */ {IDCLS_SPECIFY_CBM2_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_CBM2_MODEL_NL, "Geef CBM-II model om te emuleren. (610, 620, 620+, 710, 720, 720+)"},
/* pl */ {IDCLS_SPECIFY_CBM2_MODEL_PL, "Okrel emulowany model CBM-II. (610, 620, 620+, 710, 720, 720+)"},
/* ru */ {IDCLS_SPECIFY_CBM2_MODEL_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_CBM2_MODEL_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_CBM2_MODEL_TR, ""},  /* fuzzy */
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CBM5X0_MODEL,    N_("Specify CBM-II model to emulate. (510)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_CBM5X0_MODEL_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_CBM5X0_MODEL_DE, "CBM-II Modell fr Emulation whlen. (510)"},
/* es */ {IDCLS_SPECIFY_CBM5X0_MODEL_ES, "Especificar modelo CBM-II para emular. (510)"},
/* fr */ {IDCLS_SPECIFY_CBM5X0_MODEL_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_CBM5X0_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_CBM5X0_MODEL_IT, "Specifica il modello di CBM II da emulare. (510)"},
/* ko */ {IDCLS_SPECIFY_CBM5X0_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_CBM5X0_MODEL_NL, "Geef CBM-II model om te emuleren. (510)"},
/* pl */ {IDCLS_SPECIFY_CBM5X0_MODEL_PL, "Okrel emulowany model CBM-II. (510)"},
/* ru */ {IDCLS_SPECIFY_CBM5X0_MODEL_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_CBM5X0_MODEL_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_CBM5X0_MODEL_TR, ""},  /* fuzzy */
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_TO_USE_VIC_II,    N_("Specify to use VIC-II")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_TO_USE_VIC_II_DA, "Brug VIC-II"},
/* de */ {IDCLS_SPECIFY_TO_USE_VIC_II_DE, "VIC-II Untersttzung aktivieren"},
/* es */ {IDCLS_SPECIFY_TO_USE_VIC_II_ES, "Especificar usar CBM-II"},
/* fr */ {IDCLS_SPECIFY_TO_USE_VIC_II_FR, "Spcifier l'utilisation de VIC-II"},
/* hu */ {IDCLS_SPECIFY_TO_USE_VIC_II_HU, "VIC-II hasznlata"},
/* it */ {IDCLS_SPECIFY_TO_USE_VIC_II_IT, "Specifica di utilizzare il VIC-II"},
/* ko */ {IDCLS_SPECIFY_TO_USE_VIC_II_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_TO_USE_VIC_II_NL, "Gebruik de VIC-II"},
/* pl */ {IDCLS_SPECIFY_TO_USE_VIC_II_PL, "Okrel uycie VIC-II"},
/* ru */ {IDCLS_SPECIFY_TO_USE_VIC_II_RU, "Specify to use VIC-II"},
/* sv */ {IDCLS_SPECIFY_TO_USE_VIC_II_SV, "Ange fr att anvnda VIC-II"},
/* tr */ {IDCLS_SPECIFY_TO_USE_VIC_II_TR, "VIC-II kullanm iin sein"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_TO_USE_CRTC,    N_("Specify to use CRTC")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_TO_USE_CRTC_DA, "Brug CRTC"},
/* de */ {IDCLS_SPECIFY_TO_USE_CRTC_DE, "CRTC Untersttzung aktivieren"},
/* es */ {IDCLS_SPECIFY_TO_USE_CRTC_ES, "Especificar usar CRT"},
/* fr */ {IDCLS_SPECIFY_TO_USE_CRTC_FR, "Spcifier l'utilisation de CRTC"},
/* hu */ {IDCLS_SPECIFY_TO_USE_CRTC_HU, "CRTC hasznlata"},
/* it */ {IDCLS_SPECIFY_TO_USE_CRTC_IT, "Specifica di utilizzare il CRTC"},
/* ko */ {IDCLS_SPECIFY_TO_USE_CRTC_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_TO_USE_CRTC_NL, "Gebruik de CRTC"},
/* pl */ {IDCLS_SPECIFY_TO_USE_CRTC_PL, "Okrel uycie CRTC"},
/* ru */ {IDCLS_SPECIFY_TO_USE_CRTC_RU, "Specify to use CRTC"},
/* sv */ {IDCLS_SPECIFY_TO_USE_CRTC_SV, "Ange fr att anvnda CRTC"},
/* tr */ {IDCLS_SPECIFY_TO_USE_CRTC_TR, "CRTC kullanm iin sein"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_P_LINENUMBER,    N_("<linenumber>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_LINENUMBER_DA, "<linjenummer>"},
/* de */ {IDCLS_P_LINENUMBER_DE, "<Zeilennummer>"},
/* es */ {IDCLS_P_LINENUMBER_ES, "<nmero linea>"},
/* fr */ {IDCLS_P_LINENUMBER_FR, "<numrodeligne>"},
/* hu */ {IDCLS_P_LINENUMBER_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_LINENUMBER_IT, "<numero di linea>"},
/* ko */ {IDCLS_P_LINENUMBER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_LINENUMBER_NL, "<lijnnummer>"},
/* pl */ {IDCLS_P_LINENUMBER_PL, "<linenumber>"},
/* ru */ {IDCLS_P_LINENUMBER_RU, "<linenumber>"},
/* sv */ {IDCLS_P_LINENUMBER_SV, "<linjenummer>"},
/* tr */ {IDCLS_P_LINENUMBER_TR, "<satrnumaras>"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CBM2_MODEL_HARDWARE,    N_("Specify CBM-II model hardware (0=6x0, 1=7x0)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_DA, "Angiv hardware for CBM-II-model (0=6x0, 1=7x0)"},
/* de */ {IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_DE, "CBM-II Hardware Modell whlen (0=6x0, 1=7x0)"},
/* es */ {IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_ES, "Especificar modelo hardware CBM-II (0=6x0, 1=7x0)"},
/* fr */ {IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_FR, "Spcifier le modle hardware CBM-II (0=6x0, 1=7x0)"},
/* hu */ {IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_HU, "Adja meg a CBM-II hardver modellt (0=6x0, 1=7x0)"},
/* it */ {IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_IT, "Specifica il modello hardware del CBM-II (0=6x0, 1=7x0)"},
/* ko */ {IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_NL, "Geef CBM-II hardwaremodel (0=6x0, 1=7x0)"},
/* pl */ {IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_PL, "Okrel model sprztu CBM-II (0=6x0, 1=7x0)"},
/* ru */ {IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_RU, "Specify CBM-II model hardware (0=6x0, 1=7x0)"},
/* sv */ {IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_SV, "Ange maskinvara fr CBM-II-modell (0=6x0, 1=7x0)"},
/* tr */ {IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_TR, "CBM-II modeli donanmn belirt (0=6x0, 1=7x0)"},
#endif

/* cbm2/cbm2-cmdline-options.c, plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_P_RAMSIZE,    N_("<RAM size>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_RAMSIZE_DA, "<RAM-strrelse>"},
/* de */ {IDCLS_P_RAMSIZE_DE, "<RAM Gre>"},
/* es */ {IDCLS_P_RAMSIZE_ES, "<Tamao RAM>"},
/* fr */ {IDCLS_P_RAMSIZE_FR, "<Taille de la RAM>"},
/* hu */ {IDCLS_P_RAMSIZE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_RAMSIZE_IT, "<Dimensione RAM>"},
/* ko */ {IDCLS_P_RAMSIZE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_RAMSIZE_NL, "<RAM grootte>"},
/* pl */ {IDCLS_P_RAMSIZE_PL, "<Rozmiar RAM>"},
/* ru */ {IDCLS_P_RAMSIZE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_P_RAMSIZE_SV, "<RAM-storlek>"},
/* tr */ {IDCLS_P_RAMSIZE_TR, "<RAM boyutu>"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_SIZE_OF_RAM,    N_("Specify size of RAM (64/128/256/512/1024 kByte)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_SIZE_OF_RAM_DA, "Angiv strrelse p RAM (64/128/256/512/1024 kByte)"},
/* de */ {IDCLS_SPECIFY_SIZE_OF_RAM_DE, "RAM Gre whlen (64/128/256/512/1024 kByte)"},
/* es */ {IDCLS_SPECIFY_SIZE_OF_RAM_ES, "Especificar tamao RAM  (64/128/256/512/1024 KB)"},
/* fr */ {IDCLS_SPECIFY_SIZE_OF_RAM_FR, "Spcifier la taille de la RAM (64/128/256/512/1024 KO)"},
/* hu */ {IDCLS_SPECIFY_SIZE_OF_RAM_HU, "Adja meg a RAM mrett (64/128/256/512/1024 kBjt)"},
/* it */ {IDCLS_SPECIFY_SIZE_OF_RAM_IT, "Specifica la dimensione della RAM (4/128/256/512/1024 kByte)"},
/* ko */ {IDCLS_SPECIFY_SIZE_OF_RAM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_SIZE_OF_RAM_NL, "Geef geheugengrootte (64/128/256/512/1024 kByte)"},
/* pl */ {IDCLS_SPECIFY_SIZE_OF_RAM_PL, "Okrel rozmiar RAM-u (64/128/256/512/1024 kBajty)"},
/* ru */ {IDCLS_SPECIFY_SIZE_OF_RAM_RU, "Specify size of RAM (64/128/256/512/1024 kByte)"},
/* sv */ {IDCLS_SPECIFY_SIZE_OF_RAM_SV, "Ange storlek p RAM (64/128/256/512/1024 kByte)"},
/* tr */ {IDCLS_SPECIFY_SIZE_OF_RAM_TR, "RAM boyutunu belirt (64/128/256/512/1024 kByte)"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_SIZE_OF_RAM_CBM2,    N_("Specify size of RAM (128/256/512/1024 kByte)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_SIZE_OF_RAM_CBM2_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_SIZE_OF_RAM_CBM2_DE, "RAM Gre whlen (128/256/512/1024 kByte)"},
/* es */ {IDCLS_SPECIFY_SIZE_OF_RAM_CBM2_ES, "Especificar tamao RAM  (128/256/512/1024 kByte)"},
/* fr */ {IDCLS_SPECIFY_SIZE_OF_RAM_CBM2_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_SIZE_OF_RAM_CBM2_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_SIZE_OF_RAM_CBM2_IT, "Specifica la dimensione della RAM (128/256/512/1024 kByte)"},
/* ko */ {IDCLS_SPECIFY_SIZE_OF_RAM_CBM2_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_SIZE_OF_RAM_CBM2_NL, "Geef geheugengrootte (128/256/512/1024 kByte)"},
/* pl */ {IDCLS_SPECIFY_SIZE_OF_RAM_CBM2_PL, "Okrel rozmiar RAM-u (128/256/512/1024 kB)"},
/* ru */ {IDCLS_SPECIFY_SIZE_OF_RAM_CBM2_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_SIZE_OF_RAM_CBM2_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_SIZE_OF_RAM_CBM2_TR, ""},  /* fuzzy */
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_ROM_1000_NAME,    N_("Specify name of cartridge ROM image for $1000")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_CART_ROM_1000_NAME_DA, "Angiv navn p cartridge-ROM-image for $1000"},
/* de */ {IDCLS_SPECIFY_CART_ROM_1000_NAME_DE, "Name fr ROM Module Imagedatei ($1000)"},
/* es */ {IDCLS_SPECIFY_CART_ROM_1000_NAME_ES, "Especificar nombre imagen cartucho ROM para $1000"},
/* fr */ {IDCLS_SPECIFY_CART_ROM_1000_NAME_FR, "Spcifier le nom de limage de cartouche ROM pour $1000"},
/* hu */ {IDCLS_SPECIFY_CART_ROM_1000_NAME_HU, "Adja meg a $1000 cm cartridge ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_CART_ROM_1000_NAME_IT, "Specifica il nome immagine della cartuccia ROM a $1000"},
/* ko */ {IDCLS_SPECIFY_CART_ROM_1000_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_CART_ROM_1000_NAME_NL, "Geef de naam van het cartridge ROM bestand voor $1000"},
/* pl */ {IDCLS_SPECIFY_CART_ROM_1000_NAME_PL, "Okrel nazw obrazu ROM kartrida w $1000"},
/* ru */ {IDCLS_SPECIFY_CART_ROM_1000_NAME_RU, "Specify name of cartridge ROM image for $1000"},
/* sv */ {IDCLS_SPECIFY_CART_ROM_1000_NAME_SV, "Ange namn p insticksmodul-ROM-avbildning fr $1000"},
/* tr */ {IDCLS_SPECIFY_CART_ROM_1000_NAME_TR, "$1000 adresi iin kartu ROM imaj ismini belirt"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_ROM_2000_NAME,    N_("Specify name of cartridge ROM image for $2000-$3fff")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_CART_ROM_2000_NAME_DA, "Angiv navn p cartridge-ROM-image for $2000-3fff"},
/* de */ {IDCLS_SPECIFY_CART_ROM_2000_NAME_DE, "Name fr ROM Module Imagedatei ($2000-3fff)"},
/* es */ {IDCLS_SPECIFY_CART_ROM_2000_NAME_ES, "Especificar nombre imagen cartucho ROM para $2000-$3FFF"},
/* fr */ {IDCLS_SPECIFY_CART_ROM_2000_NAME_FR, "Spcifier le nom de limage de cartouche ROM pour $2000-$3fff"},
/* hu */ {IDCLS_SPECIFY_CART_ROM_2000_NAME_HU, "Adja meg a $2000-$3fff cm cartridge ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_CART_ROM_2000_NAME_IT, "Specifica il nome immagine della ROM della cartuccia per $2000-$3fff"},
/* ko */ {IDCLS_SPECIFY_CART_ROM_2000_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_CART_ROM_2000_NAME_NL, "Geef de naam van het cartridge ROM bestand voor $2000-$3fff"},
/* pl */ {IDCLS_SPECIFY_CART_ROM_2000_NAME_PL, "Okrel nazw obrazu ROM kartrida w $2000-$3fff"},
/* ru */ {IDCLS_SPECIFY_CART_ROM_2000_NAME_RU, "Specify name of cartridge ROM image for $2000-$3fff"},
/* sv */ {IDCLS_SPECIFY_CART_ROM_2000_NAME_SV, "Ange namn p insticksmodul-ROM-avbildning fr $2000-3fff"},
/* tr */ {IDCLS_SPECIFY_CART_ROM_2000_NAME_TR, "$2000-$3fff adres aral iin kartu ROM imaj ismini belirt"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_ROM_4000_NAME,    N_("Specify name of cartridge ROM image for $4000-$5fff")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_CART_ROM_4000_NAME_DA, "Angiv navn p cartridge-ROM-image for $4000-$5fff"},
/* de */ {IDCLS_SPECIFY_CART_ROM_4000_NAME_DE, "Name fr ROM Module Imagedatei ($4000-5fff)"},
/* es */ {IDCLS_SPECIFY_CART_ROM_4000_NAME_ES, "Especificar nombre imagen cartucho ROM para $4000-$5FFF"},
/* fr */ {IDCLS_SPECIFY_CART_ROM_4000_NAME_FR, "Spcifier le nom de limage de cartouche ROM pour $4000-$5fff"},
/* hu */ {IDCLS_SPECIFY_CART_ROM_4000_NAME_HU, "Adja meg a $4000-$5fff cm cartridge ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_CART_ROM_4000_NAME_IT, "Specifica il nome immagine della ROM della cartuccia per $4000-$5fff"},
/* ko */ {IDCLS_SPECIFY_CART_ROM_4000_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_CART_ROM_4000_NAME_NL, "Geef de naam van het cartridge ROM bestand voor $4000-$5fff"},
/* pl */ {IDCLS_SPECIFY_CART_ROM_4000_NAME_PL, "Okrel nazw obrazu ROM kartrida w $4000-$5fff"},
/* ru */ {IDCLS_SPECIFY_CART_ROM_4000_NAME_RU, "Specify name of cartridge ROM image for $4000-$5fff"},
/* sv */ {IDCLS_SPECIFY_CART_ROM_4000_NAME_SV, "Ange namn p insticksmodul-ROM-avbildning fr $4000-$5fff"},
/* tr */ {IDCLS_SPECIFY_CART_ROM_4000_NAME_TR, "$4000-$5fff adres aral iin kartu ROM imaj ismini belirt"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_ROM_6000_NAME,    N_("Specify name of cartridge ROM image for $6000-$7fff")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_CART_ROM_6000_NAME_DA, "Angiv navn p cartridge-ROM-image for $6000-$7fff"},
/* de */ {IDCLS_SPECIFY_CART_ROM_6000_NAME_DE, "Name fr ROM Module Imagedatei ($6000-7fff)"},
/* es */ {IDCLS_SPECIFY_CART_ROM_6000_NAME_ES, "Especificar nombre imagen cartucho ROM para $6000-$7FFF"},
/* fr */ {IDCLS_SPECIFY_CART_ROM_6000_NAME_FR, "Spcifier le nom de limage de cartouche ROM pour $6000-$7fff"},
/* hu */ {IDCLS_SPECIFY_CART_ROM_6000_NAME_HU, "Adja meg a $6000-$7fff cm cartridge ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_CART_ROM_6000_NAME_IT, "Specifica il nome immagine della ROM della cartuccia per $6000-$7fff"},
/* ko */ {IDCLS_SPECIFY_CART_ROM_6000_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_CART_ROM_6000_NAME_NL, "Geef de naam van het cartridge ROM bestand voor $6000-$7fff"},
/* pl */ {IDCLS_SPECIFY_CART_ROM_6000_NAME_PL, "Okrel nazw obrazu ROM kartrida w $6000-$7fff"},
/* ru */ {IDCLS_SPECIFY_CART_ROM_6000_NAME_RU, "Specify name of cartridge ROM image for $6000-$7fff"},
/* sv */ {IDCLS_SPECIFY_CART_ROM_6000_NAME_SV, "Ange namn p insticksmodul-ROM-avbildning fr $6000-$7fff"},
/* tr */ {IDCLS_SPECIFY_CART_ROM_6000_NAME_TR, "$6000-$7fff adres aral iin kartu ROM imaj ismini belirt"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_ENABLE_RAM_MAPPING_IN_0800,    N_("Enable RAM mapping in $0800-$0FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_RAM_MAPPING_IN_0800_DA, "Aktivr RAM-mappning p $0800-$0FFF"},
/* de */ {IDCLS_ENABLE_RAM_MAPPING_IN_0800_DE, "RAM Zuordnung in $0800-$0FFF aktivieren"},
/* es */ {IDCLS_ENABLE_RAM_MAPPING_IN_0800_ES, "Permitir mapeado RAM en $0800-$0FFF"},
/* fr */ {IDCLS_ENABLE_RAM_MAPPING_IN_0800_FR, "Activer le mappage RAM dans $0800-$0FFF"},
/* hu */ {IDCLS_ENABLE_RAM_MAPPING_IN_0800_HU, "$0800-$0FFF RAM lekpzs engedlyezse"},
/* it */ {IDCLS_ENABLE_RAM_MAPPING_IN_0800_IT, "Attiva mappatura della RAM a $0800-$0FFF"},
/* ko */ {IDCLS_ENABLE_RAM_MAPPING_IN_0800_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_RAM_MAPPING_IN_0800_NL, "RAM op adres $0800-$0FFF inschakelen"},
/* pl */ {IDCLS_ENABLE_RAM_MAPPING_IN_0800_PL, "Wcz mapowanie RAM w $0800-$0FFF"},
/* ru */ {IDCLS_ENABLE_RAM_MAPPING_IN_0800_RU, "Enable RAM mapping in $0800-$0FFF"},
/* sv */ {IDCLS_ENABLE_RAM_MAPPING_IN_0800_SV, "Aktivera RAM-mappning p $0800-$0FFF"},
/* tr */ {IDCLS_ENABLE_RAM_MAPPING_IN_0800_TR, "$0800-$0FFF aralnda RAM eletirmeyi aktif et"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_DISABLE_RAM_MAPPING_IN_0800,    N_("Disable RAM mapping in $0800-$0FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_RAM_MAPPING_IN_0800_DA, "Deaktivr RAM-mappning p $0800-$0FFF"},
/* de */ {IDCLS_DISABLE_RAM_MAPPING_IN_0800_DE, "RAM Zuordnung in $0800-$0FFF deaktivieren"},
/* es */ {IDCLS_DISABLE_RAM_MAPPING_IN_0800_ES, "Deshabilitar mapeado RAM en $0800-$0FFF"},
/* fr */ {IDCLS_DISABLE_RAM_MAPPING_IN_0800_FR, "Dsactiver le mappage RAM dans $0800-$0FFF"},
/* hu */ {IDCLS_DISABLE_RAM_MAPPING_IN_0800_HU, "$0800-$0FFF RAM lekpzs tiltsa"},
/* it */ {IDCLS_DISABLE_RAM_MAPPING_IN_0800_IT, "Disattiva mappatura della RAM a $0800-$0FFF"},
/* ko */ {IDCLS_DISABLE_RAM_MAPPING_IN_0800_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_RAM_MAPPING_IN_0800_NL, "RAM op adres $0800-$0FFF uitschakelen"},
/* pl */ {IDCLS_DISABLE_RAM_MAPPING_IN_0800_PL, "Wycz mapowanie RAM w $0800-$0FFF"},
/* ru */ {IDCLS_DISABLE_RAM_MAPPING_IN_0800_RU, "Disable RAM mapping in $0800-$0FFF"},
/* sv */ {IDCLS_DISABLE_RAM_MAPPING_IN_0800_SV, "Inaktivera RAM-mappning p $0800-$0FFF"},
/* tr */ {IDCLS_DISABLE_RAM_MAPPING_IN_0800_TR, "$0800-$0FFF aralnda RAM eletirmeyi pasifletir"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_ENABLE_RAM_MAPPING_IN_1000,    N_("Enable RAM mapping in $1000-$1FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_RAM_MAPPING_IN_1000_DA, "Aktivr RAM-mappning p $1000-$1FFF"},
/* de */ {IDCLS_ENABLE_RAM_MAPPING_IN_1000_DE, "RAM Zuordnung in $1000-$1FFF aktivieren"},
/* es */ {IDCLS_ENABLE_RAM_MAPPING_IN_1000_ES, "Permitir mapeado RAM en $1000-$1FFF"},
/* fr */ {IDCLS_ENABLE_RAM_MAPPING_IN_1000_FR, "Activer le mappage RAM dans $1000-$1FFF"},
/* hu */ {IDCLS_ENABLE_RAM_MAPPING_IN_1000_HU, "$1000-$1FFF RAM lekpzs engedlyezse"},
/* it */ {IDCLS_ENABLE_RAM_MAPPING_IN_1000_IT, "Attiva mappatura della RAM a $1000-$1FFF"},
/* ko */ {IDCLS_ENABLE_RAM_MAPPING_IN_1000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_RAM_MAPPING_IN_1000_NL, "RAM op adres $1000-$1FFF inschakelen"},
/* pl */ {IDCLS_ENABLE_RAM_MAPPING_IN_1000_PL, "Wcz mapowanie RAM w $1000-$1FFF"},
/* ru */ {IDCLS_ENABLE_RAM_MAPPING_IN_1000_RU, "Enable RAM mapping in $1000-$1FFF"},
/* sv */ {IDCLS_ENABLE_RAM_MAPPING_IN_1000_SV, "Aktivera RAM-mappning p $1000-$1FFF"},
/* tr */ {IDCLS_ENABLE_RAM_MAPPING_IN_1000_TR, "$1000-$1FFF aralnda RAM eletirmeyi aktif et"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_DISABLE_RAM_MAPPING_IN_1000,    N_("Disable RAM mapping in $1000-$1FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_RAM_MAPPING_IN_1000_DA, "Deaktivr RAM-mappning p $1000-$1FFF"},
/* de */ {IDCLS_DISABLE_RAM_MAPPING_IN_1000_DE, "RAM Zuordnung in $1000-$1FFF deaktivieren"},
/* es */ {IDCLS_DISABLE_RAM_MAPPING_IN_1000_ES, "Deshabilitar mapeado RAM en $1000-$1FFF"},
/* fr */ {IDCLS_DISABLE_RAM_MAPPING_IN_1000_FR, "Dsactiver le mappage RAM dans $1000-$1FFF"},
/* hu */ {IDCLS_DISABLE_RAM_MAPPING_IN_1000_HU, "$1000-$1FFF RAM lekpzs tiltsa"},
/* it */ {IDCLS_DISABLE_RAM_MAPPING_IN_1000_IT, "Disattiva mappatura della RAM a $1000-$1FFF"},
/* ko */ {IDCLS_DISABLE_RAM_MAPPING_IN_1000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_RAM_MAPPING_IN_1000_NL, "RAM op adres $1000-$1FFF uitschakelen"},
/* pl */ {IDCLS_DISABLE_RAM_MAPPING_IN_1000_PL, "Wycz mapowanie RAM w $1000-$1FFF"},
/* ru */ {IDCLS_DISABLE_RAM_MAPPING_IN_1000_RU, "Disable RAM mapping in $1000-$1FFF"},
/* sv */ {IDCLS_DISABLE_RAM_MAPPING_IN_1000_SV, "Inaktivera RAM-mappning p $1000-$1FFF"},
/* tr */ {IDCLS_DISABLE_RAM_MAPPING_IN_1000_TR, "$1000-$1FFF aralnda RAM eletirmeyi pasifletir"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_ENABLE_RAM_MAPPING_IN_2000,    N_("Enable RAM mapping in $2000-$3FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_RAM_MAPPING_IN_2000_DA, "Aktivr RAM-mappning p $2000-$3FFF"},
/* de */ {IDCLS_ENABLE_RAM_MAPPING_IN_2000_DE, "RAM Zuordnung in $2000-3FFF aktivieren"},
/* es */ {IDCLS_ENABLE_RAM_MAPPING_IN_2000_ES, "Permitir mapeado RAM en $2000-$3FFF"},
/* fr */ {IDCLS_ENABLE_RAM_MAPPING_IN_2000_FR, "Activer le mappage RAM dans $2000-$3FFF"},
/* hu */ {IDCLS_ENABLE_RAM_MAPPING_IN_2000_HU, "$2000-$3FFF RAM lekpzs engedlyezse"},
/* it */ {IDCLS_ENABLE_RAM_MAPPING_IN_2000_IT, "Attiva mappatura della RAM a $2000-$3FFF"},
/* ko */ {IDCLS_ENABLE_RAM_MAPPING_IN_2000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_RAM_MAPPING_IN_2000_NL, "RAM op adres $2000-$3FFF inschakelen"},
/* pl */ {IDCLS_ENABLE_RAM_MAPPING_IN_2000_PL, "Wcz mapowanie RAM w $2000-$3FFF"},
/* ru */ {IDCLS_ENABLE_RAM_MAPPING_IN_2000_RU, "Enable RAM mapping in $2000-$3FFF"},
/* sv */ {IDCLS_ENABLE_RAM_MAPPING_IN_2000_SV, "Aktivera RAM-mappning p $2000-$3FFF"},
/* tr */ {IDCLS_ENABLE_RAM_MAPPING_IN_2000_TR, "$2000-$3FFF aralnda RAM eletirmeyi aktif et"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_DISABLE_RAM_MAPPING_IN_2000,    N_("Disable RAM mapping in $2000-$3FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_RAM_MAPPING_IN_2000_DA, "Deaktivr RAM-mappning p $2000-$3FFF"},
/* de */ {IDCLS_DISABLE_RAM_MAPPING_IN_2000_DE, "RAM Zuordnung in $2000-$3FFF deaktivieren"},
/* es */ {IDCLS_DISABLE_RAM_MAPPING_IN_2000_ES, "Deshabilitar mapeado RAM en $2000-$3FFF"},
/* fr */ {IDCLS_DISABLE_RAM_MAPPING_IN_2000_FR, "Dsactiver le mappage RAM dans $2000-$3FFF"},
/* hu */ {IDCLS_DISABLE_RAM_MAPPING_IN_2000_HU, "$2000-$3FFF RAM lekpzs tiltsa"},
/* it */ {IDCLS_DISABLE_RAM_MAPPING_IN_2000_IT, "Disattiva mappatura della RAM a $2000-$3FFF"},
/* ko */ {IDCLS_DISABLE_RAM_MAPPING_IN_2000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_RAM_MAPPING_IN_2000_NL, "RAM op adres $2000-$3FFF uitschakelen"},
/* pl */ {IDCLS_DISABLE_RAM_MAPPING_IN_2000_PL, "Wycz mapowanie RAM w $2000-$3FFF"},
/* ru */ {IDCLS_DISABLE_RAM_MAPPING_IN_2000_RU, "Disable RAM mapping in $2000-$3FFF"},
/* sv */ {IDCLS_DISABLE_RAM_MAPPING_IN_2000_SV, "Inaktivera RAM-mappning p $2000-$3FFF"},
/* tr */ {IDCLS_DISABLE_RAM_MAPPING_IN_2000_TR, "$2000-$3FFF aralnda RAM eletirmeyi pasifletir"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_ENABLE_RAM_MAPPING_IN_4000,    N_("Enable RAM mapping in $4000-$5FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_RAM_MAPPING_IN_4000_DA, "Aktivr RAM-mappning p $4000-$5FFF"},
/* de */ {IDCLS_ENABLE_RAM_MAPPING_IN_4000_DE, "RAM Zuordnung in $4000-$5FFF aktivieren"},
/* es */ {IDCLS_ENABLE_RAM_MAPPING_IN_4000_ES, "Permitir mapeado RAM en $4000-$5FFF"},
/* fr */ {IDCLS_ENABLE_RAM_MAPPING_IN_4000_FR, "Activer le mappage RAM dans $4000-$5FFF"},
/* hu */ {IDCLS_ENABLE_RAM_MAPPING_IN_4000_HU, "$4000-$5FFF RAM lekpzs engedlyezse"},
/* it */ {IDCLS_ENABLE_RAM_MAPPING_IN_4000_IT, "Attiva mappatura della RAM a $4000-$5FFF"},
/* ko */ {IDCLS_ENABLE_RAM_MAPPING_IN_4000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_RAM_MAPPING_IN_4000_NL, "RAM op adres $4000-$5FFF inschakelen"},
/* pl */ {IDCLS_ENABLE_RAM_MAPPING_IN_4000_PL, "Wcz mapowanie RAM w $4000-$5FFF"},
/* ru */ {IDCLS_ENABLE_RAM_MAPPING_IN_4000_RU, "Enable RAM mapping in $4000-$5FFF"},
/* sv */ {IDCLS_ENABLE_RAM_MAPPING_IN_4000_SV, "Aktivera RAM-mappning p $4000-$5FFF"},
/* tr */ {IDCLS_ENABLE_RAM_MAPPING_IN_4000_TR, "$4000-$5FFF aralnda RAM eletirmeyi aktif et"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_DISABLE_RAM_MAPPING_IN_4000,    N_("Disable RAM mapping in $4000-$5FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_RAM_MAPPING_IN_4000_DA, "Deaktivr RAM-mappning p $4000-$5FFF"},
/* de */ {IDCLS_DISABLE_RAM_MAPPING_IN_4000_DE, "RAM Zuordnung in $4000-$5FFF deaktivieren"},
/* es */ {IDCLS_DISABLE_RAM_MAPPING_IN_4000_ES, "Deshabilitar mapeado RAM en $4000-$5FFF"},
/* fr */ {IDCLS_DISABLE_RAM_MAPPING_IN_4000_FR, "Dsactiver le mappage RAM dans $4000-$5FFF"},
/* hu */ {IDCLS_DISABLE_RAM_MAPPING_IN_4000_HU, "$4000-$5FFF RAM lekpzs tiltsa"},
/* it */ {IDCLS_DISABLE_RAM_MAPPING_IN_4000_IT, "Disattiva mappatura della RAM a $4000-$5FFF"},
/* ko */ {IDCLS_DISABLE_RAM_MAPPING_IN_4000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_RAM_MAPPING_IN_4000_NL, "RAM op adres $4000-$5FFF uitschakelen"},
/* pl */ {IDCLS_DISABLE_RAM_MAPPING_IN_4000_PL, "Wycz mapowanie RAM w $4000-$5FFF"},
/* ru */ {IDCLS_DISABLE_RAM_MAPPING_IN_4000_RU, "Disable RAM mapping in $4000-$5FFF"},
/* sv */ {IDCLS_DISABLE_RAM_MAPPING_IN_4000_SV, "Inaktivera RAM-mappning p $4000-$5FFF"},
/* tr */ {IDCLS_DISABLE_RAM_MAPPING_IN_4000_TR, "$4000-$5FFF aralnda RAM eletirmeyi pasifletir"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_ENABLE_RAM_MAPPING_IN_6000,    N_("Enable RAM mapping in $6000-$7FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_RAM_MAPPING_IN_6000_DA, "Aktivr RAM-mappning p $6000-$7FFF"},
/* de */ {IDCLS_ENABLE_RAM_MAPPING_IN_6000_DE, "RAM Zuordnung in $6000-$7FFF aktivieren"},
/* es */ {IDCLS_ENABLE_RAM_MAPPING_IN_6000_ES, "Permitir mapeado RAM en $6000-$7FFF"},
/* fr */ {IDCLS_ENABLE_RAM_MAPPING_IN_6000_FR, "Activer le mappage RAM dans $6000-$7FFF"},
/* hu */ {IDCLS_ENABLE_RAM_MAPPING_IN_6000_HU, "$6000-$7FFF RAM lekpzs engedlyezse"},
/* it */ {IDCLS_ENABLE_RAM_MAPPING_IN_6000_IT, "Attiva mappatura della RAM a $6000-$7FFF"},
/* ko */ {IDCLS_ENABLE_RAM_MAPPING_IN_6000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_RAM_MAPPING_IN_6000_NL, "RAM op adres $6000-$7FFF inschakelen"},
/* pl */ {IDCLS_ENABLE_RAM_MAPPING_IN_6000_PL, "Wcz mapowanie RAM w $6000-$7FFF"},
/* ru */ {IDCLS_ENABLE_RAM_MAPPING_IN_6000_RU, "Enable RAM mapping in $6000-$7FFF"},
/* sv */ {IDCLS_ENABLE_RAM_MAPPING_IN_6000_SV, "Aktivera RAM-mappning p $6000-$7FFF"},
/* tr */ {IDCLS_ENABLE_RAM_MAPPING_IN_6000_TR, "$6000-$7FFF aralnda RAM eletirmeyi aktif et"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_DISABLE_RAM_MAPPING_IN_6000,    N_("Disable RAM mapping in $6000-$7FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_RAM_MAPPING_IN_6000_DA, "Deaktivr RAM-mappning p $6000-$7FFF"},
/* de */ {IDCLS_DISABLE_RAM_MAPPING_IN_6000_DE, "RAM Zuordnung in $6000-$7FFF deaktivieren"},
/* es */ {IDCLS_DISABLE_RAM_MAPPING_IN_6000_ES, "Deshabilitar mapeado RAM en $6000-$7FFF"},
/* fr */ {IDCLS_DISABLE_RAM_MAPPING_IN_6000_FR, "Dsactiver le mappage RAM dans $6000-$7FFF"},
/* hu */ {IDCLS_DISABLE_RAM_MAPPING_IN_6000_HU, "$6000-$7FFF RAM lekpzs tiltsa"},
/* it */ {IDCLS_DISABLE_RAM_MAPPING_IN_6000_IT, "Disattiva mappatura della RAM a $6000-$7FFF"},
/* ko */ {IDCLS_DISABLE_RAM_MAPPING_IN_6000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_RAM_MAPPING_IN_6000_NL, "RAM op adres $6000-$7FFF uitschakelen"},
/* pl */ {IDCLS_DISABLE_RAM_MAPPING_IN_6000_PL, "Wycz mapowanie RAM w $6000-$7FFF"},
/* ru */ {IDCLS_DISABLE_RAM_MAPPING_IN_6000_RU, "Disable RAM mapping in $6000-$7FFF"},
/* sv */ {IDCLS_DISABLE_RAM_MAPPING_IN_6000_SV, "Inaktivera RAM-mappning p $6000-$7FFF"},
/* tr */ {IDCLS_DISABLE_RAM_MAPPING_IN_6000_TR, "$6000-$7FFF aralnda RAM eletirmeyi pasifletir"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_ENABLE_RAM_MAPPING_IN_C000,    N_("Enable RAM mapping in $C000-$CFFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_RAM_MAPPING_IN_C000_DA, "Aktivr RAM-mappning p $C000-$CFFF"},
/* de */ {IDCLS_ENABLE_RAM_MAPPING_IN_C000_DE, "RAM Zuordnung in $C000-$CFFF aktivieren"},
/* es */ {IDCLS_ENABLE_RAM_MAPPING_IN_C000_ES, "Permitir mapeado RAM en $C000-$CFFF"},
/* fr */ {IDCLS_ENABLE_RAM_MAPPING_IN_C000_FR, "Activer le mappage RAM dans $C000-$CFFF"},
/* hu */ {IDCLS_ENABLE_RAM_MAPPING_IN_C000_HU, "$C000-$CFFF RAM lekpzs engedlyezse"},
/* it */ {IDCLS_ENABLE_RAM_MAPPING_IN_C000_IT, "Attiva mappatura della RAM a $C000-$CFFF"},
/* ko */ {IDCLS_ENABLE_RAM_MAPPING_IN_C000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_RAM_MAPPING_IN_C000_NL, "RAM op adres $C000-$CFFF inschakelen"},
/* pl */ {IDCLS_ENABLE_RAM_MAPPING_IN_C000_PL, "Wcz mapowanie RAM w $C000-$CFFF"},
/* ru */ {IDCLS_ENABLE_RAM_MAPPING_IN_C000_RU, "Enable RAM mapping in $C000-$CFFF"},
/* sv */ {IDCLS_ENABLE_RAM_MAPPING_IN_C000_SV, "Aktivera RAM-mappning p $C000-$CFFF"},
/* tr */ {IDCLS_ENABLE_RAM_MAPPING_IN_C000_TR, "$C000-$CFFF aralnda RAM eletirmeyi aktif et"},
#endif

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_DISABLE_RAM_MAPPING_IN_C000,    N_("Disable RAM mapping in $C000-$CFFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_RAM_MAPPING_IN_C000_DA, "Deaktivr RAM-mappning p $C000-$CFFF"},
/* de */ {IDCLS_DISABLE_RAM_MAPPING_IN_C000_DE, "RAM Zuordnung in $C000-$CFFF deaktivieren"},
/* es */ {IDCLS_DISABLE_RAM_MAPPING_IN_C000_ES, "Deshabilitar mapeado RAM en $C000-$CFFF"},
/* fr */ {IDCLS_DISABLE_RAM_MAPPING_IN_C000_FR, "Dsactiver le mappage RAM dans $C000-$CFFF"},
/* hu */ {IDCLS_DISABLE_RAM_MAPPING_IN_C000_HU, "$C000-$CFFF RAM lekpzs tiltsa"},
/* it */ {IDCLS_DISABLE_RAM_MAPPING_IN_C000_IT, "Disattiva mappatura della RAM a $C000-$CFFF"},
/* ko */ {IDCLS_DISABLE_RAM_MAPPING_IN_C000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_RAM_MAPPING_IN_C000_NL, "RAM op adres $C000-$CFFF uitschakelen"},
/* pl */ {IDCLS_DISABLE_RAM_MAPPING_IN_C000_PL, "Wycz mapowanie RAM w $C000-$CFFF"},
/* ru */ {IDCLS_DISABLE_RAM_MAPPING_IN_C000_RU, "Disable RAM mapping in $C000-$CFFF"},
/* sv */ {IDCLS_DISABLE_RAM_MAPPING_IN_C000_SV, "Inaktivera RAM-mappning p $C000-$CFFF"},
/* tr */ {IDCLS_DISABLE_RAM_MAPPING_IN_C000_TR, "$C000-$CFFF aralnda RAM eletirmeyi pasifletir"},
#endif

#ifdef COMMON_KBD
/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_KEYMAP_INDEX,    N_("Specify index of keymap file (0: UK business symbolic, 1: UK business positional, 2: Graphics symbolic, 3: Graphics positional, 4: German business symbolic, 5: German business positional)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_KEYMAP_INDEX_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_KEYMAP_INDEX_DE, "Index der Keymap Datei whlen (0: UK business symbolic, 1: UK business positional, 2: Graphics symbolic, 3: Graphics positional, 4: German business symbolic, 5: German business positional)"},
/* es */ {IDCLS_SPECIFY_KEYMAP_INDEX_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SPECIFY_KEYMAP_INDEX_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_KEYMAP_INDEX_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_KEYMAP_INDEX_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SPECIFY_KEYMAP_INDEX_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_KEYMAP_INDEX_NL, "Geef index van het toetstoewijzingsbestand (0: UK business symbolisch, 1: UK business positioneel, 2: grafisch symbolisch, 3: grafisch positioneel, 4: Duits business symbolisch, 5: Duits business positioneel)"},
/* pl */ {IDCLS_SPECIFY_KEYMAP_INDEX_PL, "Podaj indeks ukadu klawiatury (0: UK biznesowa - symbol, 1: UK biznesowa - pozycja, 2: Graficzna - symbol, 3: Graficzna - pozycja, 4: Niemiecka biznesowa - symbol, 5: Niemiecka biznesowa - pozycja)"},
/* ru */ {IDCLS_SPECIFY_KEYMAP_INDEX_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_KEYMAP_INDEX_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_KEYMAP_INDEX_TR, ""},  /* fuzzy */
#endif

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME,    N_("Specify name of graphics keyboard symbolic keymap file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_DA, "Angiv fil for symbolsk tastaturemulering for \"graphics\"-tastatur"},
/* de */ {IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_DE, "Keymap Datei fr graphics keyboard symbolic whlen"},
/* es */ {IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_ES, "Especificar nombre fichero grficos teclado simblico"},
/* fr */ {IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_FR, "Spcifier le nom du fichier de mappage clavier symbolique"},
/* hu */ {IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_HU, "Adja meg a grafikus s szimbolikus billentyzet lekpzsi fjl nevt."},
/* it */ {IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_IT, "Specifica il nome del file della mappa simbolica della tastiera grafica"},
/* ko */ {IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_NL, "Geef de naam van het symbolisch toetstoewijzingsbestand voor het grafische toetsenbord"},
/* pl */ {IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_PL, "Okrel nazw pliku symbolicznego ukadu klawiatury graficznej"},
/* ru */ {IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_RU, "Specify name of graphics keyboard symbolic keymap file"},
/* sv */ {IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_SV, "Ange fil fr symbolisk tangentbordsemulering fr \"graphics\"-tangentbord"},
/* tr */ {IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_TR, "Grafik klavyesi sembolik tu haritas dosyasnn ismini belirt"},
#endif

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME,    N_("Specify name of graphics keyboard positional keymap file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_DA, "Angiv fil for positionsbestemt tastaturemulering for \"graphics\"-tastatur"},
/* de */ {IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_DE, "Keymap Datei fr graphics keyboard positional whlen"},
/* es */ {IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_ES, "Especificar nombre fichero grficos teclado posicional"},
/* fr */ {IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_FR, "Spcifier le nom du fichier de mappage clavier positionnel"},
/* hu */ {IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_HU, "Adja meg a grafikus s pozci szerinti billentyzet lekpzsi fjl nevt."},
/* it */ {IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_IT, "Specifica il nome del file della mappa posizionale della tastiera grafica"},
/* ko */ {IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_NL, "Geef de naam van het positioneel toetstoewijzingsbestand voor het grafische toetsenbord"},
/* pl */ {IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_PL, "Okrel nazw pliku pozycyjnego ukadu klawiatury graficznej"},
/* ru */ {IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_RU, "Specify name of graphics keyboard positional keymap file"},
/* sv */ {IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_SV, "Ange fil fr positionsriktig tangentbordsemulering fr \"graphics\"-tangentbord"},
/* tr */ {IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_TR, "Grafik klavyesi konumsal tu haritas dosyasnn ismini belirt"},
#endif

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME,    N_("Specify name of UK business keyboard symbolic keymap file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_DA, "Angiv fil for symbolsk tastaturemulering for Britisk \"business\"-tastatur"},
/* de */ {IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_DE, "Keymap Datei fr UK business keyboard symbolic whlen"},
/* es */ {IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_ES, "Especificar nombre fichero teclado UK business simblico"},
/* fr */ {IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_FR, "Spcifier le nom du fichier de mappage clavier symbolique UK"},
/* hu */ {IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_HU, "Adja meg az angol, hivatalos, szimbolikus billentyzet lekpzsi fjl nevt."},
/* it */ {IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_IT, "Specifica il nome del file della mappa simbolica della tastiera UK business"},
/* ko */ {IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_NL, "Geef de naam van het symbolisch toetstoewijzingsbestand voor het UK zakelijk toetsenbord"},
/* pl */ {IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_PL, "Okrel nazw pliku symbolicznego ukadu angielskiej klawiatury biznesowej"},
/* ru */ {IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_RU, "Specify name of UK business keyboard symbolic keymap file"},
/* sv */ {IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_SV, "Ange fil fr symbolisk tangentbordsemulering fr brittiskt \"business\"-tangentbord"},
/* tr */ {IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_TR, "UK business klavyesi sembolik tu haritas dosyasnn ismini belirt"},
#endif

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME,    N_("Specify name of UK business keyboard positional keymap file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_DA, "Angiv fil for positionsbestemt tastaturemulering for Britisk \"business\"-tastatur"},
/* de */ {IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_DE, "Keymap Datei fr UK business keyboard positional whlen"},
/* es */ {IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_ES, "Especificar nombre fichero teclado UK business posicional"},
/* fr */ {IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_FR, "Spcifier le nom du fichier de mappage clavier positionnel UK"},
/* hu */ {IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_HU, "Adja meg az angol, hivatalos, pozci szerinti billentyzet lekpzsi fjl nevt."},
/* it */ {IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_IT, "Specifica il nome del file della mappa posizionale della tastiera UK business"},
/* ko */ {IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_NL, "Geef de naam van het positioneel toetstoewijzingsbestand voor het UK zakelijk toetsenbord"},
/* pl */ {IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_PL, "Okrel nazw pliku pozycyjnego ukadu angielskiej klawiatury biznesowej"},
/* ru */ {IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_RU, "Specify name of UK business keyboard positional keymap file"},
/* sv */ {IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_SV, "Ange fil fr positionsriktig tangentbordsemulering fr brittiskt \"business\"-tangentbord"},
/* tr */ {IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_TR, "UK business klavyesi konumsal tu haritas dosyasnn ismini belirt"},
#endif

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME,    N_("Specify name of German business keyboard symbolic keymap file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_DA, "Angiv fil for symbolsk tastaturemulering for Tysk \"business\"-tastatur"},
/* de */ {IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_DE, "Keymap Datei fr German business keyboard symbolic whlen"},
/* es */ {IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_ES, "Especificar nombre fichero teclado Alemn business simblico"},
/* fr */ {IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_FR, "Spcifier le nom du fichier de mappage clavier symbolique allemand"},
/* hu */ {IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_HU, "Adja meg a nmet, hivatalos, szimbolikus billentyzet lekpzsi fjl nevt."},
/* it */ {IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_IT, "Specifica il nome del file della mappa simbolica della tastiera business tedesca"},
/* ko */ {IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_NL, "Geef de naam van het symbolisch toetstoewijzingsbestand voor het Duitse zakelijk toetsenbord"},
/* pl */ {IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_PL, "Okrel nazw pliku symbolicznego ukadu niemieckiej klawiatury biznesowej"},
/* ru */ {IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_RU, "Specify name of German business keyboard symbolic keymap file"},
/* sv */ {IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_SV, "Ange fil fr symbolisk tangentbordsemulering fr tyskt \"business\"-tangentbord"},
/* tr */ {IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_TR, "Alman business klavyesi sembolik tu haritas dosyasnn ismini belirt"},
#endif

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME,    N_("Specify name of German business keyboard positional keymap file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_DA, "Angiv fil for positionsbestemt tastaturemulering for Tysk \"business\"-tastatur"},
/* de */ {IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_DE, "Keymap Datei fr German business keyboard positional whlen"},
/* es */ {IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_ES, "Especificar nombre fichero teclado Alemn business posicional"},
/* fr */ {IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_FR, "Spcifier le nom du fichier de mappage clavier positionnel allemand"},
/* hu */ {IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_HU, "Adja meg a nmet, hivatalos, pozci szerinti billentyzet lekpzsi fjl nevt."},
/* it */ {IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_IT, "Specifica il nome del file della mappa posizionale della tastiera business tedesca"},
/* ko */ {IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_NL, "Geef de naam van het positioneel toetstoewijzingsbestand voor het Duitse zakelijk toetsenbord"},
/* pl */ {IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_PL, "Okrel nazw pliku pozycyjnego ukadu niemieckiej klawiatury biznesowej"},
/* ru */ {IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_RU, "Specify name of German business keyboard positional keymap file"},
/* sv */ {IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_SV, "Ange fil fr positionsriktig tangentbordsemulering fr tyskt \"business\"-tangentbord"},
/* tr */ {IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_TR, "Alman business klavyesi konumsal tu haritas dosyasnn ismini belirt"},
#endif
#endif

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_ENABLE_TRUE_DRIVE,    N_("Enable hardware-level emulation of disk drives")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_TRUE_DRIVE_DA, "Aktivr emulering af diskettedrev p hardware-niveau"},
/* de */ {IDCLS_ENABLE_TRUE_DRIVE_DE, "Hardware Emulation fr Disklaufwerke aktivieren"},
/* es */ {IDCLS_ENABLE_TRUE_DRIVE_ES, "Permitir Emulacin a nivel hardware unidades de disco"},
/* fr */ {IDCLS_ENABLE_TRUE_DRIVE_FR, "Activer l'mulation de disques au niveau physique"},
/* hu */ {IDCLS_ENABLE_TRUE_DRIVE_HU, "Lemezegysgek hardver szint emulcijnak engedlyezse"},
/* it */ {IDCLS_ENABLE_TRUE_DRIVE_IT, "Attiva emulazione hardware dei disk drive"},
/* ko */ {IDCLS_ENABLE_TRUE_DRIVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_TRUE_DRIVE_NL, "Hardwarematige emulatie van diskdrives inschakelen"},
/* pl */ {IDCLS_ENABLE_TRUE_DRIVE_PL, "Wcz sprztow emulacj stacji dyskw"},
/* ru */ {IDCLS_ENABLE_TRUE_DRIVE_RU, "Enable hardware-level emulation of disk drives"},
/* sv */ {IDCLS_ENABLE_TRUE_DRIVE_SV, "Aktivera emulering av diskettstationer p maskinvaruniv"},
/* tr */ {IDCLS_ENABLE_TRUE_DRIVE_TR, "Disk srclerinin donanm seviyesinde emlasyonunu aktif et"},
#endif

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_DISABLE_TRUE_DRIVE,    N_("Disable hardware-level emulation of disk drives")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_TRUE_DRIVE_DA, "Deaktivr emulering af diskettedrev p hardware-niveau"},
/* de */ {IDCLS_DISABLE_TRUE_DRIVE_DE, "Hardware Emulation fr Disklaufwerke deaktivieren"},
/* es */ {IDCLS_DISABLE_TRUE_DRIVE_ES, "No permitir Emulacin a nivel hardware unidades de disco"},
/* fr */ {IDCLS_DISABLE_TRUE_DRIVE_FR, "Dsactiver l'mulation de disques au niveau physique"},
/* hu */ {IDCLS_DISABLE_TRUE_DRIVE_HU, "Lemezegysgek hardver szint emulcijnak tiltsa"},
/* it */ {IDCLS_DISABLE_TRUE_DRIVE_IT, "Disattiva emulazione hardware dei disk drive"},
/* ko */ {IDCLS_DISABLE_TRUE_DRIVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_TRUE_DRIVE_NL, "Hardwarematige emulatie van diskdrives uitschakelen"},
/* pl */ {IDCLS_DISABLE_TRUE_DRIVE_PL, "Wycz sprztow emulacj stacji dyskw"},
/* ru */ {IDCLS_DISABLE_TRUE_DRIVE_RU, "Disable hardware-level emulation of disk drives"},
/* sv */ {IDCLS_DISABLE_TRUE_DRIVE_SV, "Inaktivera emulering av diskettstationer p maskinvaruniv"},
/* tr */ {IDCLS_DISABLE_TRUE_DRIVE_TR, "Disk srclerinin donanm seviyesinde emlasyonunu pasifletir"},
#endif

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DRIVE_SOUND,    N_("Enable sound emulation of disk drives")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_DRIVE_SOUND_DA, "Aktivr emulering af lyd for diskettedrev"},
/* de */ {IDCLS_ENABLE_DRIVE_SOUND_DE, "Sound Emulation fr Disklaufwerke aktivieren"},
/* es */ {IDCLS_ENABLE_DRIVE_SOUND_ES, "Permitir emulacin de sonido en unidad de discos"},
/* fr */ {IDCLS_ENABLE_DRIVE_SOUND_FR, "Activer l'mulation du son des lecteurs de disque"},
/* hu */ {IDCLS_ENABLE_DRIVE_SOUND_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_DRIVE_SOUND_IT, "Attiva emulazione audio dei disk drive"},
/* ko */ {IDCLS_ENABLE_DRIVE_SOUND_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_DRIVE_SOUND_NL, "Geluidsemulatie van diskdrives inschakelen"},
/* pl */ {IDCLS_ENABLE_DRIVE_SOUND_PL, "Wcz emulacj odgosw stacji dyskw"},
/* ru */ {IDCLS_ENABLE_DRIVE_SOUND_RU, "Enable sound emulation of disk drives"},
/* sv */ {IDCLS_ENABLE_DRIVE_SOUND_SV, "Aktivera ljudemulering fr diskettstationer"},
/* tr */ {IDCLS_ENABLE_DRIVE_SOUND_TR, "Disk srclerinin ses emlasyonunu aktif et"},
#endif

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DRIVE_SOUND,    N_("Disable sound emulation of disk drives")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_DRIVE_SOUND_DA, "Deaktivr emulering af lyd for diskettedrev"},
/* de */ {IDCLS_DISABLE_DRIVE_SOUND_DE, "Sound Emulation fr Disklaufwerke deaktivieren"},
/* es */ {IDCLS_DISABLE_DRIVE_SOUND_ES, "Inhabilitar emulacin de sonido wn unidad de discos"},
/* fr */ {IDCLS_DISABLE_DRIVE_SOUND_FR, "Dsactiver l'mulation du son des lecteurs disque"},
/* hu */ {IDCLS_DISABLE_DRIVE_SOUND_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_DRIVE_SOUND_IT, "Disattiva emulazione audio dei disk drive"},
/* ko */ {IDCLS_DISABLE_DRIVE_SOUND_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_DRIVE_SOUND_NL, "Geluidsemulatie van diskdrives uitschakelen"},
/* pl */ {IDCLS_DISABLE_DRIVE_SOUND_PL, "Wycz emulacj odgosw stacji dyskw"},
/* ru */ {IDCLS_DISABLE_DRIVE_SOUND_RU, "Disable sound emulation of disk drives"},
/* sv */ {IDCLS_DISABLE_DRIVE_SOUND_SV, "Inaktivera ljudemulering fr diskettstationer"},
/* tr */ {IDCLS_DISABLE_DRIVE_SOUND_TR, "Disk srclerinin ses emlasyonunu pasifletir"},
#endif

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_SET_DRIVE_SOUND_VOLUME,    N_("Set volume for disk drive sound emulation (0-4000)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_DRIVE_SOUND_VOLUME_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_DRIVE_SOUND_VOLUME_DE, "Lautstrke fr Floppygerusch Emulation (0-4000)"},
/* es */ {IDCLS_SET_DRIVE_SOUND_VOLUME_ES, "Ajustar volumen para emulacin sonido disquetera (0-400)"},
/* fr */ {IDCLS_SET_DRIVE_SOUND_VOLUME_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_DRIVE_SOUND_VOLUME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_DRIVE_SOUND_VOLUME_IT, "Imposta il volume per l'emulazione audio del disk drive (0-4000)"},
/* ko */ {IDCLS_SET_DRIVE_SOUND_VOLUME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_DRIVE_SOUND_VOLUME_NL, "Stel het volume in van de diskdrive geluidemulatie (0-4000)"},
/* pl */ {IDCLS_SET_DRIVE_SOUND_VOLUME_PL, "Ustaw gono emulacji odgosw stacji dyskw (0-4000)"},
/* ru */ {IDCLS_SET_DRIVE_SOUND_VOLUME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_DRIVE_SOUND_VOLUME_SV, "Vlj volym fr ljudemulering fr diskettstation (0-4000)"},
/* tr */ {IDCLS_SET_DRIVE_SOUND_VOLUME_TR, ""},  /* fuzzy */
#endif

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_P_VOLUME,    N_("<Volume>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_VOLUME_DA, "<Lydstyrke>"},
/* de */ {IDCLS_P_VOLUME_DE, "<Lautstrke>"},
/* es */ {IDCLS_P_VOLUME_ES, "<Volumen>"},
/* fr */ {IDCLS_P_VOLUME_FR, "<Volume>"},
/* hu */ {IDCLS_P_VOLUME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_VOLUME_IT, "<Volume>"},
/* ko */ {IDCLS_P_VOLUME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_VOLUME_NL, "<Volume>"},
/* pl */ {IDCLS_P_VOLUME_PL, "<Gono>"},
/* ru */ {IDCLS_P_VOLUME_RU, "<Volume>"},
/* sv */ {IDCLS_P_VOLUME_SV, "<Volym>"},
/* tr */ {IDCLS_P_VOLUME_TR, "<Ses Dzeyi>"},
#endif

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_P_RPM,    N_("<RPM>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_RPM_DA, ""},  /* fuzzy */
/* de */ {IDCLS_P_RPM_DE, "<RPM>"},
/* es */ {IDCLS_P_RPM_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_P_RPM_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_P_RPM_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_RPM_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_P_RPM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_RPM_NL, "<RPM>"},
/* pl */ {IDCLS_P_RPM_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_P_RPM_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_P_RPM_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_P_RPM_TR, ""},  /* fuzzy */
#endif

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_P_WOBBLE,    N_("<Wobble>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_WOBBLE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_P_WOBBLE_DE, "<Schwankung>"},
/* es */ {IDCLS_P_WOBBLE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_P_WOBBLE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_P_WOBBLE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_WOBBLE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_P_WOBBLE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_WOBBLE_NL, "<Wiebel>"},
/* pl */ {IDCLS_P_WOBBLE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_P_WOBBLE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_P_WOBBLE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_P_WOBBLE_TR, ""},  /* fuzzy */
#endif

/* drive/drive-cmdline-options.c, drive/iec/plus4exp/plus4exp-cmdline-options.c,
   drive/iec/c64exp/c64exp-cmdline-options.c, printerdrv/interface-serial.c,
   attach.c, lightpen.c, c128/functionrom.c, userport/userport_joystick.c,
   c64/c64gluelogic.c, c64/cart/sfx_soundexpander.c */
/* en */ {IDCLS_P_TYPE,    N_("<Type>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_TYPE_DA, "<Type>"},
/* de */ {IDCLS_P_TYPE_DE, "<Typ>"},
/* es */ {IDCLS_P_TYPE_ES, "<Tipo>"},
/* fr */ {IDCLS_P_TYPE_FR, "<type>"},
/* hu */ {IDCLS_P_TYPE_HU, "<Tpus>"},
/* it */ {IDCLS_P_TYPE_IT, "<Tipo>"},
/* ko */ {IDCLS_P_TYPE_KO, "<>"},
/* nl */ {IDCLS_P_TYPE_NL, "<Soort>"},
/* pl */ {IDCLS_P_TYPE_PL, "<Typ>"},
/* ru */ {IDCLS_P_TYPE_RU, "<Type>"},
/* sv */ {IDCLS_P_TYPE_SV, "<Typ>"},
/* tr */ {IDCLS_P_TYPE_TR, "<Tip>"},
#endif

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_SET_DRIVE_TYPE,    N_("Set drive type (0: no drive")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_DRIVE_TYPE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_DRIVE_TYPE_DE, "Setze Laufwerkstyp (0: kein Laufwerk"},
/* es */ {IDCLS_SET_DRIVE_TYPE_ES, "Seleccionar tipo unidad disco (0: sin unidad disco)"},
/* fr */ {IDCLS_SET_DRIVE_TYPE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_DRIVE_TYPE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_DRIVE_TYPE_IT, "Imposta tipo drive (0: nessun drive"},
/* ko */ {IDCLS_SET_DRIVE_TYPE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_DRIVE_TYPE_NL, "Stel drive soort in (0: geen drive"},
/* pl */ {IDCLS_SET_DRIVE_TYPE_PL, "Ustaw typ stacji (0: brak stacji"},
/* ru */ {IDCLS_SET_DRIVE_TYPE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_DRIVE_TYPE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_DRIVE_TYPE_TR, ""},  /* fuzzy */
#endif

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_SET_DRIVE_RPM,    N_("Set drive rpm (30000 = 300rpm)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_DRIVE_RPM_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_DRIVE_RPM_DE, "Setze Laufwerk RPM (30000 = 300rpm)"},
/* es */ {IDCLS_SET_DRIVE_RPM_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SET_DRIVE_RPM_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_DRIVE_RPM_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_DRIVE_RPM_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SET_DRIVE_RPM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_DRIVE_RPM_NL, "Stel drive rpm in (30000 = 300rpm)"},
/* pl */ {IDCLS_SET_DRIVE_RPM_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_SET_DRIVE_RPM_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_DRIVE_RPM_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_DRIVE_RPM_TR, ""},  /* fuzzy */
#endif

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_SET_DRIVE_WOBBLE,    N_("Set drive wobble (100 = +/-0.5rpm)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_DRIVE_WOBBLE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_DRIVE_WOBBLE_DE, "Setze Laufwaerkschwankung (100 = +/-0.5rpm)"},
/* es */ {IDCLS_SET_DRIVE_WOBBLE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SET_DRIVE_WOBBLE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_DRIVE_WOBBLE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_DRIVE_WOBBLE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SET_DRIVE_WOBBLE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_DRIVE_WOBBLE_NL, "Stel drive wiebel in (100 = +/-0.5rpm)"},
/* pl */ {IDCLS_SET_DRIVE_WOBBLE_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_SET_DRIVE_WOBBLE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_DRIVE_WOBBLE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_DRIVE_WOBBLE_TR, ""},  /* fuzzy */
#endif

/* drive/drive-cmdline-options.c,
   drive/iec/iec-cmdline-options.c,
   gfxoutputdrv/doodledrv.c */
/* en */ {IDCLS_P_METHOD,    N_("<method>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_METHOD_DA, "<metode>"},
/* de */ {IDCLS_P_METHOD_DE, "<Methode>"},
/* es */ {IDCLS_P_METHOD_ES, "<mtodo>"},
/* fr */ {IDCLS_P_METHOD_FR, "<mthode>"},
/* hu */ {IDCLS_P_METHOD_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_METHOD_IT, "<metodo>"},
/* ko */ {IDCLS_P_METHOD_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_METHOD_NL, "<methode>"},
/* pl */ {IDCLS_P_METHOD_PL, "<metoda>"},
/* ru */ {IDCLS_P_METHOD_RU, "<method>"},
/* sv */ {IDCLS_P_METHOD_SV, "<metod>"},
/* tr */ {IDCLS_P_METHOD_TR, "<metod>"},
#endif

/* gfxoutputdrv/doodledrv.c */
/* en */ {IDCLS_P_COLOR,    N_("<color>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_COLOR_DA, "<farve>"},
/* de */ {IDCLS_P_COLOR_DE, "<Farbe>"},
/* es */ {IDCLS_P_COLOR_ES, "<color>"},
/* fr */ {IDCLS_P_COLOR_FR, "<couleur>"},
/* hu */ {IDCLS_P_COLOR_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_COLOR_IT, "<colore>"},
/* ko */ {IDCLS_P_COLOR_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_COLOR_NL, "<kleur>"},
/* pl */ {IDCLS_P_COLOR_PL, "<kolor>"},
/* ru */ {IDCLS_P_COLOR_RU, "<>"},
/* sv */ {IDCLS_P_COLOR_SV, "<frg>"},
/* tr */ {IDCLS_P_COLOR_TR, "<renk>"},
#endif

/* gfxoutputdrv/doodledrv.c, gfxoutputdrv/koaladrv.c */
/* en */ {IDCLS_OVERSIZED_HANDLING,    N_("Select the way the oversized input should be handled, (0: scale down, 1: crop left top, 2: crop center top,  3: crop right top, 4: crop left center, 5: crop center, 6: crop right center, 7: crop left bottom, 8: crop center bottom, 9:  crop right bottom)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_OVERSIZED_HANDLING_DA, "Angiv hndtering af for stort input (0: skalr ned, 1: klip venstre top, 2: klip midt top,  3: klip hjre top, 4: klip venstre midt, 5: klip centreret, 6: klip hjre midt, 7: klip venstre bund, 8: klip midt bund, 9: klip hjre bund)"},
/* de */ {IDCLS_OVERSIZED_HANDLING_DE, "Whle, wie bergroer Input behandelt werden soll, (0: skaliere, 1: schneide links oben, 2: schneide mitte oben,  3: schneide rechts oben, 4: schneide links mitte, 5: schneide mitte, 6: schneide rechts mitte, 7: schneide links unten, 8: schneide mitte unten, 9:  schneide rechts unten)"},
/* es */ {IDCLS_OVERSIZED_HANDLING_ES, "Seleccionar cmo se manejarn las entradas sobredimensionadas, (0: escalar, 1:recorte sup izq, 2:recorte sup centro, 3:recorte sup dcha, 4:recorte centro izq, 5:recorte centro, 6:recorte centro dcha, 7:recorte abajo izq, 8:recorte centro abajo, 9:recorte abajo dcha)"},
/* fr */ {IDCLS_OVERSIZED_HANDLING_FR, "Slectionner la faon de traiter les entres trop longues (0: rduire, 1-9: Rogner  partir du coin: 1: haut-gauche, 2: haut-centre, 3: haut-droite, 4: centre-gauche, 5: centre, 6: centre-droite, 7: bas-gauche, 8: bas-centre, 9: bas-droite)"},
/* hu */ {IDCLS_OVERSIZED_HANDLING_HU, ""},  /* fuzzy */
/* it */ {IDCLS_OVERSIZED_HANDLING_IT, "Seleziona come gestire il sovradimensionamento dell'input, (0: scale down, 1: ritaglia sinistra alto, 2: ritaglia centro alto,  3: ritaglia destra alto, 4: ritaglia sinistra centro, 5: ritaglia centro, 6: ritaglia destra centro, 7: ritaglia sinistra basso, 8: ritaglia centro basso, 9:  ritaglia destra basso)"},
/* ko */ {IDCLS_OVERSIZED_HANDLING_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_OVERSIZED_HANDLING_NL, "Selecteer de manier waarop de te grote invoer moet worden afgehandeld, (0: maak kleiner, 1: knip linker bovenkant, 2: knip midden bovenkant, 3: knip rechter bovenkant, 4: knip linker midden, 5: knip midden, 6: knip rechter midden, 7: knip linker onderkant, 8: knip midden onderkant, 9: knip rechter onderkant)"},
/* pl */ {IDCLS_OVERSIZED_HANDLING_PL, "Wybierz sposb, w jaki ma by obsugiwany za duy obraz, (0: zmniejszenie, 1: cicie z gry z lewej, 2: cicie z gry, 3: cicie z prawej z gry, 4: cicie z lewej, 5: cicie od rodka, 6: cicie z prawej, 7: cicie z lewej z dou, 8: cicie z dou, 9: cicie z prawej z dou)"},
/* ru */ {IDCLS_OVERSIZED_HANDLING_RU, "Select the way the oversized input should be handled, (0: scale down, 1: crop left top, 2: crop center top,  3: crop right top, 4: crop left center, 5: crop center, 6: crop right center, 7: crop left bottom, 8: crop center bottom, 9:  crop right bottom)"},
/* sv */ {IDCLS_OVERSIZED_HANDLING_SV, "Vlj hur fr stor indata skall hanteras, (0: skala ned, 1: visa vre vnstra, 2: visa vre mitten, 3: visa vre hgra, 4: visa vnstra mitten, 5: visa mitten, 6: visa hgra mitten, 7: visa nedre vnstra, 8: visa nedre mitten, 9: visa nedre hgre)"},
/* tr */ {IDCLS_OVERSIZED_HANDLING_TR, "Byk girdilerin ele alnma yntemini sein, (0: klt, 1: sol stten krp, 2: ortal stten krp,  3: sa stten krp, 4: soldan ortal krp, 5: ortadan krp, 6: sadan ortal krp, 7: sol alttan krp, 8: ortal alttan krp, 9:  sa alttan krp)"},
#endif

/* gfxoutputdrv/doodledrv.c, gfxoutputdrv/koaladrv.c */
/* en */ {IDCLS_UNDERSIZED_HANDLING,    N_("Select the way the undersized input should be handled, (0: scale up, 1: borderize)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_UNDERSIZED_HANDLING_DA, ""},  /* fuzzy */
/* de */ {IDCLS_UNDERSIZED_HANDLING_DE, "Wie soll ungengende Eingabe behandelt werden (0: skaliere, 1: borderize)"},
/* es */ {IDCLS_UNDERSIZED_HANDLING_ES, "Seleccionar cmo se manejar la entrada fuera de rango,  (0: scale up, 1: borderize)"},
/* fr */ {IDCLS_UNDERSIZED_HANDLING_FR, "Slectionner la faon de traiter les entre trop courtes, (0: agrandir, 1: ajouter bordure)"},
/* hu */ {IDCLS_UNDERSIZED_HANDLING_HU, ""},  /* fuzzy */
/* it */ {IDCLS_UNDERSIZED_HANDLING_IT, "Seleziona come gestire il sottodimensionamento dell'input, (0: scale up, 1: borderize)"},
/* ko */ {IDCLS_UNDERSIZED_HANDLING_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_UNDERSIZED_HANDLING_NL, "Selecteer de manier waarop de te kleine invoer moet worden afgehandeld, (0: maak groter, 1: maak border)"},
/* pl */ {IDCLS_UNDERSIZED_HANDLING_PL, "Wybierz sposb obsugi maego obrazu (0: skaluj, 1: dodaj ramk)"},
/* ru */ {IDCLS_UNDERSIZED_HANDLING_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_UNDERSIZED_HANDLING_SV, "Vlj hur fr liten indata skall hanteras (0: skala upp, 1: inramning)"},
/* tr */ {IDCLS_UNDERSIZED_HANDLING_TR, ""},  /* fuzzy */
#endif

/* gfxoutputdrv/doodledrv.c */
/* en */ {IDCLS_MULTICOLOR_HANDLING,    N_("Select the way the multicolor to hires should be handled, (0: b&w, 1: 2 colors, 2: 4 colors, 3: gray scale,  4: best cell colors)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_MULTICOLOR_HANDLING_DA, "Angiv mden multicolor til hjoplsning skal hndteres p, (0: sort/hvid, 1: 2 farver, 2: 4 farver, 3: grtoner,  4: bedste cellefarver)"},
/* de */ {IDCLS_MULTICOLOR_HANDLING_DE, "Whle, wie Multicolor zu Hochauflsung behandelte werden soll, (0: s&w, 1: 2 Farben, 2: 4 Farben, 4 Graustufen, 4: Beste Zellenfarben)"},
/* es */ {IDCLS_MULTICOLOR_HANDLING_ES, "Seleccionar cmo se manejarn el cambio multicolor-alta resolucin (0:ByN, 1:2 colores, 2:4 colores, 3:escala grises, 4:mejores colores)"},
/* fr */ {IDCLS_MULTICOLOR_HANDLING_FR, "Slectionner la faon de traiter multicolore  haute rsolution, (0: noir et blanc, 1: 2 couleurs, 2: 4 couleurs, 3: chelle de gris, 4: meilleures couleurs)"},
/* hu */ {IDCLS_MULTICOLOR_HANDLING_HU, ""},  /* fuzzy */
/* it */ {IDCLS_MULTICOLOR_HANDLING_IT, "Seleziona come gestire il multicolor in hires, (0: b&w, 1: 2 colori, 2: 4 colori, 3: scala di grigi,  4: migliori colori cella)"},
/* ko */ {IDCLS_MULTICOLOR_HANDLING_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_MULTICOLOR_HANDLING_NL, "Selecteer de manier waarop 'multicolor' naar 'hires' conversie moet worden afgehandeld, (0: zwart/wit, 1: 2 kleuren, 2: 4 kleuren, 3: grijs, 4: best mogelijke kleuren in de cel)"},
/* pl */ {IDCLS_MULTICOLOR_HANDLING_PL, "Wybiera sposb obsugi wielu kolorw w wysokiej rozdzielczoci (0: czarno-biay, 1: 2 kolory, 2: 4 kolory, 3: skala szaroci, 4: najlepsze kolory komrek)"},
/* ru */ {IDCLS_MULTICOLOR_HANDLING_RU, "Select the way the multicolor to hires should be handled, (0: b&w, 1: 2 colors, 2: 4 colors, 3: gray scale,  4: best cell colors)"},
/* sv */ {IDCLS_MULTICOLOR_HANDLING_SV, "Vlj hur flerfrgs-till-hgupplst skall hanteras, (0: svartvit, 1: 2 frger, 2: fyra frger, 3: grskala, 4: bsta cellfrger)"},
/* tr */ {IDCLS_MULTICOLOR_HANDLING_TR, "ok renkliden yksek znrle geiin ele alnma yntemini sein, (0: siyah&beyaz, 1: 2 renk, 2: 4 renk, 3: gri tonlu,  4: en iyi hcre renkleri)"},
#endif

/* gfxoutputdrv/doodledrv.c */
/* en */ {IDCLS_TED_LUM_HANDLING,    N_("Select the way the TED luminosity should be handled, (0: ignore, 1: dither)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_TED_LUM_HANDLING_DA, "Angiv mden TED-lysstyrker skal hndteres p (0: ignorr, 1: blanding)"},
/* de */ {IDCLS_TED_LUM_HANDLING_DE, "Whle, wie TED Leuchtstrke behandelt werden soll, (0: ignorieren, 1: dither)"},
/* es */ {IDCLS_TED_LUM_HANDLING_ES, "Seleccionar cmo se manejarn la luminosidad TED (0:ignorar, 1:dither)"},
/* fr */ {IDCLS_TED_LUM_HANDLING_FR, "Slectionner la faon de traiter la luminosit TED, (0: ignorer, 1: tramer)"},
/* hu */ {IDCLS_TED_LUM_HANDLING_HU, ""},  /* fuzzy */
/* it */ {IDCLS_TED_LUM_HANDLING_IT, "Seleziona come gestire la luminosit TED, (0: ignora, 1: dither)"},
/* ko */ {IDCLS_TED_LUM_HANDLING_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_TED_LUM_HANDLING_NL, "Selecteer de manier waarop de TED kleuren moeten worden afgehandeld, (0: negeren, 1: dither)"},
/* pl */ {IDCLS_TED_LUM_HANDLING_PL, "Wybr sposobu obsugi jaskrawoci TED (0: ignoruj, 1: ditheruj)"},
/* ru */ {IDCLS_TED_LUM_HANDLING_RU, "Select the way the TED luminosity should be handled, (0: ignore, 1: dither)"},
/* sv */ {IDCLS_TED_LUM_HANDLING_SV, "Vlj hur TED-luminositet skall hanteras, (0: ignorera, 1: frgutjmna)"},
/* tr */ {IDCLS_TED_LUM_HANDLING_TR, "TED lminozitesinin ele alnma yntemini sein, (0: yok say, 1: dither)"},
#endif

/* gfxoutputdrv/doodledrv.c */
/* en */ {IDCLS_CRTC_TEXT_COLOR,    N_("Select the CRTC text color (0: white, 1: amber, 2: green)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_CRTC_TEXT_COLOR_DA, "Vlg CRTC tekstfarve (0: hvid, 1: ravgul, 2: grn)"},
/* de */ {IDCLS_CRTC_TEXT_COLOR_DE, "Whle CRTC Textfarbe (0: wei, 1: Bernstein, 2: grn)"},
/* es */ {IDCLS_CRTC_TEXT_COLOR_ES, "Seleccionar color texto CRTC (0:blanco, 1:mbar, 2:verde)"},
/* fr */ {IDCLS_CRTC_TEXT_COLOR_FR, "Slectionner la couleur du texte CRTC (0: blanc, 1: ambre, 2: vert)"},
/* hu */ {IDCLS_CRTC_TEXT_COLOR_HU, ""},  /* fuzzy */
/* it */ {IDCLS_CRTC_TEXT_COLOR_IT, "Seleziona il colore del testo CRTC (0: bianco, 1: ambra, 2: verde)"},
/* ko */ {IDCLS_CRTC_TEXT_COLOR_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_CRTC_TEXT_COLOR_NL, "Selecteer de CRTC tekst kleur (0: wit, 1: amber, 2: groen)"},
/* pl */ {IDCLS_CRTC_TEXT_COLOR_PL, "Wybierz kolor tekstu CRTC (0: biay, 1: bursztynowy, 2: zielony)"},
/* ru */ {IDCLS_CRTC_TEXT_COLOR_RU, "Select the CRTC text color (0: white, 1: amber, 2: green)"},
/* sv */ {IDCLS_CRTC_TEXT_COLOR_SV, "Vlj CRTC-textfrg (0: vit, 1: gul, 2: grn)"},
/* tr */ {IDCLS_CRTC_TEXT_COLOR_TR, "CRTC yaz rengini sein (0: beyaz, 1: kehribar, 2: yeil)"},
#endif

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_SET_DRIVE_EXTENSION_POLICY,    N_("Set drive 40 track extension policy (0: never, 1: ask, 2: on access)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_DRIVE_EXTENSION_POLICY_DA, "Angiv drevets regel for 40-spors udviddelse (0: aldrig, 1: sprg, 2: ved tilgang)"},
/* de */ {IDCLS_SET_DRIVE_EXTENSION_POLICY_DE, "40 Spur Erweiterungsmethode (0: nie, 1: Rckfrage, 2: bei Bedarf)"},
/* es */ {IDCLS_SET_DRIVE_EXTENSION_POLICY_ES, "Seleccionar poltica unidad disco extensin 40 pistas (0:nunca, 1:preguntar, 2:al acceder)"},
/* fr */ {IDCLS_SET_DRIVE_EXTENSION_POLICY_FR, "Spcifier la rgle d'extention 40 pistes (0: jamais, 1: demander, 2:  l'accs)"},
/* hu */ {IDCLS_SET_DRIVE_EXTENSION_POLICY_HU, "Adja meg a 40 svra kiterjeszts terjeszts mdjt (0: soha, 1: krds, 2: hozzfrskor)"},
/* it */ {IDCLS_SET_DRIVE_EXTENSION_POLICY_IT, "Imposta la politica di estensione a 40 tracce del drive (0: mai, 1: a richiesta, 2: all'accesso)"},
/* ko */ {IDCLS_SET_DRIVE_EXTENSION_POLICY_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_DRIVE_EXTENSION_POLICY_NL, "Stel beleid voor 40-sporenuitbreiding drive in (0: nooit, 1: vraag, 2: bij toegang)"},
/* pl */ {IDCLS_SET_DRIVE_EXTENSION_POLICY_PL, "Okrel zasad rozszerzania do 40 cieek (0: nigdy, 1: pytaj, 2: przy dostpie)"},
/* ru */ {IDCLS_SET_DRIVE_EXTENSION_POLICY_RU, "Set drive 40 track extension policy (0: never, 1: ask, 2: on access)"},
/* sv */ {IDCLS_SET_DRIVE_EXTENSION_POLICY_SV, "Ange regel fr 40-sprsutkning (0: aldrig, 1: frga, 2: vid tkomst)"},
/* tr */ {IDCLS_SET_DRIVE_EXTENSION_POLICY_TR, "Src 40 track byme kuraln ayarla (0: asla, 1: sor, 2: eriildiinde)"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1540_DOS_ROM_NAME,    N_("Specify name of 1540 DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_1540_DOS_ROM_NAME_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_1540_DOS_ROM_NAME_DE, "Name der 1540 DOS ROM Imagedatei whlen"},
/* es */ {IDCLS_SPECIFY_1540_DOS_ROM_NAME_ES, "Especificar nombre imagen ROM de 1540 DOS "},
/* fr */ {IDCLS_SPECIFY_1540_DOS_ROM_NAME_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_1540_DOS_ROM_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_1540_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del DOS del 1540"},
/* ko */ {IDCLS_SPECIFY_1540_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_1540_DOS_ROM_NAME_NL, "Geef de naam van het 1540 DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_1540_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 1540"},
/* ru */ {IDCLS_SPECIFY_1540_DOS_ROM_NAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_1540_DOS_ROM_NAME_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_1540_DOS_ROM_NAME_TR, ""},  /* fuzzy */
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1541_DOS_ROM_NAME,    N_("Specify name of 1541 DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_1541_DOS_ROM_NAME_DA, "Angiv navn p 1541-DOS-ROM-image"},
/* de */ {IDCLS_SPECIFY_1541_DOS_ROM_NAME_DE, "Name der 1541 DOS ROM Imagedatei whlen"},
/* es */ {IDCLS_SPECIFY_1541_DOS_ROM_NAME_ES, "Especificar nombre imagen ROM de 1541 DOS "},
/* fr */ {IDCLS_SPECIFY_1541_DOS_ROM_NAME_FR, "Spcifier le nom de l'image 1541 DOS ROM"},
/* hu */ {IDCLS_SPECIFY_1541_DOS_ROM_NAME_HU, "Adja meg az 1541 DOS ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_1541_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del DOS del 1541"},
/* ko */ {IDCLS_SPECIFY_1541_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_1541_DOS_ROM_NAME_NL, "Geef de naam van het 1541 DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_1541_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 1541"},
/* ru */ {IDCLS_SPECIFY_1541_DOS_ROM_NAME_RU, "Specify name of 1541 DOS ROM image"},
/* sv */ {IDCLS_SPECIFY_1541_DOS_ROM_NAME_SV, "Ange namn p 1541-DOS-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_1541_DOS_ROM_NAME_TR, "1541 DOS ROM imajnn ismini belirt"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1541_II_DOS_ROM_NAME,    N_("Specify name of 1541-II DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_DA, "Angivn navn p 1541-II-DOS-ROM-image"},
/* de */ {IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_DE, "Name der 1541-II DOS ROM Imagedatei whlen"},
/* es */ {IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_ES, "Especificar nombre imagen ROM de 1541-II DOS"},
/* fr */ {IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_FR, "Spcifier le nom de l'image 1541-II DOS ROM"},
/* hu */ {IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_HU, "Adja meg az 1541-II DOS ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del DOS del 1541-II"},
/* ko */ {IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_NL, "Geef de naam van het 1541-II DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 1541-II"},
/* ru */ {IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_RU, "Specify name of 1541-II DOS ROM image"},
/* sv */ {IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_SV, "Ange namn p 1541-II-DOS-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_TR, "1541-II DOS ROM imajnn ismini belirt"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1570_DOS_ROM_NAME,    N_("Specify name of 1570 DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_1570_DOS_ROM_NAME_DA, "Angivn navn p 1570-DOS-ROM-image"},
/* de */ {IDCLS_SPECIFY_1570_DOS_ROM_NAME_DE, "Name der 1570 DOS ROM Imagedatei whlen"},
/* es */ {IDCLS_SPECIFY_1570_DOS_ROM_NAME_ES, "Especificar nombre imagen ROM de 1570 DOS"},
/* fr */ {IDCLS_SPECIFY_1570_DOS_ROM_NAME_FR, "Spcifier le nom de l'image 1570 DOS ROM"},
/* hu */ {IDCLS_SPECIFY_1570_DOS_ROM_NAME_HU, "Adja meg az 1570 DOS ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_1570_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del DOS del 1570"},
/* ko */ {IDCLS_SPECIFY_1570_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_1570_DOS_ROM_NAME_NL, "Geef de naam van het 1570 DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_1570_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 1570"},
/* ru */ {IDCLS_SPECIFY_1570_DOS_ROM_NAME_RU, "Specify name of 1570 DOS ROM image"},
/* sv */ {IDCLS_SPECIFY_1570_DOS_ROM_NAME_SV, "Ange namn p 1570-DOS-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_1570_DOS_ROM_NAME_TR, "1570 DOS ROM imajnn ismini belirt"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1571_DOS_ROM_NAME,    N_("Specify name of 1571 DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_1571_DOS_ROM_NAME_DA, "Angivn navn p 1571-DOS-ROM-image"},
/* de */ {IDCLS_SPECIFY_1571_DOS_ROM_NAME_DE, "Name der 1571 DOS ROM Imagedatei whlen"},
/* es */ {IDCLS_SPECIFY_1571_DOS_ROM_NAME_ES, "Especificar nombre imagen ROM de 1571 DOS "},
/* fr */ {IDCLS_SPECIFY_1571_DOS_ROM_NAME_FR, "Spcifier le nom de l'image 1571 DOS ROM"},
/* hu */ {IDCLS_SPECIFY_1571_DOS_ROM_NAME_HU, "Adja meg az 1571 DOS ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_1571_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del DOS del 1571"},
/* ko */ {IDCLS_SPECIFY_1571_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_1571_DOS_ROM_NAME_NL, "Geef de naam van het 1571 DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_1571_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 1571"},
/* ru */ {IDCLS_SPECIFY_1571_DOS_ROM_NAME_RU, "Specify name of 1571 DOS ROM image"},
/* sv */ {IDCLS_SPECIFY_1571_DOS_ROM_NAME_SV, "Ange namn p 1571-DOS-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_1571_DOS_ROM_NAME_TR, "1571 DOS ROM imajnn ismini belirt"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1581_DOS_ROM_NAME,    N_("Specify name of 1581 DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_1581_DOS_ROM_NAME_DA, "Angivn navn p 1581-DOS-ROM-image"},
/* de */ {IDCLS_SPECIFY_1581_DOS_ROM_NAME_DE, "Name der 1581 DOS ROM Imagedatei whlen"},
/* es */ {IDCLS_SPECIFY_1581_DOS_ROM_NAME_ES, "Especificar nombre imagen ROM de 1581 DOS "},
/* fr */ {IDCLS_SPECIFY_1581_DOS_ROM_NAME_FR, "Spcifier le nom de l'image 1581 DOS ROM"},
/* hu */ {IDCLS_SPECIFY_1581_DOS_ROM_NAME_HU, "Adja meg az 1581 DOS ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_1581_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del DOS del 1581"},
/* ko */ {IDCLS_SPECIFY_1581_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_1581_DOS_ROM_NAME_NL, "Geef de naam van het 1581 DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_1581_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 1581"},
/* ru */ {IDCLS_SPECIFY_1581_DOS_ROM_NAME_RU, "Specify name of 1581 DOS ROM image"},
/* sv */ {IDCLS_SPECIFY_1581_DOS_ROM_NAME_SV, "Ange namn p 1581-DOS-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_1581_DOS_ROM_NAME_TR, "1581 DOS ROM imajnn ismini belirt"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_2000_DOS_ROM_NAME,    N_("Specify name of 2000 DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_2000_DOS_ROM_NAME_DA, "Angiv navn p 2000-DOS-ROM-image"},
/* de */ {IDCLS_SPECIFY_2000_DOS_ROM_NAME_DE, "Name der 2000 DOS ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_2000_DOS_ROM_NAME_ES, "Especificar nombre imagen 2000 DOS ROM"},
/* fr */ {IDCLS_SPECIFY_2000_DOS_ROM_NAME_FR, "Spcifier le nom de l'image 2000 DOS ROM"},
/* hu */ {IDCLS_SPECIFY_2000_DOS_ROM_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_2000_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del 2000 DOS"},
/* ko */ {IDCLS_SPECIFY_2000_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_2000_DOS_ROM_NAME_NL, "Geef de naam van het 2000 DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_2000_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 2000"},
/* ru */ {IDCLS_SPECIFY_2000_DOS_ROM_NAME_RU, "Specify name of 2000 DOS ROM image"},
/* sv */ {IDCLS_SPECIFY_2000_DOS_ROM_NAME_SV, "Ange namn p 2000-DOS-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_2000_DOS_ROM_NAME_TR, "2000 DOS ROM imaj ismini belirt"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_4000_DOS_ROM_NAME,    N_("Specify name of 4000 DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_4000_DOS_ROM_NAME_DA, "Angiv navn p 4000-DOS-ROM-image"},
/* de */ {IDCLS_SPECIFY_4000_DOS_ROM_NAME_DE, "Name der 4000 DOS ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_4000_DOS_ROM_NAME_ES, "Especificar nombre imagen 4000 DOS ROM"},
/* fr */ {IDCLS_SPECIFY_4000_DOS_ROM_NAME_FR, "Spcifier le nom de l'image 4000 DOS ROM"},
/* hu */ {IDCLS_SPECIFY_4000_DOS_ROM_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_4000_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del 4000 DOS"},
/* ko */ {IDCLS_SPECIFY_4000_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_4000_DOS_ROM_NAME_NL, "Geef de naam van het 4000 DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_4000_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 4000"},
/* ru */ {IDCLS_SPECIFY_4000_DOS_ROM_NAME_RU, "Specify name of 4000 DOS ROM image"},
/* sv */ {IDCLS_SPECIFY_4000_DOS_ROM_NAME_SV, "Ange namn p 4000-DOS-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_4000_DOS_ROM_NAME_TR, "4000 DOS ROM imaj ismini belirt"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SET_IDLE_METHOD,    N_("Set drive idling method (0: no traps, 1: skip cycles, 2: trap idle)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_IDLE_METHOD_DA, "Vlg tomgangsmetode for diskettedrev (0: ingen traps, 1: spring over cykler, 2: trap ledig)"},
/* de */ {IDCLS_SET_IDLE_METHOD_DE, "Laufwerks idling Methode (0: kein Traps, 1: Zyklen verwerfen, 2: trap idle)"},
/* es */ {IDCLS_SET_IDLE_METHOD_ES, "Seleccionar mtodo tiempo inactivo (0: sin intercepcin, 1:saltar ciclos, 2:interceptar tiempos inactivos)"},
/* fr */ {IDCLS_SET_IDLE_METHOD_FR, "Spcifier la mthode d'idle (0: pas de traps, 1: sauter des cycles, 2: trap idle)"},
/* hu */ {IDCLS_SET_IDLE_METHOD_HU, "Lemezegysg resjrsi mdja (0: folytonos emulci, 1: ciklusok kihagysa, 2: res DOS ciklusok kihagysa)"},
/* it */ {IDCLS_SET_IDLE_METHOD_IT, "Imposta il metodo per rilevare l'inattivit del drive (0: non rilevare, 1: salta cicli, 2: rileva inattivit)"},
/* ko */ {IDCLS_SET_IDLE_METHOD_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_IDLE_METHOD_NL, "Stel de drive idlemethode in (0: geen traps, 1: sla cycli over, 2: trap idle)"},
/* pl */ {IDCLS_SET_IDLE_METHOD_PL, "Okrel metod bezczynnoci napdu (0: no traps, 1: opuszczaj cykle, 2: trap idle)"},
/* ru */ {IDCLS_SET_IDLE_METHOD_RU, "Set drive idling method (0: no traps, 1: skip cycles, 2: trap idle)"},
/* sv */ {IDCLS_SET_IDLE_METHOD_SV, "Stll in vntemetod fr diskettstation (0: fnta inge, 1: hoppa cykler, 2: fnga vntan)"},
/* tr */ {IDCLS_SET_IDLE_METHOD_TR, "Src boa vakit geirme metodunu ayarlayn (0: trap yok, 1: cyclelar atla, 2: trap boa vakit geirme)"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DRIVE_RTC_SAVE,    N_("Enable saving of FD2000/4000 RTC data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_DRIVE_RTC_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_DRIVE_RTC_SAVE_DE, "FD2000/4000 RTC Daten bei nderung speichern."},
/* es */ {IDCLS_ENABLE_DRIVE_RTC_SAVE_ES, "Permitir grabacin de datos cuando cambien de  FD2000/4000 RTC."},
/* fr */ {IDCLS_ENABLE_DRIVE_RTC_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_DRIVE_RTC_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_DRIVE_RTC_SAVE_IT, "Attiva il salvataggio dei dati RTC del FD2000/4000 alla modifica."},
/* ko */ {IDCLS_ENABLE_DRIVE_RTC_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_DRIVE_RTC_SAVE_NL, "Opslaan van de FD2000/4000 RTC gegevens bij wijziging inschakelen."},
/* pl */ {IDCLS_ENABLE_DRIVE_RTC_SAVE_PL, "Zapisuj dane zegara czasu rzeczywistego FD2000/4000 przy zmianie"},
/* ru */ {IDCLS_ENABLE_DRIVE_RTC_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_DRIVE_RTC_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_DRIVE_RTC_SAVE_TR, ""},  /* fuzzy */
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DRIVE_RTC_SAVE,    N_("Disable saving of FD2000/4000 RTC data when changed.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_DRIVE_RTC_SAVE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_DRIVE_RTC_SAVE_DE, "FD2000/4000 RTC Daten bei nderung nicht speichern."},
/* es */ {IDCLS_DISABLE_DRIVE_RTC_SAVE_ES, "Deshabilitar grabacin de datos cuando cambien de  FD2000/4000 RTC."},
/* fr */ {IDCLS_DISABLE_DRIVE_RTC_SAVE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_DRIVE_RTC_SAVE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_DRIVE_RTC_SAVE_IT, "Disattiva il salvataggio dei dati RTC del FD2000/4000 alla modifica."},
/* ko */ {IDCLS_DISABLE_DRIVE_RTC_SAVE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_DRIVE_RTC_SAVE_NL, "Opslaan van de FD2000/4000 RTC gegevens bij wijziging uitschakelen."},
/* pl */ {IDCLS_DISABLE_DRIVE_RTC_SAVE_PL, "Nie zapisuj danych zegara czasu rzeczywistego FD2000/4000 przy zmianie"},
/* ru */ {IDCLS_DISABLE_DRIVE_RTC_SAVE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_DRIVE_RTC_SAVE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_DRIVE_RTC_SAVE_TR, ""},  /* fuzzy */
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DRIVE_RAM_2000,    N_("Enable 8KB RAM expansion at $2000-$3FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_DRIVE_RAM_2000_DA, "Aktivr 8kB RAM-udviddelse p $2000-$3FFF"},
/* de */ {IDCLS_ENABLE_DRIVE_RAM_2000_DE, "8KB RAM Erweiterung bei $2000-3fff aktivieren"},
/* es */ {IDCLS_ENABLE_DRIVE_RAM_2000_ES, "Permitir expansin RAM de 8KB en $2000-$3FFF"},
/* fr */ {IDCLS_ENABLE_DRIVE_RAM_2000_FR, "Activer l'exansion de 8KB RAM  $2000-$3FFF"},
/* hu */ {IDCLS_ENABLE_DRIVE_RAM_2000_HU, "8KB RAM kiterjeszs engedlyezse a $2000-$3FFF cmen"},
/* it */ {IDCLS_ENABLE_DRIVE_RAM_2000_IT, "Attiva l'espansione di RAM di 8KB a $2000-$3FFF"},
/* ko */ {IDCLS_ENABLE_DRIVE_RAM_2000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_DRIVE_RAM_2000_NL, "8KB RAM uitbreiding op adres $2000-$3FFF inschakelen"},
/* pl */ {IDCLS_ENABLE_DRIVE_RAM_2000_PL, "Wcz rozszerzenie 8KB RAM w $2000-$3FFF"},
/* ru */ {IDCLS_ENABLE_DRIVE_RAM_2000_RU, "Enable 8KB RAM expansion at $2000-$3FFF"},
/* sv */ {IDCLS_ENABLE_DRIVE_RAM_2000_SV, "Aktivera 8KB RAM-expansion p $2000-$3FFF"},
/* tr */ {IDCLS_ENABLE_DRIVE_RAM_2000_TR, "$2000-$3FFF arasnda 8KB RAM geniletmeyi aktif et"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DRIVE_RAM_2000,    N_("Disable 8KB RAM expansion at $2000-$3FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_DRIVE_RAM_2000_DA, "Deaktivr 8kB RAM-udviddelse p $2000-$3FFF"},
/* de */ {IDCLS_DISABLE_DRIVE_RAM_2000_DE, "8KB RAM Erweiterung bei $2000-3fff deaktivieren"},
/* es */ {IDCLS_DISABLE_DRIVE_RAM_2000_ES, "Deshabilitar expansin RAM de 8KB en $2000-$3FFF"},
/* fr */ {IDCLS_DISABLE_DRIVE_RAM_2000_FR, "Dsactiver l'exansion de 8KB RAM  $2000-$3FFF"},
/* hu */ {IDCLS_DISABLE_DRIVE_RAM_2000_HU, "8KB RAM kiterjeszs tiltsa a $2000-$3FFF cmen"},
/* it */ {IDCLS_DISABLE_DRIVE_RAM_2000_IT, "Disattiva l'espansione di RAM di 8KB a $2000-$3FFF"},
/* ko */ {IDCLS_DISABLE_DRIVE_RAM_2000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_DRIVE_RAM_2000_NL, "8KB RAM uitbreiding op adres $2000-$3FFF uitschakelen"},
/* pl */ {IDCLS_DISABLE_DRIVE_RAM_2000_PL, "Wycz rozszerzenie 8KB RAM w $2000-$3FFF"},
/* ru */ {IDCLS_DISABLE_DRIVE_RAM_2000_RU, "Disable 8KB RAM expansion at $2000-$3FFF"},
/* sv */ {IDCLS_DISABLE_DRIVE_RAM_2000_SV, "Inaktivera 8KB RAM-expansion p $2000-$3FFF"},
/* tr */ {IDCLS_DISABLE_DRIVE_RAM_2000_TR, "$2000-$3FFF arasnda 8KB RAM geniletmeyi pasifletir"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DRIVE_RAM_4000,    N_("Enable 8KB RAM expansion at $4000-$5FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_DRIVE_RAM_4000_DA, "Aktivr 8kB RAM-udviddelse p $4000-$5FFF"},
/* de */ {IDCLS_ENABLE_DRIVE_RAM_4000_DE, "8KB RAM Erweiterung bei $4000-5fff aktivieren"},
/* es */ {IDCLS_ENABLE_DRIVE_RAM_4000_ES, "Permitir expansin RAM de 8KB en $4000-$5FFF"},
/* fr */ {IDCLS_ENABLE_DRIVE_RAM_4000_FR, "Activer l'exansion de 8KB RAM  $4000-$5FFF"},
/* hu */ {IDCLS_ENABLE_DRIVE_RAM_4000_HU, "8KB RAM kiterjeszs engedlyezse a $4000-$5FFF cmen"},
/* it */ {IDCLS_ENABLE_DRIVE_RAM_4000_IT, "Attiva l'espansione di RAM di 8KB a $4000-$5FFF"},
/* ko */ {IDCLS_ENABLE_DRIVE_RAM_4000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_DRIVE_RAM_4000_NL, "8KB RAM uitbreiding op adres $4000-$5FFF inschakelen"},
/* pl */ {IDCLS_ENABLE_DRIVE_RAM_4000_PL, "Wcz rozszerzenie 8KB RAM w $4000-$5FFF"},
/* ru */ {IDCLS_ENABLE_DRIVE_RAM_4000_RU, "Enable 8KB RAM expansion at $4000-$5FFF"},
/* sv */ {IDCLS_ENABLE_DRIVE_RAM_4000_SV, "Aktivera 8KB RAM-expansion p $4000-$5FFF"},
/* tr */ {IDCLS_ENABLE_DRIVE_RAM_4000_TR, "$4000-$5FFF arasnda 8KB RAM geniletmeyi aktif et"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DRIVE_RAM_4000,    N_("Disable 8KB RAM expansion at $4000-$5FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_DRIVE_RAM_4000_DA, "Deaktivr 8kB RAM-udviddelse p $4000-$5FFF"},
/* de */ {IDCLS_DISABLE_DRIVE_RAM_4000_DE, "8KB RAM Erweiterung bei $4000-5fff deaktivieren"},
/* es */ {IDCLS_DISABLE_DRIVE_RAM_4000_ES, "Deshabilitar expansin RAM de 8KB en $4000-$5FFF"},
/* fr */ {IDCLS_DISABLE_DRIVE_RAM_4000_FR, "Dsactiver l'exansion de 8KB RAM  $4000-$5FFF"},
/* hu */ {IDCLS_DISABLE_DRIVE_RAM_4000_HU, "8KB RAM kiterjeszs tiltsa a $4000-$5FFF cmen"},
/* it */ {IDCLS_DISABLE_DRIVE_RAM_4000_IT, "Disattiva l'espansione di RAM di 8KB a $4000-$5FFF"},
/* ko */ {IDCLS_DISABLE_DRIVE_RAM_4000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_DRIVE_RAM_4000_NL, "8KB RAM uitbreiding op adres $4000-$5FFF uitschakelen"},
/* pl */ {IDCLS_DISABLE_DRIVE_RAM_4000_PL, "Wycz rozszerzenie 8KB RAM w $4000-$5FFF"},
/* ru */ {IDCLS_DISABLE_DRIVE_RAM_4000_RU, "Disable 8KB RAM expansion at $4000-$5FFF"},
/* sv */ {IDCLS_DISABLE_DRIVE_RAM_4000_SV, "Inaktivera 8KB RAM-expansion p $4000-$5FFF"},
/* tr */ {IDCLS_DISABLE_DRIVE_RAM_4000_TR, "$4000-$5FFF arasnda 8KB RAM geniletmeyi pasifletir"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DRIVE_RAM_6000,    N_("Enable 8KB RAM expansion at $6000-$7FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_DRIVE_RAM_6000_DA, "Aktivr 8kB RAM-udviddelse p $6000-$7FFF"},
/* de */ {IDCLS_ENABLE_DRIVE_RAM_6000_DE, "8KB RAM Erweiterung bei $6000-7fff aktivieren"},
/* es */ {IDCLS_ENABLE_DRIVE_RAM_6000_ES, "Permitir expansin RAM de 8KB en $6000-$7FFF"},
/* fr */ {IDCLS_ENABLE_DRIVE_RAM_6000_FR, "Activer l'exansion de 8KB RAM  $6000-$7FFF"},
/* hu */ {IDCLS_ENABLE_DRIVE_RAM_6000_HU, "8KB RAM kiterjeszs engedlyezse a $6000-$7FFF cmen"},
/* it */ {IDCLS_ENABLE_DRIVE_RAM_6000_IT, "Attiva l'espansione di RAM di 8KB a $6000-$7FFF"},
/* ko */ {IDCLS_ENABLE_DRIVE_RAM_6000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_DRIVE_RAM_6000_NL, "8KB RAM uitbreiding op adres $6000-$7FFF inschakelen"},
/* pl */ {IDCLS_ENABLE_DRIVE_RAM_6000_PL, "Wcz rozszerzenie 8KB RAM w $6000-$7FFF"},
/* ru */ {IDCLS_ENABLE_DRIVE_RAM_6000_RU, "Enable 8KB RAM expansion at $6000-$7FFF"},
/* sv */ {IDCLS_ENABLE_DRIVE_RAM_6000_SV, "Aktivera 8KB RAM-expansion p $6000-$7FFF"},
/* tr */ {IDCLS_ENABLE_DRIVE_RAM_6000_TR, "$6000-$7FFF arasnda 8KB RAM geniletmeyi aktif et"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DRIVE_RAM_6000,    N_("Disable 8KB RAM expansion at $6000-$7FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_DRIVE_RAM_6000_DA, "Deaktivr 8kB RAM-udviddelse p $6000-$7FFF"},
/* de */ {IDCLS_DISABLE_DRIVE_RAM_6000_DE, "8KB RAM Erweiterung bei $6000-7fff deaktivieren"},
/* es */ {IDCLS_DISABLE_DRIVE_RAM_6000_ES, "Deshabilitar expansin RAM de 8KB en $6000-$7FFF"},
/* fr */ {IDCLS_DISABLE_DRIVE_RAM_6000_FR, "Dsactiver l'exansion de 8KB RAM  $6000-$7FFF"},
/* hu */ {IDCLS_DISABLE_DRIVE_RAM_6000_HU, "8KB RAM kiterjeszs tiltsa a $6000-$7FFF cmen"},
/* it */ {IDCLS_DISABLE_DRIVE_RAM_6000_IT, "Disattiva l'espansione di RAM di 8KB a $6000-$7FFF"},
/* ko */ {IDCLS_DISABLE_DRIVE_RAM_6000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_DRIVE_RAM_6000_NL, "8KB RAM uitbreiding op adres $6000-$7FFF uitschakelen"},
/* pl */ {IDCLS_DISABLE_DRIVE_RAM_6000_PL, "Wycz rozszerzenie 8KB RAM w $6000-$7FFF"},
/* ru */ {IDCLS_DISABLE_DRIVE_RAM_6000_RU, "Disable 8KB RAM expansion at $6000-$7FFF"},
/* sv */ {IDCLS_DISABLE_DRIVE_RAM_6000_SV, "Inaktivera 8KB RAM-expansion p $6000-$7FFF"},
/* tr */ {IDCLS_DISABLE_DRIVE_RAM_6000_TR, "$6000-$7FFF arasnda 8KB RAM geniletmeyi pasifletir"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DRIVE_RAM_8000,    N_("Enable 8KB RAM expansion at $8000-$9FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_DRIVE_RAM_8000_DA, "Aktivr 8kB RAM-udviddelse p $8000-$9FFF"},
/* de */ {IDCLS_ENABLE_DRIVE_RAM_8000_DE, "8KB RAM Erweiterung bei $8000-9fff aktivieren"},
/* es */ {IDCLS_ENABLE_DRIVE_RAM_8000_ES, "Permitir expansin RAM de 8KB en $8000-$9FFF"},
/* fr */ {IDCLS_ENABLE_DRIVE_RAM_8000_FR, "Activer l'exansion de 8KB RAM  $8000-$9FFF"},
/* hu */ {IDCLS_ENABLE_DRIVE_RAM_8000_HU, "8KB RAM kiterjeszs engedlyezse a $8000-$9FFF cmen"},
/* it */ {IDCLS_ENABLE_DRIVE_RAM_8000_IT, "Attiva l'espansione di RAM di 8KB a $8000-$9FFF"},
/* ko */ {IDCLS_ENABLE_DRIVE_RAM_8000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_DRIVE_RAM_8000_NL, "8KB RAM uitbreiding op adres $8000-$9FFF inschakelen"},
/* pl */ {IDCLS_ENABLE_DRIVE_RAM_8000_PL, "Wcz rozszerzenie 8KB RAM w $8000-$9FFF"},
/* ru */ {IDCLS_ENABLE_DRIVE_RAM_8000_RU, "Enable 8KB RAM expansion at $8000-$9FFF"},
/* sv */ {IDCLS_ENABLE_DRIVE_RAM_8000_SV, "Aktivera 8KB RAM-expansion p $8000-$9FFF"},
/* tr */ {IDCLS_ENABLE_DRIVE_RAM_8000_TR, "$8000-$9FFF arasnda 8KB RAM geniletmeyi aktif et"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DRIVE_RAM_8000,    N_("Disable 8KB RAM expansion at $8000-$9FFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_DRIVE_RAM_8000_DA, "Deaktivr 8kB RAM-udviddelse p $8000-$9FFF"},
/* de */ {IDCLS_DISABLE_DRIVE_RAM_8000_DE, "8KB RAM Erweiterung bei $8000-9fff deaktivieren"},
/* es */ {IDCLS_DISABLE_DRIVE_RAM_8000_ES, "Deshabilitar expansin RAM de 8KB en $8000-$9FFF"},
/* fr */ {IDCLS_DISABLE_DRIVE_RAM_8000_FR, "Dsactiver l'exansion de 8KB RAM  $8000-$9FFF"},
/* hu */ {IDCLS_DISABLE_DRIVE_RAM_8000_HU, "8KB RAM kiterjeszs tiltsa a $8000-$9FFF cmen"},
/* it */ {IDCLS_DISABLE_DRIVE_RAM_8000_IT, "Disattiva l'espansione di RAM di 8KB a $8000-$9FFF"},
/* ko */ {IDCLS_DISABLE_DRIVE_RAM_8000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_DRIVE_RAM_8000_NL, "8KB RAM uitbreiding op adres $8000-$9FFF uitschakelen"},
/* pl */ {IDCLS_DISABLE_DRIVE_RAM_8000_PL, "Wycz rozszerzenie 8KB RAM w $8000-$9FFF"},
/* ru */ {IDCLS_DISABLE_DRIVE_RAM_8000_RU, "Disable 8KB RAM expansion at $8000-$9FFF"},
/* sv */ {IDCLS_DISABLE_DRIVE_RAM_8000_SV, "Inaktivera 8KB RAM-expansion p $8000-$9FFF"},
/* tr */ {IDCLS_DISABLE_DRIVE_RAM_8000_TR, "$8000-$9FFF arasnda 8KB RAM geniletmeyi pasifletir"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DRIVE_RAM_A000,    N_("Enable 8KB RAM expansion at $A000-$BFFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_DRIVE_RAM_A000_DA, "Aktivr 8kB RAM-udviddelse p $A000-$BFFF"},
/* de */ {IDCLS_ENABLE_DRIVE_RAM_A000_DE, "8KB RAM Erweiterung bei $A000-Bfff aktivieren"},
/* es */ {IDCLS_ENABLE_DRIVE_RAM_A000_ES, "Permitir expansin RAM de 8KB en $A000-$BFFF"},
/* fr */ {IDCLS_ENABLE_DRIVE_RAM_A000_FR, "Activer l'exansion de 8KB RAM  $A000-$BFFF"},
/* hu */ {IDCLS_ENABLE_DRIVE_RAM_A000_HU, "8KB RAM kiterjeszs engedlyezse a $A000-$BFFF cmen"},
/* it */ {IDCLS_ENABLE_DRIVE_RAM_A000_IT, "Attiva l'espansione di RAM di 8KB a $A000-$BFFF"},
/* ko */ {IDCLS_ENABLE_DRIVE_RAM_A000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_DRIVE_RAM_A000_NL, "8KB RAM uitbreiding op adres $A000-$BFFF inschakelen"},
/* pl */ {IDCLS_ENABLE_DRIVE_RAM_A000_PL, "Wcz rozszerzenie 8KB RAM w $A000-$BFFF"},
/* ru */ {IDCLS_ENABLE_DRIVE_RAM_A000_RU, "Enable 8KB RAM expansion at $A000-$BFFF"},
/* sv */ {IDCLS_ENABLE_DRIVE_RAM_A000_SV, "Aktivera 8KB RAM-expansion p $A000-$BFFF"},
/* tr */ {IDCLS_ENABLE_DRIVE_RAM_A000_TR, "$A000-$BFFF arasnda 8KB RAM geniletmeyi aktif et"},
#endif

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DRIVE_RAM_A000,    N_("Disable 8KB RAM expansion at $A000-$BFFF")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_DRIVE_RAM_A000_DA, "Deaktivr 8kB RAM-udviddelse p $A000-$BFFF"},
/* de */ {IDCLS_DISABLE_DRIVE_RAM_A000_DE, "8KB RAM Erweiterung bei $A000-Bfff deaktivieren"},
/* es */ {IDCLS_DISABLE_DRIVE_RAM_A000_ES, "Deshabilitar expansin RAM de 8KB en $A000-$BFFF"},
/* fr */ {IDCLS_DISABLE_DRIVE_RAM_A000_FR, "Dsactiver l'exansion de 8KB RAM  $A000-$BFFF"},
/* hu */ {IDCLS_DISABLE_DRIVE_RAM_A000_HU, "8KB RAM kiterjeszs tiltsa a $A000-$BFFF cmen"},
/* it */ {IDCLS_DISABLE_DRIVE_RAM_A000_IT, "Disattiva l'espansione di RAM di 8KB a $A000-$BFFF"},
/* ko */ {IDCLS_DISABLE_DRIVE_RAM_A000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_DRIVE_RAM_A000_NL, "8KB RAM uitbreiding op adres $A000-$BFFF uitschakelen"},
/* pl */ {IDCLS_DISABLE_DRIVE_RAM_A000_PL, "Wycz rozszerzenie 8KB RAM w $A000-$BFFF"},
/* ru */ {IDCLS_DISABLE_DRIVE_RAM_A000_RU, "Disable 8KB RAM expansion at $A000-$BFFF"},
/* sv */ {IDCLS_DISABLE_DRIVE_RAM_A000_SV, "Inaktivera 8KB RAM-expansion p $A000-$BFFF"},
/* tr */ {IDCLS_DISABLE_DRIVE_RAM_A000_TR, "$A000-$BFFF arasnda 8KB RAM geniletmeyi pasifletir"},
#endif

/* drive/iec/c64exp/c64exp-cmdline-options.c */
/* en */ {IDCLS_PAR_CABLE_C64EXP_TYPE,    N_("Set parallel cable type (0: none, 1: standard, 2: Dolphin DOS 3, 3: Formel 64)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PAR_CABLE_C64EXP_TYPE_DA, "Vlg typen af parallelkabel (0: ingen, 1: standard, 2: Dolphin DOS 3 3: Formel 64)"},
/* de */ {IDCLS_PAR_CABLE_C64EXP_TYPE_DE, "Parallel Kabel Typ (0: Kein, 1: Standard, 2: Dolphin DOS 3, 3: Formel 64)"},
/* es */ {IDCLS_PAR_CABLE_C64EXP_TYPE_ES, "Seleccionar tipo de cable paralelo (0:no, 1:estndar, 2:Dolphin DOS 3, 3:Formel 64)"},
/* fr */ {IDCLS_PAR_CABLE_C64EXP_TYPE_FR, "Dfinir le type de cble parallle (0: aucun, 1: standard, 2: Dolphin DOS 3, 3: Formel 64)"},
/* hu */ {IDCLS_PAR_CABLE_C64EXP_TYPE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_PAR_CABLE_C64EXP_TYPE_IT, "Imposta il tipo di cavo parallelo (0: none, 1: standard, 2: Dolphin DOS 3, 3: Formel 64)"},
/* ko */ {IDCLS_PAR_CABLE_C64EXP_TYPE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PAR_CABLE_C64EXP_TYPE_NL, "Stel parallelle kabelsoort in (0: geen, 1: standaard, 2: Dolphin DOS 3, 3: Formel 64)"},
/* pl */ {IDCLS_PAR_CABLE_C64EXP_TYPE_PL, "Okrel typ cza rwnolegego (0: brak, 1: zwyke, 2: Dolphin DOS 3, 3: Formel 64)"},
/* ru */ {IDCLS_PAR_CABLE_C64EXP_TYPE_RU, "Set parallel cable type (0: none, 1: standard, 2: Dolphin DOS 3, 3: Formel 64)"},
/* sv */ {IDCLS_PAR_CABLE_C64EXP_TYPE_SV, "Vlj typ av parallellkabel (0: ingen, 1: standard, 2: Dolphin DOS 3, 3: Formel 64)"},
/* tr */ {IDCLS_PAR_CABLE_C64EXP_TYPE_TR, "Paralel kablo tipini belirle (0: yok, 1: standart, 2: Dolphin DOS 3, 3: Formel 64)"},
#endif

/* drive/iec/c64exp/c64exp-cmdline-options.c */
/* en */ {IDCLS_ENABLE_PROFDOS,    N_("Enable Professional DOS")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_PROFDOS_DA, "Aktivr Professional DOS"},
/* de */ {IDCLS_ENABLE_PROFDOS_DE, "Professional DOS aktivieren"},
/* es */ {IDCLS_ENABLE_PROFDOS_ES, "Permitir DOS profesional"},
/* fr */ {IDCLS_ENABLE_PROFDOS_FR, "Activer le DOS Professionnel"},
/* hu */ {IDCLS_ENABLE_PROFDOS_HU, "Professional DOS engedlyezse"},
/* it */ {IDCLS_ENABLE_PROFDOS_IT, "Attiva Professional DOS"},
/* ko */ {IDCLS_ENABLE_PROFDOS_KO, "Professional DOS 밡ϰ ϱ"},
/* nl */ {IDCLS_ENABLE_PROFDOS_NL, "Activeer Professional DOS"},
/* pl */ {IDCLS_ENABLE_PROFDOS_PL, "Wcz Professional DOS"},
/* ru */ {IDCLS_ENABLE_PROFDOS_RU, "Enable Professional DOS"},
/* sv */ {IDCLS_ENABLE_PROFDOS_SV, "Aktivera Professional DOS"},
/* tr */ {IDCLS_ENABLE_PROFDOS_TR, "Professional DOS'u aktif et"},
#endif

/* drive/iec/c64exp/c64exp-cmdline-options.c */
/* en */ {IDCLS_DISABLE_PROFDOS,    N_("Disable Professional DOS")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_PROFDOS_DA, "Deaktivr Professional DOS"},
/* de */ {IDCLS_DISABLE_PROFDOS_DE, "Professional DOS deaktivieren"},
/* es */ {IDCLS_DISABLE_PROFDOS_ES, "Deshabilitar Professional DOS"},
/* fr */ {IDCLS_DISABLE_PROFDOS_FR, "Dsactiver le DOS Professionnel"},
/* hu */ {IDCLS_DISABLE_PROFDOS_HU, "Professional DOS tiltsa"},
/* it */ {IDCLS_DISABLE_PROFDOS_IT, "Disattiva Professional DOS"},
/* ko */ {IDCLS_DISABLE_PROFDOS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_PROFDOS_NL, "Professional DOS uitschakelen"},
/* pl */ {IDCLS_DISABLE_PROFDOS_PL, "Wycz Professional DOS"},
/* ru */ {IDCLS_DISABLE_PROFDOS_RU, "Disable Professional DOS"},
/* sv */ {IDCLS_DISABLE_PROFDOS_SV, "Inaktivera Professional DOS"},
/* tr */ {IDCLS_DISABLE_PROFDOS_TR, "Professional DOS'u pasifletir"},
#endif

/* drive/iec/c64exp/c64exp-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME,    N_("Specify name of Professional DOS 1571 ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_DA, "Angiv navn p Professional DOS 1571-ROM-image"},
/* de */ {IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_DE, "Name von Professional DOS 1571 Datei whlen"},
/* es */ {IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_ES, "Especificar nombre imagen ROM Professional DOS 1571"},
/* fr */ {IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_FR, "Spcifier le nom du nouveau ROM Professional DOS 1571"},
/* hu */ {IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_HU, "Adja meg a Professional DOS 1571 ROM kpmst"},
/* it */ {IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_IT, "Specifica il nome immagine della ROM del Professional DOS 1571"},
/* ko */ {IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_NL, "Geef de naam van het Professional DOS 1571 ROM bestand"},
/* pl */ {IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_PL, "Okrel nazw obrazu ROM Professional DOS 1571"},
/* ru */ {IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_RU, "Specify name of Professional DOS 1571 ROM image"},
/* sv */ {IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_SV, "Ange namn p Professional DOS 1571-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_TR, "Professional DOS 1571 ROM imaj ismini belirt"},
#endif

/* drive/iec/c64exp/c64exp-cmdline-options.c */
/* en */ {IDCLS_ENABLE_SUPERCARD,    N_("Enable SuperCard+")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_SUPERCARD_DA, "Aktivr SuperCard+"},
/* de */ {IDCLS_ENABLE_SUPERCARD_DE, "SuperCard+ aktivieren"},
/* es */ {IDCLS_ENABLE_SUPERCARD_ES, "Permitir SuperCard+"},
/* fr */ {IDCLS_ENABLE_SUPERCARD_FR, "Activer SuperCard+"},
/* hu */ {IDCLS_ENABLE_SUPERCARD_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_SUPERCARD_IT, "Attiva SuperCard+"},
/* ko */ {IDCLS_ENABLE_SUPERCARD_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_SUPERCARD_NL, "Activeer SuperCard+"},
/* pl */ {IDCLS_ENABLE_SUPERCARD_PL, "Wcz SuperCard+"},
/* ru */ {IDCLS_ENABLE_SUPERCARD_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_SUPERCARD_SV, "Aktivera SuperCard+"},
/* tr */ {IDCLS_ENABLE_SUPERCARD_TR, "SuperCard+' aktif et"},
#endif

/* drive/iec/c64exp/c64exp-cmdline-options.c */
/* en */ {IDCLS_DISABLE_SUPERCARD,    N_("Disable SuperCard+")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_SUPERCARD_DA, "Deaktivr SuperCard+"},
/* de */ {IDCLS_DISABLE_SUPERCARD_DE, "SuperCard+ deaktivieren"},
/* es */ {IDCLS_DISABLE_SUPERCARD_ES, "Deshabilitar SuperCard+"},
/* fr */ {IDCLS_DISABLE_SUPERCARD_FR, "Dsactiver SuperCard+"},
/* hu */ {IDCLS_DISABLE_SUPERCARD_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_SUPERCARD_IT, "Disattiva SuperCard+"},
/* ko */ {IDCLS_DISABLE_SUPERCARD_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_SUPERCARD_NL, "SuperCard+ uitschakelen"},
/* pl */ {IDCLS_DISABLE_SUPERCARD_PL, "Wycz SuperCard+"},
/* ru */ {IDCLS_DISABLE_SUPERCARD_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_SUPERCARD_SV, "Inaktivera SuperCard+"},
/* tr */ {IDCLS_DISABLE_SUPERCARD_TR, "SuperCard+' pasifletir"},
#endif

/* drive/iec/c64exp/c64exp-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_SUPERCARD_ROM_NAME,    N_("Specify name of SuperCard+ ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_SUPERCARD_ROM_NAME_DA, "Angiv navn p SuperCard+ ROM-image"},
/* de */ {IDCLS_SPECIFY_SUPERCARD_ROM_NAME_DE, "Name von SuperCard+ ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_SUPERCARD_ROM_NAME_ES, "Especificar nombre de Imagen ROM SuperCard+"},
/* fr */ {IDCLS_SPECIFY_SUPERCARD_ROM_NAME_FR, "Spcifier le nom de l'image ROM SuperCard+"},
/* hu */ {IDCLS_SPECIFY_SUPERCARD_ROM_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_SUPERCARD_ROM_NAME_IT, "Specifica il nome immagine della ROM del SuperCard+"},
/* ko */ {IDCLS_SPECIFY_SUPERCARD_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_SUPERCARD_ROM_NAME_NL, "Geef de naam van het SuperCard+ ROM bestand"},
/* pl */ {IDCLS_SPECIFY_SUPERCARD_ROM_NAME_PL, "Okrel nazw obrazu ROM SuperCard+"},
/* ru */ {IDCLS_SPECIFY_SUPERCARD_ROM_NAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_SUPERCARD_ROM_NAME_SV, "Ange namn p SuperCard+-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_SUPERCARD_ROM_NAME_TR, "SuperCard+ ROM imajnn ismini belirt"},
#endif

/* drive/iec/c64exp/c64exp-cmdline-options.c */
/* en */ {IDCLS_ENABLE_STARDOS,    N_("Enable StarDOS")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_STARDOS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_STARDOS_DE, ""},  /* fuzzy */
/* es */ {IDCLS_ENABLE_STARDOS_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_STARDOS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_STARDOS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_STARDOS_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_STARDOS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_STARDOS_NL, "Activeer StarDOS"},
/* pl */ {IDCLS_ENABLE_STARDOS_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_ENABLE_STARDOS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_STARDOS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_STARDOS_TR, ""},  /* fuzzy */
#endif

/* drive/iec/c64exp/c64exp-cmdline-options.c */
/* en */ {IDCLS_DISABLE_STARDOS,    N_("Disable StarDOS")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_STARDOS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_STARDOS_DE, ""},  /* fuzzy */
/* es */ {IDCLS_DISABLE_STARDOS_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_STARDOS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_STARDOS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_STARDOS_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_STARDOS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_STARDOS_NL, "StarDOS uitschakelen"},
/* pl */ {IDCLS_DISABLE_STARDOS_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_DISABLE_STARDOS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_STARDOS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_STARDOS_TR, ""},  /* fuzzy */
#endif

/* drive/iec/c64exp/c64exp-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_STARDOS_ROM_NAME,    N_("Specify name of StarDOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_STARDOS_ROM_NAME_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_STARDOS_ROM_NAME_DE, ""},  /* fuzzy */
/* es */ {IDCLS_SPECIFY_STARDOS_ROM_NAME_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SPECIFY_STARDOS_ROM_NAME_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_STARDOS_ROM_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_STARDOS_ROM_NAME_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SPECIFY_STARDOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_STARDOS_ROM_NAME_NL, "Geef de naam van het StarDOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_STARDOS_ROM_NAME_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_SPECIFY_STARDOS_ROM_NAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_STARDOS_ROM_NAME_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_STARDOS_ROM_NAME_TR, ""},  /* fuzzy */
#endif

/* drive/iec/plus4exp/plus4exp-cmdline-options.c */
/* en */ {IDCLS_PAR_CABLE_PLUS4EXP_TYPE,    N_("Set parallel cable type (0: none, 1: standard)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PAR_CABLE_PLUS4EXP_TYPE_DA, "Vlg typen af parallelkabel parallellkabel (0: ingen, 1: standard)"},
/* de */ {IDCLS_PAR_CABLE_PLUS4EXP_TYPE_DE, "Parallelkabel Typ (0: kein, 1: Standard)"},
/* es */ {IDCLS_PAR_CABLE_PLUS4EXP_TYPE_ES, "Seleccionar tipo de cable paralelo (0:no, 1:standard)"},
/* fr */ {IDCLS_PAR_CABLE_PLUS4EXP_TYPE_FR, "Dfinir le type de cble parallle (0: aucun, 1: standard)"},
/* hu */ {IDCLS_PAR_CABLE_PLUS4EXP_TYPE_HU, "Adja meg a prhuzamos kbel tpust (0: nincs, 1: standard)"},
/* it */ {IDCLS_PAR_CABLE_PLUS4EXP_TYPE_IT, "Imposta il tipo di cavo parallelo (0: nessuno, 1: standard)"},
/* ko */ {IDCLS_PAR_CABLE_PLUS4EXP_TYPE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PAR_CABLE_PLUS4EXP_TYPE_NL, "Stel parallelle kabelsoort in (0: geen, 1: standaard)"},
/* pl */ {IDCLS_PAR_CABLE_PLUS4EXP_TYPE_PL, "Ustaw typ kabla portu rwnolegego (0: brak, 1: typowy)"},
/* ru */ {IDCLS_PAR_CABLE_PLUS4EXP_TYPE_RU, "Set parallel cable type (0: none, 1: standard)"},
/* sv */ {IDCLS_PAR_CABLE_PLUS4EXP_TYPE_SV, "Vlj typ av parallellkabel (0: ingen, 1: standard)"},
/* tr */ {IDCLS_PAR_CABLE_PLUS4EXP_TYPE_TR, "Paralel kablo tipini ayarlayn (0: yok, 1: standart)"},
#endif

/* drive/iec128dcr/iec128dcr-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1571CR_DOS_ROM_NAME,    N_("Specify name of 1571CR DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_DA, "Angiv navn p 1571CR-DOS-ROM-image"},
/* de */ {IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_DE, "Name der 1571CR DOS ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_ES, "Especificar nombre imagen DOS ROM 1571CR"},
/* fr */ {IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_FR, "Spcifier le nom de l'image 1571CR DOS ROM"},
/* hu */ {IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_HU, "Adja meg az 1571CR DOS ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del DOS del 1571CR"},
/* ko */ {IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_NL, "Geef de naam van het 1571CR DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 1571CR"},
/* ru */ {IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_RU, "Specify name of 1571CR DOS ROM image"},
/* sv */ {IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_SV, "Ange namn p 1571CR-DOS-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_TR, "1571CR DOS ROM imaj ismini belirt"},
#endif

/* drive/ieee/ieee-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_2031_DOS_ROM_NAME,    N_("Specify name of 2031 DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_2031_DOS_ROM_NAME_DA, "Angiv navn p 2031-DOS-ROM-image"},
/* de */ {IDCLS_SPECIFY_2031_DOS_ROM_NAME_DE, "Name der 2031 DOS ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_2031_DOS_ROM_NAME_ES, "Especificar nombre imagen DOS ROM 2031"},
/* fr */ {IDCLS_SPECIFY_2031_DOS_ROM_NAME_FR, "Spcifier le nom de l'image 2031 DOS ROM"},
/* hu */ {IDCLS_SPECIFY_2031_DOS_ROM_NAME_HU, "Adja meg a 2031 DOS ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_2031_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del DOS del 2031"},
/* ko */ {IDCLS_SPECIFY_2031_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_2031_DOS_ROM_NAME_NL, "Geef de naam van het 2031 DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_2031_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 2031"},
/* ru */ {IDCLS_SPECIFY_2031_DOS_ROM_NAME_RU, "Specify name of 2031 DOS ROM image"},
/* sv */ {IDCLS_SPECIFY_2031_DOS_ROM_NAME_SV, "Ange namn p 2031-DOS-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_2031_DOS_ROM_NAME_TR, "2031 DOS ROM imaj ismini belirt"},
#endif

/* drive/ieee/ieee-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_2040_DOS_ROM_NAME,    N_("Specify name of 2040 DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_2040_DOS_ROM_NAME_DA, "Angiv navn p 2040-DOS-ROM-image"},
/* de */ {IDCLS_SPECIFY_2040_DOS_ROM_NAME_DE, "Name der 2040 DOS ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_2040_DOS_ROM_NAME_ES, "Especificar nombre imagen DOS ROM 2040"},
/* fr */ {IDCLS_SPECIFY_2040_DOS_ROM_NAME_FR, "Spcifier le nom de l'image 2040 DOS ROM"},
/* hu */ {IDCLS_SPECIFY_2040_DOS_ROM_NAME_HU, "Adja meg a 2040 DOS ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_2040_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del DOS del 2040"},
/* ko */ {IDCLS_SPECIFY_2040_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_2040_DOS_ROM_NAME_NL, "Geef de naam van het 2040 DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_2040_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 2040"},
/* ru */ {IDCLS_SPECIFY_2040_DOS_ROM_NAME_RU, "Specify name of 2040 DOS ROM image"},
/* sv */ {IDCLS_SPECIFY_2040_DOS_ROM_NAME_SV, "Ange namn p 2040-DOS-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_2040_DOS_ROM_NAME_TR, "2040 DOS ROM imaj ismini belirt"},
#endif

/* drive/ieee/ieee-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_3040_DOS_ROM_NAME,    N_("Specify name of 3040 DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_3040_DOS_ROM_NAME_DA, "Angiv navn p 3040-DOS-ROM-image"},
/* de */ {IDCLS_SPECIFY_3040_DOS_ROM_NAME_DE, "Name der 3040 DOS ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_3040_DOS_ROM_NAME_ES, "Especificar nombre imagen DOS ROM 3040"},
/* fr */ {IDCLS_SPECIFY_3040_DOS_ROM_NAME_FR, "Spcifier le nom de l'image 3040 DOS ROM"},
/* hu */ {IDCLS_SPECIFY_3040_DOS_ROM_NAME_HU, "Adja meg a 3040 DOS ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_3040_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del DOS del 3040"},
/* ko */ {IDCLS_SPECIFY_3040_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_3040_DOS_ROM_NAME_NL, "Geef de naam van het 3040 DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_3040_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 3040"},
/* ru */ {IDCLS_SPECIFY_3040_DOS_ROM_NAME_RU, "Specify name of 3040 DOS ROM image"},
/* sv */ {IDCLS_SPECIFY_3040_DOS_ROM_NAME_SV, "Ange namn p 3040-DOS-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_3040_DOS_ROM_NAME_TR, "3040 DOS ROM imaj ismini belirt"},
#endif

/* drive/ieee/ieee-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_4040_DOS_ROM_NAME,    N_("Specify name of 4040 DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_4040_DOS_ROM_NAME_DA, "Angiv navn p 4040-DOS-ROM-image"},
/* de */ {IDCLS_SPECIFY_4040_DOS_ROM_NAME_DE, "Name der 4040 DOS ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_4040_DOS_ROM_NAME_ES, "Especificar nombre imagen DOS ROM 4040"},
/* fr */ {IDCLS_SPECIFY_4040_DOS_ROM_NAME_FR, "Spcifier le nom de l'image 4040 DOS ROM"},
/* hu */ {IDCLS_SPECIFY_4040_DOS_ROM_NAME_HU, "Adja meg a 4040 DOS ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_4040_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del DOS del 4040"},
/* ko */ {IDCLS_SPECIFY_4040_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_4040_DOS_ROM_NAME_NL, "Geef de naam van het 4040 DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_4040_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 4040"},
/* ru */ {IDCLS_SPECIFY_4040_DOS_ROM_NAME_RU, "Specify name of 4040 DOS ROM image"},
/* sv */ {IDCLS_SPECIFY_4040_DOS_ROM_NAME_SV, "Ange namn p 4040-DOS-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_4040_DOS_ROM_NAME_TR, "4040 DOS ROM imaj ismini belirt"},
#endif

/* drive/ieee/ieee-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1001_DOS_ROM_NAME,    N_("Specify name of 1001/8050/8250 DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_1001_DOS_ROM_NAME_DA, "Angiv navn p 1001/8050/8250-DOS-ROM-image"},
/* de */ {IDCLS_SPECIFY_1001_DOS_ROM_NAME_DE, "Name der 1001/8040/8205 DOS ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_1001_DOS_ROM_NAME_ES, "Especificar nombre imagen DOS ROM 1001/8050/8250"},
/* fr */ {IDCLS_SPECIFY_1001_DOS_ROM_NAME_FR, "Spcifier le nom de l'image 1001/8050/8250 DOS ROM"},
/* hu */ {IDCLS_SPECIFY_1001_DOS_ROM_NAME_HU, "Adja meg az 1001/8050/8250 DOS ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_1001_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del DOS del 1001/8050/8250"},
/* ko */ {IDCLS_SPECIFY_1001_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_1001_DOS_ROM_NAME_NL, "Geef de naam van het 1001/8050/8250 DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_1001_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 1001/8050/8250"},
/* ru */ {IDCLS_SPECIFY_1001_DOS_ROM_NAME_RU, "Specify name of 1001/8050/8250 DOS ROM image"},
/* sv */ {IDCLS_SPECIFY_1001_DOS_ROM_NAME_SV, "Ange namn p 1001/8050/8250-DOS-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_1001_DOS_ROM_NAME_TR, "1001/8050/8250 DOS ROM imaj ismini belirt"},
#endif

/* drive/tcbm/tcbm-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1551_DOS_ROM_NAME,    N_("Specify name of 1551 DOS ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_1551_DOS_ROM_NAME_DA, "Angiv navn p 1551-DOS-ROM-image"},
/* de */ {IDCLS_SPECIFY_1551_DOS_ROM_NAME_DE, "Name der 1551 DOS ROM Datei whlen"},
/* es */ {IDCLS_SPECIFY_1551_DOS_ROM_NAME_ES, "Especificar nombre imagen DOS ROM 1551"},
/* fr */ {IDCLS_SPECIFY_1551_DOS_ROM_NAME_FR, "Spcifier le nom de l'image 1551 DOS ROM"},
/* hu */ {IDCLS_SPECIFY_1551_DOS_ROM_NAME_HU, "Adja meg az 1551 DOS ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_1551_DOS_ROM_NAME_IT, "Specifica il nome immagine della ROM del DOS del 1551"},
/* ko */ {IDCLS_SPECIFY_1551_DOS_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_1551_DOS_ROM_NAME_NL, "Geef de naam van het 1551 DOS ROM bestand"},
/* pl */ {IDCLS_SPECIFY_1551_DOS_ROM_NAME_PL, "Okrel nazw obrazu ROM DOS-a 1551"},
/* ru */ {IDCLS_SPECIFY_1551_DOS_ROM_NAME_RU, "Specify name of 1551 DOS ROM image"},
/* sv */ {IDCLS_SPECIFY_1551_DOS_ROM_NAME_SV, "Ange namn p 1551-DOS-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_1551_DOS_ROM_NAME_TR, "1551 DOS ROM imaj ismini belirt"},
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_8,    N_("Use <name> as directory for file system device #8")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_DA, "Brug <navn> som katalog for filsystembaseret drev #8"},
/* de */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_DE, "Benutze <Name> fr Verzeichnis beim Verzeichniszugriff fr Gert #8"},
/* es */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_ES, "Usar <nombre> como directorio fichero sistema perifrico #8"},
/* fr */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_FR, "Utiliser le rpertoire <nom> comme systme de fichiers pour le lecteur #8"},
/* hu */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_HU, "<nv> knyvtr hasznlata az #8-as egysg fjlrendszernek"},
/* it */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_IT, "Usa <nome> come directory per il file system della periferica #8"},
/* ko */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_NL, "Gebruik <naam> als directory voor bestandssysteemapparaat #8"},
/* pl */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_PL, "Uzyj <nazwa> jako katalog urzdzenia systemu plikw #8"},
/* ru */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_RU, "Use <name> as directory for file system device #8"},
/* sv */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_SV, "Ange <namn> som katalog fr filsystemsbaserad enhet 8"},
/* tr */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_TR, "<isim>'i aygt #8'in dosya sistemi dizini olarak kullan"},
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_9,    N_("Use <name> as directory for file system device #9")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_DA, "Brug <navn> som katalog for filsystembaseret drev #9"},
/* de */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_DE, "Benutze <Name> fr Verzeichnis beim Verzeichniszugriff fr Gert #9"},
/* es */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_ES, "Usar <nombre> como directorio fichero sistema perifrico #9"},
/* fr */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_FR, "Utiliser le rpertoire <nom> comme systme de fichiers pour le lecteur #9"},
/* hu */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_HU, "<nv> knyvtr hasznlata az #9-es egysg fjlrendszernek"},
/* it */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_IT, "Usa <nome> come directory per il file system della periferica #9"},
/* ko */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_NL, "Gebruik <naam> als directory voor bestandssysteemapparaat #9"},
/* pl */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_PL, "Uzyj <nazwa> jako katalog urzdzenia systemu plikw #9"},
/* ru */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_RU, "Use <name> as directory for file system device #9"},
/* sv */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_SV, "Ange <namn> som katalog fr filsystemsbaserad enhet 9"},
/* tr */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_TR, "<isim>'i aygt #9'un dosya sistemi dizini olarak kullan"},
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_10,    N_("Use <name> as directory for file system device #10")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_DA, "Brug <navn> som katalog for filsystembaseret drev #10"},
/* de */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_DE, "Benutze <Name> fr Verzeichnis beim Verzeichniszugriff fr Gert #10"},
/* es */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_ES, "Usar <nombre> como directorio fichero sistema perifrico #10"},
/* fr */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_FR, "Utiliser le rpertoire <nom> comme systme de fichiers pour le lecteur #10"},
/* hu */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_HU, "<nv> knyvtr hasznlata az #10-es egysg fjlrendszernek"},
/* it */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_IT, "Usa <nome> come directory per il file system della periferica #10"},
/* ko */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_NL, "Gebruik <naam> als directory voor bestandssysteemapparaat #10"},
/* pl */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_PL, "Uzyj <nazwa> jako katalog urzdzenia systemu plikw #10"},
/* ru */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_RU, "Use <name> as directory for file system device #10"},
/* sv */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_SV, "Ange <namn> som katalog fr filsystemsbaserad enhet 10"},
/* tr */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_TR, "<isim>'i aygt #10'un dosya sistemi dizini olarak kullan"},
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_11,    N_("Use <name> as directory for file system device #11")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_DA, "Brug <navn> som katalog for filsystembaseret drev #11"},
/* de */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_DE, "Benutze <Name> fr Verzeichnis beim Verzeichniszugriff fr Gert #11"},
/* es */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_ES, "Usar <nombre> como directorio fichero sistema perifrico #10"},
/* fr */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_FR, "Utiliser le rpertoire <nom> comme systme de fichiers pour le lecteur #11"},
/* hu */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_HU, "<nv> knyvtr hasznlata az #11-es egysg fjlrendszernek"},
/* it */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_IT, "Usa <nome> come directory per il file system della periferica #11"},
/* ko */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_NL, "Gebruik <naam> als directory voor bestandssysteemapparaat #11"},
/* pl */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_PL, "Uzyj <nazwa> jako katalog urzdzenia systemu plikw #11"},
/* ru */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_RU, "Use <name> as directory for file system device #11"},
/* sv */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_SV, "Ange <namn> som katalog fr filsystemsbaserad enhet 11"},
/* tr */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_TR, "<isim>'i aygt #11'in dosya sistemi dizini olarak kullan"},
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_ENABLE_FSDEVICE_8_CONVERT_P00,    N_("Enable on-read support for P00 files on drive 8")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_FSDEVICE_8_CONVERT_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_FSDEVICE_8_CONVERT_P00_DE, "On-read Untersttzung fr P00 Dateien auf Laufwerk 8 aktivieren"},
/* es */ {IDCLS_ENABLE_FSDEVICE_8_CONVERT_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_FSDEVICE_8_CONVERT_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_FSDEVICE_8_CONVERT_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_FSDEVICE_8_CONVERT_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_FSDEVICE_8_CONVERT_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_FSDEVICE_8_CONVERT_P00_NL, "Ondersteuning voor het lezen van P00 bestanden voor drive 8 inschakelen"},
/* pl */ {IDCLS_ENABLE_FSDEVICE_8_CONVERT_P00_PL, "Wcz obsug plikw P00 przy odczycie z napdu 8"},
/* ru */ {IDCLS_ENABLE_FSDEVICE_8_CONVERT_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_FSDEVICE_8_CONVERT_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_FSDEVICE_8_CONVERT_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_DISABLE_FSDEVICE_8_CONVERT_P00,    N_("Disable on-read support for P00 files on drive 8")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_FSDEVICE_8_CONVERT_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_FSDEVICE_8_CONVERT_P00_DE, "On-read Untersttzung fr P00 Dateien auf Laufwerk 8 deaktivieren"},
/* es */ {IDCLS_DISABLE_FSDEVICE_8_CONVERT_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_FSDEVICE_8_CONVERT_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_FSDEVICE_8_CONVERT_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_FSDEVICE_8_CONVERT_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_FSDEVICE_8_CONVERT_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_FSDEVICE_8_CONVERT_P00_NL, "Ondersteuning voor het lezen van P00 bestanden voor drive 8 uitschakelen"},
/* pl */ {IDCLS_DISABLE_FSDEVICE_8_CONVERT_P00_PL, "Wycz obsug plikw P00 przy odczycie z napdu 8"},
/* ru */ {IDCLS_DISABLE_FSDEVICE_8_CONVERT_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_FSDEVICE_8_CONVERT_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_FSDEVICE_8_CONVERT_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_ENABLE_FSDEVICE_9_CONVERT_P00,    N_("Enable on-read support for P00 files on drive 9")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_FSDEVICE_9_CONVERT_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_FSDEVICE_9_CONVERT_P00_DE, "On-read Untersttzung fr P00 Dateien auf Laufwerk 9 aktivieren"},
/* es */ {IDCLS_ENABLE_FSDEVICE_9_CONVERT_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_FSDEVICE_9_CONVERT_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_FSDEVICE_9_CONVERT_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_FSDEVICE_9_CONVERT_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_FSDEVICE_9_CONVERT_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_FSDEVICE_9_CONVERT_P00_NL, "Ondersteuning voor het lezen van P00 bestanden voor drive 9 inschakelen"},
/* pl */ {IDCLS_ENABLE_FSDEVICE_9_CONVERT_P00_PL, "Wcz obsug plikw P00 przy odczycie z napdu 9"},
/* ru */ {IDCLS_ENABLE_FSDEVICE_9_CONVERT_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_FSDEVICE_9_CONVERT_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_FSDEVICE_9_CONVERT_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_DISABLE_FSDEVICE_9_CONVERT_P00,    N_("Disable on-read support for P00 files on drive 9")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_FSDEVICE_9_CONVERT_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_FSDEVICE_9_CONVERT_P00_DE, "On-read Untersttzung fr P00 Dateien auf Laufwerk 9 deaktivieren"},
/* es */ {IDCLS_DISABLE_FSDEVICE_9_CONVERT_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_FSDEVICE_9_CONVERT_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_FSDEVICE_9_CONVERT_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_FSDEVICE_9_CONVERT_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_FSDEVICE_9_CONVERT_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_FSDEVICE_9_CONVERT_P00_NL, "Ondersteuning voor het lezen van P00 bestanden voor drive 9 uitschakelen"},
/* pl */ {IDCLS_DISABLE_FSDEVICE_9_CONVERT_P00_PL, "Wycz obsug plikw P00 przy odczycie z napdu 9"},
/* ru */ {IDCLS_DISABLE_FSDEVICE_9_CONVERT_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_FSDEVICE_9_CONVERT_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_FSDEVICE_9_CONVERT_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_ENABLE_FSDEVICE_10_CONVERT_P00,    N_("Enable on-read support for P00 files on drive 10")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_FSDEVICE_10_CONVERT_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_FSDEVICE_10_CONVERT_P00_DE, "On-read Untersttzung fr P00 Dateien auf Laufwerk 10 aktivieren"},
/* es */ {IDCLS_ENABLE_FSDEVICE_10_CONVERT_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_FSDEVICE_10_CONVERT_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_FSDEVICE_10_CONVERT_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_FSDEVICE_10_CONVERT_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_FSDEVICE_10_CONVERT_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_FSDEVICE_10_CONVERT_P00_NL, "Ondersteuning voor het lezen van P00 bestanden voor drive 10 inschakelen"},
/* pl */ {IDCLS_ENABLE_FSDEVICE_10_CONVERT_P00_PL, "Wcz obsug plikw P00 przy odczycie z napdu 10"},
/* ru */ {IDCLS_ENABLE_FSDEVICE_10_CONVERT_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_FSDEVICE_10_CONVERT_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_FSDEVICE_10_CONVERT_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_DISABLE_FSDEVICE_10_CONVERT_P00,    N_("Disable on-read support for P00 files on drive 10")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_FSDEVICE_10_CONVERT_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_FSDEVICE_10_CONVERT_P00_DE, "On-read Untersttzung fr P00 Dateien auf Laufwerk 10 deaktivieren"},
/* es */ {IDCLS_DISABLE_FSDEVICE_10_CONVERT_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_FSDEVICE_10_CONVERT_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_FSDEVICE_10_CONVERT_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_FSDEVICE_10_CONVERT_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_FSDEVICE_10_CONVERT_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_FSDEVICE_10_CONVERT_P00_NL, "Ondersteuning voor het lezen van P00 bestanden voor drive 10 uitschakelen"},
/* pl */ {IDCLS_DISABLE_FSDEVICE_10_CONVERT_P00_PL, "Wycz obsug plikw P00 przy odczycie z napdu 10"},
/* ru */ {IDCLS_DISABLE_FSDEVICE_10_CONVERT_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_FSDEVICE_10_CONVERT_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_FSDEVICE_10_CONVERT_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_ENABLE_FSDEVICE_11_CONVERT_P00,    N_("Enable on-read support for P00 files on drive 11")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_FSDEVICE_11_CONVERT_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_FSDEVICE_11_CONVERT_P00_DE, "On-read Untersttzung fr P00 Dateien auf Laufwerk 11 aktivieren"},
/* es */ {IDCLS_ENABLE_FSDEVICE_11_CONVERT_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_FSDEVICE_11_CONVERT_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_FSDEVICE_11_CONVERT_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_FSDEVICE_11_CONVERT_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_FSDEVICE_11_CONVERT_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_FSDEVICE_11_CONVERT_P00_NL, "Ondersteuning voor het lezen van P00 bestanden voor drive 11 inschakelen"},
/* pl */ {IDCLS_ENABLE_FSDEVICE_11_CONVERT_P00_PL, "Wcz obsug plikw P00 przy odczycie z napdu 11"},
/* ru */ {IDCLS_ENABLE_FSDEVICE_11_CONVERT_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_FSDEVICE_11_CONVERT_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_FSDEVICE_11_CONVERT_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_DISABLE_FSDEVICE_11_CONVERT_P00,    N_("Disable on-read support for P00 files on drive 11")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_FSDEVICE_11_CONVERT_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_FSDEVICE_11_CONVERT_P00_DE, "On-read Untersttzung fr P00 Dateien auf Laufwerk 11 deaktivieren"},
/* es */ {IDCLS_DISABLE_FSDEVICE_11_CONVERT_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_FSDEVICE_11_CONVERT_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_FSDEVICE_11_CONVERT_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_FSDEVICE_11_CONVERT_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_FSDEVICE_11_CONVERT_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_FSDEVICE_11_CONVERT_P00_NL, "Ondersteuning voor het lezen van P00 bestanden voor drive 11 uitschakelen"},
/* pl */ {IDCLS_DISABLE_FSDEVICE_11_CONVERT_P00_PL, "Wycz obsug plikw P00 przy odczycie z napdu 11"},
/* ru */ {IDCLS_DISABLE_FSDEVICE_11_CONVERT_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_FSDEVICE_11_CONVERT_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_FSDEVICE_11_CONVERT_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_ENABLE_FSDEVICE_8_SAVE_P00,    N_("Enable saving of P00 files on drive 8")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_FSDEVICE_8_SAVE_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_FSDEVICE_8_SAVE_P00_DE, "Speichern von P00 Dateien auf Laufwerk 8 aktivieren"},
/* es */ {IDCLS_ENABLE_FSDEVICE_8_SAVE_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_FSDEVICE_8_SAVE_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_FSDEVICE_8_SAVE_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_FSDEVICE_8_SAVE_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_FSDEVICE_8_SAVE_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_FSDEVICE_8_SAVE_P00_NL, "Opslaan van P00 bestanden voor drive 8 inschakelen"},
/* pl */ {IDCLS_ENABLE_FSDEVICE_8_SAVE_P00_PL, "Wcz zapis plikw P00 w napdzie 8"},
/* ru */ {IDCLS_ENABLE_FSDEVICE_8_SAVE_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_FSDEVICE_8_SAVE_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_FSDEVICE_8_SAVE_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_DISABLE_FSDEVICE_8_SAVE_P00,    N_("Disable saving of P00 files on drive 8")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_FSDEVICE_8_SAVE_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_FSDEVICE_8_SAVE_P00_DE, "Speichern von P00 Dateien auf Laufwerk 8 deaktivieren"},
/* es */ {IDCLS_DISABLE_FSDEVICE_8_SAVE_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_FSDEVICE_8_SAVE_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_FSDEVICE_8_SAVE_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_FSDEVICE_8_SAVE_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_FSDEVICE_8_SAVE_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_FSDEVICE_8_SAVE_P00_NL, "Opslaan van P00 bestanden voor drive 8 uitschakelen"},
/* pl */ {IDCLS_DISABLE_FSDEVICE_8_SAVE_P00_PL, "Wycz zapis plikw P00 w napdzie 8"},
/* ru */ {IDCLS_DISABLE_FSDEVICE_8_SAVE_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_FSDEVICE_8_SAVE_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_FSDEVICE_8_SAVE_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_ENABLE_FSDEVICE_9_SAVE_P00,    N_("Enable saving of P00 files on drive 9")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_FSDEVICE_9_SAVE_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_FSDEVICE_9_SAVE_P00_DE, "Speichern von P00 Dateien auf Laufwerk 9 aktivieren"},
/* es */ {IDCLS_ENABLE_FSDEVICE_9_SAVE_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_FSDEVICE_9_SAVE_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_FSDEVICE_9_SAVE_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_FSDEVICE_9_SAVE_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_FSDEVICE_9_SAVE_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_FSDEVICE_9_SAVE_P00_NL, "Opslaan van P00 bestanden voor drive 9 inschakelen"},
/* pl */ {IDCLS_ENABLE_FSDEVICE_9_SAVE_P00_PL, "Wcz zapis plikw P00 w napdzie 9"},
/* ru */ {IDCLS_ENABLE_FSDEVICE_9_SAVE_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_FSDEVICE_9_SAVE_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_FSDEVICE_9_SAVE_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_DISABLE_FSDEVICE_9_SAVE_P00,    N_("Disable saving of P00 files on drive 9")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_FSDEVICE_9_SAVE_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_FSDEVICE_9_SAVE_P00_DE, "Speichern von P00 Dateien auf Laufwerk 9 deaktivieren"},
/* es */ {IDCLS_DISABLE_FSDEVICE_9_SAVE_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_FSDEVICE_9_SAVE_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_FSDEVICE_9_SAVE_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_FSDEVICE_9_SAVE_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_FSDEVICE_9_SAVE_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_FSDEVICE_9_SAVE_P00_NL, "Opslaan van P00 bestanden voor drive 9 uitschakelen"},
/* pl */ {IDCLS_DISABLE_FSDEVICE_9_SAVE_P00_PL, "Wycz zapis plikw P00 w napdzie 9"},
/* ru */ {IDCLS_DISABLE_FSDEVICE_9_SAVE_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_FSDEVICE_9_SAVE_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_FSDEVICE_9_SAVE_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_ENABLE_FSDEVICE_10_SAVE_P00,    N_("Enable saving of P00 files on drive 10")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_FSDEVICE_10_SAVE_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_FSDEVICE_10_SAVE_P00_DE, "Speichern von P00 Dateien auf Laufwerk 10 aktivieren"},
/* es */ {IDCLS_ENABLE_FSDEVICE_10_SAVE_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_FSDEVICE_10_SAVE_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_FSDEVICE_10_SAVE_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_FSDEVICE_10_SAVE_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_FSDEVICE_10_SAVE_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_FSDEVICE_10_SAVE_P00_NL, "Opslaan van P00 bestanden voor drive 10 inschakelen"},
/* pl */ {IDCLS_ENABLE_FSDEVICE_10_SAVE_P00_PL, "Wcz zapis plikw P00 w napdzie 10"},
/* ru */ {IDCLS_ENABLE_FSDEVICE_10_SAVE_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_FSDEVICE_10_SAVE_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_FSDEVICE_10_SAVE_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_DISABLE_FSDEVICE_10_SAVE_P00,    N_("Disable saving of P00 files on drive 10")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_FSDEVICE_10_SAVE_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_FSDEVICE_10_SAVE_P00_DE, "Speichern von P00 Dateien auf Laufwerk 10 deaktivieren"},
/* es */ {IDCLS_DISABLE_FSDEVICE_10_SAVE_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_FSDEVICE_10_SAVE_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_FSDEVICE_10_SAVE_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_FSDEVICE_10_SAVE_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_FSDEVICE_10_SAVE_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_FSDEVICE_10_SAVE_P00_NL, "Opslaan van P00 bestanden voor drive 10 uitschakelen"},
/* pl */ {IDCLS_DISABLE_FSDEVICE_10_SAVE_P00_PL, "Wycz zapis plikw P00 w napdzie 10"},
/* ru */ {IDCLS_DISABLE_FSDEVICE_10_SAVE_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_FSDEVICE_10_SAVE_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_FSDEVICE_10_SAVE_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_ENABLE_FSDEVICE_11_SAVE_P00,    N_("Enable saving of P00 files on drive 11")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_FSDEVICE_11_SAVE_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_FSDEVICE_11_SAVE_P00_DE, "Speichern von P00 Dateien auf Laufwerk 11 aktivieren"},
/* es */ {IDCLS_ENABLE_FSDEVICE_11_SAVE_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_FSDEVICE_11_SAVE_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_FSDEVICE_11_SAVE_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_FSDEVICE_11_SAVE_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_FSDEVICE_11_SAVE_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_FSDEVICE_11_SAVE_P00_NL, "Opslaan van P00 bestanden voor drive 11 inschakelen"},
/* pl */ {IDCLS_ENABLE_FSDEVICE_11_SAVE_P00_PL, "Wcz zapis plikw P00 w napdzie 11"},
/* ru */ {IDCLS_ENABLE_FSDEVICE_11_SAVE_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_FSDEVICE_11_SAVE_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_FSDEVICE_11_SAVE_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_DISABLE_FSDEVICE_11_SAVE_P00,    N_("Disable saving of P00 files on drive 11")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_FSDEVICE_11_SAVE_P00_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_FSDEVICE_11_SAVE_P00_DE, "Speichern von P00 Dateien auf Laufwerk 11 deaktivieren"},
/* es */ {IDCLS_DISABLE_FSDEVICE_11_SAVE_P00_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_FSDEVICE_11_SAVE_P00_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_FSDEVICE_11_SAVE_P00_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_FSDEVICE_11_SAVE_P00_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_FSDEVICE_11_SAVE_P00_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_FSDEVICE_11_SAVE_P00_NL, "Opslaan van P00 bestanden voor drive 11 uitschakelen"},
/* pl */ {IDCLS_DISABLE_FSDEVICE_11_SAVE_P00_PL, "Wycz zapis plikw P00 w napdzie 11"},
/* ru */ {IDCLS_DISABLE_FSDEVICE_11_SAVE_P00_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_FSDEVICE_11_SAVE_P00_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_FSDEVICE_11_SAVE_P00_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_ENABLE_FSDEVICE_8_HIDE_CBM,    N_("Hide CBM files (only show P00 files) for drive 8")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_FSDEVICE_8_HIDE_CBM_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_FSDEVICE_8_HIDE_CBM_DE, "Laufwerk 8 CBM Dateien ausblenden (nur P00 Dateien zeigen)"},
/* es */ {IDCLS_ENABLE_FSDEVICE_8_HIDE_CBM_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_FSDEVICE_8_HIDE_CBM_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_FSDEVICE_8_HIDE_CBM_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_FSDEVICE_8_HIDE_CBM_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_FSDEVICE_8_HIDE_CBM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_FSDEVICE_8_HIDE_CBM_NL, "Verberg CBM bestanden (toon alleen P00 bestanden) voor drive 8"},
/* pl */ {IDCLS_ENABLE_FSDEVICE_8_HIDE_CBM_PL, "Ukryj pliki CBM (pokazuj tylko pliki P00) dla napdu 8"},
/* ru */ {IDCLS_ENABLE_FSDEVICE_8_HIDE_CBM_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_FSDEVICE_8_HIDE_CBM_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_FSDEVICE_8_HIDE_CBM_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_DISABLE_FSDEVICE_8_HIDE_CBM,    N_("Do not hide CBM files (show all files) for drive 8")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_FSDEVICE_8_HIDE_CBM_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_FSDEVICE_8_HIDE_CBM_DE, "Laufwerk 8 alle Dateien zeigen (CBM Dateien nicht ausblenden)"},
/* es */ {IDCLS_DISABLE_FSDEVICE_8_HIDE_CBM_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_FSDEVICE_8_HIDE_CBM_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_FSDEVICE_8_HIDE_CBM_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_FSDEVICE_8_HIDE_CBM_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_FSDEVICE_8_HIDE_CBM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_FSDEVICE_8_HIDE_CBM_NL, "Verberg CBM bestanden niet (toon alle bestanden) voor drive 8"},
/* pl */ {IDCLS_DISABLE_FSDEVICE_8_HIDE_CBM_PL, "Nie ukrywaj plikw CBM (pokazuj wszystkie pliki) dla napdu 8"},
/* ru */ {IDCLS_DISABLE_FSDEVICE_8_HIDE_CBM_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_FSDEVICE_8_HIDE_CBM_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_FSDEVICE_8_HIDE_CBM_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_ENABLE_FSDEVICE_9_HIDE_CBM,    N_("Hide CBM files (only show P00 files) for drive 9")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_FSDEVICE_9_HIDE_CBM_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_FSDEVICE_9_HIDE_CBM_DE, "Laufwerk 9 CBM Dateien ausblenden (nur P00 Dateien zeigen)"},
/* es */ {IDCLS_ENABLE_FSDEVICE_9_HIDE_CBM_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_FSDEVICE_9_HIDE_CBM_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_FSDEVICE_9_HIDE_CBM_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_FSDEVICE_9_HIDE_CBM_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_FSDEVICE_9_HIDE_CBM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_FSDEVICE_9_HIDE_CBM_NL, "Verberg CBM bestanden (toon alleen P00 bestanden) voor drive 9"},
/* pl */ {IDCLS_ENABLE_FSDEVICE_9_HIDE_CBM_PL, "Ukryj pliki CBM (pokazuj tylko pliki P00) dla napdu 9"},
/* ru */ {IDCLS_ENABLE_FSDEVICE_9_HIDE_CBM_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_FSDEVICE_9_HIDE_CBM_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_FSDEVICE_9_HIDE_CBM_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_DISABLE_FSDEVICE_9_HIDE_CBM,    N_("Do not hide CBM files (show all files) for drive 9")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_FSDEVICE_9_HIDE_CBM_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_FSDEVICE_9_HIDE_CBM_DE, "Laufwerk 9 alle Dateien zeigen (CBM Dateien nicht ausblenden)"},
/* es */ {IDCLS_DISABLE_FSDEVICE_9_HIDE_CBM_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_FSDEVICE_9_HIDE_CBM_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_FSDEVICE_9_HIDE_CBM_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_FSDEVICE_9_HIDE_CBM_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_FSDEVICE_9_HIDE_CBM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_FSDEVICE_9_HIDE_CBM_NL, "Verberg CBM bestanden niet (toon alle bestanden) voor drive 9"},
/* pl */ {IDCLS_DISABLE_FSDEVICE_9_HIDE_CBM_PL, "Nie ukrywaj plikw CBM (pokazuj wszystkie pliki) dla napdu 9"},
/* ru */ {IDCLS_DISABLE_FSDEVICE_9_HIDE_CBM_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_FSDEVICE_9_HIDE_CBM_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_FSDEVICE_9_HIDE_CBM_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_ENABLE_FSDEVICE_10_HIDE_CBM,    N_("Hide CBM files (only show P00 files) for drive 10")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_FSDEVICE_10_HIDE_CBM_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_FSDEVICE_10_HIDE_CBM_DE, "Laufwerk 10 CBM Dateien ausblenden (nur P00 Dateien zeigen)"},
/* es */ {IDCLS_ENABLE_FSDEVICE_10_HIDE_CBM_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_FSDEVICE_10_HIDE_CBM_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_FSDEVICE_10_HIDE_CBM_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_FSDEVICE_10_HIDE_CBM_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_FSDEVICE_10_HIDE_CBM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_FSDEVICE_10_HIDE_CBM_NL, "Verberg CBM bestanden (toon alleen P00 bestanden) voor drive 10"},
/* pl */ {IDCLS_ENABLE_FSDEVICE_10_HIDE_CBM_PL, "Ukryj pliki CBM (pokazuj tylko pliki P00) dla napdu 10"},
/* ru */ {IDCLS_ENABLE_FSDEVICE_10_HIDE_CBM_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_FSDEVICE_10_HIDE_CBM_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_FSDEVICE_10_HIDE_CBM_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_DISABLE_FSDEVICE_10_HIDE_CBM,    N_("Do not hide CBM files (show all files) for drive 10")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_FSDEVICE_10_HIDE_CBM_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_FSDEVICE_10_HIDE_CBM_DE, "Laufwerk 10 alle Dateien zeigen (CBM Dateien nicht ausblenden)"},
/* es */ {IDCLS_DISABLE_FSDEVICE_10_HIDE_CBM_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_FSDEVICE_10_HIDE_CBM_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_FSDEVICE_10_HIDE_CBM_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_FSDEVICE_10_HIDE_CBM_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_FSDEVICE_10_HIDE_CBM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_FSDEVICE_10_HIDE_CBM_NL, "Verberg CBM bestanden niet (toon alle bestanden) voor drive 10"},
/* pl */ {IDCLS_DISABLE_FSDEVICE_10_HIDE_CBM_PL, "Nie ukrywaj plikw CBM (pokazuj wszystkie pliki) dla napdu 10"},
/* ru */ {IDCLS_DISABLE_FSDEVICE_10_HIDE_CBM_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_FSDEVICE_10_HIDE_CBM_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_FSDEVICE_10_HIDE_CBM_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_ENABLE_FSDEVICE_11_HIDE_CBM,    N_("Hide CBM files (only show P00 files) for drive 11")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_FSDEVICE_11_HIDE_CBM_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_FSDEVICE_11_HIDE_CBM_DE, "Laufwerk 11 CBM Dateien ausblenden (nur P00 Dateien zeigen)"},
/* es */ {IDCLS_ENABLE_FSDEVICE_11_HIDE_CBM_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_FSDEVICE_11_HIDE_CBM_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_FSDEVICE_11_HIDE_CBM_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_FSDEVICE_11_HIDE_CBM_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_FSDEVICE_11_HIDE_CBM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_FSDEVICE_11_HIDE_CBM_NL, "Verberg CBM bestanden (toon alleen P00 bestanden) voor drive 11"},
/* pl */ {IDCLS_ENABLE_FSDEVICE_11_HIDE_CBM_PL, "Ukryj pliki CBM (pokazuj tylko pliki P00) dla napdu 11"},
/* ru */ {IDCLS_ENABLE_FSDEVICE_11_HIDE_CBM_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_FSDEVICE_11_HIDE_CBM_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_FSDEVICE_11_HIDE_CBM_TR, ""},  /* fuzzy */
#endif

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_DISABLE_FSDEVICE_11_HIDE_CBM,    N_("Do not hide CBM files (show all files) for drive 11")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_FSDEVICE_11_HIDE_CBM_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_FSDEVICE_11_HIDE_CBM_DE, "Laufwerk 11 alle Dateien zeigen (CBM Dateien nicht ausblenden)"},
/* es */ {IDCLS_DISABLE_FSDEVICE_11_HIDE_CBM_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_FSDEVICE_11_HIDE_CBM_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_FSDEVICE_11_HIDE_CBM_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_FSDEVICE_11_HIDE_CBM_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_FSDEVICE_11_HIDE_CBM_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_FSDEVICE_11_HIDE_CBM_NL, "Verberg CBM bestanden niet (toon alle bestanden) voor drive 11"},
/* pl */ {IDCLS_DISABLE_FSDEVICE_11_HIDE_CBM_PL, "Nie ukrywaj plikw CBM (pokazuj wszystkie pliki) dla napdu 11"},
/* ru */ {IDCLS_DISABLE_FSDEVICE_11_HIDE_CBM_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_FSDEVICE_11_HIDE_CBM_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_FSDEVICE_11_HIDE_CBM_TR, ""},  /* fuzzy */
#endif

/* gfxoutputdrv/ffmpegdrv.c */
/* en */ {IDCLS_SET_AUDIO_STREAM_BITRATE,    N_("Set bitrate for audio stream in media file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_AUDIO_STREAM_BITRATE_DA, "Angiv bitrate for lydstrm i mediefil"},
/* de */ {IDCLS_SET_AUDIO_STREAM_BITRATE_DE, "Bitrate fr Audio Stream fr Media Datei setzen"},
/* es */ {IDCLS_SET_AUDIO_STREAM_BITRATE_ES, "Seleccionar velocidad muestreo para flujo audio en fichero media"},
/* fr */ {IDCLS_SET_AUDIO_STREAM_BITRATE_FR, "Rgler le bitrate audio du fichier mdia"},
/* hu */ {IDCLS_SET_AUDIO_STREAM_BITRATE_HU, "Adja meg az audi bitrtt a mdia fjlhoz"},
/* it */ {IDCLS_SET_AUDIO_STREAM_BITRATE_IT, "Imposta il bitrate del flusso audio nel file multimediale"},
/* ko */ {IDCLS_SET_AUDIO_STREAM_BITRATE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_AUDIO_STREAM_BITRATE_NL, "Zet de bitrate voor het audiogedeelte van het mediabestand"},
/* pl */ {IDCLS_SET_AUDIO_STREAM_BITRATE_PL, "Okrel szybko transmisji strumienia audio w pliku multimediw"},
/* ru */ {IDCLS_SET_AUDIO_STREAM_BITRATE_RU, "Set bitrate for audio stream in media file"},
/* sv */ {IDCLS_SET_AUDIO_STREAM_BITRATE_SV, "Ange bithastighet fr ljudstrm i mediafil"},
/* tr */ {IDCLS_SET_AUDIO_STREAM_BITRATE_TR, "Ses ak iin ortam dosyasndaki bithz'n ayarla"},
#endif

/* gfxoutputdrv/ffmpegdrv.c */
/* en */ {IDCLS_SET_VIDEO_STREAM_BITRATE,    N_("Set bitrate for video stream in media file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_VIDEO_STREAM_BITRATE_DA, "Angiv bitrate for videostrm i mediefil"},
/* de */ {IDCLS_SET_VIDEO_STREAM_BITRATE_DE, "Bitrate fr Video Stream fr Media Datei setzen"},
/* es */ {IDCLS_SET_VIDEO_STREAM_BITRATE_ES, "Seleccionar velocidad muestreo para flujo vdeo en fichero media"},
/* fr */ {IDCLS_SET_VIDEO_STREAM_BITRATE_FR, "Rgler le bitrate vido du fichier mdia"},
/* hu */ {IDCLS_SET_VIDEO_STREAM_BITRATE_HU, "Adja meg az vide bitrtt a mdia fjlhoz"},
/* it */ {IDCLS_SET_VIDEO_STREAM_BITRATE_IT, "Imposta il bitrate per il flusso video nel file multimediale"},
/* ko */ {IDCLS_SET_VIDEO_STREAM_BITRATE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_VIDEO_STREAM_BITRATE_NL, "Zet de bitrate voor het videogedeelte van het mediabestand"},
/* pl */ {IDCLS_SET_VIDEO_STREAM_BITRATE_PL, "Okrel szybko transmisji strumienia wideo w pliku multimediw"},
/* ru */ {IDCLS_SET_VIDEO_STREAM_BITRATE_RU, "Set bitrate for video stream in media file"},
/* sv */ {IDCLS_SET_VIDEO_STREAM_BITRATE_SV, "Ange bithastighet fr videostrm i mediafil"},
/* tr */ {IDCLS_SET_VIDEO_STREAM_BITRATE_TR, "Grnt ak iin ortam dosyasndaki bithz'n ayarla"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_PET_MODEL,    N_("Specify PET model to emulate. (2001/3008/3016/3032/3032B/4016/4032/4032B/8032/8096/8296/SuperPET)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_PET_MODEL_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_PET_MODEL_DE, "PET model fr Emulation whlen. (2001/3008/3016/3032/3032B/4016/4032/4032B/8032/8096/8296/SuperPET)"},
/* es */ {IDCLS_SPECIFY_PET_MODEL_ES, "Especificar modelo PET a emular. (2001/3008/3016/3032/3032B/4016/4032/4032B/8032/8096/8296/SuperPET)"},
/* fr */ {IDCLS_SPECIFY_PET_MODEL_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_PET_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_PET_MODEL_IT, "Specifica il modello PET da emulare. (2001/3008/3016/3032/3032B/4016/4032/4032B/8032/8096/8296/SuperPET)"},
/* ko */ {IDCLS_SPECIFY_PET_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_PET_MODEL_NL, "Geef PET model om te emuleren. (2001/3008/3016/3032/3032B/4016/4032/4032B/8032/8096/8296/SuperPET)"},
/* pl */ {IDCLS_SPECIFY_PET_MODEL_PL, "Wybierz emulowany model PET. (2001/3008/3016/3032/3032B/4016/4032/4032B/8032/8096/8296/SuperPET)"},
/* ru */ {IDCLS_SPECIFY_PET_MODEL_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_PET_MODEL_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_PET_MODEL_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_EDITOR_ROM_NAME,    N_("Specify name of Editor ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_EDITOR_ROM_NAME_DA, "Angiv navn p Editor-ROM-image"},
/* de */ {IDCLS_SPECIFY_EDITOR_ROM_NAME_DE, "Name fr Editor ROM Imagedatei whlen"},
/* es */ {IDCLS_SPECIFY_EDITOR_ROM_NAME_ES, "Especificar nombre imagen editor ROM"},
/* fr */ {IDCLS_SPECIFY_EDITOR_ROM_NAME_FR, "Spcifier le nom de limage ROM Editor"},
/* hu */ {IDCLS_SPECIFY_EDITOR_ROM_NAME_HU, "Adja meg a szerkeszt ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_EDITOR_ROM_NAME_IT, "Specifica il nome immagine della Editor ROM"},
/* ko */ {IDCLS_SPECIFY_EDITOR_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_EDITOR_ROM_NAME_NL, "Geef naam van het Editor ROM bestand"},
/* pl */ {IDCLS_SPECIFY_EDITOR_ROM_NAME_PL, "Okrel nazw obrazu ROM Editor"},
/* ru */ {IDCLS_SPECIFY_EDITOR_ROM_NAME_RU, "Specify name of Editor ROM image"},
/* sv */ {IDCLS_SPECIFY_EDITOR_ROM_NAME_SV, "Ange namn p Editor-ROM-avbildning"},
/* tr */ {IDCLS_SPECIFY_EDITOR_ROM_NAME_TR, "Editor ROM imajnn ismini belirt"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_4K_ROM_9XXX_NAME,    N_("Specify 4K extension ROM name at $9***")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_4K_ROM_9XXX_NAME_DA, "Angiv navn p 4K-udviddelses-ROM p $9***"},
/* de */ {IDCLS_SPECIFY_4K_ROM_9XXX_NAME_DE, "4K Erweiterungs ROM Dateiname bei $9*** whlen"},
/* es */ {IDCLS_SPECIFY_4K_ROM_9XXX_NAME_ES, "Especificar nombre extensin ROM 4KB en $9***"},
/* fr */ {IDCLS_SPECIFY_4K_ROM_9XXX_NAME_FR, "Spcifier le nom de l'extension ROM 4K  $9***"},
/* hu */ {IDCLS_SPECIFY_4K_ROM_9XXX_NAME_HU, "Adja meg a $9*** cm 4K ROM kiterjeszts nevt"},
/* it */ {IDCLS_SPECIFY_4K_ROM_9XXX_NAME_IT, "Specifica il nome della ROM di estensione di 4k a $9***"},
/* ko */ {IDCLS_SPECIFY_4K_ROM_9XXX_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_4K_ROM_9XXX_NAME_NL, "Geef naam van het 4K uitbreiding ROM bestand op adres $9***"},
/* pl */ {IDCLS_SPECIFY_4K_ROM_9XXX_NAME_PL, "Okrel nazw rozszerzenia 4K ROM w $9***"},
/* ru */ {IDCLS_SPECIFY_4K_ROM_9XXX_NAME_RU, "Specify 4K extension ROM name at $9***"},
/* sv */ {IDCLS_SPECIFY_4K_ROM_9XXX_NAME_SV, "Ange namn p 4K-utknings-ROM p $9***"},
/* tr */ {IDCLS_SPECIFY_4K_ROM_9XXX_NAME_TR, "$9*** adresindeki 4K uzants ROM ismini belirt"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_4K_ROM_AXXX_NAME,    N_("Specify 4K extension ROM name at $A***")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_4K_ROM_AXXX_NAME_DA, "Angiv navn p 4K-udviddelses-ROM p $A***"},
/* de */ {IDCLS_SPECIFY_4K_ROM_AXXX_NAME_DE, "4K Erweiterungs ROM Dateiname bei $A*** whlen"},
/* es */ {IDCLS_SPECIFY_4K_ROM_AXXX_NAME_ES, "Especificar nombre extensin ROM 4KB en $A***"},
/* fr */ {IDCLS_SPECIFY_4K_ROM_AXXX_NAME_FR, "Spcifier le nom de l'extension ROM 4K  $A***"},
/* hu */ {IDCLS_SPECIFY_4K_ROM_AXXX_NAME_HU, "Adja meg a $A*** cm 4K ROM kiterjeszts nevt"},
/* it */ {IDCLS_SPECIFY_4K_ROM_AXXX_NAME_IT, "Specifica il nome della ROM di estensione di 4k a $A***"},
/* ko */ {IDCLS_SPECIFY_4K_ROM_AXXX_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_4K_ROM_AXXX_NAME_NL, "Geef naam van het 4K uitbreiding ROM bestand op adres $A***"},
/* pl */ {IDCLS_SPECIFY_4K_ROM_AXXX_NAME_PL, "Okrel nazw rozszerzenia 4K ROM w $A***"},
/* ru */ {IDCLS_SPECIFY_4K_ROM_AXXX_NAME_RU, "Specify 4K extension ROM name at $A***"},
/* sv */ {IDCLS_SPECIFY_4K_ROM_AXXX_NAME_SV, "Ange namn p 4K-utknings-ROM p $A***"},
/* tr */ {IDCLS_SPECIFY_4K_ROM_AXXX_NAME_TR, "$A*** adresindeki 4K uzants ROM ismini belirt"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_4K_ROM_BXXX_NAME,    N_("Specify 4K extension ROM name at $B***")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_4K_ROM_BXXX_NAME_DA, "Angiv navn p 4K-udviddelses-ROM p $B***"},
/* de */ {IDCLS_SPECIFY_4K_ROM_BXXX_NAME_DE, "4K Erweiterungs ROM Dateiname bei $B*** whlen"},
/* es */ {IDCLS_SPECIFY_4K_ROM_BXXX_NAME_ES, "Especificar nombre extensin ROM 4KB en $B***"},
/* fr */ {IDCLS_SPECIFY_4K_ROM_BXXX_NAME_FR, "Spcifier le nom de l'extension ROM 4K  $B***"},
/* hu */ {IDCLS_SPECIFY_4K_ROM_BXXX_NAME_HU, "Adja meg a $B*** cm 4K ROM kiterjeszts nevt"},
/* it */ {IDCLS_SPECIFY_4K_ROM_BXXX_NAME_IT, "Specifica il nome della ROM di estensione di 4k a $B***"},
/* ko */ {IDCLS_SPECIFY_4K_ROM_BXXX_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_4K_ROM_BXXX_NAME_NL, "Geef naam van het 4K uitbreiding ROM bestand op adres $B***"},
/* pl */ {IDCLS_SPECIFY_4K_ROM_BXXX_NAME_PL, "Okrel nazw rozszerzenia 4K ROM w $B***"},
/* ru */ {IDCLS_SPECIFY_4K_ROM_BXXX_NAME_RU, "Specify 4K extension ROM name at $B***"},
/* sv */ {IDCLS_SPECIFY_4K_ROM_BXXX_NAME_SV, "Ange namn p 4K-utknings-ROM p $B***"},
/* tr */ {IDCLS_SPECIFY_4K_ROM_BXXX_NAME_TR, "$B*** adresindeki 4K uzants ROM ismini belirt"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_9000,    N_("Enable PET8296 4K RAM mapping at $9***")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_DA, "Aktivr PET8296 4K-RAM-mapping p $9***"},
/* de */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_DE, "PET8296 4K RAM Zuordnung bei $9*** aktivieren"},
/* es */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_ES, "Permitir mapeado 4KB de RAM PET8296 en $9***"},
/* fr */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_FR, "Activer l'extension PET8296 4K  $9***"},
/* hu */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_HU, "PET8296 4K RAM engedlyezse a $9*** cmen"},
/* it */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_IT, "Attiva la mappatura della RAM di 4K del PET8296 a $9***"},
/* ko */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_NL, "PET8296 4K RAM op adres $9*** inschakelen"},
/* pl */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_PL, "Wcz mapowanie 4K RAM PET8296 w $9***"},
/* ru */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_RU, "Enable PET8296 4K RAM mapping at $9***"},
/* sv */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_SV, "Aktivera PET8296 4K-RAM-mappning p $9***"},
/* tr */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_TR, "$9*** adresindeki PET8296 4K RAM eletirmesini aktif et"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_9000,    N_("Disable PET8296 4K RAM mapping at $9***")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_DA, "Deaktivr PET8296 4K-RAM-mapping p $9***"},
/* de */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_DE, "PET8296 4K RAM Zuordnung bei $9*** deaktivieren"},
/* es */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_ES, "Deshabilitar mapeado 4KB de RAM PET8296 en $9***"},
/* fr */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_FR, "Dsactiver l'extension PET8296 4K  $9***"},
/* hu */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_HU, "PET8296 4K RAM tiltsa a $9*** cmen"},
/* it */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_IT, "Disattiva la mappatura della RAM di 4K del PET8296 a $9***"},
/* ko */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_NL, "PET8296 4K RAM op adres $9*** uitschakelen"},
/* pl */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_PL, "Wycz mapowanie 4K RAM PET8296 w $9***"},
/* ru */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_RU, "Disable PET8296 4K RAM mapping at $9***"},
/* sv */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_SV, "Inaktivera PET8296 4K-RAM-mappning p $9***"},
/* tr */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_TR, "$9*** adresindeki PET8296 4K RAM eletirmesini pasifletir"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_A000,    N_("Enable PET8296 4K RAM mapping at $A***")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_DA, "Aktivr PET8296 4K-RAM-mapping p $A***"},
/* de */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_DE, "PET8296 4K RAM Zuordnung bei $A*** aktivieren"},
/* es */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_ES, "Permitir mapeado 4KB de RAM PET8296 en $A***"},
/* fr */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_FR, "Activer l'extension PET8296 4K  $A***"},
/* hu */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_HU, "PET8296 4K RAM engedlyezse a $A*** cmen"},
/* it */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_IT, "Attiva la mappatura della RAM di 4K del PET8296 a $A***"},
/* ko */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_NL, "PET8296 4K RAM op adres $A*** inschakelen"},
/* pl */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_PL, "Wcz mapowanie 4K RAM PET8296 w $A***"},
/* ru */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_RU, "Enable PET8296 4K RAM mapping at $A***"},
/* sv */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_SV, "Aktivera PET8296 4K-RAM-mappning p $A***"},
/* tr */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_TR, "$A*** adresindeki PET8296 4K RAM eletirmesini aktif et"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_A000,    N_("Disable PET8296 4K RAM mapping at $A***")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_DA, "Deaktivr PET8296 4K-RAM-mapping p $A***"},
/* de */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_DE, "PET8296 4K RAM Zuordnung bei $A*** deaktivieren"},
/* es */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_ES, "Deshabilitar mapeado 4KB de RAM PET8296 en $A***"},
/* fr */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_FR, "Dsactiver l'extension PET8296 4K  $A***"},
/* hu */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_HU, "PET8296 4K RAM tiltsa a $A*** cmen"},
/* it */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_IT, "Disattiva la mappatura della RAM di 4K del PET8296 a $A***"},
/* ko */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_NL, "PET8296 4K RAM op adres $A*** uitschakelen"},
/* pl */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_PL, "Wycz mapowanie 4K RAM PET8296 w $A***"},
/* ru */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_RU, "Disable PET8296 4K RAM mapping at $A***"},
/* sv */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_SV, "Inaktivera PET8296 4K-RAM-mappning p $A***"},
/* tr */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_TR, "$A*** adresindeki PET8296 4K RAM eletirmesini pasifletir"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_ENABLE_SUPERPET_IO,    N_("Enable SuperPET I/O")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_SUPERPET_IO_DA, "Aktivr SuperPET-I/O"},
/* de */ {IDCLS_ENABLE_SUPERPET_IO_DE, "SuperPET I/O aktivieren"},
/* es */ {IDCLS_ENABLE_SUPERPET_IO_ES, "Permitir entrada/salida SuperPET"},
/* fr */ {IDCLS_ENABLE_SUPERPET_IO_FR, "Activer les E/S SuperPET"},
/* hu */ {IDCLS_ENABLE_SUPERPET_IO_HU, "SuperPET I/O engedlyezse"},
/* it */ {IDCLS_ENABLE_SUPERPET_IO_IT, "Attiva l'I/O del SuperPET"},
/* ko */ {IDCLS_ENABLE_SUPERPET_IO_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_SUPERPET_IO_NL, "SuperPET I/O inschakelen"},
/* pl */ {IDCLS_ENABLE_SUPERPET_IO_PL, "Wcz we/wy SuperPET"},
/* ru */ {IDCLS_ENABLE_SUPERPET_IO_RU, "Enable SuperPET I/O"},
/* sv */ {IDCLS_ENABLE_SUPERPET_IO_SV, "Aktivera SuperPET-I/O"},
/* tr */ {IDCLS_ENABLE_SUPERPET_IO_TR, "SuperPET G/' aktif et"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_DISABLE_SUPERPET_IO,    N_("Disable SuperPET I/O")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_SUPERPET_IO_DA, "Deaktivr SuperPET-I/O"},
/* de */ {IDCLS_DISABLE_SUPERPET_IO_DE, "SuperPET I/O deaktivieren"},
/* es */ {IDCLS_DISABLE_SUPERPET_IO_ES, "Deshabilitar entrada/salida SuperPET"},
/* fr */ {IDCLS_DISABLE_SUPERPET_IO_FR, "Dsactiver les E/S SuperPET"},
/* hu */ {IDCLS_DISABLE_SUPERPET_IO_HU, "SuperPET I/O tiltsa"},
/* it */ {IDCLS_DISABLE_SUPERPET_IO_IT, "Disattiva l'I/O del SuperPET"},
/* ko */ {IDCLS_DISABLE_SUPERPET_IO_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_SUPERPET_IO_NL, "SuperPET I/O uitschakelen"},
/* pl */ {IDCLS_DISABLE_SUPERPET_IO_PL, "Wycz we/wy SuperPET"},
/* ru */ {IDCLS_DISABLE_SUPERPET_IO_RU, "Disable SuperPET I/O"},
/* sv */ {IDCLS_DISABLE_SUPERPET_IO_SV, "Inaktivera SuperPET-I/O"},
/* tr */ {IDCLS_DISABLE_SUPERPET_IO_TR, "SuperPET G/' pasifletir"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_ENABLE_ROM_1_KERNAL_PATCHES,    N_("Enable ROM 1 Kernal patches")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_DA, "Aktivr ROM 1 kernendringer"},
/* de */ {IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_DE, "ROM 1 Kernal patches aktivieren"},
/* es */ {IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_ES, "Permitir parches ROM 1 Kernal"},
/* fr */ {IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_FR, "Activer les patches ROM 1 Kernal"},
/* hu */ {IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_HU, "ROM 1 Kernal foltozs engedlyezse"},
/* it */ {IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_IT, "Attiva le patch del Kernal della ROM 1"},
/* ko */ {IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_NL, "ROM 1 Kernalverbeteringen inschakelen"},
/* pl */ {IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_PL, "Wcz atki Kernala ROM 1"},
/* ru */ {IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_RU, "Enable ROM 1 Kernal patches"},
/* sv */ {IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_SV, "Aktivera ROM 1-Kernalpatchar"},
/* tr */ {IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_TR, "ROM 1 Kernal yamalarn aktif et"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_DISABLE_ROM_1_KERNAL_PATCHES,    N_("Disable ROM 1 Kernal patches")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_DA, "Deaktivr ROM 1 kernendringer"},
/* de */ {IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_DE, "ROM 1 Kernal patches deaktivieren"},
/* es */ {IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_ES, "Deshabilitar parches ROM 1 Kernal"},
/* fr */ {IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_FR, "Dsactiver les patches ROM 1 Kernal"},
/* hu */ {IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_HU, "ROM 1 Kernal foltozs tiltsa"},
/* it */ {IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_IT, "Disattiva le patch del Kernal della ROM 1"},
/* ko */ {IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_NL, "ROM 1 Kernalverbeteringen uitschakelen"},
/* pl */ {IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_PL, "Wycz atki Kernala ROM 1"},
/* ru */ {IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_RU, "Disable ROM 1 Kernal patches"},
/* sv */ {IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_SV, "Inaktivera ROM 1-Kernalpatchar"},
/* tr */ {IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_TR, "ROM 1 Kernal yamalarn pasifletir"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SWITCH_UPPER_LOWER_CHARSET,    N_("Switch upper/lower case charset")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SWITCH_UPPER_LOWER_CHARSET_DA, "Skift mellem store og sm bogstaver"},
/* de */ {IDCLS_SWITCH_UPPER_LOWER_CHARSET_DE, "Wechsel Gro-/Kleinschreibung Zeichensatz"},
/* es */ {IDCLS_SWITCH_UPPER_LOWER_CHARSET_ES, "Intercambiar maysculas/minscula"},
/* fr */ {IDCLS_SWITCH_UPPER_LOWER_CHARSET_FR, "Inverser le charset majuscule et minuscule"},
/* hu */ {IDCLS_SWITCH_UPPER_LOWER_CHARSET_HU, "Vlts nagy-/kisbets karakterkszletre"},
/* it */ {IDCLS_SWITCH_UPPER_LOWER_CHARSET_IT, "Scambia il set di caratteri maiuscolo/minuscolo"},
/* ko */ {IDCLS_SWITCH_UPPER_LOWER_CHARSET_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SWITCH_UPPER_LOWER_CHARSET_NL, "Schakel tussen grote/kleine letters"},
/* pl */ {IDCLS_SWITCH_UPPER_LOWER_CHARSET_PL, "Przecz zestaw wielkich/maych znakw"},
/* ru */ {IDCLS_SWITCH_UPPER_LOWER_CHARSET_RU, " / "},
/* sv */ {IDCLS_SWITCH_UPPER_LOWER_CHARSET_SV, "Vxla sm/stora bokstver i teckengeneratorn"},
/* tr */ {IDCLS_SWITCH_UPPER_LOWER_CHARSET_TR, "Byk/kk harf karakter seti deitir"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET,    N_("Do not switch upper/lower case charset")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_DA, "Skift ikke mellem store og sm bogstaver"},
/* de */ {IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_DE, "Kein Wechsel Gro-/Kleinschreibung Zeichensatz"},
/* es */ {IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_ES, "No intercambiar maysculas/minsculas"},
/* fr */ {IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_FR, "Ne pas inverser le charset majuscule et minuscule"},
/* hu */ {IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_HU, "Ne vltson a nagy-/kisbets karakterkszletre"},
/* it */ {IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_IT, "Non scambiare il set di caratteri maiuscolo/minuscolo"},
/* ko */ {IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_NL, "Schakel niet tussen grote/kleine letters"},
/* pl */ {IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_PL, "Nie przeczaj zestawu wielkich/maych znakw"},
/* ru */ {IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_RU, "  / "},
/* sv */ {IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_SV, "Vxla inte sm/stora bokstver i teckengeneratorn"},
/* tr */ {IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_TR, "Byk/kk harf karakter seti deitirme"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_EOI_BLANKS_SCREEN,    N_("EOI blanks screen")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_EOI_BLANKS_SCREEN_DA, "EOI sletter skrmen"},
/* de */ {IDCLS_EOI_BLANKS_SCREEN_DE, "EOI lscht Bildschirm"},
/* es */ {IDCLS_EOI_BLANKS_SCREEN_ES, "EOI pantalla en blanco"},
/* fr */ {IDCLS_EOI_BLANKS_SCREEN_FR, "EOI vide l'cran"},
/* hu */ {IDCLS_EOI_BLANKS_SCREEN_HU, "EOI trli a kpernyt"},
/* it */ {IDCLS_EOI_BLANKS_SCREEN_IT, "EOI oscura lo schermo"},
/* ko */ {IDCLS_EOI_BLANKS_SCREEN_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_EOI_BLANKS_SCREEN_NL, "EOI maakt het scherm leeg"},
/* pl */ {IDCLS_EOI_BLANKS_SCREEN_PL, "Koniec przerwania czyci ekran"},
/* ru */ {IDCLS_EOI_BLANKS_SCREEN_RU, "EOI blanks screen"},
/* sv */ {IDCLS_EOI_BLANKS_SCREEN_SV, "EOI tmmer skrmen"},
/* tr */ {IDCLS_EOI_BLANKS_SCREEN_TR, "EOI ekran boaltr"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_EOI_DOES_NOT_BLANK_SCREEN,    N_("EOI does not blank screen")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_EOI_DOES_NOT_BLANK_SCREEN_DA, "EOI sletter ikke skrmen"},
/* de */ {IDCLS_EOI_DOES_NOT_BLANK_SCREEN_DE, "EIO lscht Bildschirm nicht"},
/* es */ {IDCLS_EOI_DOES_NOT_BLANK_SCREEN_ES, "EOI pantalla no en blanco"},
/* fr */ {IDCLS_EOI_DOES_NOT_BLANK_SCREEN_FR, "EOI ne vide pas l'cran"},
/* hu */ {IDCLS_EOI_DOES_NOT_BLANK_SCREEN_HU, "EOI nem trli a kpernyt"},
/* it */ {IDCLS_EOI_DOES_NOT_BLANK_SCREEN_IT, "EOI non oscura lo schermo"},
/* ko */ {IDCLS_EOI_DOES_NOT_BLANK_SCREEN_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_EOI_DOES_NOT_BLANK_SCREEN_NL, "EOI maakt het scherm niet leeg"},
/* pl */ {IDCLS_EOI_DOES_NOT_BLANK_SCREEN_PL, "Koniec przerwania nie czyci ekranu"},
/* ru */ {IDCLS_EOI_DOES_NOT_BLANK_SCREEN_RU, "EOI does not blank screen"},
/* sv */ {IDCLS_EOI_DOES_NOT_BLANK_SCREEN_SV, "EOI tmmer inte skrmen"},
/* tr */ {IDCLS_EOI_DOES_NOT_BLANK_SCREEN_TR, "EOI ekran boaltmaz"},
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SET_CPU_SWITCH_TO_6502,    N_("Set SuperPET CPU switch to '6502'")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_CPU_SWITCH_TO_6502_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_CPU_SWITCH_TO_6502_DE, "Setze SuperPET CPU Schalter auf '6502'"},
/* es */ {IDCLS_SET_CPU_SWITCH_TO_6502_ES, "Ajustar interruptor SuperPET CPU"},
/* fr */ {IDCLS_SET_CPU_SWITCH_TO_6502_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_CPU_SWITCH_TO_6502_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_CPU_SWITCH_TO_6502_IT, "Imposta pulsante CPU SuperPET a '6502'"},
/* ko */ {IDCLS_SET_CPU_SWITCH_TO_6502_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_CPU_SWITCH_TO_6502_NL, "Zet SuperPET CPU schakelaar naar '6502'"},
/* pl */ {IDCLS_SET_CPU_SWITCH_TO_6502_PL, "Ustaw przecznik CPU SuperPET na '6502\""},
/* ru */ {IDCLS_SET_CPU_SWITCH_TO_6502_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_CPU_SWITCH_TO_6502_SV, "Stt SuperPET-processoromkopplaren till \"6502\""},
/* tr */ {IDCLS_SET_CPU_SWITCH_TO_6502_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SET_CPU_SWITCH_TO_6809,    N_("Set SuperPET CPU switch to '6809'")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_CPU_SWITCH_TO_6809_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_CPU_SWITCH_TO_6809_DE, "Setze SuperPET CPU Schalter auf '6809'"},
/* es */ {IDCLS_SET_CPU_SWITCH_TO_6809_ES, "Ajustar interruptor SuperPET CPU para '6809'"},
/* fr */ {IDCLS_SET_CPU_SWITCH_TO_6809_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_CPU_SWITCH_TO_6809_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_CPU_SWITCH_TO_6809_IT, "Imposta pulsante CPU SuperPET a '6809'"},
/* ko */ {IDCLS_SET_CPU_SWITCH_TO_6809_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_CPU_SWITCH_TO_6809_NL, "Zet SuperPET CPU schakelaar naar '6809'"},
/* pl */ {IDCLS_SET_CPU_SWITCH_TO_6809_PL, "Ustaw przecznik CPU SuperPET na '6809\""},
/* ru */ {IDCLS_SET_CPU_SWITCH_TO_6809_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_CPU_SWITCH_TO_6809_SV, "Stt SuperPET-processoromkopplaren till \"6809\""},
/* tr */ {IDCLS_SET_CPU_SWITCH_TO_6809_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SET_CPU_SWITCH_TO_PROG,    N_("Set SuperPET CPU switch to 'Prog'")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_CPU_SWITCH_TO_PROG_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_CPU_SWITCH_TO_PROG_DE, "Setze SuperPET CPU Schalter auf 'Prog'"},
/* es */ {IDCLS_SET_CPU_SWITCH_TO_PROG_ES, "Ajustar interruptor SuperPET CPU para 'Prog'"},
/* fr */ {IDCLS_SET_CPU_SWITCH_TO_PROG_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_CPU_SWITCH_TO_PROG_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_CPU_SWITCH_TO_PROG_IT, "Imposta pulsante CPU SuperPET a 'Prog'"},
/* ko */ {IDCLS_SET_CPU_SWITCH_TO_PROG_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_CPU_SWITCH_TO_PROG_NL, "Zet SuperPET CPU schakelaar naar 'Prog'"},
/* pl */ {IDCLS_SET_CPU_SWITCH_TO_PROG_PL, "Ustaw przecznik CPU SuperPET na 'Prog\""},
/* ru */ {IDCLS_SET_CPU_SWITCH_TO_PROG_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_CPU_SWITCH_TO_PROG_SV, "Stt SuperPET-processoromkopplaren till \"Prog\""},
/* tr */ {IDCLS_SET_CPU_SWITCH_TO_PROG_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_6809_ROM_AT_A000,    N_("Specify 4K to 24K ROM file name at $A000 for 6809")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_6809_ROM_AT_A000_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_6809_ROM_AT_A000_DE, "4K-24K Erweiterungs ROM Dateiname fr $A000 fr 6809 whlen"},
/* es */ {IDCLS_SPECIFY_6809_ROM_AT_A000_ES, "Especificar nombre ROM 4K a 24K  en $A000 para 6809"},
/* fr */ {IDCLS_SPECIFY_6809_ROM_AT_A000_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_6809_ROM_AT_A000_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_6809_ROM_AT_A000_IT, "Specifica il nome della ROM da 4K a 24K a $A000 per il 6809"},
/* ko */ {IDCLS_SPECIFY_6809_ROM_AT_A000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_6809_ROM_AT_A000_NL, "Geef de naam van het bestand voor de 4K tot 24K ROM op $A000 voor de 6809"},
/* pl */ {IDCLS_SPECIFY_6809_ROM_AT_A000_PL, "Okrel nazw pliku ROM-u 4K do 24K w $A000 dla 6809"},
/* ru */ {IDCLS_SPECIFY_6809_ROM_AT_A000_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_6809_ROM_AT_A000_SV, "Ange namn fr 4-24K-utknings-ROM p $A000 fr 6809"},
/* tr */ {IDCLS_SPECIFY_6809_ROM_AT_A000_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_6809_ROM_AT_B000,    N_("Specify 4K to 20K ROM file name at $B000 for 6809")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_6809_ROM_AT_B000_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_6809_ROM_AT_B000_DE, "4K-20K Erweiterungs ROM Dateiname fr $B000 fr 6809 whlen"},
/* es */ {IDCLS_SPECIFY_6809_ROM_AT_B000_ES, "Especificar nombre ROM 4K a 20K  en $B000 para 6809"},
/* fr */ {IDCLS_SPECIFY_6809_ROM_AT_B000_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_6809_ROM_AT_B000_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_6809_ROM_AT_B000_IT, "Specifica il nome della ROM da 4K a 20K a $B000 per il 6809"},
/* ko */ {IDCLS_SPECIFY_6809_ROM_AT_B000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_6809_ROM_AT_B000_NL, "Geef de naam van het bestand voor de 4K tot 20K ROM op $B000 voor de 6809"},
/* pl */ {IDCLS_SPECIFY_6809_ROM_AT_B000_PL, "Okrel nazw pliku ROM-u 4K do 20K w $B000 dla 6809"},
/* ru */ {IDCLS_SPECIFY_6809_ROM_AT_B000_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_6809_ROM_AT_B000_SV, "Ange namn fr 4-20K-utknings-ROM p $B000 fr 6809"},
/* tr */ {IDCLS_SPECIFY_6809_ROM_AT_B000_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_6809_ROM_AT_C000,    N_("Specify 4K to 16K ROM file name at $C000 for 6809")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_6809_ROM_AT_C000_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_6809_ROM_AT_C000_DE, "4K-16K Erweiterungs ROM Dateiname fr $C000 fr 6809 whlen"},
/* es */ {IDCLS_SPECIFY_6809_ROM_AT_C000_ES, "Especificar nombre ROM 4K a 16K  en $C000 para 6809"},
/* fr */ {IDCLS_SPECIFY_6809_ROM_AT_C000_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_6809_ROM_AT_C000_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_6809_ROM_AT_C000_IT, "Specifica il nome della ROM da 4K a 16K a $C000 per il 6809"},
/* ko */ {IDCLS_SPECIFY_6809_ROM_AT_C000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_6809_ROM_AT_C000_NL, "Geef de naam van het bestand voor de 4K tot 16K ROM op $C000 voor de 6809"},
/* pl */ {IDCLS_SPECIFY_6809_ROM_AT_C000_PL, "Okrel nazw pliku ROM-u 4K do 16K w $C000 dla 6809"},
/* ru */ {IDCLS_SPECIFY_6809_ROM_AT_C000_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_6809_ROM_AT_C000_SV, "Ange namn fr 4-16K-utknings-ROM p $C000 fr 6809"},
/* tr */ {IDCLS_SPECIFY_6809_ROM_AT_C000_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_6809_ROM_AT_D000,    N_("Specify 4K to 12K ROM file name at $D000 for 6809")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_6809_ROM_AT_D000_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_6809_ROM_AT_D000_DE, "4K-12K Erweiterungs ROM Dateiname fr $D000 fr 6809 whlen"},
/* es */ {IDCLS_SPECIFY_6809_ROM_AT_D000_ES, "Especificar nombre ROM 4K a 12K  en $D000 para 6809"},
/* fr */ {IDCLS_SPECIFY_6809_ROM_AT_D000_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_6809_ROM_AT_D000_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_6809_ROM_AT_D000_IT, "Specifica il nome della ROM da 4K a 12K a $D000 per il 6809"},
/* ko */ {IDCLS_SPECIFY_6809_ROM_AT_D000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_6809_ROM_AT_D000_NL, "Geef de naam van het bestand voor de 4K tot 12K ROM op $D000 voor de 6809"},
/* pl */ {IDCLS_SPECIFY_6809_ROM_AT_D000_PL, "Okrel nazw pliku ROM-u 4K do 12K w $D000 dla 6809"},
/* ru */ {IDCLS_SPECIFY_6809_ROM_AT_D000_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_6809_ROM_AT_D000_SV, "Ange namn fr 4-12K-utknings-ROM p $D000 fr 6809"},
/* tr */ {IDCLS_SPECIFY_6809_ROM_AT_D000_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_6809_ROM_AT_E000,    N_("Specify 2K or 8K ROM file name at $E000 for 6809")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_6809_ROM_AT_E000_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_6809_ROM_AT_E000_DE, "4K-8K Erweiterungs ROM Dateiname fr $E000 fr 6809 whlen"},
/* es */ {IDCLS_SPECIFY_6809_ROM_AT_E000_ES, "Especificar nombre ROM 4K a 8K  en $E000 para 6809"},
/* fr */ {IDCLS_SPECIFY_6809_ROM_AT_E000_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_6809_ROM_AT_E000_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_6809_ROM_AT_E000_IT, "Specifica il nome della ROM da 2K a 8K a $E000 per il 6809"},
/* ko */ {IDCLS_SPECIFY_6809_ROM_AT_E000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_6809_ROM_AT_E000_NL, "Geef de naam van het bestand voor de 2K of 8K ROM op $E000 voor de 6809"},
/* pl */ {IDCLS_SPECIFY_6809_ROM_AT_E000_PL, "Okrel nazw pliku ROM-u 2K lub 8K w $E000 dla 6809"},
/* ru */ {IDCLS_SPECIFY_6809_ROM_AT_E000_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_6809_ROM_AT_E000_SV, "Ange namn fr 2/8K-utknings-ROM p $E000 fr 6809"},
/* tr */ {IDCLS_SPECIFY_6809_ROM_AT_E000_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_6809_ROM_AT_F000,    N_("Specify 4K ROM file name at $F000 for 6809")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_6809_ROM_AT_F000_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_6809_ROM_AT_F000_DE, "4K Erweiterungs ROM Dateiname fr $F000 fr 6809 whlen"},
/* es */ {IDCLS_SPECIFY_6809_ROM_AT_F000_ES, "Especificar nombre ROM 4K en $F000 para 6809"},
/* fr */ {IDCLS_SPECIFY_6809_ROM_AT_F000_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_6809_ROM_AT_F000_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_6809_ROM_AT_F000_IT, "Specifica il nome della ROM da 4K a $F000 per il 6809"},
/* ko */ {IDCLS_SPECIFY_6809_ROM_AT_F000_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_6809_ROM_AT_F000_NL, "Geef de naam van het bestand voor de 4K ROM op $F000 voor de 6809"},
/* pl */ {IDCLS_SPECIFY_6809_ROM_AT_F000_PL, "Okrel nazw pliku ROM-u 4K w $F000 dla 6809"},
/* ru */ {IDCLS_SPECIFY_6809_ROM_AT_F000_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_6809_ROM_AT_F000_SV, "Ange namn fr 4K-utknings-ROM p $F000 fr 6809"},
/* tr */ {IDCLS_SPECIFY_6809_ROM_AT_F000_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_PET4032_COLOUR_RGBI,    N_("RGBI colour extension to PET 4032")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PET4032_COLOUR_RGBI_DA, ""},  /* fuzzy */
/* de */ {IDCLS_PET4032_COLOUR_RGBI_DE, "RGBI Farberweiterung fr PET 4032"},
/* es */ {IDCLS_PET4032_COLOUR_RGBI_ES, "Extension color RGBI para PET 4032"},
/* fr */ {IDCLS_PET4032_COLOUR_RGBI_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_PET4032_COLOUR_RGBI_HU, ""},  /* fuzzy */
/* it */ {IDCLS_PET4032_COLOUR_RGBI_IT, "Estensione colore RGBI per PET 4032"},
/* ko */ {IDCLS_PET4032_COLOUR_RGBI_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PET4032_COLOUR_RGBI_NL, "RGBI kleur uitbreiding voor de PET 4032"},
/* pl */ {IDCLS_PET4032_COLOUR_RGBI_PL, "Rozszerzenie barw RGBI do PET 4032"},
/* ru */ {IDCLS_PET4032_COLOUR_RGBI_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_PET4032_COLOUR_RGBI_SV, "RGBI-frgutkning fr PET 4032"},
/* tr */ {IDCLS_PET4032_COLOUR_RGBI_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_PET4032_COLOUR_ANALOG,    N_("Analog colour extension to PET 4032")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PET4032_COLOUR_ANALOG_DA, ""},  /* fuzzy */
/* de */ {IDCLS_PET4032_COLOUR_ANALOG_DE, "Analog Farberweiterung fr PET 4032"},
/* es */ {IDCLS_PET4032_COLOUR_ANALOG_ES, "Extension analgica de color para PET 4032"},
/* fr */ {IDCLS_PET4032_COLOUR_ANALOG_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_PET4032_COLOUR_ANALOG_HU, ""},  /* fuzzy */
/* it */ {IDCLS_PET4032_COLOUR_ANALOG_IT, "Estensione colore analogica per PET 4032"},
/* ko */ {IDCLS_PET4032_COLOUR_ANALOG_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PET4032_COLOUR_ANALOG_NL, "Analoge kleur uitbreiding voor de PET 4032"},
/* pl */ {IDCLS_PET4032_COLOUR_ANALOG_PL, "Rozszerzenie analogowych barw do PET 4032"},
/* ru */ {IDCLS_PET4032_COLOUR_ANALOG_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_PET4032_COLOUR_ANALOG_SV, "Analog frgutkning fr PET 4032"},
/* tr */ {IDCLS_PET4032_COLOUR_ANALOG_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_P_COLOUR_0_255,    N_("<Colour 0-255>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_COLOUR_0_255_DA, ""},  /* fuzzy */
/* de */ {IDCLS_P_COLOUR_0_255_DE, "<Farbe 0-255>"},
/* es */ {IDCLS_P_COLOUR_0_255_ES, "<Color 0-255>"},
/* fr */ {IDCLS_P_COLOUR_0_255_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_P_COLOUR_0_255_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_COLOUR_0_255_IT, "<Colore 0-255>"},
/* ko */ {IDCLS_P_COLOUR_0_255_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_COLOUR_0_255_NL, "<Kleur 0-255>"},
/* pl */ {IDCLS_P_COLOUR_0_255_PL, "<Kolor 0-255>"},
/* ru */ {IDCLS_P_COLOUR_0_255_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_P_COLOUR_0_255_SV, "<Frg 0-255>"},
/* tr */ {IDCLS_P_COLOUR_0_255_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_PET4032_COLOUR_BACKGROUND,    N_("Analog colour background on PET 4032")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PET4032_COLOUR_BACKGROUND_DA, ""},  /* fuzzy */
/* de */ {IDCLS_PET4032_COLOUR_BACKGROUND_DE, "Analog Hintergrundfarbe fr PET 4032"},
/* es */ {IDCLS_PET4032_COLOUR_BACKGROUND_ES, "Color del fondo analgico para PET 4032"},
/* fr */ {IDCLS_PET4032_COLOUR_BACKGROUND_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_PET4032_COLOUR_BACKGROUND_HU, ""},  /* fuzzy */
/* it */ {IDCLS_PET4032_COLOUR_BACKGROUND_IT, "Coloro sfondo analogico su PET 4032"},
/* ko */ {IDCLS_PET4032_COLOUR_BACKGROUND_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PET4032_COLOUR_BACKGROUND_NL, "Analoge kleuren achtergrond voor de PET 4032"},
/* pl */ {IDCLS_PET4032_COLOUR_BACKGROUND_PL, "Analogowy kolor ta w PET 4032"},
/* ru */ {IDCLS_PET4032_COLOUR_BACKGROUND_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_PET4032_COLOUR_BACKGROUND_SV, "Analog frgbakgrund p PET 4032"},
/* tr */ {IDCLS_PET4032_COLOUR_BACKGROUND_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_PET_RAM_SIZE,    N_("PET RAM size (4/8/16/32/96/128)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PET_RAM_SIZE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_PET_RAM_SIZE_DE, "PET RAM Gre (4/8/16/32/96/128)"},
/* es */ {IDCLS_PET_RAM_SIZE_ES, "Tamao de la RAM en PET  (4/8/16/32/96/128)"},
/* fr */ {IDCLS_PET_RAM_SIZE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_PET_RAM_SIZE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_PET_RAM_SIZE_IT, "Dimensione RAM PET (4/8/16/32/96/128)"},
/* ko */ {IDCLS_PET_RAM_SIZE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PET_RAM_SIZE_NL, "PET RAM grootte (4/8/16/32/96/128)"},
/* pl */ {IDCLS_PET_RAM_SIZE_PL, "Wielko RAM-u PET (4/8/16/32/96/128)"},
/* ru */ {IDCLS_PET_RAM_SIZE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_PET_RAM_SIZE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_PET_RAM_SIZE_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_PET_IO_SIZE,    N_("PET I/O size (256/2048)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PET_IO_SIZE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_PET_IO_SIZE_DE, "PET I/O Gre (256/2048)"},
/* es */ {IDCLS_PET_IO_SIZE_ES, "Tamao PET I/O (256/2048)"},
/* fr */ {IDCLS_PET_IO_SIZE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_PET_IO_SIZE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_PET_IO_SIZE_IT, "Dimensione I/O PET (256/2048)"},
/* ko */ {IDCLS_PET_IO_SIZE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PET_IO_SIZE_NL, "PET I/O grootte (256/2048)"},
/* pl */ {IDCLS_PET_IO_SIZE_PL, "Rozmiar we/wy PET (256/2048)"},
/* ru */ {IDCLS_PET_IO_SIZE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_PET_IO_SIZE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_PET_IO_SIZE_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_ENABLE_CRTC,    N_("Enable CRTC")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_CRTC_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_CRTC_DE, "CRTC aktivieren"},
/* es */ {IDCLS_ENABLE_CRTC_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_ENABLE_CRTC_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_CRTC_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_CRTC_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_ENABLE_CRTC_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_CRTC_NL, "CRTC inschakelen"},
/* pl */ {IDCLS_ENABLE_CRTC_PL, "Wcz CRTC"},
/* ru */ {IDCLS_ENABLE_CRTC_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_CRTC_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_CRTC_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_DISABLE_CRTC,    N_("Disable CRTC")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_CRTC_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_CRTC_DE, "CRTC deaktivieren"},
/* es */ {IDCLS_DISABLE_CRTC_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_DISABLE_CRTC_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_CRTC_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_CRTC_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_DISABLE_CRTC_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_CRTC_NL, "CRTC uitschakelen"},
/* pl */ {IDCLS_DISABLE_CRTC_PL, "Wycz CRTC"},
/* ru */ {IDCLS_DISABLE_CRTC_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_CRTC_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_CRTC_TR, ""},  /* fuzzy */
#endif

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SET_VIDEO_SIZE,    N_("Set video size (0: Automatic, 40: 40 Columns, 80: 80 Columns)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_VIDEO_SIZE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_VIDEO_SIZE_DE, "Video Gre (0: Automatisch, 40: 40 Spalten, 80: 80 Spalten)"},
/* es */ {IDCLS_SET_VIDEO_SIZE_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SET_VIDEO_SIZE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_VIDEO_SIZE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_VIDEO_SIZE_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SET_VIDEO_SIZE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_VIDEO_SIZE_NL, "Stel video grootte in (0: Automatisch, 40: 40 Kolommen, 80: 80 Kolommen)"},
/* pl */ {IDCLS_SET_VIDEO_SIZE_PL, "Okrel wielko obrazu (0: Automatyczna, 40: 40 kolumn, 80: 80 kolumn)"},
/* ru */ {IDCLS_SET_VIDEO_SIZE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_VIDEO_SIZE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_VIDEO_SIZE_TR, ""},  /* fuzzy */
#endif

/* pet/petpia1.c */
/* en */ {IDCLS_ENABLE_USERPORT_DIAG_PIN,    N_("Enable userport diagnostic pin")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_USERPORT_DIAG_PIN_DA, "Aktivr diagnostik p brugerporten"},
/* de */ {IDCLS_ENABLE_USERPORT_DIAG_PIN_DE, "Userport Diagnose Pin aktivieren"},
/* es */ {IDCLS_ENABLE_USERPORT_DIAG_PIN_ES, "Permitir pin puerto diagnostico"},
/* fr */ {IDCLS_ENABLE_USERPORT_DIAG_PIN_FR, "Activer la pin de diagnostique userport"},
/* hu */ {IDCLS_ENABLE_USERPORT_DIAG_PIN_HU, "Userport diagnosztikai lb engedlyezse"},
/* it */ {IDCLS_ENABLE_USERPORT_DIAG_PIN_IT, "Attiva pin diagnostico su userport"},
/* ko */ {IDCLS_ENABLE_USERPORT_DIAG_PIN_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_USERPORT_DIAG_PIN_NL, "Userport diagnostic pin inschakelen"},
/* pl */ {IDCLS_ENABLE_USERPORT_DIAG_PIN_PL, "Wcz pin diagnostyczny userportu"},
/* ru */ {IDCLS_ENABLE_USERPORT_DIAG_PIN_RU, "Enable userport diagnostic pin"},
/* sv */ {IDCLS_ENABLE_USERPORT_DIAG_PIN_SV, "Aktivera diagnostik p anvndarporten"},
/* tr */ {IDCLS_ENABLE_USERPORT_DIAG_PIN_TR, "Userport diyagnostik pinini aktif et"},
#endif

/* pet/petpia1.c */
/* en */ {IDCLS_DISABLE_USERPORT_DIAG_PIN,    N_("Disable userport diagnostic pin")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_USERPORT_DIAG_PIN_DA, "Deaktivr diagnostik p brugerporten"},
/* de */ {IDCLS_DISABLE_USERPORT_DIAG_PIN_DE, "Userport Diagnose Pin deaktivieren"},
/* es */ {IDCLS_DISABLE_USERPORT_DIAG_PIN_ES, "Deshabilitar pin puerto diagnostico"},
/* fr */ {IDCLS_DISABLE_USERPORT_DIAG_PIN_FR, "Dsactiver la pin de diagnostique userport"},
/* hu */ {IDCLS_DISABLE_USERPORT_DIAG_PIN_HU, "Userport diagnosztikai lb tiltsa"},
/* it */ {IDCLS_DISABLE_USERPORT_DIAG_PIN_IT, "Disattiva pin diagnostico su userport"},
/* ko */ {IDCLS_DISABLE_USERPORT_DIAG_PIN_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_USERPORT_DIAG_PIN_NL, "Userport diagnostic pin uitschakelen"},
/* pl */ {IDCLS_DISABLE_USERPORT_DIAG_PIN_PL, "Wycz pin diagnostyczny userportu"},
/* ru */ {IDCLS_DISABLE_USERPORT_DIAG_PIN_RU, "Disable userport diagnostic pin"},
/* sv */ {IDCLS_DISABLE_USERPORT_DIAG_PIN_SV, "Inaktivera diagnostik p anvndarporten"},
/* tr */ {IDCLS_DISABLE_USERPORT_DIAG_PIN_TR, "Userport diyagnostik pinini pasifletir"},
#endif

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME,    N_("Specify name of Function low ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_DA, "Angiv navn p image for lav funktions-ROM"},
/* de */ {IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_DE, "Namen fr Funktions ROM Datei (unterer Bereich) whlen"},
/* es */ {IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_ES, "Especificar nombre imagen ROM funcin baja"},
/* fr */ {IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_FR, "Spcifier le nom de l'image basse ROM Fonction"},
/* hu */ {IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_HU, "Adja meg az als Function ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_IT, "Specifica il nome immagine della Function ROM bassa"},
/* ko */ {IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_NL, "Geef de naam van het Function low ROM bestand"},
/* pl */ {IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_PL, "Okrel nazw obrazu ROM Function low"},
/* ru */ {IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_RU, "Specify name of Function low ROM image"},
/* sv */ {IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_SV, "Ange namn p ROM-avbildning fr lgt funktions-ROM"},
/* tr */ {IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_TR, "Function low ROM imajnn ismini belirt"},
#endif

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME,    N_("Specify name of Function high ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_DA, "Angiv navn p image for hj funktions-ROM"},
/* de */ {IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_DE, "Namen fr Funktions ROM Datei (oberer Bereich) whlen"},
/* es */ {IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_ES, "Especificar nombre imagen ROM funcin alta"},
/* fr */ {IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_FR, "Spcifier le nom de l'image haute ROM Fonction"},
/* hu */ {IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_HU, "Adja meg a fels Function ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_IT, "Specifica il nome immagine della Function ROM alta"},
/* ko */ {IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_NL, "Geef de naam van het Function high ROM bestand"},
/* pl */ {IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_PL, "Okrel nazw obrazu ROM Function high"},
/* ru */ {IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_RU, "Specify name of Function high ROM image"},
/* sv */ {IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_SV, "Ange namn p ROM-avbildning fr hgt funktions-ROM"},
/* tr */ {IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_TR, "Function high ROM imajnn ismini belirt"},
#endif

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_1_LOW_ROM_NAME,    N_("Specify name of Cartridge 1 low ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_DA, "Angiv navn p image for lav cartridge 1 ROM"},
/* de */ {IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_DE, "Name fr Erweiterungsmodul 1 ROM Datei (unterer Bereich) whlen"},
/* es */ {IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_ES, "Especificar nombre imagen ROM cartucho 1 bajo"},
/* fr */ {IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_FR, "Spcifier le nom de l'image basse ROM Cartouche 1"},
/* hu */ {IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_HU, "Adja meg az als Cartridge 1 ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_IT, "Specifica il nome immagine della ROM Cartridge 1 bassa"},
/* ko */ {IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_NL, "Geef de naam van het Cartridge 1 low ROM bestand"},
/* pl */ {IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_PL, "Okrel nazw obrazu ROM Cartridge 1 low"},
/* ru */ {IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_RU, "Specify name of Cartridge 1 low ROM image"},
/* sv */ {IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_SV, "Ange namn p ROM-avbildning fr lgt insticksmodul 1-ROM"},
/* tr */ {IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_TR, "Cartridge 1 low ROM imajnn ismini belirt"},
#endif

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME,    N_("Specify name of Cartridge 1 high ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_DA, "Angiv navn p image for hj cartridge 1 ROM"},
/* de */ {IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_DE, "Name fr Erweiterungsmodul 1 ROM Datei (oberer Bereich) whlen"},
/* es */ {IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_ES, "Especificar nombre imagen ROM cartucho 1 alto"},
/* fr */ {IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_FR, "Spcifier le nom de l'image haute ROM Cartouche 1"},
/* hu */ {IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_HU, "Adja meg a fels Cartridge 1 ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_IT, "Specifica il nome immagine della ROM Cartridge 1 alta"},
/* ko */ {IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_NL, "Geef de naam van het Cartridge 1 high ROM bestand"},
/* pl */ {IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_PL, "Okrel nazw obrazu ROM Cartridge 1 high"},
/* ru */ {IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_RU, "Specify name of Cartridge 1 high ROM image"},
/* sv */ {IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_SV, "Ange namn p ROM-avbildning fr hgt insticksmodul 1-ROM"},
/* tr */ {IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_TR, "Cartridge 1 high ROM imajnn ismini belirt"},
#endif

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_2_LOW_ROM_NAME,    N_("Specify name of Cartridge 2 low ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_DA, "Angiv navn p image for lav cartridge 2 ROM"},
/* de */ {IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_DE, "Name fr Erweiterungsmodul 2 ROM Datei (unterer Bereich) whlen"},
/* es */ {IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_ES, "Especificar nombre imagen ROM cartucho 2 bajo"},
/* fr */ {IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_FR, "Spcifier le nom de l'image basse ROM Cartouche 2"},
/* hu */ {IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_HU, "Adja meg az als Cartridge 2 ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_IT, "Specifica il nome immagine della ROM Cartridge 2 bassa"},
/* ko */ {IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_NL, "Geef de naam van het Cartridge 2 low ROM bestand"},
/* pl */ {IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_PL, "Okrel nazw obrazu ROM Cartridge 2 low"},
/* ru */ {IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_RU, "Specify name of Cartridge 2 low ROM image"},
/* sv */ {IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_SV, "Ange namn p ROM-avbildning fr lgt insticksmodul 2-ROM"},
/* tr */ {IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_TR, "Cartridge 2 low ROM imajnn ismini belirt"},
#endif

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME,    N_("Specify name of Cartridge 2 high ROM image")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_DA, "Angiv navn p image for hj cartridge 1 ROM"},
/* de */ {IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_DE, "Name fr Erweiterungsmodul 2 ROM Datei (oberer Bereich) whlen"},
/* es */ {IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_ES, "Especificar nombre imagen ROM cartucho 2 alto"},
/* fr */ {IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_FR, "Spcifier le nom de l'image haute ROM Cartouche 2"},
/* hu */ {IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_HU, "Adja meg a fels Cartridge 2 ROM kpms nevt"},
/* it */ {IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_IT, "Specifica il nome immagine della ROM Cartridge 2 alta"},
/* ko */ {IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_NL, "Geef de naam van het Cartridge 2 high ROM bestand"},
/* pl */ {IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_PL, "Okrel nazw obrazu ROM Cartridge 2 high"},
/* ru */ {IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_RU, "Specify name of Cartridge 2 high ROM image"},
/* sv */ {IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_SV, "Ange namn p ROM-avbildning fr hgt insticksmodul 2-ROM"},
/* tr */ {IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_TR, "Cartridge 2 high ROM imajnn ismini belirt"},
#endif

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_RAM_INSTALLED,    N_("Specify size of RAM installed in kb (16/32/64)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_RAM_INSTALLED_DA, "Angiv strrelse p installeret RAM i kB (16/32/64)"},
/* de */ {IDCLS_SPECIFY_RAM_INSTALLED_DE, "Gre des emulierten RAM Speichers in kb (16/32/64) spezifizieren"},
/* es */ {IDCLS_SPECIFY_RAM_INSTALLED_ES, "Especificar tamao RAM instalada en KB (16/32/64)"},
/* fr */ {IDCLS_SPECIFY_RAM_INSTALLED_FR, "Spcifier la taille du RAM install (16/32/64)"},
/* hu */ {IDCLS_SPECIFY_RAM_INSTALLED_HU, "Adja meg a teleptett RAM mrett kb-ban (16/32/64)"},
/* it */ {IDCLS_SPECIFY_RAM_INSTALLED_IT, "Specifica la dimensione della RAM installata in kb (16/32/64)"},
/* ko */ {IDCLS_SPECIFY_RAM_INSTALLED_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_RAM_INSTALLED_NL, "Geef de hoeveelheid RAM in kb (16/32/64)"},
/* pl */ {IDCLS_SPECIFY_RAM_INSTALLED_PL, "Okrel ilo zainstalowanego RAM-u w kb (16/32/64)"},
/* ru */ {IDCLS_SPECIFY_RAM_INSTALLED_RU, "Specify size of RAM installed in kb (16/32/64)"},
/* sv */ {IDCLS_SPECIFY_RAM_INSTALLED_SV, "Ange storlek p installerat RAM i kb (16/32/64)"},
/* tr */ {IDCLS_SPECIFY_RAM_INSTALLED_TR, "Kurulmu olan RAM boyutunu kb cinsinden belirt (16/32/64)"},
#endif

/* plus4/ted-cmdline-options.c, vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_SATURATION,    N_("Set saturation of internal calculated palette")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_SATURATION_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_SATURATION_DE, "Sttigung fr intern berechneten Palette setzen"},
/* es */ {IDCLS_SET_SATURATION_ES, "Seleccionar saturacin calculada en paleta interna"},
/* fr */ {IDCLS_SET_SATURATION_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_SATURATION_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_SATURATION_IT, "Imposta la saturazione della palette calcolata internamente"},
/* ko */ {IDCLS_SET_SATURATION_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_SATURATION_NL, "Stel de verzadiging in van het intern berekend kleurenpalet"},
/* pl */ {IDCLS_SET_SATURATION_PL, "Okrel nasycenie wewntrznie obliczonej palety kolorystycznej"},
/* ru */ {IDCLS_SET_SATURATION_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_SATURATION_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_SATURATION_TR, ""},  /* fuzzy */
#endif

/* plus4/ted-cmdline-options.c, vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_CONTRAST,    N_("Set contrast of internal calculated palette")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_CONTRAST_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_CONTRAST_DE, "Kontrast fr intern berechnete Palette setzen"},
/* es */ {IDCLS_SET_CONTRAST_ES, "Seleccionar contraste calculado en paleta interna [1000]"},
/* fr */ {IDCLS_SET_CONTRAST_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_CONTRAST_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_CONTRAST_IT, "Imposta il constrasto della palette calcolata internamente"},
/* ko */ {IDCLS_SET_CONTRAST_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_CONTRAST_NL, "Stel het contrast in van het intern berekend kleurenpalet"},
/* pl */ {IDCLS_SET_CONTRAST_PL, "Okrel kontrast wewntrznie obliczonej palety kolorystycznej"},
/* ru */ {IDCLS_SET_CONTRAST_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_CONTRAST_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_CONTRAST_TR, ""},  /* fuzzy */
#endif

/* plus4/ted-cmdline-options.c, vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_BRIGHTNESS,    N_("Set brightness of internal calculated palette")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_BRIGHTNESS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_BRIGHTNESS_DE, "Helligkeit fr intern berechnete Palette setzen"},
/* es */ {IDCLS_SET_BRIGHTNESS_ES, "Seleccionar brillo calculado en paleta interna"},
/* fr */ {IDCLS_SET_BRIGHTNESS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_BRIGHTNESS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_BRIGHTNESS_IT, "Imposta la luminanza della palette calcolata internamente"},
/* ko */ {IDCLS_SET_BRIGHTNESS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_BRIGHTNESS_NL, "Stel de helderheid in van het intern berekend kleurenpalet"},
/* pl */ {IDCLS_SET_BRIGHTNESS_PL, "Okrel jasno wewntrznie obliczonej palety kolorystycznej"},
/* ru */ {IDCLS_SET_BRIGHTNESS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_BRIGHTNESS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_BRIGHTNESS_TR, ""},  /* fuzzy */
#endif

/* plus4/ted-cmdline-options.c`, vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_GAMMA,    N_("Set gamma of internal calculated palette")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_GAMMA_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_GAMMA_DE, "Gamma fr intern berechnete Palette setzen"},
/* es */ {IDCLS_SET_GAMMA_ES, "Seleccionar gamma calculada en paleta interna"},
/* fr */ {IDCLS_SET_GAMMA_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_GAMMA_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_GAMMA_IT, "Imposta la gamma della palette calcolata internamente"},
/* ko */ {IDCLS_SET_GAMMA_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_GAMMA_NL, "Stel de gamma in van het intern berekend kleurenpalet"},
/* pl */ {IDCLS_SET_GAMMA_PL, "Okrel jaskrawo wewntrznie obliczonej palety kolorystycznej"},
/* ru */ {IDCLS_SET_GAMMA_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_GAMMA_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_GAMMA_TR, ""},  /* fuzzy */
#endif

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_TINT,    N_("Set tint of internal calculated palette")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_TINT_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_TINT_DE, "Farbton fr intern berechneten Palette setzen"},
/* es */ {IDCLS_SET_TINT_ES, "Seleccionar tinta calculada en paleta interna"},
/* fr */ {IDCLS_SET_TINT_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_TINT_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_TINT_IT, "Imposta la sfumatura della palette calcolata internamente"},
/* ko */ {IDCLS_SET_TINT_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_TINT_NL, "Stel de tint in van het intern berekend kleuren palette"},
/* pl */ {IDCLS_SET_TINT_PL, "Okrel odcie wewntrznie obliczonej palety kolorystycznej"},
/* ru */ {IDCLS_SET_TINT_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_TINT_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_TINT_TR, ""},  /* fuzzy */
#endif

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_ODDLINES_PHASE,    N_("Set phase for color carrier in odd lines")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_ODDLINES_PHASE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_ODDLINES_PHASE_DE, "Phase fr Farbtrger in ungeraden Zeilen setzen"},
/* es */ {IDCLS_SET_ODDLINES_PHASE_ES, "Seleccionar fase trasporte color en lineas impares"},
/* fr */ {IDCLS_SET_ODDLINES_PHASE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_ODDLINES_PHASE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_ODDLINES_PHASE_IT, "Imposta la fase per la portante colore nelle linee dispari"},
/* ko */ {IDCLS_SET_ODDLINES_PHASE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_ODDLINES_PHASE_NL, "Stel de fase in van de kleuren drager in oneven lijnen"},
/* pl */ {IDCLS_SET_ODDLINES_PHASE_PL, "Okrel faz nonika koloru w liniach nieparzystych"},
/* ru */ {IDCLS_SET_ODDLINES_PHASE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_ODDLINES_PHASE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_ODDLINES_PHASE_TR, ""},  /* fuzzy */
#endif

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_ODDLINES_OFFSET,    N_("Set phase offset for color carrier in odd lines")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_ODDLINES_OFFSET_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_ODDLINES_OFFSET_DE, "Phasenoffset fr Farbtrger in ungeraden Zeilen setzen"},
/* es */ {IDCLS_SET_ODDLINES_OFFSET_ES, "Seleccionar aadido fase trasporte color en lineas impares"},
/* fr */ {IDCLS_SET_ODDLINES_OFFSET_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_ODDLINES_OFFSET_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_ODDLINES_OFFSET_IT, "Imposta l'offset della fase per la portate colore nelle linee dispari"},
/* ko */ {IDCLS_SET_ODDLINES_OFFSET_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_ODDLINES_OFFSET_NL, "Stel de fase in compensatie van de kleuren drager in oneven lijnen"},
/* pl */ {IDCLS_SET_ODDLINES_OFFSET_PL, "Okrel wyrwnanie fazy nonika koloru w liniach nieparzystych"},
/* ru */ {IDCLS_SET_ODDLINES_OFFSET_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_ODDLINES_OFFSET_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_ODDLINES_OFFSET_TR, ""},  /* fuzzy */
#endif

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_BLUR,    N_("Amount of horizontal blur for the CRT emulation.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_BLUR_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_BLUR_DE, "Wert fr horizontale Unschrfe fr CRT Emulation."},
/* es */ {IDCLS_SET_BLUR_ES, "Cantidad de borrosidad para Emulacin CRT."},
/* fr */ {IDCLS_SET_BLUR_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_BLUR_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_BLUR_IT, "Valore della sfuocatura orizzontale per l'emulazione CRT"},
/* ko */ {IDCLS_SET_BLUR_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_BLUR_NL, "Horizontale wazigheid hoeveelheid voor de CRT emulatie."},
/* pl */ {IDCLS_SET_BLUR_PL, "Warto rozmycia w poziomie emulacji CRT"},
/* ru */ {IDCLS_SET_BLUR_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_BLUR_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_BLUR_TR, ""},  /* fuzzy */
#endif

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_SCANLINE_SHADE,    N_("Amount of scan line shading for the CRT emulation")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_SCANLINE_SHADE_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_SCANLINE_SHADE_DE, "Wert fr Scanline Schatten fr CRT Emulation"},
/* es */ {IDCLS_SET_SCANLINE_SHADE_ES, "Cantidad de lineas sombra escaneo para emulacin CRT"},
/* fr */ {IDCLS_SET_SCANLINE_SHADE_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_SCANLINE_SHADE_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_SCANLINE_SHADE_IT, "Valore dell'ombreggiatura della scan line per l'emulazione CRT"},
/* ko */ {IDCLS_SET_SCANLINE_SHADE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_SCANLINE_SHADE_NL, "Hoeveelheid van de scan lijn schaduw voor de CRT emulatie"},
/* pl */ {IDCLS_SET_SCANLINE_SHADE_PL, "Warto cieniowania linii wybierania emulacji CRT"},
/* ru */ {IDCLS_SET_SCANLINE_SHADE_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_SCANLINE_SHADE_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_SCANLINE_SHADE_TR, ""},  /* fuzzy */
#endif

/* viciisc/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_VICII_MODEL,    N_("Set VIC-II model (6569/6569r1/8565/6567/8562/6567r56a/6572)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_VICII_MODEL_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_VICII_MODEL_DE, "Whle VIC-II Modell (6569/6569r1/8565/6567/8562/6567r56a/6572)"},
/* es */ {IDCLS_SET_VICII_MODEL_ES, "Seleccionar modelo VIC-II (6569/6569r1/8565/6567/8562/6567r56a/6572)"},
/* fr */ {IDCLS_SET_VICII_MODEL_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_VICII_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_VICII_MODEL_IT, "Imposta modello VIC-II (6569/6569r1/8565/6567/8562/6567r56a/6572)"},
/* ko */ {IDCLS_SET_VICII_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_VICII_MODEL_NL, "Zet VIC-II model (6569/6569r1/8565/6567/8562/6567r56a/6572)"},
/* pl */ {IDCLS_SET_VICII_MODEL_PL, "Ustaw model VIC-II (6569/6569r1/8565/6567/8562/6567r56a/6572)"},
/* ru */ {IDCLS_SET_VICII_MODEL_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_VICII_MODEL_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_VICII_MODEL_TR, ""},  /* fuzzy */
#endif

/* printerdrv/driver-select.c */
/* en */ {IDCLS_SPECIFY_PRT_DRIVER_4_NAME,    N_("Specify name of printer driver for device #4. (ascii/mps803/nl10/raw)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_PRT_DRIVER_4_NAME_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_PRT_DRIVER_4_NAME_DE, "Name fr Druckertreiber fr Gert #4 whlen. (ascii/mps803/nl10/raw)"},
/* es */ {IDCLS_SPECIFY_PRT_DRIVER_4_NAME_ES, "Especificar nombre controlador impresora perifrico #4. (ascii/mps803/nl10/raw)"},
/* fr */ {IDCLS_SPECIFY_PRT_DRIVER_4_NAME_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_PRT_DRIVER_4_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_PRT_DRIVER_4_NAME_IT, "Specifica il nome del driver di stampa per la periferica #4. (ascii/mps803/nl10/raw)"},
/* ko */ {IDCLS_SPECIFY_PRT_DRIVER_4_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_PRT_DRIVER_4_NAME_NL, "Geef de naam van het stuurprogramma voor apparaat #4. (ascii/mps803/nl10/raw)"},
/* pl */ {IDCLS_SPECIFY_PRT_DRIVER_4_NAME_PL, "Okrel nazw sterownika drukarki urzdzenia #4. (ascii/mps803/nl10/raw)"},
/* ru */ {IDCLS_SPECIFY_PRT_DRIVER_4_NAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_PRT_DRIVER_4_NAME_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_PRT_DRIVER_4_NAME_TR, ""},  /* fuzzy */
#endif

/* printerdrv/driver-select.c */
/* en */ {IDCLS_SPECIFY_PRT_DRIVER_5_NAME,    N_("Specify name of printer driver for device #5. (ascii/mps803/nl10/raw)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_PRT_DRIVER_5_NAME_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_PRT_DRIVER_5_NAME_DE, "Name fr Druckertreiber fr Gert #5 whlen. (ascii/mps803/nl10/raw)"},
/* es */ {IDCLS_SPECIFY_PRT_DRIVER_5_NAME_ES, "Especificar nombre controlador impresora perifrico #5. (ascii/mps803/nl10/raw)"},
/* fr */ {IDCLS_SPECIFY_PRT_DRIVER_5_NAME_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_PRT_DRIVER_5_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_PRT_DRIVER_5_NAME_IT, "Specifica il nome del driver di stampa per la periferica #5. (ascii/mps803/nl10/raw)"},
/* ko */ {IDCLS_SPECIFY_PRT_DRIVER_5_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_PRT_DRIVER_5_NAME_NL, "Geef de naam van het stuurprogramma voor apparaat #5. (ascii/mps803/nl10/raw)"},
/* pl */ {IDCLS_SPECIFY_PRT_DRIVER_5_NAME_PL, "Okrel nazw sterownika drukarki urzdzenia #5. (ascii/mps803/nl10/raw)"},
/* ru */ {IDCLS_SPECIFY_PRT_DRIVER_5_NAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_PRT_DRIVER_5_NAME_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_PRT_DRIVER_5_NAME_TR, ""},  /* fuzzy */
#endif

/* printerdrv/driver-select.c */
/* en */ {IDCLS_SPECIFY_PRT_DRIVER_6_NAME,    N_("Specify name of printer driver for device #6. (1520/raw)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_PRT_DRIVER_6_NAME_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_PRT_DRIVER_6_NAME_DE, "Name fr Druckertreiber fr Gert #6 whlen. (1520/raw)"},
/* es */ {IDCLS_SPECIFY_PRT_DRIVER_6_NAME_ES, "Especificar nombre controlador impresora perifrico #6. (ascii/mps803/nl10/raw)"},
/* fr */ {IDCLS_SPECIFY_PRT_DRIVER_6_NAME_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_PRT_DRIVER_6_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_PRT_DRIVER_6_NAME_IT, "Specifica il nome del driver di stampa per la periferica #4. (1520/raw)"},
/* ko */ {IDCLS_SPECIFY_PRT_DRIVER_6_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_PRT_DRIVER_6_NAME_NL, "Geef de naam van het stuurprogramma voor apparaat #6. (1520/raw)"},
/* pl */ {IDCLS_SPECIFY_PRT_DRIVER_6_NAME_PL, "Okrel nazw sterownika drukarki urzdzenia #6. (1520/raw)"},
/* ru */ {IDCLS_SPECIFY_PRT_DRIVER_6_NAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_PRT_DRIVER_6_NAME_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_PRT_DRIVER_6_NAME_TR, ""},  /* fuzzy */
#endif

/* printerdrv/driver-select.c */
/* en */ {IDCLS_SPECIFY_PRT_DRIVER_USR_NAME,    N_("Specify name of printer driver for the userport printer. (ascii/nl10/raw)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_DE, "Name fr Userport Druckertreiber whlen. (ascii/nl10/raw)"},
/* es */ {IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_ES, "Especificar nombre controlador impresin para puerto impresora. (ascii/nl10/raw)"},
/* fr */ {IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_IT, "Specifica il nome del driver di stampa per la stampante su userport. (ascii/nl10/raw)"},
/* ko */ {IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_NL, "Geef de naam van het stuurprogramma voor de userport printer. (ascii/nl10/raw)"},
/* pl */ {IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_PL, "Okrel nazw sterownika drukarki dla drukarki w userporcie. (ascii/nl10/raw)"},
/* ru */ {IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_TR, ""},  /* fuzzy */
#endif

/* printerdrv/interface-serial.c */
/* en */ {IDCLS_SET_DEVICE_TYPE_4,    N_("Set device type for device #4 (0: None, 1: Filesystem, 2: Real)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_DEVICE_TYPE_4_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_DEVICE_TYPE_4_DE, "Gertetyp fr Gert #4 (0: Kein, 1: Dateisystem, 2: Real) setzen"},
/* es */ {IDCLS_SET_DEVICE_TYPE_4_ES, "Seleccionar tipo para el perifrico #4 (0:Ninguno 1: Filesystem, 2:Real)"},
/* fr */ {IDCLS_SET_DEVICE_TYPE_4_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_DEVICE_TYPE_4_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_DEVICE_TYPE_4_IT, "Specifica il tipo di periferica #4 (0: Nessuna, 1: Filesystem, 2: Reale)"},
/* ko */ {IDCLS_SET_DEVICE_TYPE_4_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_DEVICE_TYPE_4_NL, "Stel apparaatsoort invoor apparaat #4 (0: Geen, 1: Bestandssysteem, 2: Echt)"},
/* pl */ {IDCLS_SET_DEVICE_TYPE_4_PL, "Okrel typ urzdzenia #4 (0: Brak, 1: System plikw, 2: Rzeczywiste)"},
/* ru */ {IDCLS_SET_DEVICE_TYPE_4_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_DEVICE_TYPE_4_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_DEVICE_TYPE_4_TR, ""},  /* fuzzy */
#endif

/* printerdrv/interface-serial.c */
/* en */ {IDCLS_SET_DEVICE_TYPE_5,    N_("Set device type for device #5 (0: None, 1: Filesystem, 2: Real)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_DEVICE_TYPE_5_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_DEVICE_TYPE_5_DE, "Gertetyp fr Gert #5 (0: Kein, 1: Dateisystem, 2: Real) setzen"},
/* es */ {IDCLS_SET_DEVICE_TYPE_5_ES, "Seleccionar tipo para el perifrico #5 (0:Ninguno 1: Filesystem, 2:Real)"},
/* fr */ {IDCLS_SET_DEVICE_TYPE_5_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_DEVICE_TYPE_5_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_DEVICE_TYPE_5_IT, "Specifica il tipo di periferica #5 (0: Nessuna, 1: Filesystem, 2: Reale)"},
/* ko */ {IDCLS_SET_DEVICE_TYPE_5_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_DEVICE_TYPE_5_NL, "Stel apparaatsoort in voor apparaat #5 (0: Geen, 1: Bestandssysteem, 2: Echt)"},
/* pl */ {IDCLS_SET_DEVICE_TYPE_5_PL, "Okrel typ urzdzenia #5 (0: Brak, 1: System plikw, 2: Rzeczywiste)"},
/* ru */ {IDCLS_SET_DEVICE_TYPE_5_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_DEVICE_TYPE_5_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_DEVICE_TYPE_5_TR, ""},  /* fuzzy */
#endif

/* printerdrv/interface-serial.c */
/* en */ {IDCLS_SET_DEVICE_TYPE_6,    N_("Set device type for device #6 (0: None, 1: Filesystem, 2: Real)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_DEVICE_TYPE_6_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_DEVICE_TYPE_6_DE, "Gertetyp fr Gert #6 (0: Kein, 1: Dateisystem, 2: Real) setzen"},
/* es */ {IDCLS_SET_DEVICE_TYPE_6_ES, "Seleccionar tipo para el perifrico #6 (0:Ninguno 1: Filesystem, 2:Real)"},
/* fr */ {IDCLS_SET_DEVICE_TYPE_6_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_DEVICE_TYPE_6_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_DEVICE_TYPE_6_IT, "Specifica il tipo di periferica #6 (0: Nessuna, 1: Filesystem, 2: Reale)"},
/* ko */ {IDCLS_SET_DEVICE_TYPE_6_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_DEVICE_TYPE_6_NL, "Stel apparaatsoort in voor apparaat #6 (0: Geen, 1: Bestandssysteem, 2: Echt)"},
/* pl */ {IDCLS_SET_DEVICE_TYPE_6_PL, "Okrel typ urzdzenia #6 (0: Brak, 1: System plikw, 2: Rzeczywiste)"},
/* ru */ {IDCLS_SET_DEVICE_TYPE_6_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_DEVICE_TYPE_6_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_DEVICE_TYPE_6_TR, ""},  /* fuzzy */
#endif

/* printerdrv/interface-serial.c */
/* en */ {IDCLS_SET_DEVICE_TYPE_7,    N_("Set device type for device #7 (0: None, 2: Real)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_DEVICE_TYPE_7_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SET_DEVICE_TYPE_7_DE, "Gertetyp fr Gert #7 (0: Kein, 2: Real) setzen"},
/* es */ {IDCLS_SET_DEVICE_TYPE_7_ES, "Seleccionar tipo para el perifrico #7 (0:Ninguno 1: Filesystem, 2:Real)"},
/* fr */ {IDCLS_SET_DEVICE_TYPE_7_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SET_DEVICE_TYPE_7_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SET_DEVICE_TYPE_7_IT, "Specifica il tipo di periferica #7 (0: Nessuna, 1: Filesystem, 2: Reale)"},
/* ko */ {IDCLS_SET_DEVICE_TYPE_7_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_DEVICE_TYPE_7_NL, "Stel apparaatsoort in voor apparaat #7 (0: Geen, 2: Echt)"},
/* pl */ {IDCLS_SET_DEVICE_TYPE_7_PL, "Okrel typ urzdzenia #7 (0: Brak, 2: Rzeczywiste)"},
/* ru */ {IDCLS_SET_DEVICE_TYPE_7_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SET_DEVICE_TYPE_7_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SET_DEVICE_TYPE_7_TR, ""},  /* fuzzy */
#endif

/* printerdrv/interface-userport.c */
/* en */ {IDCLS_ENABLE_USERPORT_PRINTER,    N_("Enable the userport printer emulation")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_USERPORT_PRINTER_DA, "Aktivr emulering af printer p brugerporten"},
/* de */ {IDCLS_ENABLE_USERPORT_PRINTER_DE, "Userport Drucker Emulation aktivieren"},
/* es */ {IDCLS_ENABLE_USERPORT_PRINTER_ES, "Permitir emulacin puerto impresora"},
/* fr */ {IDCLS_ENABLE_USERPORT_PRINTER_FR, "Acviver l'mulation de l'imprimante userport"},
/* hu */ {IDCLS_ENABLE_USERPORT_PRINTER_HU, "Userport nyomtat emulcijnak engedlyezse"},
/* it */ {IDCLS_ENABLE_USERPORT_PRINTER_IT, "Attiva l'emulazione della stampante su userport"},
/* ko */ {IDCLS_ENABLE_USERPORT_PRINTER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_USERPORT_PRINTER_NL, "Userport printeremulatie inschakelen"},
/* pl */ {IDCLS_ENABLE_USERPORT_PRINTER_PL, "Wcz emulacj drukarki w userporcie"},
/* ru */ {IDCLS_ENABLE_USERPORT_PRINTER_RU, "Enable the userport printer emulation"},
/* sv */ {IDCLS_ENABLE_USERPORT_PRINTER_SV, "Aktivera emulering av skrivare p anvndarporten"},
/* tr */ {IDCLS_ENABLE_USERPORT_PRINTER_TR, "Userport yazc emlasyonunu aktif et"},
#endif

/* printerdrv/interface-userport.c */
/* en */ {IDCLS_DISABLE_USERPORT_PRINTER,    N_("Disable the userport printer emulation")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_USERPORT_PRINTER_DA, "Deaktivr emulering af printer p brugerporten"},
/* de */ {IDCLS_DISABLE_USERPORT_PRINTER_DE, "Userport Drucker Emulation deaktivieren"},
/* es */ {IDCLS_DISABLE_USERPORT_PRINTER_ES, "Deshabilitar emulacin puerto impresora"},
/* fr */ {IDCLS_DISABLE_USERPORT_PRINTER_FR, "Dsactiver l'mulation de l'imprimante userport"},
/* hu */ {IDCLS_DISABLE_USERPORT_PRINTER_HU, "Userport nyomtat emulcijnak tiltsa"},
/* it */ {IDCLS_DISABLE_USERPORT_PRINTER_IT, "Disattiva l'emulazione della stampante su userport"},
/* ko */ {IDCLS_DISABLE_USERPORT_PRINTER_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_USERPORT_PRINTER_NL, "Userport printeremulatie uitschakelen"},
/* pl */ {IDCLS_DISABLE_USERPORT_PRINTER_PL, "Wycz emulacj drukarki w userporcie"},
/* ru */ {IDCLS_DISABLE_USERPORT_PRINTER_RU, "Disable the userport printer emulation"},
/* sv */ {IDCLS_DISABLE_USERPORT_PRINTER_SV, "Inaktivera emulering av skrivare p anvndarporten"},
/* tr */ {IDCLS_DISABLE_USERPORT_PRINTER_TR, "Userport yazc emlasyonunu pasifletir"},
#endif

/* printerdrv/output-select.c */
/* en */ {IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME,    N_("Specify name of output device for device #4")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_DA, "Angiv navn p uddataenhed for enhed #4"},
/* de */ {IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_DE, "Name fr Druckerausgabe Datei Gert #4 whlen"},
/* es */ {IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_ES, "Especificar nombre perifrico de salida para perifrico #4"},
/* fr */ {IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_FR, "Spcifiez le nom du priphrique de sortie pour le priphrique #4"},
/* hu */ {IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_HU, "Adja meg a kimeneti eszkz nevt a #4-es egysghez"},
/* it */ {IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_IT, "Specifica il nome del dispositivo di output per la periferica #4"},
/* ko */ {IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_NL, "Geef de naam van het uitvoerapparaat voor apparaat #4"},
/* pl */ {IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_PL, "Okrel nazw urzdzenia wyjcia #4"},
/* ru */ {IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_RU, "Specify name of output device for device #4"},
/* sv */ {IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_SV, "Ange namn p utskriftsenhet fr enhet 4"},
/* tr */ {IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_TR, "Aygt #4 iin k aygt ismini belirt"},
#endif

/* printerdrv/output-select.c */
/* en */ {IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME,    N_("Specify name of output device for device #5")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_DA, "Angiv navn p uddataenhed for enhed #5"},
/* de */ {IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_DE, "Name fr Druckerausgabe Datei Gert #5 whlen"},
/* es */ {IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_ES, "Especificar nombre perifrico de salida para perifrico #5"},
/* fr */ {IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_FR, "Spcifiez le nom du priphrique de sortie pour le priphrique #5"},
/* hu */ {IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_HU, "Adja meg a kimeneti eszkz nevt a #5-s egysghez"},
/* it */ {IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_IT, "Specifica il nome del dispositivo di output per la periferica #5"},
/* ko */ {IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_NL, "Geef de naam van het uitvoerapparaat voor apparaat #5"},
/* pl */ {IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_PL, "Okrel nazw urzdzenia wyjcia #5"},
/* ru */ {IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_RU, "Specify name of output device for device #5"},
/* sv */ {IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_SV, "Ange namn p utskriftsenhet fr enhet 5"},
/* tr */ {IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_TR, "Aygt #5 iin k aygt ismini belirt"},
#endif

/* printerdrv/output-select.c */
/* en */ {IDCLS_SPECIFY_OUTPUT_DEVICE_6_NAME,    N_("Specify name of output device for device #6")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_OUTPUT_DEVICE_6_NAME_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_OUTPUT_DEVICE_6_NAME_DE, "Name fr Druckerausgabe Datei Gert #6 whlen"},
/* es */ {IDCLS_SPECIFY_OUTPUT_DEVICE_6_NAME_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SPECIFY_OUTPUT_DEVICE_6_NAME_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_OUTPUT_DEVICE_6_NAME_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_OUTPUT_DEVICE_6_NAME_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SPECIFY_OUTPUT_DEVICE_6_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_OUTPUT_DEVICE_6_NAME_NL, "Geef de naam van het uitvoerapparaat voor apparaat #6"},
/* pl */ {IDCLS_SPECIFY_OUTPUT_DEVICE_6_NAME_PL, "Okrel nazw urzdzenia wyjcia #6"},
/* ru */ {IDCLS_SPECIFY_OUTPUT_DEVICE_6_NAME_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_OUTPUT_DEVICE_6_NAME_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_OUTPUT_DEVICE_6_NAME_TR, ""},  /* fuzzy */
#endif

/* printerdrv/output-select.c */
/* en */ {IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME,    N_("Specify name of output device for the userport printer")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_DA, "Angiv navn p uddataenhed for brugerports-printer"},
/* de */ {IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_DE, "Name fr Druckerausgabe Datei Userport whlen"},
/* es */ {IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_ES, "Especificar nombre perifrico de salida para puerto usuario impresora"},
/* fr */ {IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_FR, "Spcifiez le nom du priphrique de sortie pour l'imprimante userport"},
/* hu */ {IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_HU, "Adja meg a kimeneti eszkz nevt a userport nyomtathoz"},
/* it */ {IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_IT, "Specifica il nome del dispositivo di output per la stampante su userport"},
/* ko */ {IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_NL, "Geef de naam van het uitvoerapparaat voor de userport printer"},
/* pl */ {IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_PL, "Okrel nazw urzdzenia wyjciowego dla drukarki w userporcie"},
/* ru */ {IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_RU, "Specify name of output device for the userport printer"},
/* sv */ {IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_SV, "Ange namn p utskriftsenhet fr anvndarporten"},
/* tr */ {IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_TR, "Userport yazcs iin k aygt ismini belirt"},
#endif

/* printerdrv/output-text.c */
/* en */ {IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME,    N_("Specify name of printer text device or dump file")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_DA, "Angiv navn p printer-tekst-enhed eller dump-fil"},
/* de */ {IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_DE, "Name fr Druckerausgabe Textgert oder Dump Datei whlen"},
/* es */ {IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_ES, "Especificar nombre del perifrico para imprimir texto o fichero de volcado"},
/* fr */ {IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_FR, "Spcifier le nom de l'imprimante texte ou \"dump file\""},
/* hu */ {IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_HU, "Adja meg a szvegnyomtat eszkz nevt, vagy a kimeneti fjlt"},
/* it */ {IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_IT, "Specifica il nome del dispositivo testuale di stampa o salva su file"},
/* ko */ {IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_NL, "Geef de naam van het printer tekst apparaat of het dumpbestand"},
/* pl */ {IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_PL, "Okrel nazw urzdzenia tekstowego drukarki lub pliku zrzutu"},
/* ru */ {IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_RU, "Specify name of printer text device or dump file"},
/* sv */ {IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_SV, "Ange namn p textenhet fr utskrift eller dumpfil"},
/* tr */ {IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_TR, "Metin aygt yazcs ya da dkm dosyasnn ismini belirt"},
#endif

/* printerdrv/output-text.c */
/* en */ {IDCLS_SPECIFY_TEXT_DEVICE_4,    N_("Specify printer text output device for printer #4")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_TEXT_DEVICE_4_DA, "Angiv printer tekst-uddata enhed for printer #4"},
/* de */ {IDCLS_SPECIFY_TEXT_DEVICE_4_DE, "Textausgabe Gert fr Drucker #4 whlen"},
/* es */ {IDCLS_SPECIFY_TEXT_DEVICE_4_ES, "Especificar perifrico salida impresin texto impresora #4"},
/* fr */ {IDCLS_SPECIFY_TEXT_DEVICE_4_FR, "Spcifier le priphrique de sortie texte pour l'imprimante 4"},
/* hu */ {IDCLS_SPECIFY_TEXT_DEVICE_4_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_TEXT_DEVICE_4_IT, "Specifica il dispositivo di uscita testuale per la stampante #4"},
/* ko */ {IDCLS_SPECIFY_TEXT_DEVICE_4_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_TEXT_DEVICE_4_NL, "Geef het printer tekst uitvoer apparaat voor printer #4"},
/* pl */ {IDCLS_SPECIFY_TEXT_DEVICE_4_PL, "Okrel urzdzenie wyjcia tekstowego drukarki #4"},
/* ru */ {IDCLS_SPECIFY_TEXT_DEVICE_4_RU, "Specify printer text output device for printer #4"},
/* sv */ {IDCLS_SPECIFY_TEXT_DEVICE_4_SV, "Ange skrivartextutenhet fr skrivare 4"},
/* tr */ {IDCLS_SPECIFY_TEXT_DEVICE_4_TR, "Yazc #4 iin metin kt aygt yazcs belirt"},
#endif

/* printerdrv/output-text.c */
/* en */ {IDCLS_SPECIFY_TEXT_DEVICE_5,    N_("Specify printer text output device for printer #5")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_TEXT_DEVICE_5_DA, "Angiv printer tekst-uddata enhed for printer #5"},
/* de */ {IDCLS_SPECIFY_TEXT_DEVICE_5_DE, "Textausgabe Gert fr Drucker #5 whlen"},
/* es */ {IDCLS_SPECIFY_TEXT_DEVICE_5_ES, "Especificar perifrico salida impresin texto impresora #5"},
/* fr */ {IDCLS_SPECIFY_TEXT_DEVICE_5_FR, "Spcifier le priphrique de sortie texte pour l'imprimante 5"},
/* hu */ {IDCLS_SPECIFY_TEXT_DEVICE_5_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_TEXT_DEVICE_5_IT, "Specifica il dispositivo di uscita testuale per la stampante #5"},
/* ko */ {IDCLS_SPECIFY_TEXT_DEVICE_5_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_TEXT_DEVICE_5_NL, "Geef het printer tekst uitvoer apparaat voor printer #5"},
/* pl */ {IDCLS_SPECIFY_TEXT_DEVICE_5_PL, "Okrel urzdzenie wyjcia tekstowego drukarki #5"},
/* ru */ {IDCLS_SPECIFY_TEXT_DEVICE_5_RU, "Specify printer text output device for printer #5"},
/* sv */ {IDCLS_SPECIFY_TEXT_DEVICE_5_SV, "Ange skrivartextutenhet fr skrivare 5"},
/* tr */ {IDCLS_SPECIFY_TEXT_DEVICE_5_TR, "Yazc #5 iin metin kt aygt yazcs belirt"},
#endif

/* printerdrv/output-text.c */
/* en */ {IDCLS_SPECIFY_TEXT_DEVICE_6,    N_("Specify printer text output device for printer #6")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_TEXT_DEVICE_6_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SPECIFY_TEXT_DEVICE_6_DE, "Textausgabe Gert fr Drucker #6 whlen"},
/* es */ {IDCLS_SPECIFY_TEXT_DEVICE_6_ES, "Especificar perifrico salida impresin texto impresora #6"},
/* fr */ {IDCLS_SPECIFY_TEXT_DEVICE_6_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SPECIFY_TEXT_DEVICE_6_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_TEXT_DEVICE_6_IT, "Specifica il dispositivo di uscita testuale per la stampante #6"},
/* ko */ {IDCLS_SPECIFY_TEXT_DEVICE_6_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_TEXT_DEVICE_6_NL, "Geef het printer tekst uitvoer apparaat voor printer #6"},
/* pl */ {IDCLS_SPECIFY_TEXT_DEVICE_6_PL, "Okrel urzdzenie wyjcia tekstowego drukarki #6"},
/* ru */ {IDCLS_SPECIFY_TEXT_DEVICE_6_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SPECIFY_TEXT_DEVICE_6_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SPECIFY_TEXT_DEVICE_6_TR, ""},  /* fuzzy */
#endif

/* printerdrv/output-text.c */
/* en */ {IDCLS_SPECIFY_TEXT_USERPORT,    N_("Specify printer text output device for userport printer")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_TEXT_USERPORT_DA, "Angiv printer tekst-uddata enhed for brugerports-printer"},
/* de */ {IDCLS_SPECIFY_TEXT_USERPORT_DE, "Textausgabe Gert fr Userport Drucker whlen"},
/* es */ {IDCLS_SPECIFY_TEXT_USERPORT_ES, "Especificar perifrico de salida para imprimir texto impresora puerto usuario"},
/* fr */ {IDCLS_SPECIFY_TEXT_USERPORT_FR, "Spcifier le priphrique de sortie text pour l'imprimante userport"},
/* hu */ {IDCLS_SPECIFY_TEXT_USERPORT_HU, "Adja meg a szvegnyomtat eszkzt a userport nyomtathoz"},
/* it */ {IDCLS_SPECIFY_TEXT_USERPORT_IT, "Specifica il nome del dispositivo di output testuale di stampa per la stampante su userport"},
/* ko */ {IDCLS_SPECIFY_TEXT_USERPORT_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_TEXT_USERPORT_NL, "Geef het printer tekst uitvoer apparaat voor de userport printer"},
/* pl */ {IDCLS_SPECIFY_TEXT_USERPORT_PL, "Okrel urzdzenie wyjcia tekstu dla drukarki w userporcie"},
/* ru */ {IDCLS_SPECIFY_TEXT_USERPORT_RU, "Specify printer text output device for userport printer"},
/* sv */ {IDCLS_SPECIFY_TEXT_USERPORT_SV, "Ange skrivartextutenhet fr anvndarportsskrivare"},
/* tr */ {IDCLS_SPECIFY_TEXT_USERPORT_TR, "Userport yazcs iin metin kt aygt yazcs belirt"},
#endif

/* raster/raster-cmdline-options.c */
/* en */ {IDCLS_ENABLE_VIDEO_CACHE,    N_("Enable the video cache")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_VIDEO_CACHE_DA, "Aktivr videocache"},
/* de */ {IDCLS_ENABLE_VIDEO_CACHE_DE, "Video Cache aktivieren"},
/* es */ {IDCLS_ENABLE_VIDEO_CACHE_ES, "Permitir cach de video"},
/* fr */ {IDCLS_ENABLE_VIDEO_CACHE_FR, "Activer le cache vido"},
/* hu */ {IDCLS_ENABLE_VIDEO_CACHE_HU, "Vide gyorsttr engedlyezse"},
/* it */ {IDCLS_ENABLE_VIDEO_CACHE_IT, "Attiva la cache video"},
/* ko */ {IDCLS_ENABLE_VIDEO_CACHE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_VIDEO_CACHE_NL, "Videocache inschakelen"},
/* pl */ {IDCLS_ENABLE_VIDEO_CACHE_PL, "Wcz cache wideo"},
/* ru */ {IDCLS_ENABLE_VIDEO_CACHE_RU, "Enable the video cache"},
/* sv */ {IDCLS_ENABLE_VIDEO_CACHE_SV, "Aktivera videocache"},
/* tr */ {IDCLS_ENABLE_VIDEO_CACHE_TR, "Grnt nbelleini aktif et"},
#endif

/* raster/raster-cmdline-options.c */
/* en */ {IDCLS_DISABLE_VIDEO_CACHE,    N_("Disable the video cache")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_VIDEO_CACHE_DA, "Deaktivr videocache"},
/* de */ {IDCLS_DISABLE_VIDEO_CACHE_DE, "Video Cache deaktivieren"},
/* es */ {IDCLS_DISABLE_VIDEO_CACHE_ES, "Deshabilitar cach de vdeo"},
/* fr */ {IDCLS_DISABLE_VIDEO_CACHE_FR, "Dsactiver le cache vido"},
/* hu */ {IDCLS_DISABLE_VIDEO_CACHE_HU, "Vide gyorsttr tiltsa"},
/* it */ {IDCLS_DISABLE_VIDEO_CACHE_IT, "Disattiva la cache video"},
/* ko */ {IDCLS_DISABLE_VIDEO_CACHE_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_VIDEO_CACHE_NL, "Videocache uitschakelen"},
/* pl */ {IDCLS_DISABLE_VIDEO_CACHE_PL, "Wycz cache wideo"},
/* ru */ {IDCLS_DISABLE_VIDEO_CACHE_RU, "Disable the video cache"},
/* sv */ {IDCLS_DISABLE_VIDEO_CACHE_SV, "Inaktivera videocache"},
/* tr */ {IDCLS_DISABLE_VIDEO_CACHE_TR, "Grnt nbelleini pasifletir"},
#endif

#if defined(HAVE_RS232DEV) || defined(HAVE_RS232NET)
/* rs232drv/rs232drv.c */
/* en */ {IDCLS_SPECIFY_RS232_1_NAME,    N_("Specify name of first RS232 device")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_RS232_1_NAME_DA, "Angiv navn p frste RS232-enhed"},
/* de */ {IDCLS_SPECIFY_RS232_1_NAME_DE, "Name fr erstes RS232 Gert whlen"},
/* es */ {IDCLS_SPECIFY_RS232_1_NAME_ES, "Especificar el nombre del primer perifrico RS232"},
/* fr */ {IDCLS_SPECIFY_RS232_1_NAME_FR, "Spcifier le nom du 1er priphrique RS232"},
/* hu */ {IDCLS_SPECIFY_RS232_1_NAME_HU, "Adja meg az els RS232-es eszkz nevt"},
/* it */ {IDCLS_SPECIFY_RS232_1_NAME_IT, "Specifica il nome della prima RS232"},
/* ko */ {IDCLS_SPECIFY_RS232_1_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_RS232_1_NAME_NL, "Geef de naam van het eerste RS232 apparaat"},
/* pl */ {IDCLS_SPECIFY_RS232_1_NAME_PL, "Okrel nazw pierwszego urzdzenia RS232"},
/* ru */ {IDCLS_SPECIFY_RS232_1_NAME_RU, "Specify name of first RS232 device"},
/* sv */ {IDCLS_SPECIFY_RS232_1_NAME_SV, "Ange namn p frsta RS232-enheten"},
/* tr */ {IDCLS_SPECIFY_RS232_1_NAME_TR, "lk RS232 aygtnn ismini belirt"},
#endif

/* rs232drv/rs232drv.c */
/* en */ {IDCLS_SPECIFY_RS232_2_NAME,    N_("Specify name of second RS232 device")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_RS232_2_NAME_DA, "Angiv navn p anden RS232-enhed"},
/* de */ {IDCLS_SPECIFY_RS232_2_NAME_DE, "Name fr zweites RS232 Gert whlen"},
/* es */ {IDCLS_SPECIFY_RS232_2_NAME_ES, "Especificar el nombre del segundo perifrico RS232"},
/* fr */ {IDCLS_SPECIFY_RS232_2_NAME_FR, "Spcifier le nom du 2e priphrique RS232"},
/* hu */ {IDCLS_SPECIFY_RS232_2_NAME_HU, "Adja meg a msodik RS232-es eszkz nevt"},
/* it */ {IDCLS_SPECIFY_RS232_2_NAME_IT, "Specifica il nome della seconda RS232"},
/* ko */ {IDCLS_SPECIFY_RS232_2_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_RS232_2_NAME_NL, "Geef de naam van het tweede RS232 apparaat"},
/* pl */ {IDCLS_SPECIFY_RS232_2_NAME_PL, "Okrel nazw drugiego urzdzenia RS232"},
/* ru */ {IDCLS_SPECIFY_RS232_2_NAME_RU, "Specify name of second RS232 device"},
/* sv */ {IDCLS_SPECIFY_RS232_2_NAME_SV, "Ange namn p andra RS232-enheten"},
/* tr */ {IDCLS_SPECIFY_RS232_2_NAME_TR, "kinci RS232 aygtnn ismini belirt"},
#endif

/* rs232drv/rs232drv.c */
/* en */ {IDCLS_SPECIFY_RS232_3_NAME,    N_("Specify name of third RS232 device")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_RS232_3_NAME_DA, "Angiv navn p tredje RS232-enhed"},
/* de */ {IDCLS_SPECIFY_RS232_3_NAME_DE, "Name fr drittes RS232 Gert whlen"},
/* es */ {IDCLS_SPECIFY_RS232_3_NAME_ES, "Especificar el nombre del tercer perifrico RS232"},
/* fr */ {IDCLS_SPECIFY_RS232_3_NAME_FR, "Spcifier le nom du 3e priphrique RS232"},
/* hu */ {IDCLS_SPECIFY_RS232_3_NAME_HU, "Adja meg a harmadik RS232-es eszkz nevt"},
/* it */ {IDCLS_SPECIFY_RS232_3_NAME_IT, "Specifica il nome della terza RS232"},
/* ko */ {IDCLS_SPECIFY_RS232_3_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_RS232_3_NAME_NL, "Geef de naam van het derde RS232 apparaat"},
/* pl */ {IDCLS_SPECIFY_RS232_3_NAME_PL, "Okrel nazw trzeciego urzdzenia RS232"},
/* ru */ {IDCLS_SPECIFY_RS232_3_NAME_RU, "Specify name of third RS232 device"},
/* sv */ {IDCLS_SPECIFY_RS232_3_NAME_SV, "Ange namn p tredje RS232-enheten"},
/* tr */ {IDCLS_SPECIFY_RS232_3_NAME_TR, "nc RS232 aygtnn ismini belirt"},
#endif

/* rs232drv/rs232drv.c */
/* en */ {IDCLS_SPECIFY_RS232_4_NAME,    N_("Specify name of fourth RS232 device")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_RS232_4_NAME_DA, "Angiv navn p fjerde RS232-enhed"},
/* de */ {IDCLS_SPECIFY_RS232_4_NAME_DE, "Name fr viertes RS232 Gert whlen"},
/* es */ {IDCLS_SPECIFY_RS232_4_NAME_ES, "Especificar el nombre del cuarto perifrico RS232"},
/* fr */ {IDCLS_SPECIFY_RS232_4_NAME_FR, "Spcifier le nom du 4e priphrique RS232"},
/* hu */ {IDCLS_SPECIFY_RS232_4_NAME_HU, "Adja meg a negyedik RS232-es eszkz nevt"},
/* it */ {IDCLS_SPECIFY_RS232_4_NAME_IT, "Specifica il nome della quarta RS232"},
/* ko */ {IDCLS_SPECIFY_RS232_4_NAME_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_RS232_4_NAME_NL, "Geef de naam van het vierde RS232 apparaat"},
/* pl */ {IDCLS_SPECIFY_RS232_4_NAME_PL, "Okrel nazw czwartego urzdzenia RS232"},
/* ru */ {IDCLS_SPECIFY_RS232_4_NAME_RU, "Specify name of fourth RS232 device"},
/* sv */ {IDCLS_SPECIFY_RS232_4_NAME_SV, "Ange namn p fjrde RS232-enheten"},
/* tr */ {IDCLS_SPECIFY_RS232_4_NAME_TR, "Drdnc RS232 aygtnn ismini belirt"},
#endif
#endif

/* rs232drv/rsuser.c */
/* en */ {IDCLS_ENABLE_RS232_USERPORT,    N_("Enable RS232 userport emulation")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_RS232_USERPORT_DA, "Aktivr RS232-emulering p brugerporten"},
/* de */ {IDCLS_ENABLE_RS232_USERPORT_DE, "RS232 Userport Emulation aktivieren"},
/* es */ {IDCLS_ENABLE_RS232_USERPORT_ES, "Permitir Emulacin puerto RS232"},
/* fr */ {IDCLS_ENABLE_RS232_USERPORT_FR, "Activer l'mulation de priphrique RS232 userport"},
/* hu */ {IDCLS_ENABLE_RS232_USERPORT_HU, "RS232 userport emulci engedlyezse"},
/* it */ {IDCLS_ENABLE_RS232_USERPORT_IT, "Attiva l'emulazione della RS232 su userport"},
/* ko */ {IDCLS_ENABLE_RS232_USERPORT_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_RS232_USERPORT_NL, "RS232 userportemulatie inschakelen"},
/* pl */ {IDCLS_ENABLE_RS232_USERPORT_PL, "Wcz emulacj userportu RS232"},
/* ru */ {IDCLS_ENABLE_RS232_USERPORT_RU, "Enable RS232 userport emulation"},
/* sv */ {IDCLS_ENABLE_RS232_USERPORT_SV, "Aktivera RS232-emulering p anvndarporten"},
/* tr */ {IDCLS_ENABLE_RS232_USERPORT_TR, "RS232 userport emlasyonunu aktif et"},
#endif

/* rs232drv/rsuser.c */
/* en */ {IDCLS_DISABLE_RS232_USERPORT,    N_("Disable RS232 userport emulation")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_RS232_USERPORT_DA, "Deaktivr RS232-emulering p brugerporten"},
/* de */ {IDCLS_DISABLE_RS232_USERPORT_DE, "RS232 Userport Emulation deaktivieren"},
/* es */ {IDCLS_DISABLE_RS232_USERPORT_ES, "Deshabilitar Emulacin puerto RS232"},
/* fr */ {IDCLS_DISABLE_RS232_USERPORT_FR, "Dsactiver l'mulation de priphrique RS232 userport"},
/* hu */ {IDCLS_DISABLE_RS232_USERPORT_HU, "RS232 userport emulci tiltsa"},
/* it */ {IDCLS_DISABLE_RS232_USERPORT_IT, "Disattiva l'emulazione della RS232 su userport"},
/* ko */ {IDCLS_DISABLE_RS232_USERPORT_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_RS232_USERPORT_NL, "RS232 userportemulatie uitschakelen"},
/* pl */ {IDCLS_DISABLE_RS232_USERPORT_PL, "Wycz emulacj userportu RS232"},
/* ru */ {IDCLS_DISABLE_RS232_USERPORT_RU, "Disable RS232 userport emulation"},
/* sv */ {IDCLS_DISABLE_RS232_USERPORT_SV, "Inaktivera RS232-emulering p anvndarporten"},
/* tr */ {IDCLS_DISABLE_RS232_USERPORT_TR, "RS232 userport emlasyonunu pasifletir"},
#endif

/* rs232drv/rsuser.c */
/* en */ {IDCLS_P_BAUD,    N_("<baud>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_BAUD_DA, "<baud>"},
/* de */ {IDCLS_P_BAUD_DE, "<Baud>"},
/* es */ {IDCLS_P_BAUD_ES, "<baudios>"},
/* fr */ {IDCLS_P_BAUD_FR, "<baud>"},
/* hu */ {IDCLS_P_BAUD_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_BAUD_IT, "<baud>"},
/* ko */ {IDCLS_P_BAUD_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_BAUD_NL, "<baud>"},
/* pl */ {IDCLS_P_BAUD_PL, "<bod>"},
/* ru */ {IDCLS_P_BAUD_RU, "<baud>"},
/* sv */ {IDCLS_P_BAUD_SV, "<baud>"},
/* tr */ {IDCLS_P_BAUD_TR, "<baud>"},
#endif

/* rs232drv/rsuser.c */
/* en */ {IDCLS_SET_BAUD_RS232_USERPORT,    N_("Set the baud rate of the RS232 userport emulation.")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SET_BAUD_RS232_USERPORT_DA, "Angiv baudhastighet for RS232-emuleringen p brugerporten."},
/* de */ {IDCLS_SET_BAUD_RS232_USERPORT_DE, "Baudrate fr RS232 Userport Emulation setzen"},
/* es */ {IDCLS_SET_BAUD_RS232_USERPORT_ES, "Seleccionar velocidad (baudios) para Emulacin puerto RS232"},
/* fr */ {IDCLS_SET_BAUD_RS232_USERPORT_FR, "Spcifiez la vitesse en baud du priphrique RS232 userport"},
/* hu */ {IDCLS_SET_BAUD_RS232_USERPORT_HU, "Bitrta megadsa az RS232 userport emulcihoz."},
/* it */ {IDCLS_SET_BAUD_RS232_USERPORT_IT, "Imposta la velocit della RS232 su userport (in baud)"},
/* ko */ {IDCLS_SET_BAUD_RS232_USERPORT_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SET_BAUD_RS232_USERPORT_NL, "Stel de baud rate in van de RS232 userport emulatie."},
/* pl */ {IDCLS_SET_BAUD_RS232_USERPORT_PL, "Okrel prdko transmisji emulacji userportu RS232."},
/* ru */ {IDCLS_SET_BAUD_RS232_USERPORT_RU, "Set the baud rate of the RS232 userport emulation."},
/* sv */ {IDCLS_SET_BAUD_RS232_USERPORT_SV, "Ange baudhastighet fr RS232-emuleringen p anvndarporten."},
/* tr */ {IDCLS_SET_BAUD_RS232_USERPORT_TR, "RS232 userport emlasyonunun baud rate'ini ayarla."},
#endif

/* rs232drv/rsuser.c */
/* en */ {IDCLS_SPECIFY_RS232_DEVICE_USERPORT,    N_("Specify VICE RS232 device for userport")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_RS232_DEVICE_USERPORT_DA, "Angiv VICE RS232-enhed for brugerporten"},
/* de */ {IDCLS_SPECIFY_RS232_DEVICE_USERPORT_DE, "VICE RS232 Gert fr Userport whlen"},
/* es */ {IDCLS_SPECIFY_RS232_DEVICE_USERPORT_ES, "Especificar perifrico VICE RS232 para puerto usuario"},
/* fr */ {IDCLS_SPECIFY_RS232_DEVICE_USERPORT_FR, "Spcifier un priphrique VICE RS232 pour le userport"},
/* hu */ {IDCLS_SPECIFY_RS232_DEVICE_USERPORT_HU, "VICE RS232-es userport eszkz megadsa"},
/* it */ {IDCLS_SPECIFY_RS232_DEVICE_USERPORT_IT, "Specifica il dispositivo RS232 di VICE per userport"},
/* ko */ {IDCLS_SPECIFY_RS232_DEVICE_USERPORT_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_RS232_DEVICE_USERPORT_NL, "Geef VICE RS232 apparaat voor userport"},
/* pl */ {IDCLS_SPECIFY_RS232_DEVICE_USERPORT_PL, "Okrel urzdzenie VICE RS232 w userporcie"},
/* ru */ {IDCLS_SPECIFY_RS232_DEVICE_USERPORT_RU, "Specify VICE RS232 device for userport"},
/* sv */ {IDCLS_SPECIFY_RS232_DEVICE_USERPORT_SV, "Ange VICE RS232-enhet fr anvndarporten"},
/* tr */ {IDCLS_SPECIFY_RS232_DEVICE_USERPORT_TR, "Userport iin VICE RS232 aygtn belirt"},
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_ENABLE_IEC_4,    N_("Enable IEC device emulation for device #4")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_IEC_4_DA, "Aktivr IEC-enhedsemulering for enhed #4"},
/* de */ {IDCLS_ENABLE_IEC_4_DE, "IEC Gerte Emulation fr Gert #4 aktivieren"},
/* es */ {IDCLS_ENABLE_IEC_4_ES, "Permitir emulacin IEC para perifrico #4 "},
/* fr */ {IDCLS_ENABLE_IEC_4_FR, "Activer l'mulation IEC pour le priphrique #4"},
/* hu */ {IDCLS_ENABLE_IEC_4_HU, "IEC eszkz #4 emulcijnak engedlyezse"},
/* it */ {IDCLS_ENABLE_IEC_4_IT, "Attiva emulazione IEC per la periferica #4"},
/* ko */ {IDCLS_ENABLE_IEC_4_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_IEC_4_NL, "IEC apparaat emulatie voor apparaat #4 inschakelen"},
/* pl */ {IDCLS_ENABLE_IEC_4_PL, "Wcz emulacj IEC urzdzenia #4"},
/* ru */ {IDCLS_ENABLE_IEC_4_RU, "Enable IEC device emulation for device #4"},
/* sv */ {IDCLS_ENABLE_IEC_4_SV, "Aktivera IEC-enhetsemulering fr enhet 4"},
/* tr */ {IDCLS_ENABLE_IEC_4_TR, "Aygt #4 iin IEC aygt emlasyonunu aktif et"},
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_DISABLE_IEC_4,    N_("Disable IEC device emulation for device #4")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_IEC_4_DA, "Deaktivr IEC-enhedsemulering for enhed #4"},
/* de */ {IDCLS_DISABLE_IEC_4_DE, "IEC Gerte Emulation fr Gert #4 deaktivieren"},
/* es */ {IDCLS_DISABLE_IEC_4_ES, "Deshabilitar emulacin IEC para perifrico #4 "},
/* fr */ {IDCLS_DISABLE_IEC_4_FR, "Dsactiver l'mulation IEC pour le priphrique #4"},
/* hu */ {IDCLS_DISABLE_IEC_4_HU, "IEC eszkz #4 emulcijnak tiltsa"},
/* it */ {IDCLS_DISABLE_IEC_4_IT, "Disattiva emulazione IEC per la periferica #4"},
/* ko */ {IDCLS_DISABLE_IEC_4_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_IEC_4_NL, "IEC apparaat emulatie voor apparaat #4 uitschakelen"},
/* pl */ {IDCLS_DISABLE_IEC_4_PL, "Wycz emulacj urzdzenia IEC dla urzdzenia #4"},
/* ru */ {IDCLS_DISABLE_IEC_4_RU, "Disable IEC device emulation for device #4"},
/* sv */ {IDCLS_DISABLE_IEC_4_SV, "Inaktivera IEC-enhetsemulering fr enhet 4"},
/* tr */ {IDCLS_DISABLE_IEC_4_TR, "Aygt #4 iin IEC aygt emlasyonunu pasifletir"},
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_ENABLE_IEC_5,    N_("Enable IEC device emulation for device #5")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_IEC_5_DA, "Aktivr IEC-enhedsemulering for enhed #5"},
/* de */ {IDCLS_ENABLE_IEC_5_DE, "IEC Gerte Emulation fr Gert #5 aktivieren"},
/* es */ {IDCLS_ENABLE_IEC_5_ES, "Permitir emulacin IEC para perifrico #5"},
/* fr */ {IDCLS_ENABLE_IEC_5_FR, "Activer l'mulation IEC pour le priphrique #5"},
/* hu */ {IDCLS_ENABLE_IEC_5_HU, "IEC eszkz #5 emulcijnak engedlyezse"},
/* it */ {IDCLS_ENABLE_IEC_5_IT, "Attiva emulazione IEC per la periferica #5"},
/* ko */ {IDCLS_ENABLE_IEC_5_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_IEC_5_NL, "IEC apparaat emulatie voor apparaat #5 inschakelen"},
/* pl */ {IDCLS_ENABLE_IEC_5_PL, "Wcz emulacj IEC urzdzenia #5"},
/* ru */ {IDCLS_ENABLE_IEC_5_RU, "Enable IEC device emulation for device #5"},
/* sv */ {IDCLS_ENABLE_IEC_5_SV, "Aktivera IEC-enhetsemulering fr enhet 5"},
/* tr */ {IDCLS_ENABLE_IEC_5_TR, "Aygt #5 iin IEC aygt emlasyonunu aktif et"},
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_DISABLE_IEC_5,    N_("Disable IEC device emulation for device #5")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_IEC_5_DA, "Deaktivr IEC-enhedsemulering for enhed #5"},
/* de */ {IDCLS_DISABLE_IEC_5_DE, "IEC Gerte Emulation fr Gert #5 deaktivieren"},
/* es */ {IDCLS_DISABLE_IEC_5_ES, "Deshabilitar emulacin IEC para perifrico #5"},
/* fr */ {IDCLS_DISABLE_IEC_5_FR, "Dsactiver l'mulation IEC pour le priphrique #5"},
/* hu */ {IDCLS_DISABLE_IEC_5_HU, "IEC eszkz #5 emulcijnak tiltsa"},
/* it */ {IDCLS_DISABLE_IEC_5_IT, "Disattiva emulazione IEC per la periferica #5"},
/* ko */ {IDCLS_DISABLE_IEC_5_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_IEC_5_NL, "IEC apparaat emulatie voor apparaat #5 uitschakelen"},
/* pl */ {IDCLS_DISABLE_IEC_5_PL, "Wycz emulacj urzdzenia IEC dla urzdzenia #5"},
/* ru */ {IDCLS_DISABLE_IEC_5_RU, "Disable IEC device emulation for device #5"},
/* sv */ {IDCLS_DISABLE_IEC_5_SV, "Inaktivera IEC-enhetsemulering fr enhet 5"},
/* tr */ {IDCLS_DISABLE_IEC_5_TR, "Aygt #5 iin IEC aygt emlasyonunu pasifletir"},
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_ENABLE_IEC_6,    N_("Enable IEC device emulation for device #6")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_IEC_6_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_IEC_6_DE, "IEC Gerte Emulation fr Gert #6 aktivieren"},
/* es */ {IDCLS_ENABLE_IEC_6_ES, "Permitir emulacin IEC para perifrico #6"},
/* fr */ {IDCLS_ENABLE_IEC_6_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_IEC_6_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_IEC_6_IT, "Attiva emulazione IEC per la periferica #6"},
/* ko */ {IDCLS_ENABLE_IEC_6_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_IEC_6_NL, "IEC apparaat emulatie voor apparaat #6 inschakelen"},
/* pl */ {IDCLS_ENABLE_IEC_6_PL, "Wcz emulacj IEC urzdzenia #6"},
/* ru */ {IDCLS_ENABLE_IEC_6_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_IEC_6_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_IEC_6_TR, ""},  /* fuzzy */
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_DISABLE_IEC_6,    N_("Disable IEC device emulation for device #6")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_IEC_6_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_IEC_6_DE, "IEC Gerte Emulation fr Gert #6 deaktivieren"},
/* es */ {IDCLS_DISABLE_IEC_6_ES, "Deshabilitar emulacin IEC para perifrico #6"},
/* fr */ {IDCLS_DISABLE_IEC_6_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_IEC_6_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_IEC_6_IT, "Disattiva emulazione IEC per la periferica #6"},
/* ko */ {IDCLS_DISABLE_IEC_6_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_IEC_6_NL, "IEC apparaat emulatie voor apparaat #6 uitschakelen"},
/* pl */ {IDCLS_DISABLE_IEC_6_PL, "Wycz emulacj urzdzenia IEC dla urzdzenia #6"},
/* ru */ {IDCLS_DISABLE_IEC_6_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_IEC_6_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_IEC_6_TR, ""},  /* fuzzy */
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_ENABLE_IEC_7,    N_("Enable IEC device emulation for device #7")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_IEC_7_DA, ""},  /* fuzzy */
/* de */ {IDCLS_ENABLE_IEC_7_DE, "IEC Gerte Emulation fr Gert #7 aktivieren"},
/* es */ {IDCLS_ENABLE_IEC_7_ES, "Permitir emulacin IEC para perifrico #7"},
/* fr */ {IDCLS_ENABLE_IEC_7_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_ENABLE_IEC_7_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_IEC_7_IT, "Attiva emulazione IEC per la periferica #7"},
/* ko */ {IDCLS_ENABLE_IEC_7_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_IEC_7_NL, "IEC apparaat emulatie voor apparaat #7 inschakelen"},
/* pl */ {IDCLS_ENABLE_IEC_7_PL, "Wcz emulacj IEC urzdzenia #7"},
/* ru */ {IDCLS_ENABLE_IEC_7_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_IEC_7_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_ENABLE_IEC_7_TR, ""},  /* fuzzy */
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_DISABLE_IEC_7,    N_("Disable IEC device emulation for device #7")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_IEC_7_DA, ""},  /* fuzzy */
/* de */ {IDCLS_DISABLE_IEC_7_DE, "IEC Gerte Emulation fr Gert #7 deaktivieren"},
/* es */ {IDCLS_DISABLE_IEC_7_ES, "Deshabilitar emulacin IEC para perifrico #7"},
/* fr */ {IDCLS_DISABLE_IEC_7_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_DISABLE_IEC_7_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_IEC_7_IT, "Disattiva emulazione IEC per la periferica #7"},
/* ko */ {IDCLS_DISABLE_IEC_7_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_IEC_7_NL, "IEC apparaat emulatie voor apparaat #7 uitschakelen"},
/* pl */ {IDCLS_DISABLE_IEC_7_PL, "Wycz emulacj urzdzenia IEC dla urzdzenia #7"},
/* ru */ {IDCLS_DISABLE_IEC_7_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_IEC_7_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_DISABLE_IEC_7_TR, ""},  /* fuzzy */
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_ENABLE_IEC_8,    N_("Enable IEC device emulation for device #8")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_IEC_8_DA, "Aktivr IEC-enhedsemulering for enhed #8"},
/* de */ {IDCLS_ENABLE_IEC_8_DE, "IEC Gerte Emulation fr Gert #8 aktivieren"},
/* es */ {IDCLS_ENABLE_IEC_8_ES, "Permitir emulacin IEC para perifrico #8"},
/* fr */ {IDCLS_ENABLE_IEC_8_FR, "Activer l'mulation IEC pour le lecteur #8"},
/* hu */ {IDCLS_ENABLE_IEC_8_HU, "IEC eszkz #8 emulcijnak engedlyezse"},
/* it */ {IDCLS_ENABLE_IEC_8_IT, "Attiva emulazione IEC per la periferica #8"},
/* ko */ {IDCLS_ENABLE_IEC_8_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_IEC_8_NL, "IEC apparaat emulatie voor apparaat #8 inschakelen"},
/* pl */ {IDCLS_ENABLE_IEC_8_PL, "Wcz emulacj IEC urzdzenia #8"},
/* ru */ {IDCLS_ENABLE_IEC_8_RU, "Enable IEC device emulation for device #8"},
/* sv */ {IDCLS_ENABLE_IEC_8_SV, "Aktivera IEC-enhetsemulering fr enhet 8"},
/* tr */ {IDCLS_ENABLE_IEC_8_TR, "Aygt #8 iin IEC aygt emlasyonunu aktif et"},
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_DISABLE_IEC_8,    N_("Disable IEC device emulation for device #8")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_IEC_8_DA, "Deaktivr IEC-enhedsemulering for enhed #8"},
/* de */ {IDCLS_DISABLE_IEC_8_DE, "IEC Gerte Emulation fr Gert #8 deaktivieren"},
/* es */ {IDCLS_DISABLE_IEC_8_ES, "Deshabilitar emulacin IEC para perifrico #8"},
/* fr */ {IDCLS_DISABLE_IEC_8_FR, "Dsactiver l'mulation IEC pour le lecteur #8"},
/* hu */ {IDCLS_DISABLE_IEC_8_HU, "IEC eszkz #8 emulcijnak tiltsa"},
/* it */ {IDCLS_DISABLE_IEC_8_IT, "Disattiva emulazione IEC per la periferica #8"},
/* ko */ {IDCLS_DISABLE_IEC_8_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_IEC_8_NL, "IEC apparaat emulatie voor apparaat #8 uitschakelen"},
/* pl */ {IDCLS_DISABLE_IEC_8_PL, "Wycz emulacj urzdzenia IEC dla urzdzenia #8"},
/* ru */ {IDCLS_DISABLE_IEC_8_RU, "Disable IEC device emulation for device #8"},
/* sv */ {IDCLS_DISABLE_IEC_8_SV, "Inaktivera IEC-enhetsemulering fr enhet 8"},
/* tr */ {IDCLS_DISABLE_IEC_8_TR, "Aygt #8 iin IEC aygt emlasyonunu pasifletir"},
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_ENABLE_IEC_9,    N_("Enable IEC device emulation for device #9")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_IEC_9_DA, "Aktivr IEC-enhedsemulering for enhed #9"},
/* de */ {IDCLS_ENABLE_IEC_9_DE, "IEC Gerte Emulation fr Gert #9 aktivieren"},
/* es */ {IDCLS_ENABLE_IEC_9_ES, "Permitir emulacin IEC para perifrico #9"},
/* fr */ {IDCLS_ENABLE_IEC_9_FR, "Activer l'mulation IEC pour le lecteur #9"},
/* hu */ {IDCLS_ENABLE_IEC_9_HU, "IEC eszkz #9 emulcijnak engedlyezse"},
/* it */ {IDCLS_ENABLE_IEC_9_IT, "Attiva emulazione IEC per la periferica #9"},
/* ko */ {IDCLS_ENABLE_IEC_9_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_IEC_9_NL, "IEC apparaat emulatie voor apparaat #9 inschakelen"},
/* pl */ {IDCLS_ENABLE_IEC_9_PL, "Wcz emulacj IEC urzdzenia #9"},
/* ru */ {IDCLS_ENABLE_IEC_9_RU, "Enable IEC device emulation for device #9"},
/* sv */ {IDCLS_ENABLE_IEC_9_SV, "Aktivera IEC-enhetsemulering fr enhet 9"},
/* tr */ {IDCLS_ENABLE_IEC_9_TR, "Aygt #9 iin IEC aygt emlasyonunu aktif et"},
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_DISABLE_IEC_9,    N_("Disable IEC device emulation for device #9")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_IEC_9_DA, "Deaktivr IEC-enhedsemulering for enhed #9"},
/* de */ {IDCLS_DISABLE_IEC_9_DE, "IEC Gerte Emulation fr Gert #9 deaktivieren"},
/* es */ {IDCLS_DISABLE_IEC_9_ES, "Deshabilitar emulacin IEC para perifrico #9"},
/* fr */ {IDCLS_DISABLE_IEC_9_FR, "Dsactiver l'mulation IEC pour le lecteur #9"},
/* hu */ {IDCLS_DISABLE_IEC_9_HU, "IEC eszkz #9 emulcijnak tiltsa"},
/* it */ {IDCLS_DISABLE_IEC_9_IT, "Disattiva emulazione IEC per la periferica #9"},
/* ko */ {IDCLS_DISABLE_IEC_9_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_IEC_9_NL, "IEC apparaat emulatie voor apparaat #9 uitschakelen"},
/* pl */ {IDCLS_DISABLE_IEC_9_PL, "Wycz emulacj urzdzenia IEC dla urzdzenia #9"},
/* ru */ {IDCLS_DISABLE_IEC_9_RU, "Disable IEC device emulation for device #9"},
/* sv */ {IDCLS_DISABLE_IEC_9_SV, "Inaktivera IEC-enhetsemulering fr enhet 9"},
/* tr */ {IDCLS_DISABLE_IEC_9_TR, "Aygt #9 iin IEC aygt emlasyonunu pasifletir"},
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_ENABLE_IEC_10,    N_("Enable IEC device emulation for device #10")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_IEC_10_DA, "Aktivr IEC-enhedsemulering for enhed #10"},
/* de */ {IDCLS_ENABLE_IEC_10_DE, "IEC Gerte Emulation fr Gert #10 aktivieren"},
/* es */ {IDCLS_ENABLE_IEC_10_ES, "Permitir emulacin IEC para perifrico #10"},
/* fr */ {IDCLS_ENABLE_IEC_10_FR, "Activer l'mulation IEC pour le lecteur #10"},
/* hu */ {IDCLS_ENABLE_IEC_10_HU, "IEC eszkz #10 emulcijnak engedlyezse"},
/* it */ {IDCLS_ENABLE_IEC_10_IT, "Attiva emulazione IEC per la periferica #10"},
/* ko */ {IDCLS_ENABLE_IEC_10_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_IEC_10_NL, "IEC apparaat emulatie voor apparaat #10 inschakelen"},
/* pl */ {IDCLS_ENABLE_IEC_10_PL, "Wcz emulacj IEC urzdzenia #10"},
/* ru */ {IDCLS_ENABLE_IEC_10_RU, "Enable IEC device emulation for device #10"},
/* sv */ {IDCLS_ENABLE_IEC_10_SV, "Aktivera IEC-enhetsemulering fr enhet 10"},
/* tr */ {IDCLS_ENABLE_IEC_10_TR, "Aygt #10 iin IEC aygt emlasyonunu aktif et"},
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_DISABLE_IEC_10,    N_("Disable IEC device emulation for device #10")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_IEC_10_DA, "Deaktivr IEC-enhedsemulering for enhed #10"},
/* de */ {IDCLS_DISABLE_IEC_10_DE, "IEC Gerte Emulation fr Gert #10 deaktivieren"},
/* es */ {IDCLS_DISABLE_IEC_10_ES, "Deshabilitar emulacin IEC para perifrico #10"},
/* fr */ {IDCLS_DISABLE_IEC_10_FR, "Dsactiver l'mulation IEC pour le lecteur #10"},
/* hu */ {IDCLS_DISABLE_IEC_10_HU, "IEC eszkz #10 emulcijnak tiltsa"},
/* it */ {IDCLS_DISABLE_IEC_10_IT, "Disattiva emulazione IEC per la periferica #10"},
/* ko */ {IDCLS_DISABLE_IEC_10_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_IEC_10_NL, "IEC apparaat emulatie voor apparaat #10 uitschakelen"},
/* pl */ {IDCLS_DISABLE_IEC_10_PL, "Wycz emulacj urzdzenia IEC dla urzdzenia #10"},
/* ru */ {IDCLS_DISABLE_IEC_10_RU, "Disable IEC device emulation for device #10"},
/* sv */ {IDCLS_DISABLE_IEC_10_SV, "Inaktivera IEC-enhetsemulering fr enhet 10"},
/* tr */ {IDCLS_DISABLE_IEC_10_TR, "Aygt #10 iin IEC aygt emlasyonunu pasifletir"},
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_ENABLE_IEC_11,    N_("Enable IEC device emulation for device #11")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_IEC_11_DA, "Aktivr IEC-enhedsemulering for enhed #11"},
/* de */ {IDCLS_ENABLE_IEC_11_DE, "IEC Gerte Emulation fr Gert #11 aktivieren"},
/* es */ {IDCLS_ENABLE_IEC_11_ES, "Permitir emulacin IEC para perifrico #11"},
/* fr */ {IDCLS_ENABLE_IEC_11_FR, "Activer l'mulation IEC pour le lecteur #11"},
/* hu */ {IDCLS_ENABLE_IEC_11_HU, "IEC eszkz #11 emulcijnak engedlyezse"},
/* it */ {IDCLS_ENABLE_IEC_11_IT, "Attiva emulazione IEC per la periferica #11"},
/* ko */ {IDCLS_ENABLE_IEC_11_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_IEC_11_NL, "IEC apparaat emulatie voor apparaat #11 inschakelen"},
/* pl */ {IDCLS_ENABLE_IEC_11_PL, "Wcz emulacj IEC urzdzenia #11"},
/* ru */ {IDCLS_ENABLE_IEC_11_RU, "Enable IEC device emulation for device #11"},
/* sv */ {IDCLS_ENABLE_IEC_11_SV, "Aktivera IEC-enhetsemulering fr enhet 11"},
/* tr */ {IDCLS_ENABLE_IEC_11_TR, "Aygt #11 iin IEC aygt emlasyonunu aktif et"},
#endif

/* serial/serial-iec-device.c */
/* en */ {IDCLS_DISABLE_IEC_11,    N_("Disable IEC device emulation for device #11")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_IEC_11_DA, "Deaktivr IEC-enhedsemulering for enhed #11"},
/* de */ {IDCLS_DISABLE_IEC_11_DE, "IEC Gerte Emulation fr Gert #11 deaktivieren"},
/* es */ {IDCLS_DISABLE_IEC_11_ES, "Deshabilitar emulacin IEC para perifrico #11"},
/* fr */ {IDCLS_DISABLE_IEC_11_FR, "Dsactiver l'mulation IEC pour le lecteur #11"},
/* hu */ {IDCLS_DISABLE_IEC_11_HU, "IEC eszkz #11 emulcijnak tiltsa"},
/* it */ {IDCLS_DISABLE_IEC_11_IT, "Disattiva emulazione IEC per la periferica #11"},
/* ko */ {IDCLS_DISABLE_IEC_11_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_IEC_11_NL, "IEC apparaat emulatie voor apparaat #11 uitschakelen"},
/* pl */ {IDCLS_DISABLE_IEC_11_PL, "Wycz emulacj urzdzenia IEC dla urzdzenia #11"},
/* ru */ {IDCLS_DISABLE_IEC_11_RU, "Disable IEC device emulation for device #11"},
/* sv */ {IDCLS_DISABLE_IEC_11_SV, "Inaktivera IEC-enhetsemulering fr enhet 11"},
/* tr */ {IDCLS_DISABLE_IEC_11_TR, "Aygt #11 iin IEC aygt emlasyonunu pasifletir"},
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_P_ENGINE_MODEL,    N_("<engine and model>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_ENGINE_MODEL_DA, "<motor og model>"},
/* de */ {IDCLS_P_ENGINE_MODEL_DE, "<Engine und Modell>"},
/* es */ {IDCLS_P_ENGINE_MODEL_ES, "<motor y modelo>"},
/* fr */ {IDCLS_P_ENGINE_MODEL_FR, "<engin et modle>"},
/* hu */ {IDCLS_P_ENGINE_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_ENGINE_MODEL_IT, "<motore e modello>"},
/* ko */ {IDCLS_P_ENGINE_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_ENGINE_MODEL_NL, "<kern en model>"},
/* pl */ {IDCLS_P_ENGINE_MODEL_PL, "<silnik i model>"},
/* ru */ {IDCLS_P_ENGINE_MODEL_RU, "<engine and model>"},
/* sv */ {IDCLS_P_ENGINE_MODEL_SV, "<motor och modell>"},
/* tr */ {IDCLS_P_ENGINE_MODEL_TR, "<motor ve model>"},
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_P_AMOUNT,    N_("<amount>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_AMOUNT_DA, "<antal>"},
/* de */ {IDCLS_P_AMOUNT_DE, "<Anzahl>"},
/* es */ {IDCLS_P_AMOUNT_ES, "<cantidad>"},
/* fr */ {IDCLS_P_AMOUNT_FR, "<quantit>"},
/* hu */ {IDCLS_P_AMOUNT_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_AMOUNT_IT, "<numero>"},
/* ko */ {IDCLS_P_AMOUNT_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_P_AMOUNT_NL, "<hoeveelheid>"},
/* pl */ {IDCLS_P_AMOUNT_PL, "<ilo>"},
/* ru */ {IDCLS_P_AMOUNT_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_P_AMOUNT_SV, "<antal>"},
/* tr */ {IDCLS_P_AMOUNT_TR, "<adet>"},
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_AMOUNT_EXTRA_SIDS,    N_("amount of extra SID chips. (0..2)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_AMOUNT_EXTRA_SIDS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_AMOUNT_EXTRA_SIDS_DE, "Anzahl der extra SID Chips. (0..2)"},
/* es */ {IDCLS_AMOUNT_EXTRA_SIDS_ES, "Cantidad de chips SID extra (0..2)"},
/* fr */ {IDCLS_AMOUNT_EXTRA_SIDS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_AMOUNT_EXTRA_SIDS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_AMOUNT_EXTRA_SIDS_IT, "numero di SID chip aggiuntivi. (0..2)"},
/* ko */ {IDCLS_AMOUNT_EXTRA_SIDS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_AMOUNT_EXTRA_SIDS_NL, "Aantal extra SID chips. (0..2)"},
/* pl */ {IDCLS_AMOUNT_EXTRA_SIDS_PL, "liczba dodatkowych czipw SID (0..2)"},
/* ru */ {IDCLS_AMOUNT_EXTRA_SIDS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_AMOUNT_EXTRA_SIDS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_AMOUNT_EXTRA_SIDS_TR, ""},  /* fuzzy */
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_FASTSID_ENGINE_MODEL,    N_("0: FastSID 6581, 1: FastSID 8580")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_FASTSID_ENGINE_MODEL_DA, "0: FastSID 6581, 1: FastSID 8580"},
/* de */ {IDCLS_FASTSID_ENGINE_MODEL_DE, "0: FastSID 6581, 1: FastSID 8580"},
/* es */ {IDCLS_FASTSID_ENGINE_MODEL_ES, "0: FastSID 6581, 1: FastSID 8580"},
/* fr */ {IDCLS_FASTSID_ENGINE_MODEL_FR, "0: FastSID 6581, 1: FastSID 8580"},
/* hu */ {IDCLS_FASTSID_ENGINE_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_FASTSID_ENGINE_MODEL_IT, "0: FastSID 6581, 1: FastSID 8580"},
/* ko */ {IDCLS_FASTSID_ENGINE_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_FASTSID_ENGINE_MODEL_NL, "0: FastSID 6581, 1: FastSID 8580"},
/* pl */ {IDCLS_FASTSID_ENGINE_MODEL_PL, "0: FastSID 6581, 1: FastSID 8580"},
/* ru */ {IDCLS_FASTSID_ENGINE_MODEL_RU, "0: FastSID 6581, 1: FastSID 8580"},
/* sv */ {IDCLS_FASTSID_ENGINE_MODEL_SV, "0: FastSID 6581, 1: FastSID 8580"},
/* tr */ {IDCLS_FASTSID_ENGINE_MODEL_TR, "0: FastSID 6581, 1: FastSID 8580"},
#endif

#ifdef HAVE_RESID
/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_RESID_ENGINE_MODEL,    N_("256: ReSID 6581, 257: ReSID 8580, 258: ReSID 8580 + digiboost")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_RESID_ENGINE_MODEL_DA, "256: ReSID 6581, 257: ReSID 8580, 258: ReSID 8580 + digitalforstrkning"},
/* de */ {IDCLS_RESID_ENGINE_MODEL_DE, "256: ReSID 6581, 257: ReSID 8580, 258: ReSID 8580 + digiboost"},
/* es */ {IDCLS_RESID_ENGINE_MODEL_ES, "256: ReSID 6581, 257: ReSID 8580, 258: ReSID 8580 + digiboost"},
/* fr */ {IDCLS_RESID_ENGINE_MODEL_FR, "256: ReSID 6581, 257: ReSID 8580, 258: ReSID 8580 + digiboost"},
/* hu */ {IDCLS_RESID_ENGINE_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_RESID_ENGINE_MODEL_IT, "256: ReSID 6581, 257: ReSID 8580, 258: ReSID 8580 + digiboost"},
/* ko */ {IDCLS_RESID_ENGINE_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_RESID_ENGINE_MODEL_NL, "256: ReSID 6581, 257: ReSID 8580, 258: ReSID 8580 + digiboost"},
/* pl */ {IDCLS_RESID_ENGINE_MODEL_PL, "256: ReSID 6581, 257: ReSID 8580, 258: ReSID 8580 + digiboost"},
/* ru */ {IDCLS_RESID_ENGINE_MODEL_RU, "256: ReSID 6581, 257: ReSID 8580, 258: ReSID 8580 + digiboost"},
/* sv */ {IDCLS_RESID_ENGINE_MODEL_SV, "256: ReSID 6581, 257: ReSID 8580, 258: ReSID 8580 + digifrstrkning"},
/* tr */ {IDCLS_RESID_ENGINE_MODEL_TR, "256: ReSID 6581, 257: ReSID 8580, 258: ReSID 8580 + digiboost"},
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_RESIDDTV_ENGINE_MODEL,    N_("260: DTVSID")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_RESIDDTV_ENGINE_MODEL_DA, "260: DTVSID"},
/* de */ {IDCLS_RESIDDTV_ENGINE_MODEL_DE, "260: DTVSID"},
/* es */ {IDCLS_RESIDDTV_ENGINE_MODEL_ES, "260: DTVSID"},
/* fr */ {IDCLS_RESIDDTV_ENGINE_MODEL_FR, "260: DTVSID"},
/* hu */ {IDCLS_RESIDDTV_ENGINE_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_RESIDDTV_ENGINE_MODEL_IT, "260: DTVSID"},
/* ko */ {IDCLS_RESIDDTV_ENGINE_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_RESIDDTV_ENGINE_MODEL_NL, "260: DTVSID"},
/* pl */ {IDCLS_RESIDDTV_ENGINE_MODEL_PL, "260: DTVSID"},
/* ru */ {IDCLS_RESIDDTV_ENGINE_MODEL_RU, "260: DTVSID"},
/* sv */ {IDCLS_RESIDDTV_ENGINE_MODEL_SV, "260: DTVSID"},
/* tr */ {IDCLS_RESIDDTV_ENGINE_MODEL_TR, "260: DTVSID"},
#endif
#endif

#ifdef HAVE_CATWEASELMKIII
/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_CATWEASELMKIII_ENGINE_MODEL,    N_("512: Catweasel")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_CATWEASELMKIII_ENGINE_MODEL_DA, "512: Catweasel"},
/* de */ {IDCLS_CATWEASELMKIII_ENGINE_MODEL_DE, "512: Catweasel"},
/* es */ {IDCLS_CATWEASELMKIII_ENGINE_MODEL_ES, "512: Catweasel"},
/* fr */ {IDCLS_CATWEASELMKIII_ENGINE_MODEL_FR, "512: Catweasel"},
/* hu */ {IDCLS_CATWEASELMKIII_ENGINE_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_CATWEASELMKIII_ENGINE_MODEL_IT, "512: Catweasel"},
/* ko */ {IDCLS_CATWEASELMKIII_ENGINE_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_CATWEASELMKIII_ENGINE_MODEL_NL, "512: Catweasel"},
/* pl */ {IDCLS_CATWEASELMKIII_ENGINE_MODEL_PL, "512: Catweasel"},
/* ru */ {IDCLS_CATWEASELMKIII_ENGINE_MODEL_RU, "512: Catweasel"},
/* sv */ {IDCLS_CATWEASELMKIII_ENGINE_MODEL_SV, "512: Catweasel"},
/* tr */ {IDCLS_CATWEASELMKIII_ENGINE_MODEL_TR, "512: Catweasel"},
#endif
#endif

#ifdef HAVE_HARDSID
/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_HARDSID_ENGINE_MODEL,    N_("768: HardSID")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_HARDSID_ENGINE_MODEL_DA, "768: HardSID"},
/* de */ {IDCLS_HARDSID_ENGINE_MODEL_DE, "768: HardSID"},
/* es */ {IDCLS_HARDSID_ENGINE_MODEL_ES, "768: HardSID"},
/* fr */ {IDCLS_HARDSID_ENGINE_MODEL_FR, "768: HardSID"},
/* hu */ {IDCLS_HARDSID_ENGINE_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_HARDSID_ENGINE_MODEL_IT, "768: HardSID"},
/* ko */ {IDCLS_HARDSID_ENGINE_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_HARDSID_ENGINE_MODEL_NL, "768: HardSID"},
/* pl */ {IDCLS_HARDSID_ENGINE_MODEL_PL, "768: HardSID"},
/* ru */ {IDCLS_HARDSID_ENGINE_MODEL_RU, "768: HardSID"},
/* sv */ {IDCLS_HARDSID_ENGINE_MODEL_SV, "768: HardSID"},
/* tr */ {IDCLS_HARDSID_ENGINE_MODEL_TR, "768: HardSID"},
#endif
#endif

#ifdef HAVE_PARSID
/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_PARSID_ENGINE_MODEL,    N_("1024: ParSID in par port 1, 1280: ParSID in par port 2, 1536: ParSID in par port 3")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PARSID_ENGINE_MODEL_DA, "1024: ParSID p port 1, 1280: ParSID p port 2, 1536: ParSID p port 3"},
/* de */ {IDCLS_PARSID_ENGINE_MODEL_DE, "1024: ParSID in par port 1, 1280: ParSID in par port 2, 1536: ParSID in par port 3"},
/* es */ {IDCLS_PARSID_ENGINE_MODEL_ES, "1024: ParSID in par port 1, 1280: ParSID in par port 2, 1536: ParSID in par port 3"},
/* fr */ {IDCLS_PARSID_ENGINE_MODEL_FR, "1024: ParSID sur port.par 1, 1280: ParSID sur port.par 2, 1536: ParSID sur port.par 3"},
/* hu */ {IDCLS_PARSID_ENGINE_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_PARSID_ENGINE_MODEL_IT, "1024: ParSID in par port 1, 1280: ParSID in par port 2, 1536: ParSID in par port 3"},
/* ko */ {IDCLS_PARSID_ENGINE_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PARSID_ENGINE_MODEL_NL, "1024: ParSID in par port 1, 1280: ParSID in par port 2, 1536: ParSID in par port 3"},
/* pl */ {IDCLS_PARSID_ENGINE_MODEL_PL, "1024: ParSID in porcie par 1, 1280: ParSID w porcie par 2, 1536: ParSID in porcie par 3"},
/* ru */ {IDCLS_PARSID_ENGINE_MODEL_RU, "1024: ParSID in par port 1, 1280: ParSID in par port 2, 1536: ParSID in par port 3"},
/* sv */ {IDCLS_PARSID_ENGINE_MODEL_SV, "1024: ParSID i parport 1, 1280: ParSID i parport 2, 1536: ParSID i parport 3"},
/* tr */ {IDCLS_PARSID_ENGINE_MODEL_TR, "1024: Par port 1'de ParSID, 1280: Par port 2'de ParSID, 1536: Par port 3'de ParSID"},
#endif
#endif

#ifdef HAVE_SSI2001
/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_SSI2001_ENGINE_MODEL,    N_("1792: SSI2001")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SSI2001_ENGINE_MODEL_DA, ""},  /* fuzzy */
/* de */ {IDCLS_SSI2001_ENGINE_MODEL_DE, "1792: SSI2001"},
/* es */ {IDCLS_SSI2001_ENGINE_MODEL_ES, ""},  /* fuzzy */
/* fr */ {IDCLS_SSI2001_ENGINE_MODEL_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_SSI2001_ENGINE_MODEL_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SSI2001_ENGINE_MODEL_IT, ""},  /* fuzzy */
/* ko */ {IDCLS_SSI2001_ENGINE_MODEL_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SSI2001_ENGINE_MODEL_NL, "1792: SSI2001"},
/* pl */ {IDCLS_SSI2001_ENGINE_MODEL_PL, ""},  /* fuzzy */
/* ru */ {IDCLS_SSI2001_ENGINE_MODEL_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_SSI2001_ENGINE_MODEL_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_SSI2001_ENGINE_MODEL_TR, ""},  /* fuzzy */
#endif
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_ENABLE_SIDCART,    N_("Enable the SID cartridge")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_SIDCART_DA, "Aktivr SID-cartridget"},
/* de */ {IDCLS_ENABLE_SIDCART_DE, "SID Modul aktivieren"},
/* es */ {IDCLS_ENABLE_SIDCART_ES, "Permitir cartucho SID"},
/* fr */ {IDCLS_ENABLE_SIDCART_FR, "Activer la cartouche SID"},
/* hu */ {IDCLS_ENABLE_SIDCART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_ENABLE_SIDCART_IT, "Attiva cartuccia SID"},
/* ko */ {IDCLS_ENABLE_SIDCART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_SIDCART_NL, "SID cartridge inschakelen"},
/* pl */ {IDCLS_ENABLE_SIDCART_PL, "Wcz kartrid SID"},
/* ru */ {IDCLS_ENABLE_SIDCART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_ENABLE_SIDCART_SV, "Aktivera SID-insticksmodul"},
/* tr */ {IDCLS_ENABLE_SIDCART_TR, "SID kartuunu aktif et"},
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_DISABLE_SIDCART,    N_("Disable the SID cartridge")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_SIDCART_DA, "Deaktivr SID-cartridge"},
/* de */ {IDCLS_DISABLE_SIDCART_DE, "SID Modul deaktivieren"},
/* es */ {IDCLS_DISABLE_SIDCART_ES, "Deshabilitar cartucho SID"},
/* fr */ {IDCLS_DISABLE_SIDCART_FR, "Dsactiver la cartouche SID"},
/* hu */ {IDCLS_DISABLE_SIDCART_HU, ""},  /* fuzzy */
/* it */ {IDCLS_DISABLE_SIDCART_IT, "Disattiva la cartuccia SID"},
/* ko */ {IDCLS_DISABLE_SIDCART_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_SIDCART_NL, "SID cartridge uitschakelen"},
/* pl */ {IDCLS_DISABLE_SIDCART_PL, "Wycz kartrid SID"},
/* ru */ {IDCLS_DISABLE_SIDCART_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_DISABLE_SIDCART_SV, "Inaktivera SID-insticksmodul"},
/* tr */ {IDCLS_DISABLE_SIDCART_TR, "SID kartuunu pasifletir"},
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_PET_SIDCART_ADDRESS,    N_("SID cartridge address (0x8F00/0xE900)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PET_SIDCART_ADDRESS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_PET_SIDCART_ADDRESS_DE, "SID Modul Adresse (0x8F00/0xE900)"},
/* es */ {IDCLS_PET_SIDCART_ADDRESS_ES, "Direccin del cartucho SID (0x8F00/0xE900)"},
/* fr */ {IDCLS_PET_SIDCART_ADDRESS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_PET_SIDCART_ADDRESS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_PET_SIDCART_ADDRESS_IT, "Indirizzo cartuccia SID (0x8F00/0xE900)"},
/* ko */ {IDCLS_PET_SIDCART_ADDRESS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PET_SIDCART_ADDRESS_NL, "SID cartridge adres (0x8F00/0xE900)"},
/* pl */ {IDCLS_PET_SIDCART_ADDRESS_PL, "Adres kartrida SID (0x8F00/0xE900)"},
/* ru */ {IDCLS_PET_SIDCART_ADDRESS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_PET_SIDCART_ADDRESS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_PET_SIDCART_ADDRESS_TR, ""},  /* fuzzy */
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_PLUS4_SIDCART_ADDRESS,    N_("SID cartridge address (0xFD40/0xFE80)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PLUS4_SIDCART_ADDRESS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_PLUS4_SIDCART_ADDRESS_DE, "SID Modul Adresse (0xFD40/0xFE80)"},
/* es */ {IDCLS_PLUS4_SIDCART_ADDRESS_ES, "Direccin del cartucho SID (0xFD40/0xFE80)"},
/* fr */ {IDCLS_PLUS4_SIDCART_ADDRESS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_PLUS4_SIDCART_ADDRESS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_PLUS4_SIDCART_ADDRESS_IT, "Indirizzo cartuccia SID (0xFD40/0xFE80)"},
/* ko */ {IDCLS_PLUS4_SIDCART_ADDRESS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PLUS4_SIDCART_ADDRESS_NL, "SID cartridge adres (0xFD40/0xFE80)"},
/* pl */ {IDCLS_PLUS4_SIDCART_ADDRESS_PL, "Adres kartrida SID (0xFD40/0xFE80)"},
/* ru */ {IDCLS_PLUS4_SIDCART_ADDRESS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_PLUS4_SIDCART_ADDRESS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_PLUS4_SIDCART_ADDRESS_TR, ""},  /* fuzzy */
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_VIC20_SIDCART_ADDRESS,    N_("SID cartridge address (0x9800/0x9C00)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_VIC20_SIDCART_ADDRESS_DA, ""},  /* fuzzy */
/* de */ {IDCLS_VIC20_SIDCART_ADDRESS_DE, "SID Module Adresse (0x9800/0x9C00)"},
/* es */ {IDCLS_VIC20_SIDCART_ADDRESS_ES, "Direccin del cartucho SID (0x9800/0x9C00)"},
/* fr */ {IDCLS_VIC20_SIDCART_ADDRESS_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_VIC20_SIDCART_ADDRESS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_VIC20_SIDCART_ADDRESS_IT, "Indirizzo cartuccia SID (0x9800/0x9C00)"},
/* ko */ {IDCLS_VIC20_SIDCART_ADDRESS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_VIC20_SIDCART_ADDRESS_NL, "SID cartridge adres (0x9800/0x9C00)"},
/* pl */ {IDCLS_VIC20_SIDCART_ADDRESS_PL, "Adres kartrida SID (0x9800/0x9C00)"},
/* ru */ {IDCLS_VIC20_SIDCART_ADDRESS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_VIC20_SIDCART_ADDRESS_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_VIC20_SIDCART_ADDRESS_TR, ""},  /* fuzzy */
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_PET_SIDCART_CLOCK,    N_("SID cartridge clock (0: C64 clock, 1: PET clock)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PET_SIDCART_CLOCK_DA, ""},  /* fuzzy */
/* de */ {IDCLS_PET_SIDCART_CLOCK_DE, "SID Module Takt (0: C64 Takt, 1: PET Takt)"},
/* es */ {IDCLS_PET_SIDCART_CLOCK_ES, "Reloj del cartucho SID (0: Reloj C64, 1: Reloj PET)"},
/* fr */ {IDCLS_PET_SIDCART_CLOCK_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_PET_SIDCART_CLOCK_HU, ""},  /* fuzzy */
/* it */ {IDCLS_PET_SIDCART_CLOCK_IT, "Clock cartuccia SID (0: clock C64 , 1: clock PET)"},
/* ko */ {IDCLS_PET_SIDCART_CLOCK_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PET_SIDCART_CLOCK_NL, "SID cartridge klok (0: C64 klok, 1: PET klok)"},
/* pl */ {IDCLS_PET_SIDCART_CLOCK_PL, "Zegar kartrida SID (0: Zegar C64, 1: Zegar PET)"},
/* ru */ {IDCLS_PET_SIDCART_CLOCK_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_PET_SIDCART_CLOCK_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_PET_SIDCART_CLOCK_TR, ""},  /* fuzzy */
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_PLUS4_SIDCART_CLOCK,    N_("SID cartridge clock (0: C64 clock, 1: PLUS4 clock)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_PLUS4_SIDCART_CLOCK_DA, ""},  /* fuzzy */
/* de */ {IDCLS_PLUS4_SIDCART_CLOCK_DE, "SID Modul Takt (0: C64 Takt, 1: PLUS4 Takt)"},
/* es */ {IDCLS_PLUS4_SIDCART_CLOCK_ES, "Reloj del cartucho SID (0: Reloj C64, 1: Reloj PLUS4)"},
/* fr */ {IDCLS_PLUS4_SIDCART_CLOCK_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_PLUS4_SIDCART_CLOCK_HU, ""},  /* fuzzy */
/* it */ {IDCLS_PLUS4_SIDCART_CLOCK_IT, "Clock cartuccia SID (0: clock C64 , 1: clock PLUS4)"},
/* ko */ {IDCLS_PLUS4_SIDCART_CLOCK_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_PLUS4_SIDCART_CLOCK_NL, "SID cartridge klok (0: C64 klok, 1: PLUS4 klok)"},
/* pl */ {IDCLS_PLUS4_SIDCART_CLOCK_PL, "Zegar kartrida SID (0: Zegar C64, 1: Zegar PLUS4)"},
/* ru */ {IDCLS_PLUS4_SIDCART_CLOCK_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_PLUS4_SIDCART_CLOCK_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_PLUS4_SIDCART_CLOCK_TR, ""},  /* fuzzy */
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_VIC20_SIDCART_CLOCK,    N_("SID cartridge clock (0: C64 clock, 1: VIC20 clock)")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_VIC20_SIDCART_CLOCK_DA, ""},  /* fuzzy */
/* de */ {IDCLS_VIC20_SIDCART_CLOCK_DE, "SID Modul Takt (0: C64 Takt, 1: VIC20 Takt)"},
/* es */ {IDCLS_VIC20_SIDCART_CLOCK_ES, "Reloj del cartucho SID (0: Reloj C64, 1: Reloj VIC20)"},
/* fr */ {IDCLS_VIC20_SIDCART_CLOCK_FR, ""},  /* fuzzy */
/* hu */ {IDCLS_VIC20_SIDCART_CLOCK_HU, ""},  /* fuzzy */
/* it */ {IDCLS_VIC20_SIDCART_CLOCK_IT, "Clock cartuccia SID (0: clock C64 , 1: clock VIC20)"},
/* ko */ {IDCLS_VIC20_SIDCART_CLOCK_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_VIC20_SIDCART_CLOCK_NL, "SID cartridge klok (0: C64 klok, 1: VIC20 klok)"},
/* pl */ {IDCLS_VIC20_SIDCART_CLOCK_PL, "Zegar kartrida SID (0: Zegar C64, 1: Zegar VIC20)"},
/* ru */ {IDCLS_VIC20_SIDCART_CLOCK_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_VIC20_SIDCART_CLOCK_SV, ""},  /* fuzzy */
/* tr */ {IDCLS_VIC20_SIDCART_CLOCK_TR, ""},  /* fuzzy */
#endif

/* sid/sid-cmdline-options.c, c64/plus60k, c64/c64_256k.c */
/* en */ {IDCLS_P_BASE_ADDRESS,    N_("<Base address>")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_P_BASE_ADDRESS_DA, "<Baseadresse>"},
/* de */ {IDCLS_P_BASE_ADDRESS_DE, "<Basis Adresse>"},
/* es */ {IDCLS_P_BASE_ADDRESS_ES, "<Direccin base>"},
/* fr */ {IDCLS_P_BASE_ADDRESS_FR, "<Adresse de base>"},
/* hu */ {IDCLS_P_BASE_ADDRESS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_P_BASE_ADDRESS_IT, "<Indirizzo base>"},
/* ko */ {IDCLS_P_BASE_ADDRESS_KO, "<̽ ּ>"},
/* nl */ {IDCLS_P_BASE_ADDRESS_NL, "<Basisadres>"},
/* pl */ {IDCLS_P_BASE_ADDRESS_PL, "<Adres bazowy>"},
/* ru */ {IDCLS_P_BASE_ADDRESS_RU, ""},  /* fuzzy */
/* sv */ {IDCLS_P_BASE_ADDRESS_SV, "<Basadress>"},
/* tr */ {IDCLS_P_BASE_ADDRESS_TR, "<Taban adresi>"},
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_SID_2_ADDRESS,    N_("Specify base address for 2nd SID")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_SID_2_ADDRESS_DA, "Angiv baseadresse for sekundr SID"},
/* de */ {IDCLS_SPECIFY_SID_2_ADDRESS_DE, "Basis Adresse fr zweiten SID definieren"},
/* es */ {IDCLS_SPECIFY_SID_2_ADDRESS_ES, "Especificar direccin base para el segundo ISD"},
/* fr */ {IDCLS_SPECIFY_SID_2_ADDRESS_FR, "Spcifier l'adresse de base pour le second SID"},
/* hu */ {IDCLS_SPECIFY_SID_2_ADDRESS_HU, "Adja meg a bziscmt a msodik SID-nek"},
/* it */ {IDCLS_SPECIFY_SID_2_ADDRESS_IT, "Specifica l'indirizzo di base per il secondo SID"},
/* ko */ {IDCLS_SPECIFY_SID_2_ADDRESS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_SID_2_ADDRESS_NL, "Geef het basisadres van de 2e SID"},
/* pl */ {IDCLS_SPECIFY_SID_2_ADDRESS_PL, "Okrel adres bazowy drugiego SID-a"},
/* ru */ {IDCLS_SPECIFY_SID_2_ADDRESS_RU, "Specify base address for 2nd SID"},
/* sv */ {IDCLS_SPECIFY_SID_2_ADDRESS_SV, "Ange basadress fr andra SID"},
/* tr */ {IDCLS_SPECIFY_SID_2_ADDRESS_TR, "2nci SID iin taban adresini belirt"},
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_SID_3_ADDRESS,    N_("Specify base address for 3rd SID")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_SPECIFY_SID_3_ADDRESS_DA, "Angiv baseadresse for tredie SID"},
/* de */ {IDCLS_SPECIFY_SID_3_ADDRESS_DE, "Basis Adresse fr dritten SID definieren"},
/* es */ {IDCLS_SPECIFY_SID_3_ADDRESS_ES, "Especificar direccin base para el tercer SID"},
/* fr */ {IDCLS_SPECIFY_SID_3_ADDRESS_FR, "Spcifier l'adresse de base pour le troisime SID"},
/* hu */ {IDCLS_SPECIFY_SID_3_ADDRESS_HU, ""},  /* fuzzy */
/* it */ {IDCLS_SPECIFY_SID_3_ADDRESS_IT, "Specifica l'indirizzo di base per il terzo SID"},
/* ko */ {IDCLS_SPECIFY_SID_3_ADDRESS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_SPECIFY_SID_3_ADDRESS_NL, "Geef het basisadres van de 3e SID"},
/* pl */ {IDCLS_SPECIFY_SID_3_ADDRESS_PL, "Okrel adres bazowy trzeciego SID-a"},
/* ru */ {IDCLS_SPECIFY_SID_3_ADDRESS_RU, "Specify base address for 3rd SID"},
/* sv */ {IDCLS_SPECIFY_SID_3_ADDRESS_SV, "Ange basadress fr tredje SID"},
/* tr */ {IDCLS_SPECIFY_SID_3_ADDRESS_TR, "3nc SID iin taban adresini belirt"},
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_ENABLE_SID_FILTERS,    N_("Emulate SID filters")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_ENABLE_SID_FILTERS_DA, "Emulr SID-filtre"},
/* de */ {IDCLS_ENABLE_SID_FILTERS_DE, "SID Filter Emulation aktivieren"},
/* es */ {IDCLS_ENABLE_SID_FILTERS_ES, "Emular filtros SID"},
/* fr */ {IDCLS_ENABLE_SID_FILTERS_FR, "muler les filtres SID"},
/* hu */ {IDCLS_ENABLE_SID_FILTERS_HU, "SID szrk emulcija"},
/* it */ {IDCLS_ENABLE_SID_FILTERS_IT, "Emula i filtri del SID"},
/* ko */ {IDCLS_ENABLE_SID_FILTERS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_ENABLE_SID_FILTERS_NL, "Emuleer SID filters"},
/* pl */ {IDCLS_ENABLE_SID_FILTERS_PL, "Emuluj filtry SID"},
/* ru */ {IDCLS_ENABLE_SID_FILTERS_RU, "Emulate SID filters"},
/* sv */ {IDCLS_ENABLE_SID_FILTERS_SV, "Emulera SID-filter"},
/* tr */ {IDCLS_ENABLE_SID_FILTERS_TR, "SID filtrelerini emle et"},
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_DISABLE_SID_FILTERS,    N_("Do not emulate SID filters")},
#ifdef HAS_TRANSLATION
/* da */ {IDCLS_DISABLE_SID_FILTERS_DA, "Emulr ikke SID-filtre"},
/* de */ {IDCLS_DISABLE_SID_FILTERS_DE, "SID Filter Emulation deaktivieren"},
/* es */ {IDCLS_DISABLE_SID_FILTERS_ES, "No emular filtros SID"},
/* fr */ {IDCLS_DISABLE_SID_FILTERS_FR, "Ne pas muler les filtres SID"},
/* hu */ {IDCLS_DISABLE_SID_FILTERS_HU, "Nem emullja a SID szrket"},
/* it */ {IDCLS_DISABLE_SID_FILTERS_IT, "Non emulare i filtri del SID"},
/* ko */ {IDCLS_DISABLE_SID_FILTERS_KO, ""},  /* fuzzy */
/* nl */ {IDCLS_DISABLE_SID_FILTERS_NL, "SID filters niet emuleren"},
/* pl */ {IDCLS_DISABLE_SID_FILTERS_PL, "Nie emuluj filtrw SID"},
/* ru */ {IDCLS_DISABLE_SID_FILTERS_RU, "Do not emulate SID filters"},
/* sv */ {IDCLS_DISABLE_SID_FILTERS_SV, "Emulera inte SID-filter"},
/* tr */ {IDCLS_DISABLE_SID_FILTERS_TR, "SID filtrelerini emle etme"},
#endif

#ifdef HAVE_RESID
/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_RESID_SAMPLING_METHOD,    N_("reSID sampling method (0: fast, 1: interpolating, 2: resampling, 3: fast resampling)")},
#ifdef