//Wolf4SDL\DC
//dc_vmu.h
//2009 - Cyle Terry
//
// BJ LCD images made by Antioch


#define LCD_HEIGHT 32
#define LCD_WIDTH 48

const unsigned char vmu_bios_save_icon[544] ={
    0x00,0xf0,0x0d,0xf0,0x0f,0xf0,0x00,0x0f,
    0x44,0xf4,0x62,0xfb,0x96,0xff,0xca,0xff,
    0xff,0xff,0x00,0xf0,0x00,0xf0,0x00,0xf0,
    0x00,0xf0,0x00,0xf0,0x00,0xf0,0x00,0xf0,
    0x33,0x33,0x33,0x33,0x33,0x55,0x55,0x55,
    0x55,0x55,0x53,0x33,0x33,0x33,0x33,0x33,
    0x33,0x33,0x33,0x05,0x55,0x55,0x55,0x55,
    0x56,0x56,0x55,0x53,0x33,0x33,0x33,0x33,
    0x33,0x33,0x30,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x55,0x55,0x53,0x33,0x33,0x33,
    0x33,0x33,0x34,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x66,0x55,0x53,0x33,0x33,0x33,
    0x33,0x33,0x45,0x55,0x55,0x44,0x45,0x55,
    0x45,0x45,0x56,0x55,0x55,0x33,0x33,0x33,
    0x33,0x33,0x04,0x55,0x54,0x44,0x45,0x45,
    0x44,0x55,0x55,0x55,0x55,0x33,0x33,0x33,
    0x33,0x33,0x45,0x54,0x45,0x66,0x55,0x54,
    0x44,0x44,0x55,0x54,0x45,0x33,0x33,0x33,
    0x33,0x33,0x34,0x45,0x56,0x67,0x76,0x66,
    0x55,0x55,0x56,0x65,0x54,0x33,0x33,0x33,
    0x33,0x33,0x34,0x56,0x67,0x77,0x77,0x77,
    0x56,0x56,0x56,0x75,0x54,0x33,0x33,0x33,
    0x33,0x33,0x34,0x57,0x76,0x76,0x77,0x77,
    0x76,0x66,0x77,0x76,0x64,0x33,0x33,0x33,
    0x33,0x33,0x34,0x56,0x66,0x78,0x87,0x77,
    0x75,0x57,0x78,0x66,0x64,0x33,0x33,0x33,
    0x33,0x33,0x44,0x57,0x74,0x45,0x57,0x77,
    0x76,0x65,0x44,0x76,0x60,0x43,0x33,0x33,
    0x33,0x33,0x60,0x64,0x44,0x10,0x00,0x55,
    0x50,0x04,0x41,0x46,0x64,0x63,0x33,0x33,
    0x33,0x33,0x60,0x66,0x67,0x12,0x75,0x56,
    0x55,0x71,0x28,0x65,0x54,0x63,0x33,0x33,
    0x33,0x33,0x55,0x67,0x76,0x66,0x67,0x67,
    0x77,0x76,0x66,0x76,0x64,0x53,0x33,0x33,
    0x33,0x33,0x66,0x77,0x78,0x78,0x77,0x68,
    0x77,0x77,0x88,0x76,0x67,0x63,0x33,0x33,
    0x33,0x33,0x66,0x77,0x78,0x78,0x77,0x68,
    0x77,0x77,0x88,0x76,0x67,0x63,0x33,0x33,
    0x33,0x33,0x66,0x67,0x77,0x87,0x76,0x77,
    0x76,0x77,0x78,0x76,0x66,0x63,0x33,0x33,
    0x33,0x33,0x54,0x57,0x77,0x77,0x65,0x54,
    0x55,0x67,0x77,0x65,0x54,0x53,0x33,0x33,
    0x33,0x33,0x35,0x66,0x66,0x77,0x66,0x65,
    0x77,0x67,0x77,0x66,0x65,0x33,0x33,0x33,
    0x33,0x33,0x33,0x66,0x67,0x76,0x77,0x76,
    0x77,0x77,0x76,0x66,0x63,0x33,0x33,0x33,
    0x33,0x33,0x33,0x76,0x67,0x76,0x55,0x66,
    0x65,0x56,0x77,0x67,0x73,0x33,0x33,0x33,
    0x33,0x33,0x33,0x67,0x76,0x76,0x67,0x77,
    0x77,0x66,0x76,0x77,0x73,0x33,0x33,0x33,
    0x33,0x33,0x33,0x66,0x67,0x77,0x76,0x66,
    0x67,0x77,0x77,0x67,0x73,0x33,0x33,0x33,
    0x33,0x33,0x33,0x56,0x67,0x77,0x87,0x77,
    0x77,0x78,0x77,0x67,0x73,0x33,0x33,0x33,
    0x33,0x33,0x33,0x45,0x56,0x67,0x77,0x76,
    0x67,0x77,0x76,0x67,0x73,0x33,0x33,0x33,
    0x33,0x33,0x33,0x55,0x55,0x55,0x66,0x55,
    0x66,0x57,0x55,0x77,0x73,0x33,0x33,0x33,
    0x33,0x33,0x33,0x44,0x44,0x44,0x44,0x44,
    0x44,0x54,0x56,0x77,0x73,0x33,0x33,0x33,
    0x33,0x33,0x33,0x55,0x54,0x54,0x45,0x54,
    0x55,0x55,0x77,0x57,0x73,0x33,0x33,0x33,
    0x33,0x33,0x33,0x44,0x45,0x45,0x56,0x56,
    0x56,0x57,0x77,0x75,0x53,0x33,0x33,0x33,
    0x33,0x33,0x33,0x54,0x44,0x55,0x66,0x67,
    0x76,0x56,0x76,0x75,0x53,0x33,0x33,0x33,
    0x33,0x33,0x33,0x45,0x55,0x55,0x67,0x66,
    0x77,0x66,0x76,0x55,0x53,0x33,0x33,0x33
};

static const char FACE1ALCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..                 ..             \
              ..  ..         ..  ..             \
              .. .....     ..... ..             \
             ..... ........... .....            \
             ... . .. . . . .. . ...            \
             ...        .        ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              . .   .   .   .   . .             \
              .    .         .    .             \
              .     .........     .             \
               .                 .              \
               .      .....      .              \
               ..               ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE1BLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              .. ...             ..             \
              ...   .        ..  ..             \
              ........     ..... ..             \
             ......  ........  .....            \
             ... ..   . . ...  . ...            \
             ...        .        ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .     ......    . .             \
              . .       .   .   . .             \
              .              .    .             \
              .      .........    .             \
               .                 .              \
               .       ....      .              \
               ..               ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE1CLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..             ......             \
              ..  ..        .    ..             \
              .. .....     ..... ..             \
             .....  ......... ......            \
             ... .  ... . .   .. ...            \
             ...        .        ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              . .   .   .       . .             \
              .    .              .             \
              .     ........      .             \
               .                 .              \
               .      .....      .              \
               ..               ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE2ALCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..                 ..             \
              ..  ..         ..  ..             \
              .. .....     ..... ..             \
             ..... ........... .....            \
             ... . .. . . . .. . ...            \
             ...        .        ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              . .   .   .   .   . .             \
              .    .         .    .             \
              .     .........     .             \
               .           .     .              \
               .      .... .     .              \
               ..               ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE2BLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              .. ...             ..             \
              ...   .        ..  ..             \
              ........     ..... ..             \
             ......  ........  .....            \
             ... ..   . . ...  . ...            \
             ...        .        ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .     ......    . .             \
              . .       .   .   . .             \
              .              .    .             \
              .      .........    .             \
               .            .    .              \
               .       .... .    .              \
               ..           .   ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE2CLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..             ......             \
              ..  ..        .    ..             \
              .. .....     ..... ..             \
             .....  ......... ......            \
             ... .  ... . .   .. ...            \
             ...        .        ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              . .   .   .       . .             \
              .    .              .             \
              .     ........      .             \
               .          .      .              \
               .      .....      .              \
               ..         .     ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE3ALCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..                 ..             \
              ..  ..         ..  ..             \
              .. .....     ..... ..             \
             ..... ........... .....            \
             ... . .. . . . .. . ...            \
             ...        .        ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              . .   .   . . .   . .             \
              .    .      .  .    .             \
              .     .........     .             \
               .          ..     .              \
               .      .... .     .              \
               ..               ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE3BLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              .. ...             ..             \
              ...   .        ..  ..             \
              ........     ..... ..             \
             ......  ........  .....            \
             ... ..   . . ...  . ...            \
             ...        .        ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .     ......    . .             \
              . .       . . .   . .             \
              .           .. .    .             \
              .      .........    .             \
               .            ..   .              \
               .       .... .    .              \
               ..           .   ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE3CLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..             ......             \
              ..  ..        .    ..             \
              .. .....     ..... ..             \
             .....  ......... ......            \
             ... .  ... . ... .. ...            \
             ...        .        ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              . .   .   . .     . .             \
              .    .     ..       .             \
              .     ........      .             \
               .          ..     .              \
               .      .....      .              \
               ..         .     ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE4ALCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..                 ..             \
              ..  ..         ..  ..             \
              .. .....     ..... ..             \
             ..... ........... .....            \
             ... . .. . . ...... ...            \
             ...        .        ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              . .   . . . . .   . .             \
              .    .  .   .  .    .             \
              .     .........     .             \
               .        ......   .              \
               .      ....  .    .              \
               ..           .   ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE4BLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              .. ...             ..             \
              ...   .        ..  ..             \
              ........     ..... ..             \
             ......  ........  .....            \
             ... ..   . .....  . ...            \
             ...        .        ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .     ......    . .             \
              . .     . . . .   . .             \
              .       .   .. .    .             \
              .      .........    .             \
               .          .....  .              \
               .       .... .    .              \
               ..           .   ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE4CLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..             ......             \
              ..  ..        .    ..             \
              .. .....     ..... ..             \
             .....  ......... ......            \
             ... .  ... . ... .. ...            \
             ...        .   .    ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              . .   .  .. .     . .             \
              .    .    ...       .             \
              .     ........      .             \
               .         ...     .              \
               .      .....      .              \
               ..         .     ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE5ALCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..                 ..             \
              ..  ..         ..  ..             \
              .. .....     ..... ..             \
             ..... ......... . .....            \
             ... . .. . . ...... ...            \
             ...        .        ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              . .   . . . . .   . .             \
              .    .  .   .  .    .             \
              .     .........     .             \
               .     .  ......   .              \
               .     ..........  .              \
               ..    .      .   ..              \
               ...      .   .  . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE5BLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              .. ...             ..             \
              ...   .        ..  ..             \
              ........     ..... ..             \
             ......  ...............            \
             ... ..   . .. .. .. ...            \
             ...        .        ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .     ......    . .             \
              . .      .. . .   . .             \
              .        .  .. .    .             \
              .      .........    .             \
               .     .    .....  .              \
               .     . .... .    .              \
               ..    .      .   ..              \
               ...      .   .  . .              \
               ....     .   . .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE5CLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..             ......             \
              ..  ..        ...  ..             \
              .. .....     ..... ..             \
             .....  ................            \
             ... .  ... . ... .. ...            \
             ...        .   .    ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              . .   .  .. .     . .             \
              .    .  . ...       .             \
              .     ........      .             \
               .    ..   ...     .              \
               .    . .... .     .              \
               ..          .    ..              \
               ...      .  .   . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE6ALCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .               .             \
              .. .                .             \
              . . .      ...    ...             \
              .. . ....  .  .  .  .             \
              . .      . .  . .   .             \
              ...      . .  . .  ..             \
              ..        .   ...  ..             \
              ..            .    ..             \
              .. ....       .... ..             \
             ..... ....   ..........            \
             ... . .. .......... ...            \
             ...        .  ....  ...            \
             ..                   ..            \
             ..                   ..            \
              ..      .   .      ..             \
              . .    ..   ..    . .             \
              . .   .  ...  .   . .             \
              .        . .        .             \
               .     .......     .              \
               .    ..  ......   .              \
               ..   ..     .    ..              \
               ...   .     .   . .              \
               ....     . .   .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE6BLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .               .             \
              .. .                .             \
              . . .      ...    ...             \
              .. . ....  .  .  .  .             \
              . .      . .  . .   .             \
              ...      . .  . .  ..             \
              ..        .   ...  ..             \
              .. ...        .    ..             \
              ...  ..       .... ..             \
             ... .. ...   ..........            \
             ... ..  ........... ...            \
             ...        .  ....  ...            \
             ..                   ..            \
             ..                   ..            \
              ..      .   .      ..             \
              . .    ..   ..    . .             \
              . .   .  ...  .   . .             \
              .        . .        .             \
               .     .......     .              \
               .    ..  ......   .              \
               ..   ..     .    ..              \
               ...   .     .   . .              \
               ....     . .   .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE6CLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .               .             \
              .. .                .             \
              . . .      ...    ...             \
              .. . ....  .  .  .  .             \
              . .      . .  . .   .             \
              ...      . .  . .  ..             \
              ..        .   ...  ..             \
              ..           ..... ..             \
              .. ....     . .   ...             \
             .....  ...   ..........            \
             ... .  ............ ...            \
             ...        .  ....  ...            \
             ..                   ..            \
             ..                   ..            \
              ..      .   .      ..             \
              . .    ..   ..    . .             \
              . .   .  ...  .   . .             \
              .        . .        .             \
               .     .......     .              \
               .    ..  .....    .              \
               ..   ..     .    ..              \
               ...   .     .   . .              \
               ....     . .   .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE7ALCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .               .             \
              .. .                .             \
              . . .               .             \
              .. . .    .         .             \
              . . ..   . . ..   ...             \
              ....  . ..  . .  . ..             \
              ...   .. .    .  . ..             \
              ..   .        . .  ..             \
             ...            ..   ...            \
             ... ....     ...... ...            \
             ..... ....   ..........            \
             ...   ..  ... ..... ...            \
             ..         . ......  ..            \
              .              ..   .             \
              .                   .             \
              ..      .   .      ..             \
              . .    ..   ..    ...             \
              . .   .  ...  .   ...             \
               .       . .       .              \
               .    .........    .              \
               ..   ..  ......  ..              \
               ...  ..      .  . .              \
               ....  .  . . . .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE7BLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .               .             \
              .. .                .             \
              . . .               .             \
              .. . .    .         .             \
              . . ..   . . ..   ...             \
              ....  . ..  . .  . ..             \
              ...   .. .    .  . ..             \
              ..            . .  ..             \
             ...  .         ..   ...            \
             ... . ..       .... ...            \
             ......  ..   ..........            \
             ... ...  .... ..... ...            \
             ..         . ......  ..            \
              .              ..   .             \
              .           .       .             \
              .           .      ..             \
              .      ..   ..    ...             \
              ..       ...  .   ...             \
               ..      . .       .              \
               ..    ........    .              \
               ...   .. ......  ..              \
               ....  ..     .  . .              \
               .....  . . . . .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE7CLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .               .             \
              .. .                .             \
              . . .               .             \
              .. . .    .         .             \
              . . ..   . . ..   ...             \
              ....  . ..  . .  . ..             \
              ...   .. .    .  . ..             \
              ..   .        . .  ..             \
             ...            ...  ...            \
             ... ....     ...... ...            \
             .....  ...   ..........            \
             ... .. .. ... ..... ...            \
             ..         . ....... ..            \
              .              .. . .             \
              .                   .             \
              ..      .   .      ..             \
              . .    ..   ..    ...             \
              . .   .  ...  .   ...             \
               .       . .       .              \
               .   ..........    .              \
               ..  ...  .....   ..              \
               ...  ..     .   . .              \
               .... ..  . ..  .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char FACE8ALCD[] =
"\
                                                \
                                                \
                                                \
                 ..............                 \
                . .            .                \
               . .             ..               \
              . . .              ..             \
              .. .                .             \
              . . .               .             \
              .. .                .             \
              ...                 .             \
              .. .                .             \
              ... . .             .             \
              .. . . .            .             \
             .... ....          ....            \
             ... ...  . .       . ..            \
             ... . .   . ..     . ..            \
             .... .    .  .  . . ...            \
             ...  ...     ... .  ...            \
              .. .....    ......  .             \
              .   ............. ...             \
              .  ....  .  ...... ..             \
               . ..   .    . .  ..              \
               . .    .    .  .  .              \
               . .    .    .  .  .              \
               ...   ...  .     ..              \
               ...  .......    . .              \
               ...  .........  . .              \
               ...  ...    ..  . .              \
               ................  .              \
                ....         .  .               \
                .....       ..  .               ";

static const char GOTGATLINGLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ... ..         ..  ..             \
              ..    .       .    ..             \
              .. .....     ..... ..             \
              .. . .. .. .. .. . ..             \
             ...  .. . . . . ..  ...            \
             ...       . .       ...            \
             ...                 ...            \
             ..                   ..            \
             .....   .     .   .....            \
              . .    .......    . .             \
              . . ..    .    .. . .             \
              .   . ......... .   .             \
              .    .         .    .             \
               ..   .       .   ..              \
               ..   ........    ..              \
               ..               ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char MUTANTBJLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              .. . .         . . ..             \
              .. .   .     .   . ..             \
              ..  ..  .   .  ..  ..             \
             ..... .. . . . .. .....            \
             ... . . .. . .. . . ...            \
             ...  ....  .  ....  ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              .  .   .  .  .   .  .             \
              .  .             .  .             \
              .  .   .......   .  .             \
               .    .       .    .              \
               .      .....      .              \
               ..               ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

#ifdef SPEAR
static const char GODMODEFACE1LCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..                 ..             \
              ..                 ..             \
              .. .....     ..... ..             \
             .....   .......   .....            \
             ... .    . . .    . ...            \
             ...  . .   .   . .  ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              . .       .       . .             \
              .                   .             \
              .     .........     .             \
               .                 .              \
               .      .....      .              \
               ..               ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char GODMODEFACE2LCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..                 ..             \
              ..  ....           ..             \
              .. .   ..    ..... ..             \
             .....   ......... .....            \
             ... .    . . .    . ...            \
             ...  . .   .   . .  ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              . .       .       . .             \
              .                   .             \
              .     .........     .             \
               .                 .              \
               .      .....      .              \
               ..               ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char GODMODEFACE3LCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..                 ..             \
              ..           ....  ..             \
              .. ....     ..   ....             \
             ..... ........    . ...            \
             ... .    . . .    . ...            \
             ...  . .   .   . .  ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              . .       .       . .             \
              .                   .             \
              .     .........     .             \
               .                 .              \
               .      .....      .              \
               ..               ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char BJWAITING1LCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..                 ..             \
              ..  ..         ..  ..             \
              .. .....     ..... ..             \
             .....  .........  .....            \
             ... .  ... . ...  . ...            \
             ...        .        ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . ..   .......   .. .             \
              .  .  .   .   .  .  .             \
              .  .             .  .             \
              .  .    .....    .  .             \
               .                 .              \
               .                 .              \
               ..               ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char BJWAITING2LCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..                 ..             \
              ..  ..         ..  ..             \
              .. .....     ..... ..             \
             ..... ........... .....            \
             ... . .. . . . .. . ...            \
             ...        .        ...            \
             ..                   ..            \
             ....     .   .     ....            \
              .  .   .......   .  .             \
              .  .  .   .   .  .  .             \
              .    .         .    .             \
              .       .....       .             \
               .     .. . ..     .              \
               .      . . .      .              \
               ..     .   .     ..              \
               ...     ...     . .              \
               ....           .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";

static const char BJOUCHLCD[] =
"\
                                                \
                 ...............                \
                .               .               \
               . .               .              \
              . . .      ...    ...             \
              .. . ....  .  .  . ..             \
              . . .    . .   ..   .             \
              .. .      .     .   .             \
              . .             .   .             \
              ...                ..             \
              ..                 ..             \
              .. ......   ...... ..             \
              .....  .     .  .....             \
             ... . .. .   . .. . ...            \
             ... . .. .. .. .. . ...            \
             ...  .  .     .  .  ...            \
             ..                   ..            \
             ...      .   .      ...            \
              . .    .......    . .             \
              . .   .   .   .   . .             \
              .                   .             \
              .      .......      .             \
               .    .........    .              \
               .                 .              \
               ..      ...      ..              \
               ...      .      . .              \
               ....     .     .  .              \
               ...............   .              \
               .....         .  ..              \
                ....         .  .               \
                .....       .   .               \
                .....       .   .               ";
#endif //SPEAR

static const char *e_BJFaces[] = {
	FACE1ALCD,
	FACE1BLCD,
	FACE1CLCD,
	FACE2ALCD,
	FACE2BLCD,
	FACE2CLCD,
	FACE3ALCD,
	FACE3BLCD,
	FACE3CLCD,
	FACE4ALCD,
	FACE4BLCD,
	FACE4CLCD,
	FACE5ALCD,
	FACE5BLCD,
	FACE5CLCD,
	FACE6ALCD,
	FACE6BLCD,
	FACE6CLCD,
	FACE7ALCD,
	FACE7BLCD,
	FACE7CLCD,
	FACE8ALCD,
	GOTGATLINGLCD,
#ifndef SPEAR
	MUTANTBJLCD
#else
	MUTANTBJLCD,
	GODMODEFACE1LCD,
	GODMODEFACE2LCD,
	GODMODEFACE3LCD,
	BJWAITING1LCD,
	BJOUCHLCD
#endif
};
