/* xoreos-tools - Tools to help with xoreos development
 *
 * xoreos-tools is the legal property of its developers, whose names
 * can be found in the AUTHORS file distributed with this source
 * distribution.
 *
 * xoreos-tools is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * xoreos-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xoreos-tools. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  Names of GFF V4.0/V4.1 fields.
 */

#ifndef XML_GFF4FIELDS_H
#define XML_GFF4FIELDS_H

namespace XML {

struct GFF4FieldName {
	uint32 label;
	const char *name;
};

static const GFF4FieldName kGFF4FieldName[] = {
	{      1, "Tag"                                             },
	{      2, "Name"                                            },
	{      3, "TemplateResRef"                                  },
	{      4, "Position"                                        },
	{      5, "Orientation"                                     },
	{      6, "Uint8List"                                       },
	{      7, "Int8List"                                        },
	{      8, "Uint16List"                                      },
	{      9, "Int16List"                                       },
	{     10, "Uint32List"                                      },
	{     11, "Int32List"                                       },
	{     12, "Uint64List"                                      },
	{     13, "Int64List"                                       },
	{     14, "Float32List"                                     },
	{     15, "Float64List"                                     },
	{     16, "Vector3fList"                                    },
	{     17, "Vector4fList"                                    },
	{     18, "QuaternionfList"                                 },
	{     19, "EcstringList"                                    },
	{     20, "Color4fList"                                     },
	{     21, "NameHash"                                        },
	{     22, "Text"                                            },
	{     23, "ObjectID"                                        },

	{    900, "TsProperty"                                      },
	{    901, "TsPropertyName"                                  },
	{    902, "TsPropertyAtom"                                  },
	{    903, "TsPropertyValue"                                 },
	{    904, "TsPropertyChildren"                              },
	{    905, "TsPropertyVartype"                               },

	{   1000, "ItemBaseID"                                      },
	{   1001, "ItemCost"                                        },
	{   1002, "ItemStackSize"                                   },
	{   1003, "ItemStolen"                                      },
	{   1004, "ItemPlot"                                        },
	{   1005, "ItemIDentified"                                  },
	{   1006, "ItemCharges"                                     },
	{   1007, "ItemModelVariation"                              },
	{   1008, "ItemDescription"                                 },
	{   1009, "ItemPropertyList"                                },
	{   1010, "ItemMaterial"                                    },
	{   1011, "ItemAbilityID"                                   },
	{   1012, "ItemAbilityPwr"                                  },
	{   1013, "ItemProperties"                                  },
	{   1014, "ItemPropertyPowers"                              },
	{   1015, "ItemPropertyEffectID"                            },
	{   1018, "ItemPropertyVFXID"                               },
	{   1019, "ItemSubitemsResRefs"                             },
	{   1020, "ItemCraftingRecipeID"                            },
	{   1021, "ItemBaseCost"                                    },

	{   2000, "ItemPropParam1"                                  },
	{   2001, "ItemPropPropertyName"                            },
	{   2002, "ItemPropSubType"                                 },
	{   2003, "ItemPropCostTable"                               },
	{   2004, "ItemPropCostValue"                               },
	{   2005, "ItemPropParam1Value"                             },
	{   2006, "ItemPropChanceAppear"                            },

	{   3000, "EnvWorld"                                        },
	{   3001, "EnvWorldName"                                    },
	{   3002, "EnvWorldAreaList"                                },
	{   3003, "LvlChildList"                                    },
	{   3004, "LvlFileObjectVersion"                            },
	{   3005, "LvlChangeTime"                                   },

	{   3010, "EnvArea"                                         },
	{   3011, "EnvAreaID"                                       },
	{   3012, "EnvAreaName"                                     },
	{   3013, "EnvAreaFile"                                     },
	{   3014, "EnvAreaEnvironmentSettings"                      },
	{   3015, "EnvAreaNavigationInfoFile"                       },
	{   3016, "EnvAreaRoomList"                                 },
	{   3017, "EnvAreaRoomListElement"                          },
	{   3018, "EnvAreaPosition"                                 },
	{   3019, "EnvAreaRotation"                                 },
	{   3020, "EnvAreaPathfindExport"                           },
	{   3021, "EnvAreaPathfindVisInfo"                          },
	{   3022, "EnvAreaPathfindVisinfoCount"                     },
	{   3023, "EnvAreaFrameBufEffect"                           },
	{   3024, "EnvAreaCenter"                                   },
	{   3025, "EnvAreaSkydomeModel"                             },
	{   3026, "EnvAreaFrameBufEffectList"                       },
	{   3027, "EnvAreaGlobalwindResRef"                         },
	{   3028, "EnvAreaLocalwindList"                            },
	{   3029, "EnvAreaPathfindCosts"                            },

	{   3030, "EnvRoom"                                         },
	{   3031, "EnvRoomID"                                       },
	{   3032, "EnvRoomName"                                     },
	{   3033, "EnvRoomFile"                                     },
	{   3034, "EnvRoomEnvironmentSettings"                      },
	{   3035, "EnvRoomPosition"                                 },
	{   3036, "EnvRoomRotation"                                 },
	{   3037, "EnvRoomPathfindGridSep"                          },
	{   3038, "EnvRoomPathfindCharHeight"                       },
	{   3039, "EnvRoomPathfindClearance"                        },
	{   3040, "EnvRoomPathfindExport"                           },
	{   3041, "EnvRoomPathfindVisInfo"                          },
	{   3042, "EnvRoomPathfindVisInfoCount"                     },
	{   3043, "EnvRoomPathGridFile"                             },
	{   3044, "EnvRoomPathConnectionList"                       },
	{   3045, "EnvRoomPathConnection"                           },
	{   3046, "EnvRoomPathConnectionID"                         },
	{   3047, "EnvRoomVisibilityList"                           },
	{   3048, "EnvRoomVisibility"                               },
	{   3049, "EnvRoomVisibilityID"                             },
	{   3050, "EnvRoomModelList"                                },
	{   3051, "EnvRoomLightList"                                },
	{   3052, "EnvRoomModelListElement"                         },
	{   3053, "EnvRoomLightListElement"                         },
	{   3054, "EnvRoomDynShadowDirection"                       },
	{   3055, "EnvRoomDynShadowEnabled"                         },

	{   3056, "EnvModelPathfindOverlapped"                      },
	{   3057, "EnvModelShowHighLod"                             },
	{   3058, "EnvModelSnapToTerrain"                           },
	{   3059, "EnvModelScale"                                   },

	{   3060, "EnvModel"                                        },
	{   3061, "EnvModelID"                                      },
	{   3062, "EnvModelName"                                    },
	{   3063, "EnvModelFile"                                    },
	{   3064, "EnvModelPosition"                                },
	{   3065, "EnvModelRotation"                                },
	{   3066, "EnvModelPathfindNormal"                          },

	{   3067, "EnvLight"                                        },
	{   3068, "EnvLightID"                                      },
	{   3069, "EnvLightName"                                    },
	{   3070, "EnvLightPosition"                                },
	{   3071, "EnvLightRotation"                                },
	{   3072, "LightColor"                                      },
	{   3073, "LightIsDynamic"                                  },
	{   3074, "LightType"                                       },
	{   3075, "LightPointRadius"                                },
	{   3076, "LightColorMultiplier"                            },
	{   3077, "LightBaked"                                      },
	{   3078, "LightEffect"                                     },
	{   3079, "LightAffectDomain"                               },

	{   3080, "AreaGridNavInfo"                                 },
	{   3081, "AreaGridRoomName"                                },
	{   3082, "AreaGridGridNavInfo"                             },
	{   3083, "AreaGridModelGrid"                               },
	{   3084, "AreaGridGridID"                                  },
	{   3085, "AreaGridModelID"                                 },
	{   3086, "AreaGridNbColumns"                               },
	{   3087, "AreaGridNbRows"                                  },
	{   3088, "AreaGridCellSize"                                },
	{   3089, "AreaGridClearance"                               },
	{   3090, "AreaGridBasePos"                                 },
	{   3091, "AreaGridNormal"                                  },
	{   3092, "AreaGridData"                                    },
	{   3093, "AreaGridHeight"                                  },
	{   3094, "AreaGridAbstractSectorSize"                      },
	{   3095, "AreaGridAbstractSectors"                         },
	{   3096, "AreaGridAbstractMemory"                          },
	{   3097, "AreaGridID"                                      },
	{   3098, "AreaGridCellID"                                  },

	{   3099, "EnvRoomConnectivityList"                         },

	{   3100, "LightSpotInnerAngle"                             },
	{   3101, "LightSpotOuterAngle"                             },
	{   3102, "LightSpotDistance"                               },

	{   3103, "EnvLightProbe"                                   },
	{   3104, "EnvLightProbeEnvMap"                             },

	{   3105, "EnvLightNumSamples"                              },
	{   3106, "EnvLightSize"                                    },
	{   3107, "DynamicShadowVectorGame"                         },

	{   3108, "EnvLightProbeID"                                 },

	{   3109, "EnvModelCutAwayOverride"                         },

	{   3110, "AreaGridArea"                                    },

	{   3114, "AreaGridSoundData"                               },
	{   3115, "AreaGridAbstractionSNumReg"                      },
	{   3116, "AreaGridAbstractionSaddr"                        },

	{   3117, "AreaGridLightSubsetData8"                        },
	{   3118, "AreaGridLightSubsetData16"                       },

	{   3119, "LightCanBeOccluded"                              },

	{   3120, "AreaGridCellPadding"                             },

	{   3111, "AreaGridAreaID"                                  },
	{   3112, "AreaGridRooms"                                   },
	{   3113, "AreaGridRoom"                                    },
	{   3114, "AreaGridRoomID"                                  },
	{   3115, "AreaGridRoomNumberOfLinks"                       },
	{   3116, "AreaGridLinks"                                   },
	{   3117, "AreaGridLink"                                    },
	{   3118, "AreaGridLinkID"                                  },
	{   3119, "AreaGridLinkCellID"                              },
	{   3120, "AreaGridLinkRoomID"                              },
	{   3121, "AreaGridLinkNeighborIDs"                         },

	{   3122, "EnvAreaChunkIsChunk"                             },
	{   3123, "EnvAreaChunkRowCount"                            },
	{   3124, "EnvAreaChunkColCount"                            },
	{   3125, "EnvAreaChunkWidth"                               },
	{   3126, "EnvAreaChunkHeight"                              },
	{   3127, "EnvAreaLayoutName"                               },
	{   3128, "EnvAreaStartPointName"                           },
	{   3129, "EnvAreaCutoffHeight"                             },

	{   3130, "LightAnimatedMinFrequency"                       },
	{   3131, "LightAnimatedMaxFrequency"                       },
	{   3132, "LightAnimatedMinIntensity"                       },
	{   3133, "LightAnimatedMaxIntensity"                       },

	{   3134, "EnvAreaCutoffSystemEnabled"                      },

	{   3137, "EnvMinimapTextureMapCoords"                      },
	{   3138, "EnvMinimapLowerLeftPoint"                        },
	{   3139, "EnvMinimapUpperRightPoint"                       },

	{   3140, "EnvRoomLowerLeftPoint"                           },
	{   3141, "EnvRoomUpperRightPoint"                          },
	{   3142, "EnvAreaForceCharacterLighting"                   },

	{   3148, "EnvAreaSunlightCanBeOccludedChar"                },
	{   3149, "EnvAreaSunlightColorChar"                        },
	{   3150, "EnvAreaSunlightDirection"                        },
	{   3151, "EnvAreaSunlightEnabled"                          },
	{   3152, "EnvAreaSunlightColor"                            },
	{   3153, "EnvAreaSunlightColorMult"                        },

	{   3154, "TerrainChunk"                                    },
	{   3155, "TerrainChunkList"                                },
	{   3156, "TerrainChunkCellPositionX"                       },
	{   3157, "TerrainChunkCellPositionY"                       },
	{   3158, "TerrainChunkLength"                              },
	{   3159, "TerrainChunkWidth"                               },
	{   3160, "TerrainChunkTexelSize"                           },
	{   3161, "TerrainChunkBlendpageSize"                       },
	{   3162, "TerrainChunkSectorID"                            },
	{   3163, "EnvAreaSunlightRotation"                         },

	{   3164, "EnvRoomLightVisList"                             },
	{   3165, "EnvFogColor"                                     },
	{   3166, "EnvFogMaxDistance"                               },
	{   3167, "EnvFogMaxIntensity"                              },
	{   3168, "EnvFogEnabled"                                   },
	{   3169, "EnvFogMinDistance"                               },

	{   3170, "EnvModelNameChanged"                             },

	{   3171, "EnvVegetation"                                   },
	{   3172, "EnvCreature"                                     },

	{   3200, "EnvCamera"                                       },
	{   3201, "EnvCameraPivotDistance"                          },
	{   3202, "EnvStandalone"                                   },
	{   3202, "EnvListArea"                                     },
	{   3203, "EnvListRoom"                                     },
	{   3204, "EnvListModel"                                    },
	{   3205, "EnvListLight"                                    },

	{   3210, "EnvPfContainerLayoutName"                        },
	{   3211, "EnvPfContainerExportData"                        },
	{   3212, "EnvPfContainerDataVersion"                       },
	{   3213, "EnvPfContainerVisInfo"                           },

	{   3290, "RimTreeRootNode"                                 },
	{   3291, "RimTreeRimList"                                  },
	{   3292, "RimTreeChildList"                                },
	{   3293, "RimTreeNodeTag"                                  },
	{   3294, "RimTreeNodeResRef"                               },

	{   3300, "EnvGroup"                                        },
	{   3301, "EnvGroupName"                                    },

	{   3302, "EnvSpGroup"                                      },
	{   3303, "EnvSpGroupName"                                  },
	{   3304, "EnvSp"                                           },
	{   3305, "EnvSpFile"                                       },

	{   3310, "EnvObjectVisible"                                },
	{   3311, "EnvObjectLockSelection"                          },

	{   3320, "EnvModelInstanceID"                              },
	{   3321, "EnvModelBoundsCenter"                            },
	{   3322, "EnvModelBoundsRadius"                            },
	{   3323, "EnvModelLightmapAtlas"                           },
	{   3324, "EnvModelLightmapOffsetScale"                     },
	{   3235, "EnvModelLightmapPartID"                          },
	{   3326, "EnvModelLightmapAtlasList"                       },

	{   3330, "LvlLightmapSizeMultiplier"                       },

	{   3331, "LvlLightmapLastUpdatedList"                      },
	{   3332, "LvlLightmapLastUpdated"                          },
	{   3333, "LvlLightmapFilespec"                             },
	{   3334, "LvlLightingVersion"                              },

	{   3340, "LvlAoColorMin"                                   },
	{   3341, "LvlAoColorMax"                                   },
	{   3342, "LvlAoSamplesMin"                                 },
	{   3343, "LvlAoSamplesMax"                                 },
	{   3344, "LvlAoAdaptsampleEnabled"                         },
	{   3345, "LvlAoAdaptsampleAccuracy"                        },
	{   3346, "LvlAoAdaptsampleSmooth"                          },
	{   3347, "LvlAoConeAngle"                                  },
	{   3348, "LvlAoMaxRayLength"                               },
	{   3349, "LvlAoExponent"                                   },

	{   3350, "EnvTree"                                         },
	{   3351, "EnvTreenodeID"                                   },
	{   3352, "EnvTreeName"                                     },
	{   3353, "EnvTreeFile"                                     },
	{   3354, "EnvRoomTreenodeList"                             },
	{   3355, "EnvAreaTreecontrollerList"                       },
	{   3356, "EnvTreeScale"                                    },
	{   3357, "EnvAreaTreecontrollerID"                         },
	{   3358, "EnvTreePaintedList"                              },
	{   3359, "EnvTreePaintedPosition"                          },
	{   3360, "EnvTreePaintedRotation"                          },
	{   3361, "EnvTreePaintedScale"                             },
	{   3362, "EnvScatterObjects"                               },
	{   3363, "EnvScatterObjectFile"                            },
	{   3364, "EnvScatterInstance"                              },
	{   3365, "EnvScatterInstanceList"                          },
	{   3366, "EnvScatterObjectList"                            },
	{   3367, "EnvScatterObjectID"                              },
	{   3368, "EnvScatterObjIgnoreMaxDensity"                   },
	{   3369, "EnvScatterObjMaxDensity"                         },
	{   3370, "EnvScatterObjMinScale"                           },
	{   3371, "EnvScatterObjMaxScale"                           },
	{   3372, "EnvScatterObjOrient"                             },
	{   3373, "EnvScatterObjPrototype"                          },
	{   3374, "EnvScatterObjMsiData"                            },
	{   3375, "EnvTreeColorTint"                                },
	{   3376, "EnvScatterobjSoundType"                          },
	{   3377, "EnvTreeColorLevelTint"                           },
	{   3378, "EnvTreeColorLevelIntensity"                      },
	{   3379, "EnvTreeDrawDistance"                             },

	{   3400, "TerrainExportArea"                               },
	{   3401, "TerrainExportAreaList"                           },
	{   3403, "TerrainAreaCellPositionX"                        },
	{   3404, "TerrainAreaCellPositionY"                        },
	{   3405, "TerrainAreaCellPositionZ"                        },
	{   3406, "TerrainAreaCellSizeX"                            },
	{   3407, "TerrainAreaCellSizeY"                            },
	{   3408, "TerrainAreaCellSizeZ"                            },
	{   3409, "TerrainAreaBorderCellWidth"                      },
	{   3410, "TerrainAreaVistaCellWidth"                       },
	{   3411, "TerrainAreaLightmapSize"                         },
	{   3412, "TerrainAreaLightmapSizeVista"                    },
	{   3413, "TerrainAreaSubdivideBy"                          },

	{   3500, "EnvModelPartGroup"                               },
	{   3501, "EnvModelLightmapOnly"                            },
	{   3502, "EnvModelLightmapFlag"                            },
	{   3503, "EnvModelExportFlag"                              },
	{   3504, "EnvModelDefaultAnimation"                        },
	{   3505, "EnvModelBlendTreeName"                           },
	{   3506, "EnvModelUserParamList"                           },
	{   3507, "EnvModelUserParamName"                           },
	{   3508, "EnvModelUserParamValue"                          },

	{   3600, "LvlWater"                                        },
	{   3601, "LvlWaterSizeX"                                   },
	{   3602, "LvlWaterSizeY"                                   },
	{   3603, "LvlWaterMaxTessellation"                         },
	{   3604, "LvlWaterMeshID"                                  },
	{   3605, "LvlWaterNormalMap"                               },
	{   3606, "LvlWaterHeightMap"                               },
	{   3607, "LvlWaterDeepColor"                               },
	{   3608, "LvlWaterShallowColor"                            },
	{   3609, "LvlWaterWaveFreq1"                               },
	{   3610, "LvlWaterWaveAmpl1"                               },
	{   3611, "LvlWaterWaveDirection1"                          },
	{   3618, "LvlWaterWaveSpeed1"                              },
	{   3612, "LvlWaterWaveFreq2"                               },
	{   3613, "LvlWaterWaveAmpl2"                               },
	{   3614, "LvlWaterWaveDirection2"                          },
	{   3619, "LvlWaterWaveSpeed2"                              },
	{   3615, "LvlWaterWaveFreq3"                               },
	{   3616, "LvlWaterWaveAmpl3"                               },
	{   3617, "LvlWaterWaveDirection3"                          },
	{   3620, "LvlWaterWaveSpeed3"                              },
	{   3621, "LvlWaterReflectivity"                            },
	{   3622, "LvlWaterFoamHeight"                              },
	{   3623, "LvlWaterSubdivDepthTolerance"                    },
	{   3624, "LvlWaterShallowDepth"                            },
	{   3625, "LvlWaterFoamColor"                               },
	{   3626, "LvlWaterWalkableDepth"                           },
	{   3627, "LvlWaterWallHeight"                              },
	{   3628, "LvlWaterOpacityFalloff"                          },
	{   3629, "LvlWaterSunlightSpecularPower"                   },
	{   3630, "LvlWaterSpecularMultiplier"                      },
	{   3631, "LvlWaterSpecularFalloff"                         },
	{   3632, "LvlWaterColorizeTransparency"                    },
	{   3633, "LvlWaterOverrideReflection"                      },
	{   3634, "LvlWaterEnableSpec"                              },

	{   3700, "LvlWind"                                         },
	{   3701, "LvlWindID"                                       },
	{   3702, "LvlWindName"                                     },
	{   3710, "LvlWindIsGlobal"                                 },
	{   3711, "LvlWindRegionRadius"                             },
	{   3712, "LvlWindRegionFalloff"                            },
	{   3713, "LvlWindSptStrength"                              },
	{   3714, "LvlWindSptGustMinPercent"                        },
	{   3715, "LvlWindSptGustMaxPercent"                        },
	{   3716, "LvlWindSptGustMinDuration"                       },
	{   3717, "LvlWindSptGustMaxDuration"                       },
	{   3718, "LvlWindSptBendAngle"                             },
	{   3719, "LvlWindClothResponse"                            },
	{   3720, "LvlWindClothResponseLmt"                         },
	{   3721, "LvlWindClothStrength"                            },
	{   3722, "LvlWindClothGustStrengthMin"                     },
	{   3723, "LvlWindClothGustStrengthMax"                     },
	{   3724, "LvlWindClothGustDurationMin"                     },
	{   3725, "LvlWindClothGustDurationMax"                     },
	{   3726, "LvlWindClothGustIntervalMin"                     },
	{   3727, "LvlWindClothGustIntervalMax"                     },
	{   3728, "LvlWindClothGustDirChange"                       },
	{   3729, "LvlWindClothGustAxisRatio"                       },
	{   3730, "LvlWindSptGustFrequency"                         },

	{   3730, "LvlCollisionWallInfo"                            },
	{   3731, "LvlCollisionWallVerticies"                       },
	{   3732, "LvlCollisionWallVerticiesV2"                     },

	{   3740, "LvlMinimapPositionX"                             },
	{   3741, "LvlMinimapPositionY"                             },
	{   3742, "LvlMinimapSizeX"                                 },
	{   3743, "LvlMinimapSizeY"                                 },

	{   3744, "EnvStatPhys"                                     },
	{   3745, "EnvStatPhysData"                                 },

	{   3800, "LvlLightSubsetList"                              },
	{   3801, "LvlLightSubsetEntry"                             },
	{   3802, "LvlLightSubsetTotalEntries"                      },

	{   4000, "AnimationNodeName"                               },
	{   4001, "AnimationTarget"                                 },
	{   4002, "AnimationSourceType"                             },
	{   4003, "AnimationElementsPerEntry"                       },
	{   4004, "AnimationNodeData"                               },
	{   4005, "AnimationNodeList"                               },
	{   4006, "AnimationName"                                   },
	{   4007, "AnimationGeneralAnimName"                        },
	{   4008, "AnimationHasGobAnim"                             },
	{   4009, "AnimationAnimLength"                             },
	{   4010, "AnimationCombatRange"                            },
	{   4011, "AnimationIsAdditive"                             },
	{   4012, "AnimationIsOverride"                             },
	{   4013, "AnimationOverridePriority"                       },
	{   4014, "AnimationNameHash"                               },
	{   4015, "AnimationNodeNameHash"                           },
	{   4016, "AnimationEventTime"                              },
	{   4017, "AnimationEventID"                                },
	{   4018, "AnimationEventTarget"                            },
	{   4019, "AnimationEventString"                            },
	{   4020, "AnimationEventList"                              },
	{   4021, "AnimationTree"                                   },
	{   4022, "AnimationTreeName"                               },
	{   4023, "AnimationTreeNode"                               },
	{   4024, "AnimationTreeNodeName"                           },
	{   4025, "AnimationTreeNodeFile"                           },
	{   4026, "AnimationTreeNodeWeight"                         },
	{   4027, "AnimationTreeNodeFlags"                          },
	{   4028, "AnimationTreeNodeFirstChild"                     },
	{   4029, "AnimationTreeNodeNumChildren"                    },
	{   4030, "AnimationTreeNodeParent"                         },
	{   4031, "AnimationBlendcurveAnimFrom"                     },
	{   4032, "AnimationBlendcurveAnimTo"                       },
	{   4033, "AnimationBlendcurveData"                         },
	{   4034, "AnimationBlendcurveList"                         },
	{   4035, "AnimationKeyTime"                                },
	{   4036, "AnimationKeyData0"                               },
	{   4037, "AnimationKeyData1"                               },
	{   4038, "AnimationKeyData2"                               },
	{   4039, "AnimationKeyData3"                               },
	{   4040, "AnimationIgnoreScale"                            },

	{   5000, "CutsceneRunTime"                                 },
	{   5001, "CutsceneEndScript"                               },
	{   5002, "CutsceneLayout"                                  },
	{   5003, "CutscenePosition"                                },
	{   5004, "CutsceneOrientation"                             },
	{   5005, "CutsceneTransitionTime"                          },
	{   5006, "CutsceneFov"                                     },
	{   5007, "CutsceneBlendtree"                               },
	{   5008, "CutsceneAnimatic"                                },
	{   5009, "CutsceneShowAreaDynamics"                        },
	{   5010, "CutsceneStaged"                                  },
	{   5011, "CutsceneLodCurves"                               },
	{   5012, "CutsceneAnimSoundEvents"                         },
	{   5013, "CutsceneEnableLevelFbes"                         },
	{   5014, "CutsceneLodOriginPos"                            },
	{   5015, "CutsceneLodOriginOri"                            },
	{   5016, "CutsceneFPS"                                     },
	{   5017, "CutsceneStageResRef"                             },
	{   5018, "CutscenePlayUntilVoCompletes"                    },
	{   5019, "CutsceneAreaRequired"                            },
	{   5020, "CutsceneShadowRadius"                            },
	{   5021, "CutsceneLightOcclusion"                          },

	{   5050, "CutsceneHenchmanTag"                             },
	{   5051, "CutsceneHenchmanActions"                         },

	{   5100, "CutsceneResources"                               },
	{   5101, "CutsceneResourceResRef"                          },
	{   5102, "CutsceneResourceType"                            },

	{   5200, "CutsceneActors"                                  },
	{   5201, "CutsceneActorID"                                 },
	{   5202, "CutsceneActorModelResRef"                        },
	{   5203, "CutsceneActorDeprecated1"                        },
	{   5204, "CutsceneActorDeprecated2"                        },
	{   5205, "CutsceneActorDeprecated3"                        },
	{   5206, "CutsceneActorActionQueue"                        },
	{   5207, "CutsceneActorDeprecated4"                        },
	{   5208, "CutsceneActorCreatureResRef"                     },
	{   5209, "CutsceneActorCameraTarget"                       },
	{   5210, "CutsceneActorUsePose"                            },
	{   5211, "CutsceneActorPose"                               },
	{   5212, "CutsceneActorPoseSpeed"                          },
	{   5213, "CutsceneActorPoseHumanoid"                       },
	{   5214, "CutsceneActorOriginPos"                          },
	{   5215, "CutsceneActorOriginOri"                          },
	{   5216, "CutsceneActorMappingTag"                         },
	{   5217, "CutsceneActorInventory"                          },
	{   5218, "CutsceneActorTransitionDelay"                    },
	{   5219, "CutsceneActorPreviousPose"                       },
	{   5220, "CutsceneActorMappingRequired"                    },
	{   5221, "CutsceneActorFinalPos"                           },
	{   5222, "CutsceneActorFinalOri"                           },
	{   5223, "CutsceneActorMaster"                             },
	{   5224, "CutsceneActorLod"                                },
	{   5225, "CutsceneActorAmbientAnim"                        },
	{   5226, "CutsceneActorModelScale"                         },

	{   5300, "CutsceneActionType"                              },
	{   5301, "CutsceneActionStartTime"                         },
	{   5302, "CutsceneActionStopTime"                          },
	{   5303, "CutsceneActionCurves"                            },
	{   5304, "CutsceneActionCategory"                          },

	{   5350, "CutsceneActionCurveBaseValue"                    },
	{   5351, "CutsceneActionCurveVertices"                     },
	{   5352, "CutsceneActionCurveTransitions"                  },
	{   5353, "CutsceneActionCurveDeprecated"                   },

	{   5370, "CutsceneActionCurveVertexTime"                   },
	{   5371, "CutsceneActionCurveVertexValue"                  },

	{   5380, "CutsceneActionCurveTransType"                    },
	{   5381, "CutsceneActionCurveTransControl1"                },
	{   5382, "CutsceneActionCurveTransControl2"                },

	{   5400, "CutsceneActionAnimAnimationName"                 },
	{   5401, "CutsceneActionAnimBlendtreeName"                 },
	{   5402, "CutsceneActionAnimSpeed"                         },
	{   5403, "CutsceneActionAnimStartOffset"                   },
	{   5404, "CutsceneActionAnimDeprecated1"                   },
	{   5405, "CutsceneActionAnimPlayGad"                       },
	{   5406, "CutsceneActionAnimPoseAnimation"                 },
	{   5407, "CutsceneActionAnimLinkToMovement"                },
	{   5408, "CutsceneActionAnimGadKeysPos"                    },
	{   5409, "CutsceneActionAnimGadKeysOri"                    },
	{   5410, "CutsceneActionAnimBlendGad"                      },
	{   5411, "CutsceneActionAnimExtendGad"                     },
	{   5412, "CutsceneActionAnimLinkToMoveDist"                },
	{   5413, "CutsceneActionAnimApplyFutureGads"               },

	{   5520, "CutsceneActionFrameBufEffectFileName"            },
	{   5521, "CutsceneActionFrameBufEffectEffectName"          },
	{   5522, "CutsceneActionFrameBufEffectParamList"           },
	{   5523, "CutsceneActionFrameBufEffectParamName"           },
	{   5524, "CutsceneActionFrameBufEffectParamValue"          },
	{   5525, "CutsceneActionFrameBufEffectParamCurveIndex"     },
	{   5526, "CutsceneActionFrameBufEffectParamVectorIndex"    },

	{   5562, "CutsceneActionSpeakLineLipsynchSet"              },
	{   5563, "CutsceneActionSpeakLineVobank"                   },
	{   5564, "CutsceneActionSpeakLineFaHeadMove"               },
	{   5565, "CutsceneActionSpeakLineNoVOIngame"               },

	{   5570, "CutsceneActionStageCameraDefault"                },
	{   5571, "CutsceneActionStageCameraHenchman"               },

	{   5580, "CutsceneActionStagePlaceLookAt"                  },

	{   5600, "CutsceneActionShakeType"                         },
	{   5601, "CutsceneActionShakeDeprecated1"                  },
	{   5602, "CutsceneActionShakeDeprecated2"                  },
	{   5603, "CutsceneActionShakeNoiseSeed"                    },
	{   5604, "CutsceneActionShakeNoiseFrequency"               },
	{   5605, "CutsceneActionShakeNoiseType"                    },
	{   5606, "CutsceneActionShakeNoiseCorrelated"              },
	{   5607, "CutsceneActionShakeNoiseRoughness"               },
	{   5608, "CutsceneActionShakeNoiseRampIn"                  },
	{   5609, "CutsceneActionShakeNoiseRampOut"                 },

	{   5610, "CutsceneActionActiveCameraActorID"               },

	{   5620, "CutsceneActionHeadtrackTargetID"                 },
	{   5621, "CutsceneActionHeadtrackSpeed"                    },
	{   5624, "CutsceneActionHeadtrackDeprecated1"              },
	{   5625, "CutsceneActionHeadtrackDeprecated2"              },
	{   5626, "CutsceneActionHeadtrackDeprecated3"              },
	{   5627, "CutsceneActionHeadtrackDeprecated4"              },
	{   5628, "CutsceneActionHeadtrackRealignStart"             },
	{   5629, "CutsceneActionHeadtrackRealignCont"              },

	{   5630, "CutsceneActionLinkActorTargetID"                 },
	{   5631, "CutsceneActionLinkActorNodeID"                   },
	{   5632, "CutsceneActionLinkActorDeprecated1"              },
	{   5633, "CutsceneActionLinkActorDeprecated2"              },
	{   5634, "CutsceneActionLinkActorDeprecated3"              },
	{   5635, "CutsceneActionLinkActorDeprecated4"              },
	{   5636, "CutsceneActionLinkActorIsTargetCrust"            },
	{   5637, "CutsceneActionLinkActorUseOffset"                },

	{   5640, "CutsceneActionApplycrustTargetID"                },

	{   5650, "CutsceneActionPoseAnimationPose"                 },
	{   5651, "CutsceneActionPoseAnimationAnimation"            },
	{   5652, "CutsceneActionPoseAnimationLooping"              },
	{   5653, "CutsceneActionPoseAnimationOutro"                },
	{   5654, "CutsceneActionPoseAnimationOutroSpeed"           },

	{   5670, "CutsceneActionSoundName"                         },
	{   5671, "CutsceneActionSoundSplineParamNo1"               },
	{   5672, "CutsceneActionSoundSplineParamNo2"               },
	{   5673, "CutsceneActionSoundSplineParamNo3"               },
	{   5674, "CutsceneActionSoundSplineParamNo4"               },
	{   5675, "CutsceneActionSoundSplineParamNo5"               },

	{   5680, "CutsceneActionChangeVisibilityVisible"           },

	{   5700, "CutsceneActionToggleClothPhysics"                },
	{   5701, "CutsceneActionToggleHairPhysics"                 },

	{   5720, "CutsceneActionSetLodDeprecated"                  },

	{   5730, "CutsceneActionDrawWeaponMain"                    },
	{   5731, "CutsceneActionDrawWeaponOff"                     },

	{   5740, "CutsceneActionPlayMovie"                         },

	{   5750, "CutsceneActionSetGore"                           },

	{   6000, "MMHName"                                         },
	{   6001, "MMHMaterialObject"                               },
	{   6002, "MMHMaterialLibrary"                              },
	{   6003, "MMHResName"                                      },
	{   6004, "MMHID"                                           },
	{   6005, "MMHModelHierarchyModelDataName"                  },
	{   6006, "MMHMeshGroupName"                                },
	{   6007, "MMHNodePointLightColor"                          },
	{   6008, "MMHNodePointLightRadius"                         },
	{   6009, "MMHNodePointLightIsStatic"                       },
	{   6010, "MMHNodeAmbientLightColor"                        },
	{   6011, "MMHNodeEmitBirthRate"                            },
	{   6012, "MMHNodeEmitBirthRateRange"                       },
	{   6013, "MMHNodeEmitLife"                                 },
	{   6014, "MMHNodeEmitLifeRange"                            },
	{   6015, "MMHNodeEmitScaleRange"                           },
	{   6016, "MMHNodeEmitInitialSpeed"                         },
	{   6017, "MMHNodeEmitInitialSpeedRange"                    },
	{   6018, "MMHNodeEmitAcceleration"                         },
	{   6019, "MMHNodeEmitInitialRotationSpeed"                 },
	{   6020, "MMHNodeEmitInitialRotationSpeedRange"            },
	{   6021, "MMHNodeEmitRotationalAcceleration"               },
	{   6022, "MMHNodeInvEmitterMovementSpreadUpdateDelay"      },
	{   6023, "MMHNodeEmitSpawnSpreadX"                         },
	{   6024, "MMHNodeEmitSpawnSpreadY"                         },
	{   6025, "MMHNodeEmitMovementSpreadX"                      },
	{   6026, "MMHNodeEmitMovementSpreadY"                      },
	{   6027, "MMHNodeEmitOptionsBitflags"                      },
	{   6028, "MMHNodeEmitOptionsBirthrateInParticlesPerMeter"  },
	{   6029, "MMHNodeEmitOptionsRandomInitialRotation"         },
	{   6030, "MMHNodeEmitOptionsParticlesAffectedByWind"       },
	{   6031, "MMHNodeEmitGravityMultiplier"                    },
	{   6032, "MMHNodeEmitOptionsParticlesFollowPath"           },
	{   6033, "MMHNodeEmitOptionsLinkParticlesTogether"         },
	{   6034, "MMHNodeEmitOptionsUpdateOnlyWhenVisible"         },
	{   6035, "MMHNodeEmitOptionsEnableParticleCollisions"      },
	{   6036, "MMHNodeEmitOptionsInheritVelocityInsteadOfPos"   },
	{   6037, "MMHNodeEmitOrientationBehavior"                  },
	{   6038, "MMHNodeEmitParticleInheritance"                  },
	{   6039, "MMHNodeAgeMapCount"                              },
	{   6040, "MMHNodeAgeMapElementPercentLifeElapsed"          },
	{   6041, "MMHNodeAgeMapElementScaleX"                      },
	{   6042, "MMHNodeAgeMapElementScaleY"                      },
	{   6043, "MMHNodeAgeMapElementColor"                       },
	{   6044, "MMHNodeSpawnVolumeOptionsBitflags"               },
	{   6045, "MMHNodeSpawnVolumeOptionsSpawnWithinVolume"      },
	{   6046, "MMHNodeSpawnVolumeOptionsInvertSpawnVolumeNorms" },
	{   6047, "MMHTranslation"                                  },
	{   6048, "MMHRotation"                                     },
	{   6049, "MMHAttributeName"                                },
	{   6050, "MMHAttributeSourceName"                          },
	{   6051, "MMHExportTagName"                                },
	{   6052, "MMHExportExportName"                             },
	{   6053, "MMHExportControllerType"                         },
	{   6054, "MMHBoundingBoxMin"                               },
	{   6055, "MMHBoundingBoxMax"                               },
	{   6056, "MMHNodeCollisionObjDensity"                      },
	{   6057, "MMHNodeCollisionObjType"                         },
	{   6058, "MMHShapeType"                                    },
	{   6059, "MMHShapePmatName"                                },
	{   6060, "MMHShapeRotation"                                },
	{   6061, "MMHShapePosition"                                },
	{   6062, "MMHShapeCollisionMaskBitflags"                   },
	{   6063, "MMHShapeCollisionMaskAll"                        },
	{   6064, "MMHShapeCollisionMaskNone"                       },
	{   6065, "MMHShapeCollisionMaskItems"                      },
	{   6066, "MMHShapeCollisionMaskCreatures"                  },
	{   6067, "MMHShapeCollisionMaskPlaceables"                 },
	{   6068, "MMHShapeCollisionMaskTriggers"                   },
	{   6069, "MMHShapeCollisionMaskStaticGeometry"             },
	{   6070, "MMHShapeCollisionMaskNonwalkable"                },
	{   6071, "MMHShapeBoxDim"                                  },
	{   6072, "MMHShapeRadius"                                  },
	{   6073, "MMHShapeHeight"                                  },
	{   6074, "MMHShapeMeshShapeFlags"                          },
	{   6075, "MMHShapeMeshHeightFieldAxis"                     },
	{   6076, "MMHShapeMeshHeightFieldExtent"                   },
	{   6077, "MMHShapeCookedDataStream"                        },
	{   6078, "MMHJointTarget"                                  },
	{   6079, "MMHJointType"                                    },
	{   6080, "MMHJointTypeStruct"                              },
	{   6081, "MMHJointLocalNormal1"                            },
	{   6082, "MMHJointLocalNormal2"                            },
	{   6083, "MMHJointLocalAnchor1"                            },
	{   6084, "MMHJointLocalAnchor2"                            },
	{   6085, "MMHJointLocalAxis1"                              },
	{   6086, "MMHJointLocalAxis2"                              },
	{   6087, "MMHJointMaxForce"                                },
	{   6088, "MMHJointMaxTorque"                               },
	{   6089, "MMHJointCollisionEnabled"                        },
	{   6090, "MMHJointSphericalSwingAxis"                      },
	{   6091, "MMHJointSphericalProjectionDistance"             },
	{   6092, "MMHJointSphericalTwistLimitLow"                  },
	{   6093, "MMHJointSphericalTwistLimitHigh"                 },
	{   6094, "MMHJointSphericalSwingLimit"                     },
	{   6095, "MMHJointSphericalTwistSwing"                     },
	{   6096, "MMHJointSphericalSwingSpring"                    },
	{   6097, "MMHJointSphericalJointSpring"                    },
	{   6098, "MMHJointSphericalProjectionMode"                 },
	{   6099, "MMHJointSphericalSphereFlags"                    },
	{   6100, "MMHJointRevoluteLimitLow"                        },
	{   6101, "MMHJointRevoluteLimitHigh"                       },
	{   6102, "MMHJointRevoluteProjectionDistance"              },
	{   6103, "MMHJointRevoluteProjectionAngle"                 },
	{   6104, "MMHJointRevoluteProjectionMode"                  },
	{   6105, "MMHJointRevoluteSpring"                          },
	{   6106, "MMHJointRevoluteMotorVelTarget"                  },
	{   6107, "MMHJointRevoluteMotorMaxForce"                   },
	{   6108, "MMHJointRevoluteMotorFreeSpin"                   },
	{   6109, "MMHJointRevoluteRevoluteFlags"                   },
	{   6110, "MMHJointDistanceMinDistance"                     },
	{   6111, "MMHJointDistanceMaxDistance"                     },
	{   6112, "MMHJointDistanceSpring"                          },
	{   6113, "MMHJointDistanceDistanceFlags"                   },
	{   6114, "MMHJointPulleyPulley1"                           },
	{   6115, "MMHJointPulleyPulley2"                           },
	{   6116, "MMHJointPulleyDistance"                          },
	{   6117, "MMHJointPulleyStiffness"                         },
	{   6118, "MMHJointPulleyRatio"                             },
	{   6119, "MMHJointPulleyMotorVelTarget"                    },
	{   6120, "MMHJointPulleyMotorMaxForce"                     },
	{   6121, "MMHJointPulleyMotorFreeSpin"                     },
	{   6122, "MMHJointPulleyPulleyFlags"                       },
	{   6123, "MMHJoint6dofXMotion"                             },
	{   6124, "MMHJoint6dofYMotion"                             },
	{   6125, "MMHJoint6dofZMotion"                             },
	{   6126, "MMHJoint6dofSwing1Motion"                        },
	{   6127, "MMHJoint6dofSwing2Motion"                        },
	{   6128, "MMHJoint6dofTwistMotion"                         },
	{   6129, "MMHJoint6dofLinearLimit"                         },
	{   6130, "MMHJoint6dofSwing1Limit"                         },
	{   6131, "MMHJoint6dofSwing2Limit"                         },
	{   6132, "MMHJoint6dofTwistLimitLow"                       },
	{   6133, "MMHJoint6dofTwistLimitHigh"                      },
	{   6134, "MMHJoint6dofDriveOrientation"                    },
	{   6135, "MMHJoint6dofDriveXDriveType"                     },
	{   6136, "MMHJoint6dofDriveXDriveSpring"                   },
	{   6137, "MMHJoint6dofDriveXDriveDamping"                  },
	{   6138, "MMHJoint6dofDriveXDriveForceLimit"               },
	{   6139, "MMHJoint6dofDriveYDriveType"                     },
	{   6140, "MMHJoint6dofDriveYDriveSpring"                   },
	{   6141, "MMHJoint6dofDriveYDriveDamping"                  },
	{   6142, "MMHJoint6dofDriveYDriveForceLimit"               },
	{   6143, "MMHJoint6dofDriveZDriveType"                     },
	{   6144, "MMHJoint6dofDriveZDriveSpring"                   },
	{   6145, "MMHJoint6dofDriveZDriveDamping"                  },
	{   6146, "MMHJoint6dofDriveZDriveForceLimit"               },
	{   6147, "MMHJoint6dofDriveSwingDriveType"                 },
	{   6148, "MMHJoint6dofDriveSwingDriveSpring"               },
	{   6149, "MMHJoint6dofDriveSwingDriveDamping"              },
	{   6150, "MMHJoint6dofDriveSwingDriveForceLimit"           },
	{   6151, "MMHJoint6dofDriveTwistDriveType"                 },
	{   6152, "MMHJoint6dofDriveTwistDriveSpring"               },
	{   6153, "MMHJoint6dofDriveTwistDriveDamping"              },
	{   6154, "MMHJoint6dofDriveTwistDriveForceLimit"           },
	{   6155, "MMHJoint6dofDriveSlerpDriveType"                 },
	{   6156, "MMHJoint6dofDriveSlerpDriveSpring"               },
	{   6157, "MMHJoint6dofDriveSlerpDriveDamping"              },
	{   6158, "MMHJoint6dofDriveSlerpDriveForceLimit"           },
	{   6159, "MMHJoint6dofDrivePosition"                       },
	{   6160, "MMHJoint6dofDriveLinearVelocity"                 },
	{   6161, "MMHJoint6dofDriveAngularVelocity"                },
	{   6162, "MMHJoint6dofProjectionDistance"                  },
	{   6163, "MMHJoint6dofProjectionAngle"                     },
	{   6164, "MMHJoint6dofGearRatio"                           },
	{   6165, "MMHJoint6dofProjectionMode"                      },
	{   6166, "MMHJoint6dofD6Flags"                             },
	{   6167, "MMHDataSemantic"                                 },
	{   6168, "MMHDataIsIndexStream"                            },
	{   6169, "MMHDataType"                                     },
	{   6170, "MMHDataBitflags"                                 },
	{   6171, "MMHDataLooping"                                  },
	{   6172, "MMHDataInstanced"                                },
	{   6173, "MMHDataCount"                                    },
	{   6174, "MMHDataPrimitiveType"                            },
	{   6175, "MMHDataFrequency"                                },
	{   6176, "MMHMeshCastRuntimeShadow"                        },
	{   6177, "MMHMeshCastBakedShadow"                          },
	{   6178, "MMHShapeCollisionMaskEffects"                    },
	{   6179, "MMHShapeCollisionMaskWaypoints"                  },
	{   6180, "MMHFlipbookFramesPerSecond"                      },
	{   6181, "MMHFlipbookRows"                                 },
	{   6182, "MMHFlipbookColumns"                              },
	{   6183, "MMHFlipbookRandomStartFrame"                     },
	{   6184, "MMHEmitterTargetName"                            },
	{   6185, "MMHEmitterTargetAttraction"                      },
	{   6186, "MMHEmitterTargetRadius"                          },
	{   6187, "MMHEmitterSpawnDirectionTracksTarget"            },
	{   6188, "MMHEmitterKillParticleWhenTargetHit"             },
	{   6189, "MMHEmitterFlipbookType"                          },
	{   6190, "MMHLightprobeIrradianceCoefficientsRed"          },
	{   6191, "MMHLightprobeIrradianceCoefficientsGreen"        },
	{   6192, "MMHLightprobeIrradianceCoefficientsBlue"         },
	{   6193, "MMHMeshCutAway"                                  },
	{   6194, "MMHMeshPunchThrough"                             },
	{   6195, "MMHClothThickness"                               },
	{   6196, "MMHClothDensity"                                 },
	{   6197, "MMHClothBendingStiffness"                        },
	{   6198, "MMHClothStretchingStiffness"                     },
	{   6199, "MMHClothDampingCoefficient"                      },
	{   6200, "MMHClothFriction"                                },
	{   6201, "MMHClothPressure"                                },
	{   6202, "MMHClothTearFactor"                              },
	{   6203, "MMHClothCollisionResponseCoefficient"            },
	{   6204, "MMHClothAttachmentResponseCoefficient"           },
	{   6205, "MMHClothAttachmentTearFactor"                    },
	{   6206, "MMHClothSolverIterations"                        },
	{   6207, "MMHClothExternalAcceleration"                    },
	{   6208, "MMHClothWakeUpCounter"                           },
	{   6209, "MMHClothSleepLinearVelocity"                     },
	{   6210, "MMHClothFlagBitflags"                            },
	{   6211, "MMHClothFlagPressure"                            },
	{   6212, "MMHClothFlagStatic"                              },
	{   6213, "MMHClothFlagDisableCollision"                    },
	{   6214, "MMHClothFlagSelfcollision"                       },
	{   6215, "MMHClothFlagVisualization"                       },
	{   6216, "MMHClothFlagGravity"                             },
	{   6217, "MMHClothFlagBending"                             },
	{   6218, "MMHClothFlagBendingOrtho"                        },
	{   6219, "MMHClothFlagDamping"                             },
	{   6220, "MMHClothFlagCollisionTwoway"                     },
	{   6221, "MMHClothFlagTriangleCollision"                   },
	{   6222, "MMHClothFlagTearable"                            },
	{   6223, "MMHClothFlagHardware"                            },
	{   6224, "MMHClothFlagComdamping"                          },
	{   6225, "MMHClothAttachmentType"                          },
	{   6226, "MMHClothAttachmentFlagBitflags"                  },
	{   6227, "MMHClothAttachmentFlagTwoWayAttachment"          },
	{   6228, "MMHClothAttachmentFlagTearableAttachment"        },
	{   6229, "MMHClothAttachmentShapeName"                     },
	{   6230, "MMHClothAttachmentVertexID"                      },
	{   6231, "MMHClothAttachmentLocalPos"                      },
	{   6232, "MMHClothCookedDataStream"                        },
	{   6233, "MMHClothMeshGroupStruct"                         },
	{   6234, "MMHNodeEmitType"                                 },
	{   6235, "MMHNodeCrustHookID"                              },
	{   6236, "MMHCollisionObjectVolume"                        },
	{   6237, "MMHObjectVolume"                                 },
	{   6238, "MMHExportTagVariableType"                        },
	{   6239, "MMHEmitterIsPhysicsEmitter"                      },
	{   6240, "MMHShapeVolume"                                  },
	{   6241, "MMHShapeName"                                    },
	{   6242, "MMHSnapPosition"                                 },
	{   6243, "MMHEmitterIsPhysicsObjectSpawnEmitter"           },
	{   6244, "MMHShapeAllowEmitterSpawn"                       },
	{   6245, "MMHCollisionGroup"                               },
	{   6246, "MMHEmitterEmitterAttachmentType"                 },
	{   6247, "MMHEmitterEmitterAttachmentName"                 },
	{   6248, "MMHFacialAnimationBlueprintName"                 },

	{   6249, "MMHNodePointLightIntensityVariation"             },
	{   6250, "MMHNodePointLightIntensityPeriod"                },
	{   6251, "MMHNodePointLightIntensityPeriodDelta"           },
	{   6252, "MMHShapeFadeable"                                },

	{   6253, "MMHLightprobeIrradianceRes"                      },

	{   6254, "MMHBoneIndex"                                    },
	{   6255, "MMHMeshBonesUsed"                                },
	{   6256, "MMHTotalBones"                                   },

	{   6257, "MMHClothWindEnabled"                             },
	{   6258, "MMHClothWindSpace"                               },
	{   6259, "MMHClothWindDirection"                           },
	{   6260, "MMHClothWindResponse"                            },
	{   6261, "MMHClothWindResponseLimit"                       },
	{   6262, "MMHClothWindStrength"                            },
	{   6263, "MMHClothWindGustMinStrength"                     },
	{   6264, "MMHClothWindGustMaxStrength"                     },
	{   6265, "MMHClothWindGustMinDuration"                     },
	{   6266, "MMHClothWindGustMaxDuration"                     },
	{   6267, "MMHClothWindGustMinInterval"                     },
	{   6268, "MMHClothWindGustMaxInterval"                     },
	{   6269, "MMHClothWindGustDirChange"                       },
	{   6270, "MMHClothWindGustAxisRatio"                       },
	{   6271, "MMHClothWindSpeedtreeUpdateTime"                 },
	{   6272, "MMHClothWindSpeedtreeStrength"                   },
	{   6273, "MMHClothWindSpeedtreeDirection"                  },

	{   6274, "MMHExportControllerIndex"                        },
	{   6275, "MMHTotalExports"                                 },

	{   6276, "MMHClothWindSpeedtreeParams"                     },

	{   6277, "MMHShapeCollisionMaskWater"                      },

	{   6278, "MMHScale"                                        },

	{   6279, "MMHNodeEmitAgemapColorMultiplier"                },
	{   6280, "MMHNodeEmitAgemapScalexMultiplier"               },
	{   6281, "MMHNodeEmitAgemapScaleyMultiplier"               },

	{   6282, "MMHNodeEmitOptionsBounciness"                    },
	{   6283, "MMHNodeEmitOptionsFriction"                      },
	{   6284, "MMHNodeEmitMeshParticleModelName"                },
	{   6285, "MMHNodeSpawnVolumeType"                          },
	{   6286, "MMHNodeSpawnVolumeRadius"                        },
	{   6287, "MMHNodeSpawnVolumeCylinderLength"                },
	{   6288, "MMHNodeSpawnVolumeCylinderAxis"                  },
	{   6289, "MMHNodeSpawnVolumeBoxMin"                        },
	{   6290, "MMHNodeSpawnVolumeBoxMax"                        },
	{   6291, "MMHNodeSpawnVolumeOptionsNormalsAsDirection"     },

	{   6292, "MMHWeapontrailSegmentLength"                     },
	{   6293, "MMHWeapontrailDuration"                          },

	{   6294, "MMHNodeEmitWorldAxisAcceleration"                },

	{   6295, "MMHShapeCollisionMaskTerrainWall"                },

	{   6296, "MMHNodeLightAffectDomain"                        },
	{   6297, "MmnNodeEmitVertexFormat"                         },

	{   6298, "MMHNodeEmitOptionsObjectSpaceAcceleration"       },
	{   6299, "MMHNodeEmitInitialRotation"                      },
	{   6300, "MMHNodeEmitInitialRotationRange"                 },

	{   6301, "MMHMeshReceiveBakedShadow"                       },

	{   6302, "MMHNodeEmitMeshParticleUpAxis"                   },
	{   6303, "MMHNodeEmitMeshParticleRollAxis"                 },

	{   6304, "MMHMeshReceiveRuntimeShadow"                     },
	{   6305, "MMHShapeCollisionMaskWalkable"                   },

	{   6306, "MMHModelMeshNameList"                            },
	{   6307, "MMHNodeMeshName"                                 },
	{   6308, "MMHNodeEmitUvDistributionSize"                   },
	{   6309, "MMHNodeEmitIgnoreDistortion"                     },

	{   6310, "MMHNodeEmitSplatParamsWidth"                     },
	{   6311, "MMHNodeEmitSplatParamsHeight"                    },
	{   6312, "MMHNodeEmitSplatParamsNumsamplesWidth"           },
	{   6313, "MMHNodeEmitSplatParamsNumsamplesHeight"          },
	{   6314, "MMHNodeEmitSplatParamsOrientationRange"          },
	{   6315, "MMHNodeEmitSplatParamsLife"                      },
	{   6316, "MMHNodeEmitSplatParamsFlipbookType"              },
	{   6317, "MMHNodeEmitSplatParamsFlipbookFramesPerSecond"   },
	{   6318, "MMHNodeEmitSplatParamsFlipbookRows"              },
	{   6319, "MMHNodeEmitSplatParamsFlipbookColumns"           },
	{   6320, "MMHNodeEmitSplatParamsFlipbookRandomStartFrame"  },
	{   6321, "MMHNodeEmitCanParticlesSplat"                    },
	{   6322, "MMHNodeEmitSplatParamsAgeMapElemPercLifeElapsed" },
	{   6323, "MMHNodeEmitLod"                                  },
	{   6324, "MMHNodeEmitSplatParamsMaterialName"              },

	{   6325, "MMHNodeEmitUserParamName"                        },

	{   6327, "MMHRemoteMaterialDecalName"                      },
	{   6328, "MMHRemoteMaterialFresnelFalloff"                 },
	{   6329, "MMHRemoteMaterialInvertFresnel"                  },

	{   6330, "MMHNodeSoundMaterial"                            },

	{   6331, "MMHRemoteMaterialAlpha"                          },
	{   6332, "MMHRemoteMaterialTint"                           },
	{   6333, "MMHEmitterPresimulateTime"                       },

	{   6334, "MMHMeshIsVFXMesh"                                },
	{   6335, "MMHMeshMaterialColor"                            },

	{   6336, "MMHLightProbeIrradianceRed"                      },
	{   6337, "MMHLightProbeIrradianceGreen"                    },
	{   6338, "MMHLightProbeIrradianceBlue"                     },

	{   6339, "MMHLightCanBeOccluded"                           },

	{   6340, "MMHUseVariationTint"                             },
	{   6341, "MMHNodeEmitSplatparamsHoldLastFrame"             },
	{   6342, "MMHEmitterEmitterAttachmentSpawnOnSurface"       },
	{   6343, "MMHEmitterEmitterAttachmentUseNormalForVelocity" },
	{   6344, "MMHNodeEmitSplatparamsAgemapColorMultiplier"     },

	{   6345, "MMHNodeLightVersion"                             },

	{   6346, "MMHMeshDefaultHidden"                            },

	{   6998, "MMHShapeTypeStruct"                              },
	{   6999, "MMHChildren"                                     },

	{   7000, "TerrainVersion"                                  },
	{   7001, "TerrainBaseRows"                                 },
	{   7002, "TerrainBaseColumns"                              },
	{   7003, "TerrainLengthUnits"                              },
	{   7004, "TerrainWidthUnits"                               },
	{   7005, "TerrainSectorRows"                               },
	{   7006, "TerrainSectorColumns"                            },
	{   7007, "TerrainTessellation"                             },
	{   7008, "TerrainSectorID"                                 },
	{   7009, "TerrainSectorList"                               },
	{   7010, "TerrainMeshFaceID"                               },
	{   7011, "TerrainMeshFaceList"                             },
	{   7012, "TerrainMeshEdgeID"                               },
	{   7013, "TerrainMeshEdgeStartVertex"                      },
	{   7014, "TerrainMeshEdgeBoundaryFlag"                     },
	{   7015, "TerrainMeshEdgeSubedgeList"                      },
	{   7016, "TerrainMeshEdgeList"                             },
	{   7017, "TerrainSubEdgeID"                                },
	{   7018, "TerrainMeshVertexID"                             },
	{   7019, "TerrainMeshVertexPosition"                       },
	{   7020, "TerrainMeshVertexLevel"                          },
	{   7021, "TerrainMeshVertexConstraintList"                 },
	{   7022, "TerrainMeshVertexConstraintID"                   },
	{   7023, "TerrainMeshVertexList"                           },
	{   7024, "TerrainElementIDValue"                           },
	{   7025, "TerrainElementIDSector"                          },
	{   7026, "TerrainMaterialValue"                            },
	{   7027, "TerrainMaterialList"                             },
	{   7028, "TerrainAreaInformation"                          },
	{   7029, "TerrainVertexU"                                  },
	{   7030, "TerrainVertexV"                                  },
	{   7031, "TerrainMaskDataWidth"                            },
	{   7032, "TerrainMaskDataHeight"                           },
	{   7033, "TerrainMaskDataStride"                           },
	{   7034, "TerrainMaskDataArray"                            },
	{   7035, "TerrainVMaskData"                                },
	{   7036, "TerrainAMaskData"                                },
	{   7037, "TerrainMapVertexID"                              },
	{   7038, "TerrainMapVertexUVW"                             },
	{   7039, "TerrainMapVertexList"                            },
	{   7040, "TerrainMapEdgeID"                                },
	{   7041, "TerrainMapEdgeStartVertex"                       },
	{   7042, "TerrainMapEdgeList"                              },
	{   7043, "TerrainMapFaceID"                                },
	{   7044, "TerrainMapFaceLayer"                             },
	{   7045, "TerrainMapFaceList"                              },
	{   7046, "TerrainMapFaceBlendPageID"                       },
	{   7047, "TerrainBlendWeightMatID"                         },
	{   7048, "TerrainBlendWeightWeight"                        },
	{   7049, "TerrainBlendTexelWeightList"                     },
	{   7050, "TerrainBlendPageID"                              },
	{   7051, "TerrainBlendPageWidth"                           },
	{   7052, "TerrainBlendPageHeight"                          },
	{   7053, "TerrainBlendPageTexelList"                       },
	{   7054, "TerrainBlendPageList"                            },
	{   7055, "TerrainMesh"                                     },
	{   7056, "TerrainPalette"                                  },
	{   7057, "TerrainBlendTexelByteWeightList"                 },
	{   7058, "TerrainMeshName"                                 },
	{   7059, "TerrainPaletteName"                              },
	{   7060, "TerrainMaterial"                                 },
	{   7061, "TerrainMaterialID"                               },
	{   7062, "TerrainMaterialName"                             },
	{   7063, "TerrainMaterialScale"                            },
	{   7064, "TerrainMaterialDiffuseName"                      },
	{   7065, "TerrainMaterialNormalName"                       },
	{   7066, "TerrainMaterialSpecualarName"                    },
	{   7067, "TerrainMaterialHeightMapName"                    },
	{   7068, "TerrainPaletteParallaxGlobal"                    },
	{   7069, "TerrainMaterialReliefScale"                      },
	{   7070, "TerrainBlendTexel6ByteWeightList"                },
	{   7071, "TerrainMeshVertexConstraintA"                    },
	{   7072, "TerrainMeshVertexConstraintB"                    },
	{   7073, "TerrainMeshEdgeSubEdgeA"                         },
	{   7074, "TerrainMeshEdgeSubEdgeB"                         },
	{   7075, "TerrainBlendTexelID"                             },
	{   7076, "TerrainSoundData"                                },
	{   7077, "TerrainMaterialSpecularColor"                    },

	{   7900, "WaterInformation"                                },
	{   7901, "WaterVersion"                                    },
	{   7902, "WaterID"                                         },
	{   7903, "WaterVertexList"                                 },
	{   7904, "WaterVertexPosition"                             },
	{   7905, "WaterVertexNormal"                               },
	{   7906, "WaterVertexUVW"                                  },
	{   7907, "WaterVertexColor"                                },
	{   7908, "WaterVertexIndexList"                            },

	{   8000, "MeshChunkVertexSize"                             },
	{   8001, "MeshChunkVertexCount"                            },
	{   8002, "MeshChunkIndexCount"                             },
	{   8003, "MeshChunkPrimitiveType"                          },
	{   8004, "MeshChunkIndexFormat"                            },
	{   8005, "MeshChunkBaseVertexIndex"                        },
	{   8006, "MeshChunkVertexOffset"                           },
	{   8007, "MeshChunkMinIndex"                               },
	{   8008, "MeshChunkVerticesReferenced"                     },
	{   8009, "MeshChunkStartIndex"                             },
	{   8010, "MeshChunkHasInstGeom"                            },
	{   8011, "MeshChunkAdditionalStreams"                      },
	{   8012, "MeshStreamVertexSize"                            },
	{   8013, "MeshStreamVertexCount"                           },
	{   8014, "MeshStreamFrequency"                             },
	{   8015, "MeshStreamLooping"                               },
	{   8016, "MeshStreamInstanced"                             },
	{   8017, "MeshBoundsBoxMin"                                },
	{   8018, "MeshBoundsBoxMax"                                },
	{   8019, "MeshBoundsSphere"                                },
	{   8020, "MeshChunkBounds"                                 },
	{   8021, "MeshChunks"                                      },
	{   8022, "MeshVertexData"                                  },
	{   8023, "MeshIndexData"                                   },
	{   8024, "MeshStreamVertexData"                            },
	{   8025, "MeshChunkVertexDeclarator"                       },
	{   8026, "MeshVertexDeclaratorStream"                      },
	{   8027, "MeshVertexDeclaratorOffset"                      },
	{   8028, "MeshVertexDeclaratorDatatype"                    },
	{   8029, "MeshVertexDeclaratorUsage"                       },
	{   8030, "MeshVertexDeclaratorUsageIndex"                  },
	{   8031, "MeshVertexDeclaratorMethod"                      },
	{   8032, "MeshIndexFormat"                                 },
	{   8033, "MeshInstancedStream"                             },
	{   8034, "MeshChunkInstancesCount"                         },

	{   9000, "AcNodeName"                                      },
	{   9001, "AcEdgeStartID"                                   },
	{   9002, "AcEdgeEndID"                                     },
	{   9003, "AcCaption"                                       },
	{   9004, "AcNodeSocketList"                                },
	{   9005, "AcSocketIsOutput"                                },
	{   9006, "AcNodeImage"                                     },
	{   9007, "AcEdgeList"                                      },
	{   9008, "AcNodeList"                                      },
	{   9009, "AcNodeColor"                                     },
	{   9010, "AcNodeAnimation"                                 },
	{   9011, "AcCurveControlPointList"                         },
	{   9012, "AcCurveControlPointTime"                         },
	{   9013, "AcCurveControlPointValue"                        },
	{   9014, "AcModelName"                                     },
	{   9015, "AcEventList"                                     },
	{   9016, "AcEventTime"                                     },
	{   9017, "AcEventID"                                       },
	{   9018, "AcNodeLooping"                                   },
	{   9019, "AcFlags"                                         },
	{   9020, "AcTransAnimName"                                 },
	{   9021, "AcTransAnimStart"                                },
	{   9022, "AcTransAnimLength"                               },
	{   9023, "AcTransTrackList"                                },
	{   9024, "AcTransitionList"                                },
	{   9025, "AcTransLength"                                   },

	{   9100, "AcBlendGroupAnimList"                            },
	{   9101, "AcBlendGroupList"                                },
	{   9102, "AcBlendGroupName"                                },

	{  10000, "G2DAColumnName"                                  },
	{  10001, "G2DAColumnHash"                                  },
	{  10002, "G2DAColumnList"                                  },
	{  10003, "G2DARowList"                                     },
	{  10004, "G2DARowData"                                     },

	{  10005, "G2DAColumn1"                                     },
	{  10006, "G2DAColumn2"                                     },
	{  10007, "G2DAColumn3"                                     },
	{  10008, "G2DAColumn4"                                     },
	{  10009, "G2DAColumn5"                                     },
	{  10010, "G2DAColumn6"                                     },
	{  10011, "G2DAColumn7"                                     },
	{  10012, "G2DAColumn8"                                     },
	{  10013, "G2DAColumn9"                                     },
	{  10014, "G2DAColumn10"                                    },
	{  10015, "G2DAColumn11"                                    },
	{  10016, "G2DAColumn12"                                    },
	{  10017, "G2DAColumn13"                                    },
	{  10018, "G2DAColumn14"                                    },
	{  10019, "G2DAColumn15"                                    },
	{  10020, "G2DAColumn16"                                    },
	{  10021, "G2DAColumn17"                                    },
	{  10022, "G2DAColumn18"                                    },
	{  10023, "G2DAColumn19"                                    },
	{  10024, "G2DAColumn20"                                    },
	{  10025, "G2DAColumn21"                                    },
	{  10026, "G2DAColumn22"                                    },
	{  10027, "G2DAColumn23"                                    },
	{  10028, "G2DAColumn24"                                    },
	{  10029, "G2DAColumn25"                                    },
	{  10030, "G2DAColumn26"                                    },
	{  10031, "G2DAColumn27"                                    },
	{  10032, "G2DAColumn28"                                    },
	{  10033, "G2DAColumn29"                                    },
	{  10034, "G2DAColumn30"                                    },
	{  10035, "G2DAColumn31"                                    },
	{  10036, "G2DAColumn32"                                    },
	{  10037, "G2DAColumn33"                                    },
	{  10038, "G2DAColumn34"                                    },
	{  10039, "G2DAColumn35"                                    },
	{  10040, "G2DAColumn36"                                    },
	{  10041, "G2DAColumn37"                                    },
	{  10042, "G2DAColumn38"                                    },
	{  10043, "G2DAColumn39"                                    },
	{  10044, "G2DAColumn40"                                    },
	{  10045, "G2DAColumn41"                                    },
	{  10046, "G2DAColumn42"                                    },
	{  10047, "G2DAColumn43"                                    },
	{  10048, "G2DAColumn44"                                    },
	{  10049, "G2DAColumn45"                                    },
	{  10050, "G2DAColumn46"                                    },
	{  10051, "G2DAColumn47"                                    },
	{  10052, "G2DAColumn48"                                    },
	{  10053, "G2DAColumn49"                                    },
	{  10054, "G2DAColumn50"                                    },
	{  10055, "G2DAColumn51"                                    },
	{  10056, "G2DAColumn52"                                    },
	{  10057, "G2DAColumn53"                                    },
	{  10058, "G2DAColumn54"                                    },
	{  10059, "G2DAColumn55"                                    },
	{  10060, "G2DAColumn56"                                    },
	{  10061, "G2DAColumn57"                                    },
	{  10062, "G2DAColumn58"                                    },
	{  10063, "G2DAColumn59"                                    },
	{  10064, "G2DAColumn60"                                    },
	{  10065, "G2DAColumn61"                                    },
	{  10066, "G2DAColumn62"                                    },
	{  10067, "G2DAColumn63"                                    },
	{  10068, "G2DAColumn64"                                    },
	{  10069, "G2DAColumn65"                                    },
	{  10070, "G2DAColumn66"                                    },
	{  10071, "G2DAColumn67"                                    },
	{  10072, "G2DAColumn68"                                    },
	{  10073, "G2DAColumn69"                                    },
	{  10074, "G2DAColumn70"                                    },
	{  10075, "G2DAColumn71"                                    },
	{  10076, "G2DAColumn72"                                    },
	{  10077, "G2DAColumn73"                                    },
	{  10078, "G2DAColumn74"                                    },
	{  10079, "G2DAColumn75"                                    },
	{  10080, "G2DAColumn76"                                    },
	{  10081, "G2DAColumn77"                                    },
	{  10082, "G2DAColumn78"                                    },
	{  10083, "G2DAColumn79"                                    },
	{  10084, "G2DAColumn80"                                    },
	{  10085, "G2DAColumn81"                                    },
	{  10086, "G2DAColumn82"                                    },
	{  10087, "G2DAColumn83"                                    },
	{  10088, "G2DAColumn84"                                    },
	{  10089, "G2DAColumn85"                                    },
	{  10090, "G2DAColumn86"                                    },
	{  10091, "G2DAColumn87"                                    },
	{  10092, "G2DAColumn88"                                    },
	{  10093, "G2DAColumn89"                                    },
	{  10094, "G2DAColumn90"                                    },
	{  10095, "G2DAColumn91"                                    },
	{  10096, "G2DAColumn92"                                    },
	{  10097, "G2DAColumn93"                                    },
	{  10098, "G2DAColumn94"                                    },
	{  10099, "G2DAColumn95"                                    },
	{  10100, "G2DAColumn96"                                    },
	{  10101, "G2DAColumn97"                                    },
	{  10102, "G2DAColumn98"                                    },
	{  10103, "G2DAColumn99"                                    },

	{  10104, "G2DAColumn100"                                   },
	{  10105, "G2DAColumn101"                                   },
	{  10106, "G2DAColumn102"                                   },
	{  10107, "G2DAColumn103"                                   },
	{  10108, "G2DAColumn104"                                   },
	{  10109, "G2DAColumn105"                                   },
	{  10110, "G2DAColumn106"                                   },
	{  10111, "G2DAColumn107"                                   },
	{  10112, "G2DAColumn108"                                   },
	{  10113, "G2DAColumn109"                                   },
	{  10114, "G2DAColumn110"                                   },
	{  10115, "G2DAColumn111"                                   },
	{  10116, "G2DAColumn112"                                   },
	{  10117, "G2DAColumn113"                                   },
	{  10118, "G2DAColumn114"                                   },
	{  10119, "G2DAColumn115"                                   },
	{  10120, "G2DAColumn116"                                   },
	{  10121, "G2DAColumn117"                                   },
	{  10122, "G2DAColumn118"                                   },
	{  10123, "G2DAColumn119"                                   },
	{  10124, "G2DAColumn120"                                   },
	{  10125, "G2DAColumn121"                                   },
	{  10126, "G2DAColumn122"                                   },
	{  10127, "G2DAColumn123"                                   },
	{  10128, "G2DAColumn124"                                   },
	{  10129, "G2DAColumn125"                                   },
	{  10130, "G2DAColumn126"                                   },
	{  10131, "G2DAColumn127"                                   },
	{  10132, "G2DAColumn128"                                   },
	{  10133, "G2DAColumn129"                                   },
	{  10134, "G2DAColumn130"                                   },
	{  10135, "G2DAColumn131"                                   },
	{  10136, "G2DAColumn132"                                   },
	{  10137, "G2DAColumn133"                                   },
	{  10138, "G2DAColumn134"                                   },
	{  10139, "G2DAColumn135"                                   },
	{  10140, "G2DAColumn136"                                   },
	{  10141, "G2DAColumn137"                                   },
	{  10142, "G2DAColumn138"                                   },
	{  10143, "G2DAColumn139"                                   },
	{  10144, "G2DAColumn140"                                   },
	{  10145, "G2DAColumn141"                                   },
	{  10146, "G2DAColumn142"                                   },
	{  10147, "G2DAColumn143"                                   },
	{  10148, "G2DAColumn144"                                   },
	{  10149, "G2DAColumn145"                                   },
	{  10150, "G2DAColumn146"                                   },
	{  10151, "G2DAColumn147"                                   },
	{  10152, "G2DAColumn148"                                   },
	{  10153, "G2DAColumn149"                                   },
	{  10154, "G2DAColumn150"                                   },
	{  10155, "G2DAColumn151"                                   },
	{  10156, "G2DAColumn152"                                   },
	{  10157, "G2DAColumn153"                                   },
	{  10158, "G2DAColumn154"                                   },
	{  10159, "G2DAColumn155"                                   },
	{  10160, "G2DAColumn156"                                   },
	{  10161, "G2DAColumn157"                                   },
	{  10162, "G2DAColumn158"                                   },
	{  10163, "G2DAColumn159"                                   },
	{  10164, "G2DAColumn160"                                   },
	{  10165, "G2DAColumn161"                                   },
	{  10166, "G2DAColumn162"                                   },
	{  10167, "G2DAColumn163"                                   },
	{  10168, "G2DAColumn164"                                   },
	{  10169, "G2DAColumn165"                                   },
	{  10170, "G2DAColumn166"                                   },
	{  10171, "G2DAColumn167"                                   },
	{  10172, "G2DAColumn168"                                   },
	{  10173, "G2DAColumn169"                                   },
	{  10174, "G2DAColumn170"                                   },
	{  10175, "G2DAColumn171"                                   },
	{  10176, "G2DAColumn172"                                   },
	{  10177, "G2DAColumn173"                                   },
	{  10178, "G2DAColumn174"                                   },
	{  10179, "G2DAColumn175"                                   },
	{  10180, "G2DAColumn176"                                   },
	{  10181, "G2DAColumn177"                                   },
	{  10182, "G2DAColumn178"                                   },
	{  10183, "G2DAColumn179"                                   },
	{  10184, "G2DAColumn180"                                   },
	{  10185, "G2DAColumn181"                                   },
	{  10186, "G2DAColumn182"                                   },
	{  10187, "G2DAColumn183"                                   },
	{  10188, "G2DAColumn184"                                   },
	{  10189, "G2DAColumn185"                                   },
	{  10190, "G2DAColumn186"                                   },
	{  10191, "G2DAColumn187"                                   },
	{  10192, "G2DAColumn188"                                   },
	{  10193, "G2DAColumn189"                                   },
	{  10194, "G2DAColumn190"                                   },
	{  10195, "G2DAColumn191"                                   },
	{  10196, "G2DAColumn192"                                   },
	{  10197, "G2DAColumn193"                                   },
	{  10198, "G2DAColumn194"                                   },
	{  10199, "G2DAColumn195"                                   },
	{  10200, "G2DAColumn196"                                   },
	{  10201, "G2DAColumn197"                                   },
	{  10202, "G2DAColumn198"                                   },
	{  10203, "G2DAColumn199"                                   },

	{  10204, "G2DAColumn200"                                   },
	{  10205, "G2DAColumn201"                                   },
	{  10206, "G2DAColumn202"                                   },
	{  10207, "G2DAColumn203"                                   },
	{  10208, "G2DAColumn204"                                   },
	{  10209, "G2DAColumn205"                                   },
	{  10210, "G2DAColumn206"                                   },
	{  10211, "G2DAColumn207"                                   },
	{  10212, "G2DAColumn208"                                   },
	{  10213, "G2DAColumn209"                                   },
	{  10214, "G2DAColumn210"                                   },
	{  10215, "G2DAColumn211"                                   },
	{  10216, "G2DAColumn212"                                   },
	{  10217, "G2DAColumn213"                                   },
	{  10218, "G2DAColumn214"                                   },
	{  10219, "G2DAColumn215"                                   },
	{  10220, "G2DAColumn216"                                   },
	{  10221, "G2DAColumn217"                                   },
	{  10222, "G2DAColumn218"                                   },
	{  10223, "G2DAColumn219"                                   },
	{  10224, "G2DAColumn220"                                   },
	{  10225, "G2DAColumn221"                                   },
	{  10226, "G2DAColumn222"                                   },
	{  10227, "G2DAColumn223"                                   },
	{  10228, "G2DAColumn224"                                   },
	{  10229, "G2DAColumn225"                                   },
	{  10230, "G2DAColumn226"                                   },
	{  10231, "G2DAColumn227"                                   },
	{  10232, "G2DAColumn228"                                   },
	{  10233, "G2DAColumn229"                                   },
	{  10234, "G2DAColumn230"                                   },
	{  10235, "G2DAColumn231"                                   },
	{  10236, "G2DAColumn232"                                   },
	{  10237, "G2DAColumn233"                                   },
	{  10238, "G2DAColumn234"                                   },
	{  10239, "G2DAColumn235"                                   },
	{  10240, "G2DAColumn236"                                   },
	{  10241, "G2DAColumn237"                                   },
	{  10242, "G2DAColumn238"                                   },
	{  10243, "G2DAColumn239"                                   },
	{  10244, "G2DAColumn240"                                   },
	{  10245, "G2DAColumn241"                                   },
	{  10246, "G2DAColumn242"                                   },
	{  10247, "G2DAColumn243"                                   },
	{  10248, "G2DAColumn244"                                   },
	{  10249, "G2DAColumn245"                                   },
	{  10250, "G2DAColumn246"                                   },
	{  10251, "G2DAColumn247"                                   },
	{  10252, "G2DAColumn248"                                   },
	{  10253, "G2DAColumn249"                                   },
	{  10254, "G2DAColumn250"                                   },
	{  10255, "G2DAColumn251"                                   },
	{  10256, "G2DAColumn252"                                   },
	{  10257, "G2DAColumn253"                                   },
	{  10258, "G2DAColumn254"                                   },
	{  10259, "G2DAColumn255"                                   },
	{  10260, "G2DAColumn256"                                   },
	{  10261, "G2DAColumn257"                                   },
	{  10262, "G2DAColumn258"                                   },
	{  10263, "G2DAColumn259"                                   },
	{  10264, "G2DAColumn260"                                   },
	{  10265, "G2DAColumn261"                                   },
	{  10266, "G2DAColumn262"                                   },
	{  10267, "G2DAColumn263"                                   },
	{  10268, "G2DAColumn264"                                   },
	{  10269, "G2DAColumn265"                                   },
	{  10270, "G2DAColumn266"                                   },
	{  10271, "G2DAColumn267"                                   },
	{  10272, "G2DAColumn268"                                   },
	{  10273, "G2DAColumn269"                                   },
	{  10274, "G2DAColumn270"                                   },
	{  10275, "G2DAColumn271"                                   },
	{  10276, "G2DAColumn272"                                   },
	{  10277, "G2DAColumn273"                                   },
	{  10278, "G2DAColumn274"                                   },
	{  10279, "G2DAColumn275"                                   },
	{  10280, "G2DAColumn276"                                   },
	{  10281, "G2DAColumn277"                                   },
	{  10282, "G2DAColumn278"                                   },
	{  10283, "G2DAColumn279"                                   },
	{  10284, "G2DAColumn280"                                   },
	{  10285, "G2DAColumn281"                                   },
	{  10286, "G2DAColumn282"                                   },
	{  10287, "G2DAColumn283"                                   },
	{  10288, "G2DAColumn284"                                   },
	{  10289, "G2DAColumn285"                                   },
	{  10290, "G2DAColumn286"                                   },
	{  10291, "G2DAColumn287"                                   },
	{  10292, "G2DAColumn288"                                   },
	{  10293, "G2DAColumn289"                                   },
	{  10294, "G2DAColumn290"                                   },
	{  10295, "G2DAColumn291"                                   },
	{  10296, "G2DAColumn292"                                   },
	{  10297, "G2DAColumn293"                                   },
	{  10298, "G2DAColumn294"                                   },
	{  10299, "G2DAColumn295"                                   },
	{  10300, "G2DAColumn296"                                   },
	{  10301, "G2DAColumn297"                                   },
	{  10302, "G2DAColumn298"                                   },
	{  10303, "G2DAColumn299"                                   },

	{  10999, "G2DAColumnType"                                  },

	{  11000, "StagePlaceList"                                  },
	{  11001, "StageCameraList"                                 },
	{  11002, "StagePlacesInShot"                               },
	{  11003, "StageCameraFOV"                                  },
	{  11004, "StagePlaceDefaultCamera"                         },
	{  11005, "StageCameraDeprecated"                           },
	{  11006, "StageCameraLookingFrom"                          },
	{  11007, "StageCameraLookingAtPrimary"                     },
	{  11008, "StageCameraLookingAtSecondary"                   },
	{  11009, "StageCameraLookingAtType"                        },

	{  12000, "ConversationStartingList"                        },
	{  12001, "ConversationStartingIndex"                       },
	{  12002, "ConversationLineList"                            },
	{  12003, "ConversationEnd"                                 },
	{  12004, "ConversationVOBank"                              },

	{  12100, "ConversationStageName"                           },
	{  12101, "ConversationStageMap"                            },

	{  12102, "ConversationKeyTag"                              },
	{  12103, "ConversationValueTag"                            },

	{  12104, "ConversationStageAtCurrentLocation"              },

	{  12201, "ConversationLineText"                            },
	{  12202, "ConversationLineSpeaker"                         },
	{  12203, "ConversationLineListener"                        },
	{  12204, "ConversationLineGameLanguage"                    },
	{  12205, "ConversationLineIcon"                            },
	{  12206, "ConversationLineVisibility"                      },
	{  12207, "ConversationLineAmbient"                         },
	{  12208, "ConversationLineCond"                            },
	{  12209, "ConversationLineAction"                          },
	{  12210, "ConversationLineCutResRef"                       },
	{  12211, "ConversationLineCut"                             },
	{  12212, "ConversationLineCutMap"                          },
	{  12213, "ConversationLineAnimation"                       },
	{  12214, "ConversationLineSkip"                            },
	{  12215, "ConversationLineFastPath"                        },
	{  12216, "ConversationLineNoVOIngame"                      },
	{  12217, "ConversationLineRevertAnim"                      },
	{  12218, "ConversationLineSlideShowTexture"                },

	{  12300, "ConversationPlotGuid"                            },
	{  12301, "ConversationPlotFlag"                            },
	{  12302, "ConversationPlotTest"                            },
	{  12303, "ConversationScript"                              },
	{  12304, "ConversationScriptParameter"                     },

	{  12400, "ConversationLineChildrenList"                    },

	{  12500, "ConversationLineActive"                          },

	{  13000, "PlotFlags"                                       },
	{  13001, "PlotFlagID"                                      },
	{  13002, "PlotFlagName"                                    },
	{  13003, "PlotFlagReward"                                  },
	{  13004, "PlotFlagJournal"                                 },
	{  13005, "PlotFlagEndsPlot"                                },
	{  13006, "PlotFlagMultiReward"                             },
	{  13007, "PlotGuid"                                        },
	{  13008, "PlotName"                                        },
	{  13009, "PlotScript"                                      },
	{  13010, "PlotPriority"                                    },
	{  13011, "PlotFlags1"                                      },
	{  13012, "PlotFlags2"                                      },
	{  13013, "PlotFlags3"                                      },
	{  13014, "PlotFlags4"                                      },
	{  13015, "PlotJournalImage"                                },
	{  13016, "PlotPlots"                                       },
	{  13017, "PlotParentPlot"                                  },
	{  13018, "PlotFlagAreaLocationTag"                         },
	{  13019, "PlotAssistList"                                  },
	{  13020, "PlotAssistTag"                                   },
	{  13021, "PlotAssistAdvancesPlot"                          },
	{  13022, "PlotEntryType"                                   },
	{  13023, "PlotAllowPausing"                                },
	{  13024, "PlotFlagOfferID"                                 },
	{  13025, "PlotParentPlotGuid"                              },

	{  14000, "TintMaskDiffuseR"                                },
	{  14001, "TintMaskDiffuseG"                                },
	{  14002, "TintMaskDiffuseB"                                },
	{  14003, "TintMaskSpecularR"                               },
	{  14004, "TintMaskSpecularG"                               },
	{  14005, "TintMaskSpecularB"                               },
	{  14006, "TintMaskDiffuseA"                                },
	{  14007, "TintMaskSpecularA"                               },
	{  14008, "TintMaskDiffuseOpacity"                          },
	{  14009, "TintMaskSpecularOpacity"                         },

	{  15000, "MatFileObjectVersion"                            },
	{  15001, "MatChildList"                                    },

	{  15010, "MatRoot"                                         },
	{  15011, "MatRootName"                                     },
	{  15012, "MatModel"                                        },
	{  15013, "MatModelName"                                    },
	{  15014, "MatPart"                                         },
	{  15015, "MatPartName"                                     },
	{  15016, "MatPartMMHParent"                                },
	{  15017, "MatMatLib"                                       },
	{  15018, "MatMatLibName"                                   },
	{  15019, "MatMatObj"                                       },
	{  15020, "MatMatObjName"                                   },
	{  15021, "MatLight"                                        },
	{  15022, "MatLightName"                                    },
	{  15023, "MatLightRig"                                     },
	{  15024, "MatLightRigName"                                 },
	{  15025, "MatLightProbe"                                   },
	{  15026, "MatLightProbeName"                               },
	{  15027, "MatGroup"                                        },
	{  15028, "MatGroupName"                                    },
	{  15029, "MatPalettelIb"                                   },
	{  15030, "MatPalettelIbName"                               },
	{  15031, "MatPaletteObj"                                   },
	{  15032, "MatPaletteObjName"                               },
	{  15033, "MatHeraldryLib"                                  },
	{  15034, "MatHeraldryLibName"                              },
	{  15035, "MatHeraldryObj"                                  },
	{  15036, "MatHeraldryObjName"                              },
	{  15037, "MatDuplicate"                                    },
	{  15038, "MatDuplicateName"                                },
	{  15039, "MatLayoutName"                                   },
	{  15040, "MatTintLib"                                      },
	{  15041, "MatTintLibName"                                  },
	{  15042, "MatTintObj"                                      },
	{  15043, "MatTintObjName"                                  },

	{  15050, "MatMaterialType"                                 },
	{  15051, "MatBasicParams"                                  },
	{  15052, "MatShinyTrans"                                   },
	{  15053, "MatTwoSide"                                      },
	{  15054, "MatHair"                                         },
	{  15055, "MatDyncLight"                                    },
	{  15056, "MatBlendMode"                                    },
	{  15057, "MatName"                                         },
	{  15058, "MatMaterialTypeString"                           },
	{  15059, "MatMaterialSemantic"                             },
	{  15060, "MatMaterialSoundType"                            },

	{  15070, "MatDiffuseMapType"                               },
	{  15071, "MatDiffuseMapColor"                              },
	{  15072, "MatDiffuseMapScale"                              },
	{  15073, "MatDiffuseMap"                                   },
	{  15074, "MatDiffuseFileName"                              },
	{  15075, "MatDiffOpacDimensionX"                           },
	{  15076, "MatDiffOpacDimensionY"                           },
	{  15077, "MatDiffOpacCompression"                          },
	{  15078, "MatDiffOpacCompressionXbox360"                   },

	{  15080, "MatSecondaryDiffuseMapEnable"                    },
	{  15081, "MatSecondaryDiffuseMap"                          },
	{  15082, "MatSecondaryDiffuseFileName"                     },
	{  15085, "MatSecondaryDiffuseCompression"                  },
	{  15086, "MatSecondaryDiffuseCompressionXbox360"           },

	{  15100, "MatOpacitymapenable"                             },
	{  15101, "MatOpacitymaptype"                               },
	{  15102, "MatOpacitymapcolor"                              },
	{  15103, "MatOpacitymapscale"                              },
	{  15104, "MatOpacitymap"                                   },

	{  15130, "MatSpecularMapEnable"                            },
	{  15131, "MatSpecularMapType"                              },
	{  15132, "MatSpecularMapColor"                             },
	{  15133, "MatSpecularMapScale"                             },
	{  15134, "MatSpecularMap"                                  },
	{  15135, "MatSpecularGlossType"                            },
	{  15136, "MatSpecularGlossColor"                           },
	{  15137, "MatSpecularGlossScale"                           },
	{  15138, "MatSpecularGloss"                                },
	{  15139, "MatSpecularFileName"                             },
	{  15140, "MatSpecularDimensionX"                           },
	{  15141, "MatSpecularDimensionY"                           },
	{  15142, "MatSpecularCompression"                          },
	{  15143, "MatSpecularCompressionXbox360"                   },
	{  15144, "MatSpecularReflectionMultiplier"                 },

	{  15160, "MatNormalMapEnable"                              },
	{  15161, "MatNormalMap"                                    },
	{  15162, "MatNormalFileName"                               },
	{  15163, "MatNormalCompression"                            },
	{  15164, "MatNormalCompressionXbox360"                     },

	{  15190, "MatTintMapEnable"                                },
	{  15191, "MatTintMap"                                      },

	{  15192, "MatTintREnable"                                  },
	{  15193, "MatTintGEnable"                                  },
	{  15194, "MatTintBEnable"                                  },
	{  15195, "MatTintFileNamePostfix"                          },

	{  15196, "MatTintCompression"                              },
	{  15197, "MatTintCompressionXbox360"                       },

	{  15198, "MatTintAEnable"                                  },
	{  15199, "MatTintRSpecularIntensity"                       },
	{  15200, "MatTintGSpecularIntensity"                       },
	{  15201, "MatTintBSpecularIntensity"                       },
	{  15202, "MatTintASpecularIntensity"                       },
	{  15203, "MatTintRDiffuseIntensity"                        },
	{  15204, "MatTintGDiffuseIntensity"                        },
	{  15205, "MatTintBDiffuseIntensity"                        },
	{  15206, "MatTintADiffuseIntensity"                        },
	{  15207, "MatTintRSpecularOpacity"                         },
	{  15208, "MatTintGSpecularOpacity"                         },
	{  15209, "MatTintBSpecularOpacity"                         },
	{  15210, "MatTintASpecularOpacity"                         },
	{  15211, "MatTintRDiffuseOpacity"                          },
	{  15212, "MatTintGDiffuseOpacity"                          },
	{  15213, "MatTintBDiffuseOpacity"                          },
	{  15214, "MatTintADiffuseOpacity"                          },
	{  15215, "MatTintType"                                     },

	{  15216, "MatTintMaskTintChannel1"                         },
	{  15217, "MatTintMaskTintChannel2"                         },
	{  15218, "MatTintMaskTintChannel3"                         },
	{  15219, "MatTintMaskTintChannel4"                         },

	{  15220, "MatReliefMapEnable"                              },
	{  15221, "MatReliefMap"                                    },
	{  15222, "MatReliefMapScale"                               },
	{  15223, "MatReliefMapSamples"                             },
	{  15224, "MatReliefMapShadowOffset"                        },
	{  15225, "MatReliefMapInOut"                               },
	{  15226, "MatReliefCompression"                            },
	{  15227, "MatReliefCompressionXbox360"                     },

	{  15228, "MatTintExportable"                               },

	{  15250, "MatVFXContactSheetWidth"                         },
	{  15251, "MatVFXContactSheetHeight"                        },
	{  15252, "MatVFXContactSheetFrames"                        },
	{  15253, "MatVFXScrollSpeedU"                              },
	{  15254, "MatVFXScrollSpeedV"                              },
	{  15255, "MatVFXDepthBiasAlpha"                            },
	{  15256, "MatVFXStartAlphaFresnel"                         },
	{  15257, "MatVFXEndAlphaFresnel"                           },
	{  15258, "MatVFXInvertAlphaFresnel"                        },

	{  15280, "MatFresnelMapEnable"                             },
	{  15281, "MatFresnelMap"                                   },
	{  15282, "MatFresnelFileName"                              },
	{  15283, "MatFresnelCompression"                           },
	{  15284, "MatFresnelCompressionXbox360"                    },

	{  15310, "MatEmissiveMapEnable"                            },
	{  15311, "MatEmissiveMap"                                  },
	{  15312, "MatEmissiveFileName"                             },
	{  15313, "MatEmissiveCompression"                          },
	{  15314, "MatEmissiveCompressionXbox360"                   },

	{  15340, "MatSectionMaskMapEnable"                         },
	{  15341, "MatSectionMaskMap"                               },
	{  15342, "MatSectionMaskFileName"                          },
	{  15343, "MatSectionMaskCompression"                       },
	{  15344, "MatSectionMaskCompressionXbox360"                },

	{  15360, "MatSecondaryNormalMapEnable"                     },
	{  15361, "MatSecondaryNormalMap"                           },
	{  15362, "MatSecondaryNormalFileName"                      },
	{  15363, "MatSecondaryNormalCompression"                   },
	{  15364, "MatSecondaryNormalCompressionXbox360"            },

	{  15380, "MatEyeCorneaSpecularMask"                        },
	{  15381, "MatEyeCorneaSpecularPower"                       },
	{  15382, "MatEyeScleraSpecularMask"                        },
	{  15383, "MatEyeScleraSpecularPower"                       },
	{  15384, "MatEyeCorneaReflectionMultiplier"                },

	{  15400, "MatSpecularMaskMapEnable"                        },
	{  15401, "MatPackedTextureMap"                             },
	{  15402, "MatPackedTextureFileName"                        },
	{  15403, "MatPackedTextureCompression"                     },
	{  15404, "MatPackedTextureCompressionXbox360"              },

	{  15420, "MatSpecularShiftMapEnable"                       },
	{  15421, "MatTintNoiseMap"                                 },
	{  15422, "MatTintNoiseFileName"                            },
	{  15423, "MatTintNoiseCompression"                         },
	{  15424, "MatTintNoiseCompressionXbox360"                  },

	{  15440, "MatHairDiffuseTint"                              },
	{  15441, "MatHairPrimarySpecularPower"                     },
	{  15442, "MatHairPrimarySpecularMask"                      },
	{  15443, "MatHairSecondarySpecularPower"                   },
	{  15444, "MatHairSecondarySpecularTint"                    },
	{  15445, "MatHairTintNoiseTiling"                          },

	{  15460, "MatSun"                                          },
	{  15461, "MatSunName"                                      },
	{  15462, "MatSunDirection"                                 },
	{  15463, "MatSunColor"                                     },
	{  15464, "MatSunColormult"                                 },

	{  15480, "MatHeraldryMapEnable"                            },
	{  15481, "MatHeraldryMap"                                  },
	{  15482, "MatHeraldryFileName"                             },
	{  15483, "MatHeraldryCompression"                          },
	{  15484, "MatHeraldryCompressionXbox360"                   },

	{  15500, "MatRimLightWidth"                                },
	{  15501, "MatRimLightMultiplier"                           },
	{  15502, "MatFalloffWidth"                                 },
	{  15503, "MatFalloffMultiplier"                            },

	{  15510, "MatAmbientMultiplier"                            },
	{  15511, "MatSpecularMultiplier"                           },
	{  15512, "MatLipSpecularBoost"                             },
	{  15513, "MatRimPower"                                     },

	{  15520, "MatDistortionMapEnable"                          },
	{  15521, "MatDistortionMap"                                },
	{  15522, "MatDistortionFileName"                           },
	{  15523, "MatDistortionCompression"                        },
	{  15524, "MatDistortionCompressionXbox360"                 },

	{  15540, "MatDistortionModifiersMapEnable"                 },
	{  15541, "MatDistortionModifiersMap"                       },
	{  15542, "MatDistortionModifiersFileName"                  },
	{  15543, "MatDistortionModifiersCompression"               },
	{  15544, "MatDistortionModifiersCompressionXbox360"        },

	{  15560, "MatDistortionMagnitude"                          },
	{  15561, "MatDistortionInvert"                             },
	{  15562, "MatDistortionFadeDistance"                       },
	{  15563, "MatDistortionFadeMultiplier"                     },

	{  15580, "MatAlternateDecalMap"                            },
	{  15581, "MatAlternateDecalFileName"                       },
	{  15582, "MatAlternateDecalCompression"                    },
	{  15583, "MatAlternateDecalCompressionXbox360"             },

	{  15590, "MatTattooMaskMap"                                },
	{  15591, "MatTattooMaskFileName"                           },
	{  15592, "MatTattooMaskCompression"                        },
	{  15593, "MatTattooMaskCompressionXbox360"                 },
	{  15594, "MatTattooMaskMapEnable"                          },

	{  15595, "MatTattooMaskTintChannel1"                       },
	{  15596, "MatTattooMaskTintChannel2"                       },
	{  15597, "MatTattooMaskTintChannel3"                       },
	{  15598, "MatTattooMaskTintChannel4"                       },

	{  15600, "MatBrowStubbleMap"                               },
	{  15601, "MatBrowStubbleFileName"                          },
	{  15602, "MatBrowStubbleCompression"                       },
	{  15603, "MatBrowStubbleCompressionXbox360"                },

	{  15610, "MatBrowStubbleNormalMap"                         },
	{  15611, "MatBrowStubbleNormalFileName"                    },
	{  15612, "MatBrowStubbleNormalCompression"                 },
	{  15613, "MatBrowStubbleNormalCompressionXbox360"          },

	{  15620, "MatEmotionsMask0Map"                             },
	{  15621, "MatEmotionsMask0FileName"                        },
	{  15622, "MatEmotionsMask0Compression"                     },
	{  15623, "MatEmotionsMask0CompressionXbox360"              },

	{  15630, "MatEmotionsMask1Map"                             },
	{  15631, "MatEmotionsMask1FileName"                        },
	{  15632, "MatEmotionsMask1Compression"                     },
	{  15633, "MatEmotionsMask1CompressionXbox360"              },

	{  15640, "MatEmotionsNormalMap"                            },
	{  15641, "MatEmotionsNormalFileName"                       },
	{  15642, "MatEmotionsNormalCompression"                    },
	{  15643, "MatEmotionsNormalCompressionXbox360"             },

	{  15650, "MatScrollSpeed1"                                 },
	{  15651, "MatScrollSpeed2"                                 },
	{  15652, "MatScrollSpeed3"                                 },
	{  15653, "MatLavaTintColor"                                },
	{  15654, "MatLavaBrightness"                               },
	{  15655, "MatLavaContrast"                                 },
	{  15656, "MatLavaNoiseMap"                                 },

	{  16000, "SavegameCampaign"                                },
	{  16001, "SavegameAreaList"                                },
	{  16002, "SavegamePlayerchar"                              },
	{  16003, "SavegamePartyList"                               },
	{  16004, "SavegameVersion"                                 },
	{  16005, "SavegameGameState"                               },
	{  16006, "SavegameAddinsList"                              },
	{  16007, "SavegameCheatUsed"                               },
	{  16008, "SavegameStorySoFar"                              },

	{  16010, "SavegameAreaPlaceables"                          },
	{  16011, "SavegameAreaCreatures"                           },
	{  16012, "SavegameAreaTriggers"                            },
	{  16013, "SavegameAreaAOEs"                                },
	{  16014, "SavegameCampaignResource"                        },
	{  16015, "SavegameAreaWaypoints"                           },
	{  16016, "SavegameAreaMap"                                 },
	{  16017, "SavegameAreaStores"                              },
	{  16018, "SavegameAreaRoomsViewed"                         },
	{  16019, "SavegameAreaSounds"                              },
	{  16020, "SavegameAreaMinCreatureImportance"               },

	{  16100, "SavegameAreaPlaceableState"                      },
	{  16101, "SavegameAreaTriggerGeometry"                     },
	{  16102, "SavegameAreaPlaceableUseable"                    },
	{  16103, "SavegameAreaTriggerDetectable"                   },
	{  16104, "SavegameAreaTriggerDisarmable"                   },
	{  16105, "SavegameAreaTriggerDCDetectCheck"                },
	{  16106, "SavegameAreaTriggerDCDisarmCheck"                },
	{  16107, "SavegameAreaTriggerLastDisarmed"                 },
	{  16108, "SavegameAreaTriggerReverbPreset"                 },
	{  16109, "SavegameAreaTriggerPriority"                     },
	{  16110, "SavegameAreaTriggerLoadScreen"                   },
	{  16111, "SavegameAreaTriggerSounds"                       },
	{  16112, "SavegameAreaTriggerType"                         },

	{  16113, "SavegameAreaTriggerMusicVolumeEnterState"        },
	{  16114, "SavegameAreaTriggerMusicVolumeExitState"         },
	{  16115, "SavegameAreaTriggerMusicVolumeEnterStateDelay"   },
	{  16116, "SavegameAreaTriggerMusicVolumeExitStateDelay"    },

	{  16150, "SavegameStoreMarkDown"                           },
	{  16151, "SavegameStoreMarkUp"                             },
	{  16152, "SavegameStoreGold"                               },
	{  16153, "SavegameStoreMaxBuyPrice"                        },
	{  16154, "SavegameStoreWillNotBuy"                         },
	{  16155, "SavegameStoreWillOnlyBuy"                        },
	{  16156, "SavegameStoreItemList"                           },

	{  16200, "SavegamePlayercharArea"                          },
	{  16201, "SavegameObjectActive"                            },
	{  16202, "SavegameObjectAILevel"                           },

	{  16203, "SavegamePartyMembers"                            },
	{  16204, "SavegamePartyPoolMembers"                        },
	{  16205, "SavegamePartyMemCreature"                        },
	{  16206, "SavegamePartyMemTemplate"                        },
	{  16207, "SavegamePartyCreatures"                          },
	{  16208, "SavegamePlayerCharChar"                          },

	{  16209, "SavegameCreatureStats"                           },
	{  16210, "SavegameBackpack"                                },
	{  16211, "SavegamePlotItems"                               },
	{  16212, "SavegameMoney"                                   },
	{  16213, "SavegameQuickItems"                              },
	{  16214, "SavegameEquipment"                               },
	{  16215, "SavegameEquipmentSet"                            },
	{  16216, "SavegameEquipmentSetSlot"                        },
	{  16217, "SavegameEquipmentSetObject"                      },
	{  16218, "SavegameEquipmentActiveSet"                      },
	{  16219, "SavegameEquipmentItems"                          },

	{  16220, "SavegameObjectImmortal"                          },
	{  16221, "SavegameObjectEventScript"                       },
	{  16222, "SavegameObjectTag"                               },

	{  16223, "SavegameItems"                                   },
	{  16224, "SavegameItemDroppable"                           },
	{  16225, "SavegameItemDamaged"                             },
	{  16226, "SavegameMaxItems"                                },
	{  16227, "SavegameCraftingRecipeList"                      },
	{  16228, "SavegameItemIrremovable"                         },
	{  16229, "SavegameItemIndestructible"                      },
	{  16230, "SavegameItemMaterialType"                        },
	{  16231, "SavegameItemStealable"                           },
	{  16232, "SavegameItemInfinite"                            },
	{  16233, "SavegameItemCurrentVFXPropertyID"                },
	{  16234, "SavegameItemCurrentVFXPropertyPower"             },

	{  16250, "SavegameObjectPlot"                              },
	{  16251, "SavegameObjectHealth"                            },
	{  16252, "SavegameObjectMaxHealth"                         },
	{  16253, "SavegameObjectRank"                              },
	{  16254, "SavegameObjectTreasureGroup"                     },
	{  16255, "SavegameObjectName"                              },
	{  16256, "SavegameObjectLoopingAnimation"                  },
	{  16257, "SavegameObjectLootableCreatureAppearanceType"    },
	{  16258, "SavegameObjectPickLock"                          },
	{  16259, "SavegameObjectTrapDetected"                      },
	{  16260, "SavegameObjectDCDetectCheck"                     },
	{  16261, "SavegameObjectDCDisarmCheck"                     },
	{  16262, "SavegameObjectInteractionRadius"                 },
	{  16263, "SavegameObjectImportance"                        },

	{  16270, "SavegameSelectedCharacter"                       },
	{  16271, "SavegameFollowerLastEnabledArea"                 },
	{  16272, "SavegameFollowerLastEnabledPosition"             },
	{  16273, "SavegameFollowerLastEnabledOrientation"          },
	{  16274, "SavegamePartyPickerGUIStatus"                    },
	{  16275, "SavegamePartyApprovalList"                       },
	{  16276, "SavegamePartyApprovalID"                         },
	{  16277, "SavegamePartyApprovalLevel"                      },
	{  16278, "SavegamePartyLeader"                             },
	{  16279, "SavegameNonPartyMembers"                         },
	{  16280, "SavegamePartyMemberSubstate"                     },
	{  16281, "SavegamePartyMemberLocked"                       },
	{  16282, "SavegamePartyMemberFollow"                       },
	{  16284, "SavegamePartyItemStorageItem"                    },
	{  16285, "SavegamePartyItemStorageOwner"                   },
	{  16286, "SavegamePartyItemStorageSlot"                    },
	{  16287, "SavegamePartyItemStorageWeaponset"               },
	{  16288, "SavegamePartyItemStorageList"                    },
	{  16289, "SavegamePartyNewItemID"                          },
	{  16290, "SavegamePartyNewItemList"                        },
	{  16291, "SavegamePartyAutoLevelDefault"                   },
	{  16292, "SavegamePartyQuickbarLocked"                     },
	{  16293, "SavegamePartyHoldPositions"                      },
	{  16294, "SavegamePartyRunInDriveMode"                     },

	{  16295, "SavegamePlayerMapZoom"                           },
	{  16296, "SavegamePlayerMapLegend"                         },

	{  16297, "SavegamePartyApprovalDesc"                       },
	{  16298, "SavegamePlayerTimePlayed"                        },
	{  16299, "SavegamePartyBackpackSort"                       },

	{  16300, "SavegameStatPropertyBase"                        },
	{  16301, "SavegameStatPropertyModifier"                    },
	{  16302, "SavegameStatPropertyCurrent"                     },
	{  16303, "SavegameStatPropertyComRegen"                    },
	{  16304, "SavegameStatPropertyRegen"                       },

	{  16305, "SavegameSpellList"                               },
	{  16306, "SavegameTalentList"                              },
	{  16307, "SavegameSkillList"                               },
	{  16308, "SavegameQuickslots"                              },
	{  16309, "SavegameAbilityList"                             },
	{  16310, "SavegameQbarExpansionValue"                      },
	{  16311, "SavegameQuickslotAbility"                        },
	{  16312, "SavegameQuickslotItemTag"                        },
	{  16313, "SavegameQuickslots1"                             },
	{  16314, "SavegameQuickslots2"                             },
	{  16315, "SavegameQuickslots3"                             },
	{  16316, "SavegameQuickslots4"                             },
	{  16317, "SavegameCurentQbar"                              },
	{  16318, "SavegameLockQbar"                                },
	{  16319, "SavegameQuickslotTemplate"                       },

	{  16320, "SavegameAppearance"                              },
	{  16321, "SavegameAppearanceType"                          },
	{  16322, "SavegameAppearanceGender"                        },
	{  16324, "SavegameAppearanceGore"                          },
	{  16325, "SavegameAppearanceDecapitated"                   },
	{  16326, "SavegameAppearanceItemHeraldryVariation"         },
	{  16327, "SavegameAppearanceOriginalType"                  },
	{  16328, "SavegameAppearanceMorphName"                     },

	{  16329, "SavegameAutoLevelUp"                             },
	{  16330, "SavegamePromptAutoLevelUp"                       },
	{  16331, "SavegameQuickslotNumber"                         },

	{  16332, "SavegamePlayerPortraitPitch"                     },
	{  16333, "SavegamePlayerPortraitYaw"                       },
	{  16334, "SavegamePlayerPortraitTint"                      },
	{  16335, "SavegamePlayerPortraitExpression"                },
	{  16336, "SavegamePlayerPortraitDistance"                  },
	{  16337, "SavegamePlayerPortraitPositionH"                 },
	{  16338, "SavegamePlayerPortraitPositionV"                 },

	{  16350, "SavegameStatList"                                },
	{  16351, "SavegameHeroicStatList"                          },
	{  16352, "SavegameHeroicPartyStatList"                     },
	{  16353, "SavegameStatPropertyIndex"                       },
	{  16354, "SavegameStatPropertyMin"                         },
	{  16355, "SavegameStatPropertyMax"                         },

	{  16400, "SavegamePlotManager"                             },
	{  16401, "SavegamePlotList"                                },
	{  16402, "SavegamePlotGuid"                                },
	{  16403, "SavegamePlotFlags1"                              },
	{  16404, "SavegamePlotFlags2"                              },
	{  16405, "SavegamePlotFlags3"                              },
	{  16406, "SavegamePlotFlags4"                              },

	{  16420, "StructSavegameAddinUID"                          },
	{  16421, "StructSavegameAddinENUS"                         },
	{  16422, "StructSavegameAddinFRFR"                         },
	{  16423, "StructSavegameAddinITIT"                         },
	{  16424, "StructSavegameAddinDEDE"                         },
	{  16425, "StructSavegameAddinESES"                         },
	{  16426, "StructSavegameAddinPLPL"                         },
	{  16427, "StructSavegameAddinRURU"                         },
	{  16428, "StructSavegameAddinPseudo"                       },
	{  16429, "StructSavegameAddinCSCZ"                         },
	{  16430, "StructSavegameAddinHUHU"                         },

	{  16450, "SavegameGroupList"                               },
	{  16451, "SavegameGroupID"                                 },
	{  16452, "SavegameGroupHostiles"                           },
	{  16453, "SavegameTeamID"                                  },
	{  16454, "SavegameCreatureStealth"                         },
	{  16455, "SavegameIsPlotGiver"                             },
	{  16456, "SavegameCanLevelUp"                              },
	{  16457, "SavegameCreatureTrackable"                       },
	{  16458, "SavegameCreatureControllable"                    },
	{  16459, "SavegameCreatureInteractive"                     },
	{  16460, "SavegameCreatureRace"                            },
	{  16461, "SavegameCreaturePackage"                         },
	{  16462, "SavegameCreaturePackageAI"                       },
	{  16463, "SavegameCreatureCanChangeEquipment"              },
	{  16464, "SavegameCreatureClassRankList"                   },
	{  16465, "SavegameCreatureClassID"                         },
	{  16466, "SavegameCreatureClassRank"                       },
	{  16467, "SavegameCreatureIsGhost"                         },
	{  16468, "SavegameCreatureModalAbilityList"                },
	{  16469, "SavegameCreatureShowAsAllyOnMap"                 },
	{  16470, "SavegameCreatureIsStatue"                        },
	{  16471, "SavegameCreatureMinimizedSkillHeaderList"        },
	{  16472, "SavegameCreatureMinimizedTalentHeaderList"       },
	{  16473, "SavegameCreatureAbilityHeaderID"                 },
	{  16474, "SavegameCreatureItemsScaled"                     },

	{  16475, "SavegameCreatureHeartbeatInterval"               },

	{  16476, "SavegameCreatureRoamRadius"                      },
	{  16477, "SavegameCreatureRoamCenter"                      },

	{  16478, "SavegameCreaturePoolName"                        },
	{  16479, "SavegameCreaturePoolAvailable"                   },

	{  16480, "SavegameCreatureNoPermDeath"                     },
	{  16481, "SavegameCreatureTimeSinceDeath"                  },

	{  16499, "SavegameCreatureTimeBeforeDecay"                 },

	{  16500, "SavegameWorldDatabase"                           },
	{  16501, "SavegameWorldDBIDgroup"                          },
	{  16502, "SavegameWorldDBLastID"                           },

	{  16503, "SavegamePartySeenLines"                          },

	{  16504, "SavegameJournal"                                 },
	{  16505, "SavegameJournalActiveList"                       },
	{  16506, "SavegameJournalCompleteList"                     },
	{  16507, "SavegameJournalTitle"                            },
	{  16508, "SavegameJournalText"                             },
	{  16509, "SavegameJournalParentPlot"                       },
	{  16510, "SavegameJournalResRef"                           },
	{  16511, "SavegameJournalStoryText"                        },
	{  16512, "SavegameJournalAreaTag"                          },
	{  16513, "SavegameJournalPlotDestinationList"              },
	{  16514, "SavegameJournalPlotDestinationTag"               },
	{  16515, "SavegameJournalPlotDestinationGuidList"          },
	{  16516, "SavegameJournalConversationList"                 },
	{  16517, "SavegameJournalConversationLineList"             },
	{  16518, "SavegameJournalConversationLineSpeaker"          },
	{  16519, "SavegameJournalConversationLineText"             },
	{  16520, "SavegameJournalConversationLineReply"            },
	{  16521, "SavegameJournalUnreadCodexList"                  },
	{  16522, "SavegameJournalOrphanList"                       },
	{  16523, "SavegameJournalQuestCompleted"                   },
	{  16524, "SavegameJournalQuestGroup"                       },
	{  16525, "SavegameJournalGroupList"                        },
	{  16526, "SavegameJournalGroupResRef"                      },
	{  16527, "SavegameJournalGroupOpenInCurrent"               },
	{  16528, "SavegameJournalGroupOpenInCompleted"             },
	{  16529, "SavegameJournalGroupPriority"                    },

	{  16530, "SavegameAmbientDialogList"                       },
	{  16531, "SavegameAmbientDialogOwner"                      },
	{  16532, "SavegameAmbientDialogSpeaker"                    },
	{  16533, "SavegameAmbientDialogResRef"                     },
	{  16534, "SavegameAmbientDialogLine"                       },

	{  16540, "SavegameJournalQuestUpdated"                     },
	{  16541, "SavegameJournalOfferID"                          },

	{  16600, "SavegameBodybagID"                               },
	{  16601, "SavegameIsBodybag"                               },
	{  16602, "SavegameLootableObjectID"                        },

	{  16603, "SavegameAOEID"                                   },
	{  16604, "SavegameAOEShape"                                },
	{  16605, "SavegameAOERadius"                               },
	{  16606, "SavegameAOEWidth"                                },
	{  16607, "SavegameAOELength"                               },
	{  16608, "SavegameAOECreator"                              },
	{  16609, "SavegameAOEDuration"                             },
	{  16610, "SavegameAOEDurationType"                         },
	{  16611, "SavegameAOELinked"                               },

	{  16612, "SavegameCreatureRank"                            },

	{  16613, "SavegameEffectID"                                },
	{  16614, "SavegameEffectType"                              },
	{  16615, "SavegameEffectDurationType"                      },
	{  16616, "SavegameEffectDuration"                          },
	{  16617, "SavegameEffectSubType"                           },
	{  16618, "SavegameEffectTimeIndex"                         },
	{  16619, "SavegameEffectAnimation"                         },
	{  16620, "SavegameEffectPriority"                          },
	{  16621, "SavegameEffectCreator"                           },
	{  16622, "SavegameEffectAbilityID"                         },
	{  16623, "SavegameEffectList"                              },
	{  16624, "SavegameEffectEngineData"                        },
	{  16625, "SavegameEffectResource2"                         },
	{  16626, "SavegameEffectStartingID"                        },
	{  16627, "SavegameEffectFlags"                             },

	{  16636, "SavegameAIMaster"                                },
	{  16630, "SavegameEventQueue"                              },
	{  16631, "SavegameEventDay"                                },
	{  16632, "SavegameEventTime"                               },
	{  16633, "SavegameEventCallerID"                           },
	{  16634, "SavegameEventTargetID"                           },
	{  16635, "SavegameEventID"                                 },

	{  16640, "SavegameDataarray"                               },
	{  16641, "SavegameDataarrayInt"                            },
	{  16642, "SavegameDataarrayFloat"                          },
	{  16643, "SavegameDataarrayBool"                           },
	{  16644, "SavegameDataarrayOID"                            },
	{  16645, "SavegameDataarrayString"                         },
	{  16646, "SavegameDataarrayVector"                         },
	{  16647, "SavegameDataarrayQuaternion"                     },

	{  16650, "SavegameEventScript"                             },
	{  16651, "SavegameEventSimpleValue"                        },

	{  16670, "SavegameScriptEventType"                         },
	{  16671, "SavegameScriptEventCreator"                      },
	{  16672, "SavegameScriptEventTarget"                       },
	{  16673, "SavegameScriptEventData"                         },
	{  16674, "SavegameScriptEventScriptName"                   },
	{  16675, "SavegameScriptEventResourceList"                 },

	{  16700, "SavegameWorldTimer"                              },
	{  16701, "SavegameWorldTimerDay"                           },
	{  16702, "SavegameWorldTimerTime"                          },

	{  16710, "SavegameWaypointMapNote"                         },
	{  16711, "SavegameWaypointMapNoteEnabled"                  },
	{  16712, "SavegameWaypointMapNoteText"                     },
	{  16713, "SavegameWaypointMapNoteType"                     },
	{  16714, "SavegameWaypointMapNoteLocText"                  },

	{  16720, "SavegameCurrentCommand"                          },
	{  16721, "SavegameCommandList"                             },
	{  16722, "SavegameCommandCommandid"                        },
	{  16723, "SavegameCommandID"                               },
	{  16724, "SavegameCommandStatic"                           },
	{  16725, "SavegameCommandData"                             },
	{  16726, "SavegameCommandPlayerIssued"                     },

	{  16730, "SavegameSubactionList"                           },
	{  16731, "SavegameSubactionID"                             },
	{  16732, "SavegameSubactionCoreSubaction"                  },
	{  16733, "SavegameSubactionCoreInterruptable"              },
	{  16734, "SavegameSubactionTimeIndex"                      },
	{  16735, "SavegameSubactionLastTimeIndex"                  },
	{  16736, "SavegameSubactionLength"                         },
	{  16737, "SaveNameSubactionStartTime"                      },
	{  16738, "SavegameSubactionData"                           },

	{  16740, "SavegameCurrentActionQueue"                      },

	{  16750, "SavegameAOEAbilityID"                            },
	{  16751, "SavegameAOEFlags"                                },
	{  16752, "SavegameAOEStationary"                           },

	{  16770, "SavegameBuildNumber"                             },
	{  16771, "SavegameSaveVersionInternal"                     },

	{  16780, "SavegameWorldmap"                                },
	{  16781, "SavegameWorldmapPrimaryMap"                      },
	{  16782, "SavegameWorldmapSecondaryMap"                    },
	{  16783, "SavegameWorldmapMapList"                         },
	{  16784, "SavegameWorldmapMapTag"                          },
	{  16785, "SavegameWorldmapMapPlayerLoc"                    },
	{  16786, "SavegameWorldmapMapPinList"                      },
	{  16787, "SavegameWorldmapMapPinTag"                       },
	{  16788, "SavegameWorldmapMapPinState"                     },
	{  16789, "SavegameWorldmapMapPinRecentlyActivated"         },
	{  16790, "SavegameWorldmapGUIStatus"                       },
	{  16791, "SavegameWorldmapLastPinClicked"                  },
	{  16792, "SavegameWorldmapMapPinActivatedPreviously"       },
	{  16793, "SavegameWorldmapMapPinLastState"                 },
	{  16794, "SavegameWorldmapTravelPointPosX"                 },
	{  16795, "SavegameWorldmapTravelPointPosY"                 },
	{  16796, "SavegameWorldmapMapTravelPathBefore"             },
	{  16797, "SavegameWorldmapMapTravelPathAfter"              },
	{  16798, "SavegameWorldmapMapPinName"                      },

	{  16800, "SavegameMetaAreaName"                            },
	{  16801, "SavegameMetaTimePlayed"                          },
	{  16802, "SavegameMetaLevel"                               },
	{  16803, "SavegameMetaClass"                               },
	{  16804, "SavegameMetaGender"                              },
	{  16805, "SavegameMetaRace"                                },
	{  16806, "SavegameMetaBackground"                          },
	{  16807, "SavegameMetaName"                                },
	{  16808, "SavegameMetaSaveName"                            },

	{  16818, "SavegameTacticEntryTargetObjectID"               },
	{  16819, "SavegameTacticEntryConditionObjectID"            },
	{  16820, "SavegamePartyTacticsItemAbilities"               },
	{  16821, "SavegameTacticsHasTable"                         },
	{  16822, "SavegameTacticsTable"                            },
	{  16823, "SavegameTacticsEnabled"                          },
	{  16824, "SavegameTacticsList"                             },
	{  16825, "SavegameTacticEntryEnabled"                      },
	{  16826, "SavegameTacticEntryTarget"                       },
	{  16827, "SavegameTacticEntryCondition"                    },
	{  16828, "SavegameTacticEntryCommand"                      },
	{  16829, "SavegameTacticEntryCommandParam"                 },
	{  16830, "SavegameTacticEntryTargetTag"                    },
	{  16831, "SavegameTacticEntryConditionTag"                 },
	{  16832, "SavegameTacticsDirty"                            },
	{  16833, "SavegameTacticsPresetType"                       },
	{  16834, "SavegameTacticsPresetIndex"                      },
	{  16835, "SavegameTacticsPresetList"                       },
	{  16836, "SavegameTacticsCustomList"                       },
	{  16837, "SavegameTacticEntryCommandItemTag"               },
	{  16838, "SavegameTacticEntryCommandItemResRef"            },

	{  16840, "SavegamePlotActions"                             },
	{  16841, "SavegamePlotActionsEnabled"                      },
	{  16842, "SavegamePlotActionsCurrentSet"                   },
	{  16843, "SavegamePlotActionsList"                         },
	{  16844, "SavegamePlotActionID"                            },
	{  16845, "SavegamePlotActionState"                         },
	{  16846, "SavegamePlotActionCount"                         },
	{  16847, "SavegamePlotActionUpdated"                       },

	{  16900, "SavegameSoundTag"                                },
	{  16901, "SavegameSoundActive"                             },
	{  16902, "SavegameSoundName"                               },
	{  16903, "SavegameSoundXPosition"                          },
	{  16904, "SavegameSoundYPosition"                          },
	{  16905, "SavegameSoundZPosition"                          },
	{  16906, "SavegameSoundXOrientation"                       },
	{  16907, "SavegameSoundYOrientation"                       },
	{  16908, "SavegameSoundZOrientation"                       },
	{  16909, "SavegameSoundWOrientation"                       },
	{  16910, "SavegameSoundVolume"                             },
	{  16911, "SavegameSoundPitch"                              },
	{  16912, "SavegameSoundFadeIn"                             },
	{  16913, "SavegameSoundFadeOut"                            },
	{  16914, "SavegameSoundMaxDistanceMult"                    },
	{  16915, "SavegameSoundConeInside"                         },
	{  16916, "SavegameSoundConeOutside"                        },
	{  16917, "SavegameSoundConeVolume"                         },
	{  16918, "SavegameSoundPriority"                           },
	{  16919, "SavegameSoundOccludable"                         },

	{  16950, "SavegamePlayerMorph"                             },
	{  16951, "SavegamePlayerSoundSet"                          },
	{  16952, "SavegameDefaultSoundSet"                         },

	{  16960, "SavegameAddinName"                               },

	{  16970, "SavegameStorySoFarEventList"                     },
	{  16971, "SavegameStorySoFarEventID"                       },
	{  16972, "SavegameStorySoFarGameTime"                      },
	{  16973, "SavegameStorySoFarUTC"                           },
	{  16974, "SavegameStorySoFarScreenshot"                    },
	{  16975, "SavegameStorySoFarLevelUpList"                   },

	{  16976, "SavegameStorySoFarArea"                          },
	{  16977, "SavegameStorySoFarLevel"                         },
	{  16978, "SavegameStorySoFarMoney"                         },
	{  16979, "SavegameStorySoFarCurrentHealth"                 },
	{  16980, "SavegameStorySoFarTotalHealth"                   },
	{  16981, "SavegameStorySoFarCurrentStamina"                },
	{  16982, "SavegameStorySoFarTotalStamina"                  },
	{  16983, "SavegameStorySoFarCurrentXP"                     },
	{  16984, "SavegameStorySoFarSpellList"                     },
	{  16985, "SavegameStorySoFarTalentList"                    },
	{  16986, "SavegameStorySoFarSkillList"                     },
	{  16987, "SavegameStorySoFarAttributeList"                 },
	{  16988, "SavegameStorySoFarAttributeBase"                 },
	{  16989, "SavegameStorySoFarAttributeModifier"             },
	{  16990, "SavegameStorySoFarEquipmentList"                 },
	{  16991, "SavegameStorySoFarEquipmentSlotID"               },
	{  16992, "SavegameStorySoFarEquipmentResRef"               },
	{  16993, "SavegameStorySoFarEquipmentStackSize"            },
	{  16994, "SavegameStorySoFarItemProperty"                  },
	{  16995, "SavegameStorySoFarItemPower"                     },
	{  16996, "SavegameStorySoFarItemData"                      },

	{  17000, "ScriptVarTable"                                  },
	{  17001, "ScriptVarTableName"                              },
	{  17002, "ScriptVarTableType"                              },
	{  17003, "ScriptVarTableValue"                             },

	{  17100, "CampaignCIFEntryAreaList"                        },
	{  17101, "CampaignCIFEntryArea"                            },
	{  17102, "CampaignCIFEntryPosition"                        },
	{  17103, "CampaignCIFEntryOrientation"                     },
	{  17104, "CampaignCIFEntryScript"                          },
	{  17105, "CampaignCIFEntryClientScript"                    },
	{  17106, "CampaignCIFDisplayNameENUS"                      },
	{  17107, "CampaignCIFDisplayNameFRFR"                      },
	{  17108, "CampaignCIFDisplayNameDEDE"                      },
	{  17109, "CampaignCIFDisplayNamePLPL"                      },
	{  17110, "CampaignCIFDisplayNameRURU"                      },
	{  17111, "CampaignCIFDisplayNameITIT"                      },
	{  17112, "CampaignCIFDisplayNameESES"                      },
	{  17113, "CampaignCIFDisplayNameHUHU"                      },
	{  17114, "CampaignCIFDisplayNameCSCZ"                      },
	{  17115, "CampaignCIFDescriptionENUS"                      },
	{  17116, "CampaignCIFDescriptionFRFR"                      },
	{  17117, "CampaignCIFDescriptionDEDE"                      },
	{  17118, "CampaignCIFDescriptionPLPL"                      },
	{  17119, "CampaignCIFDescriptionRURU"                      },
	{  17120, "CampaignCIFDescriptionITIT"                      },
	{  17121, "CampaignCIFDescriptionESES"                      },
	{  17122, "CampaignCIFDescriptionHUHU"                      },
	{  17123, "CampaignCIFDescriptionCSCZ"                      },
	{  17124, "CampaignCIFPackagesList"                         },

	{  19000, "TalkBucketList"                                  },
	{  19001, "TalkStringList"                                  },
	{  19002, "TalkStringID"                                    },
	{  19003, "TalkString"                                      },

	{  19004, "HuffTalkStringID"                                },
	{  19005, "HuffTalkStringBitOffset"                         },
	{  19006, "HuffTalkStringList"                              },
	{  19007, "HuffTalkStringHuffTree"                          },
	{  19008, "HuffTalkStringBitStream"                         },

	{  20000, "PlaceableStatesList"                             },

	{  21000, "VFXChildList"                                    },
	{  21001, "VFXObjectID"                                     },
	{  21002, "VFXEmitterInitialRotationRange"                  },
	{  21003, "VFXOrientation"                                  },
	{  21004, "VFXRoot"                                         },
	{  21005, "VFXEmitterMeshParticleRollAxis"                  },
	{  21006, "VFXType"                                         },
	{  21007, "VFXObjectVisible"                                },
	{  21008, "VFXEmitterMeshParticleUpAxis"                    },
	{  21009, "VFXKeyframe"                                     },
	{  21010, "VFXValue"                                        },
	{  21011, "VFXEmitterName"                                  },
	{  21012, "VFXEmitterType"                                  },
	{  21013, "VFXEmitterOrientationBehaviour"                  },
	{  21014, "VFXEmitterUpdateOnlyWhenVisible"                 },
	{  21015, "VFXEmitterLinkParticlesTogether"                 },
	{  21016, "VFXEmitterMaterialLibrary"                       },
	{  21017, "VFXEmitterMaterialObject"                        },
	{  21018, "VFXEmitterBirthrate"                             },
	{  21019, "VFXEmitterBirthrateRange"                        },
	{  21020, "VFXEmitterBirthrateInParticlesPerMeter"          },
	{  21021, "VFXEmitterInitialSpeed"                          },
	{  21022, "VFXEmitterInitialSpeedRange"                     },
	{  21023, "VFXEmitterAcceleration"                          },
	{  21024, "VFXEmitterGravityMultiplier"                     },
	{  21025, "VFXEmitterLife"                                  },
	{  21026, "VFXEmitterLifeRange"                             },
	{  21027, "VFXEmitterScaleRange"                            },
	{  21028, "VFXEmitterSpreadX"                               },
	{  21029, "VFXEmitterSpreadY"                               },
	{  21030, "VFXEmitterInitialRotationSpeed"                  },
	{  21031, "VFXEmitterInitialRotationSpeedRange"             },
	{  21032, "VFXEmitterRotationalAcceleration"                },
	{  21033, "VFXEmitterRandomInitialRotation"                 },
	{  21034, "VFXEmitterParticleInheritance"                   },
	{  21035, "VFXEmitterInheritVelocityInsteadOfPosition"      },
	{  21036, "VFXEmitterParticlesAffectedByWind"               },
	{  21037, "VFXEmitterEnableParticleCollisions"              },
	{  21038, "VFXEmitterPhysicsObjectSpawn"                    },
	{  21039, "VFXEmitterPhysicsEmitter"                        },
	{  21040, "VFXEmitterMovementSpreadX"                       },
	{  21041, "VFXEmitterMovementSpreadY"                       },
	{  21042, "VFXEmitterMovementSpreadUpdateDelay"             },
	{  21043, "VFXEmitterTargetName"                            },
	{  21044, "VFXEmitterTargetAttraction"                      },
	{  21045, "VFXEmitterTargetRadius"                          },
	{  21046, "VFXEmitterSpawnDirectionTracksTarget"            },
	{  21047, "VFXEmitterKillParticleWhenTargetHit"             },
	{  21048, "VFXEmitterParticlesFollowPath"                   },
	{  21049, "VFXEmitterFlipbookType"                          },
	{  21050, "VFXEmitterFlipbookFramesPerSecond"               },
	{  21051, "VFXEmitterFlipbookRows"                          },
	{  21052, "VFXEmitterFlipbookColumns"                       },
	{  21053, "VFXEmitterFlipbookRandomStartFrame"              },
	{  21054, "VFXEmitterAlphaMultiplier"                       },
	{  21055, "VFXEmitterColorMultiplier"                       },
	{  21056, "VFXEmitterScaleMultiplier"                       },
	{  21057, "VFXEmitterInfiniteLife"                          },
	{  21058, "VFXEmitterChunkyModelName"                       },
	{  21059, "VFXEmitterInitialRotation"                       },

	{  21060, "VFXCrustNodeName"                                },
	{  21061, "VFXCrustNodeRealName"                            },
	{  21062, "VFXCrustNodeCrustHookID"                         },
	{  21063, "VFXGeometryFileName"                             },

	{  21064, "VFXEmitterAgent"                                 },
	{  21065, "VFXUseVariationTint"                             },

	{  21070, "VFXDummyName"                                    },

	{  21080, "VFXGeometryName"                                 },
	{  21081, "VFXGeometryScale"                                },

	{  21090, "VFXTargetName"                                   },
	{  21100, "VFXModelName"                                    },
	{  21101, "VFXModelResourcetype"                            },
	{  21102, "VFXModelAnimationName"                           },
	{  21110, "VFXCreatureName"                                 },
	{  21111, "VFXCreatureURI"                                  },

	{  21120, "VFXRelativePositionX"                            },
	{  21121, "VFXRelativePositionY"                            },
	{  21122, "VFXRelativePositionZ"                            },
	{  21123, "VFXRelativeOrientationX"                         },
	{  21124, "VFXRelativeOrientationY"                         },
	{  21125, "VFXRelativeOrientationZ"                         },

	{  21130, "VFXImpactLength"                                 },
	{  21131, "VFXDurationLength"                               },
	{  21132, "VFXCessationLength"                              },
	{  21133, "VFXCustomLength"                                 },
	{  21134, "VFXCustomName"                                   },

	{  21140, "VFXAgemapColorR"                                 },
	{  21141, "VFXAgemapColorG"                                 },
	{  21142, "VFXAgemapColorB"                                 },
	{  21143, "VFXAgemapColorA"                                 },
	{  21144, "VFXAgemapScaleX"                                 },
	{  21145, "VFXAgemapScaleY"                                 },
	{  21146, "VFXAgemapRotationalSpeedMultiplier"              },

	{  21150, "VFXEvent"                                        },
	{  21151, "VFXEventTime"                                    },
	{  21152, "VFXEventType"                                    },
	{  21153, "VFXEventID"                                      },
	{  21154, "VFXEventTargetSystem"                            },

	{  21160, "VFXEmitterVolumeSpawnType"                       },
	{  21161, "VFXEmitterVolumeSpawnSelectedPartName"           },
	{  21162, "VFXEmitterVolumeSpawnArbitraryVolumeName"        },
	{  21163, "VFXEmitterCollisionType"                         },
	{  21164, "VFXEmitterBounceValue"                           },
	{  21165, "VFXEmitterVolumeSpawnWithinVolume"               },
	{  21166, "VFXEmitterVolumeSpawnInvertNormals"              },

	{  21170, "VFXEmitterColorMultiplierR"                      },
	{  21171, "VFXEmitterColorMultiplierG"                      },
	{  21172, "VFXEmitterColorMultiplierB"                      },

	{  21173, "VFXSplatAgemapColorR"                            },
	{  21174, "VFXSplatAgemapColorG"                            },
	{  21175, "VFXSplatAgemapColorB"                            },
	{  21176, "VFXSplatAgemapColorA"                            },
	{  21177, "VFXSplatAgemapScaleX"                            },
	{  21178, "VFXSplatAgemapScaleY"                            },

	{  21180, "VFXFileObjectVersion"                            },

	{  21181, "VFXEmitterSplatAlphaMultiplier"                  },
	{  21182, "VFXEmitterSplatColorMultiplierR"                 },
	{  21183, "VFXEmitterSplatColorMultiplierG"                 },
	{  21184, "VFXEmitterSplatColorMultiplierB"                 },

	{  21185, "VFXEmitterVolumeSpawnPrimitiveMeshType"          },
	{  21186, "VFXEmitterVolumeSpawnPrimitiveBoxMin"            },
	{  21187, "VFXEmitterVolumeSpawnPrimitiveBoxMax"            },
	{  21188, "VFXEmitterVolumeSpawnPrimitiveSphereR"           },
	{  21189, "VFXEmitterVolumeSpawnPrimitiveCylinderR"         },
	{  21190, "VFXEmitterVolumeSpawnPrimitiveCylinderH"         },
	{  21191, "VFXEmitterVolumeSpawnPrimitiveCylinderAxis"      },
	{  21192, "VFXEmitterVolumeSpawnUseVolumeNormal"            },

	{  21193, "VFXEmitterWorldAxisAccelerationX"                },
	{  21194, "VFXEmitterWorldAxisAccelerationY"                },
	{  21195, "VFXEmitterWorldAxisAccelerationZ"                },

	{  21196, "VFXRange"                                        },

	{  21197, "VFXEmitterAxisAccelerationSpace"                 },
	{  21198, "VFXEmitterUVDistributionsize"                    },

	{  21210, "VFXEmitterGroupName"                             },

	{  21220, "VFXRemoteMaterialTintR"                          },
	{  21221, "VFXRemoteMaterialTintG"                          },
	{  21222, "VFXRemoteMaterialTintB"                          },
	{  21223, "VFXRemoteMaterialTintA"                          },
	{  21224, "VFXRemoteMaterialFresnelFalloff"                 },
	{  21225, "VFXRemoteMaterialInvertFresnel"                  },
	{  21226, "VFXRemoteMaterialAlpha"                          },
	{  21227, "VFXRemoteMaterialDecalName"                      },

	{  22000, "WndRoot"                                         },
	{  22001, "WndResRef"                                       },
	{  22002, "WndRadius"                                       },

	{  22003, "WndStrength"                                     },
	{  22004, "WndDirection"                                    },
	{  22005, "WndRadiusFalloff"                                },

	{  22010, "WndGustMinStrength"                              },
	{  22011, "WndGustMaxStrength"                              },
	{  22012, "WndGustMinDuration"                              },
	{  22013, "WndGustMaxDuration"                              },

	{  22014, "WndGustFrequency"                                },

	{  22020, "WndTreeNumWindMatrices"                          },
	{  22021, "WndTreeNumLeafAngles"                            },
	{  22022, "WndTreeResponse"                                 },
	{  22023, "WndTreeResponseLimit"                            },
	{  22024, "WndTreeMaxBendAngle"                             },
	{  22025, "WndTreeBranchExponent"                           },
	{  22026, "WndTreeLeafExponent"                             },

	{  22027, "WndTreeBranchOscillationX"                       },
	{  22028, "WndTreeBranchOscillationY"                       },
	{  22029, "WndTreeLeafRocking"                              },
	{  22030, "WndTreeLeafRustling"                             },

	{  22031, "WndClothResponse"                                },
	{  22032, "WndClothResponseLmt"                             },
	{  22033, "WndClothStrength"                                },
	{  22034, "WndClothGustStrengthMin"                         },
	{  22035, "WndClothGustStrengthMax"                         },
	{  22036, "WndClothGustDurationMin"                         },
	{  22037, "WndClothGustDurationMax"                         },
	{  22038, "WndClothGustIntervalMin"                         },
	{  22039, "WndClothGustIntervalMax"                         },
	{  22040, "WndClothGustDirChange"                           },
	{  22041, "WndClothGustAxisRatio"                           },

	{  22500, "AtmoData"                                        },
	{  22519, "AtmoSunColor"                                    },
	{  22520, "AtmoSunIntensity"                                },
	{  22521, "AtmoTurbidity"                                   },
	{  22522, "AtmoEarthReflectance"                            },
	{  22523, "AtmoMieMultiplier"                               },
	{  22524, "AtmoRayleighMultiplier"                          },
	{  22525, "AtmoEarthInScatterPower"                         },
	{  22526, "AtmoDistanceMultiplier"                          },
	{  22527, "AtmoPhaseEccentricity"                           },
	{  22528, "AtmoAlpha"                                       },
	{  22529, "AtmoFogColor"                                    },
	{  22530, "AtmoFogIntensity"                                },
	{  22531, "AtmoFogCap"                                      },
	{  22532, "AtmoFogZenith"                                   },
	{  22533, "AtmoFogWaterIntensity"                           },
	{  22534, "AtmoFogWaterCap"                                 },
	{  22535, "AtmoFogTacticalMultiplier"                       },

	{  22600, "CloudData"                                       },
	{  22620, "CloudDensity"                                    },
	{  22621, "CloudSharpness"                                  },
	{  22622, "CloudDepth"                                      },
	{  22623, "CloudRangeMultiplier1"                           },
	{  22624, "CloudRangeMultiplier2"                           },
	{  22625, "CloudColor"                                      },

	{  22700, "MoonScale"                                       },
	{  22701, "MoonAlpha"                                       },
	{  22702, "MoonCloudAlpha"                                  },
	{  22703, "MoonRotation"                                    },

	{  23000, "MorphParts"                                      },
	{  23001, "MorphTintFileNames"                              },
	{  23002, "MorphNodes"                                      },
	{  23003, "MorphTextureName"                                },
	{  23004, "MorphTextureParam"                               },
	{  23005, "MorphVector4fParam"                              },
	{  23006, "MorphFloatParam"                                 },
	{  23007, "MorphFloatParamValue"                            },
	{  23008, "MorphName"                                       },
	{  23009, "MorphMatNodeName"                                },
	{  23010, "MorphMatParamName"                               },
	{  23011, "MorphMatParamIndex"                              },
	{  23012, "MorphMatParamValue"                              },
	{  23013, "MorphMatParamVector"                             },
	{  23014, "MorphMatParams"                                  },
	{  23015, "MorphMatVecParams"                               },
	{  23016, "MorphModelName"                                  },
	{  23017, "MorphModelValue"                                 },
	{  23018, "MorphModelParams"                                },
	{  23019, "MorphTexNodeName"                                },
	{  23020, "MorphTexParamName"                               },
	{  23021, "MorphTexName"                                    },
	{  23022, "MorphTextures"                                   },

	{  24000, "MapTag"                                          },
	{  24001, "MapType"                                         },
	{  24002, "MapPinList"                                      },
	{  24003, "MapPinState"                                     },
	{  24004, "MapPinPosX"                                      },
	{  24005, "MapPinPosY"                                      },
	{  24006, "MapPinName"                                      },
	{  24007, "MapPinTag"                                       },
	{  24008, "MapPinAreatag"                                   },
	{  24009, "MapPinTerraintype"                               },
	{  24010, "MapPinType"                                      },
	{  24011, "MapMaps"                                         },
	{  24012, "MapMapParentResRef"                              },
	{  24013, "MapPinWaypointOverride"                          },
	{  24014, "MapTrailList"                                    },
	{  24015, "MapTrailPin1Tag"                                 },
	{  24016, "MapTrailPin2Tag"                                 },
	{  24017, "MapPointList"                                    },
	{  24018, "MapPointPosX"                                    },
	{  24019, "MapPointPosY"                                    },
	{  24020, "MapPinTooltip"                                   },

	{  25000, "DepFileList"                                     },
	{  25001, "DepResRef"                                       },
	{  25002, "DepDependencyList"                               },

	{  26000, "SaveprofileBuildNumber"                          },
	{  26001, "SaveprofileInitialBuildNumber"                   },
	{  26002, "SaveprofileLastUsedProfile"                      },
	{  26003, "SaveprofileProfileList"                          },
	{  26004, "SaveprofileAccountName"                          },
	{  26005, "SaveprofileLocalAchievementData"                 },
	{  26006, "SaveprofileAchievementList"                      },
	{  26007, "SaveprofileAchievementID"                        },
	{  26008, "SaveprofileAchievementNew"                       },
	{  26009, "SaveprofileAchievementOnline"                    },
	{  26010, "SaveprofileAchievementCount"                     },
	{  26011, "SaveprofileAchievementDate"                      },

	{  26100, "SaveprofileAddinList"                            },
	{  26101, "SaveprofileOfferList"                            },
	{  26102, "SaveprofileContentName"                          },
	{  26103, "SaveprofileContentShown"                         },
	{  26104, "SaveprofileContentEnabled"                       },
	{  26105, "SaveprofileContentToken"                         },
	{  26106, "SaveprofileContentUser"                          },
	{  26107, "SaveprofileFileList"                             },
	{  26108, "SaveprofileFileName"                             },
	{  26109, "SaveprofileFileData"                             },
	{  26110, "SaveprofileFileVersion"                          },
	{  26111, "SaveprofileAddinTokenList"                       },

	{  33012, "MAOMaterial"                                     },
	{  33013, "MAODefaultSemantic"                              },
	{  33016, "MAOFloats"                                       },
	{  33002, "MAOFloatName"                                    },
	{  33003, "MAOFloatValue"                                   },
	{  33017, "MAOVectors"                                      },
	{  33004, "MAOVectorName"                                   },
	{  33005, "MAOVectorValue"                                  },
	{  33020, "MAOTextures"                                     },
	{  33010, "MAOTextureName"                                  },
	{  33011, "MAOTextureResource"                              },

	{ 250100, "CharMOP"                                         },
	{ 250101, "CharApp"                                         },
	{ 250102, "CharGender"                                      },
	{ 250103, "CharRace"                                        },
	{ 250104, "CharClass"                                       },
	{ 250105, "CharBack"                                        },
	{ 250106, "CharAttributes"                                  },
	{ 250107, "CharAbilities"                                   },
	{ 250108, "CharName"                                        },
	{ 250109, "CharHeadName"                                    },
	{ 250110, "CharAttributeID"                                 },
	{ 250111, "CharAttributePoints"                             },
	{ 250112, "CharPortrait"                                    }
};

} // End of namespace XML

#endif // XML_GFF4FIELDS_H
