/* vfs-trash-impl-gio.c generated by valac 0.10.4, the Vala compiler
 * generated from vfs-trash-impl-gio.vala, do not modify */

/*
 * Desktop Agnostic Library: Trash implementation with GIO.
 *
 * Copyright (C) 2008, 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO (desktop_agnostic_vfs_trash_gio_get_type ())
#define DESKTOP_AGNOSTIC_VFS_TRASH_GIO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO, DesktopAgnosticVFSTrashGIO))
#define DESKTOP_AGNOSTIC_VFS_TRASH_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO, DesktopAgnosticVFSTrashGIOClass))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH_GIO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO))
#define DESKTOP_AGNOSTIC_VFS_TRASH_GIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO, DesktopAgnosticVFSTrashGIOClass))

typedef struct _DesktopAgnosticVFSTrashGIO DesktopAgnosticVFSTrashGIO;
typedef struct _DesktopAgnosticVFSTrashGIOClass DesktopAgnosticVFSTrashGIOClass;
typedef struct _DesktopAgnosticVFSTrashGIOPrivate DesktopAgnosticVFSTrashGIOPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DesktopAgnosticVFSTrashGIO {
	GObject parent_instance;
	DesktopAgnosticVFSTrashGIOPrivate * priv;
};

struct _DesktopAgnosticVFSTrashGIOClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSTrashGIOPrivate {
	DesktopAgnosticVFSFile* trash;
	DesktopAgnosticVFSFileMonitor* monitor;
	guint _file_count;
};


static gpointer desktop_agnostic_vfs_trash_gio_parent_class = NULL;
static DesktopAgnosticVFSTrashIface* desktop_agnostic_vfs_trash_gio_desktop_agnostic_vfs_trash_parent_iface = NULL;

GType desktop_agnostic_vfs_trash_gio_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_VFS_TRASH_GIO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO, DesktopAgnosticVFSTrashGIOPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_TRASH_GIO_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_TRASH_GIO_FILE_COUNT
};
static void desktop_agnostic_vfs_trash_gio_on_trash_changed (DesktopAgnosticVFSTrashGIO* self, DesktopAgnosticVFSFileMonitor* monitor, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* other_file, DesktopAgnosticVFSFileMonitorEvent event_type);
static void desktop_agnostic_vfs_trash_gio_update_file_count (DesktopAgnosticVFSTrashGIO* self);
static void desktop_agnostic_vfs_trash_gio_on_trash_count (DesktopAgnosticVFSTrashGIO* self, GObject* obj, GAsyncResult* res);
static void _desktop_agnostic_vfs_trash_gio_on_trash_count_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void desktop_agnostic_vfs_trash_gio_do_empty (DesktopAgnosticVFSTrashGIO* self, GFile* dir);
static void desktop_agnostic_vfs_trash_gio_real_send_to_trash (DesktopAgnosticVFSTrash* base, DesktopAgnosticVFSFile* uri, GError** error);
static void desktop_agnostic_vfs_trash_gio_real_empty (DesktopAgnosticVFSTrash* base);
DesktopAgnosticVFSTrashGIO* desktop_agnostic_vfs_trash_gio_new (void);
DesktopAgnosticVFSTrashGIO* desktop_agnostic_vfs_trash_gio_construct (GType object_type);
static void _desktop_agnostic_vfs_trash_gio_on_trash_changed_desktop_agnostic_vfs_file_monitor_changed (DesktopAgnosticVFSFileMonitor* _sender, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event, gpointer self);
static GObject * desktop_agnostic_vfs_trash_gio_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void desktop_agnostic_vfs_trash_gio_finalize (GObject* obj);
static void desktop_agnostic_vfs_trash_gio_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);



static void desktop_agnostic_vfs_trash_gio_on_trash_changed (DesktopAgnosticVFSTrashGIO* self, DesktopAgnosticVFSFileMonitor* monitor, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* other_file, DesktopAgnosticVFSFileMonitorEvent event_type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (file != NULL);
	desktop_agnostic_vfs_trash_gio_update_file_count (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _desktop_agnostic_vfs_trash_gio_on_trash_count_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	desktop_agnostic_vfs_trash_gio_on_trash_count (self, source_object, res);
	g_object_unref (self);
}


static void desktop_agnostic_vfs_trash_gio_update_file_count (DesktopAgnosticVFSTrashGIO* self) {
	GFile* dir;
	g_return_if_fail (self != NULL);
	dir = _g_object_ref0 (G_FILE (desktop_agnostic_vfs_file_get_implementation (self->priv->trash)));
	g_file_query_info_async (dir, G_FILE_ATTRIBUTE_TRASH_ITEM_COUNT, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, _desktop_agnostic_vfs_trash_gio_on_trash_count_gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (dir);
}


static void desktop_agnostic_vfs_trash_gio_on_trash_count (DesktopAgnosticVFSTrashGIO* self, GObject* obj, GAsyncResult* res) {
	GFile* dir;
	GFileInfo* file_info;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (res != NULL);
	dir = _g_object_ref0 (G_FILE (obj));
	file_info = NULL;
	{
		GFileInfo* _tmp0_;
		GFileInfo* _tmp1_;
		_tmp0_ = g_file_query_info_finish (dir, res, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		file_info = (_tmp1_ = _tmp0_, _g_object_unref0 (file_info), _tmp1_);
		self->priv->_file_count = (guint) g_file_info_get_attribute_uint32 (file_info, G_FILE_ATTRIBUTE_TRASH_ITEM_COUNT);
		g_signal_emit_by_name ((DesktopAgnosticVFSTrash*) self, "file-count-changed");
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vfs-trash-impl-gio.vala:86: Could not update file count: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file_info);
		_g_object_unref0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file_info);
	_g_object_unref0 (dir);
}


static void desktop_agnostic_vfs_trash_gio_do_empty (DesktopAgnosticVFSTrashGIO* self, GFile* dir) {
	GFileEnumerator* files;
	GFileInfo* info;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	files = NULL;
	info = NULL;
	{
		char* attrs;
		GFileEnumerator* _tmp0_;
		GFileEnumerator* _tmp1_;
		attrs = g_strdup (G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE);
		_tmp0_ = g_file_enumerate_children (dir, attrs, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (attrs);
			goto __catch4_g_error;
		}
		files = (_tmp1_ = _tmp0_, _g_object_unref0 (files), _tmp1_);
		_g_free0 (attrs);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vfs-trash-impl-gio.vala:106: Trash error: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (info);
		_g_object_unref0 (files);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (files == NULL) {
		_g_object_unref0 (info);
		_g_object_unref0 (files);
		return;
	}
	while (TRUE) {
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		GFile* child;
		GFile* _tmp4_;
		_tmp2_ = g_file_enumerator_next_file (files, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (info);
			_g_object_unref0 (files);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (!((info = (_tmp3_ = _tmp2_, _g_object_unref0 (info), _tmp3_)) != NULL)) {
			break;
		}
		child = NULL;
		child = (_tmp4_ = g_file_get_child (dir, g_file_info_get_name (info)), _g_object_unref0 (child), _tmp4_);
		if (g_file_info_get_file_type (info) == G_FILE_TYPE_DIRECTORY) {
			desktop_agnostic_vfs_trash_gio_do_empty (self, child);
		}
		{
			g_file_delete (child, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
			}
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vfs-trash-impl-gio.vala:126: Trash error: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally5:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (child);
			_g_object_unref0 (info);
			_g_object_unref0 (files);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (child);
	}
	_g_object_unref0 (info);
	_g_object_unref0 (files);
}


static void desktop_agnostic_vfs_trash_gio_real_send_to_trash (DesktopAgnosticVFSTrash* base, DesktopAgnosticVFSFile* uri, GError** error) {
	DesktopAgnosticVFSTrashGIO * self;
	GFile* file;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSTrashGIO*) base;
	g_return_if_fail (uri != NULL);
	file = _g_object_ref0 (G_FILE (desktop_agnostic_vfs_file_get_implementation (uri)));
	g_file_trash (file, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return;
	}
	_g_object_unref0 (file);
}


static void desktop_agnostic_vfs_trash_gio_real_empty (DesktopAgnosticVFSTrash* base) {
	DesktopAgnosticVFSTrashGIO * self;
	self = (DesktopAgnosticVFSTrashGIO*) base;
	desktop_agnostic_vfs_trash_gio_do_empty (self, G_FILE (desktop_agnostic_vfs_file_get_implementation (self->priv->trash)));
}


DesktopAgnosticVFSTrashGIO* desktop_agnostic_vfs_trash_gio_construct (GType object_type) {
	DesktopAgnosticVFSTrashGIO * self = NULL;
	self = (DesktopAgnosticVFSTrashGIO*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticVFSTrashGIO* desktop_agnostic_vfs_trash_gio_new (void) {
	return desktop_agnostic_vfs_trash_gio_construct (DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO);
}


static guint desktop_agnostic_vfs_trash_gio_real_get_file_count (DesktopAgnosticVFSTrash* base) {
	guint result;
	DesktopAgnosticVFSTrashGIO* self;
	self = (DesktopAgnosticVFSTrashGIO*) base;
	result = self->priv->_file_count;
	return result;
}


static void _desktop_agnostic_vfs_trash_gio_on_trash_changed_desktop_agnostic_vfs_file_monitor_changed (DesktopAgnosticVFSFileMonitor* _sender, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event, gpointer self) {
	desktop_agnostic_vfs_trash_gio_on_trash_changed (self, _sender, file, other, event);
}


static GObject * desktop_agnostic_vfs_trash_gio_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DesktopAgnosticVFSTrashGIO * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (desktop_agnostic_vfs_trash_gio_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DESKTOP_AGNOSTIC_VFS_TRASH_GIO (obj);
	_inner_error_ = NULL;
	{
		DesktopAgnosticVFSFile* _tmp0_;
		DesktopAgnosticVFSFile* _tmp1_;
		DesktopAgnosticVFSFileMonitor* _tmp2_;
		_tmp0_ = desktop_agnostic_vfs_file_new_for_uri ("trash://", &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		self->priv->trash = (_tmp1_ = _tmp0_, _g_object_unref0 (self->priv->trash), _tmp1_);
		if (self->priv->trash == NULL) {
			g_critical ("vfs-trash-impl-gio.vala:36: trash is NULL!!!!");
		}
		self->priv->monitor = (_tmp2_ = desktop_agnostic_vfs_file_monitor (self->priv->trash), _g_object_unref0 (self->priv->monitor), _tmp2_);
		g_signal_connect_object (self->priv->monitor, "changed", (GCallback) _desktop_agnostic_vfs_trash_gio_on_trash_changed_desktop_agnostic_vfs_file_monitor_changed, self, 0);
		self->priv->_file_count = (guint) 0;
		desktop_agnostic_vfs_trash_gio_update_file_count (self);
	}
	return obj;
}


static void desktop_agnostic_vfs_trash_gio_class_init (DesktopAgnosticVFSTrashGIOClass * klass) {
	desktop_agnostic_vfs_trash_gio_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSTrashGIOPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_trash_gio_get_property;
	G_OBJECT_CLASS (klass)->constructor = desktop_agnostic_vfs_trash_gio_constructor;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_trash_gio_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_TRASH_GIO_FILE_COUNT, "file-count");
}


static void desktop_agnostic_vfs_trash_gio_desktop_agnostic_vfs_trash_interface_init (DesktopAgnosticVFSTrashIface * iface) {
	desktop_agnostic_vfs_trash_gio_desktop_agnostic_vfs_trash_parent_iface = g_type_interface_peek_parent (iface);
	iface->send_to_trash = desktop_agnostic_vfs_trash_gio_real_send_to_trash;
	iface->empty = desktop_agnostic_vfs_trash_gio_real_empty;
	iface->get_file_count = desktop_agnostic_vfs_trash_gio_real_get_file_count;
}


static void desktop_agnostic_vfs_trash_gio_instance_init (DesktopAgnosticVFSTrashGIO * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_TRASH_GIO_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_trash_gio_finalize (GObject* obj) {
	DesktopAgnosticVFSTrashGIO * self;
	self = DESKTOP_AGNOSTIC_VFS_TRASH_GIO (obj);
	_g_object_unref0 (self->priv->trash);
	_g_object_unref0 (self->priv->monitor);
	G_OBJECT_CLASS (desktop_agnostic_vfs_trash_gio_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_trash_gio_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_trash_gio_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_trash_gio_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSTrashGIOClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_trash_gio_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSTrashGIO), 0, (GInstanceInitFunc) desktop_agnostic_vfs_trash_gio_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_vfs_trash_info = { (GInterfaceInitFunc) desktop_agnostic_vfs_trash_gio_desktop_agnostic_vfs_trash_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType desktop_agnostic_vfs_trash_gio_type_id;
		desktop_agnostic_vfs_trash_gio_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSTrashGIO", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_vfs_trash_gio_type_id, DESKTOP_AGNOSTIC_VFS_TYPE_TRASH, &desktop_agnostic_vfs_trash_info);
		g_once_init_leave (&desktop_agnostic_vfs_trash_gio_type_id__volatile, desktop_agnostic_vfs_trash_gio_type_id);
	}
	return desktop_agnostic_vfs_trash_gio_type_id__volatile;
}


static void desktop_agnostic_vfs_trash_gio_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSTrashGIO * self;
	self = DESKTOP_AGNOSTIC_VFS_TRASH_GIO (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_TRASH_GIO_FILE_COUNT:
		g_value_set_uint (value, desktop_agnostic_vfs_trash_get_file_count ((DesktopAgnosticVFSTrash*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




