/*
 * libkysdk-qtwidgets's Library
 *
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Zhen Sun <sunzhen1@kylinos.cn>
 *
 */

#ifndef KTAG_H
#define KTAG_H

#include "gui_g.h"
#include <QPushButton>

namespace kdk
{
class KTagPrivate;

enum TagStyle
{
    HighlightTag,
    BoderTag,
    BaseBoderTag,
    GrayTag
};

class GUI_EXPORT KTag : public QPushButton
{
    Q_OBJECT

public:
    explicit KTag(QWidget *parent = nullptr);
    void setClosable(bool);
    bool closable();
    void setText(const QString&);
    QString text();
    void setTagStyle(TagStyle);
    TagStyle tagStyle();

protected:
    void paintEvent(QPaintEvent* event);
    QSize sizeHint() const override;

private:
    Q_DECLARE_PRIVATE(KTag)
    KTagPrivate * const d_ptr;
};
}


#endif // KTAG_H
