/* ----- encode/653x4621, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_653x4621_checksums[] = {
  "0b8bea4448ae678f4152f1aed36bd50c1d538a1a0fef1134f480b956223c1aa7",
  "045c8b06a6e1591bf38ff18e8b0f4cd7130ade473cbf7c1088c23257fca300ea",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_653x4621_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_653x4621_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_653x4621_ITEMBYTES

static void *storage_encode_653x4621_s;
static unsigned char *test_encode_653x4621_s;
static void *storage_encode_653x4621_x;
static unsigned char *test_encode_653x4621_x;
static void *storage_encode_653x4621_s2;
static unsigned char *test_encode_653x4621_s2;
static void *storage_encode_653x4621_x2;
static unsigned char *test_encode_653x4621_x2;

#define precomputed_encode_653x4621_NUM 4

static const unsigned char precomputed_encode_653x4621_s[precomputed_encode_653x4621_NUM][crypto_encode_STRBYTES] = {
  {127,196,241,102,68,91,30,143,194,226,46,97,107,172,165,94,91,68,142,22,188,177,211,46,100,186,42,201,200,210,54,118,210,228,149,117,242,209,108,223,223,246,127,126,74,44,216,161,165,101,204,183,248,130,220,21,237,26,195,144,86,191,80,34,50,157,35,227,153,120,114,243,18,54,210,47,177,67,206,220,23,60,103,56,27,188,236,28,50,78,145,7,4,19,86,156,215,37,72,111,43,231,42,42,50,54,45,41,6,204,23,143,52,231,4,186,165,213,12,54,187,202,144,160,40,119,215,38,13,168,0,230,236,251,80,155,178,10,86,110,86,243,8,13,51,224,112,36,120,149,223,182,19,223,59,99,47,71,146,167,124,211,32,199,189,227,217,220,117,78,191,91,211,239,226,75,87,25,91,104,48,188,103,19,93,4,98,176,169,187,49,254,148,178,35,44,1,106,172,104,115,34,63,131,168,64,191,150,57,56,242,20,101,235,63,202,240,104,172,214,87,153,47,190,255,189,32,225,58,174,56,214,113,130,190,7,96,4,138,245,153,86,159,128,13,248,1,42,127,133,43,210,23,207,244,147,73,55,166,190,146,146,36,135,195,178,125,13,236,195,61,132,136,113,193,160,15,48,216,219,89,16,219,209,148,200,100,45,71,14,105,158,44,163,186,102,152,191,194,18,230,194,118,56,200,69,169,54,62,90,179,115,79,46,235,15,165,113,42,225,213,34,0,168,219,53,166,156,174,204,115,218,138,191,45,237,188,44,161,59,181,20,119,97,238,43,84,110,94,96,181,255,222,193,60,184,172,193,41,210,122,119,75,77,62,119,96,228,127,59,229,172,99,78,218,55,239,186,87,189,113,175,244,205,43,122,72,217,246,155,206,11,2,206,185,83,70,219,164,243,245,241,0,14,97,243,253,109,250,23,100,79,103,23,12,211,129,188,136,248,80,121,171,209,94,168,205,143,236,56,167,0,38,25,158,27,157,14,210,20,171,80,107,39,13,35,147,97,251,225,245,190,243,196,214,129,189,180,81,228,202,216,211,94,185,251,58,183,245,221,91,69,157,33,74,221,51,105,10,118,147,219,80,241,170,65,227,225,54,133,13,22,177,169,82,102,27,145,16,130,124,155,165,48,62,85,92,217,37,106,40,64,26,57,208,23,194,68,222,153,145,35,175,232,220,57,138,171,222,55,156,222,209,155,254,58,104,15,212,66,171,86,52,253,239,114,11,106,231,104,117,239,20,22,2,44,4,75,147,69,186,95,201,156,21,80,9,209,112,206,48,238,24,112,230,69,157,240,127,211,133,2,9,223,74,165,21,130,240,144,208,146,85,142,71,196,208,162,154,141,157,43,77,26,200,20,107,103,27,70,125,224,21,190,26,155,32,118,72,248,41,40,11,99,2,13,159,201,40,127,70,85,88,145,130,1,94,71,141,188,255,159,21,251,254,138,62,161,148,72,176,7,200,29,106,137,204,78,70,156,133,21,231,123,131,142,242,154,65,101,52,33,78,231,158,95,141,17,198,75,138,201,239,42,33,242,107,90,176,45,166,27,171,163,34,83,164,138,61,253,39,210,250,63,245,3,226,57,134,144,89,35,219,251,9,212,76,184,158,1,103,58,68,244,142,121,84,48,42,128,241,68,135,88,25,104,13,21,90,213,153,153,100,0,61,215,106,123,130,38,232,237,194,195,149,142,27,86,116,219,187,233,128,45,217,173,117,194,119,195,187,226,187,221,89,195,174,183,175,73,225,221,111,18,226,73,176,223,229,32,229,253,114,10,192,122,106,131,180,94,100,190,194,92,212,243,124,175,196,178,31,16,238,103,4,174,245,207,56,67,36,114,37,181,157,154,70,124,245,122,167,56,122,240,146,94,147,48,121,25,86,128,57,155,114,4,253,225,235,133,238,89,18,196,1,160,74,32,108,154,232,62,42,52,73,178,101,168,22,126,146,19,110,226,150,84,192,236,90,112,82,129,47,246,96,126,170,56,82,52,249,244,242,223,112,46,31,90,184,234,102,250,120,141,114,77,21,90,200,30,127,234,7,132,47,97,164,169,252,67,116,254,119,245,223,73,202,119,215,150,74,16,66,228,53,79,101,162,56,13,139,87,112,101,110,212,19,120,115,117,110,226,213,245,112,30,120,108,242,91,72,86,205,27,218,13,253,227,241,62,94,18,41,2,150,14,148,201,39,92,239,51,135,243,32,217,179,233,197,215,148,51,83,185},
  {251,133,127,129,67,73,56,113,140,219,220,52,50,199,96,8,189,191,206,142,221,158,27,95,164,229,245,226,132,72,233,93,173,224,126,103,18,94,24,247,63,192,79,151,36,114,88,25,231,132,68,51,227,35,212,229,51,91,224,194,100,137,82,171,18,246,156,214,157,239,8,211,6,255,162,150,215,200,103,213,33,113,107,122,154,107,159,157,14,242,15,37,33,101,214,181,206,181,97,225,46,160,71,133,70,81,188,183,191,70,26,254,30,124,249,203,117,247,152,198,123,69,124,187,253,164,159,157,186,48,100,71,74,193,193,111,81,139,44,70,63,229,247,104,185,237,130,171,143,91,153,117,148,57,145,203,186,214,189,209,255,132,100,175,55,186,138,6,243,163,242,146,39,38,39,99,28,188,206,79,200,88,243,45,245,45,65,238,78,128,61,168,62,174,116,217,86,138,62,127,169,99,74,170,217,30,74,81,154,220,35,39,105,92,98,31,187,166,20,140,225,61,183,181,72,245,110,169,66,168,23,148,53,98,234,82,40,227,250,212,103,171,75,172,27,165,184,19,51,205,219,58,196,190,164,153,180,251,152,102,189,253,128,210,244,104,100,23,38,77,61,35,196,166,113,197,217,72,236,47,212,81,169,88,215,48,141,56,180,230,188,16,83,120,55,145,40,149,218,30,168,139,190,36,173,124,173,25,251,185,111,218,243,68,28,122,78,230,141,15,144,138,154,226,75,219,23,254,26,103,66,172,90,11,242,226,71,170,201,98,82,147,106,152,121,137,174,13,81,200,101,245,202,138,8,206,247,51,123,192,66,3,66,209,105,105,90,172,69,160,35,22,133,58,92,149,55,254,196,71,208,53,72,81,125,24,167,28,176,84,74,239,54,31,229,237,101,52,99,73,231,131,84,111,24,139,67,150,76,71,245,200,143,239,1,41,74,117,99,153,204,240,79,127,195,1,102,146,242,115,50,131,181,247,105,11,203,204,251,191,6,204,127,3,241,136,210,46,47,248,14,225,180,103,117,102,30,42,221,103,159,89,33,120,54,107,174,39,127,153,243,147,204,201,19,145,17,65,5,140,89,119,165,122,65,156,211,43,213,252,107,127,250,12,8,151,33,240,97,171,52,155,51,102,18,194,171,95,131,7,33,63,189,7,144,172,192,139,33,118,23,179,225,22,71,242,5,21,192,158,204,204,232,253,207,19,230,191,235,197,150,45,244,57,215,102,134,219,202,33,48,197,232,118,27,252,239,173,82,212,225,117,63,77,192,252,112,249,55,219,105,109,165,187,186,190,108,185,185,24,213,248,110,132,95,33,242,7,28,67,32,25,42,149,91,251,251,151,7,231,157,129,235,154,3,222,84,44,163,8,155,75,255,45,13,154,254,139,115,180,246,57,54,110,235,56,216,143,3,112,17,141,5,184,153,43,63,185,55,88,183,13,112,69,207,150,225,235,230,236,190,210,39,136,225,157,159,200,203,203,165,144,109,201,218,194,208,222,219,81,255,243,7,21,191,230,49,33,72,170,34,192,43,153,131,92,227,38,172,42,80,177,40,81,161,248,199,191,13,96,198,193,228,62,127,157,241,106,81,174,178,253,245,189,47,221,17,77,219,234,107,95,204,143,128,110,81,171,239,148,220,9,21,67,33,148,158,20,137,61,53,117,149,171,246,191,15,90,205,26,66,244,95,188,202,180,127,113,109,42,52,82,76,185,47,114,191,101,155,11,2,203,138,88,102,191,237,251,119,152,139,208,106,0,206,161,99,86,120,72,98,39,41,82,70,238,152,209,32,203,84,60,91,34,43,231,198,220,144,143,174,7,197,43,224,150,233,107,161,182,90,41,141,187,7,8,219,48,65,128,144,133,8,162,89,90,88,155,245,166,195,17,45,213,59,6,13,138,157,189,149,72,69,197,247,204,222,17,19,75,24,71,120,150,214,171,74,137,133,73,208,117,51,150,55,79,91,167,154,203,231,131,197,66,12,131,49,171,93,68,86,145,211,27,181,227,30,108,196,84,249,90,28,44,177,28,176,47,189,158,194,230,150,248,91,223,178,118,59,227,47,145,101,253,46,130,212,218,190,82,163,119,246,250,126,235,120,201,53,196,118,112,122,173,85,196,239,89,53,240,183,124,51,239,16,214,124,206,169,41,132,189,251,78,206,14,172,182,30,185,241,0,183,134,142,48,49,203,90,98,216,68,171,84,35,3,54,0,62,77,113,100,43,53},
  {141,34,129,175,57,230,213,180,28,71,92,5,58,251,117,0,116,135,35,40,130,146,38,192,30,56,148,83,103,124,203,159,182,230,209,251,31,50,24,207,5,205,181,1,232,18,107,16,119,227,150,173,198,86,213,179,101,12,238,199,176,79,240,88,15,196,42,44,122,64,213,166,3,194,96,216,55,193,15,16,33,68,189,81,205,173,37,216,251,19,198,121,229,131,251,42,13,205,70,99,139,215,2,228,185,128,134,158,37,168,199,50,244,4,202,160,205,148,255,198,113,83,199,144,226,46,81,7,175,141,153,110,193,165,172,143,164,74,16,22,49,1,27,124,151,149,222,240,71,32,21,50,237,30,200,125,238,217,184,172,46,78,157,237,146,148,236,96,42,183,9,236,166,246,247,211,118,123,114,218,5,179,206,220,187,146,173,27,28,103,70,110,56,32,21,232,24,128,30,220,232,105,146,114,33,239,139,179,222,17,225,52,9,47,74,164,9,0,39,193,232,187,87,229,192,250,216,205,85,137,118,124,147,32,153,118,81,238,82,252,169,33,58,140,151,100,124,212,42,142,139,159,109,58,221,191,192,64,142,203,187,132,37,133,2,213,115,110,177,37,232,70,247,28,187,131,180,229,31,87,246,76,100,248,165,14,226,143,99,29,53,35,17,60,92,99,9,84,201,202,61,57,162,122,134,116,145,151,208,84,200,221,57,49,119,81,198,65,104,199,97,246,196,10,28,160,168,149,24,29,111,49,22,27,105,102,23,97,166,146,175,221,14,145,62,180,236,81,0,142,42,95,105,183,8,159,115,105,2,66,181,190,216,144,211,118,16,187,165,128,225,73,214,72,193,234,231,101,223,45,0,37,3,61,127,199,93,221,230,144,115,97,85,127,95,167,145,144,168,132,52,27,140,34,207,213,184,228,174,72,41,129,155,64,120,175,219,255,170,149,141,187,202,138,153,76,137,18,11,171,206,4,177,192,138,121,169,254,61,0,34,225,11,253,70,13,127,45,218,29,76,251,25,200,245,228,54,61,44,55,190,113,42,12,198,129,92,137,128,65,192,153,124,253,152,167,169,6,3,130,28,38,185,54,183,239,82,170,164,209,230,213,76,76,104,186,221,221,193,236,145,114,94,4,254,178,83,111,43,224,155,175,97,81,188,239,70,131,26,77,132,48,2,174,63,254,70,204,189,180,61,152,33,199,210,37,29,205,61,148,181,207,199,174,47,252,249,145,40,222,113,155,139,164,149,77,154,219,14,255,158,89,86,8,116,144,215,124,51,211,154,243,2,246,250,6,213,112,171,74,254,52,234,196,39,202,72,1,34,247,43,63,247,149,126,96,211,194,3,149,167,40,18,192,181,193,63,53,230,186,238,61,148,200,95,68,171,38,27,144,16,45,251,149,169,228,187,44,146,101,3,191,171,87,40,109,27,23,0,161,138,36,20,45,181,3,226,61,78,200,239,179,69,243,21,206,77,218,7,88,92,185,78,58,251,34,38,47,101,130,211,32,19,219,10,189,58,23,128,230,227,175,44,72,86,88,48,159,251,196,129,192,251,83,81,59,233,120,211,73,200,38,151,182,231,114,26,23,65,213,125,107,57,28,28,129,107,48,31,102,151,246,252,115,80,119,167,187,177,239,103,151,138,35,38,101,46,25,201,10,98,145,193,153,159,28,198,148,185,146,53,3,4,237,48,211,73,127,195,246,91,214,250,133,145,216,17,163,169,235,118,110,58,183,61,202,210,187,47,225,237,66,241,104,228,190,197,219,220,140,137,161,203,226,10,192,66,93,230,172,6,227,7,26,131,253,182,14,31,59,104,220,44,191,172,66,219,20,4,147,170,45,145,46,168,66,165,227,117,242,118,147,167,227,112,81,59,38,94,62,11,149,155,58,88,81,127,158,148,36,189,99,122,56,61,198,34,31,87,107,214,185,67,116,78,80,220,230,34,150,160,3,203,189,204,249,82,194,53,12,168,128,118,243,111,212,97,59,15,38,236,44,166,222,42,120,131,203,179,163,17,51,213,48,126,171,20,50,126,249,21,38,201,255,33,74,226,201,93,187,169,214,75,89,140,56,74,105,95,198,42,132,195,149,39,186,142,148,153,242,38,78,71,173,111,175,50,91,125,233,189,138,211,179,204,155,253,142,132,220,80,149,192,153,154,222,93,86,95,109,249,2,147,9,19,17,149,245,133,120,67,219,143,155,34,229,98,19,165,222,178,69,144,140},
  {35,35,117,118,151,180,53,163,92,160,204,78,104,215,164,110,109,218,241,66,21,188,42,142,34,217,27,47,95,223,192,48,244,107,102,134,175,34,83,129,81,241,4,138,167,247,149,46,108,58,96,70,146,117,218,189,3,113,213,43,211,68,174,114,87,42,71,22,160,229,152,227,213,116,180,230,113,80,18,99,128,170,35,162,206,20,219,153,129,224,98,48,9,173,153,4,251,102,28,154,90,59,201,205,14,95,82,51,10,8,30,49,151,127,105,54,18,204,250,143,83,109,69,36,3,64,27,160,152,8,143,124,107,12,207,32,54,247,0,92,9,107,182,73,95,196,103,230,77,29,174,101,91,131,108,85,193,215,103,22,242,64,124,32,81,23,206,229,39,191,162,223,123,61,177,43,137,82,157,186,189,9,179,74,242,106,27,121,173,227,221,45,12,2,12,206,55,143,4,102,181,117,5,107,194,252,138,48,231,106,104,148,192,90,56,106,25,20,208,31,199,19,37,86,59,110,43,54,180,201,13,73,31,76,234,168,34,61,56,108,17,130,231,254,27,87,196,232,238,18,98,252,127,247,252,245,5,253,161,29,4,162,222,89,42,82,103,243,24,56,147,200,114,134,103,92,146,231,64,203,254,2,175,190,29,49,215,27,246,169,62,50,33,30,173,165,120,196,214,237,140,164,13,149,203,151,205,208,169,160,120,222,73,235,34,4,115,250,104,53,58,3,75,226,53,38,65,202,17,90,248,118,156,41,216,31,124,106,4,174,28,15,171,177,110,214,32,204,159,201,229,189,133,54,165,111,185,33,221,33,183,27,120,18,133,220,49,192,119,181,252,58,111,154,96,248,203,109,145,239,137,5,86,49,196,100,169,141,185,121,237,192,90,117,156,0,19,90,147,62,43,66,57,90,9,143,83,198,254,153,116,238,212,179,147,179,95,181,15,81,143,125,201,172,155,234,164,25,74,241,128,140,168,173,39,69,231,243,15,191,221,192,234,140,37,11,195,121,37,37,110,2,221,59,155,137,104,82,115,215,141,197,96,41,181,130,120,233,110,239,238,151,231,49,3,241,145,33,3,106,75,149,9,96,165,245,188,97,202,54,128,96,206,241,173,106,11,57,225,195,131,210,221,214,187,168,187,30,72,52,245,230,8,0,233,105,9,32,77,200,98,155,39,45,185,91,51,82,125,171,56,238,65,184,234,239,124,63,146,169,73,21,33,92,236,116,57,97,66,55,61,173,14,44,192,103,164,87,23,253,181,139,39,251,146,226,120,250,155,119,222,92,123,100,205,52,92,146,126,195,5,71,156,69,174,141,189,97,202,41,91,178,29,50,195,131,10,126,182,221,113,195,161,64,64,179,98,229,190,128,193,127,166,212,197,15,192,16,63,84,204,37,112,144,142,236,157,206,29,90,236,200,141,166,167,217,117,235,141,54,241,22,140,9,39,5,126,41,35,177,32,133,251,228,32,41,199,168,14,168,148,55,192,209,16,2,25,178,9,76,82,53,56,167,11,242,65,246,188,162,48,209,73,67,181,36,120,137,119,187,249,138,204,68,237,68,157,175,43,175,139,21,223,210,251,134,233,25,96,231,207,80,147,40,191,232,205,250,96,169,81,155,45,105,107,220,131,229,150,55,202,156,18,70,233,131,84,164,60,124,61,83,213,24,32,156,145,185,126,20,114,157,236,61,184,106,48,15,86,163,38,105,157,20,0,53,238,121,43,38,164,180,141,110,147,251,79,29,48,250,71,52,214,162,40,97,190,59,97,198,179,228,109,171,13,41,30,131,122,204,162,65,87,69,243,216,26,49,222,69,45,64,200,161,254,206,224,128,44,198,64,235,123,208,116,204,41,106,181,143,191,210,113,20,99,63,54,161,181,38,220,126,26,254,129,81,95,151,200,30,65,169,40,157,203,125,143,40,118,156,50,169,247,206,240,225,80,136,5,25,85,229,112,195,54,193,241,159,253,35,154,169,110,58,246,198,247,203,187,132,207,242,145,136,178,127,114,6,33,79,183,205,142,243,123,146,236,213,192,158,30,250,64,227,163,237,130,180,130,23,61,163,221,18,210,144,195,16,132,98,195,200,45,5,175,7,30,79,59,37,241,246,215,18,135,167,82,134,175,74,71,234,85,246,168,158,125,231,105,194,36,33,63,177,127,181,181,237,234,66,153,15,65,93,52,210,180,81,254,82,20,1,36,211,221,145,70,150,16,71,57,41,18,244},
} ;

static const int16_t precomputed_encode_653x4621_x[precomputed_encode_653x4621_NUM][crypto_encode_ITEMS] = {
  {-6296,-3057,-31961,16334,18370,-26522,-10828,-23570,-8471,24409,-23954,-14564,-12045,-16204,-5722,-1641,-9779,9378,9565,9233,27965,10007,22429,-7702,17069,-3793,31565,1133,3041,24863,24648,1410,25787,-23793,-18245,-30434,-13364,-16230,-32294,22198,8323,552,11605,10926,-2140,18714,-27250,27214,22369,-22608,9467,1073,26648,-5188,29701,-9265,-17746,-32297,-2787,19482,29612,-4306,-15877,-25915,3530,14436,-3229,-17380,7091,16986,-29532,-32286,22242,-692,14677,-30835,4091,4202,29729,-6531,-27306,7137,-29290,15409,19314,-25751,22196,-22924,-26768,-18266,-3249,27686,17123,-19775,-10619,-15567,2181,-23178,-9767,12231,-27061,31164,-31002,4272,-6979,-6043,22085,-5660,25131,30435,30790,-10191,-31342,-18682,-8013,-31567,-29436,-4799,8014,26002,-6493,25556,21825,-23257,-31251,-23613,-16480,16047,26892,17697,-5826,-26970,7179,20865,-27749,10149,21169,25121,3933,16121,15038,-5548,24195,17845,26561,17686,17717,-13885,17083,-31539,-9820,-16445,17693,-16470,22444,5735,253,22998,2436,-14814,-14325,-26799,-24691,21883,-29685,-28330,17301,-24912,4823,17906,26884,-13501,10389,-18414,11500,-26454,16340,811,29068,24231,-24754,-12474,19952,-14865,-12949,-8810,29836,-28406,-2660,16733,27199,-20842,-15133,-3439,15869,2202,4104,-23047,-2968,9648,29256,21107,11128,-25217,-25868,-20256,-7551,-9966,-29867,-1840,-12563,6965,11068,18665,-21053,-1848,15256,16916,8189,-31225,273,-19654,-28182,19061,4549,32254,-22083,-16245,-9176,-17098,26010,3826,-2783,-1044,-7754,8580,-11560,31492,16053,-21691,2084,-26267,-24156,-26493,-21877,31334,-31383,-31148,29474,-17683,-18119,-30826,14610,11061,-14562,-23030,18039,26358,19152,26890,1159,-12333,-1776,-15680,15858,-20943,159,3122,-6330,20762,20621,-31796,-4650,11606,4828,-5483,-15273,-32268,11906,10378,13068,9629,6352,-22829,-5100,27612,5269,2215,-2036,7363,569,-4532,-2209,19997,19853,14589,19494,-5098,-25506,18512,25965,22393,-27424,10186,-3611,12043,-31422,5535,-26323,-9359,754,19937,9912,-6001,23910,22965,-22980,-3799,-32610,-9960,8969,25944,-18392,28308,-27480,-21093,-12807,-7043,-3728,-25582,26520,25571,3580,-14430,11304,-32203,13481,18427,12433,172,7588,26993,-24001,17268,2436,-20242,16623,-22507,-1320,9594,-10393,26978,24721,-1635,-1647,-1293,30969,-27877,-30244,31901,2883,-10321,-27583,-26098,32321,13325,-28793,29785,16493,2614,23911,20818,3781,-9742,-8199,10625,11088,14007,8709,7030,11165,-8320,-10580,10180,-29596,-13441,-3006,17146,-1298,2180,-29290,15988,-27821,-26105,1901,-31784,-17170,-18668,25131,7033,-31557,-15618,30552,3236,3639,3758,-31279,-2248,-20140,794,-14710,17694,-22484,6595,25280,-2088,7782,11299,23166,-27890,17422,20774,1652,-19793,25487,9383,979,-21314,-7754,-24086,15152,-14865,14307,-17941,21133,-31887,-6917,-24826,-23414,1220,19285,-24438,-21750,-32767,31360,-29219,20658,-31103,26806,-13451,7661,-14204,16615,27288,25800,16674,30247,11978,27653,8152,2357,-2299,5421,-19942,-15128,14385,30783,30851,7979,18126,30361,12454,-30003,-29844,-2149,28935,-29079,-11570,-302,-9356,15453,-13846,-11492,11104,-1040,-25218,19957,31618,14561,-18747,-15064,31125,-21391,24476,14984,10190,-10561,13864,-12828,29496,14349,-2617,-24871,-168,-25046,4032,-4941,1897,134,14519,-26267,30059,24962,1364,25518,29574,14754,19708,-31714,14876,16090,21039,27400,-32033,17858,-29346,-16744,27542,-22100,470,6991,25501,4857,-21612,29305,-30795,-31498,24342,5054,-16054,11264,-26893,20685,-865,31722,-28619,-12859,-14534,20997,12614,-16075,5276,28926,3914,15065,15849,-8614,-27602,23956,-18281,19865,31937,-3481,29382,21330,-7317,16232,-9663,-20562,-16218,-28023,-26401,7227,25197,-25366,5960,19633,-3592,-16357,-26288,6069,12140,30619,-17150,30444,-27726,-32100,-32391,-3406,-5358,24219,9765,-18607,-7312,8501,21046,22372,-26760,-30015,6745,-560,-10211,-4767,-8456,-31344,-11404,-6959,13790,-8940,25535,16318,25687,-24942,-7893,-9902,15428,8109,-22565,-22391,20311,26957,-4952,-12225,-15272,15729,1009,-30195,-16202,-6963,2403,-22963,-12551,-15030,27682,-23139,28821,16606,-548,-2785,-25342,-16738,-1791,-10551,31704,19080,8234,30399,9495,24634,-32098,-18747,1587,7664},
  {28652,10983,-23772,7523,11260,-9985,11658,-1470,-29258,11018,-19655,-23605,-18699,-26547,20026,17562,-30681,19402,-14367,28093,-13042,-23129,4955,18460,-29611,27431,-21536,7301,-16883,-8465,2903,-24650,26281,-11664,4534,-8124,31120,28006,12259,-15067,-26263,10250,-14163,6150,19774,10842,28589,4595,15004,-21229,22677,-1529,-4859,7730,-12486,-9762,-10276,25423,4763,24181,-4014,-24522,-31558,20564,22969,31193,9593,29003,-28382,13827,24270,9726,30888,-29774,664,-7922,15540,14411,29600,-28801,32442,-9569,30628,29823,-29657,-27429,27990,-28279,505,-18043,-21003,-25506,-20870,24543,17440,-31126,-13645,11555,-21280,-20319,-10908,-32050,-10048,21823,-21332,-24610,7427,-17991,10003,-4936,29182,7912,-21441,-6153,2451,7642,28001,-4416,16467,19573,6513,-9970,12455,20293,12039,-13398,-26998,-21371,-16264,-18394,21080,-8296,-3989,-4873,-13263,-25812,13825,9196,-14246,-6154,5942,-2487,6486,-28607,19648,18681,5526,-5128,-32011,-23586,28397,12216,30669,-20609,-2851,26080,-23214,-7580,10063,-29694,21035,-13696,31148,13300,3588,25755,8582,10608,20861,14890,-28767,5809,-20103,-4286,-174,3141,11671,-23115,-19380,-32666,-13870,-30550,-16386,5861,26437,25292,-15172,-21323,-2412,-20098,13531,-8250,685,4081,-2196,19844,-4743,-28819,30765,-1679,30434,-31105,2019,-30049,473,20060,18204,15042,15974,-5280,-7824,17435,14775,-30634,468,-23646,28465,12942,19629,-25697,-5101,-10014,903,7244,-18938,-31962,-4852,19654,24086,-24264,-29065,-11908,-15987,-16732,-21201,-13757,17274,1602,-24000,32382,16180,-23397,29511,3440,17594,-3071,-15796,30072,-30061,-15748,17589,12442,7312,-160,-11151,8603,-11027,26751,-19562,5606,8384,-22515,-2600,-5468,-4700,25068,-31307,-29433,24769,8981,23804,-9887,12543,-26123,4749,22224,31043,17354,8172,-12964,-19697,-6411,-2828,-19547,3553,11434,-32342,24075,26480,7344,11883,29105,-28433,15696,13071,4644,13807,-20423,-26602,-7632,6425,22887,-23559,-12043,-8462,-7613,-32217,24442,24833,-21058,22779,19360,1758,-123,-10021,8289,-24860,-22034,14574,22967,7918,26886,-2488,-20362,-2453,-8772,23394,11941,-19043,11917,26365,18293,-10798,3844,-20788,-6502,4402,1669,4200,-4607,31360,-20746,22578,18548,11318,9707,3407,31351,28083,-24334,28277,5132,31844,-9766,24447,-1847,-14844,15707,31766,-25835,31201,257,-4331,-6659,3372,-11187,31403,27911,-12709,32366,30245,978,-3346,26767,15698,29966,-7736,4807,-4683,16103,23309,14699,1825,-7841,-1104,-31971,-20560,-21649,11550,2230,30093,1997,26201,-25747,18155,29630,11450,26611,2543,16800,-23218,-2791,32421,-6137,23978,23298,29652,28871,30158,-25774,-24926,29499,-21498,25033,-11058,-4965,10092,20786,-6986,25213,-20370,11698,-31841,-21556,-17956,-6625,-16573,6987,-11637,-31329,5383,2163,-32653,6950,2575,16286,31010,-13719,31498,-26927,6723,-21397,-3927,-31734,22376,18377,29075,-27945,-8480,-21721,-13739,-6727,24751,-8139,8592,-619,-14468,15366,27942,-32721,-2649,19252,3623,17086,13608,32290,19871,-281,15448,-32673,26554,-3783,-29859,-825,13264,9707,29907,-28398,9884,13097,-5763,30632,10370,22091,-17829,-9382,31591,4216,25769,-6344,17048,28603,15679,-9149,19056,20052,350,-25237,-3480,16633,-9800,12744,-16198,32633,-1528,-6898,18864,11139,-30178,-2027,-10313,2542,13572,4537,20118,18110,13085,22219,-30961,3638,-12192,-14289,-6061,30882,-25632,-29025,-15439,-15616,-15928,26676,31280,-8344,21856,-12796,8753,5106,-24544,14522,-30083,24834,-3500,28454,10216,12440,-32638,14533,951,17319,-30702,26612,-11878,-2102,-13434,-18490,-20530,20637,6367,29356,-18581,20255,31512,-6647,1283,9096,14084,-2296,21663,24113,-30927,28154,26112,-25303,15999,-27750,31077,5061,-9642,-20150,11373,9176,18193,-18128,-18567,-3611,24470,-30455,-4812,14738,8532,-25532,24054,15534,-2444,10090,22323,-20444,17964,-6745,-25555,3870,2841,-24336,-31509,27484,18914,-31039,19226,18174,-11082,-12611,7570,5705,-19977,3972,9699,-9810,-16478,20520,-14372,-7793,28090,-2168,1913,-22323,-11894,-26879,-20437,-18051,-9900,9735,-27706,6163,-9206,-13949,-24308,-2083,-19542,-15099,17989,-23402,29971,9104,-1418,26558,7134,-6959,23326,1899,6408,-4302,-26349,-7693,-15940},
  {-11677,9646,-15556,19061,29834,11527,22266,15075,105,18715,-10499,-8073,15143,-4101,-20287,-15648,-29081,93,5126,-11347,-11060,17002,-10973,15019,-21936,17634,-29202,-8678,29721,18786,16356,-25057,13217,-14203,11360,-21679,7240,-8241,24959,25,2588,9897,2466,-14341,21358,-29122,549,-32454,-15908,7587,13569,-31739,25540,5606,10976,-8731,21055,-15206,3142,-31324,-31422,-21502,-1507,22971,-6055,-26518,-29928,18486,-20087,18641,-16934,-30077,-11249,2592,-22899,-1861,-17840,-7905,27685,22638,22893,18912,-9448,1621,-12335,-8120,27252,-19823,25312,2851,20879,-31825,7588,-1695,17579,30956,18420,-10855,18056,914,-24836,-18585,31901,2581,-23159,10572,32317,-32375,6469,12220,-12353,-11644,26657,-28741,24458,29596,-12888,-1835,26483,-27624,27904,-8623,12526,-21671,6933,-10723,4120,-6087,5751,-25740,8128,-10663,-19900,-1907,-12026,15130,-28113,11109,-31014,-17942,-29936,-20287,28903,-29600,26894,11977,-22776,-26870,-26357,-24952,-12473,11746,-8455,9248,-26940,13168,-30261,19531,31948,-4616,-25303,-19915,20302,17447,-24514,-19968,-26837,19169,7437,12717,-23815,13996,7933,7785,26415,4932,-4765,30203,5616,-29338,17781,3372,-125,19475,9822,-787,-12204,-6951,7644,-9316,-29362,-972,-2479,20511,13757,-25836,-4670,8586,5082,2480,171,-10931,-1039,-27839,-30068,8197,28581,-15014,-333,371,-6514,10043,9558,6171,32558,7144,17056,11049,8121,-8446,-4254,-22406,-15530,29729,7441,18695,-6418,-6290,13561,30760,-20989,-16421,8093,-15702,15565,-14504,25534,-15237,26051,3431,-17215,-15388,6662,20320,-14777,-12052,-1153,5133,17286,7568,28191,-10888,3954,-11133,10919,22506,-13357,-11331,13832,-10886,4103,31712,-24924,10913,-10647,5401,-18429,-24180,28491,-24102,-23715,-9389,-3914,5985,-154,20165,10373,18055,8776,-17713,-1016,-21374,-14639,18299,935,-25902,-17677,-12985,-17329,-24128,-19333,10878,15897,-29388,20340,-4380,23935,11662,4102,22891,8791,9306,-31401,-15341,-17085,10219,1636,4349,18424,-16492,7319,-19439,-29739,13136,3285,-6650,-5719,-22611,15900,13528,-2746,6947,-11621,-7959,7111,-12603,-12900,32408,-1771,22443,24410,9093,31183,27903,-9319,-28820,20463,-28380,617,6221,-26014,-23651,26348,-15994,25099,25243,20017,-8125,19719,26873,2044,15298,-8349,16890,1359,13497,3364,-1497,-13286,-26396,-16276,6025,17001,19655,18902,-2035,2485,31843,19257,-5768,17649,-13812,11995,32643,-31977,-17618,-20010,-25999,-27114,30473,-13487,29959,-7460,12639,-19173,21584,2222,23559,-2299,29569,26080,31099,-5498,-19289,10816,31287,-22429,4290,9045,1595,6405,-24697,-3620,-19252,-2502,-30971,-2535,-11849,31558,28260,31896,19697,-13643,-166,16228,-21312,-21576,24651,-5653,23383,-13605,-29098,-2312,-10762,7944,6641,16309,27264,9099,17116,-6551,-25323,-7859,5456,31136,-23442,-21991,4140,-7738,-32017,-6874,-18872,20100,7999,-6385,31151,-25861,27888,-32272,-3986,30388,-22956,-16256,16921,-24150,2579,14417,32149,-1860,-30324,-3694,-20680,-31737,9291,18235,20051,5168,-18376,19261,25323,13343,-16831,-22332,3828,-22541,-19627,12063,4750,6264,-18093,-5290,32698,11908,2597,-28916,25843,7321,14521,-26307,14495,-26494,27472,13912,-11744,-5560,-6660,-22931,-6516,8810,-14769,-23884,3693,12587,26523,5009,18493,-19171,20714,17282,-18583,22748,29271,-32642,8203,31553,-23549,21954,13296,-20345,7803,-16553,-20227,14874,3812,28668,23275,-3972,-26674,29418,-14149,19212,-4079,15842,20183,-31492,-13814,-31620,11585,-28407,-7072,-25802,22295,871,-8644,5620,11459,-2013,-6390,-2691,-29453,14980,-4163,15948,24535,-12367,-12848,-22428,28138,-24789,11019,1995,6331,2235,13219,13760,-1568,11412,25835,-17133,-15364,-23227,16581,-32755,-283,2962,-11164,30520,12077,-6568,-27333,29704,17066,-26370,6648,-17507,-23154,-5909,6381,-31454,30556,-30826,32517,8955,18760,17551,12359,12390,1853,-7866,-22067,-10928,13135,5758,27712,13226,-28717,-31282,-13487,-28334,-5056,-20270,9192,-1444,20084,24830,769,-12167,-5674,29673,18390,32006,-4850,-4561,11608,-23624,17105,-22745,30784,-16901,-14193,25559,13880,22930,29337,-7079,30887,-4021,7020,19062,3470,-26310,12780,11972,12524,9003,-16498,19399,-12253,-25153,-3737,23096,-9425,5300},
  {-24503,-6370,-3576,-16067,-7378,-12503,13860,14193,-29945,-23611,-32261,9777,-12357,381,21724,29764,-8989,4238,-15622,19055,30571,19502,380,10050,-13703,12649,19433,-5418,-20137,2436,-23191,-29873,-6507,21367,-7568,-3670,-24299,-3874,-1494,11241,3522,20071,17177,5171,-25711,-7606,-28800,-7035,18895,557,-13841,19537,-5276,-17726,5110,10704,-14403,-14278,720,-30155,27108,11079,-22975,-5827,-7355,1590,-2640,-23153,21063,19673,-16786,20142,-10237,-15626,-27122,21786,16350,25211,19535,-23189,-25812,-1792,-4713,-744,13016,-6230,12755,-21628,8840,-26119,-3193,-27165,8703,-19442,-27498,21419,-4654,-23063,-108,-30716,-18638,4132,6276,14197,-14599,-32379,-4083,32117,-29221,14215,1049,-8651,-9140,27155,1033,-16068,31774,-3040,20027,18775,-21938,-13259,20900,24385,8543,-32368,19413,24378,10992,12196,-9443,-28138,-9183,7758,32190,17777,18549,-31775,-423,8927,-27749,27906,17955,-24197,-15679,25586,-11275,-30954,8206,-11561,-15018,16660,29517,34,18440,-17584,28709,18536,-9315,-19762,11797,-8851,-17907,-15161,-30397,30242,-21587,1217,17890,2933,14268,-18086,9737,24598,11308,-25931,-11159,-29700,-17075,-21524,-4975,16440,-19003,-16254,10483,-1385,15354,21441,-25440,1629,-21513,31578,-13582,7262,26344,-29680,-20651,7750,6264,14872,15808,-14107,31831,-28350,27034,-25820,10816,-29618,10490,5309,-22268,20816,-28126,-14606,-23715,18403,19488,-13319,-21071,-15561,29301,-18058,-18595,-29372,27977,3990,-28813,10484,-4730,21698,-11796,30145,26552,-11105,-5817,-26165,-10993,-18437,22421,17099,29969,32348,-26912,-24897,-21714,-22851,-13889,-10187,10243,2099,6573,11941,-9307,-23522,-1888,-15064,19696,14725,14159,-11658,-14679,-29085,-29716,20630,-12460,-3062,19478,-30031,-28549,-27347,-13832,11939,18800,-14362,6309,-18010,-15870,-23252,27052,-31680,12637,-9663,-14045,-15848,-30838,-8325,123,6952,-19998,-11072,-14396,-23234,-32550,6399,13557,-25868,-17640,29756,-14395,-11151,2040,27456,27889,10984,-2156,-9297,-114,30423,15243,13682,1554,-29734,25538,23615,-15723,2781,5078,4141,-18096,-25644,-9643,-3691,-19038,1897,27650,27291,24247,30350,17201,-10308,23107,4261,5763,-9319,4027,-83,-29954,8530,21041,-30021,-12004,-19620,-31697,-12856,12564,13214,18101,-21325,-13573,-7792,-13416,-29027,8255,26938,6581,-24820,669,32232,-19222,-18341,-20680,28439,-27826,-12114,18799,-2742,15879,8110,-20623,-6150,-2197,18417,-30858,-15623,-27688,14852,-21680,-5629,9459,-12046,-20911,15220,6597,11249,21035,14617,-22673,8190,-20579,5352,363,13414,21287,-3429,16485,-17489,17505,18262,17268,-4041,-3750,-1487,26581,29776,-26322,-19741,-15870,-25679,18990,-6036,-12644,-24940,30604,196,-19452,23143,19818,30949,-20443,-13970,5420,13707,-32125,3386,-11301,-228,12754,31222,10062,31816,-10056,30276,-2113,-6743,-31882,5777,11429,-21722,32053,-7650,-180,-16911,28572,12898,22828,-8711,18217,9694,-10202,29079,-15568,4114,-979,16332,-2267,-1494,4048,23636,4409,-2,12284,8689,-27967,-26185,-6105,21666,24420,-20800,22578,-4472,19586,-26760,13100,18243,27695,25728,24369,-28356,20714,14745,1476,1087,-15350,15511,-32630,24355,-4220,628,-8167,-16495,-29080,18900,8710,580,-30678,-4053,10465,9646,27291,30778,-5674,-6531,-30295,22112,17902,-24291,-15172,-3433,13114,-19166,10632,24125,7338,23730,31709,-17256,-17784,-6751,21623,-22262,1953,-17183,29699,-6640,4207,-23218,-20702,-14991,-8859,-18988,5366,-15066,16115,15970,-25277,-5153,8477,4215,-25932,-27086,-14389,18258,20726,6515,8376,14688,-11749,-14478,19178,32020,-12068,-8191,20147,22627,24381,-4565,-24234,-20638,-11352,-11321,24586,23539,25443,-18640,-29202,-28784,14549,9163,-450,32237,19169,-20211,26052,-11217,21595,-29418,-15110,-7738,-22024,-22150,31464,11181,-11062,-6410,13699,-25997,-10724,15425,21964,2002,-21699,-8334,23731,-20498,-6204,-17257,-20178,29352,-3405,-1365,-24850,14891,8421,30984,8350,-5114,5448,22878,4244,-14930,-821,3242,14189,-6599,9445,-1092,-5124,-18384,6643,-5672,7604,22484,-13318,13354,-12428,-9634,15461,8820,9849,10896,-18848,-27880,-3447,-19344,-27604,-18173,24822,-15081,-31188,-15359,5256,-15319,-23914,170,8507,-3592,24403,-11149,80,13243,-2629,-28139,10946},
} ;

static void test_encode_653x4621_impl(long long impl)
{
  unsigned char *s = test_encode_653x4621_s;
  unsigned char *x = test_encode_653x4621_x;
  unsigned char *s2 = test_encode_653x4621_s2;
  unsigned char *x2 = test_encode_653x4621_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_653x4621_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_653x4621(impl);
    printf("encode_653x4621 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_653x4621_implementation(impl),ntruprime_dispatch_encode_653x4621_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_653x4621;
    printf("encode_653x4621 selected implementation %s compiler %s\n",ntruprime_encode_653x4621_implementation(),ntruprime_encode_653x4621_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_653x4621_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_653x4621_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_653x4621_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_653x4621_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_653x4621_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_653x4621_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_653x4621(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"653x4621")) return;
  storage_encode_653x4621_s = callocplus(crypto_encode_STRBYTES);
  test_encode_653x4621_s = aligned(storage_encode_653x4621_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_653x4621_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_653x4621_x = aligned(storage_encode_653x4621_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_653x4621_s2 = callocplus(maxalloc);
  test_encode_653x4621_s2 = aligned(storage_encode_653x4621_s2,crypto_encode_STRBYTES);
  storage_encode_653x4621_x2 = callocplus(maxalloc);
  test_encode_653x4621_x2 = aligned(storage_encode_653x4621_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_653x4621 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_653x4621();++impl)
      forked(test_encode_653x4621_impl,impl);
    ++test_encode_653x4621_s;
    ++test_encode_653x4621_x;
    ++test_encode_653x4621_s2;
    ++test_encode_653x4621_x2;
  }
  free(storage_encode_653x4621_x2);
  free(storage_encode_653x4621_s2);
  free(storage_encode_653x4621_x);
  free(storage_encode_653x4621_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

