/* hashKeyMix.h
 */
#ifndef _HASH_KEY_MIX_H
#define _HASH_KEY_MIX_H
#include "osl/pieceStand.h"
#include <cassert>
namespace osl
{
namespace hash
{
  /**
   * 2つのhashKey(たとえばHashKey32とHashKey64)を保持して，
   * 常に同じ結果(片方で一致して片方で一致しないことがない)であることを
   * assertで確認しながら動くHashKey
   */
  template<typename hash1_t,typename hash2_t>
  class HashKeyMix{
  private:
    hash1_t hash1;
    hash2_t hash2;
    hash1_t const& getHash1() const{ return hash1; }
    hash1_t & getHash1() { return hash1; }
    hash2_t const& getHash2() const{ return hash2; }
    hash2_t & getHash2() { return hash2; }
  public:
    HashKeyMix() :hash1(),hash2(){
    }
    HashKeyMix(unsigned int v0, unsigned int v1, unsigned int v2,
	    unsigned int v3, unsigned int v4, unsigned int v5) 
      : hash1(v0,v1,v2,v3,v4,v5),hash2(v0,v1,v2,v3,v4,v5){
    }
  public:
    bool isSameBoard(const HashKeyMix& key) const{
      if(hash1.isSameBoard(key.getHash1())){
	assert(hash2.isSameBoard(key.getHash2()));
	return true;
      }
      assert(!hash2.isSameBoard(key.getHash2()));
      return false;
    }
    HashKeyMix& operator+=(const HashKeyMix& r){
      hash1+=r.getHash1();
      hash2+=r.getHash2();
      return *this;
    }
    HashKeyMix& operator-=(const HashKeyMix& r){
      hash1-=r.getHash1();
      hash2-=r.getHash2();
      return *this;
    }
    PieceStand blackStand() const { 
      PieceStand ret=hash1.blackStand();
      assert(ret==hash2.blackStand());
      return ret;
    }
    void changeTurn() {
      hash1.changeTurn();
      hash2.changeTurn();
    }
    void setPlayer(Player p){
      hash1.setPlayer(p);
      hash2.setPlayer(p);
    }
    bool isPlayerOfTurn(Player p) const{
      bool ret=hash1.isPlayerOfTurn(p);
      assert(ret==hash2.isPlayerOfTurn(p));
      return ret;
    }
    size_t size() const
    {
      return std::max(hash1.size(),hash2.size());
    }
    size_t value(unsigned int i) const 
    {
      assert(i<size());
      return (hash1.size() > hash2.size()) ? hash1.value(i) : hash2.value(i);
    }
    void setRandom(){
      hash1.setRandom();
      hash2.setRandom();
    }
    friend bool operator==(HashKeyMix const& l, HashKeyMix const& r){
      bool ret=(l.getHash1()==r.getHash1());
      assert(ret==(l.getHash2()==r.getHash2()));
      return ret;
    }
    /**
     * ここの順序はset等に入れるためだけに使うので，完全に一致する必要はない
     */
    friend bool operator<(HashKeyMix const& l, HashKeyMix const& r){
      bool ret=(l.getHash1()<r.getHash1());
      if(ret){
	assert(l.getHash2()<r.getHash2() ||
	       r.getHash2()<l.getHash2());
      }
      return ret;
    }
    friend bool operator!=(const HashKeyMix& h1,const HashKeyMix& h2){
      return !(h1==h2);
    }
  };
} // namespace hash
} // namespace osl
#endif /* _HASH_KEY_MIX_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
