/* real_time.cc
 */
#include "osl/misc/milliSeconds.h"
#ifdef _WIN32
#  include <sys/timeb.h>
#else
#  include <sys/time.h>
#endif
const osl::misc::MilliSeconds osl::misc::MilliSeconds::now()
{
#ifdef _WIN32
  struct _timeb now;
  _ftime(&now); // mingw does not support _ftime_s
  return MilliSeconds((int64_t)now.time*1000 + now.millitm);
#else
  timeval now;
  gettimeofday(&now, 0);
  return MilliSeconds((int64_t)now.tv_sec*1000 + now.tv_usec/1000);
#endif
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
